
      subroutine gpghei(imat,ipart,ppart,shadi)
      implicit none
c       imat: input. matter index
c      ipart: input. particle index
c      ppart: input. |p|
c      shadi: output. mean free path in  g/cm2;
c       
c   **  gfmate needs  density; cosmos give 1.0 to get
c      shadi in g/cm2

      integer *4 mixmax
      parameter (mixmax=10)
c
c *** compute distance to next hadronic interaction point ***
c
      integer *4 imat,ipart
      real *4 ppart !total momentum of input particle
      real *4 energy,kinetic
      real *4 shadi !distance to hadronic interaction
c      real *4 a,z,dens,radl,absl,dum,rando,sigma,ghesig;  below by  k.k
      real *4 a,z,dens,radl,absl,dum,sigma,ghesig
      integer *4 nmix,imix(mixmax)
      real *4 wmix(mixmax),amix(mixmax),zmix(mixmax)
      integer *4 ndum,idum(mixmax),i
      character *20 namemat,namepar
      integer *4 itrtyp
      real *4 mass,charge,tlife
      real *4 qcor
      save qcor
      data qcor/0.0/
c      integer *4 ipart_old/0/
c      integer *4 imat_old/0/
c      logical dow
c
c      if(ipart.eq.ipart_old.and.imat.eq.imat_old) then
c       dow=.false.
c      else
c       dow=.true.
c       imat_old=imat
c       ipart_old=ipart
c      endif !imat...
c
c do kinematics
      call gfpart(ipart,namepar,itrtyp,mass,charge,tlife)
c      if(dow) write(6,*) 'ipart=',ipart,'name=',namepar
c      if(dow) write(5,*) 'ipart=',ipart,'name=',namepar
      energy=sqrt(ppart**2+mass**2)
      kinetic=energy-mass
c
c do material
      nmix=mixmax !tell gfmate how much room we have
      call gfmate(imat,namemat,a,z,dens,radl,absl,nmix,imix,wmix)
c      if(dow) write(6,*) 'imat=',imat,'name=',namemat
c      if(dow) write(5,*) 'imat=',imat,'name=',namemat
c
c calc step
      if(z.lt.1.0) then
       shadi=1.0e+30
       return
      else if(nmix.eq.1) then
       sigma=ghesig(ppart,kinetic,a,a,z,1.0,1,dens,0.0,ipart)
      else
       do 1000 i=1,nmix
        ndum=mixmax
        call gfmate
     x  (imix(i),namemat,amix(i),zmix(i),dum,dum,dum,ndum,idum,dum)
1000   continue
       sigma=ghesig(ppart,kinetic,a,amix,zmix,wmix,nmix,dens,qcor,ipart)
      endif !z.lt.1.0
      if(sigma.le.0.0) then
       shadi=1.0e+30
       return
      endif !sigma.le.0.0
c     shadi=-log(rando(dum))/sigma
c  gismo wants interaction length ... not dist. to interact
      shadi = 1./sigma
      return
      end
      real function ghesig(ppart,ekin,aver,a,z,w,kk,dens,qcor,lpart)
      implicit none
c
c *** calculation of the probabilities for (in)elastic interactions ***
c *** of stable particles on proton and neutron                     ***
c *** nve 07-apr-1988 ***
c
c called by : gpghei
c origin : f.carminati, h.fesefeldt (routine intact 06-oct-1987)
c
c *** ipart denotes the gheisha particle index ***
c
c convention :
c
c   particle                 ipart
c   ------------------------------
c   gamma                    1
c   neutrino                 2
c   positron                 3
c   electron                 4
c   muon +                   5
c   muon -                   6
c   pion +                   7
c   pion 0                   8
c   pion -                   9
c   kaon +                  10
c   kaon 0 s                11
c   kaon 0 l                12
c   kaon -                  13
c   proton                  14
c   proton bar              15
c   neutron                 16
c   neutron bar             17
c   lambda                  18
c   lambda bar              19
c   sigma +                 20
c   sigma 0                 21
c   sigma -                 22
c   sigma + bar             23
c   sigma 0 bar             24
c   sigma - bar             25
c   xsi 0                   26
c   xsi -                   27
c   xsi 0 bar               28
c   xsi - bar               29
c   deuteron                30
c   triton                  31
c   alpha                   32
c   omega -                 33
c   omega - bar             34
c   new particles           35
c
c *** for cross-section information see "pcsdata" ***
c
      common/gsecti/ aiel(20),aiin(20),aifi(20),aica(20),alam,k0flag
      integer k0flag
      real aiel,aiin,aifi,aica,alam
      real rca,dx,dy,p,ppart,ek,ekin,ekx,rce,b,apart,alph,corfac
      real rc,crin,crel,wgch,xsecel,xsecin,aitot,aver,acc40
      real acca,accb,afact,dens,qcor,z43ba,corh,acc
      integer lpart,j,i,je1,ja1,izno,fail,k,kk,je2,ja2
      integer *4 ipart,ipart3
c
c
c
      real a(kk),z(kk),w(kk)
c
      real alpha(35),alphac(41),ipart2(7),csa(4)
      real partel(35),partin(35)
      save alpha, alphac, ipart2, csa, partel, partin
c
c --- dimension statements for cross section data ---
      real  plab(41),csel(35,41),csin(35,41),cspiel(3,41),
     $          cspiin(3,41),cspnel(3,41),cspnin(3,41),
     $          elab(17),cnlwat(15),cnlwel(15,17),cnlwin(15,17),
     $          cscap(100),ekfiss(21),csfiss(4,21)
      save plab, csel, csin, cspiel, cspiin, cspnel, cspnin
      save elab, cnlwat, cnlwel, cnlwin, cscap, ekfiss, csfiss
c
c --- dimension stmts. for geant/gheisha particle code conversions ---
c --- kipart(i)=gheisha code corresponding to geant   code i ---
c --- ikpart(i)=geant   code corresponding to gheisha code i ---
c
      integer kipart(48),ikpart(35)
      save kipart, ikpart
c
c --- cross-section data by "pcsdat" 01-feb-1989 ---
c
      data plab /
     $  0.00000e+00, 0.10000    , 0.15000    , 0.20000    , 0.25000    ,
     $  0.30000    , 0.35000    , 0.40000    , 0.45000    , 0.50000    ,
     $  0.55000    , 0.60000    , 0.65000    , 0.70000    , 0.75000    ,
     $  0.80000    , 0.85000    , 0.90000    , 0.95000    ,  1.0000    ,
     $   1.1000    ,  1.2000    ,  1.3000    ,  1.4000    ,  1.5000    ,
     $   1.6000    ,  1.8000    ,  2.0000    ,  2.2000    ,  2.4000    ,
     $   2.6000    ,  2.8000    ,  3.0000    ,  4.0000    ,  5.0000    ,
     $   6.0000    ,  8.0000    ,  10.000    ,  20.000    ,  100.00    ,
     $   1000.0    /
      data (csel( 1,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel( 2,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel( 3,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel( 4,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel( 5,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel( 6,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel( 7,j),j=1,41) /
     $  0.00000e+00,  6.0000    ,  20.000    ,  71.000    ,  155.00    ,
     $   195.00    ,  130.00    ,  78.000    ,  60.000    ,  32.000    ,
     $   23.500    ,  18.500    ,  15.000    ,  12.500    ,  10.000    ,
     $   9.1000    ,  8.6000    ,  8.8000    ,  9.5000    ,  10.600    ,
     $   13.000    ,  15.500    ,  17.100    ,  17.200    ,  16.200    ,
     $   15.000    ,  12.300    ,  10.200    ,  9.0000    ,  8.0000    ,
     $   7.3000    ,  6.8000    ,  6.5000    ,  5.8000    ,  5.4000    ,
     $   5.2000    ,  5.0000    ,  4.9000    ,  3.8000    ,  3.2000    ,
     $   3.5000    /
      data (csel( 8,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel( 9,j),j=1,41) /
     $  0.00000e+00,  1.0000    ,  3.0000    ,  8.0000    ,  18.000    ,
     $   25.000    ,  27.500    ,  12.300    ,  10.600    ,  11.000    ,
     $   12.500    ,  14.500    ,  17.000    ,  19.400    ,  19.800    ,
     $   16.800    ,  14.000    ,  14.800    ,  20.000    ,  26.100    ,
     $   19.500    ,  15.000    ,  12.800    ,  11.500    ,  10.500    ,
     $   9.8000    ,  8.8000    ,  8.2000    ,  7.8000    ,  7.5000    ,
     $   7.2000    ,  7.0000    ,  6.8000    ,  6.1000    ,  5.7000    ,
     $   5.4000    ,  4.9000    ,  4.6000    ,  4.0000    ,  3.3000    ,
     $   3.5000    /
      data (csel(10,j),j=1,41) /
     $   10.000    ,  11.200    ,  11.300    ,  11.400    ,  11.500    ,
     $   11.600    ,  11.800    ,  12.000    ,  12.100    ,  12.200    ,
     $   12.300    ,  12.400    ,  12.500    ,  12.500    ,  12.500    ,
     $   12.400    ,  12.300    ,  12.200    ,  12.000    ,  11.800    ,
     $   11.200    ,  11.500    ,  9.9000    ,  9.4000    ,  8.8000    ,
     $   8.4000    ,  7.5000    ,  6.9000    ,  6.3000    ,  5.9000    ,
     $   5.5000    ,  5.2000    ,  5.0000    ,  4.0000    ,  3.5000    ,
     $   3.3000    ,  3.1000    ,  3.1000    ,  3.0000    ,  2.5000    ,
     $   3.0000    /
      data (csel(11,j),j=1,41) /
     $   10.000    ,  11.200    ,  11.300    ,  11.400    ,  11.500    ,
     $   11.600    ,  11.800    ,  12.000    ,  12.100    ,  12.200    ,
     $   12.300    ,  12.400    ,  12.500    ,  12.500    ,  12.500    ,
     $   12.400    ,  12.300    ,  12.200    ,  12.000    ,  11.800    ,
     $   11.200    ,  11.500    ,  9.9000    ,  9.4000    ,  8.8000    ,
     $   8.4000    ,  7.5000    ,  6.9000    ,  6.3000    ,  5.9000    ,
     $   5.5000    ,  5.2000    ,  5.0000    ,  4.0000    ,  3.5000    ,
     $   3.3000    ,  3.1000    ,  3.1000    ,  3.0000    ,  2.5000    ,
     $   3.0000    /
      data (csel(12,j),j=1,41) /
     $   160.83    ,  82.800    ,  58.575    ,  43.683    ,  34.792    ,
     $   28.650    ,  24.367    ,  20.917    ,  18.192    ,  16.300    ,
     $   14.608    ,  13.017    ,  12.250    ,  11.700    ,  12.017    ,
     $   14.075    ,  15.842    ,  16.433    ,  16.042    ,  15.008    ,
     $   12.575    ,  10.708    ,  9.2000    ,  8.0167    ,  7.2833    ,
     $   7.0750    ,  6.6333    ,  6.1250    ,  5.6583    ,  5.2750    ,
     $   4.9333    ,  4.6250    ,  4.4583    ,  3.7333    ,  3.3833    ,
     $   3.1833    ,  2.9833    ,  2.7500    ,  2.3667    ,  2.2000    ,
     $   2.6000    /
      data (csel(13,j),j=1,41) /
     $   300.00    ,  140.00    ,  97.000    ,  70.000    ,  55.000    ,
     $   45.000    ,  37.000    ,  31.000    ,  26.000    ,  23.000    ,
     $   20.000    ,  17.000    ,  15.500    ,  14.500    ,  14.700    ,
     $   18.500    ,  22.000    ,  23.000    ,  22.500    ,  20.700    ,
     $   16.500    ,  14.000    ,  11.500    ,  9.6000    ,  8.6000    ,
     $   8.5000    ,  8.3000    ,  7.6000    ,  7.0000    ,  6.4000    ,
     $   5.9000    ,  5.5000    ,  5.3000    ,  4.4000    ,  4.1000    ,
     $   3.9000    ,  3.7000    ,  3.3000    ,  2.6000    ,  2.5000    ,
     $   3.0000    /
      data (csel(14,j),j=1,41) /
     $   1100.0    ,  115.00    ,  105.00    ,  100.00    ,  56.000    ,
     $   40.000    ,  27.000    ,  22.000    ,  21.000    ,  20.000    ,
     $   20.000    ,  20.000    ,  20.500    ,  21.000    ,  22.000    ,
     $   23.000    ,  24.000    ,  24.000    ,  24.400    ,  24.500    ,
     $   25.000    ,  25.500    ,  26.000    ,  26.500    ,  27.000    ,
     $   27.000    ,  26.000    ,  23.000    ,  21.500    ,  20.000    ,
     $   19.000    ,  18.000    ,  17.000    ,  13.000    ,  11.500    ,
     $   10.300    ,  9.4000    ,  9.0000    ,  8.8000    ,  7.0000    ,
     $   7.5000    /
      data (csel(15,j),j=1,41) /
     $   200.00    ,  163.00    ,  141.00    ,  120.00    ,  111.00    ,
     $   99.500    ,  92.500    ,  86.500    ,  82.000    ,  78.000    ,
     $   74.000    ,  71.000    ,  67.500    ,  65.000    ,  62.500    ,
     $   59.700    ,  58.100    ,  56.300    ,  54.700    ,  52.700    ,
     $   50.000    ,  48.400    ,  47.000    ,  46.000    ,  45.200    ,
     $   42.800    ,  39.200    ,  36.300    ,  32.800    ,  30.400    ,
     $   28.100    ,  26.300    ,  24.500    ,  19.250    ,  16.840    ,
     $   14.600    ,  12.340    ,  11.210    ,  8.8500    ,  7.5000    ,
     $   7.5000    /
      data (csel(16,j),j=1,41) /
     $   4200.0    ,  440.00    ,  420.00    ,  400.00    ,  230.00    ,
     $   160.00    ,  105.00    ,  80.000    ,  62.000    ,  50.000    ,
     $   45.000    ,  41.000    ,  38.000    ,  36.000    ,  35.000    ,
     $   34.000    ,  33.000    ,  32.000    ,  31.500    ,  31.000    ,
     $   30.500    ,  30.000    ,  29.500    ,  29.000    ,  28.500    ,
     $   28.000    ,  26.000    ,  23.000    ,  21.500    ,  20.000    ,
     $   19.000    ,  18.000    ,  17.000    ,  13.000    ,  11.500    ,
     $   10.300    ,  9.4000    ,  9.0000    ,  8.8000    ,  7.0000    ,
     $   7.5000    /
      data (csel(17,j),j=1,41) /
     $   185.88    ,  133.23    ,  119.37    ,  102.86    ,  93.102    ,
     $   82.752    ,  76.205    ,  71.008    ,  67.366    ,  64.096    ,
     $   60.891    ,  58.501    ,  55.735    ,  53.773    ,  51.839    ,
     $   49.671    ,  48.485    ,  47.045    ,  45.803    ,  44.306    ,
     $   42.623    ,  41.786    ,  41.115    ,  40.630    ,  40.129    ,
     $   38.242    ,  35.233    ,  32.662    ,  29.639    ,  27.573    ,
     $   25.536    ,  23.948    ,  22.356    ,  17.723    ,  15.614    ,
     $   13.653    ,  11.675    ,  10.653    ,  8.6198    ,  7.4464    ,
     $   7.4821    /
      data (csel(18,j),j=1,41) /
     $   1100.0    ,  115.00    ,  105.00    ,  100.00    ,  56.000    ,
     $   40.000    ,  27.000    ,  22.000    ,  21.000    ,  20.000    ,
     $   20.000    ,  19.067    ,  19.333    ,  19.500    ,  19.833    ,
     $   20.567    ,  21.800    ,  22.900    ,  23.869    ,  23.809    ,
     $   22.161    ,  21.488    ,  19.732    ,  19.433    ,  19.345    ,
     $   19.029    ,  18.121    ,  16.280    ,  15.258    ,  14.280    ,
     $   13.644    ,  12.963    ,  12.316    ,  9.5333    ,  8.4333    ,
     $   7.5728    ,  6.9696    ,  6.7518    ,  6.6175    ,  5.6000    ,
     $   6.1145    /
      data (csel(19,j),j=1,41) /
     $   157.65    ,  73.701    ,  76.096    ,  68.571    ,  57.305    ,
     $   49.257    ,  43.616    ,  40.024    ,  38.098    ,  36.287    ,
     $   34.674    ,  33.105    ,  31.712    ,  30.685    ,  29.613    ,
     $   28.602    ,  28.336    ,  28.075    ,  27.786    ,  27.215    ,
     $   26.380    ,  26.146    ,  25.108    ,  24.783    ,  24.360    ,
     $   23.219    ,  21.431    ,  20.095    ,  18.382    ,  17.267    ,
     $   16.100    ,  15.175    ,  14.271    ,  11.573    ,  10.305    ,
     $   9.1471    ,  8.0149    ,  7.4349    ,  6.2499    ,  5.8928    ,
     $   6.0774    /
      data (csel(20,j),j=1,41) /
     $   1100.0    ,  115.00    ,  105.00    ,  100.00    ,  56.000    ,
     $   40.000    ,  27.000    ,  22.000    ,  21.000    ,  20.000    ,
     $   20.000    ,  19.067    ,  19.333    ,  19.500    ,  19.833    ,
     $   20.567    ,  21.800    ,  22.900    ,  23.869    ,  23.809    ,
     $   22.161    ,  21.488    ,  19.732    ,  19.433    ,  19.345    ,
     $   19.029    ,  18.121    ,  16.280    ,  15.258    ,  14.280    ,
     $   13.644    ,  12.963    ,  12.316    ,  9.5333    ,  8.4333    ,
     $   7.5728    ,  6.9696    ,  6.7518    ,  6.6175    ,  5.6000    ,
     $   6.1145    /
      data (csel(21,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel(22,j),j=1,41) /
     $   1100.0    ,  115.00    ,  105.00    ,  100.00    ,  56.000    ,
     $   40.000    ,  27.000    ,  22.000    ,  21.000    ,  20.000    ,
     $   20.000    ,  19.067    ,  19.333    ,  19.500    ,  19.833    ,
     $   20.567    ,  21.800    ,  22.900    ,  23.869    ,  23.809    ,
     $   22.161    ,  21.488    ,  19.732    ,  19.433    ,  19.345    ,
     $   19.029    ,  18.121    ,  16.280    ,  15.258    ,  14.280    ,
     $   13.644    ,  12.963    ,  12.316    ,  9.5333    ,  8.4333    ,
     $   7.5728    ,  6.9696    ,  6.7518    ,  6.6175    ,  5.6000    ,
     $   6.1145    /
      data (csel(23,j),j=1,41) /
     $   185.88    ,  133.23    ,  119.37    ,  102.86    ,  93.102    ,
     $   82.752    ,  76.205    ,  71.008    ,  67.366    ,  64.096    ,
     $   60.891    ,  58.104    ,  55.241    ,  53.140    ,  50.934    ,
     $   48.660    ,  47.566    ,  46.585    ,  45.581    ,  44.003    ,
     $   41.134    ,  39.374    ,  36.878    ,  35.523    ,  34.503    ,
     $   32.334    ,  29.365    ,  27.370    ,  24.705    ,  22.921    ,
     $   21.229    ,  19.879    ,  18.559    ,  14.625    ,  12.758    ,
     $   11.041    ,  9.3440    ,  8.5484    ,  6.7104    ,  6.0000    ,
     $   6.1131    /
      data (csel(24,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel(25,j),j=1,41) /
     $   157.65    ,  73.701    ,  76.096    ,  68.571    ,  57.305    ,
     $   49.257    ,  43.616    ,  40.024    ,  38.098    ,  36.287    ,
     $   34.674    ,  33.105    ,  31.712    ,  30.685    ,  29.613    ,
     $   28.602    ,  28.336    ,  28.075    ,  27.786    ,  27.215    ,
     $   26.380    ,  26.146    ,  25.108    ,  24.783    ,  24.360    ,
     $   23.219    ,  21.431    ,  20.095    ,  18.382    ,  17.267    ,
     $   16.100    ,  15.175    ,  14.271    ,  11.573    ,  10.305    ,
     $   9.1471    ,  8.0149    ,  7.4349    ,  6.2499    ,  5.8928    ,
     $   6.0774    /
      data (csel(26,j),j=1,41) /
     $   1100.0    ,  115.00    ,  105.00    ,  100.00    ,  56.000    ,
     $   40.000    ,  27.000    ,  22.000    ,  21.000    ,  20.000    ,
     $   20.000    ,  18.133    ,  18.167    ,  18.000    ,  17.667    ,
     $   18.133    ,  19.600    ,  21.800    ,  23.338    ,  23.118    ,
     $   19.323    ,  17.476    ,  13.464    ,  12.367    ,  11.691    ,
     $   11.057    ,  10.242    ,  9.5593    ,  9.0151    ,  8.5591    ,
     $   8.2884    ,  7.9253    ,  7.6311    ,  6.0667    ,  5.3667    ,
     $   4.8456    ,  4.5392    ,  4.5036    ,  4.4351    ,  4.2000    ,
     $   4.7289    /
      data (csel(27,j),j=1,41) /
     $   1100.0    ,  115.00    ,  105.00    ,  100.00    ,  56.000    ,
     $   40.000    ,  27.000    ,  22.000    ,  21.000    ,  20.000    ,
     $   20.000    ,  18.133    ,  18.167    ,  18.000    ,  17.667    ,
     $   18.133    ,  19.600    ,  21.800    ,  23.338    ,  23.118    ,
     $   19.323    ,  17.476    ,  13.464    ,  12.367    ,  11.691    ,
     $   11.057    ,  10.242    ,  9.5593    ,  9.0151    ,  8.5591    ,
     $   8.2884    ,  7.9253    ,  7.6311    ,  6.0667    ,  5.3667    ,
     $   4.8456    ,  4.5392    ,  4.5036    ,  4.4351    ,  4.2000    ,
     $   4.7289    /
      data (csel(28,j),j=1,41) /
     $   157.65    ,  73.701    ,  76.096    ,  68.571    ,  57.305    ,
     $   49.257    ,  43.616    ,  40.024    ,  38.098    ,  36.287    ,
     $   34.674    ,  32.708    ,  31.218    ,  30.052    ,  28.707    ,
     $   27.591    ,  27.417    ,  27.615    ,  27.564    ,  26.913    ,
     $   24.891    ,  23.734    ,  20.871    ,  19.677    ,  18.734    ,
     $   17.311    ,  15.563    ,  14.803    ,  13.448    ,  12.615    ,
     $   11.794    ,  11.106    ,  10.474    ,  8.4745    ,  7.4498    ,
     $   6.5350    ,  5.6835    ,  5.3300    ,  4.3406    ,  4.4464    ,
     $   4.7083    /
      data (csel(29,j),j=1,41) /
     $   143.53    ,  43.935    ,  54.462    ,  51.429    ,  39.407    ,
     $   32.510    ,  27.321    ,  24.532    ,  23.465    ,  22.383    ,
     $   21.566    ,  20.209    ,  19.453    ,  18.825    ,  18.046    ,
     $   17.562    ,  17.802    ,  18.360    ,  18.667    ,  18.519    ,
     $   17.514    ,  17.120    ,  14.985    ,  14.306    ,  13.663    ,
     $   12.753    ,  11.596    ,  11.165    ,  10.287    ,  9.7882    ,
     $   9.2294    ,  8.7539    ,  8.3300    ,  6.9480    ,  6.2234    ,
     $   5.5881    ,  5.0189    ,  4.7733    ,  4.1104    ,  4.3929    ,
     $   4.6905    /
      data (csel(30,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel(31,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel(32,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csel(33,j),j=1,41) /
     $   1100.0    ,  115.00    ,  105.00    ,  100.00    ,  56.000    ,
     $   40.000    ,  27.000    ,  22.000    ,  21.000    ,  20.000    ,
     $   20.000    ,  18.133    ,  18.167    ,  18.000    ,  17.667    ,
     $   18.133    ,  19.600    ,  21.800    ,  23.338    ,  23.118    ,
     $   19.323    ,  17.476    ,  13.464    ,  12.367    ,  11.691    ,
     $   11.057    ,  10.242    ,  9.5593    ,  9.0151    ,  8.5591    ,
     $   8.2884    ,  7.9253    ,  7.6311    ,  6.0667    ,  5.3667    ,
     $   4.8456    ,  4.5392    ,  4.5036    ,  4.4351    ,  4.2000    ,
     $   4.7289    /
      data (csel(34,j),j=1,41) /
     $   143.53    ,  43.935    ,  54.462    ,  51.429    ,  39.407    ,
     $   32.510    ,  27.321    ,  24.532    ,  23.465    ,  22.383    ,
     $   21.566    ,  20.209    ,  19.453    ,  18.825    ,  18.046    ,
     $   17.562    ,  17.802    ,  18.360    ,  18.667    ,  18.519    ,
     $   17.514    ,  17.120    ,  14.985    ,  14.306    ,  13.663    ,
     $   12.753    ,  11.596    ,  11.165    ,  10.287    ,  9.7882    ,
     $   9.2294    ,  8.7539    ,  8.3300    ,  6.9480    ,  6.2234    ,
     $   5.5881    ,  5.0189    ,  4.7733    ,  4.1104    ,  4.3929    ,
     $   4.6905    /
      data (csel(35,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin( 1,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin( 2,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin( 3,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin( 4,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin( 5,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin( 6,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin( 7,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.50000    ,  1.2000    ,  1.7000    ,
     $   2.2500    ,  3.0000    ,  3.6000    ,  4.5000    ,  5.4000    ,
     $   6.3000    ,  8.6000    ,  9.0000    ,  10.000    ,  11.500    ,
     $   14.000    ,  17.000    ,  19.500    ,  22.000    ,  24.000    ,
     $   21.500    ,  18.500    ,  19.000    ,  20.500    ,  22.200    ,
     $   23.000    ,  23.300    ,  23.000    ,  21.000    ,  20.500    ,
     $   20.200    ,  20.100    ,  20.000    ,  20.000    ,  20.000    ,
     $   21.000    /
      data (csin( 8,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin( 9,j),j=1,41) /
     $  0.00000e+00,  3.0000    ,  9.2000    ,  20.500    ,  36.500    ,
     $   45.000    ,  28.000    ,  19.500    ,  15.500    ,  14.200    ,
     $   15.500    ,  17.500    ,  20.000    ,  23.000    ,  26.000    ,
     $   20.000    ,  23.000    ,  26.500    ,  32.000    ,  35.000    ,
     $   28.500    ,  22.000    ,  22.500    ,  23.500    ,  24.000    ,
     $   24.500    ,  26.000    ,  27.500    ,  27.500    ,  27.000    ,
     $   26.500    ,  25.500    ,  25.000    ,  23.000    ,  22.500    ,
     $   22.200    ,  22.000    ,  22.000    ,  21.200    ,  20.700    ,
     $   21.000    /
      data (csin(10,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.50000    ,  1.5000    ,  2.7000    ,  3.8000    ,  4.8000    ,
     $   6.5000    ,  7.6000    ,  8.4000    ,  9.0000    ,  9.4000    ,
     $   9.8000    ,  10.500    ,  11.000    ,  11.500    ,  11.800    ,
     $   12.200    ,  12.400    ,  12.600    ,  13.200    ,  13.500    ,
     $   13.700    ,  14.000    ,  14.200    ,  14.500    ,  16.400    ,
     $   17.000    /
      data (csin(11,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.50000    ,  1.5000    ,  2.7000    ,  3.8000    ,  4.8000    ,
     $   6.5000    ,  7.6000    ,  8.4000    ,  9.0000    ,  9.4000    ,
     $   9.8000    ,  10.500    ,  11.000    ,  11.500    ,  11.800    ,
     $   12.200    ,  12.400    ,  12.600    ,  13.200    ,  13.500    ,
     $   13.700    ,  14.000    ,  14.200    ,  14.500    ,  16.400    ,
     $   17.000    /
      data (csin(12,j),j=1,41) /
     $   266.67    ,  133.33    ,  83.333    ,  57.083    ,  44.500    ,
     $   33.250    ,  24.583    ,  20.833    ,  18.333    ,  16.083    ,
     $   15.625    ,  15.083    ,  14.833    ,  15.083    ,  15.833    ,
     $   17.042    ,  18.958    ,  20.758    ,  22.533    ,  22.825    ,
     $   21.250    ,  18.567    ,  17.767    ,  18.100    ,  19.933    ,
     $   20.783    ,  21.225    ,  21.000    ,  20.558    ,  20.258    ,
     $   20.017    ,  19.767    ,  19.600    ,  19.183    ,  18.850    ,
     $   18.575    ,  18.350    ,  18.175    ,  17.808    ,  17.558    ,
     $   19.250    /
      data (csin(13,j),j=1,41) /
     $   400.00    ,  200.00    ,  120.00    ,  81.000    ,  62.000    ,
     $   47.000    ,  35.000    ,  28.000    ,  24.000    ,  21.000    ,
     $   19.500    ,  19.000    ,  18.800    ,  19.000    ,  20.000    ,
     $   21.000    ,  23.000    ,  25.000    ,  27.000    ,  27.500    ,
     $   25.500    ,  22.000    ,  20.800    ,  21.000    ,  23.000    ,
     $   24.000    ,  24.000    ,  23.800    ,  23.000    ,  22.500    ,
     $   22.000    ,  21.600    ,  21.400    ,  21.000    ,  20.500    ,
     $   20.200    ,  19.800    ,  19.500    ,  18.600    ,  17.500    ,
     $   20.000    /
      data (csin(14,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.10000    ,  1.5000    ,
     $   7.0000    ,  12.000    ,  17.000    ,  19.500    ,  20.500    ,
     $   22.000    ,  23.500    ,  24.800    ,  25.800    ,  26.500    ,
     $   27.000    ,  27.500    ,  28.000    ,  30.000    ,  31.000    ,
     $   32.000    ,  32.500    ,  32.500    ,  33.000    ,  33.500    ,
     $   34.000    /
      data (csin(15,j),j=1,41) /
     $   1500.0    ,  1160.0    ,  310.00    ,  230.00    ,  178.00    ,
     $   153.00    ,  134.00    ,  124.00    ,  113.00    ,  106.00    ,
     $   101.00    ,  96.000    ,  92.000    ,  89.000    ,  87.000    ,
     $   84.000    ,  81.000    ,  78.500    ,  76.500    ,  75.000    ,
     $   72.000    ,  70.000    ,  68.000    ,  64.500    ,  63.000    ,
     $   62.000    ,  61.000    ,  59.500    ,  58.500    ,  56.500    ,
     $   56.500    ,  56.000    ,  55.500    ,  52.000    ,  50.000    ,
     $   48.000    ,  45.000    ,  44.000    ,  39.200    ,  34.500    ,
     $   34.500    /
      data (csin(16,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.10000    ,  1.5000    ,
     $   7.0000    ,  12.000    ,  17.000    ,  19.500    ,  20.500    ,
     $   22.000    ,  23.500    ,  24.800    ,  25.800    ,  26.500    ,
     $   27.000    ,  27.500    ,  28.000    ,  30.000    ,  31.000    ,
     $   32.000    ,  32.500    ,  32.500    ,  33.000    ,  33.500    ,
     $   34.000    /
      data (csin(17,j),j=1,41) /
     $   1394.1    ,  948.17    ,  262.43    ,  197.14    ,  149.30    ,
     $   127.25    ,  110.39    ,  101.79    ,  92.834    ,  87.104    ,
     $   83.109    ,  79.099    ,  75.965    ,  73.627    ,  72.161    ,
     $   69.889    ,  67.595    ,  65.595    ,  64.057    ,  63.054    ,
     $   61.377    ,  60.434    ,  59.485    ,  56.970    ,  55.931    ,
     $   55.398    ,  54.827    ,  53.538    ,  52.861    ,  51.247    ,
     $   51.344    ,  50.992    ,  50.644    ,  47.876    ,  46.358    ,
     $   44.887    ,  42.577    ,  41.815    ,  38.180    ,  34.254    ,
     $   34.418    /
      data (csin(18,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.97815e-01,  1.4577    ,
     $   6.2052    ,  10.112    ,  12.902    ,  14.300    ,  14.688    ,
     $   15.505    ,  16.379    ,  17.554    ,  18.309    ,  18.920    ,
     $   19.389    ,  19.804    ,  20.284    ,  22.000    ,  22.733    ,
     $   23.527    ,  24.097    ,  24.382    ,  24.816    ,  26.800    ,
     $   27.719    /
      data (csin(19,j),j=1,41) /
     $   1182.4    ,  524.50    ,  167.30    ,  131.43    ,  91.895    ,
     $   75.743    ,  63.184    ,  57.376    ,  52.502    ,  49.313    ,
     $   47.326    ,  44.762    ,  43.222    ,  42.015    ,  41.221    ,
     $   40.244    ,  39.504    ,  39.145    ,  38.860    ,  38.731    ,
     $   37.987    ,  37.814    ,  36.326    ,  34.750    ,  33.953    ,
     $   33.635    ,  33.349    ,  32.938    ,  32.785    ,  32.092    ,
     $   32.373    ,  32.312    ,  32.329    ,  31.261    ,  30.597    ,
     $   30.073    ,  29.228    ,  29.182    ,  27.683    ,  27.107    ,
     $   27.956    /
      data (csin(20,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.97815e-01,  1.4577    ,
     $   6.2052    ,  10.112    ,  12.902    ,  14.300    ,  14.688    ,
     $   15.505    ,  16.379    ,  17.554    ,  18.309    ,  18.920    ,
     $   19.389    ,  19.804    ,  20.284    ,  22.000    ,  22.733    ,
     $   23.527    ,  24.097    ,  24.382    ,  24.816    ,  26.800    ,
     $   27.719    /
      data (csin(21,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin(22,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.97815e-01,  1.4577    ,
     $   6.2052    ,  10.112    ,  12.902    ,  14.300    ,  14.688    ,
     $   15.505    ,  16.379    ,  17.554    ,  18.309    ,  18.920    ,
     $   19.389    ,  19.804    ,  20.284    ,  22.000    ,  22.733    ,
     $   23.527    ,  24.097    ,  24.382    ,  24.816    ,  26.800    ,
     $   27.719    /
      data (csin(23,j),j=1,41) /
     $   1394.1    ,  948.17    ,  262.43    ,  197.14    ,  149.30    ,
     $   127.25    ,  110.39    ,  101.79    ,  92.834    ,  87.104    ,
     $   83.109    ,  78.563    ,  75.292    ,  72.760    ,  70.900    ,
     $   68.467    ,  66.314    ,  64.955    ,  63.746    ,  62.623    ,
     $   59.233    ,  56.946    ,  53.355    ,  49.810    ,  48.090    ,
     $   46.839    ,  45.695    ,  44.863    ,  44.062    ,  42.599    ,
     $   42.684    ,  42.328    ,  42.041    ,  39.508    ,  37.880    ,
     $   36.299    ,  34.075    ,  33.553    ,  29.723    ,  27.600    ,
     $   28.120    /
      data (csin(24,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin(25,j),j=1,41) /
     $   1182.4    ,  524.50    ,  167.30    ,  131.43    ,  91.895    ,
     $   75.743    ,  63.184    ,  57.376    ,  52.502    ,  49.313    ,
     $   47.326    ,  44.762    ,  43.222    ,  42.015    ,  41.221    ,
     $   40.244    ,  39.504    ,  39.145    ,  38.860    ,  38.731    ,
     $   37.987    ,  37.814    ,  36.326    ,  34.750    ,  33.953    ,
     $   33.635    ,  33.349    ,  32.938    ,  32.785    ,  32.092    ,
     $   32.373    ,  32.312    ,  32.329    ,  31.261    ,  30.597    ,
     $   30.073    ,  29.228    ,  29.182    ,  27.683    ,  27.107    ,
     $   27.956    /
      data (csin(26,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.95639e-01,  1.4154    ,
     $   5.4104    ,  8.2240    ,  8.8031    ,  9.1000    ,  8.8761    ,
     $   9.0095    ,  9.2576    ,  10.307    ,  10.818    ,  11.341    ,
     $   11.778    ,  12.108    ,  12.569    ,  14.000    ,  14.467    ,
     $   15.054    ,  15.694    ,  16.263    ,  16.632    ,  20.100    ,
     $   21.438    /
      data (csin(27,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.95639e-01,  1.4154    ,
     $   5.4104    ,  8.2240    ,  8.8031    ,  9.1000    ,  8.8761    ,
     $   9.0095    ,  9.2576    ,  10.307    ,  10.818    ,  11.341    ,
     $   11.778    ,  12.108    ,  12.569    ,  14.000    ,  14.467    ,
     $   15.054    ,  15.694    ,  16.263    ,  16.632    ,  20.100    ,
     $   21.438    /
      data (csin(28,j),j=1,41) /
     $   1182.4    ,  524.50    ,  167.30    ,  131.43    ,  91.895    ,
     $   75.743    ,  63.184    ,  57.376    ,  52.502    ,  49.313    ,
     $   47.326    ,  44.225    ,  42.549    ,  41.148    ,  39.960    ,
     $   38.822    ,  38.223    ,  38.505    ,  38.549    ,  38.301    ,
     $   35.843    ,  34.326    ,  30.196    ,  27.590    ,  26.112    ,
     $   25.076    ,  24.217    ,  24.264    ,  23.985    ,  23.445    ,
     $   23.713    ,  23.647    ,  23.726    ,  22.892    ,  22.119    ,
     $   21.485    ,  20.726    ,  20.921    ,  19.226    ,  20.454    ,
     $   21.658    /
      data (csin(29,j),j=1,41) /
     $   1076.5    ,  312.66    ,  119.74    ,  98.571    ,  63.193    ,
     $   49.990    ,  39.579    ,  35.168    ,  32.335    ,  30.417    ,
     $   29.434    ,  27.325    ,  26.514    ,  25.775    ,  25.120    ,
     $   24.711    ,  24.818    ,  25.600    ,  26.106    ,  26.355    ,
     $   25.220    ,  24.760    ,  21.681    ,  20.060    ,  19.044    ,
     $   18.474    ,  18.044    ,  18.301    ,  18.347    ,  18.192    ,
     $   18.557    ,  18.639    ,  18.870    ,  18.769    ,  18.478    ,
     $   18.372    ,  18.302    ,  18.735    ,  18.206    ,  20.207    ,
     $   21.576    /
      data (csin(30,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin(31,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin(32,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csin(33,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.95639e-01,  1.4154    ,
     $   5.4104    ,  8.2240    ,  8.8031    ,  9.1000    ,  8.8761    ,
     $   9.0095    ,  9.2576    ,  10.307    ,  10.818    ,  11.341    ,
     $   11.778    ,  12.108    ,  12.569    ,  14.000    ,  14.467    ,
     $   15.054    ,  15.694    ,  16.263    ,  16.632    ,  20.100    ,
     $   21.438    /
      data (csin(34,j),j=1,41) /
     $   1076.5    ,  312.66    ,  119.74    ,  98.571    ,  63.193    ,
     $   49.990    ,  39.579    ,  35.168    ,  32.335    ,  30.417    ,
     $   29.434    ,  27.325    ,  26.514    ,  25.775    ,  25.120    ,
     $   24.711    ,  24.818    ,  25.600    ,  26.106    ,  26.355    ,
     $   25.220    ,  24.760    ,  21.681    ,  20.060    ,  19.044    ,
     $   18.474    ,  18.044    ,  18.301    ,  18.347    ,  18.192    ,
     $   18.557    ,  18.639    ,  18.870    ,  18.769    ,  18.478    ,
     $   18.372    ,  18.302    ,  18.735    ,  18.206    ,  20.207    ,
     $   21.576    /
      data (csin(35,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (cspiel( 1,j),j=1,41) /
     $  0.00000e+00,  350.00    ,  580.00    ,  600.00    ,  550.00    ,
     $   450.00    ,  410.00    ,  370.00    ,  340.00    ,  230.00    ,
     $   220.00    ,  205.00    ,  180.00    ,  155.00    ,  145.00    ,
     $   140.00    ,  160.00    ,  195.00    ,  235.00    ,  250.00    ,
     $   270.00    ,  280.00    ,  300.00    ,  300.00    ,  290.00    ,
     $   285.00    ,  265.00    ,  240.00    ,  230.00    ,  222.00    ,
     $   204.00    ,  196.00    ,  190.00    ,  170.00    ,  170.00    ,
     $   160.00    ,  150.00    ,  140.00    ,  120.00    ,  80.000    ,
     $   80.000    /
      data (cspiel( 2,j),j=1,41) /
     $  0.00000e+00,  700.00    ,  1000.0    ,  1200.0    ,  1300.0    ,
     $   1300.0    ,  1250.0    ,  1250.0    ,  1100.0    ,  1000.0    ,
     $   940.00    ,  740.00    ,  700.00    ,  670.00    ,  660.00    ,
     $   670.00    ,  680.00    ,  700.00    ,  735.00    ,  800.00    ,
     $   810.00    ,  820.00    ,  820.00    ,  810.00    ,  800.00    ,
     $   800.00    ,  700.00    ,  600.00    ,  500.00    ,  470.00    ,
     $   440.00    ,  410.00    ,  380.00    ,  330.00    ,  330.00    ,
     $   330.00    ,  330.00    ,  330.00    ,  285.00    ,  240.00    ,
     $   240.00    /
      data (cspiel( 3,j),j=1,41) /
     $  0.00000e+00,  1700.0    ,  2200.0    ,  2200.0    ,  1800.0    ,
     $   1300.0    ,  1200.0    ,  900.00    ,  900.00    ,  1000.0    ,
     $   1100.0    ,  1300.0    ,  1400.0    ,  1420.0    ,  1490.0    ,
     $   1560.0    ,  1580.0    ,  1690.0    ,  1795.0    ,  2000.0    ,
     $   2070.0    ,  2140.0    ,  2050.0    ,  2010.0    ,  1970.0    ,
     $   1880.0    ,  1690.0    ,  1500.0    ,  1420.0    ,  1390.0    ,
     $   1350.0    ,  1360.0    ,  1370.0    ,  1280.0    ,  1290.0    ,
     $   1295.0    ,  1250.0    ,  1200.0    ,  1050.0    ,  900.00    ,
     $   900.00    /
      data (cspiin( 1,j),j=1,41) /
     $  0.00000e+00,  200.00    ,  320.00    ,  500.00    ,  600.00    ,
     $   600.00    ,  590.00    ,  530.00    ,  510.00    ,  470.00    ,
     $   430.00    ,  425.00    ,  420.00    ,  425.00    ,  425.00    ,
     $   430.00    ,  430.00    ,  435.00    ,  435.00    ,  440.00    ,
     $   430.00    ,  430.00    ,  420.00    ,  420.00    ,  420.00    ,
     $   415.00    ,  415.00    ,  410.00    ,  410.00    ,  408.00    ,
     $   406.00    ,  404.00    ,  400.00    ,  380.00    ,  340.00    ,
     $   340.00    ,  340.00    ,  340.00    ,  340.00    ,  340.00    ,
     $   340.00    /
      data (cspiin( 2,j),j=1,41) /
     $  0.00000e+00,  400.00    ,  800.00    ,  1000.0    ,  1100.0    ,
     $   1200.0    ,  1150.0    ,  1050.0    ,  1000.0    ,  900.00    ,
     $   860.00    ,  860.00    ,  850.00    ,  850.00    ,  840.00    ,
     $   830.00    ,  820.00    ,  810.00    ,  805.00    ,  800.00    ,
     $   800.00    ,  800.00    ,  800.00    ,  800.00    ,  800.00    ,
     $   800.00    ,  800.00    ,  800.00    ,  800.00    ,  780.00    ,
     $   760.00    ,  740.00    ,  720.00    ,  720.00    ,  700.00    ,
     $   690.00    ,  680.00    ,  670.00    ,  665.00    ,  660.00    ,
     $   660.00    /
      data (cspiin( 3,j),j=1,41) /
     $  0.00000e+00,  1000.0    ,  1900.0    ,  2600.0    ,  2900.0    ,
     $   3000.0    ,  2800.0    ,  2600.0    ,  2500.0    ,  2300.0    ,
     $   2200.0    ,  2000.0    ,  1900.0    ,  1880.0    ,  1860.0    ,
     $   1840.0    ,  1820.0    ,  1810.0    ,  1805.0    ,  1800.0    ,
     $   1780.0    ,  1760.0    ,  1750.0    ,  1740.0    ,  1730.0    ,
     $   1720.0    ,  1710.0    ,  1700.0    ,  1680.0    ,  1660.0    ,
     $   1650.0    ,  1640.0    ,  1630.0    ,  1620.0    ,  1610.0    ,
     $   1605.0    ,  1600.0    ,  1600.0    ,  1550.0    ,  1500.0    ,
     $   1500.0    /
      data (cspnel( 1,j),j=1,41) /
     $   2100.0    ,  1800.0    ,  1500.0    ,  1050.0    ,  900.00    ,
     $   950.00    ,  800.00    ,  650.00    ,  570.00    ,  390.00    ,
     $   300.00    ,  240.00    ,  230.00    ,  230.00    ,  220.00    ,
     $   220.00    ,  225.00    ,  225.00    ,  240.00    ,  240.00    ,
     $   290.00    ,  330.00    ,  335.00    ,  350.00    ,  355.00    ,
     $   370.00    ,  350.00    ,  330.00    ,  310.00    ,  290.00    ,
     $   270.00    ,  265.00    ,  260.00    ,  230.00    ,  210.00    ,
     $   210.00    ,  200.00    ,  200.00    ,  190.00    ,  180.00    ,
     $   180.00    /
      data (cspnel( 2,j),j=1,41) /
     $   3800.0    ,  2900.0    ,  1850.0    ,  1550.0    ,  1450.0    ,
     $   1520.0    ,  1460.0    ,  1300.0    ,  1140.0    ,  880.00    ,
     $   700.00    ,  620.00    ,  540.00    ,  560.00    ,  460.00    ,
     $   460.00    ,  470.00    ,  470.00    ,  480.00    ,  480.00    ,
     $   580.00    ,  600.00    ,  610.00    ,  620.00    ,  620.00    ,
     $   620.00    ,  590.00    ,  580.00    ,  460.00    ,  440.00    ,
     $   420.00    ,  400.00    ,  480.00    ,  430.00    ,  380.00    ,
     $   380.00    ,  380.00    ,  380.00    ,  380.00    ,  380.00    ,
     $   380.00    /
      data (cspnel( 3,j),j=1,41) /
     $   7000.0    ,  6000.0    ,  4500.0    ,  3350.0    ,  2700.0    ,
     $   3000.0    ,  3550.0    ,  3970.0    ,  3280.0    ,  2490.0    ,
     $   2100.0    ,  1510.0    ,  1440.0    ,  1370.0    ,  1370.0    ,
     $   1370.0    ,  1400.0    ,  1400.0    ,  1420.0    ,  1420.0    ,
     $   1440.0    ,  1460.0    ,  1460.0    ,  1450.0    ,  1450.0    ,
     $   1470.0    ,  1400.0    ,  1400.0    ,  1380.0    ,  1370.0    ,
     $   1360.0    ,  1350.0    ,  1340.0    ,  1330.0    ,  1320.0    ,
     $   1310.0    ,  1305.0    ,  1300.0    ,  1300.0    ,  1300.0    ,
     $   1300.0    /
      data (cspnin( 1,j),j=1,41) /
     $  0.00000e+00,  200.00    ,  400.00    ,  800.00    ,  800.00    ,
     $   550.00    ,  500.00    ,  450.00    ,  430.00    ,  410.00    ,
     $   400.00    ,  390.00    ,  380.00    ,  370.00    ,  370.00    ,
     $   370.00    ,  365.00    ,  365.00    ,  360.00    ,  360.00    ,
     $   360.00    ,  360.00    ,  365.00    ,  370.00    ,  375.00    ,
     $   380.00    ,  400.00    ,  410.00    ,  420.00    ,  430.00    ,
     $   440.00    ,  440.00    ,  440.00    ,  440.00    ,  440.00    ,
     $   440.00    ,  440.00    ,  440.00    ,  440.00    ,  440.00    ,
     $   440.00    /
      data (cspnin( 2,j),j=1,41) /
     $  0.00000e+00,  400.00    ,  950.00    ,  1050.0    ,  1050.0    ,
     $   980.00    ,  940.00    ,  900.00    ,  860.00    ,  820.00    ,
     $   800.00    ,  780.00    ,  760.00    ,  740.00    ,  740.00    ,
     $   740.00    ,  730.00    ,  730.00    ,  720.00    ,  720.00    ,
     $   720.00    ,  720.00    ,  730.00    ,  740.00    ,  750.00    ,
     $   760.00    ,  800.00    ,  820.00    ,  820.00    ,  820.00    ,
     $   820.00    ,  820.00    ,  820.00    ,  820.00    ,  820.00    ,
     $   820.00    ,  820.00    ,  820.00    ,  820.00    ,  820.00    ,
     $   820.00    /
      data (cspnin( 3,j),j=1,41) /
     $  0.00000e+00, 0.00000e+00,  500.00    ,  1450.0    ,  1700.0    ,
     $   1800.0    ,  1750.0    ,  1730.0    ,  1720.0    ,  1710.0    ,
     $   1700.0    ,  1690.0    ,  1660.0    ,  1630.0    ,  1630.0    ,
     $   1630.0    ,  1600.0    ,  1600.0    ,  1580.0    ,  1580.0    ,
     $   1580.0    ,  1580.0    ,  1600.0    ,  1630.0    ,  1650.0    ,
     $   1670.0    ,  1760.0    ,  1800.0    ,  1800.0    ,  1800.0    ,
     $   1800.0    ,  1800.0    ,  1800.0    ,  1800.0    ,  1800.0    ,
     $   1800.0    ,  1800.0    ,  1800.0    ,  1800.0    ,  1800.0    ,
     $   1800.0    /
      data elab /
     $  0.10000e-03, 0.20000e-03, 0.30000e-03, 0.40000e-03, 0.50000e-03,
     $  0.70000e-03, 0.10000e-02, 0.20000e-02, 0.30000e-02, 0.40000e-02,
     $  0.50000e-02, 0.70000e-02, 0.10000e-01, 0.15000e-01, 0.20000e-01,
     $  0.25000e-01, 0.32700e-01/
      data cnlwat /
     $   1.0000    ,  16.000    ,  27.000    ,  56.000    ,  59.000    ,
     $   64.000    ,  91.000    ,  112.00    ,  119.00    ,  127.00    ,
     $   137.00    ,  181.00    ,  207.00    ,  209.00    ,  238.00    /
      data (cnlwel( 1,j),j=1,17) /
     $   6000.0    ,  5500.0    ,  5200.0    ,  4900.0    ,  4800.0    ,
     $   4400.0    ,  4000.0    ,  2900.0    ,  2200.0    ,  1800.0    ,
     $   1400.0    ,  1100.0    ,  900.00    ,  700.00    ,  600.00    ,
     $   560.00    ,  520.00    /
      data (cnlwel( 2,j),j=1,17) /
     $   5400.0    ,  5050.0    ,  4800.0    ,  4600.0    ,  4399.0    ,
     $   4090.0    ,  3700.0    ,  2600.0    ,  1950.0    ,  1600.0    ,
     $   1300.0    ,  900.00    ,  700.00    ,  800.00    ,  1050.0    ,
     $   1250.0    ,  1320.0    /
      data (cnlwel( 3,j),j=1,17) /
     $   5500.0    ,  5150.0    ,  4900.0    ,  4699.0    ,  4490.0    ,
     $   4150.0    ,  3750.0    ,  2790.0    ,  2100.0    ,  1650.0    ,
     $   1300.0    ,  950.00    ,  800.00    ,  860.00    ,  1000.0    ,
     $   1090.0    ,  1080.0    /
      data (cnlwel( 4,j),j=1,17) /
     $   5499.0    ,  4970.0    ,  4450.0    ,  4080.0    ,  3750.0    ,
     $   3380.0    ,  2900.0    ,  2400.0    ,  2380.0    ,  2350.0    ,
     $   2300.0    ,  2100.0    ,  1720.0    ,  1370.0    ,  1200.0    ,
     $   1060.0    ,  870.00    /
      data (cnlwel( 5,j),j=1,17) /
     $   5399.0    ,  4710.0    ,  4180.0    ,  3760.0    ,  3460.0    ,
     $   3150.0    ,  2730.0    ,  2270.0    ,  1850.0    ,  1850.0    ,
     $   2130.0    ,  2330.0    ,  2120.0    ,  1640.0    ,  1310.0    ,
     $   1100.0    ,  1050.0    /
      data (cnlwel( 6,j),j=1,17) /
     $   5099.0    ,  4405.0    ,  3825.0    ,  3455.0    ,  3125.0    ,
     $   2695.0    ,  2350.0    ,  1850.0    ,  1580.0    ,  1820.0    ,
     $   2050.0    ,  2210.0    ,  2000.0    ,  1590.0    ,  1310.0    ,
     $   1120.0    ,  1040.0    /
      data (cnlwel( 7,j),j=1,17) /
     $   6290.0    ,  5960.0    ,  5640.0    ,  5370.0    ,  5150.0    ,
     $   4800.0    ,  4250.0    ,  3150.0    ,  2470.0    ,  2100.0    ,
     $   2230.0    ,  2420.0    ,  2450.0    ,  2050.0    ,  1760.0    ,
     $   1550.0    ,  1330.0    /
      data (cnlwel( 8,j),j=1,17) /
     $   6885.0    ,  6650.0    ,  6350.0    ,  6150.0    ,  6000.0    ,
     $   5700.0    ,  5360.0    ,  4250.0    ,  2800.0    ,  1870.0    ,
     $   1810.0    ,  1820.0    ,  2170.0    ,  2450.0    ,  2150.0    ,
     $   1700.0    ,  1390.0    /
      data (cnlwel( 9,j),j=1,17) /
     $   6600.0    ,  6500.0    ,  6400.0    ,  6249.0    ,  6190.0    ,
     $   5950.0    ,  5520.0    ,  4250.0    ,  2750.0    ,  1900.0    ,
     $   1850.0    ,  1950.0    ,  2340.0    ,  2800.0    ,  2540.0    ,
     $   2100.0    ,  1760.0    /
      data (cnlwel(10,j),j=1,17) /
     $   7400.0    ,  7200.0    ,  6999.0    ,  6840.0    ,  6655.0    ,
     $   6320.0    ,  5820.0    ,  4400.0    ,  2850.0    ,  2000.0    ,
     $   1800.0    ,  1800.0    ,  2150.0    ,  2600.0    ,  2350.0    ,
     $   1950.0    ,  2100.0    /
      data (cnlwel(11,j),j=1,17) /
     $   7900.0    ,  7700.0    ,  7499.0    ,  7390.0    ,  7202.0    ,
     $   6810.0    ,  6360.0    ,  4920.0    ,  3450.0    ,  2600.0    ,
     $   2200.0    ,  1950.0    ,  2300.0    ,  2800.0    ,  2650.0    ,
     $   2250.0    ,  2050.0    /
      data (cnlwel(12,j),j=1,17) /
     $   7900.0    ,  7750.0    ,  7699.0    ,  7590.0    ,  7450.0    ,
     $   7200.0    ,  6850.0    ,  5650.0    ,  4400.0    ,  3700.0    ,
     $   3400.0    ,  2800.0    ,  2700.0    ,  3100.0    ,  3250.0    ,
     $   3100.0    ,  2750.0    /
      data (cnlwel(13,j),j=1,17) /
     $   6100.0    ,  5950.0    ,  5750.0    ,  5599.0    ,  5440.0    ,
     $   5200.0    ,  4800.0    ,  4300.0    ,  5800.0    ,  5750.0    ,
     $   4800.0    ,  3420.0    ,  2650.0    ,  3200.0    ,  3650.0    ,
     $   3500.0    ,  2980.0    /
      data (cnlwel(14,j),j=1,17) /
     $   6100.0    ,  5950.0    ,  5750.0    ,  5599.0    ,  5440.0    ,
     $   5200.0    ,  4800.0    ,  4300.0    ,  5800.0    ,  5750.0    ,
     $   4800.0    ,  3420.0    ,  2650.0    ,  3200.0    ,  3650.0    ,
     $   3500.0    ,  2980.0    /
      data (cnlwel(15,j),j=1,17) /
     $   6600.0    ,  6350.0    ,  6100.0    ,  5899.0    ,  5690.0    ,
     $   5300.0    ,  4850.0    ,  4450.0    ,  5650.0    ,  5700.0    ,
     $   4950.0    ,  3850.0    ,  3050.0    ,  3050.0    ,  3460.0    ,
     $   3650.0    ,  3340.0    /
      data (cnlwin( 1,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00/
      data (cnlwin( 2,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,  1.0000    ,
     $   10.000    ,  50.000    ,  100.00    ,  200.00    ,  300.00    ,
     $   400.00    ,  600.00    ,  700.00    ,  750.00    ,  700.00    ,
     $   700.00    ,  680.00    /
      data (cnlwin( 3,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00,  1.0000    ,  10.000    ,
     $   50.000    ,  100.00    ,  260.00    ,  450.00    ,  600.00    ,
     $   700.00    ,  800.00    ,  900.00    ,  940.00    ,  900.00    ,
     $   860.00    ,  820.00    /
      data (cnlwin( 4,j),j=1,17) /
     $   1.0000    ,  80.000    ,  200.00    ,  320.00    ,  400.00    ,
     $   520.00    ,  700.00    ,  1000.0    ,  1120.0    ,  1200.0    ,
     $   1200.0    ,  1200.0    ,  1180.0    ,  1130.0    ,  1100.0    ,
     $   1090.0    ,  1080.0    /
      data (cnlwin( 5,j),j=1,17) /
     $   1.0000    ,  90.000    ,  220.00    ,  340.00    ,  420.00    ,
     $   550.00    ,  720.00    ,  1080.0    ,  1300.0    ,  1400.0    ,
     $   1420.0    ,  1420.0    ,  1380.0    ,  1260.0    ,  1190.0    ,
     $   1150.0    ,  1100.0    /
      data (cnlwin( 6,j),j=1,17) /
     $   1.0000    ,  95.000    ,  225.00    ,  345.00    ,  425.00    ,
     $   555.00    ,  750.00    ,  1150.0    ,  1500.0    ,  1680.0    ,
     $   1700.0    ,  1690.0    ,  1550.0    ,  1360.0    ,  1240.0    ,
     $   1180.0    ,  1120.0    /
      data (cnlwin( 7,j),j=1,17) /
     $   10.000    ,  140.00    ,  260.00    ,  380.00    ,  450.00    ,
     $   600.00    ,  750.00    ,  1200.0    ,  1580.0    ,  1800.0    ,
     $   1820.0    ,  1830.0    ,  1800.0    ,  1750.0    ,  1690.0    ,
     $   1650.0    ,  1620.0    /
      data (cnlwin( 8,j),j=1,17) /
     $   15.000    ,  150.00    ,  300.00    ,  400.00    ,  500.00    ,
     $   650.00    ,  840.00    ,  1500.0    ,  2100.0    ,  2130.0    ,
     $   2140.0    ,  2130.0    ,  2080.0    ,  2000.0    ,  1950.0    ,
     $   1900.0    ,  1860.0    /
      data (cnlwin( 9,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00,  1.0000    ,  10.000    ,
     $   150.00    ,  380.00    ,  1000.0    ,  1650.0    ,  2100.0    ,
     $   2100.0    ,  2100.0    ,  2060.0    ,  1950.0    ,  1860.0    ,
     $   1800.0    ,  1740.0    /
      data (cnlwin(10,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00,  1.0000    ,  10.000    ,  45.000    ,
     $   180.00    ,  380.00    ,  1050.0    ,  1900.0    ,  2300.0    ,
     $   2300.0    ,  2200.0    ,  2150.0    ,  2000.0    ,  1900.0    ,
     $   1800.0    ,  1750.0    /
      data (cnlwin(11,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00,  1.0000    ,  10.000    ,  48.000    ,
     $   190.00    ,  390.00    ,  1080.0    ,  2000.0    ,  2400.0    ,
     $   2400.0    ,  2300.0    ,  2200.0    ,  2100.0    ,  1950.0    ,
     $   1850.0    ,  1800.0    /
      data (cnlwin(12,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00,  1.0000    ,  10.000    ,  50.000    ,
     $   200.00    ,  400.00    ,  1100.0    ,  2100.0    ,  2500.0    ,
     $   2500.0    ,  2450.0    ,  2300.0    ,  2100.0    ,  2000.0    ,
     $   1900.0    ,  1850.0    /
      data (cnlwin(13,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00,  1.0000    ,  10.000    ,
     $   100.00    ,  350.00    ,  900.00    ,  1400.0    ,  2000.0    ,
     $   2300.0    ,  2380.0    ,  2400.0    ,  2300.0    ,  2250.0    ,
     $   2200.0    ,  2120.0    /
      data (cnlwin(14,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00,  1.0000    ,  10.000    ,
     $   100.00    ,  350.00    ,  900.00    ,  1400.0    ,  2000.0    ,
     $   2300.0    ,  2380.0    ,  2400.0    ,  2300.0    ,  2250.0    ,
     $   2200.0    ,  2120.0    /
      data (cnlwin(15,j),j=1,17) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00,  1.0000    ,  10.000    ,
     $   100.00    ,  400.00    ,  950.00    ,  1600.0    ,  2200.0    ,
     $   2550.0    ,  2750.0    ,  2700.0    ,  2600.0    ,  2540.0    ,
     $   2450.0    ,  2360.0    /
      data (cscap(j),j=1,50) /
     $   6.0000    ,  5.7000    ,  5.5000    ,  5.3000    ,  5.2000    ,
     $   5.1000    ,  5.0000    ,  4.9000    ,  4.8000    ,  4.8000    ,
     $   4.8000    ,  4.8000    ,  4.8000    ,  4.8000    ,  4.8000    ,
     $   4.8000    ,  4.9000    ,  5.0000    ,  5.2000    ,  5.5000    ,
     $   6.0000    ,  6.7000    ,  7.5000    ,  8.5000    ,  10.000    ,
     $   12.000    ,  14.500    ,  19.000    ,  26.500    ,  40.000    ,
     $   75.000    ,  120.00    ,  180.00    ,  260.00    ,  360.00    ,
     $   330.00    ,  60.000    ,  7.0000    ,  9.5000    ,  20.000    ,
     $   75.000    ,  140.00    ,  250.00    ,  360.00    ,  480.00    ,
     $   580.00    ,  590.00    ,  500.00    ,  300.00    ,  100.00    /
      data (cscap(j),j=51,100) /
     $   200.00    ,  300.00    ,  400.00    ,  470.00    ,  500.00    ,
     $   430.00    ,  100.00    ,  20.000    ,  22.000    ,  40.000    ,
     $   560.00    ,  950.00    ,  1000.0    ,  1000.0    ,  1000.0    ,
     $   990.00    ,  920.00    ,  860.00    ,  790.00    ,  740.00    ,
     $   650.00    ,  600.00    ,  540.00    ,  470.00    ,  440.00    ,
     $   390.00    ,  360.00    ,  340.00    ,  320.00    ,  310.00    ,
     $   280.00    ,  2.0000    ,  2.5000    ,  6.0000    ,  13.000    ,
     $   38.000    ,  65.000    ,  140.00    ,  280.00    ,  300.00    ,
     $   430.00    ,  580.00    ,  650.00    ,  800.00    ,  920.00    ,
     $   1100.0    ,  1250.0    ,  1400.0    ,  1550.0    ,  1700.0    /
      data ekfiss /
     $  0.10000e-03, 0.20000e-03, 0.30000e-03, 0.50000e-03, 0.70000e-03,
     $  0.10000e-02, 0.15000e-02, 0.20000e-02, 0.30000e-02, 0.50000e-02,
     $  0.70000e-02, 0.10000e-01, 0.15000e-01, 0.20000e-01, 0.50000e-01,
     $  0.10000    , 0.20000    , 0.30000    , 0.40000    , 0.50000    ,
     $   1000.0    /
      data (csfiss( 1,j),j=1,21) /
     $   2600.0    ,  2300.0    ,  2300.0    ,  2100.0    ,  2000.0    ,
     $   1950.0    ,  1930.0    ,  1900.0    ,  1800.0    ,  1600.0    ,
     $   2100.0    ,  2300.0    , 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csfiss( 2,j),j=1,21) /
     $   1850.0    ,  1400.0    ,  1300.0    ,  1150.0    ,  1100.0    ,
     $   1200.0    ,  1250.0    ,  1300.0    ,  1250.0    ,  1150.0    ,
     $   1600.0    ,  1900.0    , 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csfiss( 3,j),j=1,21) /
     $   1700.0    ,  1650.0    ,  1650.0    ,  1700.0    ,  1700.0    ,
     $   1800.0    ,  1900.0    ,  2000.0    ,  1950.0    ,  1800.0    ,
     $   2150.0    ,  2450.0    , 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00/
      data (csfiss( 4,j),j=1,21) /
     $  0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     $  0.00000e+00,  250.00    ,  550.00    ,  550.00    ,  550.00    ,
     $   550.00    ,  550.00    ,  1000.0    ,  1400.0    ,  1600.0    ,
     $   1500.0    ,  1400.0    ,  1300.0    ,  1200.0    ,  1100.0    ,
     $   1000.0    /
c --- end of cross section data statements ---
c
c --- data stmts. for geant/gheisha particle code conversions ---
c --- kipart(i)=gheisha code corresponding to geant   code i ---
c --- ikpart(i)=geant   code corresponding to gheisha code i ---
c
      data kipart/
     $               1,   3,   4,   2,   5,   6,   8,   7,
     $               9,  12,  10,  13,  16,  14,  15,  11,
     $              35,  18,  20,  21,  22,  26,  27,  33,
     $              17,  19,  23,  24,  25,  28,  29,  34,
     $              35,  35,  35,  35,  35,  35,  35,  35,
     $              35,  35,  35,  35,  30,  31,  32,  35/
c
      data ikpart/
     $               1,   4,   2,   3,   5,   6,   8,   7,
     $               9,  11,  16,  10,  12,  14,  15,  13,
     $              25,  18,  26,  19,  20,  21,  27,  28,
     $              29,  22,  23,  30,  31,  45,  46,  47,
     $              24,  32,  48/
c
c
      data alpha    / 6*0.7,
     $                0.75 ,0.75 ,0.75 ,
     $                0.76,0.76 ,0.76 ,0.76 ,
     $                0.685,0.63 ,0.685,0.63,0.685,0.63,
     $                3*0.685,3*0.63,2*0.685,2*0.63,
     $                3*0.7,0.685,0.63,0.7/
      data alphac    /1.2,1.2,1.2,1.15,0.90,0.91,0.98,1.06,1.10,1.11,
     $                1.10,1.08,1.05,1.01,0.985,0.962,0.945,0.932,
     $                0.925,0.920,0.920,0.921,0.922,0.923,0.928,0.931,
     $                0.940,0.945,0.950,0.955,0.958,0.962,0.965,0.976,
     $                0.982,0.988,0.992,1.010,1.020,1.030,1.040/
      data partel/6*0.,29*1./
      data partin/6*0.,1.00,0.00,1.05,1.20,1.35,1.30,1.20,1.00,1.30,
     $            1.00,1.30,1.00,1.30,1.00,1.00,1.00,1.30,1.30,1.30,
     $            1.00,1.00,1.30,1.30,1.00,1.,1.,1.,1.3,1./
c
c cross sections on nucleus are known only for pions and protons.
c the general law sigma(a)=1.25*sigma(tot,proton)*a**alpha is valid
c only for momenta > 2 gev.the parametrization done here gives only
c a behaviour averaged over momenta and particle types.
c for a detector with only a few materials it's of course muchbetter
c to use tables of the measured cross sections .
c for elements with the following atomic numbers measured cross
c sections are available (see "pcsdata").
c
c                 h   al     cu     pb
      data  csa  /1. ,27.00 ,63.54 ,207.19 /
      data ipart2/9,8,7,11,10,13,12/
c
c
c --- initialise ghesig and switch to gheisha particle code ---
      ghesig=0.0
      fail=1301
      if(lpart.gt.48) go to 1313
      ipart=kipart(lpart)
c
c --- also switch to gheisha physics quantities ---
      p=ppart
      ek=ekin
c
c --- no interaction for gammas, neutrinos, electrons, positrons, muons,
c --- neutral pions, neutral sigmas and antisigmas and new particles.
      fail=1302
      if(ipart.le. 6) go to 1313
      if(ipart.eq. 8) go to 1313
      if(ipart.eq.21) go to 1313
      if(ipart.eq.24) go to 1313
      if(ipart.gt.34) go to 1313
c
c --- initialise the cross-sections with 0.0 ---
      do 9000 k=1,kk
      aiel(k)=0.0
      aiin(k)=0.0
      aifi(k)=0.0
      aica(k)=0.0
 9000 continue
c
      if ((ipart .lt. 30) .or. (ipart .gt. 32)) go to 121
c
c *** take geometrical cross sections for inelastic scattering ***
c *** of deuterons, tritons and alphas ***
      apart=0.0
      if (ipart .eq. 30) apart=2.0
      if (ipart .eq. 31) apart=3.0
      if (ipart .eq. 32) apart=4.0
      do 120 k=1,kk
      aiin(k)=49.0*(apart**(1.0/3.0)+a(k)**(1.0/3.0))**2
  120 continue
      goto 50
c
 121  continue
      if ((ipart .ne. 16) .or. (ek .gt. 0.0327)) go to 12
c
c *** use tables for low energy neutrons ***
c
c --- get energy bin ---
      do 13 j=2,17
      if (ek .lt. elab(j)) go to 14
 13   continue
      j=17
c
 14   continue
      je1=j-1
      je2=j
      ekx=max(ek,1.0e-9)
      do 20 k=1,kk
c
c --- get a bin ---
      do 17 j=2,15
      if (a(k) .lt. cnlwat(j)) go to 18
 17   continue
      j=15
c
 18   continue
      ja1=j-1
      ja2=j
c
c *** use linear interpolation or extrapolation by y=rce*x+rca*x+b ***
c
c --- elastic cross section ---
c --- e interpolation or extrapolation at ja1 ---
      dx=elab(je2)-elab(je1)
      dy=cnlwel(ja1,je2)-cnlwel(ja1,je1)
      rce=dy/dx
c --- a interpolation or extrapolation at je1 ---
      dx=cnlwat(ja2)-cnlwat(ja1)
      dy=cnlwel(ja2,je1)-cnlwel(ja1,je1)
      rca=dy/dx
      b=cnlwel(ja1,je1)-rce*elab(je1)-rca*cnlwat(ja1)
      aiel(k)=rce*ek+rca*a(k)+b
c
c --- inelastic cross section ---
c --- e interpolation or extrapolation at ja1 ---
      dx=elab(je2)-elab(je1)
      dy=cnlwin(ja1,je2)-cnlwin(ja1,je1)
      rce=dy/dx
c --- a interpolation or extrapolation at je1 ---
      dx=cnlwat(ja2)-cnlwat(ja1)
      dy=cnlwin(ja2,je1)-cnlwin(ja1,je1)
      rca=dy/dx
      b=cnlwin(ja1,je1)-rce*elab(je1)-rca*cnlwat(ja1)
      aiin(k)=rce*ek+rca*a(k)+b
c
      izno=z(k)+0.01
      aica(k)=11.12*cscap(izno)/(ekx*1.0e6)**0.577
 20   continue
      goto 50
c
c *** use parametrization of cross section data for all other cases ***
 12   continue
c
c
c --- get momentum bin ---
      do 2 i=2,41
      if (p .lt. plab(i)) go to 3
 2    continue
      i=41
c
 3    continue
      j=i-1
c
      do 40 k=1,kk
c
c *** start with  cross sections for scattering on free protons ***
c *** use linear interpolation or extrapolation by y=rc*x+b     ***
      dx=plab(j+1)-plab(j)
c --- elastic cross section ---
      dy=csel(ipart,j+1)-csel(ipart,j)
      rc=dy/dx
      b=csel(ipart,j)-rc*plab(j)
      aiel(k)=rc*p+b
c --- inelastic cross section ---
      dy=csin(ipart,j+1)-csin(ipart,j)
      rc=dy/dx
      b=csin(ipart,j)-rc*plab(j)
      aiin(k)=rc*p+b
c
      if (a(k) .lt. 1.5) go to 40
c
c *** a-dependence from parametrization ***
      crel=1.0
      crin=1.0
      alph=alpha(ipart)
c --- get medium bin  1=hydr.  2=al  3=cu  4=pb ---
      i=3
      if (a(k) .lt. 50.0) i=2
      if (a(k) .gt. 100.0) i=4
c --- jump to 5 for protons and neutrons ---
      if ((ipart .eq. 14) .or. (ipart .eq. 16)) go to 5
c --- jump to 11 for all other baryons ---
      if (ipart .ge. 15) go to 11
c
c *** calculate correction factors from values on al,cu,pb ***
c *** for all mesons ***
c *** use linear interpolation or extrapolation by y=rc*x+b ***
c note that data is only available for pions and protons
      dx=plab(j+1)-plab(j)
      dy=alphac(j+1)-alphac(j)
      rc=dy/dx
      b=alphac(j)-rc*plab(j)
      corfac=rc*p+b
      alph=alph*corfac
c
      ipart3=ipart2(ipart-6)
      wgch=0.5
      if (a(k) .lt. 20.0) wgch=0.5+0.5*exp(-(a(k)-1.0))
c
      dx=plab(j+1)-plab(j)
c --- eleastic cross section ---
      dy=csel(ipart3,j+1)-csel(ipart3,j)
      rc=dy/dx
      b=csel(ipart3,j)-rc*plab(j)
      xsecel=rc*p+b
c --- ineleastic cross section ---
      dy=csin(ipart3,j+1)-csin(ipart3,j)
      rc=dy/dx
      b=csin(ipart3,j)-rc*plab(j)
      xsecin=rc*p+b
c
      aiel(k)=wgch*aiel(k)+(1.0-wgch)*xsecel
      aiin(k)=wgch*aiin(k)+(1.0-wgch)*xsecin
c
c --- jump to 11 for kaons ---
      if (ipart .ge. 10) go to 11
c
      dx=plab(j+1)-plab(j)
c --- elastic cross section ---
      dy=cspiel(i-1,j+1)-cspiel(i-1,j)
      rc=dy/dx
      b=cspiel(i-1,j)-rc*plab(j)
      xsecel=rc*p+b
c --- inelastic cross section ---
      dy=cspiin(i-1,j+1)-cspiin(i-1,j)
      rc=dy/dx
      b=cspiin(i-1,j)-rc*plab(j)
      xsecin=rc*p+b
c
      crel=1.0
      if (aiel(k) .ge. 0.001) crel=xsecel/(0.36*aiel(k)*csa(i)**1.17)
      crin=1.0
      aitot=aiel(k)+aiin(k)
      if (aitot .ge. 0.001) crin=xsecin/(aitot*csa(i)**alph)
      goto 11
c
c --- protons and neutrons ---
 5    continue
      dx=plab(j+1)-plab(j)
c --- elastic cross section ---
      dy=cspnel(i-1,j+1)-cspnel(i-1,j)
      rc=dy/dx
      b=cspnel(i-1,j)-rc*plab(j)
      xsecel=rc*p+b
c --- inelastic cross section ---
      dy=cspnin(i-1,j+1)-cspnin(i-1,j)
      rc=dy/dx
      b=cspnin(i-1,j)-rc*plab(j)
      xsecin=rc*p+b
      crel=1.0
      if (aiel(k) .ge. 0.001) crel=xsecel/(0.36*aiel(k)*csa(i)**1.17)
      crin=1.0
      aitot=aiel(k)+aiin(k)
      if (aitot .ge. 0.001) crin=xsecin/(aitot*csa(i)**alph)
c
 11   continue
      aiin(k)=crin*(aiin(k)+aiel(k))*a(k)**alph
      aiel(k)=crel*0.36*aiel(k)*a(k)**1.17
      aiel(k)=aiel(k)*partel(ipart)
      aiin(k)=aiin(k)*partin(ipart)
   40 continue
c
c *** fission cross sections ***
c --- a-dependence given by  sigma(3 mev)=-67.0+38.7*z**(4/3)/a ---
 50   continue
      do 51 i=1,21
      if (ek .lt. ekfiss(i)) go to 52
 51   continue
      i=21
c
 52   continue
      do 60 k=1,kk
c
c --- no fission for materials with a < 230 ---
      if (a(k) .lt. 230.0) go to 60
c
c --- only data for u(233), u(235) and pu(239) for ekin .le. 0.01 gev ---
      j=4
      if (ek .gt. 0.01) go to 53
c
c --- distinguish u(233), u(235), pu(239) and u(238) and rest by j=1,4
      if ((z(k) .eq. 92.0) .and. (abs(a(k)-233.0) .lt. 0.5)) j=1
      if ((z(k) .eq. 92.0) .and. (abs(a(k)-235.0) .lt. 0.5)) j=2
      if ((z(k) .eq. 94.0) .and. (abs(a(k)-239.0) .lt. 0.5)) j=3
      if (j .le. 3) aifi(k)=csfiss(j,i)
      if (j .le. 3) go to 60
c
 53   continue
      z43ba=z(k)**(4.0/3.0)/a(k)
      z43ba=-67.0+38.7*z43ba
      if (z43ba .lt. 0.0) go to 60
c
c --- energy dependence taken from u(238) ---
c --- approximated as step-function ---
      aifi(k)=csfiss(j,i)*z43ba
   60 continue
c
c *** corrections for compounds ***
c --- these corrections should only be applied to anorganic scintill. ---
 70   continue
c --- apply the correction only if user selected it within geant ---
      if (qcor .le. 0.0) go to 45
      if (kk .le. 1) go to 45
c --- do not apply corrections for anti-baryons ---
      if (ipart .eq. 15) go to 45
      if (ipart .eq. 17) go to 45
      if (ipart .eq. 19) go to 45
      if ((ipart .ge. 23) .and. (ipart .le. 25)) go to 45
      if ((ipart .eq. 28) .or. (ipart .eq. 29)) go to 45
      if (ipart .eq. 34) go to 45
c
c --- acc40 between 0.3 and 0.5 for pi+ and pi0, 0.2 for other mesons ---
      acc40=0.325
**    if (ipart .ge. 9) acc40=0.20
c --- acc40 = 0.15 for baryons ---
      if (ipart .ge. 14) acc40=0.15
c --- acca=0.08 for all pions, 0.02 for all other particles ---
      acca= 0.08
      if (ipart .ge. 10) acca=0.02
c
      accb=0.32*(acc40-acca)
      acc=acca-accb*log(ek)
      if (acc .gt. 0.5) acc=0.5
      if (acc .le. 0.0) go to 45
c
      do 44 k=1,kk
      aiel(k)=aiel(k)*aver**acc
      aiin(k)=aiin(k)*aver**acc
      aifi(k)=aifi(k)*aver**acc
      aica(k)=aica(k)*aver**acc
   44 continue
c
c *** calculate interaction probability ***
 45   continue
c
c --- correction factor for high (p > 100 gev/c) energies ---
      corh=1.0
      if (p .le. 100.) go to 46
c --- assume a log(p) dependence of the correction factor with values ---
c p = 100 gev/c  ==> corh = 1.
c p =   1 tev/c  ==> corh = 1.25
      dx=log(1000.)-log(100.)
      dy=1.25-1.
      rc=dy/dx
      b=1.-rc*log(100.)
      corh=rc*log(p)+b
c
 46   continue
      alam=0.0
      do 73 k=1,kk
      afact=6.022045e-4*dens*w(k)/a(k)
      aiel(k)=corh*aiel(k)*afact
      aiin(k)=corh*aiin(k)*afact
      aifi(k)=corh*aifi(k)*afact
      aica(k)=corh*aica(k)*afact
c
c --- check for un-physical values of the cross-sections ---
      if (aiel(k) .lt. 0.0) aiel(k)=0.0
      if (aiin(k) .lt. 0.0) aiin(k)=0.0
      if (aifi(k) .lt. 0.0) aifi(k)=0.0
      if (aica(k) .lt. 0.0) aica(k)=0.0
c
      alam=alam+aiel(k)+aiin(k)+aifi(k)+aica(k)
   73 continue
c
c --- pass the interaction probability to geant ---
      ghesig=alam
c
c
c --- printout of skipped particles in case of interface debug ---
c
 9999 continue
      return
c
1313  continue
c      write(6,*) 'fail=',fail,' in ghesig'
      return
      end


