      implicit none
c     The result (ans) of this calculation can be fitted by the
c     following 4th order polynomial.  
c
c         log(ans) = sum c_i p**i  (i=0 to 3)
c
c     c0        .77099  
c     c1        1.3470  
c     c2        .12049   
c     c3       -.57001E-02 
c
c  ans  gives integral 1 to 5 of 1/(x- sqrt(x**2-1))**p/sqrt(x**2-1)
c      for p=0.1 to 10. 
c     the result is used in the decay in flight.
c
      real*8 p
      common /zzz/p
      integer i, icon
      real*8 func
      external func
      real*8  ans, error, eps

      eps = 1.d-5
      do i = 1, 21
         p= 0.1d0*10.**((i-1)*0.1d0)
         call kdexpIntF(func, 1.0d0, 5.0d0, eps,
     *        ans, error, icon)
         write(*,*) sngl(p), sngl(ans), log(sngl(ans))
      enddo
      end
c     *********************************
      real*8 function func(xa)
      real*8 xa(2)
      real*8 p
      common /zzz/p
      real*8 x
c      write(*,*) xa
      x = xa(1)
      if(xa(2) .lt. 0.) then
c         x = 1.d0 - xa(2) so x-1=-xa(2)
c
         func =
     *   1.d0/(x-sqrt(-xa(2)*(x+1.d0)))**p/
     *   sqrt(-xa(2)*(x+1.d0))
      else
         func = 1.d0/(x- sqrt(x**2-1.d0))**p
     *          /sqrt(x**2-1.d0)
      endif

      end

