c----------------------------------------------------
c       cmkptc:  make  a particle
c        
c     implicit none
c     include '../Zptcl.h'
c     include '../Zcode.h'
c     record /ptcl/  p
c     integer i
c     do i=1, klast
c        call cmkptc(i, 0, 0,  p)
c        write(*, *) p.mass, p.charge
c     enddo
c     end   
      subroutine cmkptc(code, subcode,  charge, p)
c             make a particle. 
c       code: integer. Input. Particle code defined by the Cosmos convention.
c    subcode: integer. Input. Particle subcode defined //
c                      It has meaning for k0. neutron, gamma.
c     charge: integer. Input. Charge of the particle.
c                             In case of heavy (alpha, etd) this should be
c                             1 or -1, indepndently of the real charge.
c                             -1 for anti-neucleus.
c          p: structure /ptcl/. Output.
c                             Template particle is set.
c                  The attributes set are:
c                       px=undef  unchaged
c                       py=   //
c                       pz=   //
c                       e=    //
c                       mass=ptcl mass 
c                       code=ptcl code (same as input)
c                       subcode = ptcl sub code 
c                              This code is mainly used to identify
c                              particle/antiparticle.  If it is not
c                              important, or it is to be determined
c                              later, the user may give 0.
c
c                              This has meaning for the following
c                              particles. For other particles, 
c                              giving 0 is ok. It can be composed by
c                              'code' and 'charge'.
c----------------------------------------------------------------------
c                n           n~         k0s           k0l
c subcode
c defined      kneutron   kneutronb     k0s           k0l   
c in Zcode.h 
c----------------------------------------------------------------------
c           neutrino(e)  neutrino(mu)  neutrino(e)~   neutrino(mu)~
c
c subcode      regptcl            regptcl     antip          antip
c
c----------------------------------------------------------------------
c           direct gamma   brems gamma     d0          d0~
c
c subcode     kdirectg     kcasg          kd0          kdb
c
c----------------------------------------------------------------------
c                       charge=charge (if not heavy neuclus)
c                                     (charge * Z) (charge = 1, 0, -1)
c
c                             If subcode = 0 for  neutral partilces, this
c                             should be reset later, if they are
c                             not symmetric particle (k0, n, d0)
c              
c    
c                 
       implicit none
c----       include '../Zptcl.h'




c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c----       include '../Zcode.h'
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     4  kneutronb, kd0, kd0b, kdirectg, kcasg

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  klast=keta, khvymax = kiron)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3,
     3  k0s = 4,  k0l= 5,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.





c
c	(->	------------------------------------------

	integer Charge2heavyG	!2  charge of heavy $\rightarrow$  heavy group index conversion array.
        integer HeavyG2massN    !2  heavy group index $\rightarrow$     mass number conversion array.
	integer HeavyG2charge	!2  heavy group index $\rightarrow$     charge of heavy conversion array.
        integer HeavyG2code     !2  heavy group index $\rightarrow$     particle code conversion array.
        integer Code2massN      !2  particle code $\rightarrow$     mass number conversion array.
        integer Code2heavyG	!2  particle code $\rightarrow$     heavy group index conversion array.
        real*8  FragmentTbl	!2  tbl(i,j)=$<$Number$>$  of frag. j when a heavy of heavy group index i
                                !    breaks up at air.
        real*8  PtAvNonInteNuc  !2  $<$Pt$>$  of non interacting nucleons.
	real*8  PtAvFrag        !2  $<$Pt$>$  of heavy fragments.
	character*4 HeavyG2symbol !2   heavy group index $\rightarrow$  'Fe' etc conversion array.
	 integer HowIntNuc       !2 If 0, the  number of interacting nucleons among a projectile heavy nucleus is 
                                 !  determined as the number of first collision of each interacting nucleon inside 
                                ! the  nucleus.  If 1, the number is determined as the total number of collisions 
                                !   including successive interactions. Default is 1. (There is uncertaninity in
                                !  interpretation of the formula; value 1 gives larger number of interacting
                                !  nucleons.)


 
c	<-)	--------------------------------------
        

	common /Zheavyc/
     *   PtAvNonInteNuc, PtAvFrag,
     *   FragmentTbl(maxHeavyG, maxHeavyG), 
     *	 Charge2heavyG(maxHeavyCharge),
     *   HeavyG2massN(maxHeavyG), HeavyG2charge(maxHeavyG),
     *   HeavyG2code(maxHeavyG), Code2massN(khvymax),
     *   Code2heavyG(khvymax), HowIntNuc
        common /Zheavycc/ HeavyG2symbol(maxHeavyG)



	
       record /ptcl/ p
       integer code, charge, subcode
c

          p.code = code
c          if(code .ge. kdeut .and. code .le. khvymax) then
          if(code .ge. kalfa .and. code .le. khvymax) then
              call cshvc(code, charge, p)
          elseif(code .eq. ktriton) then
              call cshvc(code, charge, p)
          else
              p.charge = charge
          endif
          call csmass(code, subcode, charge, p)
          call cssubc(code, subcode, charge, p)
c           for heavy, we use only kgnuc here after (from v6.0)
          if(code .ge. kalfa .and. code .le. khvymax) then
             p.subcode = Code2massN(code)
             p.code = kgnuc
          endif   
      end
c     *******************************************************
      subroutine csmass(code, subcode, charge, p)
c          set  particle mass from ptcl code and charge.
c            code: Integer. Input. partcle code defined in COSMOS
c           charge:Integer. Input. partcle charge.
c                p:/ptcl/  Output.  p.mass will get partcle mass in GeV.
c                           For heavy neucleus, (massp + massn)/2*A
c                           is used.
      implicit none
c----      include '../Zptcl.h'




c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c----      include '../Zcode.h'
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     4  kneutronb, kd0, kd0b, kdirectg, kcasg

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  klast=keta, khvymax = kiron)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3,
     3  k0s = 4,  k0l= 5,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.





c----      include '../Zmass.h'

c               mass (GeV)

       real*8
     1  masele, maspic, maspi0, maskc, mask0, masd,
     2  masmu, masp,  masn,  masrho, masomg, masphi,
     3  maseta, masddb, masnnb, wrho,  womega, wphai,
     4  massigmap, massigma0, massigmam, masgzai0, 
     5  masgzaim, maslambda, maslambdac, masbomega
       
       parameter (
     1  masele=0.511d-3, maspic=139.5685d-3, maspi0=134.9642d-3,
     2  maskc=493.646d-3, mask0=497.671d-3, masd=1869.d-3,
     3  masmu=105.659d-3, masp=0.93827231,  masn=0.93956563,
     4  masrho=768.d-3, masomg=782.d-3, masphi=1019.4d-3,
     5  maseta=548.8d-3, masddb=2*masd, masnnb=2*masp,
     6  wrho = 150.e-3, womega = 8.4e-3, wphai = 4.4e-3  )
       parameter(
     1 massigmap = 1.189, massigma0 = 1.192, massigmam=1.197,
     2 masgzai0 = 1.314, masgzaim = 1.321, 
     3 maslambda = 1.115, maslambdac = 2.282, masbomega=1.672)
c        masddb and masnnb are the minimum value.
c
       integer code, charge, subcode
       record /ptcl/ p
c
       real*8 x
       parameter (x = 1.d50)
       real*8 mass(0:klast, -1:1)
       character*8 id
       integer massn
       character*70  msg
c
       data 
     * mass(kphoton, -1)/x/, mass(kphoton, 0)/0./,
     * mass(kphoton, 1)/x/,
     * mass(kelec,-1)/masele/,mass(kelec, 0)/x/,
     * mass(kelec, 1)/masele/,
     * mass(kmuon, -1)/masmu/,mass(kmuon, 0)/x/,
     * mass(kmuon, 1)/masmu/, 
     * mass(kpion, -1)/maspic/,mass(kpion, 0)/maspi0/,
     * mass(kpion, 1)/maspic/
       data
     * mass(kkaon, -1)/maskc/,mass(kkaon, 0)/mask0/,
     * mass(kkaon, 1)/maskc/,
     * mass(knuc, -1)/masp/, mass(knuc, 0)/masn/, 
     * mass(knuc, 1)/masp/,
     * mass(kneue, -1)/x/, mass(kneue, 0)/0./, 
     * mass(kneue, 1)/x/,
     * mass(kneumu,-1)/x/, mass(kneumu, 0)/0./, 
     * mass(kneumu, 1)/x/,
     * mass(knnb,  -1)/x/, mass(knnb, 0)/masnnb/,
     * mass(knnb, 1)/x/
       data
     * mass(kddb, -1)/x/, mass(kddb, 0)/masddb/,
     * mass(kddb, 1)/x/,
     * mass(kdmes, -1)/masd/, mass(kdmes, 0)/masd/, 
     * mass(kdmes, 1)/masd/,
     * mass(krho, -1)/masrho/,  mass(krho, 0)/masrho/,
     * mass(krho, 1)/masrho/,
     * mass(komega, -1)/x/,mass(komega, 0)/masomg/,
     * mass(komega,1)/x/,
     * mass(kphi, -1)/x/, mass(kphi, 0)/masphi/, 
     * mass(kphi, 1)/x/,
     * mass(keta, -1)/x/, mass(keta, 0)/maseta/,
     * mass(keta, 1)/x/ 
       data
     * mass(ksigma, -1)/massigmam/, mass(ksigma, 0)/massigma0/,
     * mass(ksigma, 1) /massigmap/,
     * mass(kgzai, -1) /masgzaim/, mass(kgzai, 0)/masgzai0/,
     * mass(kgzai, 1) /masgzaim/,
     * mass(klambda, 0)/maslambda/, mass(klambda, -1)/x/,
     * mass(klambda, 1)/x/,
     * mass(klambdac,-1)/maslambdac/, mass(klambdac, 0)/x/,
     * mass(klambdac, 1)/maslambdac/,
     * mass(krare, -1)/0./, mass(krare,0)/0./, mass(krare,1)/0./,
     * mass(kgnuc, -1)/x/, mass(kgnuc,0)/x/, mass(kgnuc,1)/x/
       data 
     * mass(kbomega, -1)/masbomega/, mass(kbomega,0)/x/,
     * mass(kbomega, 1) /masbomega/
c

 
c       if(code .ge. kdeut .and. code .le. khvymax) then
       if(code .ge. kalfa .and. code .le. khvymax) then
c                  get mass number
          call cghvm(code, massn)
          p.mass =( masn + masp)  * massn /2
       elseif(code .eq. ktriton) then
          p.mass = (masn *2 + masp)
       elseif(code  .eq. kgnuc) then
c             general nucleaus (A>1). subcode is A. very rough
c             binding energy. (Weizsacker-Bethe)
          p.mass = masn*(subcode-charge) + masp*charge
     *            -(15.68d-3*subcode-18.56d-3*(float(subcode))**0.6666
     *          -0.717d-3 * charge**2/(float(subcode))**0.33333)
       elseif(code .ge. 0 .and. code .le. klast) then
            p.mass = mass(code, charge)
            if(p.mass .eq. x) then
               call cgpid(code, id)
               write(msg, *)
     *        ' charge=',charge,' invalid for csmass; code=',id
               call cerrorMsg(msg, 0)
            endif
       else
            write(msg, *) ' code=',code,' invalid to csmass'
            call cerrorMsg(msg, 0)
       endif
      end
c     *******************************************************
      subroutine cssubc(code, subcode, charge, p)
c            set particle or anti particle subcode from 
c            ptcl code and charge.
c            code: Integer. Input. particle code defined in COSMOS
c          subcode: Integer. Input. paricle sub code //
c          charge:Integer. Input. partcle charge.
c             p: /ptcl/. Output. for most of particles,
c                        'ptcl' or 'antip' is set according to
c                        code and charge. For neutron, k0, gamma
c                        they are treated specially.
c                        for self conjugate particles, 0 is set.
c
      implicit none
c----      include '../Zptcl.h'




c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c----      include '../Zcode.h'
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     4  kneutronb, kd0, kd0b, kdirectg, kcasg

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  klast=keta, khvymax = kiron)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3,
     3  k0s = 4,  k0l= 5,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.





c
c	(->	------------------------------------------

	integer Charge2heavyG	!2  charge of heavy $\rightarrow$  heavy group index conversion array.
        integer HeavyG2massN    !2  heavy group index $\rightarrow$     mass number conversion array.
	integer HeavyG2charge	!2  heavy group index $\rightarrow$     charge of heavy conversion array.
        integer HeavyG2code     !2  heavy group index $\rightarrow$     particle code conversion array.
        integer Code2massN      !2  particle code $\rightarrow$     mass number conversion array.
        integer Code2heavyG	!2  particle code $\rightarrow$     heavy group index conversion array.
        real*8  FragmentTbl	!2  tbl(i,j)=$<$Number$>$  of frag. j when a heavy of heavy group index i
                                !    breaks up at air.
        real*8  PtAvNonInteNuc  !2  $<$Pt$>$  of non interacting nucleons.
	real*8  PtAvFrag        !2  $<$Pt$>$  of heavy fragments.
	character*4 HeavyG2symbol !2   heavy group index $\rightarrow$  'Fe' etc conversion array.
	 integer HowIntNuc       !2 If 0, the  number of interacting nucleons among a projectile heavy nucleus is 
                                 !  determined as the number of first collision of each interacting nucleon inside 
                                ! the  nucleus.  If 1, the number is determined as the total number of collisions 
                                !   including successive interactions. Default is 1. (There is uncertaninity in
                                !  interpretation of the formula; value 1 gives larger number of interacting
                                !  nucleons.)


 
c	<-)	--------------------------------------
        

	common /Zheavyc/
     *   PtAvNonInteNuc, PtAvFrag,
     *   FragmentTbl(maxHeavyG, maxHeavyG), 
     *	 Charge2heavyG(maxHeavyCharge),
     *   HeavyG2massN(maxHeavyG), HeavyG2charge(maxHeavyG),
     *   HeavyG2code(maxHeavyG), Code2massN(khvymax),
     *   Code2heavyG(khvymax), HowIntNuc
        common /Zheavycc/ HeavyG2symbol(maxHeavyG)



	
c
       integer code, subcode, charge
       record /ptcl/ p
       character*70  msg
c
       if(code .ge. 1 .and. code .le. klast) then
c                   this should be consistent with regptcl/antip
c                   def. in Zcode.h
          if(code .eq. kphoton) then
             p.subcode = subcode
          elseif(code .eq. kelec .or. code .eq. kmuon ) then
             p.subcode = - charge * regptcl
          elseif(code .eq. kpion .or. code .eq. kkaon
     *            .or. code .eq. knuc) then
             p.subcode =  charge * regptcl
             if( code .eq. kkaon .and. charge .eq. 0 .and.
     *            subcode .ne. 0) then
                if(abs(subcode) .eq. k0s .or. 
     *               abs(subcode) .eq. k0l ) then
                   p.subcode = subcode
                else
                   write(msg,*) '1 strange subcode=', 
     *                  subcode,' to cssubc. code=', code
                   p.mass = -1.0
                   p.mass = sqrt(p.mass)
                   call cerrorMsg(msg, 0)
                endif
             elseif(code .eq. knuc .and. charge .eq. 0 
     *               .and.   subcode .ne. 0) then
                if(subcode .eq. kneutron .or.
     *               subcode .eq. kneutronb) then
                   p.subcode = subcode
                else
                   write(msg, *) '2 strange subcode=', 
     *                  subcode, ' to cssubc. code=', code
                   call cerrorMsg(msg, 0)
                endif
             endif
          elseif(code .eq. kdmes) then
             if(subcode .ne. 0 .and. charge .eq. 0)then
                if(subcode .eq. kd0 .or.
     *               subcode .eq. kd0b) then                       
                   p.subcode = subcode
                endif
             else
                p.subcode = charge * regptcl
             endif
c          elseif(code .ge. kdeut .and. code .le. khvymax) then
          elseif(code .ge. kalfa .and. code .le. khvymax) then
c             p.subcode = isign(1, charge) *regptcl; set A
             p.subcode = Code2massN(code)   ! mass #
          elseif(code .eq. ktriton ) then
c             p.subcode = isign(1, charge) *regptcl
             p.subcode = 3   !   mass #
          elseif(code .eq. kgnuc) then
             p.subcode = subcode    ! mass #
          elseif(code .eq. kneumu .or. code .eq. kneue) then
             if(subcode .eq. regptcl .or.
     *            subcode .eq. antip .or.
     *            subcode .eq. 0  ) then
                p.subcode = subcode
             else
                write(msg, *) ' 3 strange subcode=', 
     *               subcode, ' to cssubc. code=', code
                call cerrorMsg(msg,  0)
             endif   
          elseif(code .ge. klambda .and.
     *            code .le. klast ) then
             p.subcode = subcode
          else      
             p.subcode = 0      ! should be fixed later
          endif     
       elseif(code .eq. krare) then
          p.subcode = 0
       else     
          write(msg, *) ' code=',code,' invalid to cssubc'
          call cerrorMsg(msg, 0)
       endif
      end
c     ****************************************************
c           set heavy neucleus charge
      subroutine cshvc(code, charge, p)
c           code: Integer. Input.  ptcl code
c         charge: Integer. Input.  ptcl charge (1 or -1)
c                                  indicating only positive or
c                                  negative. True charge is
c                                  set here.
c              p: /ptcl/. Output. heavy neucleus charge 
c                           is set in p.charge
c
         implicit none
c----         include '../Zptcl.h'




c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
c----         include '../Zcode.h'
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     4  kneutronb, kd0, kd0b, kdirectg, kcasg

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  klast=keta, khvymax = kiron)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3,
     3  k0s = 4,  k0l= 5,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.





         integer code, charge
         record /ptcl/ p
         character*70  msg
c
c         integer zhvy(kdeut:khvymax)/1, 2, 4, 7, 12, 17, 26/
         integer zhvy(kalfa:khvymax)/2, 4, 7, 12, 17, 26/
c
c         if(code .ge. kdeut .and. code .le. khvymax ) then
         if(code .ge. kalfa .and. code .le. khvymax ) then
            p.charge =  zhvy(code) * isign(1, charge)
         elseif(code .eq. ktriton) then
            p.charge = isign(1, charge)
         else
            write(msg, *) 'error input code=',code,' to cshvc'
            call cerrorMsg(msg, 0)
         endif
       end
c     ***************************************************
c         get heavy neucleus mass number
       subroutine cghvm(code, massn)      
c         code: Integer input. ptcl code
c        massn: Integer  output.  mass number
         implicit none
c----         include '../Zcode.h'
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     4  kneutronb, kd0, kd0b, kdirectg, kcasg

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  klast=keta, khvymax = kiron)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3,
     3  k0s = 4,  k0l= 5,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.





c
c	(->	------------------------------------------

	integer Charge2heavyG	!2  charge of heavy $\rightarrow$  heavy group index conversion array.
        integer HeavyG2massN    !2  heavy group index $\rightarrow$     mass number conversion array.
	integer HeavyG2charge	!2  heavy group index $\rightarrow$     charge of heavy conversion array.
        integer HeavyG2code     !2  heavy group index $\rightarrow$     particle code conversion array.
        integer Code2massN      !2  particle code $\rightarrow$     mass number conversion array.
        integer Code2heavyG	!2  particle code $\rightarrow$     heavy group index conversion array.
        real*8  FragmentTbl	!2  tbl(i,j)=$<$Number$>$  of frag. j when a heavy of heavy group index i
                                !    breaks up at air.
        real*8  PtAvNonInteNuc  !2  $<$Pt$>$  of non interacting nucleons.
	real*8  PtAvFrag        !2  $<$Pt$>$  of heavy fragments.
	character*4 HeavyG2symbol !2   heavy group index $\rightarrow$  'Fe' etc conversion array.
	 integer HowIntNuc       !2 If 0, the  number of interacting nucleons among a projectile heavy nucleus is 
                                 !  determined as the number of first collision of each interacting nucleon inside 
                                ! the  nucleus.  If 1, the number is determined as the total number of collisions 
                                !   including successive interactions. Default is 1. (There is uncertaninity in
                                !  interpretation of the formula; value 1 gives larger number of interacting
                                !  nucleons.)


 
c	<-)	--------------------------------------
        

	common /Zheavyc/
     *   PtAvNonInteNuc, PtAvFrag,
     *   FragmentTbl(maxHeavyG, maxHeavyG), 
     *	 Charge2heavyG(maxHeavyCharge),
     *   HeavyG2massN(maxHeavyG), HeavyG2charge(maxHeavyG),
     *   HeavyG2code(maxHeavyG), Code2massN(khvymax),
     *   Code2heavyG(khvymax), HowIntNuc
        common /Zheavycc/ HeavyG2symbol(maxHeavyG)



	
         integer code, massn
         character*70  msg
c
c
c         if(code .ge. kdeut .and. code .le. khvymax) then
         if(code .ge. kalfa .and. code .le. khvymax) then
            massn = Code2massN(code)
         else
            write(msg, *) 'error input code=',code,' to cghvm'
            call cerrorMsg(msg, 0)
         endif
       end
c     ****************************************************
c           get particle id 
      subroutine cgpid(code, id)
c           get partilce id in character
c        code: Integer. Input.  particle code defined in COSMOS          
c          id: Character*8. Output. partcle id
         implicit none
c----         include '../Zcode.h'
c             ptcl kind code; kindmx is the no. of observable ptcls
c             klast; max ptcl code in the system.
c
        integer  kphoton, kelec, kmuon, kpion,  kkaon, knuc,
     1  kneue, kneumu, kindmx, knnb, kddb, kdmes, krho,
     2  komega, kphi, keta, kgnuc, kalfa, klibe, kcno, khvy, kvhvy,
     3  kiron, khvymax, klast, klambda, ksigma, kgzai, kbomega,
     4  ktriton, klambdac, krare
c            subcode
        integer
     1  regptcl, antip, k0s,  k0l, kneutron, 
     4  kneutronb, kd0, kd0b, kdirectg, kcasg

c
        parameter(
     1  kphoton=1, kelec=2, kmuon=3, kpion=4,  kkaon=5,
     2  knuc=6,
     3  kneue=7, kneumu=8, kgnuc=9, kalfa=10, klibe=11, kcno=12, 
     4  khvy=13, kvhvy=14, kiron=15, kdmes=16, 
c          next line added Nov. 17,'95. 
     5  ktriton=17, klambda=18, ksigma=19, kgzai=20, klambdac=21,
     6  kbomega=22,  kindmx=kbomega, krare = 0,

     7  knnb=kindmx+1, kddb=knnb+1,  krho=kddb+1,
     8  komega=krho+1, kphi=komega+1, keta=kphi+1,
     9  klast=keta, khvymax = kiron)
        parameter(
     1  regptcl=-1, antip=1,
     2  kdirectg=2, kcasg=3,
     3  k0s = 4,  k0l= 5,
     4  kneutron=regptcl,
     5  kneutronb = antip, kd0 =-8, kd0b =-kd0)
c
	integer maxHeavyMassN, maxHeavyCharge, maxHeavyG
	parameter (maxHeavyMassN = 56, maxHeavyCharge = 26, 
     1             maxHeavyG = 7)
c       kphoton: gamma ray 
c        kelec: electron, positiron
c        kmuon: muon
c        kpion: pion
c        kkaon: kaon
c        knuc: neucleon
c        kneue: electron neutrino
c       kneumu: muon neutrino
c        kgnuc: general nucleus(A>=2.)
c        kalfa: alpha  (heliunm)
c        klibe: Li, Be, B
c         kcno: C, N, O 
c         khvy: heavy such as, Na/Mg/Si
c        kvhvy: very heavy such as S/Cl/Ar
c        kiron: iron group
c        regptcl: particle index
c        antip: anti-particle index
c        krare:  used to set very rare particle code
c                which might come from imported soft.
c                such as tau. They are neglected in
c                Cosmos.





         integer code
         character*8 id
c
         character*70  msg
         character*8 ida(klast)
         data ida(kphoton)/'photon'/, ida(keta)/'Eta'/,
     *        ida(kelec)/'Electron'/, ida(kmuon)/'Muon'/,
     *        ida(kpion)/'Pion'/,     ida(kkaon)/'Kaon'/,
     *        ida(knuc)/'Nucleon'/,   ida(kneue)/'Nue_e'/,
     *        ida(kneumu)/'Nue_mu'/,  ida(knnb)/'NN~'/,
     *        ida(kddb)/'DD~'/,        ida(kdmes)/'D_meson'/,
     *        ida(krho)/'Rho'/,       ida(komega)/'omega'/,
     *        ida(kphi)/'Phi'/,  ida(kgnuc)/'Nucleus'/
c     *        ida(kphi)/'Phi'/,  ida(kdeut)/'deuteron'/
c                heavy neucleus
         data ida(kalfa)/'Helium'/, ida(klibe)/'LiBiB'/,
     *        ida(kcno)/'CNO'/, ida(khvy)/'NaMgSi'/,
     *        ida(kvhvy)/'SClAr'/, ida(kiron)/'Fe'/
         data ida(ksigma)/'sigma'/, ida(klambda)/'lambda'/,
     *   ida(kgzai)/'gzai'/, ida(klambdac)/'lambdac'/,
     *   ida(kbomega)/'Omega'/
c


         if(code .ge. 1 .and. code .le. klast)then
              id = ida(code)
         else
              write(msg, *) ' code=',code,' invalid to cgpid'
              call  cerrorMsg(msg,  0)
         endif
      end
c        ------------------------------------------
      subroutine cprptc(p, n)
c           print /ptcl/ strucuture; debug purpose
c      
c----      include '../Zptcl.h'




c    structure defining a particle at production
c         Basic idea of what is to be contained in 
c         the particle structue is that
c        1) dynamical ones should be included
c        2) those derivable from the particle code
c           is not included 
c     ******************************************************
      structure /fmom/     ! 4 momentum

          union
              map

                  real*8 p(4)

              endmap    
              map
                  real*8 px, py, pz, e
              endmap
              map
                  real*8  x, y, z, t
              endmap
              map
c                         pt before pz is set
                  real*8  dummy1, dummy2, pt, rap
              endmap
c                                tm: transverse mass
              map
                  real*8  dummy3, dummy4, tm
              endmap
          endunion   

      end structure   
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c       Important note:   Bug in sun fortran
c           If we define, say,
c                 record /fmom/ p1
c           and set
c                 p1.e = some value (or p1.p(4)= ...)
c           where some value is a constant or arithmetic
c           expression which results in a value > 1.d37
c           then overflow message comes out on SUN fortran
c           although the result is correct.
c           Setting the same into, say, p1.px does not
c           cause such. (as of 1993/08/14)
c     \/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/
c     ******************************************************
      structure /ptcl/       ! particle at production
c                   4 momentum. 
          record /fmom/ fm 
c
          real*8 mass
          integer*2 code, subcode  
          integer*2 charge
c       code: ptcl code
c    subcode:used mainly to identify paticle/antiparticle
c            if the difference is important.
c            To set particle, "ptcl" is used.
c                   anti-partilce, 'antip" is used for particles
c           For particles of which partilce/antiparticle nature
c            can be judded by its code and charge, the user 
c            need not specify it when using cmkptc subroutine.
c            give 0.
c            subcode for gamma ray may be used to identify
c            brems gamma and direct gamma by kdiretg, kcasg
      end structure   
c     ******************************************************
      record /ptcl/ p(n)
c
      integer i, j, code
      character*8 id
      character*80 msg

c
      do i=1, n
         code = p(i).code
         call cgpid(code, id)
         write(msg, *) ' ---------code=',p(i).code, ' id=', id
         call cerrorMsg(msg, 1)
         write(msg, *) ' 4 momentum=',(p(i).fm.p(j),j=1, 4), ' mass=',
     *               p(i).mass
         call cerrorMsg(msg, 1)
         write(msg, *) ' charge=', p(i).charge, ' subcode=',
     *    p(i).subcode
         call cerrorMsg(msg, 1)
      enddo   
      end





