c         test kpolintp, kpolintpFE
c
c      implicit none
c      integer n
c      parameter (n = 20)
c      real*8 xa(n), ya(n), x, y, error
c      integer i,  m
c
c     do i = 1, n
c         xa(i) = i/3.d0
c         ya(i) = exp(xa(i))
c      enddo
c      m = 5   ! use m points around x.
c      do i =1, n
c         x = xa(i) - 0.2
c         call kpolintpFE(xa, 1, ya, 1, n, m, x, y, error)
c         write(*, *) x, exp(x), y, error
c      enddo
c      end
      subroutine kpolintpFE(xa, xstep, ya, ystep, nt, m,  x, y, error)
      implicit none
c        This is a front end for kpolintp for which we must give
c     some few to several points around x. This manages such 
c     business automatically.
c
      integer xstep ! input.   see below
      integer nt    ! input.   total number of points 
      integer m     ! input.   the number of points to be used
                    !          for interpolation. must be <=10.
      real*8 xa(xstep, nt)  ! input. values of x-coordinate at xa(1, i)
                           !        (i=1, nt) are valid x data.
      integer ystep ! input.  see below
      real*8 ya(ystep, nt)  ! input. values of y-coordinate at ya(1, i)
                           !       (i=1, nt) are valid y data.
      real*8 x             ! input. x-value where an interpolated y
                           !        value is wanted
      real*8 y             ! output. see above
      real*8 error         ! output. estimated error. if -1.e30.  degenerate x


      integer  loc, k

c          find location of  x  in xa
      call kdwhereis(x, nt, xa, xstep,  loc)
      k = min(max(loc - (m-1)/2,1), nt+1-m) ! max of m points from k
      call kpolintp(xa(1, k), xstep, ya(1, k), ystep, m, x, y, error)
      if(error .gt. 1.d29 ) then
         y =ya(1, loc)
      endif
      end


      subroutine kpolintp(xa, xstep, ya, ystep, n,  x, y, error)
c   
c      integer   n. input. number of points.   
c      real*8   xa(xstep, n). input.
c      real*8   ya(ystep, n). input.  function values at xa.
c      real*8   x.  input.
c      real*8   y.  output.  interepolated functon value at x.
c      real*8  error. output. estiamted rough error.
c
      implicit none
      integer n, xstep, ystep
      real*8 xa(xstep, n), ya(ystep, n), x, y, error

      integer i, maxm
      parameter (maxm = 10)
      real*8  c(maxm), d(maxm), diff, difft

      integer ns,  m
      real*8 h0, hp, w, den


      if(n .gt. maxm) then
         write(*, *) ' kpolintp: use lesser number of points'
         stop
      endif

      ns = 1      
      diff = abs(x - xa(1, 1))
      do i = 1, n
         difft= abs(x - xa(1, i))
         if(difft .le. diff) then
            ns = i
            diff = difft
         endif
         c(i) = ya(1, i)
         d(i) = ya(1, i)
      enddo
      y = ya(1, ns)

      ns = ns-1
      do m = 1, n-1
         do i=1, n-m
            h0 = xa(1,i) -x
            hp = xa(1, i+m) - x
            w = c(i+1) - d(i)
            den = h0- hp

            if( abs(den) .gt. 1.d-10) then
               den = w/den
               if( abs(den) .gt. 1.d10)  then
                  error = 1.d30
                  return  ! **********************
               endif
               d(i) = hp*den
               c(i) = h0*den
            else
cc               write(0,*)  ' error in kpolintp'
cc               stop
               error = 1.d30
               return   ! ****************
            endif
         enddo
         if(2*ns .le. n-m) then
            error = c(ns+1)
         else
            error = d(ns)
            ns = ns-1
         endif
         y = y + error
      enddo
      end

      subroutine kpolintpeqs(x0, dx, ya, ystep, n,  x, y, error)
c   
c      integer   n. input. number of points.   
c      real*8   x0. input. x0, x0+dx, x0+2dx, ...x0+(n-1)dx
c                          are given data points
c      real*8   ya(ystep,n)  input.  function values at x0,..
c      real*8   x.  input.
c      real*8   y.  output.  interepolated functon value at x.
c      real*8  error. output. estiamted rough error.
c
      implicit none
      integer n,  ystep
      real*8 x0,  ya(ystep, n), x, y, error, dx

      integer i, maxm
      parameter (maxm = 10)
      real*8  c(maxm), d(maxm), diff, difft

      integer ns,  m
      real*8 h0, hp, w, den
      integer p, q
      real*8 xa
      xa(p, q) = (q-1)*dx + x0

      if(n .gt. maxm) then
         write(*, *)
     *    ' kpolintpeqs: use lesser number of points'
         stop
      endif
      ns = 1      
      diff = abs(x - xa(1, 1))
      do i = 1, n
         difft= abs(x - xa(1, i))
         if(difft .le. diff) then
            ns = i
            diff = difft
         endif
         c(i) = ya(1, i)
         d(i) = ya(1, i)
      enddo
      y = ya(1, ns)
      ns = ns-1
      do m = 1, n-1
         do i=1, n-m
            h0 = xa(1,i) -x
            hp = xa(1, i+m) - x
            w = c(i+1) - d(i)
            den = h0- hp
            if(den .eq. 0.) then
c               write(0,*) ' error in kpolintpeqs'
c               stop
               error = 1.e30
               return
            endif
            den = w/den
            d(i) = hp*den
            c(i) = h0*den
         enddo
         if(2*ns .le. n-m) then
            error = c(ns+1)
         else
            error = d(ns)
            ns = ns-1
         endif
         y = y + error
      enddo
      end
