



c   dpmjet cannot be used on NEXTSTEP, so
c   you have to make the next 0. 



c            make DEBUG > 0 depending on the debug purpose. 


c
c   choose:    Old atmosphere or new segmented atmosphere
c            define 
c               old atmosphere --> 0
c           or  new with c-spline
c               new atmosphere --> 1
c           or  new with linear interp.
c               new atmosphere --> 2


c     if you want to put a lable on each particle to identify that
c     the one and the same particle crosses a given observation
c     plane more than once, make this 1 or 2.  Then the same particle
c     will have the  same label number in track record.
c     ( aTrack.label ).  If this is 0, aTrack.lable record dose not
c     exists. 
c     If 1; after any interaction (except for continuous energy
c     loss by dE/dx and deflection by B or scattering), label is
c     changed.
c     If 2: For knockon and Bremstrahlung, the survival particle
c     will have the same label. In the case of Moller scattring
c     higher enregy electrons are regarded as the survival one.
c

c     if you want to have a detailed info. for particle tracking
c     make the below >=1.  The user observation routine is called
c     with the following id  on the following  conditions:
c              chookobs(a, id)
c     1)  if it is >=1,  a particle is going to interact at a point given in
c         the track information, id=4
c     2)  if it is >=1,  a particle is going to die, id=5
c     3)  if it is >=2,  a particle is being discarded due to the large
c          angle (cos(angle relative to the parent) > BackAngLimit). id=6
c     4)  if it is >=3,  a particle makes a step. id=7
c        







c
c    +-------------------------------------------------------------+
c    |                                                             |
c    |                                                             |
c    |                        DPMJET 3.0                           |
c    |                                                             |
c    |                                                             |
c    |         S. Roesler+), R. Engel#), J. Ranft*)                |
c    |                                                             |
c    |         +) SLAC, M.S.48, P.O.Box 4349                       |
c    |            Stanford, CA 94309, USA                          |
c    |            Email: Stefan.Roesler@cern.ch                    |
c    |                                                             |
c    |         #) University of Delaware, BRI                      |
c    |            Newark, DE 19716, USA                            |
c    |                                                             |
c    |         *) University of Siegen, Dept. of Physics           |
c    |            D-57068 Siegen, Germany                          |
c    |                                                             |
c    |                                                             |
c    |       http://home.cern.ch/sroesler/dpmjet3.html             |
c    |                                                             |
c    |                                                             |
c    |       Monte Carlo models used for event generation:         |
c    |          PHOJET 1.12, JETSET 7.4 and LEPTO 6.5.1            |
c    |                                                             |
c    +-------------------------------------------------------------+
c
c
c===init===============================================================*
c
CDECK  ID>, DT_INIT
      SUBROUTINE DT_INIT(NCASES,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,
     &                                             IDP,IGLAU)

c***********************************************************************
c Initialization of event generation                                   *
c This version dated  7.4.98  is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE

      PARAMETER (LIN=5,LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c names of hadrons used in input-cards
      CHARACTER*8 BTYPE
      COMMON /DTPAIN/ BTYPE(30)

c (original name: PAREVT)
      LOGICAL LDIFFR, LINCTV, LEVPRT, LHEAVY, LDEEXG, LGDHPR, LPREEX,
     &        LHLFIX, LPRFIX, LPARWV, LPOWER, LSNGCH, LLVMOD, LSCHDF
      PARAMETER ( NALLWP = 39   )
      COMMON /FKPARE/ DPOWER, FSPRD0, FSHPFN, RN1GSC, RN2GSC,
     &                LDIFFR (NALLWP),LPOWER, LINCTV, LEVPRT, LHEAVY,
     &                LDEEXG, LGDHPR, LPREEX, LHLFIX, LPRFIX, LPARWV,
     &                ILVMOD, JLVMOD, LLVMOD, LSNGCH, LSCHDF

c (original name: INPFLG)
      COMMON /FKINPF/ IANG,IFISS,IB0,IGEOM,ISTRAG,KEYDK

c (original name: FRBKCM)
      PARAMETER ( MXFFBK =     6 )
      PARAMETER ( MXZFBK =     9 )
      PARAMETER ( MXNFBK =    10 )
      PARAMETER ( MXAFBK =    16 )
      PARAMETER ( NXZFBK = MXZFBK + MXFFBK / 3 )
      PARAMETER ( NXNFBK = MXNFBK + MXFFBK / 3 )
      PARAMETER ( NXAFBK = MXAFBK + 1 )
      PARAMETER ( MXPSST =   300 )
      PARAMETER ( MXPSFB = 41000 )
      LOGICAL LFRMBK, LNCMSS
      COMMON /FKFRBK/  AMUFBK, EEXFBK (MXPSST), AMFRBK (MXPSST),
     &          EXFRBK (MXPSFB), SDMFBK (MXPSFB), COUFBK (MXPSFB),
     &          EXMXFB, R0FRBK, R0CFBK, C1CFBK, C2CFBK,
     &          IFRBKN (MXPSST), IFRBKZ (MXPSST),
     &          IFBKSP (MXPSST), IFBKPR (MXPSST), IFBKST (MXPSST),
     &          IPSIND (0:MXNFBK,0:MXZFBK,2), JPSIND (0:MXAFBK),
     &          IFBIND (0:NXNFBK,0:NXZFBK,2), JFBIND (0:NXAFBK),
     &          IFBCHA (5,MXPSFB), IPOSST, IPOSFB, IFBSTF,
     &          IFBFRB, NBUFBK, LFRMBK, LNCMSS

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c interface HADRIN-DPM
      COMMON /HNTHRE/ EHADTH,EHADLO,EHADHI,INTHAD,IDXTA

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT

c threshold values for x-sampling (DTUNUC 1.x)
      COMMON /DTXCUT/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     &                SSMIMQ,VVMTHR

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c n-n cross section fluctuations
      PARAMETER (NBINS = 1000)
      COMMON /DTXSFL/ FLUIXX(NBINS),IFLUCT

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c parameters for hA-diffraction
      COMMON /DTDIHA/ DIBETA,DIALPH

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c kinematical cuts for lepton-nucleus interactions
      COMMON /DTLCUT/ ECMIN,ECMAX,XBJMIN,ELMIN,EGMIN,EGMAX,YMIN,YMAX,
     &                Q2MIN,Q2MAX,THMIN,THMAX,Q2LI,Q2HI,ECMLI,ECMHI

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c cuts for variable energy runs
      COMMON /DTVARE/ VARELO,VAREHI,VARCLO,VARCHI

c flags for activated histograms
      COMMON /DTHIS3/ IHISPP(50),IHISXS(50),IXSTBL


      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      COMMON/PYDAT3/MDCY(500,3),MDME(4000,2),BRAT(4000),KFDP(4000,5)


c LEPTO
c*LUND single / double precision
      REAL CUT,PARL,TMPX,TMPY,TMPW2,TMPQ2,TMPU
      COMMON /LEPTOU/ CUT(14),LST(40),PARL(30),
     &                TMPX,TMPY,TMPW2,TMPQ2,TMPU

c LEPTO
      REAL RPPN
      COMMON /LEPTOI/ RPPN,LEPIN,INTER

c steering flags for qel neutrino scattering modules
      COMMON /QNEUTO/ DSIGSU,DSIGMC,NDSIG,NEUTYP,NEUDEC



      INTEGER PYCOMP


C     DIMENSION XPARA(5)
      DIMENSION XDUMB(40),IPRANG(5)

      PARAMETER (MXCARD=58)
      CHARACTER*78 CLINE,CTITLE
      CHARACTER*60 CWHAT
      CHARACTER*8  BLANK,SDUM
      CHARACTER*10 CODE,CODEWD
      CHARACTER*72 HEADER
      LOGICAL LSTART,LEINP,LXSTAB
      DIMENSION WHAT(6),CODE(MXCARD)
      DATA CODE/
     &   'TITLE     ','PROJPAR   ','TARPAR    ','ENERGY    ',
     &   'MOMENTUM  ','CMENERGY  ','EMULSION  ','FERMI     ',
     &   'TAUFOR    ','PAULI     ','COULOMB   ','HADRIN    ',
     &   'EVAP      ','EMCCHECK  ','MODEL     ','PHOINPUT  ',
     &   'GLAUBERI  ','FLUCTUAT  ','CENTRAL   ','RECOMBIN  ',
     &   'COMBIJET  ','XCUTS     ','INTPT     ','CRONINPT  ',
     &   'SEADISTR  ','SEASU3    ','DIQUARKS  ','RESONANC  ',
     &   'DIFFRACT  ','SINGLECH  ','NOFRAGME  ','HADRONIZE ',
     &   'POPCORN   ','PARDECAY  ','BEAM      ','LUND-MSTU ',
     &   'LUND-MSTJ ','LUND-MDCY ','LUND-PARJ ','LUND-PARU ',
     &   'OUTLEVEL  ','FRAME     ','L-TAG     ','L-ETAG    ',
     &   'ECMS-CUT  ','VDM-PAR1  ','HISTOGRAM ','XS-TABLE  ',
     &   'GLAUB-PAR ','GLAUB-INI ','VDM-PAR2  ','XS-QELPRO ',
     &   'RNDMINIT  ','LEPTO-CUT ','LEPTO-LST ','LEPTO-PARL',
     &   'START     ','STOP      '/
      DATA BLANK /'        '/

      DATA LSTART,LXSTAB,IFIRST /.TRUE.,.FALSE.,1/
      DATA CMEOLD /0.0D0/

c---------------------------------------------------------------------
c at the first call of INIT: initialize event generation
      IF (LSTART) THEN
         CALL DT_TITLE
c   initialization and test of the random number generator
         CALL DT_RNDMST(22,54,76,92)
         CALL DT_RNDMTE(1)
c   initialization of BAMJET, DECAY and HADRIN
         CALL DT_DDATAR
         CALL DT_DHADDE
         CALL DT_DCHANT
         CALL DT_DCHANH
c   set default values for input variables
         CALL DT_DEFAUL(EPN,PPN)
         IGLAU  = 0
         IXSQEL = 0
c   flag for collision energy input
         LEINP  = .FALSE.
         LSTART = .FALSE.
      ENDIF

c---------------------------------------------------------------------
   10 CONTINUE

c read control card from input-unit LIN
      READ(TempDev,'(A78)',END=9999) CLINE
      IF (CLINE(1:1).EQ.'*') THEN
c comment-line
         WRITE(ErrorOut,'(A78)') CLINE
         GOTO 10
      ENDIF
C     READ(CLINE,1000,END=9999) CODEWD,(WHAT(I),I=1,6),SDUM
C1000 FORMAT(A10,6E10.0,A8)
      DO 1008 I=1,6
         WHAT(I) = ZERO
 1008 CONTINUE
      READ(CLINE,1006,END=9999) CODEWD,CWHAT,SDUM
 1006 FORMAT(A10,A60,A8)
      READ(CWHAT,*,END=1007) (WHAT(I),I=1,6)
 1007 CONTINUE
      WRITE(ErrorOut,1001) CODEWD,(WHAT(I),I=1,6),SDUM
 1001 FORMAT(A10,6G10.3,A8)

c check for valid control card and get card index
      ICW = 0
      DO 11 I=1,MXCARD
         IF (CODEWD.EQ.CODE(I)) ICW = I
   11 CONTINUE
      IF (ICW.EQ.0) THEN
         WRITE(ErrorOut,1002) CODEWD
 1002    FORMAT(/,1X,'---> ',A10,': INVALID CONTROL-CARD !',/)
         GOTO 10
      ENDIF

      GOTO(
c------------------------------------------------------------
c       TITLE   ,  PROJPAR ,  TARPAR  ,  ENERGY  ,  MOMENTUM,
     &  100     ,  110     ,  120     ,  130     ,  140     ,
c
c------------------------------------------------------------
c       CMENERGY,  EMULSION,  FERMI   ,  TAUFOR  ,  PAULI   ,
     &  150     ,  160     ,  170     ,  180     ,  190     ,
c
c------------------------------------------------------------
c       COULOMB ,  HADRIN  ,  EVAP    ,  EMCCHECK,  MODEL   ,
     &  200     ,  210     ,  220     ,  230     ,  240     ,
c
c------------------------------------------------------------
c       PHOINPUT,  GLAUBERI,  FLUCTUAT,  CENTRAL ,  RECOMBIN,
     &  250     ,  260     ,  270     ,  280     ,  290     ,
c
c------------------------------------------------------------
c       COMBIJET,  XCUTS   ,  INTPT   ,  CRONINPT,  SEADISTR,
     &  300     ,  310     ,  320     ,  330     ,  340     ,
c
c------------------------------------------------------------
c       SEASU3  ,  DIQUARKS,  RESONANC,  DIFFRACT,  SINGLECH,
     &  350     ,  360     ,  370     ,  380     ,  390     ,
c
c------------------------------------------------------------
c       NOFRAGME, HADRONIZE,  POPCORN ,  PARDECAY,  BEAM    ,
     &  400     ,  410     ,  420     ,  430     ,  440     ,
c
c------------------------------------------------------------
c      LUND-MSTU, LUND-MSTJ, LUND-MDCY, LUND-PARJ, LUND-PARU,
     &  450     ,  451     ,  452     ,  460     ,  470     ,
c
c------------------------------------------------------------
c       OUTLEVEL,  FRAME   , L-TAG    ,  L-ETAG  ,  ECMS-CUT,
     &  480     ,  490     ,  500     ,  510     ,  520     ,
c
c------------------------------------------------------------
c       VDM-PAR1, HISTOGRAM, XS-TABLE , GLAUB-PAR, GLAUB-INI,
     &  530     ,  540     ,  550     ,  560     ,  565     ,
c
c------------------------------------------------------------
c               ,          ,  VDM-PAR2, XS-QELPRO, RNDMINIT ,
     &                        570     ,  580     ,  590     ,
c
c------------------------------------------------------------
c      LEPTO-CUT, LEPTO-LST,LEPTO-PARL,  START   ,  STOP    )
     &  600     ,  610     ,  620     ,  630     ,  640     ) , ICW
c
c------------------------------------------------------------

      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = TITLE                       *
c                                                                   *
c       what (1..6), sdum   no meaning                              *
c                                                                   *
c       Note:  The control-card following this must consist of      *
c              a string of characters usually giving the title of   *
c              the run.                                             *
c                                                                   *
c********************************************************************

  100 CONTINUE
      READ(TempDev,'(A78)') CTITLE
      WRITE(ErrorOut,'(//,5X,A78,//)') CTITLE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = PROJPAR                     *
c                                                                   *
c       what (1) =  mass number of projectile nucleus  default: 1   *
c       what (2) =  charge of projectile nucleus       default: 1   *
c       what (3..6)   no meaning                                    *
c       sdum        projectile particle code word                   *
c                                                                   *
c       Note: If sdum is defined what (1..2) have no meaning.       *
c                                                                   *
c********************************************************************

  110 CONTINUE
      IF (SDUM.EQ.BLANK) THEN
         IP     = INT(WHAT(1))
         IPZ    = INT(WHAT(2))
         IJPROJ = 1
         IBPROJ = 1
      ELSE
         IJPROJ = 0
         DO 111 II=1,30
            IF (SDUM.EQ.BTYPE(II)) THEN
               IP     = 1
               IPZ    = 1
               IF (II.EQ.26) THEN
                  IJPROJ = 135
               ELSEIF (II.EQ.27) THEN
                  IJPROJ = 136
               ELSEIF (II.EQ.28) THEN
                  IJPROJ = 133
               ELSEIF (II.EQ.29) THEN
                  IJPROJ = 134
               ELSE
                  IJPROJ = II
               ENDIF
               IBPROJ = IIBAR(IJPROJ)
c photon
               IF ((IJPROJ.EQ.7).AND.(WHAT(1).GT.ZERO)) VIRT = WHAT(1)
c lepton
               IF (((IJPROJ.EQ. 3).OR.(IJPROJ.EQ. 4).OR.
     &              (IJPROJ.EQ.10).OR.(IJPROJ.EQ.11)).AND.
     &                              (WHAT(1).GT.ZERO)) Q2HI = WHAT(1)
            ENDIF
  111    CONTINUE
         IF (IJPROJ.EQ.0) THEN
            WRITE(ErrorOut,1110)
 1110       FORMAT(/,1X,'INVALID PROJPAR CARD !',/)
            GOTO 9999
         ENDIF
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = TARPAR                      *
c                                                                   *
c       what (1) =  mass number of target nucleus      default: 1   *
c       what (2) =  charge of target nucleus           default: 1   *
c       what (3..6)   no meaning                                    *
c       sdum        target particle code word                       *
c                                                                   *
c       Note: If sdum is defined what (1..2) have no meaning.       *
c                                                                   *
c********************************************************************

  120 CONTINUE
      IF (SDUM.EQ.BLANK) THEN
         IT     = INT(WHAT(1))
         ITZ    = INT(WHAT(2))
         IJTARG = 1
         IBTARG = 1
      ELSE
         IJTARG = 0
         DO 121 II=1,30
            IF (SDUM.EQ.BTYPE(II)) THEN
               IT     = 1
               ITZ    = 1
               IJTARG = II
               IBTARG = IIBAR(IJTARG)
            ENDIF
  121    CONTINUE
         IF (IJTARG.EQ.0) THEN
            WRITE(ErrorOut,1120)
 1120       FORMAT(/,1X,'INVALID TARPAR CARD !',/)
            GOTO 9999
         ENDIF
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = ENERGY                      *
c                                                                   *
c       what (1) =  energy (GeV) of projectile in Lab.              *
c                   if what(1) < 0:  |what(1)| = kinetic energy     *
c                                                default: 200 GeV   *
c                   if |what(2)| > 0: min. energy for variable      *
c                                     energy runs                   *
c       what (2) =  max. energy for variable energy runs            *
c                   if what(2) < 0:  |what(2)| = kinetic energy     *
c                                                                   *
c********************************************************************

  130 CONTINUE
      EPN    = WHAT(1)
      PPN    = ZERO
      CMENER = ZERO
      IF ((ABS(WHAT(2)).GT.ZERO).AND.
     &    (ABS(WHAT(2)).GT.ABS(WHAT(1)))) THEN
         VARELO = WHAT(1)
         VAREHI = WHAT(2)
         EPN    = VAREHI
      ENDIF
      LEINP  = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = MOMENTUM                    *
c                                                                   *
c       what (1) =  momentum (GeV/c) of projectile in Lab.          *
c                                                default: 200 GeV/c *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  140 CONTINUE
      EPN    = ZERO
      PPN    = WHAT(1)
      CMENER = ZERO
      LEINP  = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = CMENERGY                    *
c                                                                   *
c       what (1) =  energy in nucleon-nucleon cms.                  *
c                                                default: none      *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  150 CONTINUE
      EPN    = ZERO
      PPN    = ZERO
      CMENER = WHAT(1)
      LEINP  = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = EMULSION                    *
c                                                                   *
c               definition of nuclear emulsions                     *
c                                                                   *
c     what(1)      mass number of emulsion component                *
c     what(2)      charge of emulsion component                     *
c     what(3)      fraction of events in which a scattering on a    *
c                  nucleus of this properties is performed          *
c     what(4,5,6)  as what(1,2,3) but for another component         *
c                                             default: no emulsion  *
c     sdum         no meaning                                       *
c                                                                   *
c     Note: If this input-card is once used with valid parameters   *
c           TARPAR is obsolete.                                     *
c           Not the absolute values of the fractions are important  *
c           but only the ratios of fractions of different comp.     *
c           This control card can be repeatedly used to define      *
c           emulsions consisting of up to 10 elements.              *
c                                                                   *
c********************************************************************

  160 CONTINUE
      IF ((WHAT(1).GT.ZERO).AND.(WHAT(2).GT.ZERO)
     &                     .AND.(ABS(WHAT(3)).GT.ZERO)) THEN
         NCOMPO = NCOMPO+1
         IF (NCOMPO.GT.NCOMPX) THEN
            WRITE(ErrorOut,1600)
            STOP
         ENDIF
         IEMUMA(NCOMPO) = INT(WHAT(1))
         IEMUCH(NCOMPO) = INT(WHAT(2))
         EMUFRA(NCOMPO) = WHAT(3)
         IEMUL = 1
C        CALL SHMAKF(IDUM,IDUM,IEMUMA(NCOMPO),IEMUCH(NCOMPO))
      ENDIF
      IF ((WHAT(4).GT.ZERO).AND.(WHAT(5).GT.ZERO)
     &                     .AND.(ABS(WHAT(6)).GT.ZERO)) THEN
         NCOMPO = NCOMPO+1
         IF (NCOMPO.GT.NCOMPX) THEN
            WRITE(ErrorOut,1001)
            STOP
         ENDIF
         IEMUMA(NCOMPO) = INT(WHAT(4))
         IEMUCH(NCOMPO) = INT(WHAT(5))
         EMUFRA(NCOMPO) = WHAT(6)
C        CALL SHMAKF(IDUM,IDUM,IEMUMA(NCOMPO),IEMUCH(NCOMPO))
      ENDIF
 1600 FORMAT(1X,'TOO MANY EMULSION COMPONENTS - PROGRAM STOPPED')
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = FERMI                       *
c                                                                   *
c       what (1) = -1 Fermi-motion of nucleons not treated          *
c                                                 default: 1        *
c       what (2) =    scale factor for Fermi-momentum               *
c                                                 default: 0.75     *
c       what (3..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  170 CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         LFERMI = .FALSE.
      ELSE
         LFERMI = .TRUE.
      ENDIF
      XMOD = WHAT(2)
      IF (XMOD.GE.ZERO) FERMOD = XMOD
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = TAUFOR                      *
c                                                                   *
c          formation time supressed intranuclear cascade            *
c                                                                   *
c    what (1)      formation time (in fm/c)                         *
c                  note: what(1)=10. corresponds roughly to an      *
c                        average formation time of 1 fm/c           *
c                                                 default: 5. fm/c  *
c    what (2)      number of generations followed                   *
c                                                 default: 25       *
c    what (3) = 1. p_t-dependent formation zone                     *
c             = 2. constant formation zone                          *
c                                                 default: 1        *
c    what (4)      modus of selection of nucleus where the          *
c                  cascade if followed first                        *
c             = 1.  proj./target-nucleus with probab. 1/2           *
c             = 2.  nucleus with highest mass                       *
c             = 3.  proj. nucleus if particle is moving in pos. z   *
c                   targ. nucleus if particle is moving in neg. z   *
c                                                 default: 1        *
c    what (5..6), sdum   no meaning                                 *
c                                                                   *
c********************************************************************

  180 CONTINUE
      TAUFOR = WHAT(1)
      KTAUGE = INT(WHAT(2))
      INCMOD = 1
      IF ((WHAT(3).GE.1.0D0).AND.(WHAT(3).LE.2.0D0))
     &                                    ITAUVE = INT(WHAT(3))
      IF ((WHAT(4).GE.1.0D0).AND.(WHAT(4).LE.3.0D0))
     &                                    INCMOD = INT(WHAT(4))
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = PAULI                       *
c                                                                   *
c       what (1) =  -1  Pauli's principle for secondary             *
c                       interactions not treated                    *
c                                                    default: 1     *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  190 CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         LPAULI = .FALSE.
      ELSE
         LPAULI = .TRUE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = COULOMB                     *
c                                                                   *
c       what (1) = -1. Coulomb-energy treatment switched off        *
c                                                    default: 1     *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  200 CONTINUE
      ICOUL = 1
      IF (WHAT(1).EQ.-1.0D0) THEN
         ICOUL = 0
      ELSE
         ICOUL = 1
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = HADRIN                      *
c                                                                   *
c                       HADRIN module                               *
c                                                                   *
c    what (1) = 0. elastic/inelastic interactions with probab.      *
c                  as defined by cross-sections                     *
c             = 1. inelastic interactions forced                    *
c             = 2. elastic interactions forced                      *
c                                                 default: 1        *
c    what (2)      upper threshold in total energy (GeV) below      *
c                  which interactions are sampled by HADRIN         *
c                                                 default: 5. GeV   *
c    what (3..6), sdum   no meaning                                 *
c                                                                   *
c********************************************************************

  210 CONTINUE
      IWHAT = INT(WHAT(1))
      IF ((IWHAT.GE.0).AND.(IWHAT.LE.2)) INTHAD = IWHAT
      IF ((WHAT(2).GT.ZERO).AND.(WHAT(2).LT.15.0D0)) EHADTH = WHAT(2)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = EVAP                        *
c                                                                   *
c                    evaporation module                             *
c                                                                   *
c  what (1) =< -1 ==> evaporation is switched off                   *
c           >=  1 ==> evaporation is performed                      *
c                                                                   *
c         what (1) = i1 + i2*10 + i3*100 + i4*10000                 *
c                    (i1, i2, i3, i4 >= 0 )                         *
c                                                                   *
c   i1 is the flag for selecting the T=0 level density option used  *
c      =  1: standard EVAP level densities with Cook pairing        *
c            energies                                               *
c      =  2: Z,N-dependent Gilbert & Cameron level densities        *
c                                                        (default)  *
c      =  3: Julich A-dependent level densities                     *
c      =  4: Z,N-dependent Brancazio & Cameron level densities      *
c                                                                   *
c   i2 >= 1: high energy fission activated                          *
c            (default high energy fission activated)                *
c                                                                   *
c   i3 =  0: No energy dependence for level densities               *
c      =  1: Standard Ignyatuk (1975, 1st) energy dependence        *
c            for level densities (default)                          *
c      =  2: Standard Ignyatuk (1975, 1st) energy dependence        *
c            for level densities with NOT used set of parameters    *
c      =  3: Standard Ignyatuk (1975, 1st) energy dependence        *
c            for level densities with NOT used set of parameters    *
c      =  4: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities                                    *
c      =  5: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities with fit 1 Iljinov & Mebel set of  *
c            parameters                                             *
c      =  6: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities with fit 2 Iljinov & Mebel set of  *
c            parameters                                             *
c      =  7: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities with fit 3 Iljinov & Mebel set of  *
c            parameters                                             *
c      =  8: Second   Ignyatuk (1975, 2nd) energy dependence        *
c            for level densities with fit 4 Iljinov & Mebel set of  *
c            parameters                                             *
c                                                                   *
c   i4 >= 1: Original Gilbert and Cameron pairing energies used     *
c            (default Cook's modified pairing energies)             *
c                                                                   *
c  what (2) = ig + 10 * if   (ig and if must have the same sign)    *
c                                                                   *
c   ig =< -1 ==> deexcitation gammas are not produced               *
c                (if the evaporation step is not performed          *
c                 they are never produced)                          *
c   if =< -1 ==> Fermi Break Up is not invoked                      *
c                (if the evaporation step is not performed          *
c                 it is never invoked)                              *
c   The default is: deexcitation gamma produced and Fermi break up  *
c                   activated for the new  preequilibrium, not      *
c                   activated otherwise.                            *
c  what (3..6), sdum   no meaning                                   *
c                                                                   *
c********************************************************************

 220  CONTINUE
      IF (WHAT(1).LE.-1.0D0) THEN
         LEVPRT = .FALSE.
         LDEEXG = .FALSE.
         LHEAVY = .FALSE.
         GOTO 10
      ENDIF
      WHTSAV = WHAT (1)
      IF ( NINT (WHAT (1)) .GE. 10000 ) THEN
         LLVMOD   = .FALSE.
         JLVHLP   = NINT (WHAT (1)) / 10000
         WHAT (1) = WHAT (1) - 10000.D+00 * JLVHLP
      END IF
      IF ( NINT (WHAT (1)) .GE. 100 ) THEN
         JLVMOD   = NINT (WHAT (1)) / 100
         WHAT (1) = WHAT (1) - 100.D+00 * JLVMOD
      END IF
      IF ( NINT (WHAT (1)) .GE. 10  ) THEN
         IFISS    = 1
         JLVHLP   = NINT (WHAT (1)) / 10
         WHAT (1) = WHAT (1) - 10.D+00 * JLVHLP
      ELSE IF ( NINT (WHTSAV) .NE. 0 ) THEN
         IFISS    = 0
      END IF
      IF ( NINT (WHAT (1)) .GE. 0 ) THEN
         LEVPRT = .TRUE.
         ILVMOD = NINT (WHAT(1))
         IF ( ABS (NINT (WHAT (2))) .GE. 10  ) THEN
            LFRMBK   = .TRUE.
            JLVHLP   = NINT (WHAT (2)) / 10
            WHAT (2) = WHAT (2) - 10.D+00 * JLVHLP
         ELSE IF ( NINT (WHAT (2)) .NE. 0 ) THEN
            LFRMBK   = .FALSE.
         END IF
         IF ( NINT (WHAT (2)) .GE. 0 ) THEN
            LDEEXG = .TRUE.
         ELSE
            LDEEXG = .FALSE.
         END IF
c*sr heavies are always put to /FKFHVY/
C        IF ( NINT (WHAT(3)) .GE. 1 ) THEN
C           LHEAVY = .TRUE.
C        ELSE
C           LHEAVY = .FALSE.
C        END IF
         LHEAVY = .TRUE.
      ELSE
         LEVPRT = .FALSE.
         LDEEXG = .FALSE.
         LHEAVY = .FALSE.
      END IF

      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = EMCCHECK                    *
c                                                                   *
c    extended energy-momentum / quantum-number conservation check   *
c                                                                   *
c       what (1) = -1   extended check not performed                *
c                                                    default: 1.    *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  230 CONTINUE
      IF (WHAT(1).EQ.-1) THEN
         LEMCCK = .FALSE.
      ELSE
         LEMCCK = .TRUE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = MODEL                       *
c                                                                   *
c     Model to be used to treat nucleon-nucleon interactions        *
c                                                                   *
c       sdum = DTUNUC    two-chain model                            *
c            = PHOJET    multiple chains including minijets         *
c            = LEPTO     DIS                                        *
c            = QNEUTRIN  quasi-elastic neutrino scattering          *
c                                                  default: PHOJET  *
c                                                                   *
c       if sdum = LEPTO:                                            *
c       what (1)         (variable INTER)                           *
c                        = 1  gamma exchange                        *
c                        = 2  W+-   exchange                        *
c                        = 3  Z0    exchange                        *
c                        = 4  gamma/Z0 exchange                     *
c                                                                   *
c       if sdum = QNEUTRIN:                                         *
c       what (1)         = 0  elastic scattering on nucleon and     *
c                             tau does not decay (default)          *
c                        = 1  decay of tau into mu..                *
c                        = 2  decay of tau into e..                 *
c                        = 10 CC events on p and n                  *
c                        = 11 NC events on p and n                  *
c                                                                   *
c       what (2..6)      no meaning                                 *
c                                                                   *
c********************************************************************

  240 CONTINUE
      IF (SDUM.EQ.CMODEL(1)) THEN
         MCGENE = 1
      ELSEIF (SDUM.EQ.CMODEL(2)) THEN
         MCGENE = 2
      ELSEIF (SDUM.EQ.CMODEL(3)) THEN
         MCGENE = 3
         IF ((WHAT(1).GE.1.0D0).AND.(WHAT(1).LE.4.0D0))
     &      INTER = INT(WHAT(1))
      ELSEIF (SDUM.EQ.CMODEL(4)) THEN
         MCGENE = 4
         IWHAT  = INT(WHAT(1))
         IF ((IWHAT.EQ.1 ).OR.(IWHAT.EQ.2 ).OR.
     &       (IWHAT.EQ.10).OR.(IWHAT.EQ.11))
     &      NEUDEC = IWHAT
      ELSE
         STOP ' UNKNOWN MODEL !'
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = PHOINPUT                    *
c                                                                   *
c       Start of input-section for PHOJET-specific input-cards      *
c       Note:  This section will not be finished before giving      *
c              ENDINPUT-card                                        *
c       what (1..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  250 CONTINUE
      IF (LPHOIN) THEN

         CALL PHO_INIT(TempDev,IREJ1)

         IF (IREJ1.NE.0) THEN
            WRITE(ErrorOut,
     * '(1X,A)')'INIT:   reading PHOJET-input failed'
            STOP
         ENDIF
         LPHOIN = .FALSE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = GLAUBERI                    *
c                                                                   *
c        Pre-initialization of impact parameter selection           *
c                                                                   *
c        what (1..6), sdum   no meaning                             *
c                                                                   *
c********************************************************************

  260 CONTINUE
      IF (IFIRST.NE.99) THEN
         CALL DT_RNDMST(12,34,56,78)
         CALL DT_RNDMTE(1)
         OPEN(40,FILE='OUTDATA0/SHM.OUT',STATUS='UNKNOWN')
C        OPEN(11,FILE='outdata0/shm.dbg',STATUS='UNKNOWN')
         IFIRST = 99
      ENDIF

      IPPN = 8
      PLOW = 10.0D0
C     IPPN = 1
C     PLOW = 100.0D0
      PHI  = 1.0D5
      APLOW = LOG10(PLOW)
      APHI  = LOG10(PHI)
      ADP   = (APHI-APLOW)/DBLE(IPPN)

      IPLOW = 1
      IDIP  = 1
      IIP   = 5
C     IPLOW = 1
C     IDIP  = 1
C     IIP   = 1
      IPRANG(1) = 1
      IPRANG(2) = 2
      IPRANG(3) = 5
      IPRANG(4) = 10
      IPRANG(5) = 20

      ITLOW = 30
      IDIT  = 3
      IIT   = 60
C     IDIT  = 10
C     IIT   = 21

      DO 473 NCIT=1,IIT
         IT   = ITLOW+(NCIT-1)*IDIT
C        IPHI = IT
C        IDIP = 10
C        IIP  = (IPHI-IPLOW)/IDIP
C        IF (IIP.EQ.0) IIP = 1
C        IF (IT.EQ.IPLOW) IIP = 0

         DO 472 NCIP=1,IIP
            IP = IPRANG(NCIP)
CC           IF (NCIP.LE.IIP) THEN
C               IP = IPLOW+(NCIP-1)*IDIP
CC           ELSE
CC              IP = IT
CC           ENDIF
            IF (IP.GT.IT) GOTO 472

            DO 471 NCP=1,IPPN+1
               APPN = APLOW+DBLE(NCP-1)*ADP
               PPN  = 10**APPN

               OPEN(12,FILE='OUTDATA0/SHM.STA',STATUS='UNKNOWN')
               WRITE(12,'(1X,2I5,E15.3)') IP,IT,PPN
               CLOSE(12)

               XLIM1 = 0.0D0
               XLIM2 = 50.0D0
               XLIM3 = ZERO
               IBIN  = 50
               CALL DT_NEWHGR(XDUM,XDUM,XDUM,XDUMB,-1,IHDUM)
               CALL DT_NEWHGR(XLIM1,XLIM2,XLIM3,XDUMB,IBIN,IHSHMA)

               NEVFIT = 5
C              IF ((IP.GT.10).OR.(IT.GT.10)) THEN
C                 NEVFIT = 5
C              ELSE
C                 NEVFIT = 10
C              ENDIF
               SIGAV  = 0.0D0

               DO 478 I=1,NEVFIT
                  CALL DT_SHMAKI(IP,IDUM1,IT,IDUM1,IJPROJ,PPN,99)
                  SIGAV = SIGAV+XSPRO(1,1,1)
                  DO 479 J=1,50
                     XC = DBLE(J)
                     CALL DT_FILHGR(XC,BSITE(1,1,1,J),IHSHMA,I)
  479             CONTINUE
  478          CONTINUE

               CALL DT_EVTHIS(IDUM)
               HEADER = ' BSITE'
C              CALL OUTGEN(IHSHMA,0,0,0,0,0,HEADER,0,NEVFIT,ONE,0,1,-1)

C              CALL GENFIT(XPARA)
C              WRITE(40,'(2I4,E11.3,F6.0,5E11.3)')
C    &              IP,IT,PPN,SIGAV/DBLE(NEVFIT),XPARA

  471       CONTINUE

  472    CONTINUE

  473 CONTINUE

      STOP

c********************************************************************
c                                                                   *
c               control card:  codewd = FLUCTUAT                    *
c                                                                   *
c           Treatment of cross section fluctuations                 *
c                                                                   *
c       what (1) = 1  treat cross section fluctuations              *
c                                                    default: 0.    *
c       what (1..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

 270  CONTINUE
      IFLUCT = 0
      IF (WHAT(1).EQ.ONE) THEN
         IFLUCT = 1
         CALL DT_FLUINI
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = CENTRAL                     *
c                                                                   *
c       what (1) = 1.  central production forced     default: 0     *
c  if what (1) < 0 and > -100                                       *
c       what (2) = min. impact parameter             default: 0     *
c       what (3) = max. impact parameter             default: b_max *
c  if what (1) < -99                                                *
c       what (2) = fraction of cross section         default: 1     *
c  if what (1) = -1 : evaporation/fzc suppressed                    *
c  if what (1) < -1 : evaporation/fzc allowed                       *
c                                                                   *
c       what (4..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  280 CONTINUE
      ICENTR = INT(WHAT(1))
      IF (ICENTR.LT.0) THEN
         IF (ICENTR.GT.-100) THEN
            BIMIN = WHAT(2)
            BIMAX = WHAT(3)
         ELSE
            XSFRAC = WHAT(2)
         ENDIF
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = RECOMBIN                    *
c                                                                   *
c                     Chain recombination                           *
c        (recombine S-S and V-V chains to V-S chains)               *
c                                                                   *
c       what (1) = -1. recombination switched off    default: 1     *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  290 CONTINUE
      IRECOM = 1
      IF (WHAT(1).EQ.-1.0D0) IRECOM = 0
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = COMBIJET                    *
c                                                                   *
c               chain fusion (2 q-aq --> qq-aqaq)                   *
c                                                                   *
c       what (1) = 1   fusion treated                               *
c                                                    default: 0.    *
c       what (2)       minimum number of uncombined chains from     *
c                      single projectile or target nucleons         *
c                                                    default: 0.    *
c       what (3..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  300 CONTINUE
      LCO2CR = .FALSE.
      IF (INT(WHAT(1)).EQ.1) LCO2CR = .TRUE.
      IF (WHAT(2).GE.ZERO) CUTOF = WHAT(2)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = XCUTS                       *
c                                                                   *
c                 thresholds for x-sampling                         *
c                                                                   *
c    what (1)    defines lower threshold for val.-q x-value (CVQ)   *
c                                                 default: 1.       *
c    what (2)    defines lower threshold for val.-qq x-value (CDQ)  *
c                                                 default: 2.       *
c    what (3)    defines lower threshold for sea-q x-value (CSEA)   *
c                                                 default: 0.2      *
c    what (4)    sea-q x-values in S-S chains (SSMIMA)              *
c                                                 default: 0.14     *
c    what (5)    not used                                           *
c                                                 default: 2.       *
c    what (6), sdum   no meaning                                    *
c                                                                   *
c    Note: Lower thresholds (what(1..3)) are def. as x_thr=CXXX/ECM *
c                                                                   *
c********************************************************************

  310 CONTINUE
      IF (WHAT(1).GE.0.5D0) CVQ    = WHAT(1)
      IF (WHAT(2).GE.ONE)   CDQ    = WHAT(2)
      IF (WHAT(3).GE.0.1D0) CSEA   = WHAT(3)
      IF (WHAT(4).GE.ZERO) THEN
         SSMIMA = WHAT(4)
         SSMIMQ = SSMIMA**2
      ENDIF
      IF (WHAT(5).GT.2.0D0) VVMTHR = WHAT(5)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = INTPT                       *
c                                                                   *
c     what (1) = -1   intrinsic transverse momenta of partons       *
c                     not treated                default: 1         *
c     what (2..6), sdum   no meaning                                *
c                                                                   *
c********************************************************************

  320 CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         LINTPT = .FALSE.
      ELSE
         LINTPT = .TRUE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = CRONINPT                    *
c                                                                   *
c    Cronin effect (multiple scattering of partons at chain ends)   *
c                                                                   *
c       what (1) = -1  Cronin effect not treated     default: 1     *
c       what (2) = 0   scattering parameter          default: 0.64  *
c       what (3..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  330 CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         MKCRON = 0
      ELSE
         MKCRON = 1
      ENDIF
      CRONCO = WHAT(2)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = SEADISTR                    *
c                                                                   *
c     what (1)  (XSEACO)  sea(x) prop. 1/x**what (1)   default: 1.  *
c     what (2)  (UNON)                                 default: 2.  *
c     what (3)  (UNOM)                                 default: 1.5 *
c     what (4)  (UNOSEA)                               default: 5.  *
c                        qdis(x) prop. (1-x)**what (1)  etc.        *
c     what (5..6), sdum   no meaning                                *
c                                                                   *
c********************************************************************

  340 CONTINUE
      XSEACO = WHAT(1)
      XSEACU = 1.05D0-XSEACO
      UNON   = WHAT(2)
      IF (UNON.LT.0.1D0) UNON = 2.0D0
      UNOM   = WHAT(3)
      IF (UNOM.LT.0.1D0) UNOM = 1.5D0
      UNOSEA = WHAT(4)
      IF (UNOSEA.LT.0.1D0) UNOSEA = 5.0D0
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = SEASU3                      *
c                                                                   *
c          Treatment of strange-quarks at chain ends                *
c                                                                   *
c       what (1)   (SEASQ)  strange-quark supression factor         *
c                  iflav = 1.+rndm*(2.+SEASQ)                       *
c                                                    default: 1.    *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  350 CONTINUE
      SEASQ = WHAT(1)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = DIQUARKS                    *
c                                                                   *
c     what (1) = -1.  sea-diquark/antidiquark-pairs not treated     *
c                                                    default: 1.    *
c     what (2..6), sdum   no meaning                                *
c                                                                   *
c********************************************************************

 360  CONTINUE
      IF (WHAT(1).EQ.-1.0D0) THEN
         LSEADI = .FALSE.
      ELSE
         LSEADI = .TRUE.
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = RESONANC                    *
c                                                                   *
c                 treatment of low mass chains                      *
c                                                                   *
c    what (1) = -1 low chain masses are not corrected for resonance *
c                  masses (obsolete for BAMJET-fragmentation)       *
c                                       default: 1.                 *
c    what (2) = -1 massless partons     default: 1. (massive)       *
c                                       default: 1. (massive)       *
c    what (3) = -1 chain-system containing chain of too small       *
c                  mass is rejected (note: this does not fully      *
c                  apply to S-S chains) default: 0.                 *
c    what (4..6), sdum   no meaning                                 *
c                                                                   *
c********************************************************************

  370 CONTINUE
      IRESCO = 1
      IMSHL  = 1
      IRESRJ = 0
      IF (WHAT(1).EQ.-ONE) IRESCO = 0
      IF (WHAT(2).EQ.-ONE) IMSHL  = 0
      IF (WHAT(3).EQ.-ONE) IRESRJ = 1
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = DIFFRACT                    *
c                                                                   *
c                Treatment of diffractive events                    *
c                                                                   *
c     what (1) = (ISINGD) 0  no single diffraction                  *
c                         1  single diffraction included            *
c                       +-2  single diffractive events only         *
c                       +-3  projectile single diffraction only     *
c                       +-4  target single diffraction only         *
c                        -5  double pomeron exchange only           *
c                      (neg. sign applies to PHOJET events)         *
c                                                     default: 0.   *
c                                                                   *
c     what (2) = (IDOUBD) 0  no double diffraction                  *
c                         1  double diffraction included            *
c                         2  double diffractive events only         *
c                                                     default: 0.   *
c     what (3) = 1 projectile diffraction treated (2-channel form.) *
c                                                     default: 0.   *
c     what (4) = alpha-parameter in projectile diffraction          *
c                                                     default: 0.   *
c     what (5..6), sdum   no meaning                                *
c                                                                   *
c********************************************************************

  380 CONTINUE
      IF (ABS(WHAT(1)).GT.ZERO) ISINGD = INT(WHAT(1))
      IF (ABS(WHAT(2)).GT.ZERO) IDOUBD = INT(WHAT(2))
      IF ((ISINGD.GT.1).AND.(IDOUBD.GT.1)) THEN
         WRITE(ErrorOut,1380)
 1380    FORMAT(1X,'INIT:   INCONSISTENT DIFFRACT - INPUT !',/,
     &          11X,'IDOUBD IS RESET TO ZERO')
         IDOUBD = 0
      ENDIF
      IF (WHAT(3).GT.ZERO) DIBETA = WHAT(3)
      IF (WHAT(4).GT.ZERO) DIALPH = WHAT(4)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = SINGLECH                    *
c                                                                   *
c       what (1) = 1.  Regge contribution (one chain) included      *
c                                                   default: 0.     *
c       what (2..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

 390  CONTINUE
      ISICHA = 0
      IF (WHAT(1).EQ.ONE) ISICHA = 1
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = NOFRAGME                    *
c                                                                   *
c                 biased chain hadronization                        *
c                                                                   *
c       what (1..6) = -1  no of hadronizsation of S-S chains        *
c                   = -2  no of hadronizsation of D-S chains        *
c                   = -3  no of hadronizsation of S-D chains        *
c                   = -4  no of hadronizsation of S-V chains        *
c                   = -5  no of hadronizsation of D-V chains        *
c                   = -6  no of hadronizsation of V-S chains        *
c                   = -7  no of hadronizsation of V-D chains        *
c                   = -8  no of hadronizsation of V-V chains        *
c                   = -9  no of hadronizsation of comb. chains      *
c                                  default:  complete hadronization *
c       sdum   no meaning                                           *
c                                                                   *
c********************************************************************

  400 CONTINUE
      DO 401 I=1,6
         ICHAIN = INT(WHAT(I))
         IF ((ICHAIN.LE.-1).AND.(ICHAIN.GE.-9))
     &      LHADRO(ABS(ICHAIN)) = .FALSE.
  401 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = HADRONIZE                   *
c                                                                   *
c           hadronization model and parameter switch                *
c                                                                   *
c       what (1) = 1    hadronization via BAMJET                    *
c                = 2    hadronization via JETSET                    *
c                                                    default: 2     *
c       what (2) = 1..3 parameter set to be used                    *
c                       JETSET: 3 sets available                    *
c                               ( = 3 default JETSET-parameters)    *
c                       BAMJET: 1 set available                     *
c                                                    default: 1     *
c       what (3..6), sdum   no meaning                              *
c                                                                   *
c********************************************************************

  410 CONTINUE
      IWHAT1 = INT(WHAT(1))
      IWHAT2 = INT(WHAT(2))
      IF ((IWHAT1.EQ.1).OR.(IWHAT1.EQ.2)) IFRAG(1) = IWHAT1
      IF ((IWHAT1.EQ.2).AND.(IWHAT2.GE.1).AND.(IWHAT2.LE.3))
     &                                    IFRAG(2) = IWHAT2
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = POPCORN                     *
c                                                                   *
c  "Popcorn-effect" in fragmentation and diquark breaking diagrams  *
c                                                                   *
c   what (1) = (PDB) frac. of diquark fragmenting directly into     *
c                    baryons (PYTHIA/JETSET fragmentation)          *
c                    (JETSET: = 0. Popcorn mechanism switched off)  *
c                                                    default: 0.5   *
c   what (2) = probability for accepting a diquark breaking         *
c              diagram involving the generation of a u/d quark-     *
c              antiquark pair                        default: 0.0   *
c   what (3) = same a what (2), here for s quark-antiquark pair     *
c                                                    default: 0.0   *
c   what (4..6), sdum   no meaning                                  *
c                                                                   *
c********************************************************************

  420 CONTINUE
      IF (WHAT(1).GE.0.0D0) PDB = WHAT(1)
      IF (WHAT(2).GE.0.0D0) THEN
         PDBSEA(1) = WHAT(2)
         PDBSEA(2) = WHAT(2)
      ENDIF
      IF (WHAT(3).GE.0.0D0) PDBSEA(3) = WHAT(3)
      DO 421 I=1,8
         DBRKA(1,I) = DBRKR(1,I)*PDBSEA(1)/(1.D0-PDBSEA(1))
         DBRKA(2,I) = DBRKR(2,I)*PDBSEA(2)/(1.D0-PDBSEA(2))
         DBRKA(3,I) = DBRKR(3,I)*PDBSEA(3)/(1.D0-PDBSEA(3))
  421 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = PARDECAY                    *
c                                                                   *
c      what (1) = 1.  Sigma0/Asigma0 are decaying within JETSET     *
c               = 2.  pion^0 decay after intranucl. cascade         *
c                                                default: no decay  *
c      what (2..6), sdum   no meaning                               *
c                                                                   *
c********************************************************************

 430  CONTINUE
      IF (WHAT(1).EQ.ONE)  ISIG0 = 1
      IF (WHAT(1).EQ.2.0D0) IPI0 = 1
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = BEAM                        *
c                                                                   *
c              definition of beam parameters                        *
c                                                                   *
c      what (1/2)  > 0 : energy of beam 1/2 (GeV)                   *
c                  < 0 : abs(what(1/2)) energy per charge of        *
c                        beam 1/2 (GeV)                             *
c                  (beam 1 is directed into positive z-direction)   *
c      what (3)    beam crossing angle, defined as 2x angle between *
c                  one beam and the z-axis (micro rad)              *
c      what (4)    angle with x-axis defining the collision plane   *
c      what (5..6), sdum   no meaning                               *
c                                                                   *
c      Note: this card requires previously defined projectile and   *
c            target identities (PROJPAR, TARPAR)                    *
c                                                                   *
c********************************************************************

  440 CONTINUE
      CALL DT_BEAMPR(WHAT,PPN,1)
      EPN    = ZERO
      CMENER = ZERO
      LEINP  = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-MSTU                   *
c                                                                   *
c          set parameter MSTU in JETSET-common /LUDAT1/             *
c                                                                   *
c       what (1) =  index according to LUND-common block            *
c       what (2) =  new value of MSTU( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-Lund or corresponding to  *
c                                 the set given in HADRONIZE        *
c                                                                   *
c********************************************************************

  450 CONTINUE
      IF (WHAT(1).GT.ZERO) THEN
         NMSTU = NMSTU+1
         IMSTU(NMSTU) = INT(WHAT(1))
         MSTUX(NMSTU) = INT(WHAT(2))
      ENDIF
      IF (WHAT(3).GT.ZERO) THEN
         NMSTU = NMSTU+1
         IMSTU(NMSTU) = INT(WHAT(3))
         MSTUX(NMSTU) = INT(WHAT(4))
      ENDIF
      IF (WHAT(5).GT.ZERO) THEN
         NMSTU = NMSTU+1
         IMSTU(NMSTU) = INT(WHAT(5))
         MSTUX(NMSTU) = INT(WHAT(6))
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-MSTJ                   *
c                                                                   *
c          set parameter MSTJ in JETSET-common /LUDAT1/             *
c                                                                   *
c       what (1) =  index according to LUND-common block            *
c       what (2) =  new value of MSTJ( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-Lund or corresponding to  *
c                                 the set given in HADRONIZE        *
c                                                                   *
c********************************************************************

  451 CONTINUE
      IF (WHAT(1).GT.ZERO) THEN
         NMSTJ = NMSTJ+1
         IMSTJ(NMSTJ) = INT(WHAT(1))
         MSTJX(NMSTJ) = INT(WHAT(2))
      ENDIF
      IF (WHAT(3).GT.ZERO) THEN
         NMSTJ = NMSTJ+1
         IMSTJ(NMSTJ) = INT(WHAT(3))
         MSTJX(NMSTJ) = INT(WHAT(4))
      ENDIF
      IF (WHAT(5).GT.ZERO) THEN
         NMSTJ = NMSTJ+1
         IMSTJ(NMSTJ) = INT(WHAT(5))
         MSTJX(NMSTJ) = INT(WHAT(6))
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-MDCY                   *
c                                                                   *
c  set parameter MDCY(I,1) for particle decays in JETSET-common     *
c                                                      /LUDAT3/     *
c                                                                   *
c       what (1-6) = PDG particle index of particle which should    *
c                    not decay                                      *
c                        default: default-Lund or forced in         *
c                                 DT_INITJS                         *
c                                                                   *
c********************************************************************

  452 CONTINUE
      DO 4521 I=1,6
         IF (WHAT(I).NE.ZERO) THEN

            KC = PYCOMP(INT(WHAT(I)))

            MDCY(KC,1) = 0
         ENDIF
 4521 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-PARJ                   *
c                                                                   *
c          set parameter PARJ in JETSET-common /LUDAT1/             *
c                                                                   *
c       what (1) =  index according to LUND-common block            *
c       what (2) =  new value of PARJ( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-Lund or corresponding to  *
c                                 the set given in HADRONIZE        *
c                                                                   *
c********************************************************************

  460 CONTINUE
      IF (WHAT(1).NE.ZERO) THEN
         NPARJ = NPARJ+1
         IPARJ(NPARJ) = INT(WHAT(1))
         PARJX(NPARJ) = WHAT(2)
      ENDIF
      IF (WHAT(3).NE.ZERO) THEN
         NPARJ = NPARJ+1
         IPARJ(NPARJ) = INT(WHAT(3))
         PARJX(NPARJ) = WHAT(4)
      ENDIF
      IF (WHAT(5).NE.ZERO) THEN
         NPARJ = NPARJ+1
         IPARJ(NPARJ) = INT(WHAT(5))
         PARJX(NPARJ) = WHAT(6)
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LUND-PARU                   *
c                                                                   *
c          set parameter PARJ in JETSET-common /LUDAT1/             *
c                                                                   *
c       what (1) =  index according to LUND-common block            *
c       what (2) =  new value of PARU( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-Lund or corresponding to  *
c                                 the set given in HADRONIZE        *
c                                                                   *
c********************************************************************

  470 CONTINUE
      IF (WHAT(1).GT.ZERO) THEN
         NPARU = NPARU+1
         IPARU(NPARU) = INT(WHAT(1))
         PARUX(NPARU) = WHAT(2)
      ENDIF
      IF (WHAT(3).GT.ZERO) THEN
         NPARU = NPARU+1
         IPARU(NPARU) = INT(WHAT(3))
         PARUX(NPARU) = WHAT(4)
      ENDIF
      IF (WHAT(5).GT.ZERO) THEN
         NPARU = NPARU+1
         IPARU(NPARU) = INT(WHAT(5))
         PARUX(NPARU) = WHAT(6)
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = OUTLEVEL                    *
c                                                                   *
c                    output control switches                        *
c                                                                   *
c       what (1) =  internal rejection informations  default: 0     *
c       what (2) =  energy-momentum conservation check output       *
c                                                    default: 0     *
c       what (3) =  internal warning messages        default: 0     *
c       what (4..6), sdum    not yet used                           *
c                                                                   *
c********************************************************************

  480 CONTINUE
      DO 481 K=1,6
         IOULEV(K) = INT(WHAT(K))
  481 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = FRAME                       *
c                                                                   *
c          frame in which final state is given in DTEVT1            *
c                                                                   *
c       what (1) = 1  target rest frame (laboratory)                *
c                = 2  nucleon-nucleon cms                           *
c                                                    default: 1     *
c                                                                   *
c********************************************************************

  490 CONTINUE
      KFRAME = INT(WHAT(1))
      IF ((KFRAME.GE.1).AND.(KFRAME.LE.2)) IFRAME = KFRAME
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = L-TAG                       *
c                                                                   *
c                        lepton tagger:                             *
c   definition of kinematical cuts for radiated photon and          *
c   outgoing lepton detection in lepton-nucleus interactions        *
c                                                                   *
c       what (1) = y_min                                            *
c       what (2) = y_max                                            *
c       what (3) = Q^2_min                                          *
c       what (4) = Q^2_max                                          *
c       what (5) = theta_min  (Lab)                                 *
c       what (6) = theta_max  (Lab)                                 *
c                                       default: no cuts            *
c       sdum    no meaning                                          *
c                                                                   *
c********************************************************************

  500 CONTINUE
      YMIN  = WHAT(1)
      YMAX  = WHAT(2)
      Q2MIN = WHAT(3)
      Q2MAX = WHAT(4)
      THMIN = WHAT(5)
      THMAX = WHAT(6)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = L-ETAG                      *
c                                                                   *
c                        lepton tagger:                             *
c       what (1) = min. outgoing lepton energy  (in Lab)            *
c       what (2) = min. photon energy           (in Lab)            *
c       what (3) = max. photon energy           (in Lab)            *
c                                       default: no cuts            *
c       what (2..6), sdum    no meaning                             *
c                                                                   *
c********************************************************************

  510 CONTINUE
      ELMIN = MAX(WHAT(1),ZERO)
      EGMIN = MAX(WHAT(2),ZERO)
      EGMAX = MAX(WHAT(3),ZERO)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = ECMS-CUT                    *
c                                                                   *
c     what (1) = min. c.m. energy to be sampled                     *
c     what (2) = max. c.m. energy to be sampled                     *
c     what (3) = min x_Bj         to be sampled                     *
c                                       default: no cuts            *
c     what (3..6), sdum    no meaning                               *
c                                                                   *
c********************************************************************

  520 CONTINUE
      ECMIN  = WHAT(1)
      ECMAX  = WHAT(2)
      IF (ECMIN.GT.ECMAX) ECMIN = ECMAX
      XBJMIN = MAX(WHAT(3),ZERO)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = VDM-PAR1                    *
c                                                                   *
c      parameters in gamma-nucleus cross section calculation        *
c                                                                   *
c       what (1) =  Lambda^2                       default: 2.      *
c       what (2)    lower limit in M^2 integration                  *
c                =  1  (3m_pi)^2                                    *
c                =  2  (m_rho0)^2                                   *
c                =  3  (m_phi)^2                   default: 1       *
c       what (3)    upper limit in M^2 integration                  *
c                =  1   s/2                                         *
c                =  2   s/4                                         *
c                =  3   s                          default: 3       *
c       what (4)    CKMT F_2 structure function                     *
c                =  2212  proton                                    *
c                =  100   deuteron                 default: 2212    *
c       what (5)    calculation of gamma-nucleon xsections          *
c                =  1  according to CKMT-parametrization of F_2     *
c                =  2  integrating SIGVP over M^2                   *
c                =  3  using SIGGA                                  *
c                =  4  PHOJET cross sections       default:  4      *
c                                                                   *
c       what (6), sdum    no meaning                                *
c                                                                   *
c********************************************************************

  530 CONTINUE
      IF (WHAT(1).GE.ZERO) RL2 = WHAT(1)
      IF ((WHAT(2).GE.1).AND.(WHAT(2).LE.3)) INTRGE(1) = INT(WHAT(2))
      IF ((WHAT(3).GE.1).AND.(WHAT(3).LE.3)) INTRGE(2) = INT(WHAT(3))
      IF ((WHAT(4).EQ.2212).OR.(WHAT(4).EQ.100)) IDPDF = INT(WHAT(4))
      IF ((WHAT(5).GE.1).AND.(WHAT(5).LE.4)) MODEGA = INT(WHAT(5))
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = HISTOGRAM                   *
c                                                                   *
c           activate different classes of histograms                *
c                                                                   *
c                                default: no histograms             *
c                                                                   *
c********************************************************************

  540 CONTINUE
      DO 541 J=1,6
         IF ((WHAT(J).GE.100).AND.(WHAT(J).LE.150)) THEN
            IHISPP(INT(WHAT(J))-100) = 1
         ELSEIF ((ABS(WHAT(J)).GE.200).AND.(ABS(WHAT(J)).LE.250)) THEN
            IHISXS(INT(ABS(WHAT(J)))-200) = 1
            IF (WHAT(J).LT.ZERO) IXSTBL = 1
         ENDIF
  541 CONTINUE
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = XS-TABLE                    *
c                                                                   *
c    output of cross section table for requested interaction        *
c              - particle production deactivated ! -                *
c                                                                   *
c       what (1)      lower energy limit for tabulation             *
c                > 0  Lab. frame                                    *
c                < 0  nucleon-nucleon cms                           *
c       what (2)      upper energy limit for tabulation             *
c                > 0  Lab. frame                                    *
c                < 0  nucleon-nucleon cms                           *
c       what (3) > 0  # of equidistant lin. bins in E               *
c                < 0  # of equidistant log. bins in E               *
c       what (4)      lower limit of particle virtuality (photons)  *
c       what (5)      upper limit of particle virtuality (photons)  *
c       what (6) > 0  # of equidistant lin. bins in Q^2             *
c                < 0  # of equidistant log. bins in Q^2             *
c                                                                   *
c********************************************************************

  550 CONTINUE
      IF (WHAT(1).EQ.99999.0D0) THEN
         IRATIO = INT(WHAT(2))
         GOTO 10
      ENDIF
      CMENER = ABS(WHAT(2))
      IF (.NOT.LXSTAB) THEN
         CALL DT_BERTTP
         CALL DT_INCINI
      ENDIF
      IF ((.NOT.LXSTAB).OR.(CMENER.NE.CMEOLD)) THEN
         CMEOLD = CMENER
         IF (WHAT(2).GT.ZERO)
     &      CMENER = SQRT(2.0D0*AAM(1)**2+2.0D0*WHAT(2)*AAM(1))
         EPN = ZERO
         PPN = ZERO
C        WRITE(LOUT,*) 'CMENER = ',CMENER
         CALL DT_LTINI(IJPROJ,IJTARG,EPN,PPN,CMENER,1)
         CALL DT_PHOINI
      ENDIF
      CALL DT_BERTTP
      CALL DT_INCINI
      CALL DT_XSTABL(WHAT,IXSQEL,IRATIO)
      IXSQEL = 0
      LXSTAB = .TRUE.
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = GLAUB-PAR                   *
c                                                                   *
c                parameters in Glauber-formalism                    *
c                                                                   *
c    what (1)  # of nucleon configurations sampled in integration   *
c              over nuclear desity                default: 1000     *
c    what (2)  # of bins for integration over impact-parameter and  *
c              for profile-function calculation   default: 49       *
c    what (3)  = 1 calculation of tot., el. and qel. cross sections *
c                                                 default: 0        *
c    what (4)  = 1   read pre-calculated impact-parameter distrib.  *
c                    from "sdum".glb                                *
c              =-1   dump pre-calculated impact-parameter distrib.  *
c                    into "sdum".glb                                *
c              = 100 read pre-calculated impact-parameter distrib.  *
c                    for variable projectile/target/energy runs     *
c                    from "sdum".glb                                *
c                                                 default: 0        *
c    what (5..6)   no meaning                                       *
c    sdum      if |what (4)| = 1 name of in/output-file (sdum.glb)  *
c                                                                   *
c********************************************************************

  560 CONTINUE
      IF (WHAT(1).GT.ZERO) JSTATB = INT(WHAT(1))
      IF (WHAT(2).GT.ZERO) JBINSB = INT(WHAT(2))
      IF (WHAT(3).EQ.ONE) LPROD = .FALSE.
      IF ((ABS(WHAT(4)).EQ.ONE).OR.(WHAT(4).EQ.100)) THEN
         IOGLB = INT(WHAT(4))
         CGLB  = SDUM
      ENDIF
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = GLAUB-INI                   *
c                                                                   *
c             pre-initialization of profile function                *
c                                                                   *
c       what (1)      lower energy limit for initialization         *
c                > 0  Lab. frame                                    *
c                < 0  nucleon-nucleon cms                           *
c       what (2)      upper energy limit for initialization         *
c                > 0  Lab. frame                                    *
c                < 0  nucleon-nucleon cms                           *
c       what (3) > 0  # of equidistant lin. bins in E               *
c                < 0  # of equidistant log. bins in E               *
c       what (4)      maximum projectile mass number for which the  *
c                     Glauber data are initialized for each         *
c                     projectile mass number                        *
c                     (if <= mass given with the PROJPAR-card)      *
c                                              default: 18          *
c       what (5)      steps in mass number starting from what (4)   *
c                     up to mass number defined with PROJPAR-card   *
c                     for which Glauber data are initialized        *
c                                              default: 5           *
c       what (6)      no meaning                                    *
c       sdum          no meaning                                    *
c                                                                   *
c********************************************************************

  565 CONTINUE
      IOGLB = -100
      CALL DT_GLBINI(WHAT)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = VDM-PAR2                    *
c                                                                   *
c      parameters in gamma-nucleus cross section calculation        *
c                                                                   *
c      what (1) = 0 no suppression of shadowing by direct photon    *
c                   processes                                       *
c               = 1 suppression ..                   default: 1     *
c      what (2) = 0 no suppression of shadowing by anomalous        *
c                   component if photon-F_2                         *
c               = 1 suppression ..                   default: 1     *
c      what (3) = 0 no suppression of shadowing by coherence        *
c                   length of the photon                            *
c               = 1 suppression ..                   default: 1     *
c      what (4) = 1 longitudinal polarized photons are taken into   *
c                   account                                         *
c                   eps*R*Q^2/M^2 = what(4)*Q^2/M^2  default: 0     *
c      what (5..6), sdum    no meaning                              *
c                                                                   *
c********************************************************************

  570 CONTINUE
      IF ((WHAT(1).EQ.ZERO).OR.(WHAT(1).EQ.ONE)) ISHAD(1) = INT(WHAT(1))
      IF ((WHAT(2).EQ.ZERO).OR.(WHAT(2).EQ.ONE)) ISHAD(2) = INT(WHAT(2))
      IF ((WHAT(3).EQ.ZERO).OR.(WHAT(3).EQ.ONE)) ISHAD(3) = INT(WHAT(3))
      EPSPOL  = WHAT(4)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  XS-QELPRO                            *
c                                                                   *
c     what (1..6), sdum    no meaning                               *
c                                                                   *
c********************************************************************

  580 CONTINUE
      IXSQEL = ABS(WHAT(1))
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  RNDMINIT                             *
c                                                                   *
c           initialization of random number generator               *
c                                                                   *
c     what (1..4)    values for initialization (= 1..168)           *
c     what (5..6), sdum    no meaning                               *
c                                                                   *
c********************************************************************

  590 CONTINUE
      IF ((WHAT(1).LT.1.0D0).OR.(WHAT(1).GT.168.0D0)) THEN
         NA1 = 22
      ELSE
         NA1 = WHAT(1)
      ENDIF
      IF ((WHAT(2).LT.1.0D0).OR.(WHAT(2).GT.168.0D0)) THEN
         NA2 = 54
      ELSE
         NA2 = WHAT(2)
      ENDIF
      IF ((WHAT(3).LT.1.0D0).OR.(WHAT(3).GT.168.0D0)) THEN
         NA3 = 76
      ELSE
         NA3 = WHAT(3)
      ENDIF
      IF ((WHAT(4).LT.1.0D0).OR.(WHAT(4).GT.168.0D0)) THEN
         NA4 = 92
      ELSE
         NA4 = WHAT(4)
      ENDIF
      CALL DT_RNDMST(NA1,NA2,NA3,NA4)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LEPTO-CUT                   *
c                                                                   *
c          set parameter CUT in LEPTO-common /LEPTOU/               *
c                                                                   *
c       what (1) =  index in CUT-array                              *
c       what (2) =  new value of CUT( int(what(1)) )                *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-LEPTO parameters          *
c                                                                   *
c********************************************************************

  600 CONTINUE
      IF (WHAT(1).GT.ZERO) CUT(INT(WHAT(1))) = WHAT(2)
      IF (WHAT(3).GT.ZERO) CUT(INT(WHAT(3))) = WHAT(4)
      IF (WHAT(5).GT.ZERO) CUT(INT(WHAT(5))) = WHAT(6)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LEPTO-LST                   *
c                                                                   *
c          set parameter LST in LEPTO-common /LEPTOU/               *
c                                                                   *
c       what (1) =  index in LST-array                              *
c       what (2) =  new value of LST( int(what(1)) )                *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-LEPTO parameters          *
c                                                                   *
c********************************************************************

  610 CONTINUE
      IF (WHAT(1).GT.ZERO) LST(INT(WHAT(1))) = INT(WHAT(2))
      IF (WHAT(3).GT.ZERO) LST(INT(WHAT(3))) = INT(WHAT(4))
      IF (WHAT(5).GT.ZERO) LST(INT(WHAT(5))) = INT(WHAT(6))
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = LEPTO-PARL                  *
c                                                                   *
c          set parameter PARL in LEPTO-common /LEPTOU/              *
c                                                                   *
c       what (1) =  index in PARL-array                             *
c       what (2) =  new value of PARL( int(what(1)) )               *
c       what (3), what(4) and what (5), what(6) further             *
c                   parameter in the same way as what (1) and       *
c                   what (2)                                        *
c                        default: default-LEPTO parameters          *
c                                                                   *
c********************************************************************

  620 CONTINUE
      IF (WHAT(1).GT.ZERO) PARL(INT(WHAT(1))) = WHAT(2)
      IF (WHAT(3).GT.ZERO) PARL(INT(WHAT(3))) = WHAT(4)
      IF (WHAT(5).GT.ZERO) PARL(INT(WHAT(5))) = WHAT(6)
      GOTO 10

c********************************************************************
c                                                                   *
c               control card:  codewd = START                       *
c                                                                   *
c       what (1) =   number of events                default: 100.  *
c       what (2) = 0 Glauber initialization follows                 *
c                = 1 Glauber initialization supressed, fitted       *
c                    results are used instead                       *
c                    (this does not apply if emulsion-treatment     *
c                     is requested)                                 *
c                = 2 Glauber initialization is written to           *
c                    output-file shmakov.out                        *
c                = 3 Glauber initialization is read from input-file *
c                    shmakov.out                     default: 0     *
c       what (3..6)  no meaning                                     *
c       what (3..6)  no meaning                                     *
c                                                                   *
c********************************************************************

  630 CONTINUE

c check for cross-section table output only
      IF (LXSTAB) STOP

      NCASES = INT(WHAT(1))
      IF (NCASES.LE.0) NCASES = 100
      IGLAU = INT(WHAT(2))
      IF ((IGLAU.NE.1).AND.(IGLAU.NE.2).AND.(IGLAU.NE.3))
     &                                            IGLAU = 0

      NPMASS = IP
      NPCHAR = IPZ
      NTMASS = IT
      NTCHAR = ITZ
      IDP    = IJPROJ
      IDT    = IJTARG
      IF (IDP.LE.0) IDP = 1
c muon neutrinos: temporary (missing index)
c (new patch in projpar: therefore the following this is probably not
c  necessary anymore..)
C     IF (IDP.EQ.26) IDP = 5
C     IF (IDP.EQ.27) IDP = 6

c redefine collision energy
      IF (LEINP) THEN
         IF (ABS(VAREHI).GT.ZERO) THEN
            PDUM = ZERO
            IF (VARELO.LT.EHADLO) VARELO = EHADLO
            CALL DT_LTINI(IDP,IDT,VARELO,PDUM,VARCLO,1)
            PDUM = ZERO
            CALL DT_LTINI(IDP,IDT,VAREHI,PDUM,VARCHI,1)
         ENDIF
         CALL DT_LTINI(IDP,IDT,EPN,PPN,CMENER,1)
      ELSE
         WRITE(ErrorOut,1003)
 1003    FORMAT(1X,'INIT:   COLLISION ENERGY NOT DEFINED!',/,
     &          1X,'              -PROGRAM STOPPED-      ')
         STOP
      ENDIF

c switch off evaporation (even if requested) if central coll. requ.
      IF ((ICENTR.EQ.-1).OR.(ICENTR.GT.0).OR.(XSFRAC.LT.0.5D0)) THEN
         IF (LEVPRT) THEN
            WRITE(ErrorOut,1004)
 1004       FORMAT(1X,/,'WARNING!  EVAPORATION REQUEST REJECTED SINCE',
     &             ' CENTRAL COLLISIONS FORCED.')
            LEVPRT = .FALSE.
            LDEEXG = .FALSE.
            LHEAVY = .FALSE.
         ENDIF
      ENDIF

c initialization of evaporation-module
      CALL DT_BERTTP
      CALL DT_INCINI
c save the default JETSET-parameter
      CALL DT_JSPARA(0)

c force use of phojet for g-A
      IF ((IDP.EQ.7).AND.(MCGENE.NE.3)) MCGENE = 2
c initialization of nucleon-nucleon event generator
      IF (MCGENE.EQ.2) CALL DT_PHOINI
c initialization of LEPTO event generator
      IF (MCGENE.EQ.3) THEN

         STOP ' THIS VERSION DOES NOT CONTAIN LEPTO !'

      ENDIF

c initialization of quasi-elastic neutrino scattering
      IF (MCGENE.EQ.4) THEN
         IF (IJPROJ.EQ.5) THEN
            NEUTYP = 1
         ELSEIF (IJPROJ.EQ.6) THEN
            NEUTYP = 2
         ELSEIF (IJPROJ.EQ.135) THEN
            NEUTYP = 3
         ELSEIF (IJPROJ.EQ.136) THEN
            NEUTYP = 4
         ELSEIF (IJPROJ.EQ.133) THEN
            NEUTYP = 5
         ELSEIF (IJPROJ.EQ.134) THEN
            NEUTYP = 6
         ENDIF
      ENDIF

c normalize fractions of emulsion components
      IF (NCOMPO.GT.0) THEN
         SUMFRA = ZERO
         DO 491 I=1,NCOMPO
            SUMFRA = SUMFRA+EMUFRA(I)
  491    CONTINUE
         IF (SUMFRA.GT.ZERO) THEN
            DO 492 I=1,NCOMPO
               EMUFRA(I) = EMUFRA(I)/SUMFRA
  492       CONTINUE
         ENDIF
      ENDIF

c disallow Cronin's multiple scattering for nucleus-nucleus interactions
      IF ((IP.GT.1).AND.(MKCRON.GT.0)) THEN
         WRITE(ErrorOut,1005)
 1005    FORMAT(/,1X,'INIT:  MULTIPLE SCATTERING DISALLOWED',/)
         MKCRON = 0
      ENDIF

c initialization of Glauber-formalism (moved to xAEVT, sr 26.3.96)
C     IF (NCOMPO.LE.0) THEN
C        CALL DT_SHMAKI(IP,IPZ,IT,ITZ,IDP,PPN,IGLAU)
C     ELSE
C        DO 493 I=1,NCOMPO
C           CALL DT_SHMAKI(IP,IPZ,IEMUMA(I),IEMUCH(I),IDP,PPN,0)
C 493    CONTINUE
C     ENDIF

c pre-tabulation of elastic cross-sections
      CALL DT_SIGTBL(JDUM,JDUM,DUM,DUM,-1)

      CALL DT_XTIME

      RETURN

c********************************************************************
c                                                                   *
c               control card:  codewd = STOP                        *
c                                                                   *
c               stop of the event generation                        *
c                                                                   *
c       what (1..6)  no meaning                                     *
c                                                                   *
c********************************************************************

 9999 CONTINUE
      WRITE(ErrorOut,9000)
 9000 FORMAT(1X,'---> UNEXPECTED END OF INPUT !')

  640 CONTINUE
      STOP

      END
c
c===kkinc==============================================================*
c
CDECK  ID>, DT_KKINC
      SUBROUTINE DT_KKINC(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,KKMAT,
     &                                                         IREJ)

c***********************************************************************
c Treatment of complete nucleus-nucleus or hadron-nucleus scattering   *
c This subroutine is an update of the previous version written         *
c by J. Ranft/ H.-J. Moehring.                                         *
c This version dated 19.11.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY5=1.0D-5,
     &           TINY2=1.0D-2,TINY3=1.0D-3)

      LOGICAL LFZC

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c cuts for variable energy runs
      COMMON /DTVARE/ VARELO,VAREHI,VARCLO,VARCHI

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD


      DIMENSION WHAT(6)

      IREJ  = 0
      ILOOP = 0
  100 CONTINUE
      IF (ILOOP.EQ.4) THEN
         WRITE(ErrorOut,1000) NEVHKK
 1000    FORMAT(1X,'KKINC: EVENT ',I8,' REJECTED!')
         GOTO 9999
      ENDIF
      ILOOP = ILOOP+1

c variable energy-runs, recalculate parameters for LT's
      IF ((ABS(VAREHI).GT.ZERO).OR.(IOGLB.EQ.100)) THEN
         PDUM = ZERO
         CDUM = ZERO
         CALL DT_LTINI(IDP,1,EPN,PDUM,CDUM,1)
      ENDIF
      IF (EPN.GT.EPROJ) THEN
         WRITE(ErrorOut,'(A,E9.3,2A,E9.3,A)')
     &      ' REQUESTED ENERGY (',EPN,'GEV) EXCEEDS',
     &      ' INITIALIZATION ENERGY (',EPROJ,'GEV) !'
         STOP
      ENDIF

c re-initialize /DTPRTA/
      IP  = NPMASS
      IPZ = NPCHAR
      IT  = NTMASS
      ITZ = NTCHAR
      IJPROJ = IDP
      IBPROJ = IIBAR(IJPROJ)

c calculate nuclear potentials (common /DTNPOT/)
      CALL DT_NCLPOT(IPZ,IP,ITZ,IT,ZERO,ZERO,0)

c initialize treatment for residual nuclei
      CALL DT_RESNCL(EPN,NLOOP,1)

c sample hadron/nucleus-nucleus interaction
      CALL DT_KKEVNT(KKMAT,IREJ1)
      IF (IREJ1.GT.0) THEN
         IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in KKINC'
         GOTO 9999
      ENDIF

      IF ((NPMASS.GT.1).OR.(NTMASS.GT.1)) THEN

c intranuclear cascade of final state particles for KTAUGE generations
c of secondaries
         CALL DT_FOZOCA(LFZC,IREJ1)
         IF (IREJ1.GT.0) THEN
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 2 in KKINC'
            GOTO 9999
         ENDIF

c baryons unable to escape the nuclear potential are treated as
c excited nucleons (ISTHKK=15,16)
         CALL DT_SCN4BA

c decay of resonances produced in intranuclear cascade processes
c*sr 15-11-95 should be obsolete
C        IF (LFZC) CALL DT_DECAY1

  101    CONTINUE
c treatment of residual nuclei
         CALL DT_RESNCL(EPN,NLOOP,2)

c evaporation / fission / fragmentation
c (if intranuclear cascade was sampled only)
         IF (LFZC) THEN
            CALL DT_FICONF(IJPROJ,IP,IPZ,IT,ITZ,NLOOP,IREJ1)
            IF (IREJ1.GT.1) GOTO 101
            IF (IREJ1.EQ.1) GOTO 100
         ENDIF

      ENDIF

c transform finale state into Lab.
      IFLAG = 2
      CALL DT_BEAMPR(WHAT,DUM,IFLAG)
      IF ((IFRAME.EQ.1).AND.(IFLAG.EQ.-1)) CALL DT_LT2LAB

      IF (IPI0.EQ.1) CALL DT_DECPI0

C     IF (NEVHKK.EQ.5) CALL DT_EVTOUT(4)

      RETURN
 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===defaul=============================================================*
c
CDECK  ID>, DT_DEFAUL
      SUBROUTINE DT_DEFAUL(EPN,PPN)

c***********************************************************************
c Variables are set to default values.                                 *
c This version dated 8.5.95 is written by S. Roesler.                  *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY10=1.0D-10)
      PARAMETER (TWOPI  = 6.283185307179586454D+00)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c interface HADRIN-DPM
      COMMON /HNTHRE/ EHADTH,EHADLO,EHADHI,INTHAD,IDXTA

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT

c threshold values for x-sampling (DTUNUC 1.x)
      COMMON /DTXCUT/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     &                SSMIMQ,VVMTHR

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c n-n cross section fluctuations
      PARAMETER (NBINS = 1000)
      COMMON /DTXSFL/ FLUIXX(NBINS),IFLUCT

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c diquark-breaking mechanism
      COMMON /DTDIQB/ DBRKR(3,8),DBRKA(3,8),CHAM1,CHAM3,CHAB1,CHAB3

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c kinematical cuts for lepton-nucleus interactions
      COMMON /DTLCUT/ ECMIN,ECMAX,XBJMIN,ELMIN,EGMIN,EGMAX,YMIN,YMAX,
     &                Q2MIN,Q2MAX,THMIN,THMAX,Q2LI,Q2HI,ECMLI,ECMHI

c flags for activated histograms
      COMMON /DTHIS3/ IHISPP(50),IHISXS(50),IXSTBL

c cuts for variable energy runs
      COMMON /DTVARE/ VARELO,VAREHI,VARCLO,VARCHI

c parameters for hA-diffraction
      COMMON /DTDIHA/ DIBETA,DIALPH

c LEPTO
      REAL RPPN
      COMMON /LEPTOI/ RPPN,LEPIN,INTER

c steering flags for qel neutrino scattering modules
      COMMON /QNEUTO/ DSIGSU,DSIGMC,NDSIG,NEUTYP,NEUDEC

c event flag
      COMMON /DTEVNO/ NEVENT,ICASCA


      DATA POTMES /0.002D0/

c common /DTNPOT/
      DO 10 I=1,2
         PFERMP(I) = ZERO
         PFERMN(I) = ZERO
         EBINDP(I) = ZERO
         EBINDN(I) = ZERO
         DO 11 J=1,210
            EPOT(I,J) = ZERO
   11    CONTINUE
c nucleus independent meson potential
         EPOT(I,13) = POTMES
         EPOT(I,14) = POTMES
         EPOT(I,15) = POTMES
         EPOT(I,16) = POTMES
         EPOT(I,23) = POTMES
         EPOT(I,24) = POTMES
         EPOT(I,25) = POTMES
   10 CONTINUE
c*sr 7.4.98: changed after corrected B-sampling
C     FERMOD    = 0.55D0
      FERMOD    = 0.68D0
      ETACOU(1) = ZERO
      ETACOU(2) = ZERO
      ICOUL     = 1
      LFERMI    = .TRUE.

c common /HNTHRE/
      EHADTH = -99.0D0
      EHADLO = 4.06D0
      EHADHI = 6.0D0
      INTHAD = 1
      IDXTA  = 2

c common /DTIMPA/
      ICENTR = 0
      BIMIN  = ZERO
      BIMAX  = 1.0D10
      XSFRAC = 1.0D0

c common /DTPRTA/
      IP  = 1
      IPZ = 1
      IT  = 1
      ITZ = 1
      IJPROJ = 1
      IBPROJ = 1
      IJTARG = 1
      IBTARG = 1
c common /DTGPRO/
      VIRT = ZERO
      DO 14 I=1,4
         PGAMM(I)  = ZERO
         PLEPT0(I) = ZERO
         PLEPT1(I) = ZERO
         PNUCL(I)  = ZERO
   14 CONTINUE
      IDIREC   = 0

c common /DTCOMP/
      NCOMPO = 0
      IEMUL  = 0
      DO 12 I=1,NCOMPX
         EMUFRA(I) = ZERO
         IEMUMA(I) = 1
         IEMUCH(I) = 1
   12 CONTINUE

c common /DTFOTI/
c*sr 7.4.98: changed after corrected B-sampling
C     TAUFOR = 4.4D0
      TAUFOR = 3.1D0
      KTAUGE = 25
      ITAUVE = 1
      INCMOD = 1
      LPAULI = .TRUE.

c common /DTCHAI/
      SEASQ  = ONE
      MKCRON = 1
      CRONCO = 0.64D0
      ISICHA = 0
      CUTOF  = 100.0D0
      LCO2CR = .FALSE.
      IRECOM = 1
      LINTPT = .TRUE.

c common /DTXCUT/
c  definition of soft quark distributions
      XSEACU = 0.05D0
      UNON   = 2.0D0
      UNOM   = 1.5D0
      UNOSEA = 5.0D0
c  cutoff parameters for x-sampling
      CVQ    = 1.0D0
      CDQ    = 2.0D0
C     CSEA   = 0.3D0
      CSEA   = 0.1D0
      SSMIMA = 1.2D0
      SSMIMQ = SSMIMA**2
      VVMTHR = 2.0D0

c common /DTFLG1/
      IFRAG(1) = 2
      IFRAG(2) = 1
      IRESCO   = 1
      IMSHL    = 1
      IRESRJ   = 0
      LEMCCK   = .FALSE.
      LHADRO(0) = .FALSE.
      DO 13 I=1,9
         LHADRO(I) = .TRUE.
         IF (I.LE.6) IOULEV(I) = -1
   13 CONTINUE
      LSEADI = .TRUE.
      LEVAPO = .TRUE.
      IFRAME = 1

c common /DTXSFL/
      IFLUCT = 0

c common /DTFRPA/
      PDB = 0.15D0
      PDBSEA(1) = 0.0D0
      PDBSEA(2) = 0.0D0
      PDBSEA(3) = 0.0D0
      ISIG0 = 0
      IPI0  = 0
      NMSTU = 0
      NPARU = 0
      NMSTJ = 0
      NPARJ = 0

c common /DTDIQB/
      DO 15 I=1,8
         DBRKR(1,I) = 5.0D0
         DBRKR(2,I) = 5.0D0
         DBRKR(3,I) = 10.0D0
         DBRKA(1,I) = ZERO
         DBRKA(2,I) = ZERO
         DBRKA(3,I) = ZERO
   15 CONTINUE
      CHAM1 = 0.2D0
      CHAM3 = 0.5D0
      CHAB1 = 0.7D0
      CHAB3 = 1.0D0

c common /DTFLG3/
      ISINGD = 0
      IDOUBD = 0
      IFLAGD = 0
      IDIFF  = 0

c common /DTMODL/
      MCGENE    = 2
      CMODEL(1) = 'DTUNUC  '
      CMODEL(2) = 'PHOJET  '
      CMODEL(3) = 'LEPTO   '
      CMODEL(4) = 'QNEUTRIN'
      LPHOIN    = .TRUE.
      ELOJET    = 5.0D0

c common /DTLCUT/
      ECMIN  = 3.5D0
      ECMAX  = 1.0D10
      XBJMIN = ZERO
      ELMIN = ZERO
      EGMIN = ZERO
      EGMAX = 1.0D10
      YMIN  = TINY10
      YMAX  = 0.999D0
      Q2MIN = TINY10
      Q2MAX = 10.0D0
      THMIN = ZERO
      THMAX = TWOPI
      Q2LI  = ZERO
      Q2HI  = 1.0D10
      ECMLI = ZERO
      ECMHI = 1.0D10

c common /DTVDMP/
      RL2       = 2.0D0
      INTRGE(1) = 1
      INTRGE(2) = 3
      IDPDF     = 2212
      MODEGA    = 4
      ISHAD(1)  = 1
      ISHAD(2)  = 1
      ISHAD(3)  = 1
      EPSPOL    = ZERO

c common /DTGLGP/
      JSTATB = 1000
      JBINSB = 49
      CGLB   = '        '
      IOGLB  = 0
      LPROD  = .TRUE.

c common /DTHIS3/
      DO 16 I=1,50
         IHISPP(I) = 0
         IHISXS(I) = 0
   16 CONTINUE
      IXSTBL = 0

c common /DTVARE/
      VARELO = ZERO
      VAREHI = ZERO
      VARCLO = ZERO
      VARCHI = ZERO

c common /DTDIHA/
      DIBETA = -1.0D0
      DIALPH = ZERO

c common /LEPTOI/
      RPPN  = 0.0
      LEPIN = 0
      INTER = 0

c common /QNEUTO/
      NEUTYP = 1
      NEUDEC = 0

c common /DTEVNO/
      NEVENT = 1
      ICASCA = 0

c default Lab.-energy
      EPN = 200.0D0
      PPN = SQRT((EPN-AAM(IJPROJ))*(EPN+AAM(IJPROJ)))

      RETURN
      END
c
c===aaevt==============================================================*
c
CDECK  ID>, DT_AAEVT
      SUBROUTINE DT_AAEVT(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,
     &                                             IDP,IGLAU)

c***********************************************************************
c This version dated 22.03.96 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c event flag
      COMMON /DTEVNO/ NEVENT,ICASCA


      CHARACTER*8 DATE,HHMMSS
      DIMENSION IDMNYR(3)

      KKMAT  = 1
      NMSG   = MAX(NEVTS/100,1)

c initialization of run-statistics and histograms
      CALL DT_STATIS(1)

      CALL PHO_PHIST(1000,DUM)


c initialization of Glauber-formalism
      IF (NCOMPO.LE.0) THEN
         CALL DT_SHMAKI(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,IGLAU)
      ELSE
         DO 1 I=1,NCOMPO
            CALL DT_SHMAKI(NPMASS,NPCHAR,IEMUMA(I),IEMUCH(I),IDP,EPN,0)
    1    CONTINUE
      ENDIF
      CALL DT_SIGEMU

      CALL IDATE(IDMNYR)
      WRITE(DATE,'(I2,''/'',I2,''/'',I2)')
     &   IDMNYR(1),IDMNYR(2),MOD(IDMNYR(3),100)
      CALL ITIME(IDMNYR)
      WRITE(HHMMSS,'(I2,'':'',I2,'':'',I2)')
     &   IDMNYR(1),IDMNYR(2),IDMNYR(3)
      WRITE(ErrorOut,1001) DATE,HHMMSS
 1001 FORMAT(/,' DT_AAEVT: INITIALISATION FINISHED. ( DATE: ',A8,
     &       '   TIME: ',A8,' )')

c generate NEVTS events
      DO 2 IEVT=1,NEVTS

c  print run-status message
         IF (MOD(IEVT,NMSG).EQ.0) THEN
            CALL IDATE(IDMNYR)
            WRITE(DATE,'(I2,''/'',I2,''/'',I2)')
     &         IDMNYR(1),IDMNYR(2),MOD(IDMNYR(3),100)
            CALL ITIME(IDMNYR)
            WRITE(HHMMSS,'(I2,'':'',I2,'':'',I2)')
     &         IDMNYR(1),IDMNYR(2),IDMNYR(3)
            WRITE(ErrorOut,1000) IEVT-1,NEVTS,DATE,HHMMSS
 1000       FORMAT(/,1X,I8,' OUT OF ',I8,' EVENTS SAMPLED ( DATE: ',A,
     &             '   TIME: ',A,' )',/)
C           WRITE(LOUT,1000) IEVT-1
C1000       FORMAT(1X,I8,' events sampled')
         ENDIF
         NEVENT = IEVT
c  treat nuclear emulsions
         IF (IEMUL.GT.0) CALL DT_GETEMU(NTMASS,NTCHAR,KKMAT,0)
c  composite targets only
         KKMAT = -KKMAT
c  sample this event
         CALL DT_KKINC(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,KKMAT,IREJ)


         CALL PHO_PHIST(2000,DUM)


    2 CONTINUE

c print run-statistics and histograms to output-unit 6

      CALL PHO_PHIST(3000,DUM)

      CALL DT_STATIS(2)

      RETURN
      END
c
c===laevt==============================================================*
c
CDECK  ID>, DT_LAEVT
      SUBROUTINE DT_LAEVT(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,
     &                                             IDP,IGLAU)

c***********************************************************************
c Interface to run DPMJET for lepton-nucleus interactions.             *
c Kinematics is sampled using the equivalent photon approximation      *
c Based on GPHERA-routine by R. Engel.                                 *
c This version dated 23.03.96 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY4=1.0D-4,
     &           ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0)
      PARAMETER (TWOPI  = 6.283185307179586454D+00,
     &           PI     = TWOPI/TWO,
     &           ALPHEM = ONE/137.0D0)

C     CHARACTER*72 HEADER

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c kinematical cuts for lepton-nucleus interactions
      COMMON /DTLCUT/ ECMIN,ECMAX,XBJMIN,ELMIN,EGMIN,EGMAX,YMIN,YMAX,
     &                Q2MIN,Q2MAX,THMIN,THMAX,Q2LI,Q2HI,ECMLI,ECMHI

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c kinematics at lepton-gamma vertex
      COMMON /DTLGVX/ PPL0(4),PPL1(4),PPG(4),PPA(4)

c flags for activated histograms
      COMMON /DTHIS3/ IHISPP(50),IHISXS(50),IXSTBL

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c event flag
      COMMON /DTEVNO/ NEVENT,ICASCA


      DIMENSION XDUMB(40),BGTA(4)

c LEPTO
      IF (MCGENE.EQ.3) THEN

         STOP ' THIS VERSION DOES NOT CONTAIN LEPTO !'

      ENDIF

      KKMAT  = 1
      NMSG   = MAX(NEVTS/10,1)

c mass of incident lepton
      AMLPT  = AAM(IDP)
      AMLPT2 = AMLPT**2
      IDPPDG = IDT_IPDGHA(IDP)

c consistency of kinematical limits
      Q2MIN  = MAX(Q2MIN,TINY10)
      Q2MAX  = MAX(Q2MAX,TINY10)
      YMIN   = MIN(MAX(YMIN,TINY10),0.999D0)
      YMAX   = MIN(MAX(YMAX,TINY10),0.999D0)

c total energy of the lepton-nucleon system
      PTOTLN = SQRT( (PLEPT0(1)+PNUCL(1))**2+(PLEPT0(2)+PNUCL(2))**2
     &                                      +(PLEPT0(3)+PNUCL(3))**2 )
      ETOTLN = PLEPT0(4)+PNUCL(4)
      ECMLN  = SQRT((ETOTLN-PTOTLN)*(ETOTLN+PTOTLN))
      ECMAX  = MIN(ECMAX,ECMLN)
      WRITE(ErrorOut,
     * 1003) ECMIN,ECMAX,YMIN,YMAX,Q2MIN,Q2MAX,EGMIN,
     &                 THMIN,THMAX,ELMIN
 1003 FORMAT(1X,'LAEVT:',16X,'KINEMATICAL CUTS',/,22X,
     &       '------------------',/,9X,'W (MIN)   =',
     &       F7.1,' GEV    (MAX) =',F7.1,' GEV',/,9X,'Y (MIN)   =',
     &       F7.3,8X,'(MAX) =',F7.3,/,9X,'Q^2 (MIN) =',F7.1,
     &       ' GEV^2  (MAX) =',F7.1,' GEV^2',/,' (LAB)   E_G (MIN) ='
     &       ,F7.1,' GEV',/,' (LAB) THETA (MIN) =',F7.4,8X,'(MAX) =',
     &       F7.4,'   FOR E_LPT >',F7.1,' GEV',/)

c Lorentz-parameter for transf. into Lab
      BGTA(1) = PNUCL(1)/AAM(1)
      BGTA(2) = PNUCL(2)/AAM(1)
      BGTA(3) = PNUCL(3)/AAM(1)
      BGTA(4) = PNUCL(4)/AAM(1)
c LT of incident lepton into Lab and dump it in DTEVT1
      CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &            PLEPT0(1),PLEPT0(2),PLEPT0(3),PLEPT0(4),
     &            PLTOT,PPL0(1),PPL0(2),PPL0(3),PPL0(4))
      CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &            PNUCL(1),PNUCL(2),PNUCL(3),PNUCL(4),
     &            PLTOT,PPA(1),PPA(2),PPA(3),PPA(4))
c maximum energy of photon nucleon system
      PTOTGN = SQRT((YMAX*PPL0(1)+PPA(1))**2+(YMAX*PPL0(2)+PPA(2))**2
     &                                      +(YMAX*PPL0(3)+PPA(3))**2)
      ETOTGN = YMAX*PPL0(4)+PPA(4)
      EGNMAX = SQRT((ETOTGN-PTOTGN)*(ETOTGN+PTOTGN))
      EGNMAX = MIN(EGNMAX,ECMAX)
c minimum energy of photon nucleon system
      PTOTGN = SQRT((YMIN*PPL0(1)+PPA(1))**2+(YMIN*PPL0(2)+PPA(2))**2
     &                                      +(YMIN*PPL0(3)+PPA(3))**2)
      ETOTGN = YMIN*PPL0(4)+PPA(4)
      EGNMIN = SQRT((ETOTGN-PTOTGN)*(ETOTGN+PTOTGN))
      EGNMIN = MAX(EGNMIN,ECMIN)

c limits for Glauber-initialization
      Q2LI  = Q2MIN
      Q2HI  = MAX(Q2LI,MIN(Q2HI,Q2MAX))
      ECMLI = MAX(EGNMIN,THREE)
      ECMHI = EGNMAX
      WRITE(ErrorOut,1004) EGNMIN,EGNMAX,ECMLI,ECMHI,Q2LI,Q2HI
 1004 FORMAT(1X,'RESULTING LIMITS:',/,9X,'W (MIN)   =',F7.1,
     &       ' GEV    (MAX) =',F7.1,' GEV',/,/,' LIMITS FOR ',
     &       'GLAUBER-INITIALIZATION:',/,9X,'W (MIN)   =',F7.1,
     &       ' GEV    (MAX) =',F7.1,' GEV',/,9X,'Q^2 (MIN) =',F7.1,
     &       ' GEV^2  (MAX) =',F7.1,' GEV^2',/)
c initialization of Glauber-formalism
      IF (NCOMPO.LE.0) THEN
         CALL DT_SHMAKI(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,IGLAU)
      ELSE
         DO 9 I=1,NCOMPO
            CALL DT_SHMAKI(NPMASS,NPCHAR,IEMUMA(I),IEMUCH(I),IDP,EPN,0)
    9    CONTINUE
      ENDIF
      CALL DT_SIGEMU

c initialization of run-statistics and histograms
      CALL DT_STATIS(1)

      CALL PHO_PHIST(1000,DUM)


c maximum photon-nucleus cross section
      I1  = 1
      I2  = 1
      RAT = ONE
      IF (EGNMAX.GE.ECMNN(NEBINI)) THEN
         I1  = NEBINI
         I2  = NEBINI
         RAT = ONE
      ELSEIF (EGNMAX.GT.ECMNN(1)) THEN
         DO 5 I=2,NEBINI
            IF (EGNMAX.LT.ECMNN(I)) THEN
               I1  = I-1
               I2  = I
               RAT = (EGNMAX-ECMNN(I1))/(ECMNN(I2)-ECMNN(I1))
               GOTO 6
            ENDIF
    5    CONTINUE
    6    CONTINUE
      ENDIF
      SIGMAX = XSTOT(I1,1,1)+RAT*(XSTOT(I2,1,1)-XSTOT(I1,1,1))
      EGNXX  = EGNMAX
      I1  = 1
      I2  = 1
      RAT = ONE
      IF (EGNMIN.GE.ECMNN(NEBINI)) THEN
         I1  = NEBINI
         I2  = NEBINI
         RAT = ONE
      ELSEIF (EGNMIN.GT.ECMNN(1)) THEN
         DO 7 I=2,NEBINI
            IF (EGNMIN.LT.ECMNN(I)) THEN
               I1  = I-1
               I2  = I
               RAT = (EGNMIN-ECMNN(I1))/(ECMNN(I2)-ECMNN(I1))
               GOTO 8
            ENDIF
    7    CONTINUE
    8    CONTINUE
      ENDIF
      SIGXX = XSTOT(I1,1,1)+RAT*(XSTOT(I2,1,1)-XSTOT(I1,1,1))
      IF (SIGXX.GT.SIGMAX) EGNXX = EGNMIN
      SIGMAX = MAX(SIGMAX,SIGXX)
      WRITE(ErrorOut,
     * '(9X,A,F8.3,A)') 'Sigma_tot (max) =',SIGMAX,' mb'

c plot photon flux table
      AYMIN = LOG(YMIN)
      AYMAX = LOG(YMAX)
      AYRGE = AYMAX-AYMIN
      MAXTAB = 50
      ADY    = LOG(YMAX/YMIN)/DBLE(MAXTAB-1)
C     WRITE(LOUT,'(/,1X,A)') 'LAEVT:   photon flux '
      DO 1 I=1,MAXTAB
         Y     = EXP(AYMIN+ADY*DBLE(I-1))
         Q2LOW = MAX(Q2MIN,AMLPT2*Y**2/(ONE-Y))
         FF1   = ALPHEM/TWOPI * ((ONE+(ONE-Y)**2)/Y*LOG(Q2MAX/Q2LOW)
     &                           -TWO*AMLPT2*Y*(ONE/Q2LOW-ONE/Q2MAX))
         FF2   = ALPHEM/TWOPI * ((ONE+(ONE-Y)**2)/Y*LOG(Q2MAX/Q2LOW)
     &                           -TWO*(ONE-Y)/Y*(ONE-Q2LOW/Q2MAX))
C        WRITE(LOUT,'(5X,3E15.4)') Y,FF1,FF2
    1 CONTINUE

c maximum residual weight for flux sampling (dy/y)
      YY     = YMIN
      Q2LOW  = MAX(Q2MIN,AMLPT2*YY**2/(ONE-YY))
      WGHMAX = (ONE+(ONE-YY)**2)*LOG(Q2MAX/Q2LOW)
     &         -TWO*AMLPT2*YY*(ONE/Q2LOW-ONE/Q2MAX)*YY

      CALL DT_NEWHGR(YMIN,YMAX,ZERO,XDUMB,49,IHFLY0)
      CALL DT_NEWHGR(YMIN,YMAX,ZERO,XDUMB,49,IHFLY1)
      CALL DT_NEWHGR(YMIN,YMAX,ZERO,XDUMB,49,IHFLY2)
      CALL DT_NEWHGR(Q2LOW,Q2MAX,ZERO,XDUMB,20,IHFLQ0)
      CALL DT_NEWHGR(Q2LOW,Q2MAX,ZERO,XDUMB,20,IHFLQ1)
      CALL DT_NEWHGR(Q2LOW,Q2MAX,ZERO,XDUMB,20,IHFLQ2)
      CALL DT_NEWHGR(EGNMIN,EGNMAX,ZERO,XDUMB,20,IHFLE0)
      CALL DT_NEWHGR(EGNMIN,EGNMAX,ZERO,XDUMB,20,IHFLE1)
      CALL DT_NEWHGR(EGNMIN,EGNMAX,ZERO,XDUMB,20,IHFLE2)
      CALL DT_NEWHGR(ZERO,EGMAX,ZERO,XDUMB,20,IHFLU0)
      CALL DT_NEWHGR(ZERO,EGMAX,ZERO,XDUMB,20,IHFLU1)
      CALL DT_NEWHGR(ZERO,EGMAX,ZERO,XDUMB,20,IHFLU2)
      XBLOW = 0.001D0
      CALL DT_NEWHGR(XBLOW,ONE,ZERO,XDUMB,-40,IHFLX0)
      CALL DT_NEWHGR(XBLOW,ONE,ZERO,XDUMB,-40,IHFLX1)
      CALL DT_NEWHGR(XBLOW,ONE,ZERO,XDUMB,-40,IHFLX2)

      ITRY = 0
      ITRW = 0
      NC0  = 0
      NC1  = 0

c generate events
      DO 2 IEVT=1,NEVTS
         IF (MOD(IEVT,NMSG).EQ.0) THEN
C           OPEN(LLOOK,FILE='/scrtch3/hr/sroesler/statusd5.out',
C    &                                         STATUS='UNKNOWN')
            WRITE(ErrorOut,'(1X,I8,A)') IEVT-1,' events sampled'
C           CLOSE(LLOOK)
         ENDIF
         NEVENT = IEVT

  100    CONTINUE
         ITRY = ITRY+1

c  sample y
  101    CONTINUE
         ITRW  = ITRW+1
         YY    = EXP(AYRGE*DT_RNDM(RAT)+AYMIN)
         Q2LOW = MAX(Q2MIN,AMLPT2*YY**2/(ONE-YY))
         Q2LOG = LOG(Q2MAX/Q2LOW)
         WGH   = (ONE+(ONE-YY)**2)*Q2LOG
     &           -TWO*AMLPT2*YY*(ONE/Q2LOW-ONE/Q2MAX)*YY
         IF (WGHMAX.LT.WGH) WRITE(ErrorOut,1000) YY,WGHMAX,WGH
 1000    FORMAT(1X,'LAEVT:   WEIGHT ERROR!',3E12.5)
         IF (DT_RNDM(YY)*WGHMAX.GT.WGH) GOTO 101

c  sample Q2
         YEFF = ONE+(ONE-YY)**2
  102    CONTINUE
         Q2  = Q2LOW*EXP(Q2LOG*DT_RNDM(YY))
         WGH = (YEFF-TWO*(ONE-YY)*Q2LOW/Q2)/YEFF
         IF (WGH.LT.DT_RNDM(Q2)) GOTO 102

c        NC0 = NC0+1
c        CALL DT_FILHGR(YY,ONE,IHFLY0,NC0)
c        CALL DT_FILHGR(Q2,ONE,IHFLQ0,NC0)

c  kinematics at lepton-photon vertex
c   scattered electron
         YQ2 = SQRT((ONE-YY)*Q2)
         Q2E = Q2/(4.0D0*PLEPT0(4))
         E1Y = (ONE-YY)*PLEPT0(4)
         CALL DT_DSFECF(SIF,COF)
         PLEPT1(1) = YQ2*COF
         PLEPT1(2) = YQ2*SIF
         PLEPT1(3) = E1Y-Q2E
         PLEPT1(4) = E1Y+Q2E
C        THETA = ACOS( (E1Y-Q2E)/(E1Y+Q2E) )
c   radiated photon
         PGAMM(1) = -PLEPT1(1)
         PGAMM(2) = -PLEPT1(2)
         PGAMM(3) = PLEPT0(3)-PLEPT1(3)
         PGAMM(4) = PLEPT0(4)-PLEPT1(4)
c   E_cm cut
         PTOTGN = SQRT( (PGAMM(1)+PNUCL(1))**2+(PGAMM(2)+PNUCL(2))**2
     &                                        +(PGAMM(3)+PNUCL(3))**2 )
         ETOTGN = PGAMM(4)+PNUCL(4)
         ECMGN  = (ETOTGN-PTOTGN)*(ETOTGN+PTOTGN)
         IF (ECMGN.LT.0.1D0) GOTO 101
         ECMGN  = SQRT(ECMGN)
         IF ((ECMGN.LT.ECMIN).OR.(ECMGN.GT.ECMAX)) GOTO 101

c  Lorentz-transformation into nucleon-rest system
         CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &               PGAMM(1),PGAMM(2),PGAMM(3),PGAMM(4),
     &               PGTOT,PPG(1),PPG(2),PPG(3),PPG(4))
         CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &               PLEPT1(1),PLEPT1(2),PLEPT1(3),PLEPT1(4),
     &               PLTOT,PPL1(1),PPL1(2),PPL1(3),PPL1(4))
c  temporary checks..
         Q2TMP = ABS(PPG(4)**2-PGTOT**2)
         IF (ABS(Q2-Q2TMP).GT.0.01D0) WRITE(ErrorOut,
     * 1001) Q2,Q2TMP
 1001    FORMAT(1X,'LAEVT:    INCONSISTENT KINEMATICS (Q2,Q2TMP) ',
     &          2F10.4)
         ECMTMP = SQRT((PPG(4)+AAM(1)-PGTOT)*(PPG(4)+AAM(1)+PGTOT))
         IF (ABS(ECMGN-ECMTMP).GT.TINY10) WRITE(ErrorOut,
     * 1002) ECMGN,ECMTMP
 1002    FORMAT(1X,'LAEVT:    INCONSISTENT KINEMATICS (ECMGN,ECMTMP) ',
     &          2F10.2)
         YYTMP = PPG(4)/PPL0(4)
         IF (ABS(YY-YYTMP).GT.0.01D0) WRITE(ErrorOut,
     * 1005) YY,YYTMP
 1005    FORMAT(1X,'LAEVT:    INCONSISTENT KINEMATICS (YY,YYTMP) ',
     &          2F10.4)

c  lepton tagger (Lab)
         THETA = ACOS( PPL1(3)/PLTOT )
         IF (PPL1(4).GT.ELMIN) THEN
            IF ((THETA.LT.THMIN).OR.(THETA.GT.THMAX)) GOTO 101
         ENDIF
c  photon energy-cut (Lab)
         IF (PPG(4).LT.EGMIN) GOTO 101
         IF (PPG(4).GT.EGMAX) GOTO 101
c   x_Bj cut
         XBJ = ABS(Q2/(1.876D0*PPG(4)))
         IF (XBJ.LT.XBJMIN) GOTO 101

         NC0 = NC0+1
         CALL DT_FILHGR(    Q2,ONE,IHFLQ0,NC0)
         CALL DT_FILHGR(    YY,ONE,IHFLY0,NC0)
         CALL DT_FILHGR(   XBJ,ONE,IHFLX0,NC0)
         CALL DT_FILHGR(PPG(4),ONE,IHFLU0,NC0)
         CALL DT_FILHGR( ECMGN,ONE,IHFLE0,NC0)

c  rotation angles against z-axis
         COD = PPG(3)/PGTOT
C        SID = SQRT((ONE-COD)*(ONE+COD))
         PPT = SQRT(PPG(1)**2+PPG(2)**2)
         SID = PPT/PGTOT
         COF = ONE
         SIF = ZERO
         IF (PGTOT*SID.GT.TINY10) THEN
            COF   = PPG(1)/(SID*PGTOT)
            SIF   = PPG(2)/(SID*PGTOT)
            ANORF = SQRT(COF*COF+SIF*SIF)
            COF   = COF/ANORF
            SIF   = SIF/ANORF
         ENDIF

         IF (IXSTBL.EQ.0) THEN
c  change to photon projectile
            IJPROJ = 7
c  set virtuality
            VIRT = Q2
c  re-initialize LTs with new kinematics
c  !!PGAMM ist set in cms (ECMGN) along z
            EPN = ZERO
            PPN = ZERO
            CALL DT_LTINI(IJPROJ,IJTARG,EPN,PPN,ECMGN,0)
c  force Lab-system
            IFRAME = 1
c  get emulsion component if requested
            IF (IEMUL.GT.0) CALL DT_GETEMU(NTMASS,NTCHAR,KKMAT,0)
c  convolute with cross section
            CALL DT_SIGGAT(Q2LOW,EGNXX,STOTX,KKMAT)
            CALL DT_SIGGAT(Q2,ECMGN,STOT,KKMAT)
            IF (STOTX.LT.STOT) WRITE(ErrorOut,'(1X,A,/,6E12.3)')
     &         'LAEVT: WARNING STOTX<STOT ! ',Q2LOW,EGNMAX,STOTX,
     &                                        Q2,ECMGN,STOT
            IF (DT_RNDM(Q2)*STOTX.GT.STOT) GOTO 100
            NC1 = NC1+1
            CALL DT_FILHGR(    Q2,ONE,IHFLQ1,NC1)
            CALL DT_FILHGR(    YY,ONE,IHFLY1,NC1)
            CALL DT_FILHGR(   XBJ,ONE,IHFLX1,NC1)
            CALL DT_FILHGR(PPG(4),ONE,IHFLU1,NC1)
            CALL DT_FILHGR( ECMGN,ONE,IHFLE1,NC1)
c  composite targets only
            KKMAT = -KKMAT
c  sample this event
            CALL DT_KKINC(NPMASS,NPCHAR,NTMASS,NTCHAR,IJPROJ,EPN,KKMAT,
     &                                                            IREJ)
c  rotate momenta of final state particles back in photon-nucleon syst.
            DO 4 I=NPOINT(4),NHKK
               IF ((ABS(ISTHKK(I)).EQ.1).OR.(ISTHKK(I).EQ.1000).OR.
     &                                      (ISTHKK(I).EQ.1001)) THEN
                  PX = PHKK(1,I)
                  PY = PHKK(2,I)
                  PZ = PHKK(3,I)
                  CALL DT_MYTRAN(1,PX,PY,PZ,COD,SID,COF,SIF,
     &                        PHKK(1,I),PHKK(2,I),PHKK(3,I))
               ENDIF
    4       CONTINUE
         ENDIF

         CALL DT_FILHGR(    Q2,ONE,IHFLQ2,NC1)
         CALL DT_FILHGR(    YY,ONE,IHFLY2,NC1)
         CALL DT_FILHGR(   XBJ,ONE,IHFLX2,NC1)
         CALL DT_FILHGR(PPG(4),ONE,IHFLU2,NC1)
         CALL DT_FILHGR( ECMGN,ONE,IHFLE2,NC1)

c  dump this event to histograms

         CALL PHO_PHIST(2000,DUM)


    2 CONTINUE

      WGY    = ALPHEM/TWOPI*WGHMAX*DBLE(ITRY)/DBLE(ITRW)
      WGY    = WGY*LOG(YMAX/YMIN)
      WEIGHT = WGY*SIGMAX*DBLE(NEVTS)/DBLE(ITRY)

C     HEADER = ' LAEVT:  Q^2 distribution 0'
C     CALL DT_OUTHGR(IHFLQ0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  Q^2 distribution 1'
C     CALL DT_OUTHGR(IHFLQ1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  Q^2 distribution 2'
C     CALL DT_OUTHGR(IHFLQ2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  y   distribution 0'
C     CALL DT_OUTHGR(IHFLY0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  y   distribution 1'
C     CALL DT_OUTHGR(IHFLY1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  y   distribution 2'
C     CALL DT_OUTHGR(IHFLY2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  x   distribution 0'
C     CALL DT_OUTHGR(IHFLX0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  x   distribution 1'
C     CALL DT_OUTHGR(IHFLX1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  x   distribution 2'
C     CALL DT_OUTHGR(IHFLX2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_g distribution 0'
C     CALL DT_OUTHGR(IHFLU0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_g distribution 1'
C     CALL DT_OUTHGR(IHFLU1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_g distribution 2'
C     CALL DT_OUTHGR(IHFLU2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_c distribution 0'
C     CALL DT_OUTHGR(IHFLE0,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_c distribution 1'
C     CALL DT_OUTHGR(IHFLE1,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)
C     HEADER = ' LAEVT:  E_c distribution 2'
C     CALL DT_OUTHGR(IHFLE2,0,0,0,0,0,HEADER,0,NEVTS,ONE,1,1,-1)

c print run-statistics and histograms to output-unit 6

      CALL PHO_PHIST(3000,DUM)

      IF (IXSTBL.EQ.0) CALL DT_STATIS(2)

      RETURN
      END
c
c===dtuini=============================================================*
c
CDECK  ID>, DT_DTUINI
      SUBROUTINE DT_DTUINI(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,
     &                                               IDP,IEMU)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD


      CALL DT_INIT(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,IGLAU)
      CALL DT_STATIS(1)

      CALL PHO_PHIST(1000,DUM)

      IF (NCOMPO.LE.0) THEN
         CALL DT_SHMAKI(NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,EPN,IGLAU)
      ELSE
         DO 1 I=1,NCOMPO
            CALL DT_SHMAKI(NPMASS,NPCHAR,IEMUMA(I),IEMUCH(I),IDP,EPN,0)
    1    CONTINUE
      ENDIF
      IF (IOGLB.NE.100) CALL DT_SIGEMU
      IEMU = IEMUL

      RETURN
      END
c
c===dtuout=============================================================*
c
CDECK  ID>, DT_DTUOUT
      SUBROUTINE DT_DTUOUT

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE


      CALL PHO_PHIST(3000,DUM)

      CALL DT_STATIS(2)

      RETURN
      END
c
c===beam===============================================================*
c
CDECK  ID>, DT_BEAMPR
      SUBROUTINE DT_BEAMPR(WHAT,PLAB,MODE)

c***********************************************************************
c Initialization of event generation                                   *
c This version dated  7.4.98  is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (LIN=5,LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY10=1.0D-10)
      PARAMETER (TWOPI=6.283185307D0,BOG=TWOPI/360.0D0)

      LOGICAL LBEAM

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c beam momenta
      COMMON /DTBEAM/ P1(4),P2(4)


C     DIMENSION WHAT(6),P1(4),P2(4),P1CMS(4),P2CMS(4)
      DIMENSION WHAT(6),P1CMS(4),P2CMS(4)

      DATA LBEAM /.FALSE./

      GOTO (1,2) MODE

    1 CONTINUE

      E1  = WHAT(1)
      IF (E1.LT.ZERO) E1 = DBLE(IPZ)/DBLE(IP)*ABS(WHAT(1))
      E2  = WHAT(2)
      IF (E2.LT.ZERO) E2 = DBLE(ITZ)/DBLE(IT)*ABS(WHAT(2))
      PP1 = SQRT( (E1+AAM(IJPROJ))*(E1-AAM(IJPROJ)) )
      PP2 = SQRT( (E2+AAM(IJTARG))*(E2-AAM(IJTARG)) )
      TH  = 1.D-6*WHAT(3)/2.D0
      PH  = WHAT(4)*BOG
      P1(1) = PP1*SIN(TH)*COS(PH)
      P1(2) = PP1*SIN(TH)*SIN(PH)
      P1(3) = PP1*COS(TH)
      P1(4) = E1
      P2(1) = PP2*SIN(TH)*COS(PH)
      P2(2) = PP2*SIN(TH)*SIN(PH)
      P2(3) = -PP2*COS(TH)
      P2(4) = E2
      ECM  = SQRT( (P1(4)+P2(4))**2-(P1(1)+P2(1))**2-(P1(2)+P2(2))**2
     &                                              -(P1(3)+P2(3))**2 )
      ELAB = (ECM**2-AAM(IJPROJ)**2-AAM(IJTARG)**2)/(2.0D0*AAM(IJTARG))
      PLAB = SQRT( (ELAB+AAM(IJPROJ))*(ELAB-AAM(IJPROJ)) )
      BGX  = (P1(1)+P2(1))/ECM
      BGY  = (P1(2)+P2(2))/ECM
      BGZ  = (P1(3)+P2(3))/ECM
      BGE  = (P1(4)+P2(4))/ECM
      CALL DT_DALTRA(BGE,-BGX,-BGY,-BGZ,P1(1),P1(2),P1(3),P1(4),
     &            P1TOT,P1CMS(1),P1CMS(2),P1CMS(3),P1CMS(4))
      CALL DT_DALTRA(BGE,-BGX,-BGY,-BGZ,P2(1),P2(2),P2(3),P2(4),
     &            P2TOT,P2CMS(1),P2CMS(2),P2CMS(3),P2CMS(4))
      COD = P1CMS(3)/P1TOT
C     SID = SQRT((ONE-COD)*(ONE+COD))
      PPT = SQRT(P1CMS(1)**2+P1CMS(2)**2)
      SID = PPT/P1TOT
      COF = ONE
      SIF = ZERO
      IF (P1TOT*SID.GT.TINY10) THEN
         COF   = P1CMS(1)/(SID*P1TOT)
         SIF   = P1CMS(2)/(SID*P1TOT)
         ANORF = SQRT(COF*COF+SIF*SIF)
         COF   = COF/ANORF
         SIF   = SIF/ANORF
      ENDIF
c*check
C     WRITE(LOUT,'(4E15.4)') P1(1),P1(2),P1(3),P1(4)
C     WRITE(LOUT,'(4E15.4)') P2(1),P2(2),P2(3),P2(4)
C     WRITE(LOUT,'(5E15.4)') P1CMS(1),P1CMS(2),P1CMS(3),P1CMS(4),P1TOT
C     WRITE(LOUT,'(5E15.4)') P2CMS(1),P2CMS(2),P2CMS(3),P2CMS(4),P2TOT
C     PAX = ZERO
C     PAY = ZERO
C     PAZ = P1TOT
C     PAE = SQRT(AAM(IJPROJ)**2+PAZ**2)
C     PBX = ZERO
C     PBY = ZERO
C     PBZ = -P2TOT
C     PBE = SQRT(AAM(IJTARG)**2+PBZ**2)
C     WRITE(LOUT,'(4E15.4)') PAX,PAY,PAZ,PAE
C     WRITE(LOUT,'(4E15.4)') PBX,PBY,PBZ,PBE
C     CALL DT_MYTRAN(1,PAX,PAY,PAZ,COD,SID,COF,SIF,
C    &            P1CMS(1),P1CMS(2),P1CMS(3))
C     CALL DT_MYTRAN(1,PBX,PBY,PBZ,COD,SID,COF,SIF,
C    &            P2CMS(1),P2CMS(2),P2CMS(3))
C     WRITE(LOUT,'(4E15.4)') P1CMS(1),P1CMS(2),P1CMS(3),P1CMS(4)
C     WRITE(LOUT,'(4E15.4)') P2CMS(1),P2CMS(2),P2CMS(3),P2CMS(4)
C     CALL DT_DALTRA(BGE,BGX,BGY,BGZ,P1CMS(1),P1CMS(2),P1CMS(3),P1CMS(4),
C    &            P1TOT,P1(1),P1(2),P1(3),P1(4))
C     CALL DT_DALTRA(BGE,BGX,BGY,BGZ,P2CMS(1),P2CMS(2),P2CMS(3),P2CMS(4),
C    &            P2TOT,P2(1),P2(2),P2(3),P2(4))
C     WRITE(LOUT,'(4E15.4)') P1(1),P1(2),P1(3),P1(4)
C     WRITE(LOUT,'(4E15.4)') P2(1),P2(2),P2(3),P2(4)
C     STOP
c*

      LBEAM = .TRUE.

      RETURN

    2 CONTINUE

      IF (LBEAM) THEN
         IF ( (NPOINT(4).EQ.0).OR.(NHKK.LT.NPOINT(4)) ) RETURN
         DO 20 I=NPOINT(4),NHKK
            IF ((ABS(ISTHKK(I)).EQ.1).OR.(ISTHKK(I).EQ.1000).OR.
     &                                   (ISTHKK(I).EQ.1001)) THEN
               CALL DT_MYTRAN(1,PHKK(1,I),PHKK(2,I),PHKK(3,I),
     &                     COD,SID,COF,SIF,PXCMS,PYCMS,PZCMS)
               PECMS = PHKK(4,I)
               CALL DT_DALTRA(BGE,BGX,BGY,BGZ,PXCMS,PYCMS,PZCMS,PECMS,
     &                     PTOT,PHKK(1,I),PHKK(2,I),PHKK(3,I),PHKK(4,I))
            ENDIF
   20    CONTINUE
      ELSE
         MODE = -1
      ENDIF

      RETURN
      END
c
c===eventb=============================================================*
c
CDECK  ID>, DT_EVENTB
      SUBROUTINE DT_EVENTB(NCSY,IREJ)

c***********************************************************************
c Treatment of nucleon-nucleon interactions with full two-component    *
c Dual Parton Model.                                                   *
c          NCSY     number of nucleon-nucleon interactions             *
c          IREJ     rejection flag                                     *
c This version dated 14.01.2000 is written by S. Roesler               *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0,ONE=1.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c! uncomment this line for internal phojet-fragmentation
C #include "dtu_dtevtp.inc"
c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c DTUNUC-PHOJET interface, Lorentz-param. of n-n subsystem
      COMMON /DTLTSU/ BGX,BGY,BGZ,GAM

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c statistics: double-Pomeron exchange
      COMMON /DTFLG2/ INTFLG,IPOPO

c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

C  nucleon-nucleus / nucleus-nucleus interface to DTUNUC
      INTEGER IDEQP,IDEQB,IHFLD,IHFLS
      DOUBLE PRECISION ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB
      COMMON /POHDFL/ ECMN,PCMN,SECM,SPCM,XPSUB,XTSUB,
     &                IDEQP(2),IDEQB(2),IHFLD(2,2),IHFLS(2)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  initial state parton radiation (internal part)
      INTEGER MXISR3,MXISR4
      PARAMETER ( MXISR3 = 50, MXISR4 = 100 )
      INTEGER IFL1,IFL2,IBRA,IFANO,ISH,NACC
      DOUBLE PRECISION Q2SH,PT2SH,XPSH,ZPSH,THSH,SHAT
      COMMON /POINT6/ Q2SH(2,MXISR3),PT2SH(2,MXISR3),XPSH(2,MXISR3),
     &                ZPSH(2,MXISR3),THSH(2,MXISR3),SHAT(MXISR3),
     &                IFL1(2,MXISR3),IFL2(2,MXISR3),
     &                IBRA(2,MXISR4),IFANO(2),ISH(2),NACC

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)


      DIMENSION PP(4),PT(4),PTOT(4),PP1(4),PP2(4),PT1(4),PT2(4),
     &          PPNN(4),PTNN(4),PTOTNN(4),PPSUB(4),PTSUB(4),
     &          PPTCMS(4),PTTCMS(4),PPTMP(4),PTTMP(4),
     &          KPRON(15),ISINGL(2000)

c initial values for max. number of phojet scatterings and dtunuc chains
c to be fragmented with one pyexec call
      DATA MXPHFR,MXDTFR /10,100/

      IREJ      = 0
c pointer to first parton of the first chain in dtevt common
      NPOINT(3) = NHKK+1
c special flag for double-Pomeron statistics
      IPOPO = 1
c counter for low-mass (DTUNUC) interactions
      NDTUSC = 0
c counter for interactions treated by PHOJET
      NPHOSC = 0

c scan interactions for single nucleon-nucleon interactions
c (this has to be checked here because Cronin modifies parton momenta)
      NC = NPOINT(2)
      IF (NCSY.GT.2000) STOP ' DT_EVENTB: NCSY > 2000 ! '
      DO 8 I=1,NCSY
         ISINGL(I) = 0
         MOP = JMOHKK(1,NC)
         MOT = JMOHKK(1,NC+1)
         DIFF1 = ABS(PHKK(4,MOP)-PHKK(4,  NC)-PHKK(4,NC+2))
         DIFF2 = ABS(PHKK(4,MOT)-PHKK(4,NC+1)-PHKK(4,NC+3))
         IF ((DIFF1.LT.TINY10).AND.(DIFF2.LT.TINY10)) ISINGL(I) = 1
         NC = NC+4
    8 CONTINUE

c multiple scattering of chain ends
      IF ((IP.GT.1).AND.(MKCRON.NE.0)) CALL DT_CRONIN(1)
      IF ((IT.GT.1).AND.(MKCRON.NE.0)) CALL DT_CRONIN(2)

c switch to PHOJET-settings for JETSET parameter
      CALL DT_INITJS(1)

c loop over nucleon-nucleon interaction
      NC = NPOINT(2)
      DO 2 I=1,NCSY
c
c   pick up one nucleon-nucleon interaction from DTEVT1
c     ppnn  / ptnn   - momenta of the interacting nucleons (cms)
c     ptotnn         - total momentum of the interacting nucleons (cms)
c     pp1,2 / pt1,2  - momenta of the four partons
c     pp    / pt     - total momenta of the proj / targ partons
c     ptot           - total momentum of the four partons
         MOP = JMOHKK(1,NC)
         MOT = JMOHKK(1,NC+1)
         DO 3 K=1,4
            PPNN(K)   = PHKK(K,MOP)
            PTNN(K)   = PHKK(K,MOT)
            PTOTNN(K) = PPNN(K)+PTNN(K)
            PP1(K)    = PHKK(K,NC)
            PT1(K)    = PHKK(K,NC+1)
            PP2(K)    = PHKK(K,NC+2)
            PT2(K)    = PHKK(K,NC+3)
            PP(K)     = PP1(K)+PP2(K)
            PT(K)     = PT1(K)+PT2(K)
            PTOT(K)   = PP(K)+PT(K)
    3    CONTINUE
c
c-----------------------------------------------------------------------
c   this is a complete nucleon-nucleon interaction
c
         IF (ISINGL(I).EQ.1) THEN
c
c     initialize PHOJET-variables for remnant/valence-partons
            IHFLD(1,1) = 0
            IHFLD(1,2) = 0
            IHFLD(2,1) = 0
            IHFLD(2,2) = 0
            IHFLS(1) = 1
            IHFLS(2) = 1
c     save current settings of PHOJET process and min. bias flags
            DO 9 K=1,11
               KPRON(K) = IPRON(K,1)
    9       CONTINUE
            ISWSAV   = ISWMDL(2)
c
c     check if forced sampling of diffractive interaction requested
            IF (ISINGD.LT.-1) THEN
               DO 90 K=1,11
                  IPRON(K,1) = 0
   90          CONTINUE
               IF ((ISINGD.EQ.-2).OR.(ISINGD.EQ.-3)) IPRON(5,1) = 1
               IF ((ISINGD.EQ.-2).OR.(ISINGD.EQ.-4)) IPRON(6,1) = 1
               IF (ISINGD.EQ.-5) IPRON(4,1) = 1
            ENDIF
c
c     for photons: a direct/anomalous interaction is not sampled
c     in PHOJET but already in Glauber-formalism. Here we check if such
c     an interaction is requested
            IF (IJPROJ.EQ.7) THEN
c       first switch off direct interactions
               IPRON(8,1) = 0
c       this is a direct interactions
               IF (IDIREC.EQ.1) THEN
                  DO 12 K=1,11
                     IPRON(K,1) = 0
   12             CONTINUE
                  IPRON(8,1) = 1
c       this is an anomalous interactions
c         (iswmdl(2) = 0 only hard int. generated ( = 1 min. bias) )
               ELSEIF (IDIREC.EQ.2) THEN
                  ISWMDL(2) = 0
               ENDIF
            ELSE
               IF (IDIREC.NE.0) STOP ' DT_EVENTB: IDIREC > 0 ! '
            ENDIF
c
c     make sure that total momenta of partons, pp and pt, are on mass
c     shell (Cronin may have srewed this up..)
            CALL DT_MASHEL(PP,PT,PHKK(5,MOP),PHKK(5,MOT),PPNN,PTNN,IR1)
            IF (IR1.NE.0) THEN
               IF (IOULEV(1).GT.0) WRITE(ErrorOut,'(1X,A)')
     &              'EVENTB:  MASS SHELL CORRECTION REJECTED'
               GOTO 9999
            ENDIF
c
c     initialize the incoming particles in PHOJET
            IF ((IP.EQ.1).AND.(IJPROJ.EQ.7)) THEN

               CALL PHO_SETPAR(1,22,0,VIRT)

            ELSE

               CALL PHO_SETPAR(1,IDHKK(MOP),0,ZERO)

            ENDIF

            CALL PHO_SETPAR(2,IDHKK(MOT),0,ZERO)

c
c     initialize rejection loop counter for anomalous processes
            IRJANO = 0
  800       CONTINUE
            IRJANO = IRJANO+1
c
c     temporary fix for ifano problem
            IFANO(1) = 0
            IFANO(2) = 0
c
c     generate complete hadron/nucleon/photon-nucleon event with PHOJET

            CALL PHO_EVENT(2,PPNN,PTNN,DUM,IREJ1)

c
c     for photons: special consistency check for anomalous interactions
            IF (IJPROJ.EQ.7) THEN
               IF (IRJANO.LT.30) THEN
                  IF (IFANO(1).NE.0) THEN
c       here, an anomalous interaction was generated. Check if it
c       was also requested. Otherwise reject this event.
                     IF (IDIREC.EQ.0) GOTO 800
                  ELSE
c       here, an anomalous interaction was not generated. Check if it
c       was requested in which case we need to reject this event.
                     IF (IDIREC.EQ.2) GOTO 800
                  ENDIF
               ELSE
                  WRITE(ErrorOut,
     * *) ' DT_EVENTB: Warning! IRJANO > 30 ',
     &                          IRJANO,IDIREC,NEVHKK
               ENDIF
            ENDIF
c
c     copy back original settings of PHOJET process and min. bias flags
            DO 10 K=1,11
               IPRON(K,1) = KPRON(K)
   10       CONTINUE
            ISWMDL(2) = ISWSAV
c
c     check if PHOJET has rejected this event
            IF (IREJ1.NE.0) THEN
C              IF (IOULEV(1).GT.0) WRITE(LOUT,'(1X,A,I4)')
               WRITE(ErrorOut,'(1X,A,I4)')
     &            'EVENTB:  CHAIN SYSTEM REJECTED',IDIREC

               CALL PHO_PREVNT(0)

               GOTO 9999
            ENDIF
c
c     copy partons and strings from PHOJET common back into DTEVT for
c     external fragmentation
            MO1 = NC
            MO2 = NC+3
c!      uncomment this line for internal phojet-fragmentation
C           CALL DT_GETFSP(MO1,MO2,PPNN,PTNN,-1)
            NPHOSC = NPHOSC+1
            CALL DT_GETPJE(MO1,MO2,PPNN,PTNN,-1,NPHOSC,IREJ1)
            IF (IREJ1.NE.0) THEN
               IF (IOULEV(1).GT.0)
     &         WRITE(ErrorOut,
     * '(1X,A,I4)') 'EVENTB: chain system rejected 1'
               GOTO 9999
            ENDIF
c
c     update statistics counter
            ICEVTG(IDCH(NC),29) = ICEVTG(IDCH(NC),29)+1
c
c-----------------------------------------------------------------------
c   this interaction involves "remnants"
c
         ELSE
c
c     total mass of this system
            PPTOT  = SQRT(PTOT(1)**2+PTOT(2)**2+PTOT(3)**2)
            AMTOT2 = (PTOT(4)-PPTOT)*(PTOT(4)+PPTOT)
            IF (AMTOT2.LT.ZERO) THEN
               AMTOT = ZERO
            ELSE
               AMTOT = SQRT(AMTOT2)
            ENDIF
c
c     systems with masses larger than elojet are treated with PHOJET
            IF (AMTOT.GT.ELOJET) THEN
c
c     initialize PHOJET-variables for remnant/valence-partons
c       projectile parton flavors and valence flag
               IHFLD(1,1) = IDHKK(NC)
               IHFLD(1,2) = IDHKK(NC+2)
               IHFLS(1)   = 0
               IF ((IDCH(NC).EQ.6).OR.(IDCH(NC).EQ.7)
     &                            .OR.(IDCH(NC).EQ.8)) IHFLS(1) = 1
c       target parton flavors and valence flag
               IHFLD(2,1) = IDHKK(NC+1)
               IHFLD(2,2) = IDHKK(NC+3)
               IHFLS(2)   = 0
               IF ((IDCH(NC).EQ.4).OR.(IDCH(NC).EQ.5)
     &                            .OR.(IDCH(NC).EQ.8)) IHFLS(2) = 1
c       flag signalizing PHOJET how to treat the remnant:
c         iremn = -1 sea-quark remnant: PHOJET takes flavors from ihfld
c         iremn > -1 valence remnant: PHOJET assumes flavors according
c                    to mother particle
               IREMN1 = IHFLS(1)-1
               IREMN2 = IHFLS(2)-1
c
c     initialize the incoming particles in PHOJET
               IF ((IP.EQ.1).AND.(IJPROJ.EQ.7)) THEN

                  CALL PHO_SETPAR(1,22,IREMN1,VIRT)

               ELSE

                  CALL PHO_SETPAR(1,IDHKK(MOP),IREMN1,ZERO)

               ENDIF

               CALL PHO_SETPAR(2,IDHKK(MOT),IREMN2,ZERO)

c
c     calculate Lorentz parameter of the nucleon-nucleon cm-system
               PPTOTN = SQRT(PTOTNN(1)**2+PTOTNN(2)**2+PTOTNN(3)**2)
               AMNN   = SQRT( (PTOTNN(4)-PPTOTN)*(PTOTNN(4)+PPTOTN) )
               BGX    = PTOTNN(1)/AMNN
               BGY    = PTOTNN(2)/AMNN
               BGZ    = PTOTNN(3)/AMNN
               GAM    = PTOTNN(4)/AMNN
c     transform interacting nucleons into nucleon-nucleon cm-system
               CALL DT_DALTRA(GAM,-BGX,-BGY,-BGZ,
     &                     PPNN(1),PPNN(2),PPNN(3),PPNN(4),PPCMS,
     &                     PPTCMS(1),PPTCMS(2),PPTCMS(3),PPTCMS(4))
               CALL DT_DALTRA(GAM,-BGX,-BGY,-BGZ,
     &                     PTNN(1),PTNN(2),PTNN(3),PTNN(4),PTCMS,
     &                     PTTCMS(1),PTTCMS(2),PTTCMS(3),PTTCMS(4))
c     transform (total) momenta of the proj and targ partons into
c     nucleon-nucleon cm-system
               CALL DT_DALTRA(GAM,-BGX,-BGY,-BGZ,
     &                     PP(1),PP(2),PP(3),PP(4),
     &                     PPTSUB,PPSUB(1),PPSUB(2),PPSUB(3),PPSUB(4))
               CALL DT_DALTRA(GAM,-BGX,-BGY,-BGZ,
     &                     PT(1),PT(2),PT(3),PT(4),
     &                     PTTSUB,PTSUB(1),PTSUB(2),PTSUB(3),PTSUB(4))
c     energy fractions of the proj and targ partons
               XPSUB = MIN(PPSUB(4)/PPTCMS(4),ONE)
               XTSUB = MIN(PTSUB(4)/PTTCMS(4),ONE)
c**
c testprint
c              PTOTCM = SQRT( (PPTCMS(1)+PTTCMS(1))**2 +
c    &                        (PPTCMS(2)+PTTCMS(2))**2 +
c    &                        (PPTCMS(3)+PTTCMS(3))**2 )
c              EOLDCM = SQRT( (PPTCMS(4)+PTTCMS(4)-PTOTCM) *
c    &                        (PPTCMS(4)+PTTCMS(4)+PTOTCM) )
c              PTOTSU = SQRT( (PPSUB(1)+PTSUB(1))**2 +
c    &                        (PPSUB(2)+PTSUB(2))**2 +
c    &                        (PPSUB(3)+PTSUB(3))**2 )
c              EOLDSU = SQRT( (PPSUB(4)+PTSUB(4)-PTOTSU) *
c    &                        (PPSUB(4)+PTSUB(4)+PTOTSU) )
c**
c
c     save current settings of PHOJET process and min. bias flags
               DO 7 K=1,11
                  KPRON(K) = IPRON(K,1)
    7          CONTINUE
c     disallow direct photon int. (does not make sense here anyway)
               IPRON(8,1) = 0
c     disallow double pomeron processes (due to technical problems
c     in PHOJET, needs to be solved sometime)
               IPRON(4,1) = 0
c     disallow diffraction for sea-diquarks
               IF ((IABS(IHFLD(1,1)).GT.1100).AND.
     &             (IABS(IHFLD(1,2)).GT.1100)) THEN
                  IPRON(3,1) = 0
                  IPRON(6,1) = 0
               ENDIF
               IF ((IABS(IHFLD(2,1)).GT.1100).AND.
     &             (IABS(IHFLD(2,2)).GT.1100)) THEN
                  IPRON(3,1) = 0
                  IPRON(5,1) = 0
               ENDIF
c
c     we need massless partons: transform them on mass shell
               XMP = ZERO
               XMT = ZERO
               DO 6 K=1,4
                  PPTMP(K) = PPSUB(K)
                  PTTMP(K) = PTSUB(K)
    6          CONTINUE
               CALL DT_MASHEL(PPTMP,PTTMP,XMP,XMT,PPSUB,PTSUB,IREJ1)
               PPSUTO  = SQRT(PPSUB(1)**2+PPSUB(2)**2+PPSUB(3)**2)
               PTSUTO  = SQRT(PTSUB(1)**2+PTSUB(2)**2+PTSUB(3)**2)
               PSUTOT = SQRT((PPSUB(1)+PTSUB(1))**2+
     &                  (PPSUB(2)+PTSUB(2))**2+(PPSUB(3)+PTSUB(3))**2)
c     total energy of the subsysten after mass transformation
c      (should be the same as before..)
               SECM = SQRT( (PPSUB(4)+PTSUB(4)-PSUTOT)*
     &                      (PPSUB(4)+PTSUB(4)+PSUTOT) )
c
c     after mass shell transformation the x_sub - relation has to be
c     corrected. We therefore create "pseudo-momenta" of mother-nucleons.
c
c     The old version was to scale based on the original x_sub and the
c     4-momenta of the subsystem. At very high energy this could lead to
c     "pseudo-cm energies" of the parent system considerably exceeding
c     the true cm energy. Now we keep the true cm energy and calculate
c     new x_sub instead.
C old version  PPTCMS(4) = PPSUB(4)/XPSUB
               PPTCMS(4) = MAX(PPTCMS(4),PPSUB(4))
               XPSUB = PPSUB(4)/PPTCMS(4)
               IF (IJPROJ.EQ.7) THEN
                  AMP2  = PHKK(5,MOT)**2
                  PTOT1 = SQRT(PPTCMS(4)**2-AMP2)
               ELSE
c???????
                  PTOT1 = SQRT((PPTCMS(4)-PHKK(5,MOP))
     &                        *(PPTCMS(4)+PHKK(5,MOP)))
C                 PTOT1 = SQRT((PPTCMS(4)-PHKK(5,MOT))
C    &                        *(PPTCMS(4)+PHKK(5,MOT)))
               ENDIF
C old version  PTTCMS(4) = PTSUB(4)/XTSUB
               PTTCMS(4) = MAX(PTTCMS(4),PTSUB(4))
               XTSUB = PTSUB(4)/PTTCMS(4)
               PTOT2 = SQRT((PTTCMS(4)-PHKK(5,MOT))
     &                     *(PTTCMS(4)+PHKK(5,MOT)))
               DO 4 K=1,3
                  PPTCMS(K) = PTOT1*PPSUB(K)/PPSUTO
                  PTTCMS(K) = PTOT2*PTSUB(K)/PTSUTO
    4          CONTINUE
c**
c testprint
c
c     ppnn  / ptnn   - momenta of the int. nucleons (cms, negl. Fermi)
c     ptotnn         - total momentum of the int. nucleons (cms, negl. Fermi)
c     pptcms/ pttcms - momenta of the interacting nucleons (cms)
c     pp1,2 / pt1,2  - momenta of the four partons
c
c     pp    / pt     - total momenta of the pr/ta partons (cms, negl. Fermi)
c     ptot           - total momentum of the four partons (cms, negl. Fermi)
c     ppsub / ptsub  - total momenta of the proj / targ partons (cms)
c
c              PTOTCM = SQRT( (PPTCMS(1)+PTTCMS(1))**2 +
c    &                        (PPTCMS(2)+PTTCMS(2))**2 +
c    &                        (PPTCMS(3)+PTTCMS(3))**2 )
c              ENEWCM = SQRT( (PPTCMS(4)+PTTCMS(4)-PTOTCM) *
c    &                        (PPTCMS(4)+PTTCMS(4)+PTOTCM) )
c              PTOTSU = SQRT( (PPSUB(1)+PTSUB(1))**2 +
c    &                        (PPSUB(2)+PTSUB(2))**2 +
c    &                        (PPSUB(3)+PTSUB(3))**2 )
c              ENEWSU = SQRT( (PPSUB(4)+PTSUB(4)-PTOTSU) *
c    &                        (PPSUB(4)+PTSUB(4)+PTOTSU) )
c              IF (ENEWCM/EOLDCM.GT.1.1D0) THEN
c                 WRITE(*,*) ' EOLDCM, ENEWCM : ',EOLDCM,ENEWCM
c                 WRITE(*,*) ' EOLDSU, ENEWSU : ',EOLDSU,ENEWSU
c                 WRITE(*,*) ' XPSUB,  XTSUB  : ',XPSUB,XTSUB
c              ENDIF
c              BBGX = (PPTCMS(1)+PTTCMS(1))/ENEWCM
c              BBGY = (PPTCMS(2)+PTTCMS(2))/ENEWCM
c              BBGZ = (PPTCMS(3)+PTTCMS(3))/ENEWCM
c              BGAM = (PPTCMS(4)+PTTCMS(4))/ENEWCM
c     transform interacting nucleons into nucleon-nucleon cm-system
c              CALL DT_DALTRA(BGAM,-BBGX,-BBGY,-BBGZ,
c    &                    PPTCMS(1),PPTCMS(2),PPTCMS(3),PPTCMS(4),PPTOT,
c    &                     PPNEW1,PPNEW2,PPNEW3,PPNEW4)
c              CALL DT_DALTRA(BGAM,-BBGX,-BBGY,-BBGZ,
c    &                    PTTCMS(1),PTTCMS(2),PTTCMS(3),PTTCMS(4),PTTOT,
c    &                     PTNEW1,PTNEW2,PTNEW3,PTNEW4)
c              CALL DT_DALTRA(BGAM,-BBGX,-BBGY,-BBGZ,
c    &                     PPSUB(1),PPSUB(2),PPSUB(3),PPSUB(4),PPTOT,
c    &                     PPSUB1,PPSUB2,PPSUB3,PPSUB4)
c              CALL DT_DALTRA(BGAM,-BBGX,-BBGY,-BBGZ,
c    &                     PTSUB(1),PTSUB(2),PTSUB(3),PTSUB(4),PTTOT,
c    &                     PTSUB1,PTSUB2,PTSUB3,PTSUB4)
c              PTSTCM = SQRT( (PPNEW1+PTNEW1)**2 +
c    &                        (PPNEW2+PTNEW2)**2 +
c    &                        (PPNEW3+PTNEW3)**2 )
c              ETSTCM = SQRT( (PPNEW4+PTNEW4-PTSTCM) *
c    &                        (PPNEW4+PTNEW4+PTSTCM) )
c              PTSTSU = SQRT( (PPSUB1+PTSUB1)**2 +
c    &                        (PPSUB2+PTSUB2)**2 +
c    &                        (PPSUB3+PTSUB3)**2 )
c              ETSTSU = SQRT( (PPSUB4+PTSUB4-PTSTSU) *
c    &                        (PPSUB4+PTSUB4+PTSTSU) )
C              WRITE(*,*) ' mother cmE :'
C              WRITE(*,*) ETSTCM,ENEWCM
C              WRITE(*,*) ' subsystem cmE :'
C              WRITE(*,*) ETSTSU,ENEWSU
C              WRITE(*,*) ' projectile mother :'
C              WRITE(*,*) PPNEW1,PPNEW2,PPNEW3,PPNEW4
C              WRITE(*,*) ' target mother :'
C              WRITE(*,*) PTNEW1,PTNEW2,PTNEW3,PTNEW4
C              WRITE(*,*) ' projectile subsystem:'
C              WRITE(*,*) PPSUB1,PPSUB2,PPSUB3,PPSUB4
C              WRITE(*,*) ' target subsystem:'
C              WRITE(*,*) PTSUB1,PTSUB2,PTSUB3,PTSUB4
C              WRITE(*,*) ' projectile subsystem should be:'
C              WRITE(*,*) ZERO,ZERO,XPSUB*ETSTCM/2.0D0,
C    &                    XPSUB*ETSTCM/2.0D0
C              WRITE(*,*) ' target subsystem should be:'
C              WRITE(*,*) ZERO,ZERO,-XTSUB*ETSTCM/2.0D0,
C    &                    XTSUB*ETSTCM/2.0D0
C              WRITE(*,*) ' subsystem cmE should be: '
C              WRITE(*,*) SQRT(XPSUB*XTSUB)*ETSTCM,XPSUB,XTSUB
c**
c
c     generate complete remnant - nucleon/remnant event with PHOJET

               CALL PHO_EVENT(3,PPTCMS,PTTCMS,DUM,IREJ1)

c
c     copy back original settings of PHOJET process flags
               DO 11 K=1,11
                  IPRON(K,1) = KPRON(K)
   11          CONTINUE
c
c     check if PHOJET has rejected this event
               IF (IREJ1.NE.0) THEN
                  IF (IOULEV(1).GT.0)
     &            WRITE(ErrorOut,
     * '(1X,A)') 'EVENTB:  chain system rejected'
                  WRITE(ErrorOut,*)
     &                 'XPSUB,XTSUB,SECM ',XPSUB,XTSUB,SECM,AMTOT

                  CALL PHO_PREVNT(0)

                  GOTO 9999
               ENDIF
c
c     copy partons and strings from PHOJET common back into DTEVT for
c     external fragmentation
               MO1 = NC
               MO2 = NC+3
c!      uncomment this line for internal phojet-fragmentation
C              CALL DT_GETFSP(MO1,MO2,PP,PT,1)
               NPHOSC = NPHOSC+1
               CALL DT_GETPJE(MO1,MO2,PP,PT,1,NPHOSC,IREJ1)
               IF (IREJ1.NE.0) THEN
                  IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * '(1X,A,I4)')
     &               'EVENTB: CHAIN SYSTEM REJECTED 2'
                  GOTO 9999
               ENDIF
c
c     update statistics counter
               ICEVTG(IDCH(NC),2) = ICEVTG(IDCH(NC),2)+1
c
c-----------------------------------------------------------------------
c two-chain approx. for smaller systems
c
            ELSE
c
               NDTUSC = NDTUSC+1
c   special flag for double-Pomeron statistics
               IPOPO = 0
c
c   pick up flavors at the ends of the two chains
               IFP1 = IDHKK(NC)
               IFT1 = IDHKK(NC+1)
               IFP2 = IDHKK(NC+2)
               IFT2 = IDHKK(NC+3)
c   ..and the indices of the mothers
               MOP1 = NC
               MOT1 = NC+1
               MOP2 = NC+2
               MOT2 = NC+3
               CALL DT_GETCSY(IFP1,PP1,MOP1,IFP2,PP2,MOP2,
     &                     IFT1,PT1,MOT1,IFT2,PT2,MOT2,IREJ1)
c
c   check if this chain system was rejected
               IF (IREJ1.GT.0) THEN
                  IF (IOULEV(1).GT.0) THEN
                     WRITE(ErrorOut,*) 'rejected 1 in EVENTB'
                     WRITE(ErrorOut,'(1X,4(I6,4E12.3,/),E12.3)')
     &                  IFP1,PP1,IFT1,PT1,IFP2,PP2,IFT2,PT2,AMTOT
                  ENDIF
                  IRHHA = IRHHA+1
                  GOTO 9999
               ENDIF
c   the following lines are for sea-sea chains rejected in GETCSY
               IF (IREJ1.EQ.-1) NDTUSC = NDTUSC-1
               ICEVTG(IDCH(NC),1) = ICEVTG(IDCH(NC),1)+1
            ENDIF
c
         ENDIF
c
c     update statistics counter
         ICEVTG(IDCH(NC),0) = ICEVTG(IDCH(NC),0)+1
c
         NC = NC+4
c
    2 CONTINUE
c
c-----------------------------------------------------------------------
c treatment of low-mass chains (if there are any)
c
      IF (NDTUSC.GT.0) THEN
c
c   correct chains of very low masses for possible resonances
         IF (IRESCO.EQ.1) THEN
            CALL DT_EVTRES(IREJ1)
            IF (IREJ1.GT.0) THEN
               IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 2a in EVENTB'
               IRRES(1) = IRRES(1)+1
               GOTO 9999
            ENDIF
         ENDIF
c   fragmentation of low-mass chains
c!  uncomment this line for internal phojet-fragmentation
c   (of course it will still be fragmented by DPMJET-routines but it
c    has to be done here instead of further below)
C        CALL DT_EVTFRA(IREJ1)
C        IF (IREJ1.GT.0) THEN
C           IF (IOULEV(1).GT.0) WRITE(LOUT,*) 'rejected 2b in EVENTB'
C           IRFRAG = IRFRAG+1
C           GOTO 9999
C        ENDIF
      ELSE
c! uncomment this line for internal phojet-fragmentation
C        NPOINT(4) = NHKK+1
         IF (NPOINT(4).LE.NPOINT(3)) NPOINT(4) = NHKK+1
      ENDIF
c
c-----------------------------------------------------------------------
c new di-quark breaking mechanisms
c
      MXLEFT = 2
      CALL DT_CHASTA(0)
      IF ((PDBSEA(1).GT.0.0D0).OR.(PDBSEA(2).GT.0.0D0)
     &                        .OR.(PDBSEA(3).GT.0.0D0)) THEN
         CALL DT_DIQBRK
         MXLEFT = 4
      ENDIF
c
c-----------------------------------------------------------------------
c hadronize this event
c
c   hadronize PHOJET chain systems
      NPYMAX = 0
      NPJE   = NPHOSC/MXPHFR
      IF (MXPHFR.LT.MXLEFT) MXLEFT = 2
      IF (NPJE.GT.1) THEN
         NLEFT = NPHOSC-NPJE*MXPHFR
         DO 20 JFRG=1,NPJE
            NFRG = JFRG*MXPHFR
            IF ((JFRG.EQ.NPJE).AND.(NLEFT.LE.MXLEFT)) THEN
               CALL DT_EVTFRG(1,NPHOSC,NPYMEM,IREJ1)
               IF (IREJ1.GT.0) GOTO 22
               NLEFT = 0
            ELSE
               CALL DT_EVTFRG(1,NFRG,NPYMEM,IREJ1)
               IF (IREJ1.GT.0) GOTO 22
            ENDIF
            IF (NPYMEM.GT.NPYMAX) NPYMAX = NPYMEM
   20    CONTINUE
         IF (NLEFT.GT.0) THEN
            CALL DT_EVTFRG(1,NPHOSC,NPYMEM,IREJ1)
            IF (IREJ1.GT.0) GOTO 22
            IF (NPYMEM.GT.NPYMAX) NPYMAX = NPYMEM
         ENDIF
      ELSE
         CALL DT_EVTFRG(1,NPHOSC,NPYMEM,IREJ1)
         IF (IREJ1.GT.0) GOTO 22
         IF (NPYMEM.GT.NPYMAX) NPYMAX = NPYMEM
      ENDIF
c
c   check max. filling level of jetset common and
c   reduce mxphfr if necessary
      IF (NPYMAX.GT.3000) THEN
         IF (NPYMAX.GT.3500) THEN
            MXPHFR = MAX(1,MXPHFR-2)
         ELSE
            MXPHFR = MAX(1,MXPHFR-1)
         ENDIF
C        WRITE(LOUT,*) ' EVENTB: Mxphfr reduced to ',MXPHFR
      ENDIF
c
c   hadronize DTUNUC chain systems
   23 CONTINUE
      IBACK = MXDTFR
      CALL DT_EVTFRG(2,IBACK,NPYMEM,IREJ2)
      IF (IREJ2.GT.0) GOTO 22
c
c   check max. filling level of jetset common and
c   reduce mxdtfr if necessary
      IF (NPYMEM.GT.3000) THEN
         IF (NPYMEM.GT.3500) THEN
            MXDTFR = MAX(1,MXDTFR-20)
         ELSE
            MXDTFR = MAX(1,MXDTFR-10)
         ENDIF
C        WRITE(LOUT,*) ' EVENTB: Mxdtfr reduced to ',MXDTFR
      ENDIF
c
      IF (IBACK.EQ.-1) GOTO 23
c
   22 CONTINUE
C     CALL DT_EVTFRG(1,IREJ1)
C     CALL DT_EVTFRG(2,IREJ2)
      IF ((IREJ1.GT.0).OR.(IREJ2.GT.0)) THEN
         IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in EVENTB'
         IRFRAG = IRFRAG+1
         GOTO 9999
      ENDIF
c
c get final state particles from /DTEVTP/
c! uncomment this line for internal phojet-fragmentation
C     CALL DT_GETFSP(IDUM,IDUM,PP,PT,2)

      IF (IJPROJ.NE.7)
     &   CALL DT_EMC2(9,10,0,0,0,3,1,0,0,0,0,3,4,88,IREJ3)
C     IF (IREJ3.NE.0) GOTO 9999

      RETURN

 9999 CONTINUE
      IREVT = IREVT+1
      IREJ  = 1
      RETURN
      END
c
c===getpje=============================================================*
c
CDECK  ID>, DT_GETPJE
      SUBROUTINE DT_GETPJE(MO1,MO2,PP,PT,MODE,IPJE,IREJ)

c***********************************************************************
c This subroutine copies PHOJET partons and strings from POEVT1 into   *
c DTEVT1.                                                              *
c      MO1,MO2   indices of first and last mother-parton in DTEVT1     *
c      PP,PT     4-momenta of projectile/target being handled by       *
c                PHOJET                                                *
c This version dated 11.12.99 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY1=1.0D-1,
     &           ZERO=0.0D0,ONE=1.0D0,OHALF=0.5D0)

      LOGICAL LFLIP

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c DTUNUC-PHOJET interface, Lorentz-param. of n-n subsystem
      COMMON /DTLTSU/ BGX,BGY,BGZ,GAM

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c statistics: double-Pomeron exchange
      COMMON /DTFLG2/ INTFLG,IPOPO

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC



C  standard particle data interface
      INTEGER NMXHEP

      PARAMETER (NMXHEP=4000)

      INTEGER NEVHEP,NHEP,ISTHEP,IDHEP,JMOHEP,JDAHEP
      DOUBLE PRECISION PHEP,VHEP
      COMMON /POEVT1/ NEVHEP,NHEP,ISTHEP(NMXHEP),IDHEP(NMXHEP),
     &                JMOHEP(2,NMXHEP),JDAHEP(2,NMXHEP),PHEP(5,NMXHEP),
     &                VHEP(4,NMXHEP)
C  extension to standard particle data interface (PHOJET specific)
      INTEGER IMPART,IPHIST,ICOLOR
      COMMON /POEVT2/ IMPART(NMXHEP),IPHIST(2,NMXHEP),ICOLOR(2,NMXHEP)


C  color string configurations including collapsed strings and hadrons
      INTEGER MSTR
      PARAMETER (MSTR=500)
      INTEGER NPOS,NCODE,IPAR1,IPAR2,IPAR3,IPAR4,NNCH,IBHAD
      COMMON /POSTRG/ NPOS(4,MSTR),NCODE(MSTR),
     &                IPAR1(MSTR),IPAR2(MSTR),IPAR3(MSTR),IPAR4(MSTR),
     &                NNCH(MSTR),IBHAD(MSTR),ISTR

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  event debugging information
      INTEGER NMAXD
      PARAMETER (NMAXD=100)
      INTEGER IDEB,KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,KHTRG,KSLOO,
     &        KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD
      COMMON /PODEBG/ IDEB(NMAXD),KSPOM,KHPOM,KSREG,KHDIR,KACCEP,KSTRG,
     &                KHTRG,KSLOO,KHLOO,KSDPO,KHDPO,KEVENT,KSOFT,KHARD


      DIMENSION PP(4),PT(4)
      DATA MAXLOP /10000/

      INHKK = NHKK
      LFLIP = .TRUE.
    1 CONTINUE
      NPVAL = 0
      NTVAL = 0
      IREJ  = 0

c   store initial momenta for energy-momentum conservation check
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(PP(1),PP(2),PP(3),PP(4),1,IDUM1,IDUM2)
         CALL DT_EVTEMC(PT(1),PT(2),PT(3),PT(4),2,IDUM1,IDUM2)
      ENDIF
c copy partons and strings from POEVT1 into DTEVT1
      DO 11 I=1,ISTR
C        IF ((NCODE(I).EQ.-99).AND.(IPAMDL(17).EQ.0)) THEN
         IF (NCODE(I).EQ.-99) THEN
            IDXSTG = NPOS(1,I)
            IDSTG  = IDHEP(IDXSTG)
            PX = PHEP(1,IDXSTG)
            PY = PHEP(2,IDXSTG)
            PZ = PHEP(3,IDXSTG)
            PE = PHEP(4,IDXSTG)
            IF (MODE.LT.0) THEN
               ISTAT = 70000+IPJE
               CALL DT_EVTPUT(2,ISTAT,MO1,MO2,PX,PY,PZ,PE,
     &                        11,IDSTG,0)
               IF (LEMCCK) THEN
                  PX = -PX
                  PY = -PY
                  PZ = -PZ
                  PE = -PE
                  CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM1,IDUM2)
               ENDIF
            ELSE
               CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                        PPX,PPY,PPZ,PPE)
               ISTAT = 70000+IPJE
               CALL DT_EVTPUT(2,ISTAT,MO1,MO2,PPX,PPY,PPZ,PPE,
     &                        11,IDSTG,0)
               IF (LEMCCK) THEN
                  PX = -PPX
                  PY = -PPY
                  PZ = -PPZ
                  PE = -PPE
                  CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM1,IDUM2)
               ENDIF
            ENDIF
            NOBAM(NHKK)   = 0
            IHIST(1,NHKK) = IPHIST(1,IDXSTG)
            IHIST(2,NHKK) = 0
         ELSEIF (NCODE(I).GE.0) THEN
c   indices of partons and string in POEVT1
            IDX1 = ABS(JMOHEP(1,NPOS(1,I)))
            IDX2 = ABS(JMOHEP(2,NPOS(1,I)))
            IF ((IDX1.GT.IDX2).OR.(JMOHEP(2,NPOS(1,I)).GT.0)) THEN
               WRITE(ErrorOut,
     * *) ' GETPJE: IDX1.GT.IDX2 ',IDX1,IDX2,
     &         ' OR JMOHEP(2,NPOS(1,I)).GT.0 ',JMOHEP(2,NPOS(1,I)),' ! '
               STOP ' GETPJE 1'
            ENDIF
            IDXSTG = NPOS(1,I)
c   find "mother" string of the string
            IDXMS1 = ABS(JMOHEP(1,IDX1))
            IDXMS2 = ABS(JMOHEP(1,IDX2))
            IF (IDXMS1.NE.IDXMS2) THEN
               IDXMS1 = IDXSTG
               IDXMS2 = IDXSTG
C              STOP ' GETPJE: IDXMS1.NE.IDXMS2 !'
            ENDIF
c   search POEVT1 for the original hadron of the parton
            ILOOP = 0
            IPOM1 = 0
   14       CONTINUE
            ILOOP = ILOOP+1

            IF (IDHEP(IDXMS1).EQ.990) IPOM1 = 1

            IDXMS1 = ABS(JMOHEP(1,IDXMS1))
            IF ((IDXMS1.NE.1).AND.(IDXMS1.NE.2).AND.
     &          (ILOOP.LT.MAXLOP)) GOTO 14
            IF (ILOOP.EQ.MAXLOP) WRITE(*,*) ' GETPJE: MAXLOP in 1 ! '
            IPOM2 = 0
            ILOOP = 0
   15       CONTINUE
            ILOOP = ILOOP+1

            IF (IDHEP(IDXMS2).EQ.990) IPOM2 = 1

            IF ((ILOOP.EQ.1).OR.(IDHEP(IDXMS2).GE.7777)) THEN
               IDXMS2 = ABS(JMOHEP(2,IDXMS2))
            ELSE
               IDXMS2 = ABS(JMOHEP(1,IDXMS2))
            ENDIF
            IF ((IDXMS2.NE.1).AND.(IDXMS2.NE.2).AND.
     &          (ILOOP.LT.MAXLOP)) GOTO 15
            IF (ILOOP.EQ.MAXLOP) WRITE(*,*) ' GETPJE: MAXLOP in 5 ! '
c   parton 1
            IF (IDXMS1.EQ.1) THEN
               ISPTN1 = ISTHKK(MO1)
               M1PTN1 = MO1
               M2PTN1 = MO1+2
            ELSE
               ISPTN1 = ISTHKK(MO2)
               M1PTN1 = MO2-2
               M2PTN1 = MO2
            ENDIF
c   parton 2
            IF (IDXMS2.EQ.1) THEN
               ISPTN2 = ISTHKK(MO1)
               M1PTN2 = MO1
               M2PTN2 = MO1+2
            ELSE
               ISPTN2 = ISTHKK(MO2)
               M1PTN2 = MO2-2
               M2PTN2 = MO2
            ENDIF
c   check for mis-identified mothers and switch mother indices if necessary
            IF ((IDXMS1.EQ.IDXMS2).AND.(IPROCE.NE.5).AND.(IPROCE.NE.6)
     &          .AND.((IDHEP(IDX1).NE.21).OR.(IDHEP(IDX2).NE.21)).AND.
     &          (LFLIP)) THEN
               IF (PHEP(3,IDX1).GT.PHEP(3,IDX2)) THEN
                  ISPTN1 = ISTHKK(MO1)
                  M1PTN1 = MO1
                  M2PTN1 = MO1+2
                  ISPTN2 = ISTHKK(MO2)
                  M1PTN2 = MO2-2
                  M2PTN2 = MO2
               ELSE
                  ISPTN1 = ISTHKK(MO2)
                  M1PTN1 = MO2-2
                  M2PTN1 = MO2
                  ISPTN2 = ISTHKK(MO1)
                  M1PTN2 = MO1
                  M2PTN2 = MO1+2
               ENDIF
            ENDIF
c   register partons in temporary common
c     parton at chain end
            PX = PHEP(1,IDX1)
            PY = PHEP(2,IDX1)
            PZ = PHEP(3,IDX1)
            PE = PHEP(4,IDX1)
c flag only partons coming from Pomeron with 41/42
C           IF ((IPOM1.NE.0).OR.(NPOS(4,I).GE.4)) THEN
            IF (IPOM1.NE.0) THEN
               ISTX = ABS(ISPTN1)/10
               IMO  = ABS(ISPTN1)-10*ISTX
               ISPTN1 = -(40+IMO)
            ELSE
               IF ((ICOLOR(2,IDX1).EQ.0).OR.(IDHEP(IDX1).EQ.21)) THEN
                  ISTX = ABS(ISPTN1)/10
                  IMO  = ABS(ISPTN1)-10*ISTX
                  IF ((IDHEP(IDX1).EQ.21).OR.
     &                (ABS(IPHIST(1,IDX1)).GE.100)) THEN
                     ISPTN1 = -(60+IMO)
                  ELSE
                     ISPTN1 = -(50+IMO)
                  ENDIF
               ENDIF
            ENDIF
            IF (ISPTN1.EQ.-21) NPVAL = NPVAL+1
            IF (ISPTN1.EQ.-22) NTVAL = NTVAL+1
            IF (MODE.LT.0) THEN
               CALL DT_EVTPUT(ISPTN1,IDHEP(IDX1),M1PTN1,M2PTN1,PX,PY,
     &                        PZ,PE,0,0,0)
            ELSE
               CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                        PPX,PPY,PPZ,PPE)
               CALL DT_EVTPUT(ISPTN1,IDHEP(IDX1),M1PTN1,M2PTN1,PPX,PPY,
     &                        PPZ,PPE,0,0,0)
            ENDIF
            IHIST(1,NHKK) = IPHIST(1,IDX1)
            IHIST(2,NHKK) = 0
            DO 19 KK=1,4
               VHKK(KK,NHKK) = VHKK(KK,M2PTN1)
               WHKK(KK,NHKK) = WHKK(KK,M1PTN1)
   19       CONTINUE
            VHKK(4,NHKK) = VHKK(3,M2PTN1)/BLAB-VHKK(3,M1PTN1)/BGLAB
            WHKK(4,NHKK) = -WHKK(3,M1PTN1)/BLAB+WHKK(3,M2PTN1)/BGLAB
            M1STRG = NHKK
c     gluon kinks
            NGLUON = IDX2-IDX1-1
            IF (NGLUON.GT.0) THEN
               DO 17 IGLUON=1,NGLUON
                  IDX   = IDX1+IGLUON
                  IDXMS = ABS(JMOHEP(1,IDX))
                  IF ((IDXMS.NE.1).AND.(IDXMS.NE.2)) THEN
                     ILOOP = 0
   16                CONTINUE
                     ILOOP = ILOOP+1
                     IDXMS = ABS(JMOHEP(1,IDXMS))
                     IF ((IDXMS.NE.1).AND.(IDXMS.NE.2).AND.
     &                   (ILOOP.LT.MAXLOP)) GOTO 16
                     IF (ILOOP.EQ.MAXLOP)
     &                  WRITE(*,*) ' GETPJE: MAXLOP in 3 ! '
                  ENDIF
                  IF (IDXMS.EQ.1) THEN
                     ISPTN = ISTHKK(MO1)
                     M1PTN = MO1
                     M2PTN = MO1+2
                  ELSE
                     ISPTN = ISTHKK(MO2)
                     M1PTN = MO2-2
                     M2PTN = MO2
                  ENDIF
                  PX = PHEP(1,IDX)
                  PY = PHEP(2,IDX)
                  PZ = PHEP(3,IDX)
                  PE = PHEP(4,IDX)
                  IF ((ICOLOR(2,IDX).EQ.0).OR.(IDHEP(IDX).EQ.21)) THEN
                     ISTX = ABS(ISPTN)/10
                     IMO  = ABS(ISPTN)-10*ISTX
                     IF ((IDHEP(IDX).EQ.21).OR.
     &                   (ABS(IPHIST(1,IDX)).GE.100)) THEN
                        ISPTN = -(60+IMO)
                     ELSE
                        ISPTN = -(50+IMO)
                     ENDIF
                  ENDIF
                  IF (ISPTN.EQ.-21) NPVAL = NPVAL+1
                  IF (ISPTN.EQ.-22) NTVAL = NTVAL+1
                  IF (MODE.LT.0) THEN
                     CALL DT_EVTPUT(ISPTN,IDHEP(IDX),M1PTN,M2PTN,
     &                              PX,PY,PZ,PE,0,0,0)
                  ELSE
                     CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                              PPX,PPY,PPZ,PPE)
                     CALL DT_EVTPUT(ISPTN,IDHEP(IDX),M1PTN,M2PTN,
     &                              PPX,PPY,PPZ,PPE,0,0,0)
                  ENDIF
                  IHIST(1,NHKK) = IPHIST(1,IDX)
                  IHIST(2,NHKK) = 0
                  DO 20 KK=1,4
                     VHKK(KK,NHKK) = VHKK(KK,M2PTN)
                     WHKK(KK,NHKK) = WHKK(KK,M1PTN)
   20             CONTINUE
                  VHKK(4,NHKK)= VHKK(3,M2PTN)/BLAB-VHKK(3,M1PTN)/BGLAB
                  WHKK(4,NHKK)= -WHKK(3,M1PTN)/BLAB+WHKK(3,M2PTN)/BGLAB
   17          CONTINUE
            ENDIF
c     parton at chain end
            PX = PHEP(1,IDX2)
            PY = PHEP(2,IDX2)
            PZ = PHEP(3,IDX2)
            PE = PHEP(4,IDX2)
c flag only partons coming from Pomeron with 41/42
C           IF ((IPOM2.NE.0).OR.(NPOS(4,I).GE.4)) THEN
            IF (IPOM2.NE.0) THEN
               ISTX = ABS(ISPTN2)/10
               IMO  = ABS(ISPTN2)-10*ISTX
               ISPTN2 = -(40+IMO)
            ELSE
               IF ((ICOLOR(2,IDX2).EQ.0).OR.(IDHEP(IDX2).EQ.21)) THEN
                  ISTX = ABS(ISPTN2)/10
                  IMO  = ABS(ISPTN2)-10*ISTX
                  IF ((IDHEP(IDX2).EQ.21).OR.
     &                (ABS(IPHIST(1,IDX2)).GE.100)) THEN
                     ISPTN2 = -(60+IMO)
                  ELSE
                     ISPTN2 = -(50+IMO)
                  ENDIF
               ENDIF
            ENDIF
            IF (ISPTN2.EQ.-21) NPVAL = NPVAL+1
            IF (ISPTN2.EQ.-22) NTVAL = NTVAL+1
            IF (MODE.LT.0) THEN
               CALL DT_EVTPUT(ISPTN2,IDHEP(IDX2),M1PTN2,M2PTN2,
     &                        PX,PY,PZ,PE,0,0,0)
            ELSE
               CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                        PPX,PPY,PPZ,PPE)
               CALL DT_EVTPUT(ISPTN2,IDHEP(IDX2),M1PTN2,M2PTN2,
     &                        PPX,PPY,PPZ,PPE,0,0,0)
            ENDIF
            IHIST(1,NHKK) = IPHIST(1,IDX2)
            IHIST(2,NHKK) = 0
            DO 21 KK=1,4
               VHKK(KK,NHKK) = VHKK(KK,M2PTN2)
               WHKK(KK,NHKK) = WHKK(KK,M1PTN2)
   21       CONTINUE
            VHKK(4,NHKK) = VHKK(3,M2PTN2)/BLAB-VHKK(3,M1PTN2)/BGLAB
            WHKK(4,NHKK) = -WHKK(3,M1PTN2)/BLAB+WHKK(3,M2PTN2)/BGLAB
            M2STRG = NHKK
c   register string
            JSTRG = 100*IPROCE+NCODE(I)
            PX = PHEP(1,IDXSTG)
            PY = PHEP(2,IDXSTG)
            PZ = PHEP(3,IDXSTG)
            PE = PHEP(4,IDXSTG)
            IF (MODE.LT.0) THEN
               ISTAT = 70000+IPJE
               CALL DT_EVTPUT(JSTRG,ISTAT,M1STRG,M2STRG,
     &                        PX,PY,PZ,PE,0,0,0)
               IF (LEMCCK) THEN
                  PX = -PX
                  PY = -PY
                  PZ = -PZ
                  PE = -PE
                  CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM1,IDUM2)
               ENDIF
            ELSE
               CALL DT_DALTRA(GAM,BGX,BGY,BGZ,PX,PY,PZ,PE,PTOTMP,
     &                        PPX,PPY,PPZ,PPE)
               ISTAT = 70000+IPJE
               CALL DT_EVTPUT(JSTRG,ISTAT,M1STRG,M2STRG,
     &                        PPX,PPY,PPZ,PPE,0,0,0)
               IF (LEMCCK) THEN
                  PX = -PPX
                  PY = -PPY
                  PZ = -PPZ
                  PE = -PPE
                  CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM1,IDUM2)
               ENDIF
            ENDIF
            NOBAM(NHKK)   = 0
            IHIST(1,NHKK) = 0
            IHIST(2,NHKK) = 0
            DO 18 KK=1,4
               VHKK(KK,NHKK) = VHKK(KK,MO2)
               WHKK(KK,NHKK) = WHKK(KK,MO1)
   18       CONTINUE
            VHKK(4,NHKK) = VHKK(3,MO2)/BLAB-VHKK(3,MO1)/BGLAB
            WHKK(4,NHKK) = -WHKK(3,MO1)/BLAB+WHKK(3,MO2)/BGLAB
         ENDIF
   11 CONTINUE

      IF ( ((NPVAL.GT.2).OR.(NTVAL.GT.2)).AND.(LFLIP) ) THEN
         NHKK  = INHKK
         LFLIP = .FALSE.
         GOTO 1
      ENDIF

      IF (LEMCCK) THEN
         IF (UMO.GT.1.0D5) THEN
            CHKLEV = 1.0D0
         ELSE
            CHKLEV = TINY1
         ENDIF
         CALL DT_EVTEMC(DUM1,DUM2,DUM3,CHKLEV,-1,1000,IREJ2)

         IF (IREJ2.GT.ZERO) CALL PHO_PREVNT(0)

      ENDIF

c internal statistics
c   dble-Po statistics.
      IF (IPROCE.NE.4) IPOPO = 0

      INTFLG = IPROCE
      IDCHSY = IDCH(MO1)
      IF ((IPROCE.GE.1).AND.(IPROCE.LE.8)) THEN
         ICEVTG(IDCHSY,IPROCE+2) = ICEVTG(IDCHSY,IPROCE+2)+1
      ELSE
         WRITE(ErrorOut,1000) IPROCE,NEVHKK,MO1
 1000    FORMAT(1X,'GETFSP:   WARNING! INCONS. PROCESS ID. (',I2,
     &          ') AT EVT(CHAIN) ',I6,'(',I2,')')
      ENDIF
      IF (IPROCE.EQ.5) THEN
         IF ((IDIFR1.GE.1).AND.(IDIFR1.LE.3)) THEN
            ICEVTG(IDCHSY,18+IDIFR1) = ICEVTG(IDCHSY,18+IDIFR1)+1
         ELSE
C           WRITE(LOUT,1001) IPROCE,IDIFR1,IDIFR2
 1001       FORMAT(1X,'GETFSP:   WARNING! INCONS. DIFFRAC. ID. ',
     &             '(IPROCE,IDIFR1,IDIFR2=',3I3,')')
         ENDIF
      ELSEIF (IPROCE.EQ.6) THEN
         IF ((IDIFR2.GE.1).AND.(IDIFR2.LE.3)) THEN
            ICEVTG(IDCHSY,21+IDIFR2) = ICEVTG(IDCHSY,21+IDIFR2)+1
         ELSE
C           WRITE(LOUT,1001) IPROCE,IDIFR1,IDIFR2
         ENDIF
      ELSEIF (IPROCE.EQ.7) THEN
         IF ((IDIFR1.GE.1).AND.(IDIFR1.LE.3).AND.
     &       (IDIFR2.GE.1).AND.(IDIFR2.LE.3)) THEN
            IF ((IDIFR1.EQ.1).AND.(IDIFR2.EQ.1))
     &         ICEVTG(IDCHSY,25) = ICEVTG(IDCHSY,25)+1
            IF ((IDIFR1.EQ.2).AND.(IDIFR2.EQ.2))
     &         ICEVTG(IDCHSY,26) = ICEVTG(IDCHSY,26)+1
            IF ((IDIFR1.EQ.1).AND.(IDIFR2.EQ.2))
     &         ICEVTG(IDCHSY,27) = ICEVTG(IDCHSY,27)+1
            IF ((IDIFR1.EQ.2).AND.(IDIFR2.EQ.1))
     &         ICEVTG(IDCHSY,28) = ICEVTG(IDCHSY,28)+1
         ELSE
            WRITE(ErrorOut,1001) IPROCE,IDIFR1,IDIFR2
         ENDIF
      ENDIF
      IF ((IDIFR1+IDIFR2.EQ.0).AND.(KHDIR.GE.1).AND.(KHDIR.LE.3))
     &                                                       THEN
         ICEVTG(IDCHSY,10+KHDIR) = ICEVTG(IDCHSY,10+KHDIR)+1
         ICEVTG(IDCHSY,10+KHDIR) = ICEVTG(IDCHSY,10+KHDIR)+1
         ICEVTG(IDCHSY,10+KHDIR) = ICEVTG(IDCHSY,10+KHDIR)+1
      ENDIF
      ICEVTG(IDCHSY,14) = ICEVTG(IDCHSY,14)+KSPOM
      ICEVTG(IDCHSY,15) = ICEVTG(IDCHSY,15)+KHPOM
      ICEVTG(IDCHSY,16) = ICEVTG(IDCHSY,16)+KSREG
      ICEVTG(IDCHSY,17) = ICEVTG(IDCHSY,17)+(KSTRG+KHTRG)
      ICEVTG(IDCHSY,18) = ICEVTG(IDCHSY,18)+(KSLOO+KHLOO)

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===phoini=============================================================*
c
CDECK  ID>, DT_PHOINI
      SUBROUTINE DT_PHOINI

c***********************************************************************
c Initialization PHOJET-event generator for nucleon-nucleon interact.  *
c This version dated 16.11.95 is written by S. Roesler                 *
c Last change: s.r. 21.01.01                                           *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0,ONE=1.0D0)

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c
c parameters for cascade calculations:
c maximum mumber of PDF's which can be defined in phojet (limited
c by the dimension of ipdfs in pho_setpdf)
      PARAMETER (MAXPDF = 20)
c PDF parametrization and number of set for the first 30 hadrons in
c the bamjet-code list
c   negative numbers mean that the PDF is set in phojet,
c   zero stands for "not a hadron"
      DIMENSION IPARPD(30),ISETPD(30)
c PDF parametrization
      DATA IPARPD /
     &  -5,-5, 0, 0, 0, 0,-5,-5,-5, 0, 0, 5,-5,-5, 5, 5, 5, 5, 5, 5,
     &   5, 5,-5, 5, 5, 0, 0, 0, 0, 0/
c number of set
      DATA ISETPD /
     &  -6,-6, 0, 0, 0, 0,-3,-6,-6, 0, 0, 2,-2,-2, 2, 2, 6, 6, 2, 6,
     &   6, 6,-2, 2, 2, 0, 0, 0, 0, 0/

c*PHOJET105a
C     COMMON /GLOCMS/ XECM,XPCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)
C     PARAMETER ( MAXPRO = 16 )
C     PARAMETER ( MAXTAB = 20 )
C     COMMON /HAXSEC/ XSECTA(4,-1:MAXPRO,4,MAXTAB),XSECT(6,-1:MAXPRO),
C    &                MXSECT(0:4,-1:MAXPRO,4),ECMSH(4,MAXTAB),ISTTAB
C     CHARACTER*8 MDLNA
C     COMMON /MODELS/ MDLNA(50),ISWMDL(50),PARMDL(200),IPAMDL(100)
C     COMMON /PROCES/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15)
c*PHOJET110
C  global event kinematics and particle IDs
      INTEGER IFPAP,IFPAB
      DOUBLE PRECISION ECM,PCM,PMASS,PVIRT
      COMMON /POGCMS/ ECM,PCM,PMASS(2),PVIRT(2),IFPAP(2),IFPAB(2)

C  hard cross sections and MC selection weights
      INTEGER MAX_PRO_2
      PARAMETER ( MAX_PRO_2 = 16 )
      INTEGER IHA_LAST,IHB_LAST,MH_PRO_ON,MH_TRIED,
     &  MH_ACC_1,MH_ACC_2
      DOUBLE PRECISION HFAC,HWGX,HSIG,HDPT,HECM_LAST,HQ2A_LAST,HQ2B_LAST
      COMMON /POHRCS/ HFAC(-1:MAX_PRO_2),HWGX(-1:MAX_PRO_2),
     &  HSIG(-1:MAX_PRO_2),HDPT(-1:MAX_PRO_2),
     &  HECM_LAST,HQ2A_LAST,HQ2B_LAST,IHA_LAST,IHB_LAST,
     &  MH_PRO_ON(-1:MAX_PRO_2,0:4),MH_TRIED(-1:MAX_PRO_2,0:4),
     &  MH_ACC_1(-1:MAX_PRO_2,0:4),MH_ACC_2(-1:MAX_PRO_2,0:4)

C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  general process information
      INTEGER IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON
      COMMON /POPRCS/ IPROCE,IDNODF,IDIFR1,IDIFR2,IDDPOM,IPRON(15,4)

c*
      DIMENSION PP(4),PT(4)

      LOGICAL LSTART
      DATA LSTART /.TRUE./

      IJP = IJPROJ
      IJT = IJTARG
      Q2  = VIRT
c lepton-projectiles: initialize real photon instead
      IF ((IJP.EQ.3).OR.(IJP.EQ.4).OR.(IJP.EQ.10).OR.(IJP.EQ.11)) THEN
         IJP = 7
         Q2  = ZERO
      ENDIF

      IF (LPHOIN) CALL PHO_INIT(-1,IDUM)

c switch Reggeon off
C     IPAMDL(3)= 0
      IF (IP.EQ.1) THEN
         IFPAP(1) = IDT_IPDGHA(IJP)
         IFPAB(1) = IJP
      ELSE
         IFPAP(1) = 2212
         IFPAB(1) = IDT_ICIHAD(IFPAP(1))
      ENDIF
      PMASS(1) = AAM(IFPAB(1))-SQRT(Q2)
      PVIRT(1) = PMASS(1)**2
      IF (IT.EQ.1) THEN
         IFPAP(2) = IDT_IPDGHA(IJT)
         IFPAB(2) = IJT
      ELSE
         IFPAP(2) = 2212
         IFPAB(2) = IDT_ICIHAD(IFPAP(2))
      ENDIF
      PMASS(2) = AAM(IFPAB(2))
      PVIRT(2) = ZERO
      DO 1 K=1,4
         PP(K) = ZERO
         PT(K) = ZERO
    1 CONTINUE
c get max. possible momenta of incoming particles to be used for PHOJET ini.
      PPF = ZERO
      PTF = ZERO
      SCPF= 1.5D0
      IF (UMO.GE.1.E5) THEN
         SCPF= 5.0D0
      ENDIF
      IF (NCOMPO.GT.0) THEN
         DO 2 I=1,NCOMPO
            IF (IT.GT.1) THEN
               CALL DT_NCLPOT(IEMUCH(I),IEMUMA(I),ITZ,IT,ZERO,ZERO,0)
            ELSE
               CALL DT_NCLPOT(IPZ,IP,IEMUCH(I),IEMUMA(I),ZERO,ZERO,0)
            ENDIF
            PPFTMP = MAX(PFERMP(1),PFERMN(1))
            PTFTMP = MAX(PFERMP(2),PFERMN(2))
            IF (PPFTMP.GT.PPF) PPF = PPFTMP
            IF (PTFTMP.GT.PTF) PTF = PTFTMP
    2    CONTINUE
      ELSE
         CALL DT_NCLPOT(IPZ,IP,ITZ,IT,ZERO,ZERO,0)
         PPF = MAX(PFERMP(1),PFERMN(1))
         PTF = MAX(PFERMP(2),PFERMN(2))
      ENDIF
      PTF = -PTF
      PPF = SCPF*PPF
      PTF = SCPF*PTF
      IF (IJP.EQ.7) THEN
         AMP2  = SIGN(PMASS(1)**2,PMASS(1))
         PP(3) = PPCM
         PP(4) = SQRT(AMP2+PP(3)**2)
      ELSE
         EPF = SQRT(PPF**2+PMASS(1)**2)
         CALL DT_LTNUC(PPF,EPF,PP(3),PP(4),2)
      ENDIF
      ETF = SQRT(PTF**2+PMASS(2)**2)
      CALL DT_LTNUC(PTF,ETF,PT(3),PT(4),3)
      ECMINI = SQRT((PP(4)+PT(4))**2-(PP(1)+PT(1))**2-
     &              (PP(2)+PT(2))**2-(PP(3)+PT(3))**2)
      IF (LSTART) THEN
         WRITE(ErrorOut,1001) IP,IPZ,SCPF,PPF,PP
 1001    FORMAT(
     &      ' DT_PHOINI:    PHOJET INITIALIZED FOR PROJECTILE A,Z = ',
     &      I3,',',I2,/,F4.1,'XP_F(MAX) = ',E10.3,'  P(MAX) = ',4E10.3)
         IF (NCOMPO.GT.0) THEN
            WRITE(ErrorOut,1002) SCPF,PTF,PT
         ELSE
            WRITE(ErrorOut,1003) IT,ITZ,SCPF,PTF,PT
         ENDIF
 1002    FORMAT(
     &      ' DT_PHOINI:    PHOJET INITIALIZED FOR TARGET EMULSION  ',
     &          /,F4.1,'XP_F(MAX) = ',E10.3,'  P(MAX) = ',4E10.3)
 1003    FORMAT(
     &      ' DT_PHOINI:    PHOJET INITIALIZED FOR TARGET     A,Z = ',
     &      I3,',',I2,/,F4.1,'XP_F(MAX) = ',E10.3,'  P(MAX) = ',4E10.3)
         WRITE(ErrorOut,1004) ECMINI
 1004    FORMAT(' E_CM = ',E10.3)
         IF (IJP.EQ.8) WRITE(ErrorOut,1005)
 1005    FORMAT(
     &      ' DT_PHOINI: WARNING! PROTON PARAMETERS USED FOR NEUTRON',
     &          ' PROJECTILE')
         LSTART = .FALSE.
      ENDIF
c switch off new diffractive cross sections at low energies for nuclei
c (temporary solution)
      IF ((ISWMDL(30).NE.0).AND.((IP.GT.1).OR.(IT.GT.1))) THEN
         WRITE(ErrorOut,'(1X,A)')
     &      ' DT_PHOINI: MODEL-SWITCH 30 FOR NUCLEI RE-SET !'
         CALL PHO_SETMDL(30,0,1)
      ENDIF
c
C     IF (IJP.EQ.7) THEN
C        AMP2  = SIGN(PMASS(1)**2,PMASS(1))
C        PP(3) = PPCM
C        PP(4) = SQRT(AMP2+PP(3)**2)
C     ELSE
C        PFERMX = ZERO
C        IF (IP.GT.1) PFERMX = 0.5D0
C        EFERMX = SQRT(PFERMX**2+PMASS(1)**2)
C        CALL DT_LTNUC(PFERMX,EFERMX,PP(3),PP(4),2)
C     ENDIF
C     PFERMX = ZERO
C     IF ((IT.GT.1).OR.(NCOMPO.GT.0)) PFERMX = -0.5D0
C     EFERMX = SQRT(PFERMX**2+PMASS(2)**2)
C     CALL DT_LTNUC(PFERMX,EFERMX,PT(3),PT(4),3)
c*sr 26.10.96
      ISAV = IPAMDL(13)
      IF ((ISHAD(2).EQ.1).AND.
     &   ((IJPROJ.EQ. 7).OR.(IJPROJ.EQ.3).OR.(IJPROJ.EQ.4).OR.
     &    (IJPROJ.EQ.10).OR.(IJPROJ.EQ.11))) IPAMDL(13) = 1
c*

      CALL PHO_EVENT(-1,PP,PT,SIGMAX,IREJ1)

c*sr 26.10.96
      IPAMDL(13) = ISAV
c*
c
c patch for cascade calculations:
c define parton distribution functions for other hadrons, i.e. other
c then defined already in phojet
      IF (IOGLB.EQ.100) THEN
         WRITE(ErrorOut,1006)
 1006    FORMAT(/,1X,'PHOINI: ADDITIONAL PARTON DISTRIBUTION FUNCTIONS',
     &          ' ASSIGED (ID,IPAR,ISET)',/)
         NPDF = 0
         DO 3 I=1,30
            IF (IPARPD(I).NE.0) THEN
               NPDF = NPDF+1
               IF (NPDF.GT.MAXPDF) STOP ' PHOINI: NPDF > MAXPDF !'
               IF ((IPARPD(I).GT.0).AND.(ISETPD(I).GT.0)) THEN
                  IDPDG = IDT_IPDGHA(I)
                  IPAR  = IPARPD(I)
                  ISET  = ISETPD(I)
                  WRITE(ErrorOut,
     * '(13X,A8,3I6)') ANAME(I),IDPDG,IPAR,ISET
                  CALL PHO_SETPDF(IDPDG,IDUM,IPAR,ISET,0,0,-1)
               ENDIF
            ENDIF
    3    CONTINUE
      ENDIF


C     CALL PHO_PHIST(-1,SIGMAX)

      IF (IREJ1.NE.0) THEN
         WRITE(ErrorOut,1000)
 1000    FORMAT(1X,'PHOINI:   PHOJET EVENT-INITIALIZATION FAILED!')
         STOP
      ENDIF

      RETURN
      END

c
c===eventd=============================================================*
c
CDECK  ID>, DT_EVENTD
      SUBROUTINE DT_EVENTD(IREJ)

c***********************************************************************
c Quasi-elastic neutrino nucleus scattering.                           *
c This version dated 29.04.00 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,TINY5=1.0D-5)
      PARAMETER (SQTINF=1.0D+15)

      LOGICAL LFIRST

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      PARAMETER (MAXLND=4000)
      COMMON/PYJETS/N,NPAD,K(MAXLND,5),P(MAXLND,5),V(MAXLND,5)


c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c steering flags for qel neutrino scattering modules
      COMMON /QNEUTO/ DSIGSU,DSIGMC,NDSIG,NEUTYP,NEUDEC

      COMMON /QNPOL/ POLARX(4),PMODUL


      INTEGER PYK


      DATA LFIRST /.TRUE./

      IREJ = 0

      IF (LFIRST) THEN
         LFIRST = .FALSE.
         CALL DT_MASS_INI
      ENDIF

c JETSET parameter
      CALL DT_INITJS(0)

c interacting target nucleon
      LTYP = NEUTYP
      IF (NEUDEC.LE.9) THEN
         IF ((LTYP.EQ.1).OR.(LTYP.EQ.3).OR.(LTYP.EQ.5)) THEN
            NUCTYP = 2112
            NUCTOP = 2
         ELSE
            NUCTYP = 2212
            NUCTOP = 1
         ENDIF
      ELSE
         RTYP  = DT_RNDM(RTYP)
         ZFRAC = DBLE(ITZ)/DBLE(IT)
         IF (RTYP.LE.ZFRAC) THEN
            NUCTYP = 2212
            NUCTOP = 1
         ELSE
            NUCTYP = 2112
            NUCTOP = 2
         ENDIF
      ENDIF

c select first nucleon in list with matching id and reset all other
c nucleons which have been marked as "wounded" by ININUC
      IFOUND = 0
      DO 1 I=1,NHKK
         IF ((IDHKK(I).EQ.NUCTYP).AND.(IFOUND.EQ.0)) THEN
            ISTHKK(I) = 12
            IFOUND    = 1
            IDX = I
         ELSE
            IF (ISTHKK(I).EQ.12) ISTHKK(I) = 14
         ENDIF
    1 CONTINUE
      IF (IFOUND.EQ.0)
     &   STOP ' EVENTD: INTERACTING TARGET NUCLEON NOT FOUND! '

c correct position of proj. lepton: assume position of target nucleon
      DO 3 I=1,4
         VHKK(I,1) = VHKK(I,IDX)
         WHKK(I,1) = WHKK(I,IDX)
    3 CONTINUE

c load initial momenta for conservation check
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(ZERO,ZERO,PPROJ,EPROJ,1,IDUM,IDUM)
         CALL DT_EVTEMC(PHKK(1,IDX),PHKK(2,IDX),PHKK(3,IDX),PHKK(4,IDX),
     &                                                      2,IDUM,IDUM)
      ENDIF

c quasi-elastic scattering
      IF (NEUDEC.LT.9) THEN
         CALL DT_QEL_POL(EPROJ,LTYP,PHKK(1,IDX),PHKK(2,IDX),PHKK(3,IDX),
     &                                          PHKK(4,IDX),PHKK(5,IDX))
c  CC event on p or n
      ELSEIF (NEUDEC.EQ.10) THEN
         CALL DT_GEN_DELTA(EPROJ,LTYP,NUCTOP,1,PHKK(1,IDX),PHKK(2,IDX),
     &                     PHKK(3,IDX),PHKK(4,IDX),PHKK(5,IDX))
c  NC event on p or n
      ELSEIF (NEUDEC.EQ.11) THEN
         CALL DT_GEN_DELTA(EPROJ,LTYP,NUCTOP,2,PHKK(1,IDX),PHKK(2,IDX),
     &                     PHKK(3,IDX),PHKK(4,IDX),PHKK(5,IDX))
      ENDIF

c get final state particles from Lund-common and write them into HKKEVT
      NPOINT(1) = NHKK+1
      NPOINT(4) = NHKK+1

      NLINES = PYK(0,1)

      NHKK0  = NHKK+1
      DO 4 I=4,NLINES
         IF (K(I,1).EQ.1) THEN
            ID = K(I,2)
            PX = P(I,1)
            PY = P(I,2)
            PZ = P(I,3)
            PE = P(I,4)
            CALL DT_EVTPUT(1,ID,1,IDX,PX,PY,PZ,PE,0,0,0)
            IDBJ = IDT_ICIHAD(ID)
            EKIN = PHKK(4,NHKK)-PHKK(5,NHKK)
            IF ((IDBJ.EQ.1).OR.(IDBJ.EQ.8)) THEN
               IF (EKIN.LE.EPOT(2,IDBJ)) ISTHKK(NHKK) = 16
            ENDIF
            VHKK(1,NHKK) = VHKK(1,IDX)
            VHKK(2,NHKK) = VHKK(2,IDX)
            VHKK(3,NHKK) = VHKK(3,IDX)
            VHKK(4,NHKK) = VHKK(4,IDX)
C           IF (I.EQ.4) THEN
C              WHKK(1,NHKK) = POLARX(1)
C              WHKK(2,NHKK) = POLARX(2)
C              WHKK(3,NHKK) = POLARX(3)
C              WHKK(4,NHKK) = POLARX(4)
C           ELSE
               WHKK(1,NHKK) = WHKK(1,IDX)
               WHKK(2,NHKK) = WHKK(2,IDX)
               WHKK(3,NHKK) = WHKK(3,IDX)
               WHKK(4,NHKK) = WHKK(4,IDX)
C           ENDIF
            IF (LEMCCK) CALL DT_EVTEMC(-PX,-PY,-PZ,-PE,2,IDUM,IDUM)
         ENDIF
    4 CONTINUE

      IF (LEMCCK) THEN
         CHKLEV = TINY5
         CALL DT_EVTEMC(DUM,DUM,DUM,CHKLEV,-1,778,IREJ1)
         IF (IREJ1.NE.0) CALL DT_EVTOUT(4)
      ENDIF

c transform momenta into cms (as required for inc etc.)
      DO 5 I=NHKK0,NHKK
         IF (ISTHKK(I).EQ.1) THEN
            CALL DT_LTNUC(PHKK(3,I),PHKK(4,I),PZ,PE,3)
            PHKK(3,I) = PZ
            PHKK(4,I) = PE
         ENDIF
    5 CONTINUE

      RETURN
      END
c
c===kkevnt=============================================================*
c
CDECK  ID>, DT_KKEVNT
      SUBROUTINE DT_KKEVNT(KKMAT,IREJ)

c***********************************************************************
c Treatment of complete nucleus-nucleus or hadron-nucleus scattering   *
c without nuclear effects (one event).                                 *
c This subroutine is an update of the previous version (KKEVT) written *
c by J. Ranft/ H.-J. Moehring.                                         *
c This version dated 20.04.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c interface HADRIN-DPM
      COMMON /HNTHRE/ EHADTH,EHADLO,EHADHI,INTHAD,IDXTA

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c coordinates of nucleons
      COMMON /DTNUCO/ PKOO(3,MAXNCL),TKOO(3,MAXNCL)

c interface between Glauber formalism and DPM
      COMMON /DTGLIF/ JSSH(MAXNCL),JTSH(MAXNCL),
     &                INTER1(MAXINT),INTER2(MAXINT)

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

c*temporary
c statistics: Glauber-formalism
      COMMON /DTSTA3/ ICWP,ICWT,NCSY,ICWPG,ICWTG,ICIG,IPGLB,ITGLB,NGLB

c*

      DATA NEVOLD,IPOLD,ITOLD,JJPOLD,EPROLD /4*0,0.0D0/

      IREJ   = 0
      ICREQU = ICREQU+1
      NC     = 0

    1 CONTINUE
      ICSAMP = ICSAMP+1
      NC     = NC+1
ccc &&&&&&& kk
ccc      IF (MOD(NC,10).EQ.0 ) THEN
      IF (MOD(NC,10).EQ.0  .and.  NC .gt. 100) THEN
cccc
         WRITE(ErrorOut,1000) NEVHKK, NC
 1000    FORMAT(1X,'KKEVNT: EVENT ',I8,' REJECTED ', i8,
     *       ' TIMES')
         GOTO 9999
      ENDIF

c initialize DTEVT1/DTEVT2
      CALL DT_EVTINI

c We need the following only in order to sample nucleon coordinates.
c However we don't have parameters (cross sections, slope etc.)
c for neutrinos available. Therefore switch projectile to proton
c in this case.
      IF (MCGENE.EQ.4) THEN
         JJPROJ = 1
      ELSE
         JJPROJ = IJPROJ
      ENDIF

   10 CONTINUE
      IF ( (NEVHKK.NE.NEVOLD).OR.(ICENTR.GT.0).OR.
c make sure that Glauber-formalism is called each time the interaction
c configuration changed
     &     (IP.NE.IPOLD).OR.(IT.NE.ITOLD).OR.(JJPROJ.NE.JJPOLD).OR.
     &     (ABS(EPROJ-EPROLD).GT.TINY10) ) THEN
c sample number of nucleon-nucleon coll. according to Glauber-form.
c///////////////////
c         if(IT .eq. 1) then
c            write(*,*) ' IT=',IT
c            write(*,*) 'ip=',IP, ' JJPROJ=',JJPROJ, ' BIMPAC=',BIMPAC
c
c            write(*,*) 'nn =',NN, ' NP=',NP, ' NT=',NT, ' JSSM=',JSSM, 
c     *      ' JTSH=', JTSH, ' KKMAT=',KKMAT, ' EPROJ=',EPROJ
c         endif
cc//////////////////////////
         CALL DT_GLAUBE(IP,IT,JJPROJ,BIMPAC,NN,NP,NT,JSSH,JTSH,KKMAT)
C&&&&&&&&&&&&&&&&&& KK
C           in some case pion projectile and H target goes into loop
C           in that case imact parameter is set to be -1.
C           Then, force to set something to workaround 
         if(BIMPAC .eq. -1.) then
            BIMPAC=  5.921610841295514E-002
            NN = 1
            NP = 1
            NT = 1
            JSSM = 0 
            JTSH(1) = 1
         endif
C&&&&&&&&&&&&&&&&&&&
c///////////////////
c         if(IT .eq. 1) then
c            write(*,*) ' IT=',IT
c            write(*,*) 'ip=',IP, ' JJPROJ=',JJPROJ, ' BIMPAC=',BIMPAC
c
c            write(*,*) 'nn =',NN, ' NP=',NP, ' NT=',NT, ' JSSM=',JSSM, 
c     *      ' JTSH=', JTSH, ' KKMAT=',KKMAT, ' EPROJ=',EPROJ
c         endif
c//////////////
         NWTSAM = NN
         NWASAM = NP
         NWBSAM = NT
         NEVOLD = NEVHKK
         IPOLD  = IP
         ITOLD  = IT
         JJPOLD = JJPROJ
         EPROLD = EPROJ
      ENDIF

c force diffractive particle production in h-K interactions
      IF (((ABS(ISINGD).GT.1).OR.(ABS(IDOUBD).GT.1)).AND.
     &    (IP.EQ.1).AND.(NN.NE.1)) THEN
         NEVOLD = 0
         GOTO 10
      ENDIF

c check number of involved proj. nucl. (NP) if central prod.is requested
      IF (ICENTR.GT.0) THEN
         CALL DT_CHKCEN(IP,IT,NP,NT,IBACK)
         IF (IBACK.GT.0) GOTO 10
      ENDIF

c get initial nucleon-configuration in projectile and target
c rest-system (including Fermi-momenta if requested)
      CALL DT_ININUC(IJPROJ,IP,IPZ,PKOO,JSSH,1)
      MODE = 2
      IF (EPROJ.LE.EHADTH) MODE = 3
      CALL DT_ININUC(IJTARG,IT,ITZ,TKOO,JTSH,MODE)

      IF ((MCGENE.NE.3).AND.(MCGENE.NE.4)) THEN

c activate HADRIN at low energies (implemented for h-N scattering only)
         IF (EPROJ.LE.EHADHI) THEN
            IF (EHADTH.LT.ZERO) THEN
c   smooth transition btwn. DPM and HADRIN
               FRAC = (EPROJ-EHADLO)/(EHADHI-EHADLO)
               RR   = DT_RNDM(FRAC)
               IF (RR.GT.FRAC) THEN
                  IF (IP.EQ.1) THEN
                     CALL DT_HADCOL(IJPROJ,PPROJ,IDXTA,IREJ1)
                     IF (IREJ1.GT.0) GOTO 1
                     RETURN
                  ELSE
                     WRITE(ErrorOut,1001) IP,IT,EPROJ,EHADTH
                  ENDIF
               ENDIF
            ELSE
c   fixed threshold for onset of production via HADRIN
               IF (EPROJ.LE.EHADTH) THEN
                  IF (IP.EQ.1) THEN
                     CALL DT_HADCOL(IJPROJ,PPROJ,IDXTA,IREJ1)
                     IF (IREJ1.GT.0) GOTO 1
                     RETURN
                  ELSE
                     WRITE(ErrorOut,1001) IP,IT,EPROJ,EHADTH
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
 1001    FORMAT(1X,'KKEVNT:   WARNING! INTERACTION OF PROJ. (M=',
     &          I3,') WITH TARGET (M=',I3,')',/,11X,
     &          'AT E_LAB=',F5.1,'GEV (THRESHOLD-ENERGY: ',F3.1,
     &          'GEV) CANNOT BE HANDLED')

c sampling of momentum-x fractions & flavors of chain ends
         CALL DT_SPLPTN(NN)

c Lorentz-transformation of wounded nucleons into nucl.-nucl. cms
         CALL DT_NUC2CM

c collect momenta of chain ends and put them into DTEVT1
         CALL DT_GETPTN(IP,NN,NCSY,IREJ1)
         IF (IREJ1.NE.0) GOTO 1

      ENDIF

c handle chains including fragmentation (two-chain approximation)
      IF (MCGENE.EQ.1) THEN
c  two-chain approximation
         CALL DT_EVENTA(IJPROJ,IP,IT,NCSY,IREJ1)
         IF (IREJ1.NE.0) THEN
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in KKEVNT'
            GOTO 1
         ENDIF
      ELSEIF (MCGENE.EQ.2) THEN
c  multiple-Po exchange including minijets
         CALL DT_EVENTB(NCSY,IREJ1)
         IF (IREJ1.NE.0) THEN
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 2 in KKEVNT'
            GOTO 1
         ENDIF
      ELSEIF (MCGENE.EQ.3) THEN

         STOP ' THIS VERSION DOES NOT CONTAIN LEPTO !'

      ELSEIF (MCGENE.EQ.4) THEN
c  quasi-elastic neutrino scattering
         CALL DT_EVENTD(IREJ1)
         IF (IREJ1.NE.0) THEN
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 4 in KKEVNT'
            GOTO 1
         ENDIF
      ELSE
         WRITE(ErrorOut,1002) MCGENE
 1002    FORMAT(1X,'KKEVNT:   WARNING! EVENT-GENERATOR',I4,
     &         ' NOT AVAILABLE - PROGRAM STOPPED')
         STOP
      ENDIF

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===chkcen=============================================================*
c
CDECK  ID>, DT_CHKCEN
      SUBROUTINE DT_CHKCEN(IP,IT,NP,NT,IBACK)

c***********************************************************************
c Check of number of involved projectile nucleons if central production*
c is requested.                                                        *
c Adopted from a part of the old KKEVT routine which was written by    *
c J. Ranft/H.-J.Moehring.                                              *
c This version dated 13.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR


      IBACK = 0

c old version
      IF (ICENTR.EQ.2) THEN
         IF (IP.LT.IT) THEN
            IF (IP.LE.8) THEN
               IF (NP.LT.IP-1) IBACK = 1
            ELSEIF (IP.LE.16) THEN
               IF (NP.LT.IP-2) IBACK = 1
            ELSEIF (IP.LE.32) THEN
               IF (NP.LT.IP-3) IBACK = 1
            ELSEIF (IP.GE.33) THEN
               IF (NP.LT.IP-5) IBACK = 1
            ENDIF
         ELSEIF (IP.EQ.IT) THEN
            IF (IP.EQ.32) THEN
               IF ((NP.LT.22).OR.(NT.LT.22)) IBACK = 1
            ELSE
               IF (NP.LT.IP-IP/8) IBACK = 1
            ENDIF
         ELSEIF (ABS(IP-IT).LT.3) THEN
            IF (NP.LT.IP-IP/8) IBACK = 1
         ENDIF
      ELSE
c new version (DPMJET, 5.6.99)
         IF (IP.LT.IT) THEN
            IF (IP.LE.8) THEN
               IF (NP.LT.IP-1) IBACK = 1
            ELSEIF (IP.LE.16) THEN
               IF (NP.LT.IP-2) IBACK = 1
            ELSEIF (IP.LT.32) THEN
               IF (NP.LT.IP-3) IBACK = 1
            ELSEIF (IP.GE.32) THEN
               IF (IT.LE.150) THEN
c   Example: S-Ag
                  IF (NP.LT.IP-1) IBACK = 1
               ELSE
c   Example: S-Au
                  IF (NP.LT.IP) IBACK = 1
               ENDIF
            ENDIF
         ELSEIF (IP.EQ.IT) THEN
c   Example: S-S
           IF (IP.EQ.32) THEN
              IF ((NP.LT.22).OR.(NT.LT.22)) IBACK = 1
c   Example: Pb-Pb
           ELSE
              IF (NP.LT.IP-IP/4) IBACK = 1
           ENDIF
         ELSEIF (ABS(IP-IT).LT.3) THEN
            IF (NP.LT.IP-IP/8) IBACK = 1
         ENDIF
      ENDIF

      ICCPRO = ICCPRO+1

      RETURN
      END
c
c===ininuc=============================================================*
c
CDECK  ID>, DT_ININUC
      SUBROUTINE DT_ININUC(ID,NMASS,NCH,COORD,JS,IMODE)

c***********************************************************************
c Samples initial configuration of nucleons in nucleus with mass NMASS *
c including Fermi-momenta (if reqested).                               *
c          ID             BAMJET-code for hadrons (instead of nuclei)  *
c          NMASS          mass number of nucleus (number of nucleons)  *
c          NCH            charge of nucleus                            *
c          COORD(3,NMASS) coordinates of nucleons inside nucleus in fm *
c          JS(NMASS) > 0  nucleon undergoes nucleon-nucleon interact.  *
c          IMODE = 1      projectile nucleus                           *
c                = 2      target     nucleus                           *
c                = 3      target     nucleus (E_lab<E_thr for HADRIN)  *
c Adopted from a part of the old KKEVT routine which was written by    *
c J. Ranft/H.-J.Moehring.                                              *
c This version dated 13.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (FM2MM=1.0D-12)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c auxiliary common for chain system storage (DTUNUC 1.x)
      COMMON /DTCHSY/ ISKPCH(8,MAXINT),IPOSP(MAXNCL),IPOST(MAXNCL)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c interface HADRIN-DPM
      COMMON /HNTHRE/ EHADTH,EHADLO,EHADHI,INTHAD,IDXTA


      DIMENSION PF(4),PFTOT(4),COORD(3,MAXNCL),JS(MAXNCL)

c number of neutrons
      NNEU = NMASS-NCH
c initializations
      NP = 0
      NN = 0
      DO 1 K=1,4
         PFTOT(K) = 0.0D0
    1 CONTINUE
      MODE   = IMODE
      IF (IMODE.GT.2) MODE = 2
c*sr 29.5. new NPOINT(1)-definition
C     IF (IMODE.GE.2) NPOINT(1) = NHKK+1
c*
      NHADRI = 0
      NC     = NHKK

c get initial configuration
      DO 2 I=1,NMASS
         NHKK = NHKK+1
         IF (JS(I).GT.0) THEN
            ISTHKK(NHKK) = 10+MODE
            IF (IMODE.EQ.3) THEN
c   additional treatment if HADRIN-generator is requested
               NHADRI = NHADRI+1
               IF (NHADRI.EQ.1) IDXTA  = NHKK
               IF (NHADRI.GT.1) ISTHKK(NHKK) = 14
            ENDIF
         ELSE
            ISTHKK(NHKK) = 12+MODE
         ENDIF
         IF (NMASS.GE.2) THEN
c   treatment for nuclei
            FRAC = 1.0D0-DBLE(NCH)/DBLE(NMASS)
            RR   = DT_RNDM(FRAC)
            IF ((RR.LT.FRAC).AND.(NN.LT.NNEU)) THEN
               IDX = 8
               NN  = NN+1
            ELSEIF ((RR.GE.FRAC).AND.(NP.LT.NCH)) THEN
               IDX = 1
               NP  = NP+1
            ELSEIF (NN.LT.NNEU) THEN
               IDX = 8
               NN  = NN+1
            ELSEIF (NP.LT.NCH)  THEN
               IDX = 1
               NP  = NP+1
            ENDIF
            IDHKK(NHKK) = IDT_IPDGHA(IDX)
            IDBAM(NHKK) = IDX
            IF (MODE.EQ.1) THEN
               IPOSP(I)  = NHKK
               KKPROJ(I) = IDX
            ELSE
               IPOST(I)  = NHKK
               KKTARG(I) = IDX
            ENDIF
            IF (IDX.EQ.1) THEN
               PFER = PFERMP(MODE)
               PBIN = SQRT(2.0D0*EBINDP(MODE)*AAM(1))
            ELSE
               PFER = PFERMN(MODE)
               PBIN = SQRT(2.0D0*EBINDN(MODE)*AAM(8))
            ENDIF
            CALL DT_FER4M(PFER,PBIN,PF(1),PF(2),PF(3),PF(4),IDX)
            DO 3 K=1,4
               PFTOT(K) = PFTOT(K)+PF(K)
               PHKK(K,NHKK) = PF(K)
    3       CONTINUE
            PHKK(5,NHKK) = AAM(IDX)
         ELSE
c   treatment for hadrons
            IDHKK(NHKK)  = IDT_IPDGHA(ID)
            IDBAM(NHKK)  = ID
            PHKK(4,NHKK) = AAM(ID)
            PHKK(5,NHKK) = AAM(ID)
C* VDM assumption
C            IF (IDHKK(NHKK).EQ.22) THEN
C               PHKK(4,NHKK) = AAM(33)
C               PHKK(5,NHKK) = AAM(33)
C            ENDIF
            IF (MODE.EQ.1) THEN
               IPOSP(I)  = NHKK
               KKPROJ(I) = ID
               PHKK(5,NHKK) = PHKK(5,NHKK)-SQRT(VIRT)
            ELSE
               IPOST(I)  = NHKK
               KKTARG(I) = ID
            ENDIF
         ENDIF
         DO 4 K=1,3
            VHKK(K,NHKK) = COORD(K,I)*FM2MM
            WHKK(K,NHKK) = COORD(K,I)*FM2MM
    4    CONTINUE
         IF (MODE.EQ.2) VHKK(1,NHKK) = VHKK(1,NHKK)+BIMPAC*FM2MM
         IF (MODE.EQ.2) WHKK(1,NHKK) = WHKK(1,NHKK)+BIMPAC*FM2MM
         VHKK(4,NHKK) = 0.0D0
         WHKK(4,NHKK) = 0.0D0
    2 CONTINUE

c balance Fermi-momenta
      IF (NMASS.GE.2) THEN
         DO 5 I=1,NMASS
            NC = NC+1
            DO 6 K=1,3
               PHKK(K,NC) = PHKK(K,NC)-PFTOT(K)/DBLE(NMASS)
    6       CONTINUE
            PHKK(4,NC) = SQRT(PHKK(5,NC)**2+PHKK(1,NC)**2+
     &                        PHKK(2,NC)**2+PHKK(3,NC)**2)
    5    CONTINUE
      ENDIF

      RETURN
      END
c
c===fer4m==============================================================*
c
CDECK  ID>, DT_FER4M
      SUBROUTINE DT_FER4M(PFERM,PBIND,PXT,PYT,PZT,ET,KT)

c***********************************************************************
c Sampling of nucleon Fermi-momenta from distributions at T=0.         *
c                                   processed by S. Roesler, 17.10.95  *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      LOGICAL LSTART

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI


      DATA LSTART /.TRUE./

      ILOOP = 0
      IF (LFERMI) THEN
         IF (LSTART) THEN
            WRITE(ErrorOut,1000)
 1000       FORMAT(/,1X,'FER4M:   SAMPLING OF FERMI-MOMENTA ACTIVATED')
            LSTART = .FALSE.
         ENDIF
    1    CONTINUE
         CALL DT_DFERMI(PABS)
         PABS = PFERM*PABS
C        IF (PABS.GE.PBIND) THEN
C           ILOOP = ILOOP+1
C           IF (MOD(ILOOP,500).EQ.0) THEN
C              WRITE(LOUT,1001) PABS,PBIND,ILOOP
C1001          FORMAT(1X,'FER4M:    Fermi-mom. corr. for binding',
C    &                ' energy ',2E12.3,I6)
C           ENDIF
C           GOTO 1
C        ENDIF
         CALL DT_DPOLI(POLC,POLS)
         CALL DT_DSFECF(SFE,CFE)
         CXTA = POLS*CFE
         CYTA = POLS*SFE
         CZTA = POLC
         ET   = SQRT(PABS*PABS+AAM(KT)**2)
         PXT  = CXTA*PABS
         PYT  = CYTA*PABS
         PZT  = CZTA*PABS
      ELSE
         ET   = AAM(KT)
         PXT  = 0.0D0
         PYT  = 0.0D0
         PZT  = 0.0D0
      ENDIF

      RETURN
      END
c
c===nuc2cm=============================================================*
c
CDECK  ID>, DT_NUC2CM
      SUBROUTINE DT_NUC2CM

c***********************************************************************
c Lorentz-transformation of all wounded nucleons from Lab. to nucl.-   *
c nucl. cms. (This subroutine replaces NUCMOM.)                        *
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY3=1.0D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c*temporary
c statistics: Glauber-formalism
      COMMON /DTSTA3/ ICWP,ICWT,NCSY,ICWPG,ICWTG,ICIG,IPGLB,ITGLB,NGLB

c*

      ICWP = 0
      ICWT = 0
      NWTACC = 0
      NWAACC = 0
      NWBACC = 0

      NPOINT(1) = NHKK+1
      NEND      = NHKK
      DO 1 I=1,NEND
         IF ((ISTHKK(I).EQ.11).OR.(ISTHKK(I).EQ.12)) THEN
            IF (ISTHKK(I).EQ.11) NWAACC = NWAACC+1
            IF (ISTHKK(I).EQ.12) NWBACC = NWBACC+1
            MODE = ISTHKK(I)-9
C            IF (IDHKK(I).EQ.22) THEN
C* VDM assumption
C               PEIN = AAM(33)
C               IDB  = 33
C            ELSE
C               PEIN = PHKK(4,I)
C               IDB  = IDBAM(I)
C            ENDIF
C            CALL DT_LTRANS(PHKK(1,I),PHKK(2,I),PHKK(3,I),PEIN,
C     &           PX,PY,PZ,PE,IDB,MODE)
            IF (PHKK(5,I).GT.ZERO) THEN
               CALL DT_LTRANS(PHKK(1,I),PHKK(2,I),PHKK(3,I),PHKK(4,I),
     &              PX,PY,PZ,PE,IDBAM(I),MODE)
            ELSE
               PX = PGAMM(1)
               PY = PGAMM(2)
               PZ = PGAMM(3)
               PE = PGAMM(4)
            ENDIF
            IST = ISTHKK(I)-2
            ID  = IDHKK(I)
C* VDM assumption
C            IF (ID.EQ.22) ID = 113
            CALL DT_EVTPUT(IST,ID,I,0,PX,PY,PZ,PE,0,0,0)
            IF (ISTHKK(I).EQ.11) ICWP = ICWP+1
            IF (ISTHKK(I).EQ.12) ICWT = ICWT+1
         ENDIF
    1 CONTINUE

      NWTACC = MAX(NWAACC,NWBACC)
      ICDPR  = ICDPR+ICWP
      ICDTA  = ICDTA+ICWT
c*temporary
      IF ((ICWP.EQ.0).OR.(ICWT.EQ.0)) THEN
         CALL DT_EVTOUT(4)
         STOP
      ENDIF

      RETURN
      END
c
c===splptn=============================================================*
c
CDECK  ID>, DT_SPLPTN
      SUBROUTINE DT_SPLPTN(NN)

c***********************************************************************
c SamPLing of ParToN momenta and flavors.                              *
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ


c sample flavors of sea-quarks
      CALL DT_SPLFLA(NN,1)

c sample x-values of partons at chain ends
      ECM = UMO
      CALL DT_XKSAMP(NN,ECM)

c samle flavors
      CALL DT_SPLFLA(NN,2)

      RETURN
      END
c
c===splfla=============================================================*
c
CDECK  ID>, DT_SPLFLA
      SUBROUTINE DT_SPLFLA(NN,MODE)

c***********************************************************************
c SamPLing of FLAvors of partons at chain ends.                        *
c This subroutine replaces FLKSAA/FLKSAM.                              *
c            NN            number of nucleon-nucleon interactions      *
c            MODE = 1      sea-flavors                                 *
c                 = 2      valence-flavors                             *
c Based on the original version written by J. Ranft/H.-J. Moehring.    *
c This version dated 16.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPMI/ NVV,NSV,NVS,NSS,NDV,NVD,NDS,NSD,
     &                IXPV,IXPS,IXTV,IXTS,
     &                INTVV1(MAXVQU),INTVV2(MAXVQU),
     &                INTSV1(MAXVQU),INTSV2(MAXVQU),
     &                INTVS1(MAXVQU),INTVS2(MAXVQU),
     &                INTSS1(MAXSQU),INTSS2(MAXSQU),
     &                INTDV1(MAXVQU),INTDV2(MAXVQU),
     &                INTVD1(MAXVQU),INTVD2(MAXVQU),
     &                INTDS1(MAXSQU),INTDS2(MAXSQU),
     &                INTSD1(MAXSQU),INTSD2(MAXSQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPM0/ IFROVP(MAXVQU),ITOVP(MAXVQU),IFROSP(MAXSQU),
     &                IFROVT(MAXVQU),ITOVT(MAXVQU),IFROST(MAXSQU)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      IF (MODE.EQ.1) THEN
c sea-flavors
         DO 1 I=1,NN
            IPSQ(I)  = INT(1.0D0+DT_RNDM(CRONCO)*(2.0D0+SEASQ))
            IPSAQ(I) = -IPSQ(I)
    1    CONTINUE
         DO 2 I=1,NN
            ITSQ(I) = INT(1.0D0+DT_RNDM(CRONCO)*(2.0D0+SEASQ))
            ITSAQ(I)= -ITSQ(I)
    2    CONTINUE
      ELSEIF (MODE.EQ.2) THEN
c valence flavors
         DO 3 I=1,IXPV
            CALL DT_FLAHAD(KKPROJ(IFROVP(I)),IPVQ(I),IPPV1(I),IPPV2(I))
    3    CONTINUE
         DO 4 I=1,IXTV
            CALL DT_FLAHAD(KKTARG(IFROVT(I)),ITVQ(I),ITTV1(I),ITTV2(I))
    4    CONTINUE
      ENDIF

      RETURN
      END
c
c===getptn=============================================================*
c
CDECK  ID>, DT_GETPTN
      SUBROUTINE DT_GETPTN(IP,NN,NCSY,IREJ)

c***********************************************************************
c This subroutine collects partons at chain ends from temporary        *
c commons and puts them into DTEVT1.                                   *
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0,OHALF=0.5D0)

      LOGICAL LCHK


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c auxiliary common for chain system storage (DTUNUC 1.x)
      COMMON /DTCHSY/ ISKPCH(8,MAXINT),IPOSP(MAXNCL),IPOST(MAXNCL)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c x-values of partons (DTUNUC 1.x)
      COMMON /DTDPMX/ XPVQ(MAXVQU),XPVD(MAXVQU),
     &                XTVQ(MAXVQU),XTVD(MAXVQU),
     &                XPSQ(MAXSQU),XPSAQ(MAXSQU),
     &                XTSQ(MAXSQU),XTSAQ(MAXSQU)

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPMI/ NVV,NSV,NVS,NSS,NDV,NVD,NDS,NSD,
     &                IXPV,IXPS,IXTV,IXTS,
     &                INTVV1(MAXVQU),INTVV2(MAXVQU),
     &                INTSV1(MAXVQU),INTSV2(MAXVQU),
     &                INTVS1(MAXVQU),INTVS2(MAXVQU),
     &                INTSS1(MAXSQU),INTSS2(MAXSQU),
     &                INTDV1(MAXVQU),INTDV2(MAXVQU),
     &                INTVD1(MAXVQU),INTVD2(MAXVQU),
     &                INTDS1(MAXSQU),INTDS2(MAXSQU),
     &                INTSD1(MAXSQU),INTSD2(MAXSQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPM0/ IFROVP(MAXVQU),ITOVP(MAXVQU),IFROSP(MAXSQU),
     &                IFROVT(MAXVQU),ITOVT(MAXVQU),IFROST(MAXSQU)


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),PP(4),PT(4)

      DATA AMSS,AMVS,AMDS,AMVD,AMVV/0.4D0,2.0D0,2.0D0,2.5D0,2.0D0/

      IREJ      = 0
      NCSY      = 0
      NPOINT(2) = NHKK+1

c sea-sea chains
      DO 10 I=1,NSS
         IF (ISKPCH(1,I).EQ.99) GOTO 10
         ICCHAI(1,1) = ICCHAI(1,1)+2
         IDXP = INTSS1(I)
         IDXT = INTSS2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 11 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTSAQ(IDXT)*PHKK(K,MOT)
            PT2(K) = XTSQ(IDXT) *PHKK(K,MOT)
   11    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMSS).OR.(AM2.LT.AMSS)) THEN
C              WRITE(LOUT,5000) NEVHKK,I,AM1,AM2
 5000          FORMAT(1X,'INCON. CHAIN MASS SS: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5000) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPSAQ(IDXP),0,2)
         IFT1 = IDT_IB2PDG(ITSAQ(IDXT),0,2)
         IFT2 = IDT_IB2PDG(ITSQ(IDXT),0,2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,1)
         CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,1)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,1)
         CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,1)
         NCSY = NCSY+1
   10 CONTINUE

c disea-sea chains
      DO 20 I=1,NDS
         IF (ISKPCH(2,I).EQ.99) GOTO 20
         ICCHAI(1,2) = ICCHAI(1,2)+2
         IDXP = INTDS1(I)
         IDXT = INTDS2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 21 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTSQ(IDXT) *PHKK(K,MOT)
            PT2(K) = XTSAQ(IDXT)*PHKK(K,MOT)
   21    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMDS).OR.(AM2.LT.AMDS)) THEN
C              WRITE(LOUT,5001) NEVHKK,I,AM1,AM2
 5001          FORMAT(1X,'INCON. CHAIN MASS DS: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5001) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),IPSQ2(IDXP),2)
         IFP2 = IDT_IB2PDG(-IPSQ(IDXP),-IPSQ2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITSQ(IDXT),0,2)
         IFT2 = IDT_IB2PDG(ITSAQ(IDXT),0,2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,2)
         CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,2)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,2)
         CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,2)
         NCSY = NCSY+1
   20 CONTINUE

c sea-disea chains
      DO 30 I=1,NSD
         IF (ISKPCH(3,I).EQ.99) GOTO 30
         ICCHAI(1,3) = ICCHAI(1,3)+2
         IDXP = INTSD1(I)
         IDXT = INTSD2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 31 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTSQ(IDXT) *PHKK(K,MOT)
            PT2(K) = XTSAQ(IDXT)*PHKK(K,MOT)
   31    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMDS).OR.(AM2.LT.AMDS)) THEN
C              WRITE(LOUT,5002) NEVHKK,I,AM1,AM2
 5002          FORMAT(1X,'INCON. CHAIN MASS SD: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5002) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPSAQ(IDXP),0,2)
         IFT1 = IDT_IB2PDG(ITSQ(IDXT),ITSQ2(IDXT),2)
         IFT2 = IDT_IB2PDG(-ITSQ(IDXT),-ITSQ2(IDXT),2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,3)
         CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,3)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,3)
         CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,3)
         NCSY = NCSY+1
   30 CONTINUE

c disea-valence chains
      DO 50 I=1,NDV
         IF (ISKPCH(5,I).EQ.99) GOTO 50
         ICCHAI(1,5) = ICCHAI(1,5)+2
         IDXP = INTDV1(I)
         IDXT = INTDV2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROVT(IDXT)))
         DO 51 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTVQ(IDXT) *PHKK(K,MOT)
            PT2(K) = XTVD(IDXT) *PHKK(K,MOT)
   51    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMVD).OR.(AM2.LT.AMVD)) THEN
C              WRITE(LOUT,5003) NEVHKK,I,AM1,AM2
 5003          FORMAT(1X,'INCON. CHAIN MASS DV: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5003) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),IPSQ2(IDXP),2)
         IFP2 = IDT_IB2PDG(-IPSQ(IDXP),-IPSQ2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITVQ(IDXT),0,2)
         IFT2 = IDT_IB2PDG(ITTV1(IDXT),ITTV2(IDXT),2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,5)
         CALL DT_EVTPUT(-22,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,5)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,5)
         CALL DT_EVTPUT(-22,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,5)
         NCSY = NCSY+1
   50 CONTINUE

c valence-sea chains
      DO 60 I=1,NVS
         IF (ISKPCH(6,I).EQ.99) GOTO 60
         ICCHAI(1,6) = ICCHAI(1,6)+2
         IDXP = INTVS1(I)
         IDXT = INTVS2(I)
         MOP  = JDAHKK(1,IPOSP(IFROVP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 61 K=1,4
            PP1(K) = XPVQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPVD(IDXP) *PHKK(K,MOP)
            PT1(K) = XTSAQ(IDXT)*PHKK(K,MOT)
            PT2(K) = XTSQ(IDXT) *PHKK(K,MOT)
   61    CONTINUE
         IFP1 = IDT_IB2PDG(IPVQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPPV1(IDXP),IPPV2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITSAQ(IDXT),0,2)
         IFT2 = IDT_IB2PDG(ITSQ(IDXT),0,2)
         CALL  DT_CHKCSY(IFP1,IFT1,LCHK)
         IF (LCHK) THEN
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,6)
            PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                     +(PP1(3)+PT1(3))**2)
            ECH   = PP1(4)+PT1(4)
            AM1   = (ECH+PTOCH)*(ECH-PTOCH)
            PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                     +(PP2(3)+PT2(3))**2)
            ECH   = PP2(4)+PT2(4)
            AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         ELSE
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,6)
            CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,6)
            PTOCH = SQRT((PP1(1)+PT2(1))**2+(PP1(2)+PT2(2))**2
     &                                     +(PP1(3)+PT2(3))**2)
            ECH   = PP1(4)+PT2(4)
            AM2   = (ECH+PTOCH)*(ECH-PTOCH)
            PTOCH = SQRT((PP2(1)+PT1(1))**2+(PP2(2)+PT1(2))**2
     &                                     +(PP2(3)+PT1(3))**2)
            ECH   = PP2(4)+PT1(4)
            AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         ENDIF
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMSS).OR.(AM2.LT.AMVS)) THEN
C              WRITE(LOUT,5004) NEVHKK,I,AM1,AM2
 5004          FORMAT(1X,'INCON. CHAIN MASS VS: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5004) NEVHKK,I,AM1,AM2
         ENDIF
         NCSY = NCSY+1
   60 CONTINUE

c sea-valence chains
      DO 40 I=1,NSV
         IF (ISKPCH(4,I).EQ.99) GOTO 40
         ICCHAI(1,4) = ICCHAI(1,4)+2
         IDXP = INTSV1(I)
         IDXT = INTSV2(I)
         MOP  = JDAHKK(1,IPOSP(IFROSP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROVT(IDXT)))
         DO 41 K=1,4
            PP1(K) = XPSQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPSAQ(IDXP)*PHKK(K,MOP)
            PT1(K) = XTVD(IDXT) *PHKK(K,MOT)
            PT2(K) = XTVQ(IDXT) *PHKK(K,MOT)
   41    CONTINUE
         PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                  +(PP1(3)+PT1(3))**2)
         ECH   = PP1(4)+PT1(4)
         AM1   = (ECH+PTOCH)*(ECH-PTOCH)
         PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                  +(PP2(3)+PT2(3))**2)
         ECH   = PP2(4)+PT2(4)
         AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMVS).OR.(AM2.LT.AMSS)) THEN
C              WRITE(LOUT,5005) NEVHKK,I,AM1,AM2
 5005          FORMAT(1X,'INCON. CHAIN MASS SV: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5005) NEVHKK,I,AM1,AM2
         ENDIF
         IFP1 = IDT_IB2PDG(IPSQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPSAQ(IDXP),0,2)
         IFT1 = IDT_IB2PDG(ITTV1(IDXT),ITTV2(IDXT),2)
         IFT2 = IDT_IB2PDG(ITVQ(IDXT),0,2)
         CALL DT_EVTPUT(-31,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                    0,0,4)
         CALL DT_EVTPUT(-22,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                    0,0,4)
         CALL DT_EVTPUT(-31,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                    0,0,4)
         CALL DT_EVTPUT(-22,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                    0,0,4)
         NCSY = NCSY+1
   40 CONTINUE

c valence-disea chains
      DO 70 I=1,NVD
         IF (ISKPCH(7,I).EQ.99) GOTO 70
         ICCHAI(1,7) = ICCHAI(1,7)+2
         IDXP = INTVD1(I)
         IDXT = INTVD2(I)
         MOP  = JDAHKK(1,IPOSP(IFROVP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROST(IDXT)))
         DO 71 K=1,4
            PP1(K) = XPVQ(IDXP) *PHKK(K,MOP)
            PP2(K) = XPVD(IDXP) *PHKK(K,MOP)
            PT1(K) = XTSQ(IDXT) *PHKK(K,MOT)
            PT2(K) = XTSAQ(IDXT)*PHKK(K,MOT)
   71    CONTINUE
         IFP1 = IDT_IB2PDG(IPVQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPPV1(IDXP),IPPV2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITSQ(IDXT),ITSQ2(IDXT),2)
         IFT2 = IDT_IB2PDG(-ITSQ(IDXT),-ITSQ2(IDXT),2)
         CALL  DT_CHKCSY(IFP1,IFT1,LCHK)
         IF (LCHK) THEN
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,7)
            PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                     +(PP1(3)+PT1(3))**2)
            ECH   = PP1(4)+PT1(4)
            AM1   = (ECH+PTOCH)*(ECH-PTOCH)
            PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                     +(PP2(3)+PT2(3))**2)
            ECH   = PP2(4)+PT2(4)
            AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         ELSE
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-32,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,7)
            CALL DT_EVTPUT(-32,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,7)
            PTOCH = SQRT((PP1(1)+PT2(1))**2+(PP1(2)+PT2(2))**2
     &                                     +(PP1(3)+PT2(3))**2)
            ECH   = PP1(4)+PT2(4)
            AM1   = (ECH+PTOCH)*(ECH-PTOCH)
            PTOCH = SQRT((PP2(1)+PT1(1))**2+(PP2(2)+PT1(2))**2
     &                                     +(PP2(3)+PT1(3))**2)
            ECH   = PP2(4)+PT1(4)
            AM2   = (ECH+PTOCH)*(ECH-PTOCH)
         ENDIF
         IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
            AM1 = SQRT(AM1)
            AM2 = SQRT(AM2)
            IF ((AM1.LT.AMVD).OR.(AM2.LT.AMVD)) THEN
C              WRITE(LOUT,5006) NEVHKK,I,AM1,AM2
 5006          FORMAT(1X,'INCON. CHAIN MASS VD: ',2I5,2E10.3)
            ENDIF
         ELSE
            WRITE(ErrorOut,5006) NEVHKK,I,AM1,AM2
         ENDIF
         NCSY = NCSY+1
   70 CONTINUE

c valence-valence chains
      DO 80 I=1,NVV
         IF (ISKPCH(8,I).EQ.99) GOTO 80
         ICCHAI(1,8) = ICCHAI(1,8)+2
         IDXP = INTVV1(I)
         IDXT = INTVV2(I)
         MOP  = JDAHKK(1,IPOSP(IFROVP(IDXP)))
         MOT  = JDAHKK(1,IPOST(IFROVT(IDXT)))
         DO 81 K=1,4
            PP1(K) = XPVQ(IDXP)*PHKK(K,MOP)
            PP2(K) = XPVD(IDXP)*PHKK(K,MOP)
            PT1(K) = XTVD(IDXT)*PHKK(K,MOT)
            PT2(K) = XTVQ(IDXT)*PHKK(K,MOT)
   81    CONTINUE
         IFP1 = IDT_IB2PDG(IPVQ(IDXP),0,2)
         IFP2 = IDT_IB2PDG(IPPV1(IDXP),IPPV2(IDXP),2)
         IFT1 = IDT_IB2PDG(ITTV1(IDXT),ITTV2(IDXT),2)
         IFT2 = IDT_IB2PDG(ITVQ(IDXT),0,2)

c check for diffractive event
         IDIFF = 0
         IF (((ISINGD.GT.0).OR.(IDOUBD.GT.0)).AND.
     &        (IP.EQ.1).AND.(NN.EQ.1)) THEN
            DO 800 K=1,4
               PP(K) = PP1(K)+PP2(K)
               PT(K) = PT1(K)+PT2(K)
  800       CONTINUE
            ISTCK = NHKK
            CALL DT_DIFEVT(IFP1,IFP2,PP,MOP,
     &                  IFT1,IFT2,PT,MOT,IDIFF,NCSY,IREJ1)
C           IF (IREJ1.NE.0) GOTO 9999
            IF (IREJ1.NE.0) THEN
               IDIFF = 0
               NHKK  = ISTCK
            ENDIF
         ELSE
            IDIFF = 0
         ENDIF

         IF (IDIFF.EQ.0) THEN
c   valence-valence chain system
            CALL  DT_CHKCSY(IFP1,IFT1,LCHK)
            IF (LCHK) THEN
c    baryon-baryon
               CALL DT_EVTPUT(-21,IFP1,MOP,0,
     &                     PP1(1),PP1(2),PP1(3),PP1(4),0,0,8)
               CALL DT_EVTPUT(-22,IFT1,MOT,0,
     &                     PT1(1),PT1(2),PT1(3),PT1(4),0,0,8)
               CALL DT_EVTPUT(-21,IFP2,MOP,0,
     &                     PP2(1),PP2(2),PP2(3),PP2(4),0,0,8)
               CALL DT_EVTPUT(-22,IFT2,MOT,0,
     &                     PT2(1),PT2(2),PT2(3),PT2(4),0,0,8)
               PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                                        +(PP1(3)+PT1(3))**2)
               ECH   = PP1(4)+PT1(4)
               AM1   = (ECH+PTOCH)*(ECH-PTOCH)
               PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                                        +(PP2(3)+PT2(3))**2)
               ECH   = PP2(4)+PT2(4)
               AM2   = (ECH+PTOCH)*(ECH-PTOCH)
            ELSE
c    antibaryon-baryon
               CALL DT_EVTPUT(-21,IFP1,MOP,0,
     &                     PP1(1),PP1(2),PP1(3),PP1(4),0,0,8)
               CALL DT_EVTPUT(-22,IFT2,MOT,0,
     &                     PT2(1),PT2(2),PT2(3),PT2(4),0,0,8)
               CALL DT_EVTPUT(-21,IFP2,MOP,0,
     &                     PP2(1),PP2(2),PP2(3),PP2(4),0,0,8)
               CALL DT_EVTPUT(-22,IFT1,MOT,0,
     &                     PT1(1),PT1(2),PT1(3),PT1(4),0,0,8)
               PTOCH = SQRT((PP1(1)+PT2(1))**2+(PP1(2)+PT2(2))**2
     &                                        +(PP1(3)+PT2(3))**2)
               ECH   = PP1(4)+PT2(4)
               AM1   = (ECH+PTOCH)*(ECH-PTOCH)
               PTOCH = SQRT((PP2(1)+PT1(1))**2+(PP2(2)+PT1(2))**2
     &                                        +(PP2(3)+PT1(3))**2)
               ECH   = PP2(4)+PT1(4)
               AM2   = (ECH+PTOCH)*(ECH-PTOCH)
            ENDIF
            IF ((AM1.GT.0.0D0).AND.(AM2.GT.0.0D0)) THEN
               AM1 = SQRT(AM1)
               AM2 = SQRT(AM2)
               IF ((AM1.LT.AMVV).OR.(AM2.LT.AMVV)) THEN
C                 WRITE(LOUT,5007) NEVHKK,I,AM1,AM2
 5007             FORMAT(1X,'INCON. CHAIN MASS VV: ',2I5,2E10.3)
               ENDIF
            ELSE
               WRITE(ErrorOut,5007) NEVHKK,I,AM1,AM2
            ENDIF
            NCSY = NCSY+1
         ENDIF
   80 CONTINUE
      IF (ISTHKK(NPOINT(2)).EQ.1) NPOINT(2) = NPOINT(2)+1

c energy-momentum & flavor conservation check
      IF (ABS(IDIFF).NE.1) THEN
         IF (IDIFF.NE.0) THEN
            IF (LEMCCK) CALL DT_EMC2(9,10,0,0,0,3,-21,-22,-41,1,0,
     &                                              1,3,10,IREJ)
         ELSE
            IF (LEMCCK) CALL DT_EMC2(9,10,0,0,0,3,-21,-22,-31,-32,0,
     &                                              1,3,10,IREJ)
         ENDIF
         IF (IREJ.NE.0) THEN
            CALL DT_EVTOUT(4)
            STOP
         ENDIF
      ENDIF

      RETURN

 9999 CONTINUE
      IREJ  = 1
      RETURN
      END
c
c===chkcsy=============================================================*
c
CDECK  ID>, DT_CHKCSY
      SUBROUTINE DT_CHKCSY(ID1,ID2,LCHK)

c***********************************************************************
c CHeCk Chain SYstem for consistency of partons at chain ends.         *
c            ID1,ID2        PDG-numbers of partons at chain ends       *
c            LCHK = .true.  consistent chain                           *
c                 = .false. inconsistent chain                         *
c This version dated 18.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      LOGICAL LCHK

      LCHK = .TRUE.

c q-aq chain
      IF ((ABS(ID1).LE.6).AND.(ABS(ID2).LE.6)) THEN
         IF (ID1*ID2.GT.0) LCHK = .FALSE.
c q-qq, aq-aqaq chain
      ELSEIF (((ABS(ID1).LE.6).AND.(ABS(ID2).GT.6)).OR.
     &        ((ABS(ID1).GT.6).AND.(ABS(ID2).LE.6))) THEN
         IF (ID1*ID2.LT.0) LCHK = .FALSE.
c qq-aqaq chain
      ELSEIF ((ABS(ID1).GT.6).AND.(ABS(ID2).GT.6)) THEN
         IF (ID1*ID2.GT.0) LCHK = .FALSE.
      ENDIF

      RETURN
      END
c
c===eventa=============================================================*
c
CDECK  ID>, DT_EVENTA
      SUBROUTINE DT_EVENTA(ID,IP,IT,NCSY,IREJ)

c***********************************************************************
c Treatment of nucleon-nucleon interactions in a two-chain             *
c approximation.                                                       *
c  (input) ID       BAMJET-index of projectile hadron (in case of      *
c                   h-K scattering)                                    *
c          IP/IT    mass number of projectile/target nucleus           *
c          NCSY     number of two chain systems                        *
c          IREJ     rejection flag                                     *
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4)

      IREJ      = 0
      NPOINT(3) = NHKK+1

c skip following treatment for low-mass diffraction
      IF (ABS(IFLAGD).EQ.1) THEN
         NPOINT(3) = NPOINT(2)
         GOTO 5
      ENDIF

c multiple scattering of chain ends
      IF ((IP.GT.1).AND.(MKCRON.NE.0)) CALL DT_CRONIN(1)
      IF ((IT.GT.1).AND.(MKCRON.NE.0)) CALL DT_CRONIN(2)

      NC = NPOINT(2)
c get a two-chain system from DTEVT1
      DO 3 I=1,NCSY
         IFP1 = IDHKK(NC)
         IFT1 = IDHKK(NC+1)
         IFP2 = IDHKK(NC+2)
         IFT2 = IDHKK(NC+3)
         DO 4 K=1,4
            PP1(K) = PHKK(K,NC)
            PT1(K) = PHKK(K,NC+1)
            PP2(K) = PHKK(K,NC+2)
            PT2(K) = PHKK(K,NC+3)
    4    CONTINUE
         MOP1 = NC
         MOT1 = NC+1
         MOP2 = NC+2
         MOT2 = NC+3
         CALL DT_GETCSY(IFP1,PP1,MOP1,IFP2,PP2,MOP2,
     &               IFT1,PT1,MOT1,IFT2,PT2,MOT2,IREJ1)
         IF (IREJ1.GT.0) THEN
            IRHHA = IRHHA+1
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in EVENTA'
            GOTO 9999
         ENDIF
         NC = NC+4
    3 CONTINUE

c meson/antibaryon projectile:
c sample single-chain valence-valence systems (Reggeon contrib.)
      IF ((IP.EQ.1).AND.(ISICHA.EQ.1)) THEN
         IF (IIBAR(ID).LE.0) CALL DT_VV2SCH
      ENDIF

      IF ((IRESCO.EQ.1).OR.(IFRAG(1).EQ.1)) THEN
c check DTEVT1 for remaining resonance mass corrections
         CALL DT_EVTRES(IREJ1)
         IF (IREJ1.GT.0) THEN
            IRRES(1) = IRRES(1)+1
            IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 2 in EVENTA'
            GOTO 9999
         ENDIF
      ENDIF

c assign p_t to two-"chain" systems consisting of two resonances only
c since only entries for chains will be affected, this is obsolete
c in case of JETSET-fragmetation
      CALL DT_RESPT

c combine q-aq chains to color ropes (qq-aqaq) (chain fusion)
      IF (LCO2CR) CALL DT_COM2CR

    5 CONTINUE

c fragmentation of the complete event
c*uncomment for internal phojet-fragmentation
C     CALL DT_EVTFRA(IREJ1)
      CALL DT_EVTFRG(2,IDUM,NPYMEM,IREJ1)
      IF (IREJ1.GT.0) THEN
         IRFRAG = IRFRAG+1
         IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 3 in EVENTA'
         GOTO 9999
      ENDIF

c decay of possible resonances (should be obsolete)
      CALL DT_DECAY1

      RETURN

 9999 CONTINUE
      IREVT = IREVT+1
      IREJ  = 1
      RETURN
      END
c
c===getcsy=============================================================*
c
CDECK  ID>, DT_GETCSY
      SUBROUTINE DT_GETCSY(IFPR1,PP1,MOP1,IFPR2,PP2,MOP2,
     &                  IFTA1,PT1,MOT1,IFTA2,PT2,MOT2,IREJ)

c***********************************************************************
c This version dated 15.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),
     &          IFP1(2),IFP2(2),IFT1(2),IFT2(2),PCH1(4),PCH2(4)

      IREJ  = 0

c get quark content of partons
      DO 1 I=1,2
         IFP1(I) = 0
         IFP2(I) = 0
         IFT1(I) = 0
         IFT2(I) = 0
    1 CONTINUE
      IFP1(1) = IDT_IPDG2B(IFPR1,1,2)
      IF (ABS(IFPR1).GE.1000) IFP1(2) = IDT_IPDG2B(IFPR1,2,2)
      IFP2(1) = IDT_IPDG2B(IFPR2,1,2)
      IF (ABS(IFPR2).GE.1000) IFP2(2) = IDT_IPDG2B(IFPR2,2,2)
      IFT1(1) = IDT_IPDG2B(IFTA1,1,2)
      IF (ABS(IFTA1).GE.1000) IFT1(2) = IDT_IPDG2B(IFTA1,2,2)
      IFT2(1) = IDT_IPDG2B(IFTA2,1,2)
      IF (ABS(IFTA2).GE.1000) IFT2(2) = IDT_IPDG2B(IFTA2,2,2)

c get kind of chains (1 - q-aq, 2 - q-qq/aq-aqaq, 3 - qq-aqaq)
      IDCH1 = 2
      IF ((IFP1(2).EQ.0).AND.(IFT1(2).EQ.0)) IDCH1 = 1
      IF ((IFP1(2).NE.0).AND.(IFT1(2).NE.0)) IDCH1 = 3
      IDCH2 = 2
      IF ((IFP2(2).EQ.0).AND.(IFT2(2).EQ.0)) IDCH2 = 1
      IF ((IFP2(2).NE.0).AND.(IFT2(2).NE.0)) IDCH2 = 3

c store initial configuration for energy-momentum cons. check
      IF (LEMCCK) CALL DT_EMC1(PP1,PP2,PT1,PT2,1,1,IDUM)

c sample intrinsic p_t at chain-ends
      CALL DT_GETSPT(PP1,IFPR1,IFP1,PP2,IFPR2,IFP2,
     &            PT1,IFTA1,IFT1,PT2,IFTA2,IFT2,
     &            AMCH1,IDCH1,AMCH2,IDCH2,IDCH(MOP1),IREJ1)
      IF (IREJ1.NE.0) THEN
         IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in GETCSY'
         IRPT = IRPT+1
         GOTO 9999
      ENDIF

C      IF ((IRESCO.EQ.1).OR.(IFRAG(1).EQ.1)) THEN
C         IF ((IDCH1.EQ.3).OR.((IDCH1.GT.1).AND.(IDCH2.EQ.1))) THEN
C* check second chain for resonance
C            CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDR2,IDXR2,
C     &                  AMCH2,AMCH2N,IDCH2,IREJ1)
C            IF (IREJ1.NE.0) GOTO 9999
C            IF (IDR2.NE.0) THEN
C               CALL DT_CHKINE(PP2,IFPR2,PP1,IFPR1,PT2,IFTA2,PT1,IFTA1,
C     &                     AMCH2,AMCH2N,AMCH1,IREJ1)
C               IF (IREJ1.NE.0) GOTO 9999
C            ENDIF
C* check first chain for resonance
C            CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDR1,IDXR1,
C     &                  AMCH1,AMCH1N,IDCH1,IREJ1)
C            IF (IREJ1.NE.0) GOTO 9999
C            IF (IDR1.NE.0) IDR1 = 100*IDR1
C         ELSE
C* check first chain for resonance
C            CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDR1,IDXR1,
C     &                  AMCH1,AMCH1N,IDCH1,IREJ1)
C            IF (IREJ1.NE.0) GOTO 9999
C            IF (IDR1.NE.0) THEN
C               CALL DT_CHKINE(PP1,IFPR1,PP2,IFPR2,PT1,IFTA1,PT2,IFTA2,
C     &                     AMCH1,AMCH1N,AMCH2,IREJ1)
C               IF (IREJ1.NE.0) GOTO 9999
C            ENDIF
C* check second chain for resonance
C            CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDR2,IDXR2,
C     &                  AMCH2,AMCH2N,IDCH2,IREJ1)
C            IF (IREJ1.NE.0) GOTO 9999
C            IF (IDR2.NE.0) IDR2 = 100*IDR2
C         ENDIF
C      ENDIF

      IF ((IRESCO.EQ.1).OR.(IFRAG(1).EQ.1)) THEN
c check chains for resonances
         CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDR1,IDXR1,
     &               AMCH1,AMCH1N,IDCH1,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
         CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDR2,IDXR2,
     &               AMCH2,AMCH2N,IDCH2,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
c change kinematics corresponding to resonance-masses
         IF ( (IDR1.NE.0).AND.(IDR2.EQ.0) ) THEN
            CALL DT_CHKINE(PP1,IFPR1,PP2,IFPR2,PT1,IFTA1,PT2,IFTA2,
     &                                 AMCH1,AMCH1N,AMCH2,IREJ1)
            IF (IREJ1.GT.0) GOTO 9999
            IF (IREJ1.EQ.-1) IDR1 = 100*IDR1
            CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDR2,IDXR2,
     &                  AMCH2,AMCH2N,IDCH2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            IF (IDR2.NE.0) IDR2 = 100*IDR2
         ELSEIF ( (IDR1.EQ.0).AND.(IDR2.NE.0) ) THEN
            CALL DT_CHKINE(PP2,IFPR2,PP1,IFPR1,PT2,IFTA2,PT1,IFTA1,
     &                                 AMCH2,AMCH2N,AMCH1,IREJ1)
            IF (IREJ1.GT.0) GOTO 9999
            IF (IREJ1.EQ.-1) IDR2 = 100*IDR2
            CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDR1,IDXR1,
     &                  AMCH1,AMCH1N,IDCH1,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            IF (IDR1.NE.0) IDR1 = 100*IDR1
         ELSEIF ( (IDR1.NE.0).AND.(IDR2.NE.0) ) THEN
            AMDIF1 = ABS(AMCH1-AMCH1N)
            AMDIF2 = ABS(AMCH2-AMCH2N)
            IF (AMDIF2.LT.AMDIF1) THEN
               CALL DT_CHKINE(PP2,IFPR2,PP1,IFPR1,PT2,IFTA2,PT1,IFTA1,
     &                                    AMCH2,AMCH2N,AMCH1,IREJ1)
               IF (IREJ1.GT.0) GOTO 9999
               IF (IREJ1.EQ.-1) IDR2 = 100*IDR2
               CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),
     &                     IDR1,IDXR1,AMCH1,AMCH1N,IDCH1,IREJ1)
               IF (IREJ1.NE.0) GOTO 9999
               IF (IDR1.NE.0) IDR1 = 100*IDR1
            ELSE
               CALL DT_CHKINE(PP1,IFPR1,PP2,IFPR2,PT1,IFTA1,PT2,IFTA2,
     &                                    AMCH1,AMCH1N,AMCH2,IREJ1)
               IF (IREJ1.GT.0) GOTO 9999
               IF (IREJ1.EQ.-1) IDR1 = 100*IDR1
               CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),
     &                     IDR2,IDXR2,AMCH2,AMCH2N,IDCH2,IREJ1)
               IF (IREJ1.NE.0) GOTO 9999
               IF (IDR2.NE.0) IDR2 = 100*IDR2
            ENDIF
         ENDIF
      ENDIF

c store final configuration for energy-momentum cons. check
      IF (LEMCCK) THEN
         CALL DT_EMC1(PP1,PP2,PT1,PT2,-2,1,IDUM)
         CALL DT_EMC1(PP1,PP2,PT1,PT2,3,1,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF

c put partons and chains into DTEVT1
      DO 10 I=1,4
         PCH1(I) = PP1(I)+PT1(I)
         PCH2(I) = PP2(I)+PT2(I)
   10 CONTINUE
      CALL DT_EVTPUT(-ISTHKK(MOP1),IFPR1,MOP1,0,PP1(1),PP1(2),
     &                                      PP1(3),PP1(4),0,0,0)
      CALL DT_EVTPUT(-ISTHKK(MOT1),IFTA1,MOT1,0,PT1(1),PT1(2),
     &                                      PT1(3),PT1(4),0,0,0)
      KCH = 100+IDCH(MOP1)*10+1
      CALL DT_EVTPUT(KCH,88888,-2,-1,
     &           PCH1(1),PCH1(2),PCH1(3),PCH1(4),IDR1,IDXR1,IDCH(MOP1))
      CALL DT_EVTPUT(-ISTHKK(MOP2),IFPR2,MOP2,0,PP2(1),PP2(2),
     &                                      PP2(3),PP2(4),0,0,0)
      CALL DT_EVTPUT(-ISTHKK(MOT2),IFTA2,MOT2,0,PT2(1),PT2(2),
     &                                      PT2(3),PT2(4),0,0,0)
      KCH = KCH+1
      CALL DT_EVTPUT(KCH,88888,-2,-1,
     &           PCH2(1),PCH2(2),PCH2(3),PCH2(4),IDR2,IDXR2,IDCH(MOP2))

      RETURN

 9999 CONTINUE
      IF ((IDCH(MOP1).LE.3).AND.(IDCH(MOP2).LE.3)) THEN
c "cancel" sea-sea chains
         CALL DT_RJSEAC(MOP1,MOP2,MOT1,MOT2,IREJ1)
         IF (IREJ1.NE.0) GOTO 9998
c*sr 16.5. flag for EVENTB
         IREJ = -1
         RETURN
      ENDIF
 9998 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===chkine=============================================================*
c
CDECK  ID>, DT_CHKINE
      SUBROUTINE DT_CHKINE(PP1I,IFP1,PP2I,IFP2,PT1I,IFT1,PT2I,IFT2,
     &                  AMCH1,AMCH1N,AMCH2,IREJ)

c***********************************************************************
c This subroutine replaces CORMOM.                                     *
c This version dated 05.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9,TINY10=1.0D-10)



c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),P1(4),P2(4),
     &          PP1I(4),PP2I(4),PT1I(4),PT2I(4)

      IREJ  = 0
      JMSHL = IMSHL

      SCALE  = AMCH1N/MAX(AMCH1,TINY10)
      DO 10 I=1,4
         PP1(I) = PP1I(I)
         PP2(I) = PP2I(I)
         PT1(I) = PT1I(I)
         PT2(I) = PT2I(I)
         PP2(I) = PP2(I)+(1.0D0-SCALE)*PP1(I)
         PT2(I) = PT2(I)+(1.0D0-SCALE)*PT1(I)
         PP1(I) = SCALE*PP1(I)
         PT1(I) = SCALE*PT1(I)
   10 CONTINUE
      IF ((PP1(4).LT.0.0D0).OR.(PP2(4).LT.0.0D0).OR.
     &    (PT1(4).LT.0.0D0).OR.(PT2(4).LT.0.0D0)) GOTO 9997

      ECH = PP2(4)+PT2(4)
      PCH = SQRT( (PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2+
     &                               (PP2(3)+PT2(3))**2 )
      AMCH22 = (ECH-PCH)*(ECH+PCH)
      IF (AMCH22.LT.0.0D0) THEN
         IF (IOULEV(1).GT.0)
     &      WRITE(ErrorOut,
     * '(1X,A)') 'CHKINE: inconsistent treatment!'
         GOTO 9997
      ENDIF

      AMCH1 = AMCH1N
      AMCH2 = SQRT(AMCH22)

c put partons again on mass shell
   13 CONTINUE
      XM1 = 0.0D0
      XM2 = 0.0D0
      IF (JMSHL.EQ.1) THEN

         XM1 = PYMASS(IFP1)
         XM2 = PYMASS(IFT1)

      ENDIF
      CALL DT_MASHEL(PP1,PT1,XM1,XM2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) THEN
         IF (JMSHL.EQ.0) GOTO 9998
         JMSHL = 0
         GOTO 13
      ENDIF
      JMSHL = IMSHL
      DO 11 I=1,4
         PP1(I) = P1(I)
         PT1(I) = P2(I)
   11 CONTINUE
   14 CONTINUE
      XM1 = 0.0D0
      XM2 = 0.0D0
      IF (JMSHL.EQ.1) THEN

         XM1 = PYMASS(IFP2)
         XM2 = PYMASS(IFT2)

      ENDIF
      CALL DT_MASHEL(PP2,PT2,XM1,XM2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) THEN
         IF (JMSHL.EQ.0) GOTO 9998
         JMSHL = 0
         GOTO 14
      ENDIF
      DO 12 I=1,4
         PP2(I) = P1(I)
         PT2(I) = P2(I)
   12 CONTINUE
      DO 15 I=1,4
         PP1I(I) = PP1(I)
         PP2I(I) = PP2(I)
         PT1I(I) = PT1(I)
         PT2I(I) = PT2(I)
   15 CONTINUE
      RETURN

 9997 IRCHKI(1) = IRCHKI(1)+1
c*sr
C     GOTO 9999
      IREJ = -1
      RETURN
c*
 9998 IRCHKI(2) = IRCHKI(2)+1

 9999 CONTINUE
      IF (IOULEV(1).GT.0) WRITE(ErrorOut,
     * *) 'rejected 1 in CHKINE'
      IREJ = 1
      RETURN
      END
c
c===ch2res=============================================================*
c
CDECK  ID>, DT_CH2RES
      SUBROUTINE DT_CH2RES(IF1,IF2,IF3,IF4,IDR,IDXR,
     &                  AM,AMN,IMODE,IREJ)

c***********************************************************************
c Check chains for resonance production.                               *
c This subroutine replaces COMCMA/COBCMA/COMCM2                        *
c    input:                                                            *
c          IF1,2,3,4    input flavors (q,aq in any order)              *
c          AM           chain mass                                     *
c          MODE = 1     check q-aq chain for meson-resonance           *
c               = 2     check q-qq, aq-aqaq chain for baryon-resonance *
c               = 3     check qq-aqaq chain for lower mass cut         *
c    output:                                                           *
c          IDR = 0      no resonances found                            *
c              = -1     pseudoscalar meson/octet baryon                *
c              = 1      vector-meson/decuplet baryon                   *
c          IDXR         BAMJET-index of corresponding resonance        *
c          AMN          mass of corresponding resonance                *
c                                                                      *
c          IREJ         rejection flag                                 *
c This version dated 06.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c quark-content to particle index conversion (DTUNUC 1.x)
      COMMON /DTQ2ID/ IMPS(6,6),IMVE(6,6),IB08(6,21),IB10(6,21),
     &                IA08(6,21),IA10(6,21)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      DIMENSION IF(4),JF(4)

c*sr 4.7. test
C     DATA AMLOM,AMLOB /0.08D0,0.2D0/
      DATA AMLOM,AMLOB /0.1D0,0.7D0/
c*
C     DATA AMLOM,AMLOB /0.001D0,0.001D0/

      MODE = ABS(IMODE)

      IF ((MODE.LT.1).OR.(MODE.GT.3)) THEN
         WRITE(ErrorOut,1000) MODE
 1000    FORMAT(1X,'CH2RES: MODE ',I4,' NOT SUPPORTED!',/,
     &          1X,'        PROGRAM STOPPED')
         STOP
      ENDIF

      AMX  = AM
      IREJ = 0
      IDR  = 0
      IDXR = 0
      AMN  = AMX
      IF ((AM.LE.0.0D0).AND.(MODE.EQ.1)) AMX = AMLOM
      IF ((AM.LE.0.0D0).AND.(MODE.EQ.2)) AMX = AMLOB

      IF(1) = IF1
      IF(2) = IF2
      IF(3) = IF3
      IF(4) = IF4
      NF = 0
      DO 100 I=1,4
         IF (IF(I).NE.0) THEN
            NF = NF+1
            JF(NF) = IF(I)
         ENDIF
  100 CONTINUE
      IF (NF.LE.MODE) THEN
         WRITE(ErrorOut,1001) MODE,IF
 1001    FORMAT(1X,'CH2RES: INCONSISTENT INPUT FLAVORS IN MODE ',
     &   I4,' IF1 = ',I4,' IF2 = ',I4,' IF3 = ',I4,' IF4 = ',I4)
         GOTO 9999
      ENDIF

      GOTO (1,2,3) MODE

c check for meson resonance
    1 CONTINUE
      IFQ  = JF(1)
      IFAQ = ABS(JF(2))
      IF (JF(2).GT.0) THEN
         IFQ  = JF(2)
         IFAQ = ABS(JF(1))
      ENDIF
      IFPS = IMPS(IFAQ,IFQ)
      IFV  = IMVE(IFAQ,IFQ)
      AMPS = AAM(IFPS)
      AMV  = AAM(IFV)
      AMHI = AMV+0.3D0
      IF (AMX.LT.AMV) THEN
         IF (AMX.LT.AMPS) THEN
            IF (IMODE.GT.0) THEN
               IF ((IRESRJ.EQ.1).OR.(AMX.LT.AMLOM)) GOTO 9999
            ELSE
               IF (AMX.LT.0.8D0*AMPS) GOTO 9999
            ENDIF
            LOMRES = LOMRES+1
         ENDIF
c    replace chain by pseudoscalar meson
         IDR  = -1
         IDXR = IFPS
         AMN  = AMPS
      ELSEIF (AMX.LT.AMHI) THEN
c    replace chain by vector-meson
         IDR  = 1
         IDXR = IFV
         AMN  = AMV
      ENDIF
      RETURN

c check for baryon resonance
    2 CONTINUE
      CALL DT_DBKLAS(JF(1),JF(2),JF(3),JB8,JB10)
      AM8  = AAM(JB8)
      AM10 = AAM(JB10)
      AMHI = AM10+0.3D0
      IF (AMX.LT.AM10) THEN
         IF (AMX.LT.AM8) THEN
            IF (IMODE.GT.0) THEN
               IF ((IRESRJ.EQ.1).OR.(AMX.LT.AMLOB)) GOTO 9999
            ELSE
               IF (AMX.LT.0.8D0*AM8) GOTO 9999
            ENDIF
            LOBRES = LOBRES+1
         ENDIF
c    replace chain by oktet baryon
         IDR  = -1
         IDXR = JB8
         AMN  = AM8
      ELSEIF (AMX.LT.AMHI) THEN
         IDR  = 1
         IDXR = JB10
         AMN  = AM10
      ENDIF
      RETURN

c check qq-aqaq for lower mass cut
    3 CONTINUE
c   empirical definition of AMHI to allow for (b-antib)-pair prod.
      AMHI = 2.5D0
      IF (AMX.LT.AMHI) GOTO 9999
      RETURN

 9999 CONTINUE
      IF ((IOULEV(1).GT.0).AND.(IMODE.GT.0))
     &    WRITE(ErrorOut,*) 'rejected 1 in CH2RES',IMODE
      IREJ = 1
      IRRES(2) = IRRES(2)+1
      RETURN
      END
c
c===rjseac=============================================================*
c
CDECK  ID>, DT_RJSEAC
      SUBROUTINE DT_RJSEAC(MOP1,MOP2,MOT1,MOT2,IREJ)

c***********************************************************************
c ReJection of SEA-sea Chains.                                         *
c         MOP1/2       entries of projectile sea-partons in DTEVT1     *
c         MOT1/2       entries of projectile sea-partons in DTEVT1     *
c This version dated 16.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)


      DIMENSION IDXSEA(2,2),IDXNUC(2),ISTVAL(2)

      IREJ = 0

c projectile sea q-aq-pair
c    indices of sea-pair
      IDXSEA(1,1) = MOP1
      IDXSEA(1,2) = MOP2
c    index of mother-nucleon
      IDXNUC(1)   = JMOHKK(1,MOP1)
c    status of valence quarks to be corrected
      ISTVAL(1)   = -21

c target sea q-aq-pair
c    indices of sea-pair
      IDXSEA(2,1) = MOT1
      IDXSEA(2,2) = MOT2
c    index of mother-nucleon
      IDXNUC(2)   = JMOHKK(1,MOT1)
c    status of valence quarks to be corrected
      ISTVAL(2)   = -22

      DO 1 N=1,2
         IDONE = 0
         DO 2 I=NPOINT(2),NHKK
            IF ((ISTHKK(I).EQ.ISTVAL(N)).AND.
     &          (JMOHKK(1,I).EQ.IDXNUC(N)))   THEN
c valence parton found
c    inrease 4-momentum by sea 4-momentum
               DO 3 K=1,4
                  PHKK(K,I) = PHKK(K,I)+PHKK(K,IDXSEA(N,1))+
     &                                  PHKK(K,IDXSEA(N,2))
    3          CONTINUE
               PHKK(5,I) = SQRT(ABS(PHKK(4,I)**2-PHKK(1,I)**2-
     &                              PHKK(2,I)**2-PHKK(3,I)**2))
c    "cancel" sea-pair
               DO 4 J=1,2
                  ISTHKK(IDXSEA(N,J))   = 100
                  IDHKK(IDXSEA(N,J))    = 0
                  JMOHKK(1,IDXSEA(N,J)) = 0
                  JMOHKK(2,IDXSEA(N,J)) = 0
                  JDAHKK(1,IDXSEA(N,J)) = 0
                  JDAHKK(2,IDXSEA(N,J)) = 0
                  DO 5 K=1,4
                     PHKK(K,IDXSEA(N,J)) = ZERO
                     VHKK(K,IDXSEA(N,J)) = ZERO
                     WHKK(K,IDXSEA(N,J)) = ZERO
    5             CONTINUE
                  PHKK(5,IDXSEA(N,J)) = ZERO
    4          CONTINUE
               IDONE = 1
            ENDIF
    2    CONTINUE
         IF (IDONE.NE.1) THEN
            WRITE(ErrorOut,1000) NEVHKK,MOP1,MOP2,MOT1,MOT2
 1000       FORMAT(1X,'RJSEAC: EVENT ',I8,': INCONSISTENT EVENT',
     &                '-RECORD!',/,1X,'        SEA-QUARK PAIRS   ',
     &                2I5,4X,2I5,'   COULD NOT BE CANCELED!')
            GOTO 9999
         ENDIF
    1 CONTINUE
      ICRJSS = ICRJSS+1
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===vv2sch=============================================================*
c
CDECK  ID>, DT_VV2SCH
      SUBROUTINE DT_VV2SCH

c***********************************************************************
c Change Valence-Valence chain systems to Single CHain systems for     *
c hadron-nucleus collisions with meson or antibaryon projectile.       *
c (Reggeon contribution)                                               *
c The single chain system is approximately treated as one chain and a  *
c meson at rest.                                                       *
c This version dated 18.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY7=1.0D-7,TINY3=1.0D-3)

      LOGICAL LSTART

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)


      DIMENSION IF(4,2),MO(4),PP1(4),PP2(4),PT1(4),PT2(4),PCH1(4),
     &          PCH2(4)

      DATA LSTART /.TRUE./

      IFSC  = 0
      IF (LSTART) THEN
         WRITE(ErrorOut,1000)
 1000    FORMAT(/,1X,'VV2SCH:  REGGEON CONTRIBUTION TO VALANCE-',
     &          'VALENCE CHAINS TREATED')
         LSTART = .FALSE.
      ENDIF

      NSTOP = NHKK

c get index of first chain
      DO 1 I=NPOINT(3),NHKK
         IF (IDHKK(I).EQ.88888) THEN
            NC = I
            GOTO 2
         ENDIF
    1 CONTINUE

    2 CONTINUE
      IF ((IDHKK(NC).EQ.88888).AND.(IDHKK(NC+3).EQ.88888)
     &                        .AND.(NC.LT.NSTOP)) THEN
c get valence-valence chains
         IF ((IDCH(NC).EQ.8).AND.(IDCH(NC+3).EQ.8)) THEN
c   get "mother"-hadron indices
            MO1   = JMOHKK(1,JMOHKK(1,JMOHKK(1,NC)))
            MO2   = JMOHKK(1,JMOHKK(1,JMOHKK(2,NC)))
            KPROJ = IDT_ICIHAD(IDHKK(MO1))
            KTARG = IDT_ICIHAD(IDHKK(MO2))
c   Lab momentum of projectile hadron
            CALL DT_LTNUC(PHKK(3,MO1),PHKK(4,MO1),PPZ,PPE,-3)
            PTOT  = SQRT(PHKK(1,MO1)**2+PHKK(2,MO1)**2+
     &                                  PHKK(3,MO1)**2)

            SICHAP = DT_PHNSCH(KPROJ,KTARG,PTOT)
            IF (DT_RNDM(PTOT).LE.SICHAP) THEN
               ICVV2S = ICVV2S+1
c   single chain requested
c      get flavors of chain-end partons
               MO(1) = JMOHKK(1,NC)
               MO(2) = JMOHKK(2,NC)
               MO(3) = JMOHKK(1,NC+3)
               MO(4) = JMOHKK(2,NC+3)
               DO 3 I=1,4
                  IF(I,1) = IDT_IPDG2B(IDHKK(MO(I)),1,2)
                  IF(I,2) = 0
                  IF (ABS(IDHKK(MO(I))).GE.1000)
     &               IF(I,2) = IDT_IPDG2B(IDHKK(MO(I)),2,2)
    3          CONTINUE
c      which one is the q-aq chain?
c        N1,N1+1 - DTEVT1-entries for q-aq system
c        N2,N2+1 - DTEVT1-entries for the other chain
               IF ((IF(1,2).EQ.0).AND.(IF(2,2).EQ.0)) THEN
                  K1 = 1
                  K2 = 3
                  N1 = NC-2
                  N2 = NC+1
               ELSEIF ((IF(3,2).EQ.0).AND.(IF(4,2).EQ.0)) THEN
                  K1 = 3
                  K2 = 1
                  N1 = NC+1
                  N2 = NC-2
               ELSE
                  GOTO 10
               ENDIF
               DO 4 K=1,4
                  PP1(K) = PHKK(K,N1)
                  PT1(K) = PHKK(K,N1+1)
                  PP2(K) = PHKK(K,N2)
                  PT2(K) = PHKK(K,N2+1)
    4          CONTINUE
               AMCH1 = PHKK(5,N1+2)
               AMCH2 = PHKK(5,N2+2)
c      get meson-identity corresponding to flavors of q-aq chain
               ITMP   = IRESRJ
               IRESRJ = 0
               CALL DT_CH2RES(IF(K1,1),IF(K1+1,1),0,0,IDR1,IDXR1,
     &                     ZERO,AMCH1N,1,IDUM)
               IRESRJ = ITMP
c      change kinematics of chains
               CALL DT_CHKINE(PP1,IDHKK(N1),  PP2,IDHKK(N2),
     &                     PT1,IDHKK(N1+1),PT2,IDHKK(N2+1),
     &                     AMCH1,AMCH1N,AMCH2,IREJ1)
               IF (IREJ1.NE.0) GOTO 10
c      check second chain for resonance
               IDCHAI = 2
               IF ((IF(K2,2).NE.0).AND.(IF(K2+1,2).NE.0)) IDCHAI = 3
               CALL DT_CH2RES(IF(K2,1),IF(K2,2),IF(K2+1,1),IF(K2+1,2),
     &                     IDR2,IDXR2,AMCH2,AMCH2N,IDCHAI,IREJ1)
               IF (IREJ1.NE.0) GOTO 10
               IF (IDR2.NE.0) IDR2 = 100*IDR2
c      add partons and chains to DTEVT1
               DO 5 K=1,4
                  PCH1(K) = PP1(K)+PT1(K)
                  PCH2(K) = PP2(K)+PT2(K)
    5          CONTINUE
               CALL DT_EVTPUT(ISTHKK(N1),IDHKK(N1),N1,0,PP1(1),PP1(2),
     &                                             PP1(3),PP1(4),0,0,0)
               CALL DT_EVTPUT(ISTHKK(N1+1),IDHKK(N1+1),N1+1,0,PT1(1),
     &                                      PT1(2),PT1(3),PT1(4),0,0,0)
               KCH = ISTHKK(N1+2)+100
               CALL DT_EVTPUT(KCH,88888,-2,-1,PCH1(1),PCH1(2),PCH1(3),
     &                     PCH1(4),IDR1,IDXR1,IDCH(N1+2))
               IDHKK(N1+2) = 22222
               CALL DT_EVTPUT(ISTHKK(N2),IDHKK(N2),N2,0,PP2(1),PP2(2),
     &                                             PP2(3),PP2(4),0,0,0)
               CALL DT_EVTPUT(ISTHKK(N2+1),IDHKK(N2+1),N2+1,0,PT2(1),
     &                                      PT2(2),PT2(3),PT2(4),0,0,0)
               KCH = ISTHKK(N2+2)+100
               CALL DT_EVTPUT(KCH,88888,-2,-1,PCH2(1),PCH2(2),PCH2(3),
     &                     PCH2(4),IDR2,IDXR2,IDCH(N2+2))
               IDHKK(N2+2) = 22222
            ENDIF
         ENDIF
      ELSE
         GOTO 11
      ENDIF
   10 CONTINUE
      NC = NC+6
      GOTO 2

   11 CONTINUE

      RETURN
      END
c
c=== phnsch ===========================================================*
c
CDECK  ID>, DT_PHNSCH
      DOUBLE PRECISION FUNCTION DT_PHNSCH( KP, KTARG, PLAB )

c----------------------------------------------------------------------*
c                                                                      *
c     Probability for Hadron Nucleon Single CHain interactions:        *
c                                                                      *
c     Created on 30 december 1993  by    Alfredo Ferrari & Paola Sala  *
c                                                   Infn - Milan       *
c                                                                      *
c     Last change on 04-jan-94     by    Alfredo Ferrari               *
c                                                                      *
c             modified by J.R.for use in DTUNUC  6.1.94                *
c                                                                      *
c     Input variables:                                                 *
c                      Kp = hadron projectile index (Part numbering    *
c                           scheme)                                    *
c                   Ktarg = target nucleon index (1=proton, 8=neutron) *
c                    Plab = projectile laboratory momentum (GeV/c)     *
c     Output variable:                                                 *
c                  Phnsch = probability per single chain (particle     *
c                           exchange) interactions                     *
c                                                                      *
c----------------------------------------------------------------------*

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE

      PARAMETER ( LUNOUT = 6  )
      PARAMETER ( LUNERR = 6  )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( ZERZER = 0.D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( FIVFIV = 5.D+00 )
      PARAMETER ( HLFHLF = 0.5D+00 )

      PARAMETER ( NALLWP = 39   )
      PARAMETER ( IDMAXP = 210  )

      DIMENSION ICHRGE(39),AM(39)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      DIMENSION KPTOIP(210)
c auxiliary common for reggeon exchange (DTUNUC 1.x)
      COMMON /DTQUAR/ IQECHR(-6:6),IQBCHR(-6:6),IQICHR(-6:6),
     &                IQSCHR(-6:6),IQCCHR(-6:6),IQUCHR(-6:6),
     &                IQTCHR(-6:6),MQUARK(3,39)


      DIMENSION SGTCOE (5,33), IHLP (NALLWP)
      DIMENSION SGTCO1(5,10),SGTCO2(5,8),SGTCO3(5,15)
c//////// KK
c      SAVE SGTCOE, IHLP
c      SAVE IQFSC1, IQFSC2, IQBSC1, IQBSC2
c//////////
      EQUIVALENCE (SGTCO1(1,1),SGTCOE(1,1))
      EQUIVALENCE (SGTCO2(1,1),SGTCOE(1,11))
      EQUIVALENCE (SGTCO3(1,1),SGTCOE(1,19))

c Conversion from part to paprop numbering
      DATA KPTOIP / 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
     & 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 66*0,
     & 34, 36, 31, 32, 33, 35, 37, 5*0, 38, 5*0, 39, 19*0, 27, 28, 74*0/

c  1=baryon, 2=pion, 3=kaon, 4=antibaryon:
      DATA IHLP/1,4,5*0,1,4,2*0,3,2*2,2*3,1,4,3,3*1,2,
     &    2*3, 2, 4*0, 3*4, 1, 4, 1, 4, 1, 4 /
C     DATA ( ( SGTCOE (J,I), J=1,5 ), I=1,10 ) /
      DATA  SGTCO1  /
c 1st reaction: gamma p total
     &0.147 D+00, ZERZER  , ZERZER   , 0.0022D+00, -0.0170D+00,
c 2nd reaction: gamma d total
     &0.300 D+00, ZERZER  , ZERZER   , 0.0095D+00, -0.057 D+00,
c 3rd reaction: pi+ p total
     &16.4  D+00, 19.3D+00, -0.42D+00, 0.19  D+00, ZERZER     ,
c 4th reaction: pi- p total
     &33.0  D+00, 14.0D+00, -1.36D+00, 0.456 D+00, -4.03  D+00,
c 5th reaction: pi+/- d total
     &56.8  D+00, 42.2D+00, -1.45D+00, 0.65  D+00, -5.39  D+00,
c 6th reaction: K+ p total
     &18.1  D+00, ZERZER  , ZERZER   , 0.26  D+00, -1.0   D+00,
c 7th reaction: K+ n total
     &18.7  D+00, ZERZER  , ZERZER   , 0.21  D+00, -0.89  D+00,
c 8th reaction: K+ d total
     &34.2  D+00, 7.9 D+00, -2.1 D+00, 0.346 D+00, -0.99  D+00,
c 9th reaction: K- p total
     &32.1  D+00, ZERZER  , ZERZER   , 0.66  D+00, -5.6   D+00,
c 10th reaction: K- n total
     &25.2  D+00, ZERZER  , ZERZER   , 0.38  D+00, -2.9   D+00/
C     DATA ( ( SGTCOE (J,I), J=1,5 ), I=11,18 ) /
      DATA  SGTCO2  /
c 11th reaction: K- d total
     &57.6  D+00, ZERZER  , ZERZER   , 1.17  D+00, -9.5   D+00,
c 12th reaction: p p total
     &48.0  D+00, ZERZER  , ZERZER   , 0.522 D+00, -4.51  D+00,
c 13th reaction: p n total
     &47.30 D+00, ZERZER  , ZERZER   , 0.513 D+00, -4.27  D+00,
c 14th reaction: p d total
     &91.3  D+00, ZERZER  , ZERZER   , 1.05  D+00, -8.8   D+00,
c 15th reaction: pbar p total
     &38.4  D+00, 77.6D+00, -0.64D+00, 0.26  D+00, -1.2   D+00,
c 16th reaction: pbar n total
     &ZERZER    ,133.6D+00, -0.70D+00, -1.22 D+00, 13.7   D+00,
c 17th reaction: pbar d total
     &112.  D+00, 125.D+00, -1.08D+00, 1.14  D+00, -12.4  D+00,
c 18th reaction: Lamda p total
     &30.4  D+00, ZERZER  , ZERZER   , ZERZER    , 1.6    D+00/
C     DATA ( ( SGTCOE (J,I), J=1,5 ), I=19,33 ) /
      DATA SGTCO3  /
c 19th reaction: pi+ p elastic
     &ZERZER    , 11.4D+00, -0.4 D+00, 0.079 D+00, ZERZER     ,
c 20th reaction: pi- p elastic
     &1.76  D+00, 11.2D+00, -0.64D+00, 0.043 D+00, ZERZER     ,
c 21st reaction: K+ p elastic
     &5.0   D+00, 8.1 D+00, -1.8 D+00, 0.16  D+00, -1.3   D+00,
c 22nd reaction: K- p elastic
     &7.3   D+00, ZERZER  , ZERZER   , 0.29  D+00, -2.40  D+00,
c 23rd reaction: p p elastic
     &11.9  D+00, 26.9D+00, -1.21D+00, 0.169 D+00, -1.85  D+00,
c 24th reaction: p d elastic
     &16.1  D+00, ZERZER  , ZERZER   , 0.32  D+00, -3.4   D+00,
c 25th reaction: pbar p elastic
     &10.2  D+00, 52.7D+00, -1.16D+00, 0.125 D+00, -1.28  D+00,
c 26th reaction: pbar p elastic bis
     &10.6  D+00, 53.1D+00, -1.19D+00, 0.136 D+00, -1.41  D+00,
c 27th reaction: pbar n elastic
     &36.5  D+00, ZERZER  , ZERZER   , ZERZER    , -11.9  D+00,
c 28th reaction: Lamda p elastic
     &12.3  D+00, ZERZER  , ZERZER   , ZERZER    , -2.4   D+00,
c 29th reaction: K- p ela bis
     &7.24  D+00, 46.0D+00, -4.71D+00, 0.279 D+00, -2.35  D+00,
c 30th reaction: pi- p cx
     &ZERZER    ,0.912D+00, -1.22D+00, ZERZER    , ZERZER     ,
c 31st reaction: K- p cx
     &ZERZER    , 3.39D+00, -1.75D+00, ZERZER    , ZERZER     ,
c 32nd reaction: K+ n cx
     &ZERZER    , 7.18D+00, -2.01D+00, ZERZER    , ZERZER     ,
c 33rd reaction: pbar p cx
     &ZERZER    , 18.8D+00, -2.01D+00, ZERZER    , ZERZER     /
c
c  +-------------------------------------------------------------------*
         ICHRGE(KTARG)=IICH(KTARG)
         AM    (KTARG)=AAM (KTARG)
c  |  Check for pi0 (d-dbar)
      IF ( KP .NE. 26 ) THEN
         IP  = KPTOIP (KP)
         IF(IP.EQ.0)IP=1
         ICHRGE(IP)=IICH(KP)
         AM    (IP)=AAM (KP)
c  |
c  +-------------------------------------------------------------------*
c  |
      ELSE
         IP = 23
         ICHRGE(IP)=0
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  No such interactions for baryon-baryon
      IF ( IIBAR (KP) .GT. 0 ) THEN
         DT_PHNSCH = ZERZER
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  No "annihilation" diagram possible for K+ p/n
      ELSE IF ( IP .EQ. 15 ) THEN
         DT_PHNSCH = ZERZER
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  No "annihilation" diagram possible for K0 p/n
      ELSE IF ( IP .EQ. 24 ) THEN
         DT_PHNSCH = ZERZER
         RETURN
c  |
c  +-------------------------------------------------------------------*
c  |  No "annihilation" diagram possible for Omebar p/n
      ELSE IF ( IP .GE. 38 ) THEN
         DT_PHNSCH = ZERZER
         RETURN
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  If the momentum is larger than 50 GeV/c, compute the single
c  |  chain probability at 50 GeV/c and extrapolate to the present
c  |  momentum according to 1/sqrt(s)
c  |  sigma = sigma_sch (50) * sqrt (s(50)/s) + sigma_dch
c  |  P_sch (50) = sigma_sch (50) / ( sigma_dch + sigma_sch (50) )
c  |  sigma_dch / sigma_sch (50) = 1 / P_sch (50) - 1
c  |  sigma_dch / sigma_sch = 1 / P_sch - 1 = ( 1 / P_sch (50) - 1 )
c  |                        x sqrt(s/s(50))
c  |  P_sch = 1 / [ ( 1 / P_sch (50) - 1 ) x sqrt(s/s(50)) + 1 ]
      IF ( PLAB .GT. 50.D+00 ) THEN
         PLA    = 50.D+00
         AMPSQ  = AM (IP)**2
         AMTSQ  = AM (KTARG)**2
         EPROJ  = SQRT ( PLAB**2 + AMPSQ )
         UMOSQ  = AMPSQ + AMTSQ + TWOTWO * AM (KTARG) * EPROJ
         EPROJ  = SQRT ( PLA**2 + AMPSQ )
         UMO50  = AMPSQ + AMTSQ + TWOTWO * AM (KTARG) * EPROJ
         UMORAT = SQRT ( UMOSQ / UMO50 )
c  |
c  +-------------------------------------------------------------------*
c  |  P < 3 GeV/c
      ELSE IF ( PLAB .LT. 3.D+00 ) THEN
         PLA    = 3.D+00
         AMPSQ  = AM (IP)**2
         AMTSQ  = AM (KTARG)**2
         EPROJ  = SQRT ( PLAB**2 + AMPSQ )
         UMOSQ  = AMPSQ + AMTSQ + TWOTWO * AM (KTARG) * EPROJ
         EPROJ  = SQRT ( PLA**2 + AMPSQ )
         UMO50  = AMPSQ + AMTSQ + TWOTWO * AM (KTARG) * EPROJ
         UMORAT = SQRT ( UMOSQ / UMO50 )
c  |
c  +-------------------------------------------------------------------*
c  |  P < 50 GeV/c
      ELSE
         PLA    = PLAB
         UMORAT = ONEONE
      END IF
c  |
c  +-------------------------------------------------------------------*
      ALGPLA = LOG (PLA)
c  +-------------------------------------------------------------------*
c  |  Pions:
      IF ( IHLP (IP) .EQ. 2 ) THEN
         ACOF = SGTCOE (1,3)
         BCOF = SGTCOE (2,3)
         ENNE = SGTCOE (3,3)
         CCOF = SGTCOE (4,3)
         DCOF = SGTCOE (5,3)
c  |  Compute the pi+ p total cross section:
         SPPPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,19)
         BCOF = SGTCOE (2,19)
         ENNE = SGTCOE (3,19)
         CCOF = SGTCOE (4,19)
         DCOF = SGTCOE (5,19)
c  |  Compute the pi+ p elastic cross section:
         SPPPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the pi+ p inelastic cross section:
         SPPPIN = SPPPTT - SPPPEL
         ACOF = SGTCOE (1,4)
         BCOF = SGTCOE (2,4)
         ENNE = SGTCOE (3,4)
         CCOF = SGTCOE (4,4)
         DCOF = SGTCOE (5,4)
c  |  Compute the pi- p total cross section:
         SPMPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,20)
         BCOF = SGTCOE (2,20)
         ENNE = SGTCOE (3,20)
         CCOF = SGTCOE (4,20)
         DCOF = SGTCOE (5,20)
c  |  Compute the pi- p elastic cross section:
         SPMPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the pi- p inelastic cross section:
         SPMPIN = SPMPTT - SPMPEL
         SIGDIA = SPMPIN - SPPPIN
c  |  +----------------------------------------------------------------*
c  |  |  Charged pions: besides isospin consideration it is supposed
c  |  |                 that (pi+ n)el is almost equal to (pi- p)el
c  |  |                 and  (pi+ p)el "    "     "    "  (pi- n)el
c  |  |                 and all are almost equal among each others
c  |  |                 (reasonable above 5 GeV/c)
         IF ( ICHRGE (IP) .NE. 0 ) THEN
            KHELP = KTARG / 8
            JREAC = 3 + IP - 13 + ICHRGE (IP) * KHELP
            ACOF = SGTCOE (1,JREAC)
            BCOF = SGTCOE (2,JREAC)
            ENNE = SGTCOE (3,JREAC)
            CCOF = SGTCOE (4,JREAC)
            DCOF = SGTCOE (5,JREAC)
c  |  |  Compute the total cross section:
            SHNCTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &             + DCOF * ALGPLA
            JREAC = 19 + IP - 13 + ICHRGE (IP) * KHELP
            ACOF = SGTCOE (1,JREAC)
            BCOF = SGTCOE (2,JREAC)
            ENNE = SGTCOE (3,JREAC)
            CCOF = SGTCOE (4,JREAC)
            DCOF = SGTCOE (5,JREAC)
c  |  |  Compute the elastic cross section:
            SHNCEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &             + DCOF * ALGPLA
c  |  |  Compute the inelastic cross section:
            SHNCIN = SHNCTT - SHNCEL
c  |  |  Number of diagrams:
            NDIAGR = 1 + IP - 13 + ICHRGE (IP) * KHELP
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
            IQFSC1 = 1 + IP - 13
            IQFSC2 = 0
            IQBSC1 = 1 + KHELP
            IQBSC2 = 1 + IP - 13
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  pi0: besides isospin consideration it is supposed that the
c  |  |       elastic cross section is not very different from
c  |  |       pi+ p and/or pi- p (reasonable above 5 GeV/c)
         ELSE
            KHELP  = KTARG / 8
            K2HLP  = ( KP - 23 ) / 3
c  |  |  Number of diagrams:
c  |  |  For u ubar (k2hlp=0):
c           NDIAGR = 2 - KHELP
c  |  |  For d dbar (k2hlp=1):
c           NDIAGR = 2 + KHELP - K2HLP
            NDIAGR = 2 + KHELP * ( 2 * K2HLP - 1 ) - K2HLP
            SHNCIN = HLFHLF * ( SPPPIN + SPMPIN )
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
            IQFSC1 = 1 + K2HLP
            IQFSC2 = 0
            IQBSC1 = 1 + KHELP
            IQBSC2 = 2 - K2HLP
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |                                                   end pi's
c  +-------------------------------------------------------------------*
c  |  Kaons:
      ELSE IF ( IHLP (IP) .EQ. 3 ) THEN
         ACOF = SGTCOE (1,6)
         BCOF = SGTCOE (2,6)
         ENNE = SGTCOE (3,6)
         CCOF = SGTCOE (4,6)
         DCOF = SGTCOE (5,6)
c  |  Compute the K+ p total cross section:
         SKPPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,21)
         BCOF = SGTCOE (2,21)
         ENNE = SGTCOE (3,21)
         CCOF = SGTCOE (4,21)
         DCOF = SGTCOE (5,21)
c  |  Compute the K+ p elastic cross section:
         SKPPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the K+ p inelastic cross section:
         SKPPIN = SKPPTT - SKPPEL
         ACOF = SGTCOE (1,9)
         BCOF = SGTCOE (2,9)
         ENNE = SGTCOE (3,9)
         CCOF = SGTCOE (4,9)
         DCOF = SGTCOE (5,9)
c  |  Compute the K- p total cross section:
         SKMPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,22)
         BCOF = SGTCOE (2,22)
         ENNE = SGTCOE (3,22)
         CCOF = SGTCOE (4,22)
         DCOF = SGTCOE (5,22)
c  |  Compute the K- p elastic cross section:
         SKMPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the K- p inelastic cross section:
         SKMPIN = SKMPTT - SKMPEL
         SIGDIA = HLFHLF * ( SKMPIN - SKPPIN )
c  |  +----------------------------------------------------------------*
c  |  |  Charged Kaons: actually only K-
         IF ( ICHRGE (IP) .NE. 0 ) THEN
            KHELP = KTARG / 8
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Proton target:
            IF ( KHELP .EQ. 0 ) THEN
               SHNCIN = SKMPIN
c  |  |  |  Number of diagrams:
               NDIAGR = 2
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Neutron target: besides isospin consideration it is supposed
c  |  |  |              that (K- n)el is almost equal to (K- p)el
c  |  |  |              (reasonable above 5 GeV/c)
            ELSE
               ACOF = SGTCOE (1,10)
               BCOF = SGTCOE (2,10)
               ENNE = SGTCOE (3,10)
               CCOF = SGTCOE (4,10)
               DCOF = SGTCOE (5,10)
c  |  |  |  Compute the total cross section:
               SHNCTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &                + DCOF * ALGPLA
c  |  |  |  Compute the elastic cross section:
               SHNCEL = SKMPEL
c  |  |  |  Compute the inelastic cross section:
               SHNCIN = SHNCTT - SHNCEL
c  |  |  |  Number of diagrams:
               NDIAGR = 1
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
            IQFSC1 = 3
            IQFSC2 = 0
            IQBSC1 = 1 + KHELP
            IQBSC2 = 2
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  K0's: (actually only K0bar)
         ELSE
            KHELP  = KTARG / 8
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Proton target: (K0bar p)in supposed to be given by
c  |  |  |                 (K- p)in - Sig_diagr
            IF ( KHELP .EQ. 0 ) THEN
               SHNCIN = SKMPIN - SIGDIA
c  |  |  |  Number of diagrams:
               NDIAGR = 1
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Neutron target: (K0bar n)in supposed to be given by
c  |  |  |                 (K- n)in + Sig_diagr
c  |  |  |              besides isospin consideration it is supposed
c  |  |  |              that (K- n)el is almost equal to (K- p)el
c  |  |  |              (reasonable above 5 GeV/c)
            ELSE
               ACOF = SGTCOE (1,10)
               BCOF = SGTCOE (2,10)
               ENNE = SGTCOE (3,10)
               CCOF = SGTCOE (4,10)
               DCOF = SGTCOE (5,10)
c  |  |  |  Compute the total cross section:
               SHNCTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &                + DCOF * ALGPLA
c  |  |  |  Compute the elastic cross section:
               SHNCEL = SKMPEL
c  |  |  |  Compute the inelastic cross section:
               SHNCIN = SHNCTT - SHNCEL + SIGDIA
c  |  |  |  Number of diagrams:
               NDIAGR = 2
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
            IQFSC1 = 3
            IQFSC2 = 0
            IQBSC1 = 1
            IQBSC2 = 1 + KHELP
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |                                                   end Kaon's
c  +-------------------------------------------------------------------*
c  |  Antinucleons:
      ELSE IF ( IHLP (IP) .EQ. 4 .AND. IP .LE. 9 ) THEN
c  |  For momenta between 3 and 5 GeV/c the use of tabulated data
c  |  should be implemented!
         ACOF = SGTCOE (1,15)
         BCOF = SGTCOE (2,15)
         ENNE = SGTCOE (3,15)
         CCOF = SGTCOE (4,15)
         DCOF = SGTCOE (5,15)
c  |  Compute the pbar p total cross section:
         SAPPTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         IF ( PLA .LT. FIVFIV ) THEN
            JREAC = 26
         ELSE
            JREAC = 25
         END IF
         ACOF = SGTCOE (1,JREAC)
         BCOF = SGTCOE (2,JREAC)
         ENNE = SGTCOE (3,JREAC)
         CCOF = SGTCOE (4,JREAC)
         DCOF = SGTCOE (5,JREAC)
c  |  Compute the pbar p elastic cross section:
         SAPPEL = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the pbar p inelastic cross section:
         SAPPIN = SAPPTT - SAPPEL
         ACOF = SGTCOE (1,12)
         BCOF = SGTCOE (2,12)
         ENNE = SGTCOE (3,12)
         CCOF = SGTCOE (4,12)
         DCOF = SGTCOE (5,12)
c  |  Compute the p p total cross section:
         SPPTOT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
         ACOF = SGTCOE (1,23)
         BCOF = SGTCOE (2,23)
         ENNE = SGTCOE (3,23)
         CCOF = SGTCOE (4,23)
         DCOF = SGTCOE (5,23)
c  |  Compute the p p elastic cross section:
         SPPELA = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &          + DCOF * ALGPLA
c  |  Compute the K- p inelastic cross section:
         SPPINE = SPPTOT - SPPELA
         SIGDIA = ( SAPPIN - SPPINE ) / FIVFIV
         KHELP  = KTARG / 8
c  |  +----------------------------------------------------------------*
c  |  |  Pbar:
         IF ( ICHRGE (IP) .NE. 0 ) THEN
            NDIAGR = 5 - KHELP
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Proton target:
            IF ( KHELP .EQ. 0 ) THEN
c  |  |  |  Number of diagrams:
               SHNCIN = SAPPIN
               PUUBAR = 0.8D+00
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Neutron target: it is supposed that (ap n)el is almost equal
c  |  |  |                  to (ap p)el (reasonable above 5 GeV/c)
            ELSE
               ACOF = SGTCOE (1,16)
               BCOF = SGTCOE (2,16)
               ENNE = SGTCOE (3,16)
               CCOF = SGTCOE (4,16)
               DCOF = SGTCOE (5,16)
c  |  |  |  Compute the total cross section:
               SHNCTT = ACOF + BCOF * PLA**ENNE + CCOF * ALGPLA**2
     &                + DCOF * ALGPLA
c  |  |  |  Compute the elastic cross section:
               SHNCEL = SAPPEL
c  |  |  |  Compute the inelastic cross section:
               SHNCIN = SHNCTT - SHNCEL
               PUUBAR = HLFHLF
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
c  |  |  there are different possibilities, make a random choiche:
            IQFSC1 = -1
            RNCHEN = DT_RNDM(PUUBAR)
            IF ( RNCHEN .LT. PUUBAR ) THEN
               IQFSC2 = -2
            ELSE
               IQFSC2 = -1
            END IF
            IQBSC1 = -IQFSC1 + KHELP
            IQBSC2 = -IQFSC2
c  |  |
c  |  +----------------------------------------------------------------*
c  |  |  nbar:
         ELSE
            NDIAGR = 4 + KHELP
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Proton target: (nbar p)in supposed to be given by
c  |  |  |                 (pbar p)in - Sig_diagr
            IF ( KHELP .EQ. 0 ) THEN
               SHNCIN = SAPPIN - SIGDIA
               PDDBAR = HLFHLF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  |  Neutron target: (nbar n)el is supposed to be equal to
c  |  |  |                  (pbar p)el (reasonable above 5 GeV/c)
            ELSE
c  |  |  |  Compute the total cross section:
               SHNCTT = SAPPTT
c  |  |  |  Compute the elastic cross section:
               SHNCEL = SAPPEL
c  |  |  |  Compute the inelastic cross section:
               SHNCIN = SHNCTT - SHNCEL
               PDDBAR = 0.8D+00
            END IF
c  |  |  |
c  |  |  +-------------------------------------------------------------*
c  |  |  Now compute the chain end (anti)quark-(anti)diquark
c  |  |  there are different possibilities, make a random choiche:
            IQFSC1 = -2
            RNCHEN = DT_RNDM(RNCHEN)
            IF ( RNCHEN .LT. PDDBAR ) THEN
               IQFSC2 = -1
            ELSE
               IQFSC2 = -2
            END IF
            IQBSC1 = -IQFSC1 + KHELP - 1
            IQBSC2 = -IQFSC2
         END IF
c  |  |
c  |  +----------------------------------------------------------------*
c  |
c  +-------------------------------------------------------------------*
c  |  Others: not yet implemented
      ELSE
         SIGDIA = ZERZER
         SHNCIN = ONEONE
         NDIAGR = 0
         DT_PHNSCH = ZERZER
         RETURN
      END IF
c  |                                                   end others
c  +-------------------------------------------------------------------*
      DT_PHNSCH = NDIAGR * SIGDIA / SHNCIN
      IQECHC = IQECHR (IQFSC1) + IQECHR (IQFSC2) + IQECHR (IQBSC1)
     &       + IQECHR (IQBSC2)
      IQBCHC = IQBCHR (IQFSC1) + IQBCHR (IQFSC2) + IQBCHR (IQBSC1)
     &       + IQBCHR (IQBSC2)
      IQECHC = IQECHC / 3
      IQBCHC = IQBCHC / 3
      IQSCHC = IQSCHR (IQFSC1) + IQSCHR (IQFSC2) + IQSCHR (IQBSC1)
     &       + IQSCHR (IQBSC2)
      IQSPRO = IQSCHR (MQUARK(1,IP)) + IQSCHR (MQUARK(2,IP))
     &       + IQSCHR (MQUARK(3,IP))
c  +-------------------------------------------------------------------*
c  |  Consistency check:
      IF ( DT_PHNSCH .LE. ZERZER .OR. DT_PHNSCH .GT. ONEONE ) THEN
         WRITE (ErrorOut,*)' *** Phnsch,kp,ktarg,pla',
     &                         DT_PHNSCH,KP,KTARG,PLA,' ****'
         WRITE (ErrorOut,*)' *** Phnsch,kp,ktarg,pla',
     &                         DT_PHNSCH,KP,KTARG,PLA,' ****'
         DT_PHNSCH = MAX ( DT_PHNSCH, ZERZER )
         DT_PHNSCH = MIN ( DT_PHNSCH, ONEONE )
      END IF
c  |
c  +-------------------------------------------------------------------*
c  +-------------------------------------------------------------------*
c  |  Consistency check:
      IF ( IQSPRO .NE. IQSCHC .OR. ICHRGE (IP) + ICHRGE (KTARG)
     &     .NE. IQECHC .OR. IIBAR (KP) + IIBAR (KTARG) .NE. IQBCHC) THEN
         WRITE (ErrorOut,*)
     &' *** PHNSCH,IQSPRO,IQSCHC,ICHRGE,IQECHC,IBAR,IQBCHC,KTARG',
     &      IQSPRO,IQSCHC,ICHRGE(IP),IQECHC,IIBAR(KP),IQBCHC,KTARG
         WRITE (ErrorOut,*)
     &' *** PHNSCH,IQSPRO,IQSCHC,ICHRGE,IQECHC,IBAR,IQBCHC,KTARG',
     &      IQSPRO,IQSCHC,ICHRGE(IP),IQECHC,IIBAR(KP),IQBCHC,KTARG
      END IF
c  |
c  +-------------------------------------------------------------------*
c  P_sch = 1 / [ ( 1 / P_sch (50) - 1 ) x sqrt(s/s(50)) + 1 ]
      IF ( UMORAT .GT. ONEPLS )
     &   DT_PHNSCH = ONEONE / ( ( ONEONE / DT_PHNSCH
     &                                 - ONEONE ) * UMORAT + ONEONE )
      RETURN
c
      ENTRY DT_SCHQUA ( JQFSC1, JQFSC2, JQBSC1, JQBSC2 )
      DT_SCHQUA = ONEONE
      JQFSC1 = IQFSC1
      JQFSC2 = IQFSC2
      JQBSC1 = IQBSC1
      JQBSC2 = IQBSC2
c=== End of function Phnsch ===========================================*
      RETURN
      END
c
c===respt==============================================================*
c
CDECK  ID>, DT_RESPT
      SUBROUTINE DT_RESPT

c***********************************************************************
c Check DTEVT1 for two-resonance systems and sample intrinsic p_t.     *
c This version dated 18.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY7=1.0D-7,TINY3=1.0D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


c get index of first chain
      DO 1 I=NPOINT(3),NHKK
         IF (IDHKK(I).EQ.88888) THEN
            NC = I
            GOTO 2
         ENDIF
    1 CONTINUE

    2 CONTINUE
      IF ((IDHKK(NC).EQ.88888).AND.(IDHKK(NC+3).EQ.88888)) THEN
C        WRITE(LOUT,*)NC,NC+3,IDRES(NC),IDRES(NC+3)
c skip VV-,SS- systems
         IF ((IDCH(NC  ).NE.1).AND.(IDCH(NC  ).NE.8).AND.
     &       (IDCH(NC+3).NE.1).AND.(IDCH(NC+3).NE.8)) THEN
c check if both "chains" are resonances
            IF ((IDRES(NC).NE.0).AND.(IDRES(NC+3).NE.0)) THEN
               CALL DT_SAPTRE(NC,NC+3)
            ENDIF
         ENDIF
      ELSE
         GOTO 3
      ENDIF
      NC = NC+6
      GOTO 2

    3 CONTINUE

      RETURN
      END
c
c===evtres=============================================================*
c
CDECK  ID>, DT_EVTRES
      SUBROUTINE DT_EVTRES(IREJ)

c***********************************************************************
c This version dated 14.12.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY5=1.0D-5,TINY10=1.0D-10)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),IFP(2),IFT(2)

      IREJ = 0

      DO 1 I=NPOINT(3),NHKK
         IF (ABS(IDRES(I)).GE.100) THEN
            AMMX = 0.0D0
            DO 2 J=NPOINT(3),NHKK
               IF (IDHKK(J).EQ.88888) THEN
                  IF (PHKK(5,J).GT.AMMX) THEN
                     AMMX = PHKK(5,J)
                     IMMX = J
                  ENDIF
               ENDIF
    2       CONTINUE
            IF (IDRES(IMMX).NE.0) THEN
               IF (IOULEV(3).GT.0) THEN
                  WRITE(ErrorOut,'(1X,A)')
     &               'EVTRES: NO CHAIN FOR CORREC. FOUND'
C                 GOTO 6
                  GOTO 9999
               ELSE
                  GOTO 9999
               ENDIF
            ENDIF
            IMO11  = JMOHKK(1,I)
            IMO12  = JMOHKK(2,I)
            IF (PHKK(3,IMO11).LT.0.0D0) THEN
               IMO11 = JMOHKK(2,I)
               IMO12 = JMOHKK(1,I)
            ENDIF
            IMO21  = JMOHKK(1,IMMX)
            IMO22  = JMOHKK(2,IMMX)
            IF (PHKK(3,IMO21).LT.0.0D0) THEN
               IMO21 = JMOHKK(2,IMMX)
               IMO22 = JMOHKK(1,IMMX)
            ENDIF
            AMCH1  = PHKK(5,I)
            AMCH1N = AAM(IDXRES(I))

            IFPR1 = IDHKK(IMO11)
            IFPR2 = IDHKK(IMO21)
            IFTA1 = IDHKK(IMO12)
            IFTA2 = IDHKK(IMO22)
            DO 4 J=1,4
               PP1(J) = PHKK(J,IMO11)
               PP2(J) = PHKK(J,IMO21)
               PT1(J) = PHKK(J,IMO12)
               PT2(J) = PHKK(J,IMO22)
    4       CONTINUE
c store initial configuration for energy-momentum cons. check
            IF (LEMCCK) CALL DT_EMC1(PP1,PP2,PT1,PT2,1,1,IREJ1)
c correct kinematics of second chain
            CALL DT_CHKINE(PP1,IFPR1,PP2,IFPR2,PT1,IFTA1,PT2,IFTA2,
     &                  AMCH1,AMCH1N,AMCH2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
c check now this chain for resonance mass
            IFP(1) = IDT_IPDG2B(IFPR2,1,2)
            IFP(2) = 0
            IF (ABS(IFPR2).GE.1000) IFP(2) = IDT_IPDG2B(IFPR2,2,2)
            IFT(1) = IDT_IPDG2B(IFTA2,1,2)
            IFT(2) = 0
            IF (ABS(IFTA2).GE.1000) IFT(2) = IDT_IPDG2B(IFTA2,2,2)
            IDCH2 = 2
            IF ((IFP(2).EQ.0).AND.(IFT(2).EQ.0)) IDCH2 = 1
            IF ((IFP(2).NE.0).AND.(IFT(2).NE.0)) IDCH2 = 3
            CALL DT_CH2RES(IFP(1),IFP(2),IFT(1),IFT(2),IDR2,IDXR2,
     &                  AMCH2,AMCH2N,IDCH2,IREJ1)
            IF ((IREJ1.NE.0).OR.(IDR2.NE.0)) THEN
               IF (IOULEV(1).GT.0)
     &            WRITE(ErrorOut,
     * *) ' correction for resonance not poss.'
c*sr test
C              GOTO 1
C              GOTO 9999
c*
            ENDIF
c store final configuration for energy-momentum cons. check
            IF (LEMCCK) THEN
               CALL DT_EMC1(PP1,PP2,PT1,PT2,-2,1,IREJ1)
               CALL DT_EMC1(PP1,PP2,PT1,PT2,3,1,IREJ1)
               IF (IREJ1.NE.0) GOTO 9999
            ENDIF
            DO 5 J=1,4
               PHKK(J,IMO11) = PP1(J)
               PHKK(J,IMO21) = PP2(J)
               PHKK(J,IMO12) = PT1(J)
               PHKK(J,IMO22) = PT2(J)
    5       CONTINUE
c correct entries of chains
            DO 3 K=1,4
               PHKK(K,I)    = PHKK(K,IMO11)+PHKK(K,IMO12)
               PHKK(K,IMMX) = PHKK(K,IMO21)+PHKK(K,IMO22)
    3       CONTINUE
            AM1 = PHKK(4,I)**2-PHKK(1,I)**2-PHKK(2,I)**2-PHKK(3,I)**2
            AM2 = PHKK(4,IMMX)**2-PHKK(1,IMMX)**2-PHKK(2,IMMX)**2-
     &            PHKK(3,IMMX)**2
c ?? the following should now be obsolete
c*sr test
C           IF ((AM1.LT.0.0D0).OR.(AM2.LT.1.0D0)) THEN
            IF ((AM1.LT.0.0D0).OR.(AM2.LT.0.0D0)) THEN
c*
               WRITE(ErrorOut,'(1X,A,4G10.3)')
     &          'EVTRES: INONSISTENT MASS-CORR.',AM1,AM2
C              GOTO 9999
               GOTO 1
            ENDIF
            PHKK(5,I)    = SQRT(AM1)
            PHKK(5,IMMX) = SQRT(AM2)
            IDRES(I)     = IDRES(I)/100
            IF ((ABS(PHKK(5,I)-AMCH1N).GT.TINY5).OR.
     &          (ABS(PHKK(5,IMMX)-AMCH2).GT.TINY5)) THEN
               WRITE(ErrorOut,'(1X,A,4G10.3)')
     &          'EVTRES: INCONSISTENT CHAIN-MASSES',
     &          PHKK(5,I),AMCH1N,PHKK(5,IMMX),AMCH2
               GOTO 9999
            ENDIF
         ENDIF
    1 CONTINUE
    6 CONTINUE
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===getspt=============================================================*
c
CDECK  ID>, DT_GETSPT
      SUBROUTINE DT_GETSPT(PP1I,IFPR1,IFP1,PP2I,IFPR2,IFP2,
     &                  PT1I,IFTA1,IFT1,PT2I,IFTA2,IFT2,
     &                  AM1,IDCH1,AM2,IDCH2,IDCHAI,IREJ)

c***********************************************************************
c This version dated 12.12.94 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY5=1.0D-5,TINY3=1.0D-3,ZERO=0.0D0)



c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF


      DIMENSION PP1(4),PP1I(4),PP2(4),PP2I(4),PT1(4),PT1I(4),
     &          PT2(4),PT2I(4),P1(4),P2(4),
     &          IFP1(2),IFP2(2),IFT1(2),IFT2(2),
     &          PTOTI(4),PTOTF(4),DIFF(4)

      IC   = 0
      IREJ = 0
C     B33P = 4.0D0
C     B33T = 4.0D0
C     IF ((IDCHAI.EQ.6).OR.(IDCHAI.EQ.7).OR.(IDCHAI.EQ.8)) B33P = 2.0D0
C     IF ((IDCHAI.EQ.4).OR.(IDCHAI.EQ.5).OR.(IDCHAI.EQ.8)) B33T = 2.0D0
      REDU = 1.0D0
C     B33P = 3.5D0
C     B33T = 3.5D0
      B33P = 4.0D0
      B33T = 4.0D0
      IF (IDIFF.NE.0) THEN
         B33P = 16.0D0
         B33T = 16.0D0
      ENDIF

      DO 1 I=1,4
         PTOTI(I) = PP1I(I)+PP2I(I)+PT1I(I)+PT2I(I)
         PP1(I)   = PP1I(I)
         PP2(I)   = PP2I(I)
         PT1(I)   = PT1I(I)
         PT2(I)   = PT2I(I)
    1 CONTINUE
c get initial chain masses
      PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                               +(PP1(3)+PT1(3))**2)
      ECH   = PP1(4)+PT1(4)
      AM1   = (ECH+PTOCH)*(ECH-PTOCH)
      PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                               +(PP2(3)+PT2(3))**2)
      ECH   = PP2(4)+PT2(4)
      AM2   = (ECH+PTOCH)*(ECH-PTOCH)
      IF ((AM1.LT.0.0D0).OR.(AM2.LT.0.0D0)) THEN
         IF (IOULEV(1).GT.0)
     &   WRITE(ErrorOut,
     * '(1X,A,2G10.3)')'GETSPT: too small chain masses 1',
     &                              AM1,AM2
         GOTO 9999
      ENDIF
      AM1  = SQRT(AM1)
      AM2  = SQRT(AM2)
      AM1N = ZERO
      AM2N = ZERO

      MODE = 0
C      IF ((AM1.GE.3.0D0).AND.(AM2.GE.3.0D0)) THEN
C        MODE = 0
C      ELSE
C         MODE = 1
C         IF (AM1.LT.0.6) THEN
C            B33P = 10.0D0
C         ELSEIF ((AM1.GE.1.2).AND.(AM1.LT.3.0D0)) THEN
CC           B33P = 4.0D0
C         ENDIF
C         IF (AM2.LT.0.6) THEN
C            B33T = 10.0D0
C         ELSEIF ((AM2.GE.1.2).AND.(AM2.LT.3.0D0)) THEN
CC           B33T = 4.0D0
C         ENDIF
C      ENDIF

c check chain masses for very low mass chains
C     CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDUM,IDUM,
C    &            AM1,DUM,-IDCH1,IREJ1)
C     CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDUM,IDUM,
C    &            AM2,DUM,-IDCH2,IREJ2)
C     IF ((IREJ1.NE.0).OR.(IREJ2.NE.0)) THEN
C        B33P = 20.0D0
C        B33T = 20.0D0
C     ENDIF

      JMSHL = IMSHL

    2 CONTINUE
      IC = IC+1
      IF (MOD(IC,15).EQ.0) B33P  = 2.0D0*B33P
      IF (MOD(IC,15).EQ.0) B33T  = 2.0D0*B33T
      IF (MOD(IC,18).EQ.0) REDU  = 0.0D0
C     IF (MOD(IC,19).EQ.0) JMSHL = 0
      IF (MOD(IC,20).EQ.0) GOTO 7
C        WRITE(LOUT,'(1X,A)') 'GETSPT: rejection '
C        RETURN
C        GOTO 9999
C     ENDIF

c get transverse momentum
      IF (LINTPT) THEN
         ES   = -2.0D0/(B33P**2)
     &          *LOG(ABS(DT_RNDM(AM1)*DT_RNDM(AM2))+TINY10)
         HPSP = SQRT(ES*ES+2.0D0*ES*0.94D0)
         HPSP = HPSP*REDU
         ES   = -2.0D0/(B33T**2)
     &          *LOG(ABS(DT_RNDM(AM1)*DT_RNDM(AM2))+TINY10)
         HPST = SQRT(ES*ES+2.0D0*ES*0.94D0)
         HPST = HPST*REDU
      ELSE
         HPSP = ZERO
         HPST = ZERO
      ENDIF
      CALL DT_DSFECF(SFE1,CFE1)
      CALL DT_DSFECF(SFE2,CFE2)
      IF (MODE.EQ.0) THEN
         PP1(1) = PP1I(1)+HPSP*CFE1
         PP1(2) = PP1I(2)+HPSP*SFE1
         PP2(1) = PP2I(1)-HPSP*CFE1
         PP2(2) = PP2I(2)-HPSP*SFE1
         PT1(1) = PT1I(1)+HPST*CFE2
         PT1(2) = PT1I(2)+HPST*SFE2
         PT2(1) = PT2I(1)-HPST*CFE2
         PT2(2) = PT2I(2)-HPST*SFE2
      ELSE
         PP1(1) = PP1I(1)+HPSP*CFE1
         PP1(2) = PP1I(2)+HPSP*SFE1
         PT1(1) = PT1I(1)-HPSP*CFE1
         PT1(2) = PT1I(2)-HPSP*SFE1
         PP2(1) = PP2I(1)+HPST*CFE2
         PP2(2) = PP2I(2)+HPST*SFE2
         PT2(1) = PT2I(1)-HPST*CFE2
         PT2(2) = PT2I(2)-HPST*SFE2
      ENDIF

c put partons on mass shell
      XMP1 = 0.0D0
      XMT1 = 0.0D0
      IF (JMSHL.EQ.1) THEN

         XMP1 = PYMASS(IFPR1)
         XMT1 = PYMASS(IFTA1)

      ENDIF
      CALL DT_MASHEL(PP1,PT1,XMP1,XMT1,P1,P2,IREJ1)
      IF (IREJ1.NE.0) GOTO 2
      DO 3 I=1,4
         PTOTF(I) = P1(I)+P2(I)
         PP1(I)   = P1(I)
         PT1(I)   = P2(I)
    3 CONTINUE
      XMP2 = 0.0D0
      XMT2 = 0.0D0
      IF (JMSHL.EQ.1) THEN

         XMP2 = PYMASS(IFPR2)
         XMT2 = PYMASS(IFTA2)

      ENDIF
      CALL DT_MASHEL(PP2,PT2,XMP2,XMT2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) GOTO 2
      DO 4 I=1,4
         PTOTF(I) = PTOTF(I)+P1(I)+P2(I)
         PP2(I)   = P1(I)
         PT2(I)   = P2(I)
    4 CONTINUE

c check consistency
      DO 5 I=1,4
         DIFF(I) = PTOTI(I)-PTOTF(I)
    5 CONTINUE
      IF ((ABS(DIFF(1)).GT.TINY5).OR.(ABS(DIFF(2)).GT.TINY5).OR.
     &    (ABS(DIFF(3)).GT.TINY5).OR.(ABS(DIFF(4)).GT.TINY5)) THEN
         WRITE(ErrorOut,
     * '(1X,A,4G10.3)') 'GETSPT: inconsistencies ',DIFF
         GOTO 9999
      ENDIF
      PTOTP1 = SQRT(PP1(1)**2+PP1(2)**2+PP1(3)**2)
      AMP1 = SQRT(ABS( (PP1(4)-PTOTP1)*(PP1(4)+PTOTP1) ))
      PTOTP2 = SQRT(PP2(1)**2+PP2(2)**2+PP2(3)**2)
      AMP2 = SQRT(ABS( (PP2(4)-PTOTP2)*(PP2(4)+PTOTP2) ))
      PTOTT1 = SQRT(PT1(1)**2+PT1(2)**2+PT1(3)**2)
      AMT1 = SQRT(ABS( (PT1(4)-PTOTT1)*(PT1(4)+PTOTT1) ))
      PTOTT2 = SQRT(PT2(1)**2+PT2(2)**2+PT2(3)**2)
      AMT2 = SQRT(ABS( (PT2(4)-PTOTT2)*(PT2(4)+PTOTT2) ))
      IF ((ABS(AMP1-XMP1).GT.TINY3).OR.(ABS(AMP2-XMP2).GT.TINY3).OR.
     &    (ABS(AMT1-XMT1).GT.TINY3).OR.(ABS(AMT2-XMT2).GT.TINY3))
     &                                                           THEN
         WRITE(ErrorOut,'(1X,A,2(4G10.3,/))')
     &     'GETSPT: INCONSISTENT MASSES',
     &     AMP1,XMP1,AMP2,XMP2,AMT1,XMT1,AMT2,XMT2
c sr 22.11.00: commented. It should only have inconsistent masses for
c ultrahigh energies due to rounding problems
C        GOTO 9999
      ENDIF

c get chain masses
      PTOCH = SQRT((PP1(1)+PT1(1))**2+(PP1(2)+PT1(2))**2
     &                               +(PP1(3)+PT1(3))**2)
      ECH   = PP1(4)+PT1(4)
      AM1N  = (ECH+PTOCH)*(ECH-PTOCH)
      PTOCH = SQRT((PP2(1)+PT2(1))**2+(PP2(2)+PT2(2))**2
     &                               +(PP2(3)+PT2(3))**2)
      ECH   = PP2(4)+PT2(4)
      AM2N  = (ECH+PTOCH)*(ECH-PTOCH)
      IF ((AM1N.LT.0.0D0).OR.(AM2N.LT.0.0D0)) THEN
         IF (IOULEV(1).GT.0)
     &   WRITE(ErrorOut,
     * '(1X,A,2G10.3)')'GETSPT: too small chain masses 2',
     &                              AM1N,AM2N
         GOTO 2
      ENDIF
      AM1N = SQRT(AM1N)
      AM2N = SQRT(AM2N)

c check chain masses for very low mass chains
      CALL DT_CH2RES(IFP1(1),IFP1(2),IFT1(1),IFT1(2),IDUM,IDUM,
     &            AM1N,DUM,-IDCH1,IREJ1)
      IF (IREJ1.NE.0) GOTO 2
      CALL DT_CH2RES(IFP2(1),IFP2(2),IFT2(1),IFT2(2),IDUM,IDUM,
     &            AM2N,DUM,-IDCH2,IREJ2)
      IF (IREJ2.NE.0) GOTO 2

    7 CONTINUE
      IF (AM1N.GT.ZERO) THEN
         AM1 = AM1N
         AM2 = AM2N
      ENDIF
      DO 6 I=1,4
         PP1I(I)   = PP1(I)
         PP2I(I)   = PP2(I)
         PT1I(I)   = PT1(I)
         PT2I(I)   = PT2(I)
    6 CONTINUE

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===saptre=============================================================*
c
CDECK  ID>, DT_SAPTRE
      SUBROUTINE DT_SAPTRE(IDX1,IDX2)

c***********************************************************************
c p-t sampling for two-resonance systems. ("BAMJET-like" method)       *
c        IDX1,IDX2       indices of resonances ("chains") in DTEVT1    *
c Adopted from the original SAPTRE written by J. Ranft.                *
c This version dated 18.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY7=1.0D-7,TINY3=1.0D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      DIMENSION PA1(4),PA2(4),P1(4),P2(4)

      DATA B3 /4.0D0/

      ESMAX1 = PHKK(4,IDX1)-PHKK(5,IDX1)
      ESMAX2 = PHKK(4,IDX2)-PHKK(5,IDX2)
      ESMAX  = MIN(ESMAX1,ESMAX2)
      IF (ESMAX.LE.0.05D0) RETURN

      HMA    = PHKK(5,IDX1)
      DO 1 K=1,4
         PA1(K) = PHKK(K,IDX1)
         PA2(K) = PHKK(K,IDX2)
    1 CONTINUE

      IF (LEMCCK) THEN
         CALL DT_EVTEMC(PA1(1),PA1(2),PA1(3),PA1(4),1,IDUM,IDUM)
         CALL DT_EVTEMC(PA2(1),PA2(2),PA2(3),PA2(4),2,IDUM,IDUM)
      ENDIF

      EXEB   = 0.0D0
      IF (B3*ESMAX.LE.60.0D0) EXEB = EXP(-B3*ESMAX)
      BEXP   = HMA*(1.0D0-EXEB)/B3
      AXEXP  = (1.0D0-(B3*ESMAX-1.0D0)*EXEB)/B3**2
      WA     = AXEXP/(BEXP+AXEXP)
      XAB    = DT_RNDM(WA)
   10 CONTINUE
c ES is the transverse kinetic energy
      IF (XAB.LT.WA)THEN
        X  = DT_RNDM(WA)
        Y  = DT_RNDM(WA)
        ES = -2.0D0/(B3**2)*LOG(X*Y+TINY7)
      ELSE
        X  = DT_RNDM(Y)
        ES = ABS(-LOG(X+TINY7)/B3)
      ENDIF
      IF (ES.GT.ESMAX) GOTO 10
      ES  = ES+HMA
c transverse momentum
      HPS = SQRT((ES-HMA)*(ES+HMA))

      CALL DT_DSFECF(SFE,CFE)
      HPX = HPS*CFE
      HPY = HPS*SFE
      PZ1NSQ = PA1(3)**2-HPS**2-2.0D0*PA1(1)*HPX-2.0D0*PA1(2)*HPY
      PZ2NSQ = PA2(3)**2-HPS**2+2.0D0*PA2(1)*HPX+2.0D0*PA2(2)*HPY
      IF ((PZ1NSQ.LT.TINY3).OR.(PZ2NSQ.LT.TINY3)) RETURN

C     PA1(3) = SIGN(SQRT(PZ1NSQ),PA1(3))
C     PA2(3) = SIGN(SQRT(PZ2NSQ),PA2(3))
      PA1(1) = PA1(1)+HPX
      PA1(2) = PA1(2)+HPY
      PA2(1) = PA2(1)-HPX
      PA2(2) = PA2(2)-HPY

c put resonances on mass-shell again
      XM1 = PHKK(5,IDX1)
      XM2 = PHKK(5,IDX2)
      CALL DT_MASHEL(PA1,PA2,XM1,XM2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) RETURN

      IF (LEMCCK) THEN
         CALL DT_EVTEMC(-P1(1),-P1(2),-P1(3),-P1(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(-P2(1),-P2(2),-P2(3),-P2(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,3,12,IREJ1)
         IF (IREJ1.NE.0) RETURN
      ENDIF

      DO 2 K=1,4
         PHKK(K,IDX1) = P1(K)
         PHKK(K,IDX2) = P2(K)
    2 CONTINUE

      RETURN
      END
c
c===cronin=============================================================*
c
CDECK  ID>, DT_CRONIN
      SUBROUTINE DT_CRONIN(INCL)

c***********************************************************************
c Cronin-Effect. Multiple scattering of partons at chain ends.         *
c             INCL = 1     multiple sc. in projectile                  *
c                  = 2     multiple sc. in target                      *
c This version dated 05.01.96 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY3=1.0D-3)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC


      DIMENSION R(3),PIN(4),POUT(4),DEV(4)

      DO 1 K=1,4
         DEV(K) = ZERO
    1 CONTINUE

      DO 2 I=NPOINT(2),NHKK
         IF (ISTHKK(I).LT.0) THEN
c get z-position of the chain
            R(1) = VHKK(1,I)*1.0D12
            IF (INCL.EQ.2) R(1) = VHKK(1,I)*1.0D12-BIMPAC
            R(2) = VHKK(2,I)*1.0D12
            IDXNU = JMOHKK(1,I)
            IF ( (INCL.EQ.1).AND.(ISTHKK(IDXNU).EQ.10) )
     &                             IDXNU = JMOHKK(1,I-1)
            IF ( (INCL.EQ.2).AND.(ISTHKK(IDXNU).EQ. 9) )
     &                             IDXNU = JMOHKK(1,I+1)
            R(3) = VHKK(3,IDXNU)*1.0D12
c position of target parton the chain is connected to
            DO 3 K=1,4
               PIN(K) = PHKK(K,I)
    3       CONTINUE
c multiple scattering of parton with DTEVT1-index I
            CALL DT_CROMSC(PIN,R,POUT,INCL)
c*testprint
C           IF (NEVHKK.EQ.5) THEN
C              AMIN = PIN(4)**2-PIN(1)**2-PIN(2)**2-PIN(3)**2
C              AMOU = POUT(4)**2-POUT(1)**2-POUT(2)**2-POUT(3)**2
C              AMIN = SIGN(SQRT(ABS(AMIN)),AMIN)
C              AMOU = SIGN(SQRT(ABS(AMOU)),AMOU)
C              WRITE(6,'(A,I4,2E15.5)')'I,AMIN,AMOU: ',I,AMIN,AMOU
C              WRITE(6,'(A,4E15.5)')'PIN:       ',PIN
C              WRITE(6,'(A,4E15.5)')'POUT:      ',POUT
C           ENDIF
c*
c increase accumulator by energy-momentum difference
            DO 4 K=1,4
               DEV(K)    = DEV(K)+POUT(K)-PIN(K)
               PHKK(K,I) = POUT(K)
    4       CONTINUE
            PHKK(5,I) = SQRT(ABS(PHKK(4,I)**2-PHKK(1,I)**2-
     &                           PHKK(2,I)**2-PHKK(3,I)**2))
         ENDIF
    2 CONTINUE

c dump accumulator to momenta of valence partons
      NVAL = 0
      ETOT = 0.0D0
      DO 5 I=NPOINT(2),NHKK
         IF ((ISTHKK(I).EQ.-21).OR.(ISTHKK(I).EQ.-22)) THEN
            NVAL = NVAL+1
            ETOT = ETOT+PHKK(4,I)
         ENDIF
    5 CONTINUE
C     WRITE(LOUT,1000) NVAL,(DEV(K)/DBLE(NVAL),K=1,4)
 1000 FORMAT(1X,'CRONIN :  NUMBER OF VAL. PARTONS ',I4,/,
     &       9X,4E12.4)
      DO 6 I=NPOINT(2),NHKK
         IF ((ISTHKK(I).EQ.-21).OR.(ISTHKK(I).EQ.-22)) THEN
            E = PHKK(4,I)
            DO 7 K=1,4
C              PHKK(K,I) = PHKK(K,I)-DEV(K)/DBLE(NVAL)
               PHKK(K,I) = PHKK(K,I)-DEV(K)*E/ETOT
    7       CONTINUE
            PHKK(5,I) = SQRT(ABS(PHKK(4,I)**2-PHKK(1,I)**2-
     &                           PHKK(2,I)**2-PHKK(3,I)**2))
         ENDIF
    6 CONTINUE

      RETURN
      END
c
c===cromsc=============================================================*
c
CDECK  ID>, DT_CROMSC
      SUBROUTINE DT_CROMSC(PIN,R,POUT,INCL)

c***********************************************************************
c Cronin-Effect. Multiple scattering of one parton passing through     *
c nuclear matter.                                                      *
c            PIN(4)       input 4-momentum of parton                   *
c            POUT(4)      4-momentum of parton after mult. scatt.      *
c            R(3)         spatial position of parton in target nucleus *
c            INCL = 1     multiple sc. in projectile                   *
c                 = 2     multiple sc. in target                       *
c This is a revised version of the original version written by J. Ranft*
c This version dated 17.01.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY3=1.0D-3)

      LOGICAL LSTART

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DIMENSION PIN(4),POUT(4),R(3)

      DATA LSTART /.TRUE./

      IRCRON(1) = IRCRON(1)+1

      IF (LSTART) THEN
         WRITE(ErrorOut,1000) CRONCO
 1000    FORMAT(/,1X,'CROMSC:  MULTIPLE SCATTERING OF CHAIN ENDS',
     &          ' TREATED',/,10X,'WITH PARAMETER CRONCO = ',F5.2)
         LSTART = .FALSE.
      ENDIF

      NCBACK = 0
      RNCL   = RPROJ
      IF (INCL.EQ.2) RNCL = RTARG

c Lorentz-transformation into Lab.
      MODE = -(INCL+1)
      CALL DT_LTNUC(PIN(3),PIN(4),PZ,PE,MODE)

      PTOT = SQRT(PIN(1)**2+PIN(2)**2+PZ**2)
      IF (PTOT.LE.8.0D0) GOTO 9997

c direction cosines of parton before mult. scattering
      COSX = PIN(1)/PTOT
      COSY = PIN(2)/PTOT
      COSZ = PZ/PTOT

      RTESQ = R(1)**2+R(2)**2+R(3)**2-RNCL**2
      IF (RTESQ.GE.-TINY3) GOTO 9999

c calculate distance (DIST) from R to surface of nucleus (radius RNCL)
c in the direction of particle motion

      A    = COSX*R(1)+COSY*R(2)+COSZ*R(3)
      TMP  = A**2-RTESQ
      IF (TMP.LT.ZERO) GOTO 9998
      DIST = -A+SQRT(TMP)

c multiple scattering angle
      THETO = CRONCO*SQRT(DIST)/PTOT
      IF (THETO.GT.0.1D0) THETO=0.1D0

    1 CONTINUE
c Gaussian sampling of spatial angle
      CALL DT_RANNOR(R1,R2)
      THETA = ABS(R1*THETO)
      IF (THETA.GT.0.3D0) GOTO 9997
      CALL DT_DSFECF(SFE,CFE)
      COSTH = COS(THETA)
      SINTH = SIN(THETA)

c new direction cosines
      CALL DT_MYTRAN(1,COSX,COSY,COSZ,COSTH,SINTH,SFE,CFE,
     &                               COSXN,COSYN,COSZN)

      POUT(1) = COSXN*PTOT
      POUT(2) = COSYN*PTOT
      PZ      = COSZN*PTOT
c Lorentz-transformation into nucl.-nucl. cms
      MODE = INCL+1
      CALL DT_LTNUC(PZ,PE,POUT(3),POUT(4),MODE)

C     IF (ABS(PIN(4)-POUT(4)).GT.0.2D0) THEN
C     IF ( (ABS(PIN(4)-POUT(4))/PIN(4)).GT.0.1D0 ) THEN
      IF ( (ABS(PIN(4)-POUT(4))/PIN(4)).GT.0.05D0 ) THEN
         THETO = THETO/2.0D0
         NCBACK = NCBACK+1
         IF (MOD(NCBACK,200).EQ.0) THEN
            WRITE(ErrorOut,1001) THETO,PIN,POUT
 1001       FORMAT(1X,'CROMSC: INCONSISTENT SCATTERING ANGLE ',
     &             E12.4,/,1X,'        PIN :',4E12.4,/,
     &             1X,'       POUT:',4E12.4)
            GOTO 9997
         ENDIF
         GOTO 1
      ENDIF

      RETURN

 9997 IRCRON(2) = IRCRON(2)+1
      GOTO 9999
 9998 IRCRON(3) = IRCRON(3)+1

 9999 CONTINUE
      DO 100 K=1,4
         POUT(K) = PIN(K)
  100 CONTINUE
      RETURN
      END
c
c===com2sr=============================================================*
c
CDECK  ID>, DT_COM2CR
      SUBROUTINE DT_COM2CR

c***********************************************************************
c COMbine q-aq chains to Color Ropes (qq-aqaq).                        *
c        CUTOF      parameter determining minimum number of not        *
c                   combined q-aq chains                               *
c This subroutine replaces KKEVCC etc.                                 *
c This version dated 11.01.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DIMENSION IDXQA(248),IDXAQ(248)

      ICCHAI(1,9) = ICCHAI(1,9)+1
      NQA = 0
      NAQ = 0
c scan DTEVT1 for q-aq, aq-q chains
      DO 10 I=NPOINT(3),NHKK
c skip "chains" which are resonances
         IF ((IDHKK(I).EQ.88888).AND.(IDRES(I).EQ.0)) THEN
            MO1 = JMOHKK(1,I)
            MO2 = JMOHKK(2,I)
            IF ((ABS(IDHKK(MO1)).LE.6).AND.(ABS(IDHKK(MO2)).LE.6)) THEN
c q-aq, aq-q chain found, keep index
               IF (IDHKK(MO1).GT.0) THEN
                  NQA = NQA+1
                  IDXQA(NQA) = I
               ELSE
                  NAQ = NAQ+1
                  IDXAQ(NAQ) = I
               ENDIF
            ENDIF
         ENDIF
   10 CONTINUE

c minimum number of q-aq chains requested for the same projectile/
c target
      NCHMIN = IDT_NPOISS(CUTOF)

c combine q-aq chains of the same projectile
      CALL DT_SCN4CR(NQA,IDXQA,NCHMIN,1)
c combine q-aq chains of the same target
      CALL DT_SCN4CR(NQA,IDXQA,NCHMIN,2)
c combine aq-q chains of the same projectile
      CALL DT_SCN4CR(NAQ,IDXAQ,NCHMIN,1)
c combine aq-q chains of the same target
      CALL DT_SCN4CR(NAQ,IDXAQ,NCHMIN,2)

      RETURN
      END
c
c===scn4cr=============================================================*
c
CDECK  ID>, DT_SCN4CR
      SUBROUTINE DT_SCN4CR(NCH,IDXCH,NCHMIN,MODE)

c***********************************************************************
c SCan q-aq chains for Color Ropes.                                    *
c This version dated 11.01.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


      DIMENSION IDXCH(248),IDXJN(248)

      DO 1 I=1,NCH
         IF (IDXCH(I).GT.0) THEN
            NJOIN = 1
            IDXMO = JMOHKK(1,JMOHKK(1,JMOHKK(MODE,IDXCH(I))))
            IDXJN(NJOIN) = I
            IF (I.LT.NCH) THEN
               DO 2 J=I+1,NCH
                  IF (IDXCH(J).GT.0) THEN
                     IDXMO1 = JMOHKK(1,JMOHKK(1,JMOHKK(MODE,IDXCH(J))))
                     IF (IDXMO.EQ.IDXMO1) THEN
                        NJOIN = NJOIN+1
                        IDXJN(NJOIN) = J
                     ENDIF
                  ENDIF
    2          CONTINUE
            ENDIF
            IF (NJOIN.GE.NCHMIN+2) THEN
               NJ = INT(DBLE(NJOIN-NCHMIN)/2.0D0)
               DO 3 J=1,2*NJ,2
                  CALL DT_JOIN(IDXCH(IDXJN(J)),IDXCH(IDXJN(J+1)),IREJ1)
                  IF (IREJ1.NE.0) GOTO 3
                  IDXCH(IDXJN(J))   = 0
                  IDXCH(IDXJN(J+1)) = 0
    3          CONTINUE
            ENDIF
         ENDIF
    1 CONTINUE

      RETURN
      END
c
c===join===============================================================*
c
CDECK  ID>, DT_JOIN
      SUBROUTINE DT_JOIN(IDX1,IDX2,IREJ)

c***********************************************************************
c This subroutine joins two q-aq chains to one qq-aqaq chain.          *
c     IDX1, IDX2       DTEVT1 indices of chains to be joined           *
c This version dated 11.01.95 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)



c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)


      DIMENSION MO(2,2),ID(2,2),IDX(2),PCH(4),PP(4),PT(4),P1(4),P2(4)

      IREJ   = 0

      IDX(1) = IDX1
      IDX(2) = IDX2
      DO 1 I=1,2
         DO 2 J=1,2
            MO(I,J) = JMOHKK(J,IDX(I))
            ID(I,J) = IDT_IPDG2B(IDHKK(MO(I,J)),1,2)
    2    CONTINUE
    1 CONTINUE

c check consistency
      IF ((ABS(ID(1,1)).GT.6).OR.(ABS(ID(1,2)).GT.6).OR.
     &    (ABS(ID(2,1)).GT.6).OR.(ABS(ID(2,2)).GT.6).OR.
     &    ((ID(1,1)*ID(2,1)).LT.0).OR.
     &    ((ID(1,2)*ID(2,2)).LT.0)) THEN
         WRITE(ErrorOut,
     * 1000) IDX(1),MO(1,1),MO(1,2),IDX(2),MO(2,1),
     &                    MO(2,2)
 1000    FORMAT(1X,'JOIN: INCONS. CHAIN SYSTEM! CHAIN ',I4,':',
     &             2I5,' CHAIN ',I4,':',2I5)
      ENDIF

c join chains
      DO 3 K=1,4
         PP(K) = PHKK(K,MO(1,1))+PHKK(K,MO(2,1))
         PT(K) = PHKK(K,MO(1,2))+PHKK(K,MO(2,2))
    3 CONTINUE
      IF1  = IDT_IB2PDG(ID(1,1),ID(2,1),2)
      IF2  = IDT_IB2PDG(ID(1,2),ID(2,2),2)
      IST1 = ISTHKK(MO(1,1))
      IST2 = ISTHKK(MO(1,2))

c put partons again on mass shell
      XM1 = 0.0D0
      XM2 = 0.0D0
      IF (IMSHL.EQ.1) THEN

         XM1 = PYMASS(IF1)
         XM2 = PYMASS(IF2)

      ENDIF
      CALL DT_MASHEL(PP,PT,XM1,XM2,P1,P2,IREJ1)
      IF (IREJ1.NE.0) GOTO 9999
      DO 4 I=1,4
         PP(I) = P1(I)
         PT(I) = P2(I)
    4 CONTINUE

c store new partons in DTEVT1
      CALL DT_EVTPUT(IST1,IF1,MO(1,1),MO(2,1),PP(1),PP(2),PP(3),PP(4),
     &                                                       0,0,0)
      CALL DT_EVTPUT(IST2,IF2,MO(1,2),MO(2,2),PT(1),PT(2),PT(3),PT(4),
     &                                                       0,0,0)
      DO 5 K=1,4
         PCH(K) = PP(K)+PT(K)
    5 CONTINUE

c check new chain for lower mass limit
      IF ((IRESCO.EQ.1).OR.(IFRAG(1).EQ.1)) THEN
         AMCH = SQRT(ABS(PCH(4)**2-PCH(1)**2-PCH(2)**2-PCH(3)**2))
         CALL DT_CH2RES(ID(1,1),ID(2,1),ID(1,2),ID(2,2),IDUM,IDUM,
     &               AMCH,AMCHN,3,IREJ1)
         IF (IREJ1.NE.0) THEN
            NHKK = NHKK-2
            GOTO 9999
         ENDIF
      ENDIF

      ICCHAI(2,9) = ICCHAI(2,9)+1
c store new chain in DTEVT1
      KCH = 191
      CALL DT_EVTPUT(KCH,88888,-2,-1,PCH(1),PCH(2),PCH(3),PCH(4),0,0,9)
      IDHKK(IDX(1)) = 22222
      IDHKK(IDX(2)) = 22222
c special treatment for space-time coordinates
      DO 6 K=1,4
         VHKK(K,NHKK) = (VHKK(K,IDX(1))+VHKK(K,IDX(2)))/2.0D0
         WHKK(K,NHKK) = (WHKK(K,IDX(1))+WHKK(K,IDX(2)))/2.0D0
    6 CONTINUE
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===xsglau=============================================================*
c
CDECK  ID>, DT_XSGLAU
      SUBROUTINE DT_XSGLAU(NA,NB,JJPROJ,XI,Q2I,ECMI,IE,IQ,NIDX)

c***********************************************************************
c Total, elastic, quasi-elastic, inelastic cross sections according to *
c Glauber's approach.                                                  *
c  NA / NB     mass numbers of proj./target nuclei                     *
c  JJPROJ      bamjet-index of projectile (=1 in case of proj.nucleus) *
c  XI,Q2I,ECMI kinematical variables x, Q^2, E_cm                      *
c  IE,IQ       indices of energy and virtuality (the latter for gamma  *
c              projectiles only)                                       *
c  NIDX        index of projectile/target nucleus                      *
c This version dated 17.3.98  is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      COMPLEX*16 CZERO,CONE,CTWO
      CHARACTER*12 CFILE
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0,
     &           ONETHI=ONE/THREE,TINY25=1.0D-25)
      PARAMETER (TWOPI  = 6.283185307179586454D+00,
     &           PI     = TWOPI/TWO,
     &           GEV2MB = 0.38938D0,
     &           GEV2FM = 0.1972D0,
     &           ALPHEM = ONE/137.0D0,
c proton mass
     &           AMP    = 0.938D0,
     &           AMP2   = AMP**2,
c approx. nucleon radius
     &           RNUCLE = 1.12D0)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c parameters for hA-diffraction
      COMMON /DTDIHA/ DIBETA,DIALPH


      COMPLEX*16 PP11(MAXNCL),PP12(MAXNCL),PP21(MAXNCL),PP22(MAXNCL),
     &           OMPP11,OMPP12,OMPP21,OMPP22,
     &           DIPP11,DIPP12,DIPP21,DIPP22,AVDIPP,
     &           PPTMP1,PPTMP2
      COMPLEX*16 C,CA,CI
      DIMENSION COOP1(3,MAXNCL),COOT1(3,MAXNCL),
     &          COOP2(3,MAXNCL),COOT2(3,MAXNCL),
     &          BPROD(KSITEB)

      PARAMETER (NPOINT=16)
      DIMENSION ABSZX(NPOINT),WEIGHT(NPOINT)

      LOGICAL LFIRST,LOPEN
      DATA LFIRST,LOPEN /.TRUE.,.FALSE./

      NTARG = ABS(NIDX)
c for quasi-elastic neutrino scattering set projectile to proton
c it should not have an effect since the whole Glauber-formalism is
c not needed for these interactions..
      IF (MCGENE.EQ.4) THEN
         IJPROJ = 1
      ELSE
         IJPROJ = JJPROJ
      ENDIF


      IF ((ABS(IOGLB).EQ.1).AND.(.NOT.LOPEN)) THEN
         I = INDEX(CGLB,' ')
cc &&&&&&&&&c         
         CFILE= ' '
ccc &&&&&&
         IF (I.EQ.0) THEN
            CFILE = CGLB//'.GLB'
ccc        &&&&&&&&& kk
ccc            OPEN(LLOOK,FILE=CGLB//'.GLB',STATUS='UNKNOWN')
            call cdpmOpen(LLOOK, CFILE)
ccc
         ELSEIF (I.GT.1) THEN
            CFILE = CGLB(1:I-1)//'.GLB'
ccc         &&&&&&&&&&& KK
ccc          OPEN(LLOOK,FILE=CGLB(1:I-1)//'.GLB',STATUS='UNKNOWN')
            call cdpmOpen(LLOOK, CFILE)
ccc
         ELSE
            STOP 'XSGLAU 1'
         ENDIF
         LOPEN = .TRUE.
      ENDIF

      CZERO  = DCMPLX(ZERO,ZERO)
      CONE   = DCMPLX(ONE,ZERO)
      CTWO   = DCMPLX(TWO,ZERO)
      NEBINI = IE
      NQBINI = IQ

c re-define kinematics
      S  = ECMI**2
      Q2 = Q2I
      X  = XI
c  g(Q2=0)-A, h-A, A-A scattering
      IF ((X.LE.ZERO).AND.(Q2.LE.ZERO).AND.(S.GT.ZERO)) THEN
         Q2 = 0.0001D0
         X  = Q2/(S+Q2-AMP2)
c  g(Q2>0)-A scattering
      ELSEIF ((X.LE.ZERO).AND.(Q2.GT.ZERO).AND.(S.GT.ZERO)) THEN
         X  = Q2/(S+Q2-AMP2)
      ELSEIF ((X.GT.ZERO).AND.(Q2.LE.ZERO).AND.(S.GT.ZERO)) THEN
         Q2 = (S-AMP2)*X/(ONE-X)
      ELSEIF ((X.GT.ZERO).AND.(Q2.GT.ZERO)) THEN
         S  = Q2*(ONE-X)/X+AMP2
      ELSE
         WRITE(ErrorOut,*) 'XSGLAU: inconsistent input ',S,Q2,X
         STOP
      ENDIF
      ECMNN(IE) = SQRT(S)
      Q2G(IQ)   = Q2
      XNU = (S+Q2-AMP2)/(TWO*AMP)

c parameters determining statistics in evaluating Glauber-xsection
      NSTATB = JSTATB
      NSITEB = JBINSB
      IF (NSITEB.GT.KSITEB) NSITEB = KSITEB

c set up interaction geometry (common /DTGLAM/)
c  projectile/target radii
      RPRNCL = DT_RNCLUS(NA)
      RTANCL = DT_RNCLUS(NB)
      IF (IJPROJ.EQ.7) THEN
         RASH(1) = ZERO
         RBSH(NTARG) = RTANCL
         BMAX(NTARG) = 2.0D0*(RASH(1)+RBSH(NTARG))
      ELSE
         IF (NIDX.LE.-1) THEN
            RASH(1)     = RPRNCL
            RBSH(NTARG) = RTANCL
            BMAX(NTARG) = 2.0D0*(RASH(1)+RBSH(NTARG))
         ELSE
            RASH(NTARG) = RPRNCL
            RBSH(1)     = RTANCL
            BMAX(NTARG) = 2.0D0*(RASH(NTARG)+RBSH(1))
         ENDIF
      ENDIF
c  maximum impact-parameter
      BSTEP(NTARG)= BMAX(NTARG)/DBLE(NSITEB-1)

c slope, rho ( Re(f(0))/Im(f(0)) )
      IF ((IJPROJ.LE.12).AND.(IJPROJ.NE.7)) THEN
         IF (MCGENE.EQ.2) THEN
            ZERO1 = ZERO
            CALL DT_PHOXS(IJPROJ,1,ECMNN(IE),ZERO1,SDUM1,SDUM2,SDUM3,
     &                                                   BSLOPE,0)
         ELSE
            BSLOPE = 8.5D0*(1.0D0+0.065D0*LOG(S))
         ENDIF
         IF (ECMNN(IE).LE.3.0D0) THEN
            ROSH = -0.43D0
         ELSEIF ((ECMNN(IE).GT.3.0D0).AND.(ECMNN(IE).LE.50.D0)) THEN
            ROSH = -0.63D0+0.175D0*LOG(ECMNN(IE))
         ELSEIF (ECMNN(IE).GT.50.0D0) THEN
            ROSH = 0.1D0
         ENDIF
      ELSEIF (IJPROJ.EQ.7) THEN
         ROSH = 0.1D0
      ELSE
         BSLOPE = 6.0D0*(1.0D0+0.065D0*LOG(S))
         ROSH   = 0.01D0
      ENDIF

c projectile-nucleon xsection (in fm)
      IF (IJPROJ.EQ.7) THEN
         SIGSH = DT_SIGVP(X,Q2)/10.0D0
      ELSE
         ELAB  = (S-AAM(IJPROJ)**2-AMP2)/(TWO*AMP)
         PLAB  = SQRT( (ELAB-AAM(IJPROJ))*(ELAB+AAM(IJPROJ)) )
C        SIGSH = DT_SHNTOT(IJPROJ,1,ZERO,PLAB)/10.0D0
         DUMZER = ZERO
         CALL DT_XSHN(IJPROJ,1,PLAB,DUMZER,SIGSH,SIGEL)
         SIGSH = SIGSH/10.0D0
      ENDIF

c parameters for projectile diffraction (hA scattering only)
      IF ((MCGENE.EQ.2).AND.(NA.EQ.1).AND.(NB.GT.1).AND.(IJPROJ.NE.7)
     &                               .AND.(DIBETA.GE.ZERO)) THEN
         ZERO1 = ZERO
         CALL DT_PHOXS(IJPROJ,1,ECMNN(IE),ZERO1,STOT,SDUM2,SDIF1,BDUM,0)
C        DIBETA = SDIF1/STOT
         DIBETA = 0.2D0
         DIGAMM = SQRT(DIALPH**2+DIBETA**2)
         IF (DIBETA.LE.ZERO) THEN
            ALPGAM = ONE
         ELSE
            ALPGAM = DIALPH/DIGAMM
         ENDIF
         FACDI1 = ONE-ALPGAM
         FACDI2 = ONE+ALPGAM
         FACDI  = SQRT(FACDI1*FACDI2)
         WRITE(ErrorOut,
     * *)'DIBETA,DIALPH,DIGAMM: ',DIBETA,DIALPH,DIGAMM
      ELSE
         DIBETA = -1.0D0
         DIALPH = ZERO
         DIGAMM = ZERO
         FACDI1 = ZERO
         FACDI2 = 2.0D0
         FACDI  = ZERO
      ENDIF

c initializations
      DO 10 I=1,NSITEB
         BSITE( 0,IQ,NTARG,I) = ZERO
         BSITE(IE,IQ,NTARG,I) = ZERO
         BPROD(I) = ZERO
   10 CONTINUE
      STOT  = ZERO
      STOT2 = ZERO
      SELA  = ZERO
      SELA2 = ZERO
      SQEP  = ZERO
      SQEP2 = ZERO
      SQET  = ZERO
      SQET2 = ZERO
      SQE2  = ZERO
      SQE22 = ZERO
      SPRO  = ZERO
      SPRO2 = ZERO
      SDEL  = ZERO
      SDEL2 = ZERO
      SDQE  = ZERO
      SDQE2 = ZERO
      FACN   = ONE/DBLE(NSTATB)

      IPNT = 0
      RPNT = ZERO

c  initialize Gauss-integration for photon-proj.
      JPOINT = 1
      IF (IJPROJ.EQ.7) THEN
         IF (INTRGE(1).EQ.1) THEN
            AMLO2 = (3.0D0*AAM(13))**2
         ELSEIF (INTRGE(1).EQ.2) THEN
            AMLO2 = AAM(33)**2
         ELSE
            AMLO2 = AAM(96)**2
         ENDIF
         IF (INTRGE(2).EQ.1) THEN
            AMHI2 = S/TWO
         ELSEIF (INTRGE(2).EQ.2) THEN
            AMHI2 = S/4.0D0
         ELSE
            AMHI2 = S
         ENDIF
         AMHI20 = (ECMNN(IE)-AMP)**2
         IF (AMHI2.GE.AMHI20) AMHI2 = AMHI20
         XAMLO = LOG( AMLO2+Q2 )
         XAMHI = LOG( AMHI2+Q2 )
c*PHOJET105a
C        CALL GSET(XAMLO,XAMHI,NPOINT,ABSZX,WEIGHT)
c*PHOJET112

         CALL PHO_GAUSET(XAMLO,XAMHI,NPOINT,ABSZX,WEIGHT)

c*
         JPOINT = NPOINT
c ratio direct/total photon-nucleon xsection
         CALL DT_POILIK(NB,NTARG,ECMNN(IE),Q2,IPNT,RPNT,1)
      ENDIF

c read pre-initialized profile-function from file
      IF (IOGLB.EQ.1) THEN
         READ(LLOOK,'(5I10,E15.5)') KJPROJ,IA,IB,ISTATB,ISITEB,DUM
         IF ((IA.NE.NA).OR.(IB.NE.NB)) THEN
            WRITE(ErrorOut,1000) CFILE,IA,IB,ISTATB,ISITEB,
     &                             NA,NB,NSTATB,NSITEB
 1000       FORMAT(' XSGLAU: INCONSISTENT INPUT DATA IN FILE ',A12,/,
     &             ' (IA,IB,ISTATB,ISITEB) ',4I10,/,
     &             ' (NA,NB,NSTATB,NSITEB) ',4I10)
            STOP
         ENDIF
         IF (LFIRST) WRITE(ErrorOut,1001) CFILE
 1001    FORMAT(/,' XSGLAU: IMPACT PARAMETER DISTRIBUTION READ FROM ',
     &          'FILE ',A12,/)
         READ(LLOOK,'(6E12.5)') XSTOT(IE,IQ,NTARG),XSELA(IE,IQ,NTARG),
     &                          XSQEP(IE,IQ,NTARG),XSQET(IE,IQ,NTARG),
     &                          XSQE2(IE,IQ,NTARG),XSPRO(IE,IQ,NTARG)
         READ(LLOOK,'(6E12.5)') XETOT(IE,IQ,NTARG),XEELA(IE,IQ,NTARG),
     &                          XEQEP(IE,IQ,NTARG),XEQET(IE,IQ,NTARG),
     &                          XEQE2(IE,IQ,NTARG),XEPRO(IE,IQ,NTARG)
         NLINES = INT(DBLE(NSITEB)/7.0D0)
         IF (NLINES.GT.0) THEN
            DO 21 I=1,NLINES
               ISTART = 7*I-6
               READ(LLOOK,'(7E11.4)')
     &            (BSITE(IE,IQ,NTARG,J),J=ISTART,ISTART+6)
   21       CONTINUE
         ENDIF
         ISTART = 7*NLINES+1
         IF (ISTART.LE.NSITEB) THEN
            READ(LLOOK,'(7E11.4)')
     &         (BSITE(IE,IQ,NTARG,J),J=ISTART,NSITEB)
         ENDIF
         LFIRST = .FALSE.
         GOTO 100
c variable projectile/target/energy runs:
c read pre-initialized profile-functions from file
      ELSEIF (IOGLB.EQ.100) THEN
         CALL DT_GLBSET(IJPROJ,IINA,IINB,RRELAB,0)
         GOTO 100
      ENDIF

c cross sections averaged over NSTATB nucleon configurations
      DO 11 IS=1,NSTATB
C        IF ((NA.EQ.207).AND.(NB.EQ.207)) WRITE(LOUT,*) 'conf. ',IS
         STOTN = ZERO
         SELAN = ZERO
         SQEPN = ZERO
         SQETN = ZERO
         SQE2N = ZERO
         SPRON = ZERO
         SDELN = ZERO
         SDQEN = ZERO

         IF (NIDX.LE.-1) THEN
            CALL DT_CONUCL(COOP1,NA,RASH(1),0)
            CALL DT_CONUCL(COOT1,NB,RBSH(NTARG),1)
            IF ((.NOT.LPROD).OR.(IJPROJ.EQ.7)) THEN
               CALL DT_CONUCL(COOP2,NA,RASH(1),0)
               CALL DT_CONUCL(COOT2,NB,RBSH(NTARG),1)
            ENDIF
         ELSE
            CALL DT_CONUCL(COOP1,NA,RASH(NTARG),0)
            CALL DT_CONUCL(COOT1,NB,RBSH(1),1)
            IF ((.NOT.LPROD).OR.(IJPROJ.EQ.7)) THEN
               CALL DT_CONUCL(COOP2,NA,RASH(NTARG),0)
               CALL DT_CONUCL(COOT2,NB,RBSH(1),1)
            ENDIF
         ENDIF

c  integration over impact parameter B
         DO 12 IB=1,NSITEB-1
            STOTB = ZERO
            SELAB = ZERO
            SQEPB = ZERO
            SQETB = ZERO
            SQE2B = ZERO
            SPROB = ZERO
            SDIR  = ZERO
            SDELB = ZERO
            SDQEB = ZERO
            B     = DBLE(IB)*BSTEP(NTARG)
            FACB  = 10.0D0*TWOPI*B*BSTEP(NTARG)

c   integration over M_V^2 for photon-proj.
            DO 14 IM=1,JPOINT
               PP11(1) = CONE
               PP12(1) = CONE
               PP21(1) = CONE
               PP22(1) = CONE
               IF (IJPROJ.EQ.7) THEN
                  DO 13 K=2,NB
                     PP11(K) = CONE
                     PP12(K) = CONE
                     PP21(K) = CONE
                     PP22(K) = CONE
   13             CONTINUE
               ENDIF
               SHI  = ZERO
               FACM = ONE
               DCOH = 1.0D10

               IF (IJPROJ.EQ.7) THEN
                  AMV2 = EXP(ABSZX(IM))-Q2
                  AMV  = SQRT(AMV2)
                  IF (AMV2.LT.16.0D0) THEN
                     R = TWO
                  ELSEIF ((AMV2.GE.16.0D0).AND.(AMV2.LT.121.0D0)) THEN
                     R = 10.0D0/3.0D0
                  ELSE
                     R = 11.0D0/3.0D0
                  ENDIF
c    define M_V dependent properties of nucleon scattering amplitude
c     V_M-nucleon xsection
                  SIGMVD = RPNT*SIGSH/(AMV2+Q2+RL2)*10.0D0
                  SIGMV  = (ONE-RPNT)*SIGSH/(AMV2+Q2+RL2)
c     slope-parametrisation a la Kaidalov
                  BSLOPE = 2.0D0*(2.0D0+AAM(32)**2/(AMV2+Q2)
     &                           +0.25D0*LOG(S/(AMV2+Q2)))
c    coherence length
                  IF (ISHAD(3).EQ.1) DCOH = TWO*XNU/(AMV2+Q2)*GEV2FM
c    integration weight factor
                  FACM = ALPHEM/(3.0D0*PI*(ONE-X))*
     &                  R*AMV2/(AMV2+Q2)*(ONE+EPSPOL*Q2/AMV2)*WEIGHT(IM)
               ENDIF
               GSH = 10.0D0/(TWO*BSLOPE*GEV2MB)
               GAM = GSH
               IF (IJPROJ.EQ.7) THEN
                  RCA = GAM*SIGMV/TWOPI
               ELSE
                  RCA = GAM*SIGSH/TWOPI
               ENDIF
               FCA = -ROSH*RCA
               CA  = DCMPLX(RCA,FCA)
               CI  = CONE

               DO 15 INA=1,NA
                  KK1  = 1
                  INT1 = 1
                  KK2  = 1
                  INT2 = 1
                  DO 16 INB=1,NB
c    photon-projectile: check for supression by coherence length
                     IF (IJPROJ.EQ.7) THEN
                        IF (ABS(COOT1(3,INB)-COOT1(3,KK1)).GT.DCOH)THEN
                           KK1  = INB
                           INT1 = INT1+1
                        ENDIF
                        IF (ABS(COOT2(3,INB)-COOT2(3,KK2)).GT.DCOH)THEN
                           KK2  = INB
                           INT2 = INT2+1
                        ENDIF
                     ENDIF

                     X11 = B+COOT1(1,INB)-COOP1(1,INA)
                     Y11 =   COOT1(2,INB)-COOP1(2,INA)
                     XY11 = GAM*(X11*X11+Y11*Y11)
                     IF (XY11.LE.15.0D0) THEN
                        C = CONE-CA*EXP(-XY11)
                        AR = DBLE(PP11(INT1))
                        AI = DIMAG(PP11(INT1))
                        IF (ABS(AR).LT.TINY25) AR = ZERO
                        IF (ABS(AI).LT.TINY25) AI = ZERO
                        PP11(INT1) = DCMPLX(AR,AI)
                        PP11(INT1) = PP11(INT1)*C
                        AR  = DBLE(C)
                        AI  = DIMAG(C)
                        SHI = SHI+LOG(AR*AR+AI*AI)
                     ENDIF
                     IF ((.NOT.LPROD).OR.(IJPROJ.EQ.7)) THEN
                        X12 = B+COOT2(1,INB)-COOP1(1,INA)
                        Y12 =   COOT2(2,INB)-COOP1(2,INA)
                        XY12 = GAM*(X12*X12+Y12*Y12)
                        IF (XY12.LE.15.0D0) THEN
                           C = CONE-CA*EXP(-XY12)
                           AR = DBLE(PP12(INT2))
                           AI = DIMAG(PP12(INT2))
                           IF (ABS(AR).LT.TINY25) AR = ZERO
                           IF (ABS(AI).LT.TINY25) AI = ZERO
                           PP12(INT2) = DCMPLX(AR,AI)
                           PP12(INT2) = PP12(INT2)*C
                        ENDIF
                        X21 = B+COOT1(1,INB)-COOP2(1,INA)
                        Y21 =   COOT1(2,INB)-COOP2(2,INA)
                        XY21 = GAM*(X21*X21+Y21*Y21)
                        IF (XY21.LE.15.0D0) THEN
                           C = CONE-CA*EXP(-XY21)
                           AR = DBLE(PP21(INT1))
                           AI = DIMAG(PP21(INT1))
                           IF (ABS(AR).LT.TINY25) AR = ZERO
                           IF (ABS(AI).LT.TINY25) AI = ZERO
                           PP21(INT1) = DCMPLX(AR,AI)
                           PP21(INT1) = PP21(INT1)*C
                        ENDIF
                        X22 = B+COOT2(1,INB)-COOP2(1,INA)
                        Y22 =   COOT2(2,INB)-COOP2(2,INA)
                        XY22 = GAM*(X22*X22+Y22*Y22)
                        IF (XY22.LE.15.0D0) THEN
                           C = CONE-CA*EXP(-XY22)
                           AR = DBLE(PP22(INT2))
                           AI = DIMAG(PP22(INT2))
                           IF (ABS(AR).LT.TINY25) AR = ZERO
                           IF (ABS(AI).LT.TINY25) AI = ZERO
                           PP22(INT2) = DCMPLX(AR,AI)
                           PP22(INT2) = PP22(INT2)*C
                        ENDIF
                     ENDIF
   16             CONTINUE
   15          CONTINUE

               OMPP11 = CZERO
               OMPP21 = CZERO
               DIPP11 = CZERO
               DIPP21 = CZERO
               DO 17 K=1,INT1
                  IF (PP11(K).EQ.CZERO) THEN
                     PPTMP1 = CZERO
                     PPTMP2 = CZERO
                  ELSE
                     PPTMP1 = PP11(K)**(ONE-DIALPH-DIGAMM)
                     PPTMP2 = PP11(K)**(ONE-DIALPH+DIGAMM)
                  ENDIF
                  AVDIPP = 0.5D0*
     &                  ( FACDI1*(CONE-PPTMP1)+FACDI2*(CONE-PPTMP2) )
                  OMPP11 = OMPP11+AVDIPP
C                 OMPP11 = OMPP11+(CONE-PP11(K))
                  AVDIPP = 0.5D0*FACDI*( PPTMP1-PPTMP2 )
                  DIPP11 = DIPP11+AVDIPP
                  IF (PP21(K).EQ.CZERO) THEN
                     PPTMP1 = CZERO
                     PPTMP2 = CZERO
                  ELSE
                     PPTMP1 = PP21(K)**(ONE-DIALPH-DIGAMM)
                     PPTMP2 = PP21(K)**(ONE-DIALPH+DIGAMM)
                  ENDIF
                  AVDIPP = 0.5D0*
     &                  ( FACDI1*(CONE-PPTMP1)+FACDI2*(CONE-PPTMP2) )
                  OMPP21 = OMPP21+AVDIPP
C                 OMPP21 = OMPP21+(CONE-PP21(K))
                  AVDIPP = 0.5D0*FACDI*( PPTMP1-PPTMP2 )
                  DIPP21 = DIPP21+AVDIPP
   17          CONTINUE
               OMPP12 = CZERO
               OMPP22 = CZERO
               DIPP12 = CZERO
               DIPP22 = CZERO
               DO 18 K=1,INT2
                  IF (PP12(K).EQ.CZERO) THEN
                     PPTMP1 = CZERO
                     PPTMP2 = CZERO
                  ELSE
                     PPTMP1 = PP12(K)**(ONE-DIALPH-DIGAMM)
                     PPTMP2 = PP12(K)**(ONE-DIALPH+DIGAMM)
                  ENDIF
                  AVDIPP = 0.5D0*
     &                  ( FACDI1*(CONE-PPTMP1)+FACDI2*(CONE-PPTMP2) )
                  OMPP12 = OMPP12+AVDIPP
C                 OMPP12 = OMPP12+(CONE-PP12(K))
                  AVDIPP = 0.5D0*FACDI*( PPTMP1-PPTMP2 )
                  DIPP12 = DIPP12+AVDIPP
                  IF (PP22(K).EQ.CZERO) THEN
                     PPTMP1 = CZERO
                     PPTMP2 = CZERO
                  ELSE
                     PPTMP1 = PP22(K)**(ONE-DIALPH-DIGAMM)
                     PPTMP2 = PP22(K)**(ONE-DIALPH+DIGAMM)
                  ENDIF
                  AVDIPP = 0.5D0*
     &                  ( FACDI1*(CONE-PPTMP1)+FACDI2*(CONE-PPTMP2) )
                  OMPP22 = OMPP22+AVDIPP
C                 OMPP22 = OMPP22+(CONE-PP22(K))
                  AVDIPP = 0.5D0*FACDI*( PPTMP1-PPTMP2 )
                  DIPP22 = DIPP22+AVDIPP
   18          CONTINUE

               SPROM = ONE-EXP(SHI)
               SPROB = SPROB+FACM*SPROM
               IF ((.NOT.LPROD).OR.(IJPROJ.EQ.7)) THEN
                  STOTM = DBLE(OMPP11+OMPP22)
                  SELAM = DBLE(OMPP11*DCONJG(OMPP22))
                  SQEPM = DBLE(OMPP11*DCONJG(OMPP21))-SELAM
                  SQETM = DBLE(OMPP11*DCONJG(OMPP12))-SELAM
                  SQE2M = DBLE(OMPP11*DCONJG(OMPP11))-SELAM-SQEPM-SQETM
                  SDELM = DBLE(DIPP11*DCONJG(DIPP22))
                  SDQEM = DBLE(DIPP11*DCONJG(DIPP21))-SDELM
                  STOTB = STOTB+FACM*STOTM
                  SELAB = SELAB+FACM*SELAM
                  SDELB = SDELB+FACM*SDELM
                  IF (NB.GT.1) THEN
                     SQEPB = SQEPB+FACM*SQEPM
                     SDQEB = SDQEB+FACM*SDQEM
                  ENDIF
                  IF (NA.GT.1) SQETB = SQETB+FACM*SQETM
                  IF ((NA.GT.1).AND.(NB.GT.1)) SQE2B = SQE2B+FACM*SQE2M
                  IF (IJPROJ.EQ.7) SDIR = SDIR+FACM*SIGMVD
               ENDIF

   14       CONTINUE

            STOTN = STOTN+FACB*STOTB
            SELAN = SELAN+FACB*SELAB
            SQEPN = SQEPN+FACB*SQEPB
            SQETN = SQETN+FACB*SQETB
            SQE2N = SQE2N+FACB*SQE2B
            SPRON = SPRON+FACB*SPROB
            SDELN = SDELN+FACB*SDELB
            SDQEN = SDQEN+FACB*SDQEB

            IF (IJPROJ.EQ.7) THEN
               BPROD(IB+1)= BPROD(IB+1)+FACN*FACB*(STOTB-SELAB-SQEPB)
            ELSE
               IF (DIBETA.GT.ZERO) THEN
                  BPROD(IB+1)= BPROD(IB+1)
     &                        +FACN*FACB*(STOTB-SELAB-SQEPB-SQETB-SQE2B)
               ELSE
                  BPROD(IB+1)= BPROD(IB+1)+FACN*FACB*SPROB
               ENDIF
            ENDIF

   12    CONTINUE

         STOT  = STOT +FACN*STOTN
         STOT2 = STOT2+FACN*STOTN**2
         SELA  = SELA +FACN*SELAN
         SELA2 = SELA2+FACN*SELAN**2
         SQEP  = SQEP +FACN*SQEPN
         SQEP2 = SQEP2+FACN*SQEPN**2
         SQET  = SQET +FACN*SQETN
         SQET2 = SQET2+FACN*SQETN**2
         SQE2  = SQE2 +FACN*SQE2N
         SQE22 = SQE22+FACN*SQE2N**2
         SPRO  = SPRO +FACN*SPRON
         SPRO2 = SPRO2+FACN*SPRON**2
         SDEL  = SDEL +FACN*SDELN
         SDEL2 = SDEL2+FACN*SDELN**2
         SDQE  = SDQE +FACN*SDQEN
         SDQE2 = SDQE2+FACN*SDQEN**2

   11 CONTINUE

c final cross sections
c 1) total
      XSTOT(IE,IQ,NTARG) = STOT
      IF (IJPROJ.EQ.7)
     &   XSTOT(IE,IQ,NTARG) = XSTOT(IE,IQ,NTARG)+DBLE(NB)*SDIR
c 2) elastic
      XSELA(IE,IQ,NTARG) = SELA
c 3) quasi-el.: A+B-->A+X (excluding 2)
      XSQEP(IE,IQ,NTARG) = SQEP
c 4) quasi-el.: A+B-->X+B (excluding 2)
      XSQET(IE,IQ,NTARG) = SQET
c 5) quasi-el.: A+B-->X (excluding 2-4)
      XSQE2(IE,IQ,NTARG) = SQE2
c 6) production (= STOT-SELA-SQEP-SQET-SQE2!)
      IF (SDEL.GT.ZERO) THEN
         XSPRO(IE,IQ,NTARG) = STOT-SELA-SQEP-SQET-SQE2
      ELSE
         XSPRO(IE,IQ,NTARG) = SPRO
      ENDIF
c 7) projectile diffraction (el. scatt. off target)
      XSDEL(IE,IQ,NTARG) = SDEL
c 8) projectile diffraction (quasi-el. scatt. off target)
      XSDQE(IE,IQ,NTARG) = SDQE
c  stat. errors
      XETOT(IE,IQ,NTARG) = SQRT(ABS(STOT2-STOT**2)/DBLE(NSTATB-1))
      XEELA(IE,IQ,NTARG) = SQRT(ABS(SELA2-SELA**2)/DBLE(NSTATB-1))
      XEQEP(IE,IQ,NTARG) = SQRT(ABS(SQEP2-SQEP**2)/DBLE(NSTATB-1))
      XEQET(IE,IQ,NTARG) = SQRT(ABS(SQET2-SQET**2)/DBLE(NSTATB-1))
      XEQE2(IE,IQ,NTARG) = SQRT(ABS(SQE22-SQE2**2)/DBLE(NSTATB-1))
      XEPRO(IE,IQ,NTARG) = SQRT(ABS(SPRO2-SPRO**2)/DBLE(NSTATB-1))
      XEDEL(IE,IQ,NTARG) = SQRT(ABS(SDEL2-SDEL**2)/DBLE(NSTATB-1))
      XEDQE(IE,IQ,NTARG) = SQRT(ABS(SDQE2-SDQE**2)/DBLE(NSTATB-1))

      IF (IJPROJ.EQ.7) THEN
         BNORM = XSTOT(IE,IQ,NTARG)-XSELA(IE,IQ,NTARG)
     &          -XSQEP(IE,IQ,NTARG)
      ELSE
         BNORM = XSPRO(IE,IQ,NTARG)
      ENDIF
      DO 19 I=2,NSITEB
         BSITE(IE,IQ,NTARG,I) = BPROD(I)/BNORM+BSITE(IE,IQ,NTARG,I-1)
         IF ((IE.EQ.1).AND.(IQ.EQ.1))
     &      BSITE(0,1,NTARG,I) = BPROD(I)/BNORM+BSITE(0,1,NTARG,I-1)
   19 CONTINUE

c write profile function data into file
      IF ((IOGLB.EQ.-1).OR.(IOGLB.EQ.-100)) THEN
         WRITE(LLOOK,'(5I10,1P,E15.5)')
     &      IJPROJ,NA,NB,NSTATB,NSITEB,ECMNN(IE)
         WRITE(LLOOK,'(1P,6E12.5)')
     &      XSTOT(IE,IQ,NTARG),XSELA(IE,IQ,NTARG),XSQEP(IE,IQ,NTARG),
     &      XSQET(IE,IQ,NTARG),XSQE2(IE,IQ,NTARG),XSPRO(IE,IQ,NTARG)
         WRITE(LLOOK,'(1P,6E12.5)')
     &      XETOT(IE,IQ,NTARG),XEELA(IE,IQ,NTARG),XEQEP(IE,IQ,NTARG),
     &      XEQET(IE,IQ,NTARG),XEQE2(IE,IQ,NTARG),XEPRO(IE,IQ,NTARG)
         NLINES = INT(DBLE(NSITEB)/7.0D0)
         IF (NLINES.GT.0) THEN
            DO 20 I=1,NLINES
               ISTART = 7*I-6
               WRITE(LLOOK,'(1P,7E11.4)')
     &            (BSITE(IE,IQ,NTARG,J),J=ISTART,ISTART+6)
   20       CONTINUE
         ENDIF
         ISTART = 7*NLINES+1
         IF (ISTART.LE.NSITEB) THEN
            WRITE(LLOOK,'(1P,7E11.4)')
     &         (BSITE(IE,IQ,NTARG,J),J=ISTART,NSITEB)
         ENDIF
      ENDIF

  100 CONTINUE

C     IF (ABS(IOGLB).EQ.1) CLOSE(LLOOK)

      RETURN
      END
c
c===getbxs=============================================================*
c
CDECK  ID>, DT_GETBXS
      SUBROUTINE DT_GETBXS(XSFRAC,BLO,BHI,NIDX)

c***********************************************************************
c Biasing in impact parameter space.                                   *
c     XSFRAC = 0 :  BLO    - minimum impact parameter  (input)         *
c                   BHI    - maximum impact parameter  (input)         *
c                   XSFRAC - fraction of cross section corresponding   *
c                            to impact parameter range (BLO,BHI)       *
c                                                      (output)        *
c     XSFRAC > 0 :  XSFRAC - fraction of cross section (input)         *
c                   BHI    - maximum impact parameter giving requested *
c                            fraction of cross section in impact       *
c                            parameter range (0,BMAX)  (output)        *
c This version dated 17.03.00  is written by S. Roesler                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB


      NTARG = ABS(NIDX)
      IF (XSFRAC.LE.0.0D0) THEN
         ILO    = MIN(NSITEB-1,INT(BLO/BSTEP(NTARG)))
         IHI    = MIN(NSITEB-1,INT(BHI/BSTEP(NTARG)))
         IF (ILO.GE.IHI) THEN
            XSFRAC = 0.0D0
            RETURN
         ENDIF
         IF (ILO.EQ.NSITEB-1) THEN
            FRCLO = BSITE(0,1,NTARG,NSITEB)
         ELSE
            FRCLO = BSITE(0,1,NTARG,ILO+1)
     &              +(BLO-ILO*BSTEP(NTARG))/BSTEP(NTARG)
     &              *(BSITE(0,1,NTARG,ILO+2)-BSITE(0,1,NTARG,ILO+1))
         ENDIF
         IF (IHI.EQ.NSITEB-1) THEN
            FRCHI = BSITE(0,1,NTARG,NSITEB)
         ELSE
            FRCHI = BSITE(0,1,NTARG,IHI+1)
     &              +(BHI-IHI*BSTEP(NTARG))/BSTEP(NTARG)
     &              *(BSITE(0,1,NTARG,IHI+2)-BSITE(0,1,NTARG,IHI+1))
         ENDIF
         XSFRAC = FRCHI-FRCLO
      ELSE
         BLO = 0.0D0
         BHI = BMAX(NTARG)
         DO 1 I=1,NSITEB-1
            IF (XSFRAC.LT.BSITE(0,1,NTARG,I+1)) THEN
               FAC = (XSFRAC              -BSITE(0,1,NTARG,I))/
     &               (BSITE(0,1,NTARG,I+1)-BSITE(0,1,NTARG,I))
               BHI = DBLE(I-1)*BSTEP(NTARG)+BSTEP(NTARG)*FAC
               GOTO 2
            ENDIF
    1    CONTINUE
    2    CONTINUE
      ENDIF

      RETURN
      END
c
c===conucl=============================================================*
c
CDECK  ID>, DT_CONUCL
      SUBROUTINE DT_CONUCL(X,N,R,MODE)

c***********************************************************************
c Calculation of coordinates of nucleons within nuclei.                *
c        X(3,N)   spatial coordinates of nucleons (in fm)  (output)    *
c        N / R    number of nucleons / radius of nucleus   (input)     *
c        MODE = 0 coordinates not sorted                               *
c             = 1 coordinates sorted with increasing X(3,i)            *
c             = 2 coordinates sorted with decreasing X(3,i)            *
c This version dated 26.10.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0,
     &           ONETHI=ONE/THREE,SQRTWO=1.414213562D0)

      PARAMETER (TWOPI = 6.283185307179586454D+00 )

      PARAMETER (NSRT=10)
      DIMENSION IDXSRT(NSRT,200),ICSRT(NSRT)
      DIMENSION X(3,N),XTMP(3,220)

      CALL DT_COORDI(XTMP,IDXSRT,ICSRT,N,R)

      IF ((MODE.NE.0).AND.((N.EQ.3).OR.(N.GT.4))) THEN
         K = 0
         DO 1 I=1,NSRT
            IF (MODE.EQ.2) THEN
               ISRT = NSRT+1-I
            ELSE
               ISRT = I
            ENDIF
            K1 = K
            DO 2 J=1,ICSRT(ISRT)
               K = K+1
               X(1,K) = XTMP(1,IDXSRT(ISRT,J))
               X(2,K) = XTMP(2,IDXSRT(ISRT,J))
               X(3,K) = XTMP(3,IDXSRT(ISRT,J))
    2       CONTINUE
            IF (ICSRT(ISRT).GT.1) THEN
               I0 = K1+1
               I1 = K
               CALL DT_SORT(X,N,I0,I1,MODE)
            ENDIF
    1    CONTINUE
      ELSEIF ((MODE.NE.0).AND.((N.EQ.2).OR.(N.EQ.4))) THEN
         DO 3 I=1,N
            X(1,I) = XTMP(1,I)
            X(2,I) = XTMP(2,I)
            X(3,I) = XTMP(3,I)
    3    CONTINUE
         CALL DT_SORT(X,N,1,N,MODE)
      ELSE
         DO 4 I=1,N
            X(1,I) = XTMP(1,I)
            X(2,I) = XTMP(2,I)
            X(3,I) = XTMP(3,I)
    4    CONTINUE
      ENDIF

      RETURN
      END
c
c===coordi=============================================================*
c
CDECK  ID>, DT_COORDI
      SUBROUTINE DT_COORDI(X,IDXSRT,ICSRT,N,R)

c***********************************************************************
c Calculation of coordinates of nucleons within nuclei.                *
c        X(3,N)   spatial coordinates of nucleons (in fm)  (output)    *
c        N / R    number of nucleons / radius of nucleus   (input)     *
c Based on the original version by Shmakov et al.                      *
c This version dated 26.10.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0,
     &           ONETHI=ONE/THREE,SQRTWO=1.414213562D0)

      PARAMETER (TWOPI = 6.283185307179586454D+00 )

      LOGICAL LSTART

      PARAMETER (NSRT=10)
      DIMENSION IDXSRT(NSRT,200),ICSRT(NSRT)
      DIMENSION X(3,220),WD(4),RD(3)

      DATA PDIF/0.545D0/,R2MIN/0.16D0/
      DATA WD / 0.0D0, 0.178D0, 0.465D0, 1.0D0/
      DATA RD /2.09D0, 0.935D0, 0.697D0/

      X1SUM = ZERO
      X2SUM = ZERO
      X3SUM = ZERO

      IF (N.EQ.1) THEN
         X(1,1) = ZERO
         X(2,1) = ZERO
         X(3,1) = ZERO
      ELSEIF (N.EQ.2) THEN
         EPS = DT_RNDM(RD(1))
         DO 30 I=1,3
            IF ((EPS.GE.WD(I)).AND.(EPS.LE.WD(I+1))) GOTO 40
   30    CONTINUE
   40    CONTINUE
         DO 50 J=1,3
            CALL DT_RANNOR(X1,X2)
            X(J,1) = RD(I)*X1
            X(J,2) = -X(J,1)
   50    CONTINUE
      ELSEIF ((N.EQ.3).OR.(N.EQ.4)) THEN
         SIGMA = R/SQRTWO
         LSTART = .TRUE.
         CALL DT_RANNOR(X3,X4)
         DO 100 I=1,N
            CALL DT_RANNOR(X1,X2)
            X(1,I) = SIGMA*X1
            X(2,I) = SIGMA*X2
            IF (LSTART) GOTO 80
            X(3,I) = SIGMA*X4
            CALL DT_RANNOR(X3,X4)
            GOTO 90
   80       CONTINUE
            X(3,I) = SIGMA*X3
   90       CONTINUE
            LSTART = .NOT.LSTART
            X1SUM = X1SUM+X(1,I)
            X2SUM = X2SUM+X(2,I)
            X3SUM = X3SUM+X(3,I)
  100    CONTINUE
         X1SUM = X1SUM/DBLE(N)
         X2SUM = X2SUM/DBLE(N)
         X3SUM = X3SUM/DBLE(N)
         DO 101 I=1,N
            X(1,I) = X(1,I)-X1SUM
            X(2,I) = X(2,I)-X2SUM
            X(3,I) = X(3,I)-X3SUM
  101    CONTINUE
      ELSE

c maximum nuclear radius for coordinate sampling
         RMAX = R+4.605D0*PDIF

c initialize pre-sorting
         DO 121 I=1,NSRT
            ICSRT(I) = 0
  121    CONTINUE
         DR = TWO*RMAX/DBLE(NSRT)

c sample coordinates for N nucleons
         DO 140 I=1,N
  120       CONTINUE
            RAD = RMAX*(DT_RNDM(DR))**ONETHI
            F   = DT_DENSIT(N,RAD,R)
            IF (DT_RNDM(RAD).GT.F) GOTO 120
c   theta, phi uniformly distributed
            CT  = ONE-TWO*DT_RNDM(F)
            ST  = SQRT((ONE-CT)*(ONE+CT))
            CALL DT_DSFECF(SFE,CFE)
            X(1,I) = RAD*ST*CFE
            X(2,I) = RAD*ST*SFE
            X(3,I) = RAD*CT
c   ensure that distance between two nucleons is greater than R2MIN
            IF (I.LT.2) GOTO 122
            I1 = I-1
            DO 130 I2=1,I1
               DIST2 = (X(1,I)-X(1,I2))**2+(X(2,I)-X(2,I2))**2+
     &                 (X(3,I)-X(3,I2))**2
               IF (DIST2.LE.R2MIN) GOTO 120
  130       CONTINUE
  122       CONTINUE
c   save index according to z-bin
            IDXZ        = INT( (X(3,I)+RMAX)/DR )+1
            ICSRT(IDXZ) = ICSRT(IDXZ)+1
            IDXSRT(IDXZ,ICSRT(IDXZ)) = I
            X1SUM = X1SUM+X(1,I)
            X2SUM = X2SUM+X(2,I)
            X3SUM = X3SUM+X(3,I)
  140    CONTINUE
         X1SUM = X1SUM/DBLE(N)
         X2SUM = X2SUM/DBLE(N)
         X3SUM = X3SUM/DBLE(N)
         DO 141 I=1,N
            X(1,I) = X(1,I)-X1SUM
            X(2,I) = X(2,I)-X2SUM
            X(3,I) = X(3,I)-X3SUM
  141    CONTINUE

      ENDIF

      RETURN
      END
c
c===densit=============================================================*
c
CDECK  ID>, DT_DENSIT
      DOUBLE PRECISION FUNCTION DT_DENSIT(NA,R,RA)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI = 6.283185307179586476925286766559D+00,
     &           PI    = TWOPI/TWO)

      DIMENSION R0(18),FNORM(18)
      DATA R0 /  ZERO,   ZERO,   ZERO,   ZERO, 2.12D0,
     &         2.56D0, 2.41D0, 2.46D0, 2.52D0, 2.45D0,
     &         2.37D0, 2.46D0, 2.44D0, 2.54D0, 2.58D0,
     &         2.72D0, 2.66D0, 2.79D0/
      DATA FNORM /.1000D+01,.1000D+01,.1000D+01,.1000D+01,.1000D+01,
     &            .1000D+01,.1000D+01,.1000D+01,.1000D+01,.1000D+01,
     &            .1012D+01,.1039D+01,.1075D+01,.1118D+01,.1164D+01,
     &            .1214D+01,.1265D+01,.1318D+01/
      DATA PDIF /0.545D0/

      DT_DENSIT = ZERO
c shell model
      IF (NA.LE.4) THEN
         STOP 'DT_DENSIT-0'
      ELSEIF ((NA.GT.4).AND.(NA.LE.18)) THEN
         R1 = R0(NA)/SQRT(2.5D0-4.0D0/DBLE(NA))
         DT_DENSIT = (ONE+(DBLE(NA)-4.0D0)/6.0D0*(R/R1)**2)
     &            *EXP(-(R/R1)**2)/FNORM(NA)
c Woods-Saxon
      ELSEIF (NA.GT.18) THEN
         DT_DENSIT = ONE/(ONE+EXP((R-RA)/PDIF))
      ENDIF

      RETURN
      END
c
c===rnclus=============================================================*
c
CDECK  ID>, DT_RNCLUS
      DOUBLE PRECISION FUNCTION DT_RNCLUS(N)

c***********************************************************************
c Nuclear radius for nucleus with mass number N.                       *
c This version dated 26.9.00  is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (ONE=1.0D0,THREE=3.0D0,ONETHI=ONE/THREE)

c nucleon radius
      PARAMETER (RNUCLE = 1.12D0)

c nuclear radii for selected nuclei
      DIMENSION RADNUC(18)
      DATA RADNUC / 8*0.0D0,2.52D0,2.45D0,2.37D0,2.45D0,2.44D0,2.55D0,
     &               2.58D0,2.71D0,2.66D0,2.71D0/

      IF (N.LE.18) THEN
         IF (RADNUC(N).GT.0.0D0) THEN
            DT_RNCLUS = RADNUC(N)
         ELSE
            DT_RNCLUS = RNUCLE*DBLE(N)**ONETHI
         ENDIF
      ELSE
         DT_RNCLUS = RNUCLE*DBLE(N)**ONETHI
      ENDIF

      RETURN
      END
c
c===dentst=============================================================*
c
C      PROGRAM DT_DENTST
CDECK  ID>, DT_DENTST
      SUBROUTINE DT_DENTST

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      OPEN(40,FILE='DENTST.OUT',STATUS='UNKNOWN')
      OPEN(41,FILE='DENMAX.OUT',STATUS='UNKNOWN')

      RMIN  = 0.0D0
      RMAX  = 8.0D0
      NBINS = 500.0D0
      DR    = (RMAX-RMIN)/DBLE(NBINS)
      DO 1 IA=5,18
         FMAX = 0.0D0
         DO 2 IR=1,NBINS+1
            R = RMIN+DBLE(IR-1)*DR
            F = DT_DENSIT(IA,R,R)
            IF (F.GT.FMAX) FMAX = F
            WRITE(40,'(1X,I3,2E15.5)') IA,R,F
    2    CONTINUE
         WRITE(41,'(1X,I3,E15.5)') IA,FMAX
    1 CONTINUE

      CLOSE(40)
      CLOSE(41)

      END
c
c===shmaki=============================================================*
c
CDECK  ID>, DT_SHMAKI
      SUBROUTINE DT_SHMAKI(NA,NCA,NB,NCB,IJP,PPN,MODE)

c***********************************************************************
c Initialisation of Glauber formalism. This subroutine has to be       *
c called once (in case of target emulsions as often as many different  *
c target nuclei are considered) before events are sampled.             *
c         NA / NCA   mass number/charge of projectile nucleus          *
c         NB / NCB   mass number/charge of target     nucleus          *
c         IJP        identity of projectile (hadrons/leptons/photons)  *
c         PPN        projectile momentum (for projectile nuclei:       *
c                    momentum per nucleon) in target rest system       *
c         MODE = 0   Glauber formalism invoked                         *
c              = 1   fitted results are loaded from data-file          *
c              = 99  NTARG is forced to be 1                           *
c                    (used in connection with GLAUBERI-card only)      *
c This version dated 22.03.96 is based on the original SHMAKI-routine  *
c and revised by S. Roesler.                                           *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0,
     &           THREE=3.0D0)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c kinematical cuts for lepton-nucleus interactions
      COMMON /DTLCUT/ ECMIN,ECMAX,XBJMIN,ELMIN,EGMIN,EGMAX,YMIN,YMAX,
     &                Q2MIN,Q2MAX,THMIN,THMAX,Q2LI,Q2HI,ECMLI,ECMHI

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c cuts for variable energy runs
      COMMON /DTVARE/ VARELO,VAREHI,VARCLO,VARCHI

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD


      DATA NTARG,ICOUT,IVEOUT /0,0,0/

C     CALL DT_HISHAD
C     STOP

      NTARG = NTARG+1
      IF (MODE.EQ.99) NTARG = 1
      NIDX = -NTARG
      IF (MODE.EQ.-1) NIDX = NTARG

      IF ((ICOUT.LT.15).AND.(MCGENE.NE.4)) ICOUT = ICOUT+1
      IF (ICOUT.EQ.1) WRITE(ErrorOut,1000)
 1000    FORMAT(//,1X,'SHMAKI:    GLAUBER FORMALISM (SHMAKOV ET. AL) -',
     &          ' INITIALIZATION',/,12X,'--------------------------',
     &          '-------------------------',/)

      IF (MODE.EQ.2) THEN
         CALL DT_XSGLAU(NA,NB,IJP,ZERO,VIRT,UMO,1,1,NIDX)
         CALL DT_SHFAST(MODE,PPN,IBACK)
         STOP ' GLAUBER PRE-INITIALIZATION DONE'
      ENDIF
      IF (MODE.EQ.1) THEN
         CALL DT_PROFBI(NA,NB,PPN,NTARG)
      ELSE
         IBACK = 1
         IF (MODE.EQ.3)  CALL DT_SHFAST(MODE,PPN,IBACK)
         IF (IBACK.EQ.1) THEN
c lepton-nucleus (variable energy runs)
            IF ((IJP.EQ. 3).OR.(IJP.EQ. 4).OR.
     &          (IJP.EQ.10).OR.(IJP.EQ.11))   THEN
               IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &            WRITE(ErrorOut,1002) NB,NCB
 1002          FORMAT(1X,'VARIABLE ENERGY RUN:     PROJECTILE-ID:  7',
     &                '    TARGET A/Z: ',I3,' /',I3,/,/,8X,
     &                'E_CM (GEV)    Q^2 (GEV^2)',
     &                '    SIGMA_TOT (MB)     SIGMA_IN (MB)',/,7X,
     &                '--------------------------------',
     &                '------------------------------')
               AECMLO = LOG10(MIN(UMO,ECMLI))
               AECMHI = LOG10(MIN(UMO,ECMHI))
               IESTEP = NEB-1
               DAECM  = (AECMHI-AECMLO)/DBLE(IESTEP)
               IF (AECMLO.EQ.AECMHI) IESTEP = 0
               DO 1 I=1,IESTEP+1
                  ECM = 10.0D0**(AECMLO+DBLE(I-1)*DAECM)
                  IF (Q2HI.GT.0.1D0) THEN
                     IF (Q2LI.LT.0.01D0) THEN
                        CALL DT_XSGLAU(NA,NB,7,ZERO,ZERO,ECM,I,1,NIDX)
                        IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &                     WRITE(ErrorOut,1003)
     &                  ECMNN(I),ZERO,XSTOT(I,1,NTARG),XSPRO(I,1,NTARG)
                        Q2LI = 0.01D0
                        IBIN = 2
                     ELSE
                        IBIN = 1
                     ENDIF
                     IQSTEP = NQB-IBIN
                     AQ2LO  = LOG10(Q2LI)
                     AQ2HI  = LOG10(Q2HI)
                     DAQ2   = (AQ2HI-AQ2LO)/MAX(DBLE(IQSTEP),ONE)
                     DO 2 J=IBIN,IQSTEP+IBIN
                        Q2 = 10.0D0**(AQ2LO+DBLE(J-IBIN)*DAQ2)
                        CALL DT_XSGLAU(NA,NB,7,ZERO,Q2,ECM,I,J,NIDX)
                        IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &                     WRITE(ErrorOut,1003) ECMNN(I),
     &                     Q2G(J),XSTOT(I,J,NTARG),XSPRO(I,J,NTARG)
    2                CONTINUE
                  ELSE
                     CALL DT_XSGLAU(NA,NB,7,ZERO,ZERO,ECM,I,1,NIDX)
                     IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &                  WRITE(ErrorOut,1003)
     &                  ECMNN(I),ZERO,XSTOT(I,1,NTARG),XSPRO(I,1,NTARG)
                  ENDIF
 1003             FORMAT(9X,F6.1,9X,F6.2,8X,F8.3,11X,F8.3)
    1          CONTINUE
               IVEOUT = 1
            ELSE
c hadron/photon/nucleus-nucleus
               IF ((ABS(VAREHI).GT.ZERO).AND.
     &             (ABS(VAREHI).GT.ABS(VARELO))) THEN
                  IF ((ICOUT.LT.15).AND.(MCGENE.NE.4)) THEN
                     WRITE(ErrorOut,1004) NA,NB,NCB
 1004                FORMAT(1X,'VARIABLE ENERGY RUN:    PROJECTILE-ID:',
     &                      I3,'    TARGET A/Z: ',I3,' /',I3,/)
                     WRITE(ErrorOut,1005)
 1005                FORMAT('  E_CM (GEV)  E_LAB (GEV)  SIG_TOT^PP (MB)'
     &                      ,'  SIGMA_TOT (MB)  SIGMA_PROD (MB)',/,
     &                      ' -------------------------------------',
     &                      '--------------------------------------')
                  ENDIF
                  AECMLO = LOG10(VARCLO)
                  AECMHI = LOG10(VARCHI)
                  IESTEP = NEB-1
                  DAECM = (AECMHI-AECMLO)/DBLE(IESTEP)
                  IF (AECMLO.EQ.AECMHI) IESTEP = 0
                  DO 3 I=1,IESTEP+1
                     ECM = 10.0D0**(AECMLO+DBLE(I-1)*DAECM)
                     AMP = 0.938D0
                     AMT = 0.938D0
                     AMP2 = AMP**2
                     AMT2 = AMT**2
                     ELAB = (ECM**2-AMP2-AMT2)/(TWO*AMT)
                     PLAB = SQRT((ELAB+AMP)*(ELAB-AMP))
                     CALL DT_XSGLAU(NA,NB,IJP,ZERO,VIRT,ECM,I,1,NIDX)
                     IF ((ICOUT.LT.15).AND.(MCGENE.NE.4))
     &                 WRITE(ErrorOut,1006)
     &                 ECM,PLAB,SIGSH,XSTOT(I,1,NTARG),XSPRO(I,1,NTARG)
 1006             FORMAT(1X,F9.1,1X,E11.3,1X,F12.2,8X,F10.3,8X,F8.3)
    3             CONTINUE
                  IVEOUT = 1
               ELSE
                  CALL DT_XSGLAU(NA,NB,IJP,ZERO,VIRT,UMO,1,1,NIDX)
               ENDIF
            ENDIF
         ENDIF
      ENDIF

      IF ((ICOUT.LT.15).AND.(IVEOUT.EQ.0).AND.(MCGENE.NE.4).AND.
     &    (IOGLB.NE.100)) THEN
         WRITE(ErrorOut,
     * 1001) NA,NCA,NB,NCB,ECMNN(1),SIGSH*10.0D0,ROSH,
     &                    BSLOPE,NSITEB,NSTATB,XSPRO(1,1,NTARG)
 1001    FORMAT(38X,'PROJECTILE',
     &          '      TARGET',/,1X,'MASS NUMBER / CHARGE',
     &          17X,I3,' /',I3,6X,I3,' /',I3,/,/,1X,
     &          'NUCLEON-NUCLEON C.M. ENERGY',9X,F10.2,' GEV',/,/,1X,
     &          'PARAMETERS OF ELASTIC SCATTERING AMPLITUDE:',/,5X,
     &          'SIGMA =',F7.2,' MB',6X,'RHO = ',F9.4,6X,'SLOPE = ',
     &          F4.1,' GEV^-2',/,/,1X,'NUMBER OF B-STEPS',4X,I3,8X,
     &          'STATISTICS AT EACH B-STEP',4X,I5,/,/,1X,
     &          'PROD. CROSS SECTION  ',5X,F10.4,' MB',/)
      ENDIF

      RETURN
      END
c
c===profbi=============================================================*
c
CDECK  ID>, DT_PROFBI
      SUBROUTINE DT_PROFBI(NA,NB,PPN,NTARG)

c***********************************************************************
c Integral over profile function (to be used for impact-parameter      *
c sampling during event generation).                                   *
c Fitted results are used.                                             *
c         NA / NB    mass numbers of proj./target nuclei               *
c         PPN        projectile momentum (for projectile nuclei:       *
c                    momentum per nucleon) in target rest system       *
c         NTARG      index of target material (i.e. kind of nucleus)   *
c This version dated 31.05.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)


      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0,THREE=3.0D0)

      LOGICAL LSTART
      CHARACTER CNAME*80

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI


      PARAMETER (NGLMAX=8000)
      DIMENSION NGLIT(NGLMAX),NGLIP(NGLMAX),GLAPPN(NGLMAX),
     &          GLASIG(NGLMAX),GLAFIT(5,NGLMAX)

      DATA LSTART /.TRUE./

      IF (LSTART) THEN
c read fit-parameters from file
         OPEN(47,FILE='INPDATA/GLPARA.DAT',STATUS='UNKNOWN')
         I = 0
    1    CONTINUE
         READ(47,'(A80)') CNAME
         IF (CNAME.EQ.'STOP') GOTO 2
         I = I+1
         READ(CNAME,*) NGLIP(I),NGLIT(I),GLAPPN(I),GLASIG(I),
     &                 GLAFIT(1,I),GLAFIT(2,I),GLAFIT(3,I),
     &                 GLAFIT(4,I),GLAFIT(5,I)
         IF (I+1.GT.NGLMAX) THEN
            WRITE(ErrorOut,1000)
 1000       FORMAT(1X,'PROFBI:    WARNING! ARRAY SIZE EXCEEDED - ',
     &             'PROGRAM STOPPED')
            STOP
         ENDIF
         GOTO 1
    2    CONTINUE
         NGLPAR = I
         LSTART = .FALSE.
      ENDIF

      NNA = NA
      NNB = NB
      IF (NA.GT.NB) THEN
         NNA = NB
         NNB = NA
      ENDIF
      IDXGLA = 0
      DO 3 J=1,NGLPAR
         IF ((NNB.LT.NGLIT(J)).OR.(J.EQ.NGLPAR)) THEN
            IF (NNB.NE.NGLIT(J-1)) NNB = NGLIT(J-1)
            DO 4 K=1,J-1
               IPOINT = J-K
               IF (J.EQ.NGLPAR) IPOINT = J+1-K
               IF ((NNA.GT.NGLIP(IPOINT)).OR.
     &             (NNB.NE.NGLIT(IPOINT)).OR.(IPOINT.EQ.1)) THEN
                  IF (IPOINT.EQ.1) IPOINT = 0
                  NATMP = NGLIP(IPOINT+1)
                  IF (PPN.LT.GLAPPN(IPOINT+1)) THEN
                     IDXGLA = IPOINT+1
                     GOTO 6
                  ELSE
                     J1BEG = IPOINT+1
                     J1END = J
C                    IF (J.EQ.NGLPAR) THEN
C                       J1BEG = IPOINT
C                       J1END = J
C                    ENDIF
                     DO 5 J1=J1BEG,J1END
                        IF (NGLIP(J1).EQ.NATMP) THEN
                           IF (PPN.LT.GLAPPN(J1)) THEN
                              IDXGLA = J1
                              GOTO 6
                           ENDIF
                        ELSE
                           IDXGLA = J1-1
                           GOTO 6
                        ENDIF
    5                CONTINUE
                     IF ((J.EQ.NGLPAR).AND.(PPN.GT.GLAPPN(NGLPAR)))
     &                  IDXGLA = NGLPAR
                  ENDIF
               ENDIF
    4       CONTINUE
         ENDIF
    3 CONTINUE

    6 CONTINUE
      IF (IDXGLA.EQ.0) THEN
         WRITE(ErrorOut,1001) NNA,NNB,PPN
 1001    FORMAT(1X,'PROFBI:   CONFIGURATION (NA,NB,PPN = ',
     &          2I4,F6.0,') NOT FOUND ')
         STOP
      ENDIF

c no interpolation yet available
      XSPRO(1,1,NTARG) = GLASIG(IDXGLA)

      BSITE(1,1,NTARG,1) = ZERO
      DO 10 I=2,NSITEB
         XX = DBLE(I)
         POLY  = GLAFIT(1,IDXGLA)+GLAFIT(2,IDXGLA)*XX+
     &           GLAFIT(3,IDXGLA)*XX**2+GLAFIT(4,IDXGLA)*XX**3+
     &           GLAFIT(5,IDXGLA)*XX**4
         IF (ABS(POLY).GT.35.0D0) POLY = SIGN(35.0D0,POLY)
         BSITE(1,1,NTARG,I) = (1.0D0-EXP(-POLY))
         IF (BSITE(1,1,NTARG,I).LT.ZERO) BSITE(1,1,NTARG,I) = ZERO
   10 CONTINUE

      RETURN
      END
c
c===glaube=============================================================*
c
CDECK  ID>, DT_GLAUBE
      SUBROUTINE DT_GLAUBE(NA,NB,IJPROJ,B,INTT,INTA,INTB,JS,JT,NIDX)

c***********************************************************************
c Calculation of configuartion of interacting nucleons for one event.  *
c    NB / NB    mass numbers of proj./target nuclei           (input)  *
c    B          impact parameter                              (output) *
c    INTT       total number of wounded nucleons                       *
c    INTA / INTB number of wounded nucleons in proj. / target          *
c    JS / JT(i) number of collisions proj. / target nucleon i is       *
c                                                   involved  (output) *
c    NIDX       index of projectile/target material             (input)*
c This is an update of the original routine SHMAKO by J.Ranft/HJM      *
c This version dated 22.03.96 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY14=1.0D-14,
     &           ZERO=0.0D0,ONE=1.0D0,TWO=2.0D0)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c Lorentz-parameters of the current interaction
      COMMON /DTLTRA/ GACMS(2),BGCMS(2),GALAB,BGLAB,BLAB,
     &                UMO,PPCM,EPROJ,PPROJ

c properties of photon/lepton projectiles
      COMMON /DTGPRO/ VIRT,PGAMM(4),PLEPT0(4),PLEPT1(4),PNUCL(4),IDIREC

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD


      DIMENSION JS(MAXNCL),JT(MAXNCL)

      NTARG = ABS(NIDX)

c get actual energy from /DTLTRA/
      ECMNOW = UMO
      Q2     = VIRT
c
c new patch for pre-initialized variable projectile/target/energy runs
      IF (IOGLB.EQ.100) THEN
         CALL DT_GLBSET(IJPROJ,NA,NB,EPROJ,1)
c
c variable energy run, interpolate profile function
      ELSE
         I1   = 1
         I2   = 1
         RATE = ONE
         IF (NEBINI.GT.1) THEN
            IF (ECMNOW.GE.ECMNN(NEBINI)) THEN
               I1   = NEBINI
               I2   = NEBINI
               RATE = ONE
            ELSEIF (ECMNOW.GT.ECMNN(1)) THEN
               DO 1 I=2,NEBINI
                  IF (ECMNOW.LT.ECMNN(I)) THEN
                     I1   = I-1
                     I2   = I
                     RATE = (ECMNOW-ECMNN(I1))/(ECMNN(I2)-ECMNN(I1))
                     GOTO 2
                  ENDIF
    1          CONTINUE
    2          CONTINUE
            ENDIF
         ENDIF
         J1   = 1
         J2   = 1
         RATQ = ONE
         IF (NQBINI.GT.1) THEN
            IF (Q2.GE.Q2G(NQBINI)) THEN
               J1   = NQBINI
               J2   = NQBINI
               RATQ = ONE
            ELSEIF (Q2.GT.Q2G(1)) THEN
               DO 3 I=2,NQBINI
                  IF (Q2.LT.Q2G(I)) THEN
                     J1   = I-1
                     J2   = I
                     RATQ = LOG10(     Q2/MAX(Q2G(J1),TINY14))/
     &                      LOG10(Q2G(J2)/MAX(Q2G(J1),TINY14))
C                    RATQ = (Q2-Q2G(J1))/(Q2G(J2)-Q2G(J1))
                     GOTO 4
                  ENDIF
    3          CONTINUE
    4          CONTINUE
            ENDIF
         ENDIF

         DO 5 I=1,KSITEB
            BSITE(0,1,NTARG,I) = BSITE(I1,J1,NTARG,I)+
     &         RATE*(BSITE(I2,J1,NTARG,I)-BSITE(I1,J1,NTARG,I))+
     &         RATQ*(BSITE(I1,J2,NTARG,I)-BSITE(I1,J1,NTARG,I))+
     &         RATE*RATQ*(BSITE(I2,J2,NTARG,I)-BSITE(I1,J2,NTARG,I)+
     &                    BSITE(I1,J1,NTARG,I)-BSITE(I2,J1,NTARG,I))
    5    CONTINUE
      ENDIF

      CALL DT_DIAGR(NA,NB,IJPROJ,B,JS,JT,INTT,INTA,INTB,IDIREC,NIDX)
C&&&&&&&&&&&&&&&&&& KK
      if(B .eq. -1.) return
C&&&&&&&&&&&&&&&
      IF (NIDX.LE.-1) THEN
         RPROJ = RASH(1)
         RTARG = RBSH(NTARG)
      ELSE
         RPROJ = RASH(NTARG)
         RTARG = RBSH(1)
      ENDIF

      RETURN
      END
c
c===diagr==============================================================*
c
CDECK  ID>, DT_DIAGR
      SUBROUTINE DT_DIAGR(NA,NB,IJPROJ,B,JS,JT,JNT,INTA,INTB,IDIREC,
     &                                                         NIDX)

c***********************************************************************
c Based on the original version by Shmakov et al.                      *
c This version dated 21.04.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0)
      PARAMETER (TWOPI  = 6.283185307179586454D+00,
     &           PI     = TWOPI/TWO,
     &           GEV2MB = 0.38938D0,
     &           GEV2FM = 0.1972D0,
     &           ALPHEM = ONE/137.0D0,
c proton mass
     &           AMP    = 0.938D0,
     &           AMP2   = AMP**2,
c rho0 mass
     &           AMRHO0 = 0.77D0)

      COMPLEX*16 C,CA,CI

      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c*PHOJET105a
C     COMMON /CUTOFF/ PTCUT(4),CUTMU(4),FPS(4),FPH(4),PSOMIN,XSOMIN
c*PHOJET112
C  obsolete cut-off information
      DOUBLE PRECISION PTCUT,PTANO,FPS,FPH,PSOMIN,XSOMIN
      COMMON /POCUT1/ PTCUT(4),PTANO(4),FPS(4),FPH(4),PSOMIN,XSOMIN

c*
c coordinates of nucleons
      COMMON /DTNUCO/ PKOO(3,MAXNCL),TKOO(3,MAXNCL)

c interface between Glauber formalism and DPM
      COMMON /DTGLIF/ JSSH(MAXNCL),JTSH(MAXNCL),
     &                INTER1(MAXINT),INTER2(MAXINT)

c statistics: Glauber-formalism
      COMMON /DTSTA3/ ICWP,ICWT,NCSY,ICWPG,ICWTG,ICIG,IPGLB,ITGLB,NGLB

c n-n cross section fluctuations
      PARAMETER (NBINS = 1000)
      COMMON /DTXSFL/ FLUIXX(NBINS),IFLUCT


      DIMENSION JS(MAXNCL),JT(MAXNCL),
     &          JS0(MAXNCL),JT0(MAXNCL,MAXNCL),
     &          JI1(MAXNCL,MAXNCL),JI2(MAXNCL,MAXNCL),JNT0(MAXNCL)
      DIMENSION NWA(0:210),NWB(0:210)

      LOGICAL LFIRST
      DATA LFIRST /.TRUE./

      DATA NTARGO,ICNT /0,0/

      NTARG = ABS(NIDX)

      IF (LFIRST) THEN
         LFIRST = .FALSE.
         IF (NCOMPO.EQ.0) THEN
            NCALL  = 0
            NWAMAX = NA
            NWBMAX = NB
            DO 17 I=0,210
               NWA(I) = 0
               NWB(I) = 0
   17       CONTINUE
         ENDIF
      ENDIF
      IF (NTARG.EQ.-1) THEN
         IF (NCOMPO.EQ.0) THEN
            WRITE(ErrorOut,
     * *) ' DIAGR: distribution of wounded nucleons'
            WRITE(ErrorOut,
     * '(8X,A,3I7)') 'NCALL,NWAMAX,NWBMAX = ',
     &                                NCALL,NWAMAX,NWBMAX
            DO 18 I=1,MAX(NWAMAX,NWBMAX)
               WRITE(ErrorOut,'(8X,2I7,E12.4,I7,E12.4)')
     &                          I,NWA(I),DBLE(NWA(I))/DBLE(NCALL),
     &                            NWB(I),DBLE(NWB(I))/DBLE(NCALL)
   18       CONTINUE
         ENDIF
         RETURN
      ENDIF

      DCOH   = 1.0D10
      IPNT   = 0

      SQ2  = Q2
      IF (SQ2.LE.ZERO) SQ2 = 0.0001D0
      S   = ECMNOW**2
      X   = SQ2/(S+SQ2-AMP2)
      XNU = (S+SQ2-AMP2)/(TWO*AMP)
c photon projectiles: recalculate photon-nucleon amplitude
      IF (IJPROJ.EQ.7) THEN
   15    CONTINUE
c  VDM assumption: mass of V-meson
         AMV2   = DT_SAM2(SQ2,ECMNOW)
         AMV    = SQRT(AMV2)
         IF (AMV.GT.2.0D0*PTCUT(1)) GOTO 15
c  check for pointlike interaction
         CALL DT_POILIK(NB,NTARG,ECMNOW,SQ2,IPNT,RPNT,1)
c*sr 27.10.
C        SIGSH  = DT_SIGVP(X,SQ2)/(AMV2+SQ2+RL2)/10.0D0
         SIGSH  = (ONE-RPNT)*DT_SIGVP(X,SQ2)/(AMV2+SQ2+RL2)/10.0D0
c*
         ROSH   = 0.1D0
         BSLOPE = 2.0D0*(2.0D0+AMRHO0**2/(AMV2+SQ2)
     &                   +0.25D0*LOG(S/(AMV2+SQ2)))
c  coherence length
         IF (ISHAD(3).EQ.1) DCOH = TWO*XNU/(AMV2+SQ2)*GEV2FM
      ELSEIF ((IJPROJ.LE.12).AND.(IJPROJ.NE.7)) THEN
         IF (MCGENE.EQ.2) THEN
            ZERO1 = ZERO
            CALL DT_PHOXS(IJPROJ,1,ECMNOW,ZERO1,SDUM1,SDUM2,SDUM3,
     &                                                BSLOPE,0)
         ELSE
            BSLOPE = 8.5D0*(1.0D0+0.065D0*LOG(S))
         ENDIF
         IF (ECMNOW.LE.3.0D0) THEN
            ROSH = -0.43D0
         ELSEIF ((ECMNOW.GT.3.0D0).AND.(ECMNOW.LE.50.D0)) THEN
            ROSH = -0.63D0+0.175D0*LOG(ECMNOW)
         ELSEIF (ECMNOW.GT.50.0D0) THEN
            ROSH = 0.1D0
         ENDIF
         ELAB = (S-AAM(IJPROJ)**2-AMP2)/(TWO*AMP)
         PLAB = SQRT( (ELAB-AAM(IJPROJ))*(ELAB+AAM(IJPROJ)) )
         IF (MCGENE.EQ.2) THEN
            ZERO1 = ZERO
            CALL DT_PHOXS(IJPROJ,1,ECMNOW,ZERO1,SIGSH,SDUM2,SDUM3,
     &                                                  BDUM,0)
            SIGSH = SIGSH/10.0D0
         ELSE
C           SIGSH = DT_SHNTOT(IJPROJ,1,ZERO,PLAB)/10.0D0
            DUMZER = ZERO
            CALL DT_XSHN(IJPROJ,1,PLAB,DUMZER,SIGSH,SIGEL)
            SIGSH = SIGSH/10.0D0
         ENDIF
      ELSE
         BSLOPE = 6.0D0*(1.0D0+0.065D0*LOG(S))
         ROSH   = 0.01D0
         ELAB = (S-AAM(IJPROJ)**2-AMP2)/(TWO*AMP)
         PLAB = SQRT( (ELAB-AAM(IJPROJ))*(ELAB+AAM(IJPROJ)) )
C        SIGSH = DT_SHNTOT(IJPROJ,1,ZERO,PLAB)/10.0D0
         DUMZER = ZERO
         CALL DT_XSHN(IJPROJ,1,PLAB,DUMZER,SIGSH,SIGEL)
         SIGSH = SIGSH/10.0D0
      ENDIF
      GSH = 10.0D0/(TWO*BSLOPE*GEV2MB)
      GAM = GSH
      RCA = GAM*SIGSH/TWOPI
      FCA = -ROSH*RCA
      CA  = DCMPLX(RCA,FCA)
      CI  = DCMPLX(ONE,ZERO)

   16 CONTINUE
c impact parameter
      IF (MCGENE.NE.3) CALL DT_MODB(B,NIDX)

      NTRY = 0
    3 CONTINUE
      NTRY = NTRY+1
c initializations
      JNT  = 0
      DO 1 I=1,NA
         JS(I) = 0
    1 CONTINUE
      DO 2 I=1,NB
         JT(I) = 0
    2 CONTINUE
      IF (IJPROJ.EQ.7) THEN
         DO 8 I=1,MAXNCL
            JS0(I) = 0
            JNT0(I)= 0
            DO 9 J=1,NB
               JT0(I,J) = 0
    9       CONTINUE
    8    CONTINUE
      ENDIF

c nucleon configuration
C     IF ((NTARG.NE.NTARGO).OR.(MOD(ICNT,5).EQ.0)) THEN
      IF ((NTARG.NE.NTARGO).OR.(MOD(ICNT,1).EQ.0)) THEN
C        CALL DT_CONUCL(PKOO,NA,RASH,2)
C        CALL DT_CONUCL(TKOO,NB,RBSH(NTARG),1)
         IF (NIDX.LE.-1) THEN
            CALL DT_CONUCL(PKOO,NA,RASH(1),0)
            CALL DT_CONUCL(TKOO,NB,RBSH(NTARG),0)
         ELSE
            CALL DT_CONUCL(PKOO,NA,RASH(NTARG),0)
            CALL DT_CONUCL(TKOO,NB,RBSH(1),0)
         ENDIF
         NTARGO = NTARG
      ENDIF
      ICNT = ICNT+1

c LEPTO: pick out one struck nucleon
      IF (MCGENE.EQ.3) THEN
         JNT     = 1
         JS(1)   = 1
         IDX     = INT(DT_RNDM(X)*NB)+1
         JT(IDX) = 1
         B       = ZERO
         GOTO 19
      ENDIF

      DO 4 INA=1,NA
c cross section fluctuations
         AFLUC = ONE
         IF (IFLUCT.EQ.1) THEN
            IFLUK = INT((DT_RNDM(X)+0.001D0)*1000.0D0)
            AFLUC = FLUIXX(IFLUK)
         ENDIF
         KK1  = 1
         KINT = 1
         DO 5 INB=1,NB
c photon-projectile: check for supression by coherence length
            IF (IJPROJ.EQ.7) THEN
               IF (ABS(TKOO(3,INB)-TKOO(3,KK1)).GT.DCOH) THEN
                  KK1  = INB
                  KINT = KINT+1
               ENDIF
            ENDIF
            QQ1 = B+TKOO(1,INB)-PKOO(1,INA)
            QQ2 =   TKOO(2,INB)-PKOO(2,INA)
            XY  = GAM*(QQ1*QQ1+QQ2*QQ2)
            IF (XY.LE.15.0D0) THEN
               C  = CI-CA*AFLUC*EXP(-XY)
               AR = DBLE(C)
               AI = DIMAG(C)
               P  = AR*AR+AI*AI
               IF (DT_RNDM(XY).GE.P) THEN
                  JNT = JNT+1
                  IF (IJPROJ.EQ.7) THEN
                     JNT0(KINT) = JNT0(KINT)+1
                     IF (JNT0(KINT).GT.MAXNCL) THEN
                        WRITE(ErrorOut,1001) MAXNCL
 1001                   FORMAT(1X,
     &                        'DIAGR:  NO. OF REQUESTED INTERACTIONS',
     &                        ' EXCEEDS ARRAY DIMENSIONS ',I4)
                        STOP
                     ENDIF
                     JS0(KINT)      = JS0(KINT)+1
                     JT0(KINT,INB)  = JT0(KINT,INB)+1
                     JI1(KINT,JNT0(KINT)) = INA
                     JI2(KINT,JNT0(KINT)) = INB
                  ELSE
                     IF (JNT.GT.MAXINT) THEN
                        WRITE(ErrorOut,1000) JNT, MAXINT
 1000                   FORMAT(1X,
     &                        'DIAGR:  NO. OF REQUESTED INTERACTIONS ('
     &                        ,I4,') EXCEEDS ARRAY DIMENSIONS (',I4,')')
                        STOP
                     ENDIF
                     JS(INA) = JS(INA)+1
                     JT(INB) = JT(INB)+1
                     INTER1(JNT) = INA
                     INTER2(JNT) = INB
                  ENDIF
               ENDIF
            ENDIF
    5    CONTINUE
    4 CONTINUE

      IF (JNT.EQ.0) THEN
         IF (NTRY.LT.500) THEN
            GOTO 3
         ELSE
C           WRITE(6,*) ' new impact parameter required (old= ',B,')'
C&&&&&&&&&&&&& KK
C                for pion proj and H target, some times loop happens
C                workaround by putting -1.0 to imact param.
            if(IJPROJ .eq. 14 .and. NB .eq. 1) then
               B=-1.
               return
            endif
C&&&&&&&&&&&&&&&&&
            GOTO 16
         ENDIF
      ENDIF

      IDIREC = 0
      IF (IJPROJ.EQ.7) THEN
         K = INT(ONE+DT_RNDM(X)*DBLE(KINT))
   10    CONTINUE
         IF (JNT0(K).EQ.0) THEN
            K = K+1
            IF (K.GT.KINT) K = 1
            GOTO 10
         ENDIF
c supress Glauber-cascade by direct photon processes
         CALL DT_POILIK(NB,NTARG,ECMNOW,SQ2,IPNT,RPNT,2)
         IF (IPNT.GT.0) THEN
            JNT   = 1
            JS(1) = 1
            DO 11 INB=1,NB
               JT(INB) = JT0(K,INB)
               IF (JT(INB).GT.0) GOTO 12
   11       CONTINUE
   12       CONTINUE
            INTER1(1) = 1
            INTER2(1) = INB
            IDIREC    = IPNT
         ELSE
            JNT   = JNT0(K)
            JS(1) = JS0(K)
            DO 13 INB=1,NB
               JT(INB) = JT0(K,INB)
   13       CONTINUE
            DO 14 I=1,JNT
               INTER1(I) = JI1(K,I)
               INTER2(I) = JI2(K,I)
   14       CONTINUE
         ENDIF
      ENDIF

   19 CONTINUE
      INTA = 0
      INTB = 0
      DO 6 I=1,NA
        IF (JS(I).NE.0) INTA=INTA+1
    6 CONTINUE
      DO 7 I=1,NB
        IF (JT(I).NE.0) INTB=INTB+1
    7 CONTINUE
      ICWPG = INTA
      ICWTG = INTB
      ICIG  = JNT
      IPGLB = IPGLB+INTA
      ITGLB = ITGLB+INTB
      NGLB = NGLB+1

      IF (NCOMPO.EQ.0) THEN
         NCALL = NCALL+1
         NWA(INTA) = NWA(INTA)+1
         NWB(INTB) = NWB(INTB)+1
      ENDIF

      RETURN
      END
c
c===modb===============================================================*
c
CDECK  ID>, DT_MODB
      SUBROUTINE DT_MODB(B,NIDX)

c***********************************************************************
c Sampling of impact parameter of collision.                           *
c    B          impact parameter    (output)                           *
c    NIDX       index of projectile/target material             (input)*
c Based on the original version by Shmakov et al.                      *
c This version dated 21.04.95 is revised by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY15=1.0D-15,ONE=1.0D0,TWO=2.0D0)

      LOGICAL LEFT,LFIRST

c central particle production, impact parameter biasing
      COMMON /DTIMPA/ BIMIN,BIMAX,XSFRAC,ICENTR

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI


      DATA LFIRST /.TRUE./

      NTARG = ABS(NIDX)
      IF (NIDX.LE.-1) THEN
         RA = RASH(1)
         RB = RBSH(NTARG)
      ELSE
         RA = RASH(NTARG)
         RB = RBSH(1)
      ENDIF

      IF (ICENTR.EQ.2) THEN
         IF (RA.EQ.RB) THEN
            BB = DT_RNDM(B)*(0.3D0*RA)**2
            B  = SQRT(BB)
         ELSEIF(RA.LT.RB)THEN
            BB = DT_RNDM(B)*1.4D0*(RB-RA)**2
            B  = SQRT(BB)
         ELSEIF(RA.GT.RB)THEN
            BB = DT_RNDM(B)*1.4D0*(RA-RB)**2
            B  = SQRT(BB)
         ENDIF
      ELSE
    9    CONTINUE
         Y  = DT_RNDM(BB)
         I0 = 1
         I2 = NSITEB
   10    CONTINUE
         I1 = (I0+I2)/2
         LEFT = ((BSITE(0,1,NTARG,I0)-Y)
     &          *(BSITE(0,1,NTARG,I1)-Y)).LT.ZERO
         IF (LEFT) GOTO 20
         I0 = I1
         GOTO 30
   20    CONTINUE
         I2 = I1
   30    CONTINUE
         IF (I2-I0-2) 40,50,60
   40    CONTINUE
         I1 = I2+1
         IF (I1.GT.NSITEB) I1 = I0-1
         GOTO 70
   50    CONTINUE
         I1 = I0+1
         GOTO 70
   60    CONTINUE
         GOTO 10
   70    CONTINUE
         X0 = DBLE(I0-1)*BSTEP(NTARG)
         X1 = DBLE(I1-1)*BSTEP(NTARG)
         X2 = DBLE(I2-1)*BSTEP(NTARG)
         Y0 = BSITE(0,1,NTARG,I0)
         Y1 = BSITE(0,1,NTARG,I1)
         Y2 = BSITE(0,1,NTARG,I2)
   80    CONTINUE
         B = X0*(Y-Y1)*(Y-Y2)/((Y0-Y1)*(Y0-Y2)+TINY15)+
     &       X1*(Y-Y0)*(Y-Y2)/((Y1-Y0)*(Y1-Y2)+TINY15)+
     &       X2*(Y-Y0)*(Y-Y1)/((Y2-Y0)*(Y2-Y1)+TINY15)
c*sr 5.4.98: shift B by half the bin width to be in agreement with BPROD
         B = B+0.5D0*BSTEP(NTARG)
         IF (B.LT.ZERO) B = X1
         IF (B.GT.BMAX(NTARG)) B = BMAX(NTARG)
         IF (ICENTR.LT.0) THEN
            IF (LFIRST) THEN
               LFIRST = .FALSE.
               IF (ICENTR.LE.-100) THEN
                  BIMIN  = 0.0D0
               ELSE
                  XSFRAC = 0.0D0
               ENDIF
               CALL DT_GETBXS(XSFRAC,BIMIN,BIMAX,NTARG)
               WRITE(ErrorOut,
     * 1000) RASH(1),RBSH(NTARG),BMAX(NTARG),
     &                          BIMIN,BIMAX,XSFRAC*100.0D0,
     &                          XSFRAC*XSPRO(1,1,NTARG)
 10000         FORMAT(/,1X,'DT_MODB:      BIASING IN IMPACT PARAMETER',
     &                /,15X,'---------------------------'/,/,4X,
     &                'AVERAGE RADII OF PROJ / TARG :',F10.3,' FM /',
     &                F7.3,' FM',/,4X,'CORRESP. B_MAX (4*(R_P+R_T)) :',
     &                F10.3,' FM',/,/,21X,'B_LO / B_HI :',
     &                F10.3,' FM /',F7.3,' FM',/,5X,'PERCENTAGE OF',
     &                ' CROSS SECTION :',F10.3,' %',/,5X,
     &                'CORRESPONDING CROSS SECTION :',F10.3,' MB',/)
            ENDIF
            IF (ABS(BIMAX-BIMIN).LT.1.0D-3) THEN
               B = BIMIN
            ELSE
               IF ((B.LT.BIMIN).OR.(B.GT.BIMAX)) GOTO 9
            ENDIF
         ENDIF
      ENDIF

      RETURN
      END
c
c===shfast=============================================================*
c
CDECK  ID>, DT_SHFAST
      SUBROUTINE DT_SHFAST(MODE,PPN,IBACK)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,TINY10=1.0D-10,TINY1=1.0D-1,
     &           ONE=1.0D0,TWO=2.0D0)

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI


      IBACK = 0

      IF (MODE.EQ.2) THEN
         OPEN(47,FILE='OUTDATA0/SHMAKOV.OUT',STATUS='UNKNOWN')
         WRITE(47,1000) IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG,PPN
 1000    FORMAT(1X,8I5,E15.5)
         WRITE(47,1001) RASH(1),RBSH(1),BMAX(1),BSTEP(1)
 1001    FORMAT(1X,4E15.5)
         WRITE(47,1002) SIGSH,ROSH,GSH
 1002    FORMAT(1X,3E15.5)
         DO 10 I=1,100
            WRITE(47,'(1X,E15.5)') BSITE(1,1,1,I)
   10    CONTINUE
         WRITE(47,1003) NSITEB,NSTATB,ECMNN(1),XSPRO(1,1,1),BSLOPE
 1003    FORMAT(1X,2I10,3E15.5)
         CLOSE(47)
      ELSE
         OPEN(47,FILE='OUTDATA0/SHMAKOV.OUT',STATUS='UNKNOWN')
         READ(47,1000) JT,JTZ,JP,JPZ,JJPROJ,JBPROJ,JJTARG,JBTARG,PP
         IF ((JT.EQ.IT).AND.(JTZ.EQ.ITZ).AND.(JP.EQ.IP).AND.
     &       (JPZ.EQ.IPZ).AND.(JJPROJ.EQ.IJPROJ).AND.(JBPROJ.EQ.IBPROJ)
     &       .AND.(JJTARG.EQ.IJTARG).AND.(JBTARG.EQ.IBTARG).AND.
     &       (ABS(PP-PPN).LT.(PPN*0.01D0))) THEN
            READ(47,1001) RASH(1),RBSH(1),BMAX(1),BSTEP(1)
            READ(47,1002) SIGSH,ROSH,GSH
            DO 11 I=1,100
               READ(47,'(1X,E15.5)') BSITE(1,1,1,I)
   11       CONTINUE
            READ(47,1003) NSITEB,NSTATB,ECMNN(1),XSPRO(1,1,1),BSLOPE
         ELSE
            IBACK = 1
         ENDIF
         CLOSE(47)
      ENDIF

      RETURN
      END
c
c===poilik=============================================================*
c
CDECK  ID>, DT_POILIK
      SUBROUTINE DT_POILIK(NB,NTARG,ECM,VIRT,IPNT,RPNT,MODE)

      IMPLICIT DOUBLE PRECISION(A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY14=1.0D0)
      PARAMETER (NE = 8)

c*PHOJET105a
C     CHARACTER*8 MDLNA
C     COMMON /MODELS/ MDLNA(50),ISWMDL(50),PARMDL(200),IPAMDL(100)
C     PARAMETER (IEETAB=10)
C     COMMON /XSETAB/ SIGTAB(4,70,IEETAB),SIGECM(4,IEETAB),ISIMAX
c*PHOJET110
C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

C  energy-interpolation table
      INTEGER IEETA2
      PARAMETER ( IEETA2 = 20 )
      INTEGER ISIMAX
      DOUBLE PRECISION SIGTAB,SIGECM
      COMMON /POTABL/ SIGTAB(4,80,IEETA2),SIGECM(4,IEETA2),ISIMAX

c*
c VDM parameter for photon-nucleus interactions
      COMMON /DTVDMP/ RL2,EPSPOL,INTRGE(2),IDPDF,MODEGA,ISHAD(3)

c*sr 22.7.97
      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c*

      DATA ECMOLD,Q2OLD /-1.0D0,-1.0D0/

      IF ((ECM.EQ.ECMOLD).AND.(VIRT.EQ.Q2OLD)) GOTO 3

c load cross sections from interpolation table
      IP = 1
      IF(ECM.LE.SIGECM(IP,1)) THEN
        I1 = 1
        I2 = 1
      ELSE IF(ECM.LT.SIGECM(IP,ISIMAX)) THEN
        DO 50 I=2,ISIMAX
          IF(ECM.LE.SIGECM(IP,I)) GOTO 200
  50    CONTINUE
 200    CONTINUE
        I1 = I-1
        I2 = I
      ELSE
        WRITE(ErrorOut,'(/1X,A,2E12.3)')
     &    'POILIK:WARNING:TOO HIGH ENERGY',ECM,SIGECM(IP,ISIMAX)
        I1 = ISIMAX
        I2 = ISIMAX
      ENDIF
      FAC2 = ZERO
      IF(I1.NE.I2) FAC2=LOG(ECM/SIGECM(IP,I1))
     &                     /LOG(SIGECM(IP,I2)/SIGECM(IP,I1))
      FAC1 = ONE-FAC2

      SIGANO = DT_SANO(ECM)

c cross section dependence on photon virtuality
      FSUP1 = ZERO
      DO  150 I=1,3
         FSUP1 = FSUP1+PARMDL(26+I)*(ONE+VIRT/(4.D0*PARMDL(30+I)))
     &                             /(ONE+VIRT/PARMDL(30+I))**2
 150  CONTINUE
      FSUP1 = FSUP1+PARMDL(30)/(ONE+VIRT/PARMDL(34))
      FAC1  = FAC1*FSUP1
      FAC2  = FAC2*FSUP1
      FSUP2 = ONE

      ECMOLD = ECM
      Q2OLD  = VIRT

    3 CONTINUE

C     SIGTOT = FAC2*SIGTAB(IP, 1,I2)+FAC1*SIGTAB(IP, 1,I1)
      CALL DT_SIGGP(ZERO,VIRT,ECM,ZERO,SIGTOT,DUM1,DUM2)
      IF (ISHAD(1).EQ.1) THEN
         SIGDIR = FAC2*SIGTAB(IP,29,I2)+FAC1*SIGTAB(IP,29,I1)
      ELSE
         SIGDIR = ZERO
      ENDIF
      SIGANO = FSUP1*FSUP2*SIGANO
      SIGTOT = SIGTOT-SIGDIR-SIGANO
      SIGDIR = SIGDIR/(FSUP1*FSUP2)
      SIGANO = SIGANO/(FSUP1*FSUP2)
      SIGTOT = SIGTOT+SIGDIR+SIGANO

      RR = DT_RNDM(SIGTOT)
      IF (RR.LT.SIGDIR/SIGTOT) THEN
         IPNT = 1
      ELSEIF ((RR.GE.SIGDIR/SIGTOT).AND.
     &        (RR.LT.(SIGDIR+SIGANO)/SIGTOT)) THEN
         IPNT = 2
      ELSE
         IPNT = 0
      ENDIF
      RPNT = (SIGDIR+SIGANO)/SIGTOT
C     WRITE(LOUT,'(I3,2F15.5)') ISHAD(1),FAC1,FAC2
C     WRITE(LOUT,'(I3,2F15.5)') MODE,SIGDIR,SIGANO
C     WRITE(LOUT,'(I3,4F15.5)') MODE,SIGDIR+SIGANO,SIGTOT,RPNT,ECM
C     WRITE(6,'(1X,6E12.4)') ECM,VIRT,SIGTOT,SIGDIR,SIGANO,RPNT
      IF (MODE.EQ.1) RETURN

c*sr 22.7.97
      K1   = 1
      K2   = 1
      RATE = ZERO
      IF (ECM.GE.ECMNN(NEBINI)) THEN
         K1   = NEBINI
         K2   = NEBINI
         RATE = ONE
      ELSEIF (ECM.GT.ECMNN(1)) THEN
         DO 10 I=2,NEBINI
            IF (ECM.LT.ECMNN(I)) THEN
               K1   = I-1
               K2   = I
               RATE = (ECM-ECMNN(K1))/(ECMNN(K2)-ECMNN(K1))
               GOTO 11
            ENDIF
   10    CONTINUE
   11    CONTINUE
      ENDIF
      J1   = 1
      J2   = 1
      RATQ = ZERO
      IF (NQBINI.GT.1) THEN
         IF (VIRT.GE.Q2G(NQBINI)) THEN
            J1   = NQBINI
            J2   = NQBINI
            RATQ = ONE
         ELSEIF (VIRT.GT.Q2G(1)) THEN
            DO 12 I=2,NQBINI
               IF (VIRT.LT.Q2G(I)) THEN
                  J1   = I-1
                  J2   = I
                  RATQ = LOG10(   VIRT/MAX(Q2G(J1),TINY14))/
     &                   LOG10(Q2G(J2)/MAX(Q2G(J1),TINY14))
                  GOTO 13
               ENDIF
   12       CONTINUE
   13       CONTINUE
         ENDIF
      ENDIF
      SGA = XSPRO(K1,J1,NTARG)+
     &      RATE*(XSPRO(K2,J1,NTARG)-XSPRO(K1,J1,NTARG))+
     &      RATQ*(XSPRO(K1,J2,NTARG)-XSPRO(K1,J1,NTARG))+
     &      RATE*RATQ*(XSPRO(K2,J2,NTARG)-XSPRO(K1,J2,NTARG)+
     &                 XSPRO(K1,J1,NTARG)-XSPRO(K2,J1,NTARG))
      SDI = DBLE(NB)*SIGDIR
      SAN = DBLE(NB)*SIGANO
      SPL = SDI+SAN
      RR = DT_RNDM(SPL)
      IF (RR.LT.SDI/SGA) THEN
         IPNT = 1
      ELSEIF ((RR.GE.SDI/SGA).AND.
     &        (RR.LT.SPL/SGA)) THEN
         IPNT = 2
      ELSE
         IPNT = 0
      ENDIF
      RPNT = SPL/SGA
C     WRITE(LOUT,'(I3,4F15.5)') MODE,SPL,SGA,RPNT,ECM
c*

      RETURN
      END
c
c===glbini=============================================================*
c
CDECK  ID>, DT_GLBINI
      SUBROUTINE DT_GLBINI(WHAT)

c***********************************************************************
c Pre-initialization of profile function                               *
c This version dated 28.11.00 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (LIN=5,LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY14=1.D-14)

      LOGICAL LCMS

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c emulsion treatment
      COMMON /DTCOMP/ EMUFRA(NCOMPX),IEMUMA(NCOMPX),IEMUCH(NCOMPX),
     &                NCOMPO,IEMUL

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

c number of data sets other than protons and nuclei
c at the moment = 2 (pions and kaons)
      PARAMETER (MAXOFF=2)
      DIMENSION IJPINI(5),IOFFST(25)
      DATA IJPINI / 13, 15,  0,  0,  0/
c Glauber data-set to be used for hadron projectiles
c (0=proton, 1=pion, 2=kaon)
      DATA (IOFFST(K),K=1,25) /
     &  0, 0,-1,-1,-1,-1,-1, 0, 0,-1,-1, 2, 1, 1, 2, 2, 0, 0, 2, 0,
     &  0, 0, 1, 2, 2/


      PARAMETER (MAXMSS = 100)
      DIMENSION IASAV(MAXMSS),IBSAV(MAXMSS)
      DIMENSION WHAT(6)

      DATA JPEACH,JPSTEP / 18, 5 /
c
c--------------------------------------------------------------------------
c general initializations
c
c  steps in projectile mass number for initialization
      IF (WHAT(4).GT.ZERO) JPEACH = INT(WHAT(4))
      IF (WHAT(5).GT.ZERO) JPSTEP = INT(WHAT(5))
c
c  energy range and binning
      ELO  = ABS(WHAT(1))
      EHI  = ABS(WHAT(2))
      IF (ELO.GT.EHI) ELO = EHI
      NEBIN = MAX(INT(WHAT(3)),1)
      IF (ELO.EQ.EHI) NEBIN = 0
      LCMS = (WHAT(1).LT.ZERO).OR.(WHAT(2).LT.ZERO)
      IF (LCMS) THEN
         ECMINI = EHI
      ELSE
         ECMINI = SQRT(AAM(IJPROJ)**2+AAM(IJTARG)**2
     &                 +2.0D0*AAM(IJTARG)*EHI)
      ENDIF
c
c  default arguments for Glauber-routine
      XI  = ZERO
      Q2I = ZERO
c
c  initialize nuclear parameters, etc.
      CALL DT_BERTTP
      CALL DT_INCINI
c
c  open Glauber-data output file
      IDX = INDEX(CGLB,' ')
      K   = 12
      IF (IDX.GT.1) K = IDX-1
      OPEN(LLOOK,FILE=CGLB(1:K)//'.GLB',STATUS='UNKNOWN')
c
c--------------------------------------------------------------------------
c Glauber-initialization for proton and nuclei projectiles
c
c  initialize phojet for proton-proton interactions
      ELAB = ZERO
      PLAB = ZERO
      CALL DT_LTINI(IJPROJ,IJTARG,ELAB,PLAB,ECMINI,1)
      CALL DT_PHOINI
c
c  record projectile masses
      NASAV = 0
      NPROJ = MIN(IP,JPEACH)
      DO 10 KPROJ=1,NPROJ
         NASAV = NASAV+1
         IF (NASAV.GT.MAXMSS) STOP ' GLBINI: NASAV > MAXMSS ! '
         IASAV(NASAV) = KPROJ
   10 CONTINUE
      IF (IP.GT.JPEACH) THEN
         NPROJ = DBLE(IP-JPEACH)/DBLE(JPSTEP)
         IF (NPROJ.EQ.0) THEN
            NASAV = NASAV+1
            IF (NASAV.GT.MAXMSS) STOP ' GLBINI: NASAV > MAXMSS ! '
            IASAV(NASAV) = IP
         ELSE
            DO 11 IPROJ=1,NPROJ
               KPROJ = JPEACH+IPROJ*JPSTEP
               NASAV = NASAV+1
               IF (NASAV.GT.MAXMSS) STOP ' GLBINI: NASAV > MAXMSS ! '
               IASAV(NASAV) = KPROJ
   11       CONTINUE
            IF (KPROJ.LT.IP) THEN
               NASAV = NASAV+1
               IF (NASAV.GT.MAXMSS) STOP ' GLBINI: NASAV > MAXMSS ! '
               IASAV(NASAV) = IP
            ENDIF
         ENDIF
      ENDIF
c
c  record target masses
      NBSAV = 0
      NTARG = 1
      IF (NCOMPO.GT.0) NTARG = NCOMPO
      DO 12 ITARG=1,NTARG
         NBSAV = NBSAV+1
         IF (NBSAV.GT.MAXMSS) STOP ' GLBINI: NBSAV > MAXMSS ! '
         IF (NCOMPO.GT.0) THEN
            IBSAV(NBSAV) = IEMUMA(ITARG)
         ELSE
            IBSAV(NBSAV) = IT
         ENDIF
   12 CONTINUE
c
c  print masses
      WRITE(LLOOK,1000) NEBIN,': ',SIGN(ELO,WHAT(1)),SIGN(EHI,WHAT(2))
 1000 FORMAT(I4,A,1P,2E13.5)
      NLINES = DBLE(NASAV)/18.0D0
      IF (NLINES.GT.0) THEN
         DO 13 I=1,NLINES
            IF (I.EQ.1) THEN
               WRITE(LLOOK,'(I4,A,18I4)')NASAV,': ',(IASAV(J),J=1,18)
            ELSE
               WRITE(LLOOK,'(6X,18I4)') (IASAV(J),J=18*I-17,18*I)
            ENDIF
   13    CONTINUE
      ENDIF
      I0 = 18*NLINES+1
      IF (I0.LE.NASAV) THEN
         IF (I0.EQ.1) THEN
            WRITE(LLOOK,'(I4,A,18I4)')NASAV,': ',(IASAV(J),J=I0,NASAV)
         ELSE
            WRITE(LLOOK,'(6X,18I4)') (IASAV(J),J=I0,NASAV)
         ENDIF
      ENDIF
      NLINES = DBLE(NBSAV)/18.0D0
      IF (NLINES.GT.0) THEN
         DO 14 I=1,NLINES
            IF (I.EQ.1) THEN
               WRITE(LLOOK,'(I4,A,18I4)')NBSAV,': ',(IBSAV(J),J=1,18)
            ELSE
               WRITE(LLOOK,'(6X,18I4)') (IBSAV(J),J=18*I-17,18*I)
            ENDIF
   14    CONTINUE
      ENDIF
      I0 = 18*NLINES+1
      IF (I0.LE.NBSAV) THEN
         IF (I0.EQ.1) THEN
            WRITE(LLOOK,'(I4,A,18I4)')NBSAV,': ',(IBSAV(J),J=I0,NBSAV)
         ELSE
            WRITE(LLOOK,'(6X,18I4)') (IBSAV(J),J=I0,NBSAV)
         ENDIF
      ENDIF
c
c  calculate Glauber-data for each energy and mass combination
c
c   loop over energy bins
      ELO = LOG10(ELO)
      EHI = LOG10(EHI)
      DEBIN = (EHI-ELO)/DBLE(NEBIN)
      DO 1 IE=1,NEBIN+1
         E = ELO+DBLE(IE-1)*DEBIN
         E = 10**E
         IF (LCMS) THEN
            E   = MAX(2.0D0*AAM(IJPROJ)+0.1D0,E)
            ECM = E
         ELSE
            PLAB = ZERO
            ECM  = ZERO
            E    = MAX(AAM(IJPROJ)+0.1D0,E)
            CALL DT_LTINI(IJPROJ,IJTARG,E,PLAB,ECM,0)
         ENDIF
c
c   loop over projectile and target masses
         DO 2 ITARG=1,NBSAV
            DO 3 IPROJ=1,NASAV
               CALL DT_XSGLAU(IASAV(IPROJ),IBSAV(ITARG),IJPROJ,
     &                                       XI,Q2I,ECM,1,1,-1)
    3       CONTINUE
    2    CONTINUE
c
    1 CONTINUE
c
c--------------------------------------------------------------------------
c Glauber-initialization for pion, kaon, ... projectiles
c
      DO 6 IJ=1,MAXOFF
c
c  initialize phojet for this interaction
         ELAB = ZERO
         PLAB = ZERO
         IJPROJ = IJPINI(IJ)
         IP     = 1
         IPZ    = 1
         CALL DT_LTINI(IJPROJ,IJTARG,ELAB,PLAB,ECMINI,1)
         CALL DT_PHOINI
c
c  calculate Glauber-data for each energy and mass combination
c
c   loop over energy bins
         DO 4 IE=1,NEBIN+1
            E = ELO+DBLE(IE-1)*DEBIN
            E = 10**E
            IF (LCMS) THEN
               E   = MAX(2.0D0*AAM(IJPROJ)+TINY14,E)
               ECM = E
            ELSE
               PLAB = ZERO
               ECM  = ZERO
               E    = MAX(AAM(IJPROJ)+TINY14,E)
               CALL DT_LTINI(IJPROJ,IJTARG,E,PLAB,ECM,0)
            ENDIF
c
c   loop over projectile and target masses
            DO 5 ITARG=1,NBSAV
               CALL DT_XSGLAU(1,IBSAV(ITARG),IJPROJ,XI,Q2I,ECM,1,1,-1)
    5       CONTINUE
c
    4    CONTINUE
c
    6 CONTINUE

c--------------------------------------------------------------------------
c close output unit(s), etc.
c
      CLOSE(LLOOK)

      RETURN
      END
c
c===glbset=============================================================*
c
CDECK  ID>, DT_GLBSET
      SUBROUTINE DT_GLBSET(IDPROJ,NA,NB,ELAB,MODE)
c***********************************************************************
c Interpolation of pre-initialized profile functions                   *
c This version dated 28.11.00 is written by S. Roesler.                *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE

      PARAMETER (LIN=5,LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0)

      LOGICAL LCMS,LREAD

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Glauber formalism: flags and parameters for statistics
      LOGICAL LPROD
      CHARACTER*8 CGLB
      COMMON /DTGLGP/ JSTATB,JBINSB,CGLB,IOGLB,LPROD

      PARAMETER (NCOMPX=20,NEB=8,NQB= 5,KSITEB=50)

c Glauber formalism: parameters
      COMMON /DTGLAM/ RASH(NCOMPX),RBSH(NCOMPX),
     &                BMAX(NCOMPX),BSTEP(NCOMPX),
     &                SIGSH,ROSH,GSH,BSITE(0:NEB,NQB,NCOMPX,KSITEB),
     &                NSITEB,NSTATB

c Glauber formalism: cross sections
      COMMON /DTGLXS/ ECMNN(NEB),Q2G(NQB),ECMNOW,Q2,
     &                XSTOT(NEB,NQB,NCOMPX),XSELA(NEB,NQB,NCOMPX),
     &                XSQEP(NEB,NQB,NCOMPX),XSQET(NEB,NQB,NCOMPX),
     &                XSQE2(NEB,NQB,NCOMPX),XSPRO(NEB,NQB,NCOMPX),
     &                XSDEL(NEB,NQB,NCOMPX),XSDQE(NEB,NQB,NCOMPX),
     &                XETOT(NEB,NQB,NCOMPX),XEELA(NEB,NQB,NCOMPX),
     &                XEQEP(NEB,NQB,NCOMPX),XEQET(NEB,NQB,NCOMPX),
     &                XEQE2(NEB,NQB,NCOMPX),XEPRO(NEB,NQB,NCOMPX),
     &                XEDEL(NEB,NQB,NCOMPX),XEDQE(NEB,NQB,NCOMPX),
     &                BSLOPE,NEBINI,NQBINI

c number of data sets other than protons and nuclei
c at the moment = 2 (pions and kaons)
      PARAMETER (MAXOFF=2)
      DIMENSION IJPINI(5),IOFFST(25)
      DATA IJPINI / 13, 15,  0,  0,  0/
c Glauber data-set to be used for hadron projectiles
c (0=proton, 1=pion, 2=kaon)
      DATA (IOFFST(K),K=1,25) /
     &  0, 0,-1,-1,-1,-1,-1, 0, 0,-1,-1, 2, 1, 1, 2, 2, 0, 0, 2, 0,
     &  0, 0, 1, 2, 2/

c
c        &&&&& expasion  by KK
c                      10       22+2=24       20    = 4800
c           NSET0 = (NEBIN+1)*(NABIN+MAXOFF)*NBBIN <= MAXSET
cc      for air  NEBIN =4800/(24*3)-1 = 65  : enough large
cc      proj: A=1,2,3...14,15, 21,27,33,39,45,51,56  --> 22 A's
cc
cc 
cc      PARAMETER (MAXSET=1000,   ! original
      PARAMETER (MAXSET=4800,
     &           MAXBIN=50)
      DIMENSION XSIG(MAXSET,6),XERR(MAXSET,6),BPROFL(MAXSET,KSITEB)
      DIMENSION IABIN(MAXBIN),IBBIN(MAXBIN),XS(6),XE(6),
     &          BPRO0(KSITEB),BPRO1(KSITEB),BPRO(KSITEB),
     &          IAIDX(10)

      DATA LREAD /.FALSE./

      character*12 tempstr
c
c read data from file
c
      IF (MODE.EQ.0) THEN

         IF (LREAD) RETURN

         DO 1 I=1,MAXSET
            DO 2 J=1,6
               XSIG(I,J) = ZERO
               XERR(I,J) = ZERO
    2       CONTINUE
            DO 3 J=1,KSITEB
               BPROFL(I,J) = ZERO
    3       CONTINUE
    1    CONTINUE
         DO 4 I=1,MAXBIN
            IABIN(I) = 0
            IBBIN(I) = 0
    4    CONTINUE
         DO 5 I=1,KSITEB
            BPRO0(I) = ZERO
            BPRO1(I) = ZERO
            BPRO(I)  = ZERO
    5    CONTINUE

         IDX = INDEX(CGLB,' ')
         K   = 12
         IF (IDX.GT.1) K = IDX-1
ccc         &&&&&&&&&&&& kk
         tempstr = ' '
         tempstr =CGLB(1:K)//'.GLB'
c         OPEN(LLOOK,FILE=CGLB(1:K)//'.GLB',STATUS='UNKNOWN')
         call cdpmOpen(LLOOK, tempstr)
         WRITE(ErrorOut,1000) tempstr
ccc    &&&&&&&
 1000    FORMAT(/,' GLBSET: IMPACT PARAMETER DISTRIBUTIONS READ FROM ',
     &          'FILE ',A12,/)
c
c  read binning information
         READ(LLOOK,'(I4,2X,2E13.5)') NEBIN,ELO,EHI
         LCMS = ELO.LT.ZERO
         WRITE(ErrorOut,
     * '(1X,A)') ' equidistant logarithmic energy binning:'
         IF (LCMS) THEN
            WRITE(ErrorOut,1001) '(cms)',ABS(ELO),ABS(EHI),NEBIN
         ELSE
            WRITE(ErrorOut,1001) '(lab)',ABS(ELO),ABS(EHI),NEBIN
         ENDIF
 1001    FORMAT(2X,A5,'  E_LO = ',1P,E9.3,'  E_HI = ',1P,E9.3,4X,
     &          'NO. OF BINS:',I5,/)
         ELO  = LOG10(ABS(ELO))
         EHI  = LOG10(ABS(EHI))
         DEBIN = (EHI-ELO)/ABS(DBLE(NEBIN))
         WRITE(ErrorOut,
     * '(/,1X,A)') ' projectiles: (mass number)'
         READ(LLOOK,'(I4,2X,18I4)') NABIN,(IABIN(J),J=1,18)
         IF (NABIN.LT.18) THEN
            WRITE(ErrorOut,'(6X,18I4)') (IABIN(J),J=1,NABIN)
         ELSE
            WRITE(ErrorOut,'(6X,18I4)') (IABIN(J),J=1,18)
         ENDIF
         IF (NABIN.GT.MAXBIN) STOP ' GLBSET: NABIN > MAXBIN !'
         IF (NABIN.GT.18) THEN
            NLINES = DBLE(NABIN-18)/18.0D0
            IF (NLINES.GT.0) THEN
               DO 7 I=1,NLINES
                  I0 = 18*(I+1)-17
                  READ(LLOOK,'(6X,18I4)') (IABIN(J),J=I0,I0+17)
                  WRITE(ErrorOut,
     * '(6X,18I4)') (IABIN(J),J=I0,I0+17)
    7          CONTINUE
            ENDIF
            I0 = 18*(NLINES+1)+1
            IF (I0.LE.NABIN) THEN
               READ(LLOOK,'(6X,18I4)') (IABIN(J),J=I0,NABIN)
               WRITE(ErrorOut,'(6X,18I4)') (IABIN(J),J=I0,NABIN)
            ENDIF
         ENDIF
         WRITE(ErrorOut,'(/,1X,A)') ' targets: (mass number)'
         READ(LLOOK,'(I4,2X,18I4)') NBBIN,(IBBIN(J),J=1,18)
         IF (NBBIN.LT.18) THEN
            WRITE(ErrorOut,'(6X,18I4)') (IBBIN(J),J=1,NBBIN)
         ELSE
            WRITE(ErrorOut,'(6X,18I4)') (IBBIN(J),J=1,18)
         ENDIF
         IF (NBBIN.GT.MAXBIN) STOP ' GLBSET: NBBIN > MAXBIN !'
         IF (NBBIN.GT.18) THEN
            NLINES = DBLE(NBBIN-18)/18.0D0
            IF (NLINES.GT.0) THEN
               DO 8 I=1,NLINES
                  I0 = 18*(I+1)-17
                  READ(LLOOK,'(6X,18I4)') (IBBIN(J),J=I0,I0+17)
                  WRITE(ErrorOut,
     * '(6X,18I4)') (IBBIN(J),J=I0,I0+17)
    8          CONTINUE
            ENDIF
            I0 = 18*(NLINES+1)+1
            IF (I0.LE.NBBIN) THEN
               READ(LLOOK,'(6X,18I4)') (IBBIN(J),J=I0,NBBIN)
               WRITE(ErrorOut,'(6X,18I4)') (IBBIN(J),J=I0,NBBIN)
            ENDIF
         ENDIF
c  number of data sets to follow in the Glauber data file
c   this variable is used for checks of consistency of projectile
c   and target mass configurations given in header of Glauber data
c   file and the data-sets which follow in this file
         NSET0 = (NEBIN+1)*(NABIN+MAXOFF)*NBBIN
c
c  read profile function data
         NSET  = 0
         NAIDX = 0
         IPOLD = 0
   10    CONTINUE
         NSET = NSET+1
         IF (NSET.GT.MAXSET) STOP ' GLBSET: NSET > MAXSET ! '
         READ(LLOOK,1002,END=100) IP,IA,IB,ISTATB,ISITEB,ECM
 1002    FORMAT(5I10,E15.5)
         IF ((IP.NE.1).AND.(IP.NE.IPOLD)) THEN
            NAIDX = NAIDX+1
            IF (NAIDX.GT.10) STOP ' GLBSET: NAIDX > 10 !'
            IAIDX(NAIDX) = IP
            IPOLD = IP
         ENDIF
         READ(LLOOK,'(6E12.5)') (XSIG(NSET,I),I=1,6)
         READ(LLOOK,'(6E12.5)') (XERR(NSET,I),I=1,6)
         NLINES = INT(DBLE(ISITEB)/7.0D0)
         IF (NLINES.GT.0) THEN
            DO 11 I=1,NLINES
               READ(LLOOK,'(7E11.4)') (BPROFL(NSET,J),J=7*I-6,7*I)
   11       CONTINUE
         ENDIF
         I0 = 7*NLINES+1
         IF (I0.LE.ISITEB)
     &      READ(LLOOK,'(7E11.4)') (BPROFL(NSET,J),J=I0,ISITEB)
         GOTO 10
  100    CONTINUE
         NSET = NSET-1
         IF (NSET.NE.NSET0) STOP ' GLBSET: NSET.NE.NSET0 !'
         WRITE(ErrorOut,'(/,1X,A)')
     &   ' PROJECTILES OTHER THAN PROTONS AND NUCLEI: (PARTICLE INDEX)'
         IF (NAIDX.GT.0) THEN
            WRITE(ErrorOut,'(6X,18I4)') (IAIDX(J),J=1,NAIDX)
         ELSE
            WRITE(ErrorOut,'(6X,A)') 'none'
         ENDIF
c
         CLOSE(LLOOK)
         WRITE(ErrorOut,*)
         LREAD = .TRUE.
c
c calculate profile function for certain set of parameters
c
      ELSE

c        write(*,*) 'glbset called for ',IDPROJ,NA,NB,ELAB,MODE
c
c check for type of projectile and set index-offset to entry in
c Glauber data array correspondingly
         IF (IDPROJ.GT.25) STOP ' GLBSET: IDPROJ > 25 !'
         IF (IOFFST(IDPROJ).EQ.-1) THEN
            STOP ' GLBSET: NO DATA FOR THIS PROJECTILE !'
         ELSEIF (IOFFST(IDPROJ).GT.0) THEN
            IDXOFF = (NEBIN+1)*(NABIN+IOFFST(IDPROJ)-1)*NBBIN
         ELSE
            IDXOFF = 0
         ENDIF
c
c get energy bin and interpolation factor
         IF (LCMS) THEN
            E = SQRT(AAM(IDPROJ)**2+AAM(1)**2+2.0D0*AAM(1)*ELAB)
         ELSE
            E = ELAB
         ENDIF
         E = LOG10(E)
         IF ((E.LT.ELO).OR.(E.GT.EHI)) THEN
            WRITE(ErrorOut,*) ' GLBSET: inconsistent energy ! '
            WRITE(ErrorOut,
     * *) '         (E,E_lo,E_hi) ',E,ELO,EHI
            STOP
         ENDIF
         IE0  = (E-ELO)/DEBIN+1
         IE1  = IE0+1
         FACE = (E-(ELO+DBLE(IE0-1)*DEBIN))/DEBIN
c
c get target nucleus index
         KB = 0
         DO 20 I=1,NBBIN
            IF (NB.EQ.IBBIN(I)) THEN
               KB = I
               GOTO 21
            ENDIF
   20    CONTINUE
         WRITE(ErrorOut,
     * *) ' GLBSET: data not found for target ',NB
         STOP
   21    CONTINUE
c
c get projectile nucleus bin and interpolation factor
         KA0 = 0
         KA1 = 0
         FACNA = 0
         IF (IDXOFF.GT.0) THEN
            KA0 = 1
            KA1 = 1
            KABIN = 1
         ELSE
            IF (NA.GT.IABIN(NABIN)) STOP ' GLBSET: NA > IABIN(NABIN) !'
            DO 22 I=1,NABIN
               IF (NA.EQ.IABIN(I)) THEN
                  KA0 = I
                  KA1 = I
                  GOTO 23
               ELSEIF (NA.LT.IABIN(I)) THEN
                  KA0 = I-1
                  KA1 = I
                  GOTO 23
               ENDIF
   22       CONTINUE
            WRITE(ErrorOut,
     * *) ' GLBSET: data not found for projectile ',NA
            STOP
   23       CONTINUE
            IF (KA0.NE.KA1)
     &         FACNA = DBLE(NA-IABIN(KA0))/DBLE(IABIN(KA1)-IABIN(KA0))
            KABIN = NABIN
         ENDIF
c
c interpolate profile functions for interactions ka0-kb and ka1-kb
c for energy E separately
         IDX0 = IDXOFF+1+(IE0-1)*KABIN*NBBIN+(KB-1)*KABIN+(KA0-1)
         IDX1 = IDXOFF+1+(IE1-1)*KABIN*NBBIN+(KB-1)*KABIN+(KA0-1)
         IDY0 = IDXOFF+1+(IE0-1)*KABIN*NBBIN+(KB-1)*KABIN+(KA1-1)
         IDY1 = IDXOFF+1+(IE1-1)*KABIN*NBBIN+(KB-1)*KABIN+(KA1-1)
         DO 30 I=1,ISITEB
            BPRO0(I) = BPROFL(IDX0,I)
     &                 +FACE*(BPROFL(IDX1,I)-BPROFL(IDX0,I))
            BPRO1(I) = BPROFL(IDY0,I)
     &                 +FACE*(BPROFL(IDY1,I)-BPROFL(IDY0,I))
   30    CONTINUE
         RADB  = DT_RNCLUS(NB)
         BSTP0 = 2.0D0*(DT_RNCLUS(IABIN(KA0))+RADB)/DBLE(ISITEB-1)
         BSTP1 = 2.0D0*(DT_RNCLUS(IABIN(KA1))+RADB)/DBLE(ISITEB-1)
c
c interpolate cross sections for energy E and projectile mass
         DO 31 I=1,6
            XS0   = XSIG(IDX0,I)+FACE*(XSIG(IDX1,I)-XSIG(IDX0,I))
            XS1   = XSIG(IDY0,I)+FACE*(XSIG(IDY1,I)-XSIG(IDY0,I))
            XS(I) = XS0+FACNA*(XS1-XS0)
            XE0   = XERR(IDX0,I)+FACE*(XERR(IDX1,I)-XERR(IDX0,I))
            XE1   = XERR(IDY0,I)+FACE*(XERR(IDY1,I)-XERR(IDY0,I))
            XE(I) = XE0+FACNA*(XE1-XE0)
   31    CONTINUE
c
c interpolate between ka0 and ka1
         RADA = DT_RNCLUS(NA)
         BMX  = 2.0D0*(RADA+RADB)
         BSTP = BMX/DBLE(ISITEB-1)
         BPRO(1) = ZERO
         DO 32 I=1,ISITEB-1
            B = DBLE(I)*BSTP
c
c   calculate values of profile functions at B
            IDX0 = B/BSTP0+1
            IF (IDX0.GT.ISITEB) IDX0 = ISITEB
            IDX1 = MIN(IDX0+1,ISITEB)
            FACB = (B-DBLE(IDX0-1)*BSTP0)/BSTP0
            BPR0 = BPRO0(IDX0)+FACB*(BPRO0(IDX1)-BPRO0(IDX0))
            IDX0 = B/BSTP1+1
            IF (IDX0.GT.ISITEB) IDX0 = ISITEB
            IDX1 = MIN(IDX0+1,ISITEB)
            FACB = (B-DBLE(IDX0-1)*BSTP1)/BSTP1
            BPR1 = BPRO1(IDX0)+FACB*(BPRO1(IDX1)-BPRO1(IDX0))
c
            BPRO(I+1) = BPR0+FACNA*(BPR1-BPR0)
   32    CONTINUE
c
c fill common dtglam
         NSITEB   = ISITEB
         RASH(1)  = RADA
         RBSH(1)  = RADB
         BMAX(1)  = BMX
         BSTEP(1) = BSTP
         DO 33 I=1,KSITEB
            BSITE(0,1,1,I) = BPRO(I)
   33    CONTINUE
c
c fill common dtglxs
         XSTOT(1,1,1) = XS(1)
         XSELA(1,1,1) = XS(2)
         XSQEP(1,1,1) = XS(3)
         XSQET(1,1,1) = XS(4)
         XSQE2(1,1,1) = XS(5)
         XSPRO(1,1,1) = XS(6)
         XETOT(1,1,1) = XE(1)
         XEELA(1,1,1) = XE(2)
         XEQEP(1,1,1) = XE(3)
         XEQET(1,1,1) = XE(4)
         XEQE2(1,1,1) = XE(5)
         XEPRO(1,1,1) = XE(6)

      ENDIF

      RETURN
      END
c
c===xksamp=============================================================*
c
CDECK  ID>, DT_XKSAMP
      SUBROUTINE DT_XKSAMP(NN,ECM)

c***********************************************************************
c Sampling of parton x-values and chain system for one interaction.    *
c                                   processed by S. Roesler, 9.8.95    *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)


      PARAMETER (
c lower cuts for (valence-sea/sea-valence) chain masses
c   antiquark-quark (u/d-sea quark)    (s-sea quark)
     &               AMIU = 0.5D0,      AMIS = 0.8D0,
c   quark-diquark   (u/d-sea quark)    (s-sea quark)
     &               AMAU = 2.6D0,      AMAS = 2.6D0,
c maximum lower valence-x threshold
     &           XVMAX  = 0.98D0,
c fraction of sea-diquarks sampled out of sea-partons
c*test
C    &           FRCDIQ = 0.9D0,
c*
c
     &           SQMA   = 0.7D0,
c
c maximum number of trials to generate x's for the required number
c of sea quark pairs for a given hadron
     &           NSEATY = 12
C    &           NSEATY = 3
     &          )

      LOGICAL ZUOVP,ZUOSP,ZUOVT,ZUOST,INTLO


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c interface between Glauber formalism and DPM
      COMMON /DTGLIF/ JSSH(MAXNCL),JTSH(MAXNCL),
     &                INTER1(MAXINT),INTER2(MAXINT)

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c threshold values for x-sampling (DTUNUC 1.x)
      COMMON /DTXCUT/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     &                SSMIMQ,VVMTHR

c x-values of partons (DTUNUC 1.x)
      COMMON /DTDPMX/ XPVQ(MAXVQU),XPVD(MAXVQU),
     &                XTVQ(MAXVQU),XTVD(MAXVQU),
     &                XPSQ(MAXSQU),XPSAQ(MAXSQU),
     &                XTSQ(MAXSQU),XTSAQ(MAXSQU)

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPMI/ NVV,NSV,NVS,NSS,NDV,NVD,NDS,NSD,
     &                IXPV,IXPS,IXTV,IXTS,
     &                INTVV1(MAXVQU),INTVV2(MAXVQU),
     &                INTSV1(MAXVQU),INTSV2(MAXVQU),
     &                INTVS1(MAXVQU),INTVS2(MAXVQU),
     &                INTSS1(MAXSQU),INTSS2(MAXSQU),
     &                INTDV1(MAXVQU),INTDV2(MAXVQU),
     &                INTVD1(MAXVQU),INTVD2(MAXVQU),
     &                INTDS1(MAXSQU),INTDS2(MAXSQU),
     &                INTSD1(MAXSQU),INTSD2(MAXSQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPM0/ IFROVP(MAXVQU),ITOVP(MAXVQU),IFROSP(MAXSQU),
     &                IFROVT(MAXVQU),ITOVT(MAXVQU),IFROST(MAXSQU)

c auxiliary common for chain system storage (DTUNUC 1.x)
      COMMON /DTCHSY/ ISKPCH(8,MAXINT),IPOSP(MAXNCL),IPOST(MAXNCL)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DIMENSION ZUOVP(MAXVQU),ZUOSP(MAXSQU),ZUOVT(MAXVQU),ZUOST(MAXSQU),
     &          INTLO(MAXINT)

c (1) initializations
c-----------------------------------------------------------------------

c*test
      IF (ECM.LT.4.5D0) THEN
C        FRCDIQ = 0.6D0
         FRCDIQ = 0.4D0
      ELSEIF ((ECM.GE.4.5D0).AND.(ECM.LT.7.5)) THEN
C        FRCDIQ = 0.6D0+(ECM-4.5D0)/3.0D0*0.3D0
         FRCDIQ = 0.4D0+(ECM-4.5D0)/3.0D0*0.3D0
      ELSE
C        FRCDIQ = 0.9D0
         FRCDIQ = 0.7D0
      ENDIF
c*
      DO 30 I=1,MAXSQU
         ZUOSP(I) = .FALSE.
         ZUOST(I) = .FALSE.
         IF (I.LE.MAXVQU) THEN
            ZUOVP(I) = .FALSE.
            ZUOVT(I) = .FALSE.
         ENDIF
   30 CONTINUE

c lower thresholds for x-selection
c  sea-quarks       (default: CSEA=0.2)
      IF (ECM.LT.10.0D0) THEN
c*!!test
         XSTHR = ((12.0D0-ECM)/5.0D0+1.0D0)*CSEA/ECM
C        XSTHR = ((12.0D0-ECM)/5.0D0+1.0D0)*CSEA/ECM**2.0D0
         NSEA  = NSEATY
C        XSTHR = ONE/ECM**2
      ELSE
c*sr 30.3.98
C        XSTHR = CSEA/ECM
         XSTHR = CSEA/ECM**2
C        XSTHR = ONE/ECM**2
c*
         IF ((IP.GE.150).AND.(IT.GE.150))
     &      XSTHR = 2.5D0/(ECM*SQRT(ECM))
         NSEA  = NSEATY
      ENDIF
c                   (default: SSMIMA=0.14) used for sea-diquarks (?)
      XSSTHR = SSMIMA/ECM
      BSQMA  = SQMA/ECM
c  valence-quarks   (default: CVQ=1.0)
      XVTHR  = CVQ/ECM
c  valence-diquarks (default: CDQ=2.0)
      XDTHR  = CDQ/ECM

c maximum-x for sea-quarks
      XVCUT  = XVTHR+XDTHR
      XXSEAM = ONE-XVCUT
c*sr 18.4. test: DPMJET
C     XXSEAM=1.0 - XVTHR*(1.D0+0.3D0*DT_RNDM(V1))
C    &            - XDTHR*(1.D0+0.3D0*DT_RNDM(V2))
C    &             -0.01*(1.D0+1.5D0*DT_RNDM(V3))
c*
c maximum number of sea-pairs allowed kinematically
C     NSMAX  = INT(OHALF*XXSEAM/XSTHR)
      RNSMAX = OHALF*XXSEAM/XSTHR
      IF (RNSMAX.GT.10000.0D0) THEN
         NSMAX = 10000
      ELSE
         NSMAX = INT(OHALF*XXSEAM/XSTHR)
      ENDIF
c check kinematical limit for valence-x thresholds
      IF (XVCUT.GT.XVMAX) THEN
         WRITE(ErrorOut,1000) XVCUT,ECM
 1000    FORMAT(' XKSAMP:    KIN. LIMIT FOR VALENCE-X',
     &          '  THRESHOLDS NOT ALLOWED (',2E9.3,')')
cc     &&&&&&
         call cpdpmjetinp
c     &&&&&&&&&&&&
C        XVTHR = XVMAX-XDTHR
C        IF (XVTHR.LT.ZERO) STOP
ccc          &&&&&&&&&& KK
cccc         STOP
      ENDIF

c set eta for valence-x sampling (BETREJ)
c   (UNON per default, UNOM used for projectile mesons only)
      IF ((IJPROJ.NE.0).AND.(IBPROJ.EQ.0)) THEN
         UNOPRV = UNOM
      ELSE
         UNOPRV = UNON
      ENDIF

c (2) select parton x-values of interacting projectile nucleons
c-----------------------------------------------------------------------

      IXPV = 0
      IXPS = 0

      DO 100 IPP=1,IP
c   get interacting projectile nucleon as sampled by Glauber
         IF (JSSH(IPP).NE.0) THEN
            IXSTMP = IXPS
	    IXVTMP = IXPV
   99       CONTINUE
	    IXPS   = IXSTMP
	    IXPV   = IXVTMP
c     JIPP is the actual number of sea-pairs sampled for this nucleon
            JIPP   = MIN(JSSH(IPP)-1,NSMAX)
   41       CONTINUE
            XXSEA  = ZERO
            IF (JIPP.GT.0) THEN
               XSMAX = XXSEAM-2.0D0*DBLE(JIPP)*XSTHR
c???
               IF (XSTHR.GE.XSMAX) THEN
                  JIPP = JIPP-1
                  GOTO 41
               ENDIF

c>>>get x-values of sea-quark pairs
               NSCOUN = 0
               PLW = 0.5D0
   40          CONTINUE
c     accumulator for sea x-values
               XXSEA  = ZERO
               NSCOUN = NSCOUN+1
               IF (DBLE(NSCOUN)/DBLE(NSEA).GT.0.5D0) PLW = 1.0D0
               IF (NSCOUN.GT.NSEA) THEN
c     decrease the number of interactions after NSEA trials
                  JIPP   = JIPP-1
                  NSCOUN = 0
               ENDIF
               DO 70 ISQ=1,JIPP
c     sea-quarks
                  IF (IPSQ(IXPS+1).LE.2) THEN
c*sr 8.4.98 (1/sqrt(x))
C                    XPSQI = DT_SAMPEX(XSTHR,XSMAX)
C                    XPSQI = DT_SAMSQX(XSTHR,XSMAX)
                     XPSQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                  ELSE
                     IF (XSMAX.GT.XSTHR+BSQMA) THEN
                        XPSQI = DT_SAMPXB(XSTHR+BSQMA,XSMAX,BSQMA)
                     ELSE
c*sr 8.4.98 (1/sqrt(x))
C                       XPSQI = DT_SAMPEX(XSTHR,XSMAX)
C                       XPSQI = DT_SAMSQX(XSTHR,XSMAX)
                        XPSQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                     ENDIF
                  ENDIF
c     sea-antiquarks
                  IF (IPSAQ(IXPS+1).GE.-2) THEN
c*sr 8.4.98 (1/sqrt(x))
C                    XPSAQI = DT_SAMPEX(XSTHR,XSMAX)
C                    XPSAQI = DT_SAMSQX(XSTHR,XSMAX)
                     XPSAQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                  ELSE
                     IF (XSMAX.GT.XSTHR+BSQMA) THEN
                        XPSAQI = DT_SAMPXB(XSTHR+BSQMA,XSMAX,BSQMA)
                     ELSE
c*sr 8.4.98 (1/sqrt(x))
C                       XPSAQI = DT_SAMPEX(XSTHR,XSMAX)
C                       XPSAQI = DT_SAMSQX(XSTHR,XSMAX)
                        XPSAQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                     ENDIF
                  ENDIF
                  XXSEA = XXSEA+XPSQI+XPSAQI
c     check for maximum allowed sea x-value
                  IF (XXSEA.GE.XXSEAM) THEN
                     IXPS = IXPS-ISQ+1
                     GOTO 40
                  ENDIF
c     accept this sea-quark pair
                  IXPS         = IXPS+1
                  XPSQ(IXPS)   = XPSQI
                  XPSAQ(IXPS)  = XPSAQI
                  IFROSP(IXPS) = IPP
                  ZUOSP(IXPS)  = .TRUE.
   70          CONTINUE
            ENDIF

c>>>get x-values of valence partons
c     valence quark
            IF (XVTHR.GT.0.05D0) THEN
               XVHI  = ONE-XXSEA-XDTHR
               XPVQI = DT_BETREJ(OHALF,UNOPRV,XVTHR,XVHI)
            ELSE
   90          CONTINUE
               XPVQI = DT_DBETAR(OHALF,UNOPRV)
               IF ((XPVQI.LT.XVTHR).OR.(ONE-XPVQI-XXSEA.LT.XDTHR))
     &                                                     GOTO 90
            ENDIF
c     valence diquark
            XPVDI = ONE-XPVQI-XXSEA
c       reject according to x**1.5
            XDTMP = XPVDI**1.5D0
	    IF (DT_RNDM(XPVDI).GT.XDTMP) GOTO 99
c     accept these valence partons
            IXPV         = IXPV+1
            XPVQ(IXPV)   = XPVQI
            XPVD(IXPV)   = XPVDI
            IFROVP(IXPV) = IPP
            ITOVP(IPP)   = IXPV
            ZUOVP(IXPV)  = .TRUE.

         ENDIF
  100 CONTINUE

c (3) select parton x-values of interacting target nucleons
c-----------------------------------------------------------------------

      IXTV = 0
      IXTS = 0

      DO 170 ITT=1,IT
c   get interacting target nucleon as sampled by Glauber
         IF (JTSH(ITT).NE.0) THEN
            IXSTMP = IXTS
	    IXVTMP = IXTV
  169       CONTINUE
	    IXTS   = IXSTMP
	    IXTV   = IXVTMP
c     JITT is the actual number of sea-pairs sampled for this nucleon
            JITT   = MIN(JTSH(ITT)-1,NSMAX)
  111       CONTINUE
            XXSEA  = ZERO
            IF (JITT.GT.0) THEN
               XSMAX = XXSEAM-2.0D0*DBLE(JITT)*XSTHR
c???
               IF (XSTHR.GE.XSMAX) THEN
                  JITT = JITT-1
                  GOTO 111
               ENDIF

c>>>get x-values of sea-quark pairs
               NSCOUN = 0
               PLW = 0.5D0
  110          CONTINUE
c     accumulator for sea x-values
               XXSEA  = ZERO
               NSCOUN = NSCOUN+1
               IF (DBLE(NSCOUN)/DBLE(NSEA).GT.0.5D0) PLW = 1.0D0
               IF (NSCOUN.GT.NSEA)THEN
c     decrease the number of interactions after NSEA trials
                  JITT   = JITT-1
                  NSCOUN = 0
               ENDIF
               DO 140 ISQ=1,JITT
c     sea-quarks
                  IF (ITSQ(IXTS+1).LE.2) THEN
c*sr 8.4.98 (1/sqrt(x))
C                    XTSQI = DT_SAMPEX(XSTHR,XSMAX)
C                    XTSQI = DT_SAMSQX(XSTHR,XSMAX)
                     XTSQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                  ELSE
                     IF (XSMAX.GT.XSTHR+BSQMA) THEN
                        XTSQI = DT_SAMPXB(XSTHR+BSQMA,XSMAX,BSQMA)
                     ELSE
c*sr 8.4.98 (1/sqrt(x))
C                       XTSQI = DT_SAMPEX(XSTHR,XSMAX)
C                       XTSQI = DT_SAMSQX(XSTHR,XSMAX)
                        XTSQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                     ENDIF
                  ENDIF
c     sea-antiquarks
                  IF (ITSAQ(IXTS+1).GE.-2) THEN
c*sr 8.4.98 (1/sqrt(x))
C                    XTSAQI = DT_SAMPEX(XSTHR,XSMAX)
C                    XTSAQI = DT_SAMSQX(XSTHR,XSMAX)
                     XTSAQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                  ELSE
                     IF (XSMAX.GT.XSTHR+BSQMA) THEN
                        XTSAQI = DT_SAMPXB(XSTHR+BSQMA,XSMAX,BSQMA)
                     ELSE
c*sr 8.4.98 (1/sqrt(x))
C                       XTSAQI = DT_SAMPEX(XSTHR,XSMAX)
C                       XTSAQI = DT_SAMSQX(XSTHR,XSMAX)
                        XTSAQI = DT_SAMPLW(XSTHR,XSMAX,PLW)
c*
                     ENDIF
                  ENDIF
                  XXSEA = XXSEA+XTSQI+XTSAQI
c     check for maximum allowed sea x-value
                  IF (XXSEA.GE.XXSEAM) THEN
                     IXTS = IXTS-ISQ+1
                     GOTO 110
                  ENDIF
c     accept this sea-quark pair
                  IXTS         = IXTS+1
                  XTSQ(IXTS)   = XTSQI
                  XTSAQ(IXTS)  = XTSAQI
                  IFROST(IXTS) = ITT
                  ZUOST(IXTS)  = .TRUE.
  140          CONTINUE
            ENDIF

c>>>get x-values of valence partons
c     valence quark
            IF (XVTHR.GT.0.05D0) THEN
               XVHI  = ONE-XXSEA-XDTHR
               XTVQI = DT_BETREJ(OHALF,UNON,XVTHR,XVHI)
            ELSE
  160          CONTINUE
               XTVQI = DT_DBETAR(OHALF,UNON)
               IF ((XTVQI.LT.XVTHR).OR.(ONE-XTVQI-XXSEA.LT.XDTHR))
     &                                                    GOTO 160
            ENDIF
c     valence diquark
            XTVDI = ONE-XTVQI-XXSEA
c       reject according to x**1.5
            XDTMP = XTVDI**1.5D0
	    IF (DT_RNDM(XPVDI).GT.XDTMP) GOTO 169
c     accept these valence partons
            IXTV         = IXTV+1
            XTVQ(IXTV)   = XTVQI
            XTVD(IXTV)   = XTVDI
            IFROVT(IXTV) = ITT
            ITOVT(ITT)   = IXTV
            ZUOVT(IXTV)  = .TRUE.

         ENDIF
  170 CONTINUE

c (4) get valence-valence chains
c-----------------------------------------------------------------------

      NVV = 0
      DO 240 I=1,NN
         INTLO(I) = .TRUE.
         IPVAL    = ITOVP(INTER1(I))
         ITVAL    = ITOVT(INTER2(I))
         IF (ZUOVP(IPVAL).AND.ZUOVT(ITVAL)) THEN
            INTLO(I)      = .FALSE.
            ZUOVP(IPVAL)  = .FALSE.
            ZUOVT(ITVAL)  = .FALSE.
            NVV           = NVV+1
            ISKPCH(8,NVV) = 0
            INTVV1(NVV)   = IPVAL
            INTVV2(NVV)   = ITVAL
         ENDIF
  240 CONTINUE

c (5) get sea-valence chains
c-----------------------------------------------------------------------

      NSV = 0
      NDV = 0
      PLW = 0.5D0
      DO 270 I=1,NN
         IF (INTLO(I)) THEN
            IPVAL = ITOVP(INTER1(I))
            ITVAL = ITOVT(INTER2(I))
            DO 250 J=1,IXPS
               IF (ZUOSP(J).AND.(IFROSP(J).EQ.INTER1(I)).AND.
     &                                ZUOVT(ITVAL)) THEN
                  ZUOSP(J)     = .FALSE.
                  ZUOVT(ITVAL) = .FALSE.
                  INTLO(I)     = .FALSE.
                  IF (LSEADI.AND.(DT_RNDM(PLW).GT.FRCDIQ)) THEN
c   sample sea-diquark pair
                     CALL DT_SAMSDQ(ECM,ITVAL,J,2,IREJ1)
                     IF (IREJ1.EQ.0) GOTO 260
                  ENDIF
                  NSV           = NSV+1
                  ISKPCH(4,NSV) = 0
                  INTSV1(NSV)   = J
                  INTSV2(NSV)   = ITVAL

c>>>correct chain kinematics according to minimum chain masses
c     the actual chain masses
                  AMSVQ1 = XPSQ(J) *XTVD(ITVAL)*ECM**2
                  AMSVQ2 = XPSAQ(J)*XTVQ(ITVAL)*ECM**2
c     get lower mass cuts
                  IF (IPSQ(J).EQ.3) THEN
c       q being s-quark
                     AMCHK1 = AMAS
                     AMCHK2 = AMIS
                  ELSE
c       q being u/d-quark
                     AMCHK1 = AMAU
                     AMCHK2 = AMIU
                  ENDIF
c       q-qq chain
c         chain mass above minimum - resampling of sea-q x-value
                  IF (AMSVQ1.GT.AMCHK1) THEN
                     XPSQTH      = AMCHK1/(XTVD(ITVAL)*ECM**2)
c*sr 8.4.98 (1/sqrt(x))
C                    XPSQXX      = DT_SAMPEX(XPSQTH,XPSQ(J))
C                    XPSQXX      = DT_SAMSQX(XPSQTH,XPSQ(J))
                     XPSQXX      = DT_SAMPLW(XPSQTH,XPSQ(J),PLW)
c*
                     XPVD(IPVAL) = XPVD(IPVAL)+XPSQ(J)-XPSQXX
                     XPSQ(J)     = XPSQXX
c         chain mass below minimum - reset sea-q x-value and correct
c                                    diquark-x of the same nucleon
                  ELSEIF (AMSVQ1.LT.AMCHK1) THEN
                     XPSQW       = AMCHK1/(XTVD(ITVAL)*ECM**2)
                     DXPSQ       = XPSQW-XPSQ(J)
                     IF (XPVD(IPVAL).GE.XDTHR+DXPSQ) THEN
                        XPVD(IPVAL) = XPVD(IPVAL)-DXPSQ
                        XPSQ(J)     = XPSQW
                     ENDIF
                  ENDIF
c       aq-q chain
c         chain mass below minimum - reset sea-aq x-value and correct
c                                    diquark-x of the same nucleon
                  IF (AMSVQ2.LT.AMCHK2) THEN
                     XPSQW = AMCHK2/(XTVQ(ITVAL)*ECM**2)
                     DXPSQ = XPSQW-XPSAQ(J)
                     IF (XPVD(IPVAL).GE.XDTHR+DXPSQ) THEN
                        XPVD(IPVAL) = XPVD(IPVAL)-DXPSQ
                        XPSAQ(J)    = XPSQW
                     ENDIF
                  ENDIF
c>>>end of chain mass correction

                  GOTO 260
               ENDIF
  250       CONTINUE
         ENDIF
  260    CONTINUE
  270 CONTINUE

c (6) get valence-sea chains
c-----------------------------------------------------------------------

      NVS = 0
      NVD = 0
      DO 300 I=1,NN
         IF (INTLO(I)) THEN
            IPVAL = ITOVP(INTER1(I))
            ITVAL = ITOVT(INTER2(I))
            DO 280 J=1,IXTS
               IF (ZUOVP(IPVAL).AND.ZUOST(J).AND.
     &                  (IFROST(J).EQ.INTER2(I))) THEN
                  ZUOST(J)     = .FALSE.
                  ZUOVP(IPVAL) = .FALSE.
                  INTLO(I)     = .FALSE.
                  IF (LSEADI.AND.(DT_RNDM(ECM).GT.FRCDIQ)) THEN
c   sample sea-diquark pair
                     CALL DT_SAMSDQ(ECM,IPVAL,J,1,IREJ1)
                     IF (IREJ1.EQ.0) GOTO 290
                  ENDIF
                  NVS           = NVS + 1
                  ISKPCH(6,NVS) = 0
                  INTVS1(NVS)   = IPVAL
                  INTVS2(NVS)   = J

c>>>correct chain kinematics according to minimum chain masses
c     the actual chain masses
                  AMVSQ1 = XPVQ(IPVAL)*XTSAQ(J)*ECM**2
                  AMVSQ2 = XPVD(IPVAL)*XTSQ(J) *ECM**2
c     get lower mass cuts
                  IF (ITSQ(J).EQ.3) THEN
c       q being s-quark
                     AMCHK1 = AMIS
                     AMCHK2 = AMAS
                  ELSE
c       q being u/d-quark
                     AMCHK1 = AMIU
                     AMCHK2 = AMAU
                  ENDIF
c       q-aq chain
c         chain mass below minimum - reset sea-aq x-value and correct
c                                    diquark-x of the same nucleon
                  IF (AMVSQ1.LT.AMCHK1) THEN
                     XTSQW = AMCHK1/(XPVQ(IPVAL)*ECM**2)
                     DXTSQ = XTSQW-XTSAQ(J)
                     IF (XTVD(ITVAL).GE.XDTHR+DXTSQ) THEN
                        XTVD(ITVAL) = XTVD(ITVAL)-DXTSQ
                        XTSAQ(J)    = XTSQW
                     ENDIF
                  ENDIF
c       qq-q chain
c         chain mass above minimum - resampling of sea-q x-value
                  IF (AMVSQ2.GT.AMCHK2) THEN
                     XTSQTH      = AMCHK2/(XPVD(IPVAL)*ECM**2)
c*sr 8.4.98 (1/sqrt(x))
C                    XTSQXX      = DT_SAMPEX(XTSQTH,XTSQ(J))
C                    XTSQXX      = DT_SAMSQX(XTSQTH,XTSQ(J))
                     XTSQXX      = DT_SAMPLW(XTSQTH,XTSQ(J),PLW)
c*
                     XTVD(ITVAL) = XTVD(ITVAL)+XTSQ(J)-XTSQXX
                     XTSQ(J)     = XTSQXX
c         chain mass below minimum - reset sea-q x-value and correct
c                                    diquark-x of the same nucleon
                  ELSEIF (AMVSQ2.LT.AMCHK2) THEN
                     XTSQW       = AMCHK2/(XPVD(IPVAL)*ECM**2)
                     DXTSQ       = XTSQW-XTSQ(J)
                     IF (XTVD(ITVAL).GE.XDTHR+DXTSQ) THEN
                        XTVD(ITVAL) = XTVD(ITVAL)-DXTSQ
                        XTSQ(J)     = XTSQW
                     ENDIF
                  ENDIF
c>>>end of chain mass correction

                  GOTO 290
               ENDIF
  280       CONTINUE
         ENDIF
  290    CONTINUE
  300 CONTINUE

c (7) get sea-sea chains
c-----------------------------------------------------------------------

      NSS = 0
      NDS = 0
      NSD = 0
      DO 420 I=1,NN
         IF (INTLO(I)) THEN
            IPVAL = ITOVP(INTER1(I))
            ITVAL = ITOVT(INTER2(I))
c   loop over target partons not yet matched
            DO 400 J=1,IXTS
               IF (ZUOST(J).AND.(IFROST(J).EQ.INTER2(I))) THEN
c   loop over projectile partons not yet matched
                  DO 390 JJ=1,IXPS
                     IF (ZUOSP(JJ).AND.(IFROSP(JJ).EQ.INTER1(I))) THEN
                        ZUOSP(JJ)     = .FALSE.
                        ZUOST(J)      = .FALSE.
                        INTLO(I)      = .FALSE.
                        NSS           = NSS+1
                        ISKPCH(1,NSS) = 0
                        INTSS1(NSS)   = JJ
                        INTSS2(NSS)   = J

c---->chain recombination option
                        VALFRA        = DBLE(NVV/(NVV+IXPS+IXTS))
                        IF (IRECOM.EQ.1.AND.(DT_RNDM(BSQMA).GT.VALFRA))
     &                                                             THEN
c       sea-sea chains may recombine with valence-valence chains
c       only if they have the same projectile or target nucleon
                           DO 4201 IVV=1,NVV
                              IF (ISKPCH(8,IVV).NE.99) THEN
                                 IXVPR = INTVV1(IVV)
                                 IXVTA = INTVV2(IVV)
                                 IF ((INTER1(I).EQ.IFROVP(IXVPR)).OR.
     &                               (INTER2(I).EQ.IFROVT(IXVTA))) THEN
c         recombination possible, drop old v-v and s-s chains
                                    ISKPCH(1,NSS) = 99
                                    ISKPCH(8,IVV) = 99

c         (a) assign new s-v chains
c         ~~~~~~~~~~~~~~~~~~~~~~~~~
                                    IF (LSEADI.AND.
     &                                  (DT_RNDM(VALFRA).GT.FRCDIQ))
     &                                                             THEN
c           sample sea-diquark pair
                                       CALL DT_SAMSDQ(ECM,IXVTA,JJ,2,
     &                                                      IREJ1)
                                       IF (IREJ1.EQ.0) GOTO 4202
                                    ENDIF
                                    NSV           = NSV+1
                                    ISKPCH(4,NSV) = 0
                                    INTSV1(NSV)   = JJ
                                    INTSV2(NSV)   = IXVTA
c>>>>>>>>>>>correct chain kinematics according to minimum chain masses
c           the actual chain masses
                                    AMSVQ1 = XPSQ(JJ) *XTVD(IXVTA)
     &                                                     *ECM**2
                                    AMSVQ2 = XPSAQ(JJ)*XTVQ(IXVTA)
     &                                                     *ECM**2
c           get lower mass cuts
                                    IF (IPSQ(JJ).EQ.3) THEN
c             q being s-quark
                                       AMCHK1 = AMAS
                                       AMCHK2 = AMIS
                                    ELSE
c             q being u/d-quark
                                       AMCHK1 = AMAU
                                       AMCHK2 = AMIU
                                    ENDIF
c           q-qq chain
c             chain mass above minimum - resampling of sea-q x-value
                                    IF (AMSVQ1.GT.AMCHK1) THEN
                                       XPSQTH      =
     &                                    AMCHK1/(XTVD(IXVTA)*ECM**2)
c*sr 8.4.98 (1/sqrt(x))
                                       XPSQXX      =
     &                                    DT_SAMPLW(XPSQTH,XPSQ(JJ),PLW)
C    &                                    DT_SAMSQX(XPSQTH,XPSQ(JJ))
C    &                                    DT_SAMPEX(XPSQTH,XPSQ(JJ))
c*
                                       XPVD(IPVAL) =
     &                                    XPVD(IPVAL)+XPSQ(JJ)-XPSQXX
                                       XPSQ(JJ)    = XPSQXX
c             chain mass below minimum - reset sea-q x-value and correct
c                                        diquark-x of the same nucleon
                                    ELSEIF (AMSVQ1.LT.AMCHK1) THEN
                                       XPSQW =
     &                                    AMCHK1/(XTVD(IXVTA)*ECM**2)
                                       DXPSQ = XPSQW-XPSQ(JJ)
                                       IF (XPVD(IPVAL).GE.XDTHR+DXPSQ)
     &                                                            THEN
                                          XPVD(IPVAL) =
     &                                       XPVD(IPVAL)-DXPSQ
                                          XPSQ(JJ)    = XPSQW
                                       ENDIF
                                    ENDIF
c           aq-q chain
c             chain mass below minimum - reset sea-aq x-value and correct
c                                        diquark-x of the same nucleon
                                    IF (AMSVQ2.LT.AMCHK2) THEN
                                       XPSQW =
     &                                    AMCHK2/(XTVQ(IXVTA)*ECM**2)
                                       DXPSQ = XPSQW-XPSAQ(JJ)
                                       IF (XPVD(IPVAL).GE.XDTHR+DXPSQ)
     &                                                            THEN
                                          XPVD(IPVAL) =
     &                                       XPVD(IPVAL)-DXPSQ
                                          XPSAQ(JJ)   = XPSQW
                                       ENDIF
                                    ENDIF
c>>>>>>>>>>>end of chain mass correction
 4202                               CONTINUE

c         (b) assign new v-s chains
c         ~~~~~~~~~~~~~~~~~~~~~~~~~
                                    IF (LSEADI.AND.(
     &                                  DT_RNDM(AMSVQ2).GT.FRCDIQ))
     &                                                             THEN
c           sample sea-diquark pair
                                       CALL DT_SAMSDQ(ECM,IXVPR,J,1,
     &                                                      IREJ1)
                                       IF (IREJ1.EQ.0) GOTO 4203
                                    ENDIF
                                    NVS           = NVS+1
                                    ISKPCH(6,NVS) = 0
                                    INTVS1(NVS)   = IXVPR
                                    INTVS2(NVS)   = J
c>>>>>>>>>>>correct chain kinematics according to minimum chain masses
c           the actual chain masses
                                    AMVSQ1 = XPVQ(IXVPR)*XTSAQ(J)*ECM**2
                                    AMVSQ2 = XPVD(IXVPR)*XTSQ(J) *ECM**2
c           get lower mass cuts
                                    IF (ITSQ(J).EQ.3) THEN
c             q being s-quark
                                       AMCHK1 = AMIS
                                       AMCHK2 = AMAS
                                    ELSE
c             q being u/d-quark
                                       AMCHK1 = AMIU
                                       AMCHK2 = AMAU
                                    ENDIF
c           q-aq chain
c             chain mass below minimum - reset sea-aq x-value and correct
c                                        diquark-x of the same nucleon
                                    IF (AMVSQ1.LT.AMCHK1) THEN
                                       XTSQW =
     &                                    AMCHK1/(XPVQ(IXVPR)*ECM**2)
                                       DXTSQ = XTSQW-XTSAQ(J)
                                       IF (XTVD(ITVAL).GE.XDTHR+DXTSQ)
     &                                                            THEN
                                          XTVD(ITVAL) =
     &                                       XTVD(ITVAL)-DXTSQ
                                          XTSAQ(J)    = XTSQW
                                       ENDIF
                                    ENDIF
                                    IF (AMVSQ2.GT.AMCHK2) THEN
                                       XTSQTH      =
     &                                    AMCHK2/(XPVD(IXVPR)*ECM**2)
c*sr 8.4.98 (1/sqrt(x))
                                       XTSQXX      =
     &                                    DT_SAMPLW(XTSQTH,XTSQ(J),PLW)
C    &                                    DT_SAMSQX(XTSQTH,XTSQ(J))
C    &                                    DT_SAMPEX(XTSQTH,XTSQ(J))
c*
                                       XTVD(ITVAL) =
     &                                    XTVD(ITVAL)+XTSQ(J)-XTSQXX
                                       XTSQ(J)     = XTSQXX
                                    ELSEIF (AMVSQ2.LT.AMCHK2) THEN
                                       XTSQW =
     &                                    AMCHK2/(XPVD(IXVPR)*ECM**2)
                                       DXTSQ = XTSQW-XTSQ(J)
                                       IF (XTVD(ITVAL).GE.XDTHR+DXTSQ)
     &                                                            THEN
                                          XTVD(ITVAL) =
     &                                       XTVD(ITVAL)-DXTSQ
                                          XTSQ(J)     = XTSQW
                                       ENDIF
                                    ENDIF
c>>>>>>>>>end of chain mass correction
 4203                               CONTINUE
c       jump out of s-s chain loop
                                    GOTO 420
                                 ENDIF
                              ENDIF
 4201                      CONTINUE
                        ENDIF
c---->end of chain recombination option

c     sample sea-diquark pair (projectile)
                        IF (LSEADI.AND.(DT_RNDM(BSQMA).GT.FRCDIQ)) THEN
                           CALL DT_SAMSDQ(ECM,J,JJ,4,IREJ1)
                           IF (IREJ1.EQ.0) THEN
                              ISKPCH(1,NSS) = 99
                              GOTO 410
                           ENDIF
                        ENDIF
c     sample sea-diquark pair (target)
                        IF (LSEADI.AND.(DT_RNDM(ECM).GT.FRCDIQ)) THEN
                           CALL DT_SAMSDQ(ECM,JJ,J,3,IREJ1)
                           IF (IREJ1.EQ.0) THEN
                              ISKPCH(1,NSS) = 99
                              GOTO 410
                           ENDIF
                        ENDIF
c>>>>>correct chain kinematics according to minimum chain masses
c     the actual chain masses
                        SSMA1Q = XPSQ(JJ) *XTSAQ(J)*ECM**2
                        SSMA2Q = XPSAQ(JJ)*XTSQ(J) *ECM**2
c     check for lower mass cuts
                        IF ((SSMA1Q.LT.SSMIMQ).OR.
     &                      (SSMA2Q.LT.SSMIMQ)) THEN
                           IPVAL = ITOVP(INTER1(I))
                           ITVAL = ITOVT(INTER2(I))
                           IF ((XPVD(IPVAL).GT.XDTHR+3.5D0*XSSTHR).AND.
     &                         (XTVD(ITVAL).GT.XDTHR+3.5D0*XSSTHR))THEN
c       maximum allowed x values for sea quarks
                              XSPMAX = ONE-XPVQ(IPVAL)-XDTHR-
     &                                           1.2D0*XSSTHR
                              XSTMAX = ONE-XTVQ(ITVAL)-XDTHR-
     &                                           1.2D0*XSSTHR
c       resampling of x values not possible - skip sea-sea chains
                              IF ((XSPMAX.LE.XSSTHR+0.05D0).OR.
     &                            (XSTMAX.LE.XSSTHR+0.05D0)) GOTO 380
c       resampling of x for projectile sea quark pair
                              ICOUS = 0
  310                         CONTINUE
                              ICOUS = ICOUS+1
                              IF (XSSTHR.GT.0.05D0) THEN
                                 XPSQI =DT_BETREJ(XSEACU,UNOSEA,XSSTHR,
     &                                                         XSPMAX)
                                 XPSAQI=DT_BETREJ(XSEACU,UNOSEA,XSSTHR,
     &                                                         XSPMAX)
                              ELSE
  320                            CONTINUE
                                 XPSQI = DT_DBETAR(XSEACU,UNOSEA)
                                 IF ((XPSQI.LT.XSSTHR).OR.
     &                               (XPSQI.GT.XSPMAX))  GOTO 320
  330                            CONTINUE
                                 XPSAQI = DT_DBETAR(XSEACU,UNOSEA)
                                 IF ((XPSAQI.LT.XSSTHR).OR.
     &                               (XPSAQI.GT.XSPMAX)) GOTO 330
                              ENDIF
c       final test of remaining x for projectile diquark
                              XPVDCO = XPVD(IPVAL)-XPSQI-XPSAQI
     &                                            +XPSQ(JJ)+XPSAQ(JJ)
                              IF (XPVDCO.LE.XDTHR) THEN
c!!!
C                                IF (ICOUS.LT.5) GOTO 310
                                 IF (ICOUS.LT.0.5D0) GOTO 310
                                 GOTO 380
                              ENDIF
c       resampling of x for target sea quark pair
                              ICOUS = 0
  350                         CONTINUE
                              ICOUS = ICOUS+1
                              IF (XSSTHR.GT.0.05D0) THEN
                                 XTSQI =DT_BETREJ(XSEACU,UNOSEA,XSSTHR,
     &                                                         XSTMAX)
                                 XTSAQI=DT_BETREJ(XSEACU,UNOSEA,XSSTHR,
     &                                                         XSTMAX)
                              ELSE
  360                            CONTINUE
                                 XTSQI = DT_DBETAR(XSEACU,UNOSEA)
                                 IF ((XTSQI.LT.XSSTHR).OR.
     &                               (XTSQI.GT.XSTMAX))  GOTO 360
  370                            CONTINUE
                                 XTSAQI = DT_DBETAR(XSEACU,UNOSEA)
                                 IF ((XTSAQI.LT.XSSTHR).OR.
     &                               (XTSAQI.GT.XSTMAX)) GOTO 370
                              ENDIF
c       final test of remaining x for target diquark
                              XTVDCO = XTVD(ITVAL)-XTSQI-XTSAQI
     &                                            +XTSQ(J)+XTSAQ(J)
                              IF (XTVDCO.LT.XDTHR) THEN
                                 IF (ICOUS.LT.5) GOTO 350
                                 GOTO 380
                              ENDIF
                              XPVD(IPVAL) = XPVDCO
                              XTVD(ITVAL) = XTVDCO
                              XPSQ(JJ)    = XPSQI
                              XPSAQ(JJ)   = XPSAQI
                              XTSQ(J)     = XTSQI
                              XTSAQ(J)    = XTSAQI
c>>>>>end of chain mass correction
                              GOTO 410
                           ENDIF
c     come here to discard s-s interaction
c     resampling of x values not allowed or unsuccessful
  380                      CONTINUE
                           INTLO(I)  = .FALSE.
                           ZUOST(J)  = .TRUE.
                           ZUOSP(JJ) = .TRUE.
                           NSS       = NSS-1
                        ENDIF
c   consider next s-s interaction
                        GOTO 410
                     ENDIF
  390             CONTINUE
               ENDIF
  400       CONTINUE
         ENDIF
  410    CONTINUE
  420 CONTINUE

c correct x-values of valence quarks for non-matching sea quarks
      DO 430 I=1,IXPS
         IF (ZUOSP(I)) THEN
            IPVAL       = ITOVP(IFROSP(I))
            XPVQ(IPVAL) = XPVQ(IPVAL)+XPSQ(I)+XPSAQ(I)
            XPSQ(I)     = ZERO
            XPSAQ(I)    = ZERO
            ZUOSP(I)    = .FALSE.
         ENDIF
  430 CONTINUE
      DO 440 I=1,IXTS
         IF (ZUOST(I)) THEN
            ITVAL       = ITOVT(IFROST(I))
            XTVQ(ITVAL) = XTVQ(ITVAL)+XTSQ(I)+XTSAQ(I)
            XTSQ(I)     = ZERO
            XTSAQ(I)    = ZERO
            ZUOST(I)    = .FALSE.
         ENDIF
  440 CONTINUE
      DO 450 I=1,IXPV
         IF (ZUOVP(I)) ISTHKK(IFROVP(I)) = 13
  450 CONTINUE
      DO 460 I=1,IXTV
         IF (ZUOVT(I)) ISTHKK(IFROVT(I)+IP) = 14
  460 CONTINUE

      RETURN
      END
c
c===samsdq=============================================================*
c
CDECK  ID>, DT_SAMSDQ
      SUBROUTINE DT_SAMSDQ(ECM,IDX1,IDX2,MODE,IREJ)

c***********************************************************************
c SAMpling of Sea-DiQuarks                                             *
c              ECM        cm-energy of the nucleon-nucleon system      *
c              IDX1,2     indices of x-values of the participating     *
c                         partons (IDX2 is always the sea-q-pair to be *
c                         changed to sea-qq-pair)                      *
c              MODE       = 1  valence-q - sea-diq                     *
c                         = 2  sea-diq   - valence-q                   *
c                         = 3  sea-q     - sea-diq                     *
c                         = 4  sea-diq   - sea-q                       *
c Based on DIQVS, DIQSV, DIQSSD, DIQDSS.                               *
c This version dated 17.10.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE

      PARAMETER (ZERO=0.0D0)

c threshold values for x-sampling (DTUNUC 1.x)
      COMMON /DTXCUT/ XSEACU,UNON,UNOM,UNOSEA,CVQ,CDQ,CSEA,SSMIMA,
     &                SSMIMQ,VVMTHR

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      PARAMETER ( MAXNCL = 210,

     &            MAXVQU = MAXNCL,
     &            MAXSQU = 20*MAXVQU,
     &            MAXINT = MAXVQU+MAXSQU)

c x-values of partons (DTUNUC 1.x)
      COMMON /DTDPMX/ XPVQ(MAXVQU),XPVD(MAXVQU),
     &                XTVQ(MAXVQU),XTVD(MAXVQU),
     &                XPSQ(MAXSQU),XPSAQ(MAXSQU),
     &                XTSQ(MAXSQU),XTSAQ(MAXSQU)

c flavors of partons (DTUNUC 1.x)
      COMMON /DTDPMF/ IPVQ(MAXVQU),IPPV1(MAXVQU),IPPV2(MAXVQU),
     &                ITVQ(MAXVQU),ITTV1(MAXVQU),ITTV2(MAXVQU),
     &                IPSQ(MAXSQU),IPSQ2(MAXSQU),
     &                IPSAQ(MAXSQU),IPSAQ2(MAXSQU),
     &                ITSQ(MAXSQU),ITSQ2(MAXSQU),
     &                ITSAQ(MAXSQU),ITSAQ2(MAXSQU),
     &                KKPROJ(MAXVQU),KKTARG(MAXVQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPMI/ NVV,NSV,NVS,NSS,NDV,NVD,NDS,NSD,
     &                IXPV,IXPS,IXTV,IXTS,
     &                INTVV1(MAXVQU),INTVV2(MAXVQU),
     &                INTSV1(MAXVQU),INTSV2(MAXVQU),
     &                INTVS1(MAXVQU),INTVS2(MAXVQU),
     &                INTSS1(MAXSQU),INTSS2(MAXSQU),
     &                INTDV1(MAXVQU),INTDV2(MAXVQU),
     &                INTVD1(MAXVQU),INTVD2(MAXVQU),
     &                INTDS1(MAXSQU),INTDS2(MAXSQU),
     &                INTSD1(MAXSQU),INTSD2(MAXSQU)

c auxiliary common for x-value and flavor storage of partons (DTUNUC 1.x)
      COMMON /DTDPM0/ IFROVP(MAXVQU),ITOVP(MAXVQU),IFROSP(MAXSQU),
     &                IFROVT(MAXVQU),ITOVT(MAXVQU),IFROST(MAXSQU)

c auxiliary common for chain system storage (DTUNUC 1.x)
      COMMON /DTCHSY/ ISKPCH(8,MAXINT),IPOSP(MAXNCL),IPOST(MAXNCL)


      IREJ = 0
c  threshold-x for valence diquarks
      XDTHR = CDQ/ECM

      GOTO (1,2,3,4) MODE

c---------------------------------------------------------------------
c proj. valence partons - targ. sea partons
c get x-values and flavors for target sea-diquark pair

    1 CONTINUE
      IDXVP = IDX1
      IDXST = IDX2

c  index of corr. val-diquark-x in target nucleon
      IDXVT = ITOVT(IFROST(IDXST))
c  available x above diquark thresholds for valence- and sea-diquarks
      XXD   = XTVD(IDXVT)+XTSQ(IDXST)+XTSAQ(IDXST)-3.0D0*XDTHR

      IF (XXD.GE.ZERO) THEN
c  x-values for the three diquarks of the target nucleon
         RR1    = DT_RNDM(XXD)
         RR2    = DT_RNDM(RR1)
         RR3    = DT_RNDM(RR2)
         SR123  = RR1+RR2+RR3
         XXTV   = XDTHR+RR1*XXD/SR123
         XXTSQ  = XDTHR+RR2*XXD/SR123
         XXTSAQ = XDTHR+RR3*XXD/SR123
      ELSE
         XXTV   = XTVD(IDXVT)
         XXTSQ  = XTSQ(IDXST)
         XXTSAQ = XTSAQ(IDXST)
      ENDIF
c  flavor of the second quarks in the sea-diquark pair
      ITSQ2(IDXST)  = INT(1.0D0+DT_RNDM(RR3)*(2.0D0+SEASQ))
      ITSAQ2(IDXST) = -ITSQ2(IDXST)
c  check masses of the new val-q - sea-qq, val-qq - sea-aqaq chains
      AM1    = XXTSQ *XPVQ(IDXVP)*ECM**2
      AM2    = XXTSAQ*XPVD(IDXVP)*ECM**2
      IF ( (ITSQ(IDXST).EQ.3).AND.(ITSQ2(IDXST).EQ.3).AND.
c    ss-asas pair
     &     ((AM2.LE.18.0D0).OR.(AM1.LE.6.6D0))            ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( ((ITSQ(IDXST).EQ.3).OR.(ITSQ2(IDXST).EQ.3)).AND.
c    at least one strange quark
     &         ((AM2.LE.14.6D0).OR.(AM1.LE.5.8D0))        ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( (AM2.LE.13.4D0).OR.(AM1.LE.5.0D0) ) THEN
         IREJ = 1
         RETURN
      ENDIF
c  accept the new sea-diquark
      XTVD(IDXVT)   = XXTV
      XTSQ(IDXST)   = XXTSQ
      XTSAQ(IDXST)  = XXTSAQ
      NVD           = NVD+1
      INTVD1(NVD)   = IDXVP
      INTVD2(NVD)   = IDXST
      ISKPCH(7,NVD) = 0
      RETURN

c---------------------------------------------------------------------
c proj. sea partons - targ. valence partons
c get x-values and flavors for projectile sea-diquark pair

    2 CONTINUE
      IDXSP = IDX2
      IDXVT = IDX1

c  index of corr. val-diquark-x in projectile nucleon
      IDXVP = ITOVP(IFROSP(IDXSP))
c  available x above diquark thresholds for valence- and sea-diquarks
      XXD   = XPVD(IDXVP)+XPSQ(IDXSP)+XPSAQ(IDXSP)-3.0D0*XDTHR

      IF (XXD.GE.ZERO) THEN
c  x-values for the three diquarks of the projectile nucleon
         RR1    = DT_RNDM(XXD)
         RR2    = DT_RNDM(RR1)
         RR3    = DT_RNDM(RR2)
         SR123  = RR1+RR2+RR3
         XXPV   = XDTHR+RR1*XXD/SR123
         XXPSQ  = XDTHR+RR2*XXD/SR123
         XXPSAQ = XDTHR+RR3*XXD/SR123
      ELSE
         XXPV   = XPVD(IDXVP)
         XXPSQ  = XPSQ(IDXSP)
         XXPSAQ = XPSAQ(IDXSP)
      ENDIF
c  flavor of the second quarks in the sea-diquark pair
      IPSQ2(IDXSP)  = INT(1.0D0+DT_RNDM(XXD)*(2.0D0+SEASQ))
      IPSAQ2(IDXSP) = -IPSQ2(IDXSP)
c  check masses of the new sea-qq - val-q, sea-aqaq - val-qq chains
      AM1    = XXPSQ *XTVQ(IDXVT)*ECM**2
      AM2    = XXPSAQ*XTVD(IDXVT)*ECM**2
      IF ( (IPSQ(IDXSP).EQ.3).AND.(IPSQ2(IDXSP).EQ.3).AND.
c    ss-asas pair
     &     ((AM2.LE.18.0D0).OR.(AM1.LE.6.6D0))            ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( ((IPSQ(IDXSP).EQ.3).OR.(IPSQ2(IDXSP).EQ.3)).AND.
c    at least one strange quark
     &         ((AM2.LE.14.6D0).OR.(AM1.LE.5.8D0))        ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( (AM2.LE.13.4D0).OR.(AM1.LE.5.0D0) ) THEN
         IREJ = 1
         RETURN
      ENDIF
c  accept the new sea-diquark
      XPVD(IDXVP)   = XXPV
      XPSQ(IDXSP)   = XXPSQ
      XPSAQ(IDXSP)  = XXPSAQ
      NDV           = NDV+1
      INTDV1(NDV)   = IDXSP
      INTDV2(NDV)   = IDXVT
      ISKPCH(5,NDV) = 0
      RETURN

c---------------------------------------------------------------------
c proj. sea partons - targ. sea partons
c get x-values and flavors for target sea-diquark pair

    3 CONTINUE
      IDXSP = IDX1
      IDXST = IDX2

c  index of corr. val-diquark-x in target nucleon
      IDXVT = ITOVT(IFROST(IDXST))
c  available x above diquark thresholds for valence- and sea-diquarks
      XXD   = XTVD(IDXVT)+XTSQ(IDXST)+XTSAQ(IDXST)-3.0D0*XDTHR

      IF (XXD.GE.ZERO) THEN
c  x-values for the three diquarks of the target nucleon
         RR1    = DT_RNDM(XXD)
         RR2    = DT_RNDM(RR1)
         RR3    = DT_RNDM(RR2)
         SR123  = RR1+RR2+RR3
         XXTV   = XDTHR+RR1*XXD/SR123
         XXTSQ  = XDTHR+RR2*XXD/SR123
         XXTSAQ = XDTHR+RR3*XXD/SR123
      ELSE
         XXTV   = XTVD(IDXVT)
         XXTSQ  = XTSQ(IDXST)
         XXTSAQ = XTSAQ(IDXST)
      ENDIF
c  flavor of the second quarks in the sea-diquark pair
      ITSQ2(IDXST)  = INT(1.0D0+DT_RNDM(XXD)*(2.0D0+SEASQ))
      ITSAQ2(IDXST) = -ITSQ2(IDXST)
c  check masses of the new sea-q - sea-qq, sea-aq - sea-aqaq chains
      AM1    = XXTSQ *XPSQ(IDXSP)*ECM**2
      AM2    = XXTSAQ*XPSAQ(IDXSP)*ECM**2
      IF ( (ITSQ(IDXST).EQ.3).AND.(ITSQ2(IDXST).EQ.3).AND.
c    ss-asas pair
     &     ((AM2.LE.6.6D0).OR.(AM1.LE.6.6D0))            ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( ((ITSQ(IDXST).EQ.3).OR.(ITSQ2(IDXST).EQ.3)).AND.
c    at least one strange quark
     &         ((AM2.LE.5.8D0).OR.(AM1.LE.5.8D0))        ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( (AM2.LE.5.0D0).OR.(AM1.LE.5.0D0) ) THEN
         IREJ = 1
         RETURN
      ENDIF
c  accept the new sea-diquark
      XTVD(IDXVT)   = XXTV
      XTSQ(IDXST)   = XXTSQ
      XTSAQ(IDXST)  = XXTSAQ
      NSD           = NSD+1
      INTSD1(NSD)   = IDXSP
      INTSD2(NSD)   = IDXST
      ISKPCH(3,NSD) = 0
      RETURN

c---------------------------------------------------------------------
c proj. sea partons - targ. sea partons
c get x-values and flavors for projectile sea-diquark pair

    4 CONTINUE
      IDXSP = IDX2
      IDXST = IDX1

c  index of corr. val-diquark-x in projectile nucleon
      IDXVP = ITOVP(IFROSP(IDXSP))
c  available x above diquark thresholds for valence- and sea-diquarks
      XXD   = XPVD(IDXVP)+XPSQ(IDXSP)+XPSAQ(IDXSP)-3.0D0*XDTHR

      IF (XXD.GE.ZERO) THEN
c  x-values for the three diquarks of the projectile nucleon
         RR1    = DT_RNDM(XXD)
         RR2    = DT_RNDM(RR1)
         RR3    = DT_RNDM(RR2)
         SR123  = RR1+RR2+RR3
         XXPV   = XDTHR+RR1*XXD/SR123
         XXPSQ  = XDTHR+RR2*XXD/SR123
         XXPSAQ = XDTHR+RR3*XXD/SR123
      ELSE
         XXPV   = XPVD(IDXVP)
         XXPSQ  = XPSQ(IDXSP)
         XXPSAQ = XPSAQ(IDXSP)
      ENDIF
c  flavor of the second quarks in the sea-diquark pair
      IPSQ2(IDXSP)  = INT(1.0D0+DT_RNDM(RR3)*(2.0D0+SEASQ))
      IPSAQ2(IDXSP) = -IPSQ2(IDXSP)
c  check masses of the new sea-qq - sea-q, sea-aqaq - sea-qq chains
      AM1    = XXPSQ *XTSQ(IDXST)*ECM**2
      AM2    = XXPSAQ*XTSAQ(IDXST)*ECM**2
      IF ( (IPSQ(IDXSP).EQ.3).AND.(IPSQ2(IDXSP).EQ.3).AND.
c    ss-asas pair
     &     ((AM2.LE.6.6D0).OR.(AM1.LE.6.6D0))            ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( ((IPSQ(IDXSP).EQ.3).OR.(IPSQ2(IDXSP).EQ.3)).AND.
c    at least one strange quark
     &         ((AM2.LE.5.8D0).OR.(AM1.LE.5.8D0))        ) THEN
         IREJ = 1
         RETURN
      ELSEIF ( (AM2.LE.5.0D0).OR.(AM1.LE.5.0D0) ) THEN
         IREJ = 1
         RETURN
      ENDIF
c  accept the new sea-diquark
      XPVD(IDXVP)   = XXPV
      XPSQ(IDXSP)   = XXPSQ
      XPSAQ(IDXSP)  = XXPSAQ
      NDS           = NDS+1
      INTDS1(NDS)   = IDXSP
      INTDS2(NDS)   = IDXST
      ISKPCH(2,NDS) = 0
      RETURN
      END
c
c===difevt=============================================================*
c
CDECK  ID>, DT_DIFEVT
      SUBROUTINE DT_DIFEVT(IFP1,IFP2,PP,MOP,
     &                  IFT1,IFT2,PT,MOT,JDIFF,NCSY,IREJ)

c***********************************************************************
c Interface to treatment of diffractive interactions.                  *
c  (input)          IFP1/2        PDG-indizes of projectile partons    *
c                                 (baryon: IFP2 - adiquark)            *
c                   PP(4)         projectile 4-momentum                *
c                   IFT1/2        PDG-indizes of target partons        *
c                                 (baryon: IFT1 - adiquark)            *
c                   PT(4)         target 4-momentum                    *
c  (output)         JDIFF = 0     no diffraction                       *
c                         = 1/-1  LMSD/LMDD                            *
c                         = 2/-2  HMSD/HMDD                            *
c                   NCSY          counter for two-chain systems        *
c                                 dumped to DTEVT1                     *
c This version dated 14.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY10=1.0D-10,TINY5=1.0D-5,
     &           OHALF=0.5D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF


      DIMENSION PP(4),PT(4)

      LOGICAL LFIRST
      DATA LFIRST /.TRUE./

      IREJ   = 0
      JDIFF  = 0
      IFLAGD = JDIFF

c cm. energy
      XM = SQRT((PP(4)+PT(4))**2-(PP(1)+PT(1))**2-
     &          (PP(2)+PT(2))**2-(PP(3)+PT(3))**2)
c identities of projectile hadron / target nucleon
      KPROJ = IDT_ICIHAD(IDHKK(MOP))
      KTARG = IDT_ICIHAD(IDHKK(MOT))

c single diffractive xsections
      CALL DT_SHNDIF(XM,KPROJ,KTARG,SDTOT,SDHM)
c double diffractive xsections
c*!! no double diff yet
C     CALL DT_SHNDIF(XM,KPROJ,KTARG,SDTOT,SDHM,DDTOT,DDHM)
      DDTOT = 0.0D0
      DDHM  = 0.0D0
c*!!
c total inelastic xsection
C     SIGIN  = DT_SHNTOT(KPROJ,KTARG,XM,ZERO)-DT_SHNELA(KPROJ,KTARG,XM)
      DUMZER = ZERO
      CALL DT_XSHN(KPROJ,KTARG,DUMZER,XM,SIGTO,SIGEL)
      SIGIN  = MAX(SIGTO-SIGEL,ZERO)

c fraction of diffractive processes
      FRADIF = (SDTOT+DDTOT)/SIGIN

      IF (LFIRST) THEN
         WRITE(ErrorOut,1000) XM,SDTOT,SIGIN
 1000    FORMAT(1X,'DIFEVT: SINGLE DIFFRACTION REQUESTED AT E_CM = ',
     &          F5.1,' GEV',/,9X,'SIGMA_SD = ',F4.1,' MB, SIGMA_IN = ',
     &          F5.1,' MB',/)
         LFIRST = .FALSE.
      ENDIF

      IF ((DT_RNDM(DDHM).LE.FRADIF).OR.
     &    (ISINGD.GT.1).OR.(IDOUBD.GT.1)) THEN
c diffractive interaction requested by x-section or by user
         FRASD  = SDTOT/(SDTOT+DDTOT)
         FRASDH = SDHM/SDTOT
c*sr needs to be specified!!
C        FRADDH = DDHM/DDTOT
         FRADDH = 1.0D0
c*
         IF ((DT_RNDM(FRASD).LE.FRASD).OR.(ISINGD.GT.1)) THEN
c   single diffraction
            KDIFF = 1
            IF (DT_RNDM(DDTOT).LE.FRASDH) THEN
               KP = 2
               KT = 0
               IF (((ISINGD.EQ.4).OR.(DT_RNDM(DDTOT).GE.OHALF)).AND.
     &               ISINGD.NE.3) THEN
                  KP = 0
                  KT = 2
               ENDIF
            ELSE
               KP = 1
               KT = 0
               IF (((ISINGD.EQ.4).OR.(DT_RNDM(FRADDH).GE.OHALF)).AND.
     &               ISINGD.NE.3) THEN
                  KP = 0
                  KT = 1
               ENDIF
            ENDIF
         ELSE
c   double diffraction
            KDIFF = -1
            IF (DT_RNDM(FRADDH).LE.FRADDH) THEN
               KP = 2
               KT = 2
            ELSE
               KP = 1
               KT = 1
            ENDIF
         ENDIF
         CALL DT_DIFFKI(IFP1,IFP2,PP,MOP,KP,
     &               IFT1,IFT2,PT,MOT,KT,NCSY,IREJ1)
         IF (IREJ1.EQ.0) THEN
            IFLAGD = 2*KDIFF
            IF ((KP.EQ.1).OR.(KT.EQ.1)) IFLAGD = KDIFF
         ELSE
            GOTO 9999
         ENDIF
      ENDIF
      JDIFF = IFLAGD

      RETURN

 9999 CONTINUE
      IREJ  = 1
      RETURN
      END
c
c===difkin=============================================================*
c
CDECK  ID>, DT_DIFFKI
      SUBROUTINE DT_DIFFKI(IFP1,IFP2,PP,MOP,KP,
     &                  IFT1,IFT2,PT,MOT,KT,NCSY,IREJ)

c***********************************************************************
c Kinematics of diffractive nucleon-nucleon interaction.               *
c          IFP1/2   PDG-indizes of projectile partons                  *
c                   (baryon: IFP2 - adiquark)                          *
c          PP(4)    projectile 4-momentum                              *
c          IFT1/2   PDG-indizes of target partons                      *
c                   (baryon: IFT1 - adiquark)                          *
c          PT(4)    target 4-momentum                                  *
c          KP   = 0 projectile quasi-elastically scattered             *
c               = 1            excited to low-mass diff. state         *
c               = 2            excited to high-mass diff. state        *
c          KT   = 0 target     quasi-elastically scattered             *
c               = 1            excited to low-mass diff. state         *
c               = 2            excited to high-mass diff. state        *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,ONE=1.0D0,TINY10=1.0D-10,TINY5=1.0D-5)

      LOGICAL LSTART

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


      DIMENSION PITOT(4),BGTOT(4),PP1(4),PT1(4),PPBLOB(4),PTBLOB(4),
     &          PP(4),PT(4),PPOM1(4),DEV1(4),DEV2(4)

      DATA LSTART /.TRUE./

      IF (LSTART) THEN
         WRITE(ErrorOut,2000)
 2000    FORMAT(/,1X,'DIFEVT:  DIFFRACTIVE INTERACTIONS TREATED ')
         LSTART = .FALSE.
      ENDIF

      IREJ = 0

c initialize common /DTDIKI/
      CALL DT_DIFINI
c store momenta of initial incoming particles for emc-check
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(PP(1),PP(2),PP(3),PP(4),1,IDUM,IDUM)
         CALL DT_EVTEMC(PT(1),PT(2),PT(3),PT(4),2,IDUM,IDUM)
      ENDIF

c masses of initial particles
      XMP2 = PP(4)**2-PP(1)**2-PP(2)**2-PP(3)**2
      XMT2 = PT(4)**2-PT(1)**2-PT(2)**2-PT(3)**2
      IF ((XMP2.LT.ZERO).OR.(XMT2.LT.ZERO)) GOTO 9999
      XMP  = SQRT(XMP2)
      XMT  = SQRT(XMT2)
c check quark-input (used to adjust coherence cond. for M-selection)
      IBP  = 0
      IF ((ABS(IFP1).GE.1000).OR.(ABS(IFP2).GE.1000)) IBP = 1
      IBT  = 0
      IF ((ABS(IFT1).GE.1000).OR.(ABS(IFT2).GE.1000)) IBT = 1

c parameter for Lorentz-transformation into nucleon-nucleon cms
      DO 3 K=1,4
         PITOT(K) = PP(K)+PT(K)
    3 CONTINUE
      XMTOT2 = PITOT(4)**2-PITOT(1)**2-PITOT(2)**2-PITOT(3)**2
      IF (XMTOT2.LE.ZERO) THEN
         WRITE(ErrorOut,1000) XMTOT2
 1000    FORMAT(1X,'DIFEVT:   NEGATIVE CM. ENERGY!  ',
     &          'XMTOT2 = ',E12.3)
         GOTO 9999
      ENDIF
      XMTOT = SQRT(XMTOT2)
      DO 4 K=1,4
         BGTOT(K) = PITOT(K)/XMTOT
    4 CONTINUE
c transformation of nucleons into cms
      CALL DT_DALTRA(BGTOT(4),-BGTOT(1),-BGTOT(2),-BGTOT(3),PP(1),PP(2),
     &            PP(3),PP(4),PPTOT,PP1(1),PP1(2),PP1(3),PP1(4))
      CALL DT_DALTRA(BGTOT(4),-BGTOT(1),-BGTOT(2),-BGTOT(3),PT(1),PT(2),
     &            PT(3),PT(4),PTTOT,PT1(1),PT1(2),PT1(3),PT1(4))
c rotation angles
      COD = PP1(3)/PPTOT
C     SID = SQRT((ONE-COD)*(ONE+COD))
      PPT = SQRT(PP1(1)**2+PP1(2)**2)
      SID = PPT/PPTOT
      COF = ONE
      SIF = ZERO
      IF(PPTOT*SID.GT.TINY10) THEN
         COF   = PP1(1)/(SID*PPTOT)
         SIF   = PP1(2)/(SID*PPTOT)
         ANORF = SQRT(COF*COF+SIF*SIF)
         COF   = COF/ANORF
         SIF   = SIF/ANORF
      ENDIF
c check consistency
      DO 5 K=1,4
         DEV1(K) = ABS(PP1(K)+PT1(K))
    5 CONTINUE
      DEV1(4) = ABS(DEV1(4)-XMTOT)
      IF ((DEV1(1).GT.TINY10).OR.(DEV1(2).GT.TINY10).OR.
     &    (DEV1(3).GT.TINY10).OR.(DEV1(4).GT.TINY10))     THEN
         WRITE(ErrorOut,1001) DEV1
 1001    FORMAT(1X,'DIFEVT:   INCONSITENT LORENTZ-TRANSFORMATION! ',
     &          /,8X,4E12.3)
         GOTO 9999
      ENDIF

c select x-fractions in high-mass diff. interactions
      IF ((KP.EQ.2).OR.(KT.EQ.2)) CALL DT_XVALHM(KP,KT)

c select diffractive masses
c - projectile
      IF (KP.EQ.1) THEN
         XMPF = DT_XMLMD(XMTOT)
         CALL DT_LM2RES(IFP1,IFP2,XMPF,IDPR,IDXPR,IREJ1)
         IF (IREJ1.GT.0) GOTO 9999
      ELSEIF (KP.EQ.2) THEN
         XMPF = DT_XMHMD(XMTOT,IBP,1)
      ELSE
         XMPF = XMP
      ENDIF
c - target
      IF (KT.EQ.1) THEN
         XMTF = DT_XMLMD(XMTOT)
         CALL DT_LM2RES(IFT1,IFT2,XMTF,IDTR,IDXTR,IREJ1)
         IF (IREJ1.GT.0) GOTO 9999
      ELSEIF (KT.EQ.2) THEN
         XMTF = DT_XMHMD(XMTOT,IBT,2)
      ELSE
         XMTF = XMT
      ENDIF

c kinematical treatment of "two-particle" system (masses - XMPF,XMTF)
      XMPF2 = XMPF**2
      XMTF2 = XMTF**2
      PPBLOB(3) = DT_YLAMB(XMTOT2,XMPF2,XMTF2)/(2.D0*XMTOT)
      PPBLOB(4) = SQRT(XMPF2+PPBLOB(3)**2)

c select momentum transfer (all t-values used here are <0)
c   minimum absolute value to produce diffractive masses
      TMIN = XMP2+XMPF2-2.0D0*(PP1(4)*PPBLOB(4)-PPTOT*PPBLOB(3))
      TT   = DT_TDIFF(XMTOT,TMIN,XMPF,KP,XMTF,KT,IREJ1)
      IF (IREJ1.GT.0) GOTO 9999

c longitudinal momentum of excited/elastically scattered projectile
      PPBLOB(3) = (TT-XMP2-XMPF2+2.0D0*PP1(4)*PPBLOB(4))/(2.0D0*PPTOT)
c total transverse momentum due to t-selection
      PPBLT2 = PPBLOB(4)**2-PPBLOB(3)**2-XMPF2
      IF (PPBLT2.LT.ZERO) THEN
         WRITE(ErrorOut,1002) PPBLT2,KP,PP1,XMPF,KT,PT1,XMTF,TT
 1002    FORMAT(1X,'DIFEVT:   INCONSISTENT TRANSVERSE MOMENTUM! ',
     &          E12.3,2(/,1X,I2,5E12.3),/,1X,E12.3)
         GOTO 9999
      ENDIF
      CALL DT_DSFECF(SINPHI,COSPHI)
      PPBLT     = SQRT(PPBLT2)
      PPBLOB(1) = COSPHI*PPBLT
      PPBLOB(2) = SINPHI*PPBLT

c rotate excited/elastically scattered projectile into n-n cms.
      CALL DT_MYTRAN(1,PPBLOB(1),PPBLOB(2),PPBLOB(3),COD,SID,COF,SIF,
     &                                                    XX,YY,ZZ)
      PPBLOB(1) = XX
      PPBLOB(2) = YY
      PPBLOB(3) = ZZ

c 4-momentum of excited/elastically scattered target and of exchanged
c Pomeron
      DO 6 K=1,4
         IF (K.LT.4) PTBLOB(K) = -PPBLOB(K)
         PPOM1(K) = PP1(K)-PPBLOB(K)
    6 CONTINUE
      PTBLOB(4) = XMTOT-PPBLOB(4)

c Lorentz-transformation back into system of initial diff. collision
      CALL DT_DALTRA(BGTOT(4),BGTOT(1),BGTOT(2),BGTOT(3),
     &            PPBLOB(1),PPBLOB(2),PPBLOB(3),PPBLOB(4),
     &            PPTOTF,PPF(1),PPF(2),PPF(3),PPF(4))
      CALL DT_DALTRA(BGTOT(4),BGTOT(1),BGTOT(2),BGTOT(3),
     &            PTBLOB(1),PTBLOB(2),PTBLOB(3),PTBLOB(4),
     &            PTTOTF,PTF(1),PTF(2),PTF(3),PTF(4))
      CALL DT_DALTRA(BGTOT(4),BGTOT(1),BGTOT(2),BGTOT(3),
     &            PPOM1(1),PPOM1(2),PPOM1(3),PPOM1(4),
     &            PPOMTO,PPOM(1),PPOM(2),PPOM(3),PPOM(4))

c store 4-momentum of elastically scattered particle (in single diff.
c events)
      IF (KP.EQ.0) THEN
         DO 7 K=1,4
            PSC(K) = PPF(K)
    7    CONTINUE
      ELSEIF (KT.EQ.0) THEN
         DO 8 K=1,4
            PSC(K) = PTF(K)
    8    CONTINUE
      ENDIF

c check consistency of kinematical treatment so far
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(-PPF(1),-PPF(2),-PPF(3),-PPF(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(-PTF(1),-PTF(2),-PTF(3),-PTF(4),2,IDUM,IDUM)
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,3,60,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF
      DO 9 K=1,4
         DEV1(K) = ABS(PP(K)-PPF(K)-PPOM(K))
         DEV2(K) = ABS(PT(K)-PTF(K)+PPOM(K))
    9 CONTINUE
      IF ((DEV1(1).GT.TINY5).OR.(DEV1(2).GT.TINY5).OR.
     &    (DEV1(3).GT.TINY5).OR.(DEV1(4).GT.TINY5).OR.
     &    (DEV2(1).GT.TINY5).OR.(DEV2(2).GT.TINY5).OR.
     &    (DEV2(3).GT.TINY5).OR.(DEV2(4).GT.TINY5))     THEN
         WRITE(ErrorOut,1003) DEV1,DEV2
 1003    FORMAT(1X,'DIFEVT:   INCONSITENT KINEMATICAL TREATMENT!  ',
     &          2(/,8X,4E12.3))
         GOTO 9999
      ENDIF

c kinematical treatment for low-mass diffraction
      CALL DT_LMKINE(IFP1,IFP2,KP,IFT1,IFT2,KT,IREJ1)
      IF (IREJ1.NE.0) GOTO 9999

c dump diffractive chains into DTEVT1
      CALL DT_DIFPUT(IFP1,IFP2,PP,MOP,KP,IFT1,IFT2,PT,MOT,KT,NCSY,IREJ1)
      IF (IREJ1.NE.0) GOTO 9999

      RETURN

 9999 CONTINUE
      IRDIFF(1) = IRDIFF(1)+1
      IREJ      = 1
      RETURN
      END
c
c===xmhmd==============================================================*
c
CDECK  ID>, DT_XMHMD
      DOUBLE PRECISION FUNCTION DT_XMHMD(ECM,IB,MODE)

c***********************************************************************
c Diffractive mass in high mass single/double diffractive events.      *
c This version dated 11.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (OHALF=0.5D0,ONE=1.0D0,ZERO=0.0D0)

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


C     DATA XCOLOW /0.05D0/
      DATA XCOLOW /0.15D0/

      DT_XMHMD = ZERO
      XH = XPH(2)
      IF (MODE.EQ.2) XH = XTH(2)

c minimum Pomeron-x for high-mass diffraction
c (adjusted to get a smooth transition between HM and LM component)
      R = DT_RNDM(XH)
      XDIMIN = (3.0D0+400.0D0*R**2)/(XH*ECM**2)
      IF (ECM.LE.300.0D0) THEN
         RR     = (1.0D0-EXP(-((ECM/140.0D0)**4)))
         XDIMIN = (3.0D0+400.0D0*(R**2)*RR)/(XH*ECM**2)
      ENDIF
c maximum Pomeron-x for high-mass diffraction
c (coherence condition, adjusted to fit to experimental data)
      IF (IB.NE.0) THEN
c   baryon-diffraction
         XDIMAX = XCOLOW*(1.0D0+EXP(-((ECM/420.0D0)**2)))
      ELSE
c   meson-diffraction
         XDIMAX = XCOLOW*(1.0D0+4.0D0*EXP(-((ECM/420.0D0)**2)))
      ENDIF
c check boundaries
      IF (XDIMIN.GE.XDIMAX) THEN
         XDIMIN = OHALF*XDIMAX
      ENDIF

      KLOOP = 0
    1 CONTINUE
      KLOOP = KLOOP+1
      IF (KLOOP.GT.20) RETURN
c sample Pomeron-x from 1/x-distribution (critical Pomeron)
      XDIFF = DT_SAMPEX(XDIMIN,XDIMAX)
c corr. diffr. mass
      DT_XMHMD = ECM*SQRT(XDIFF)
      IF (DT_XMHMD.LT.2.5D0) GOTO 1

      RETURN
      END
c
c===xmlmd==============================================================*
c
CDECK  ID>, DT_XMLMD
      DOUBLE PRECISION FUNCTION DT_XMLMD(ECM)

c***********************************************************************
c Diffractive mass in high mass single/double diffractive events.      *
c This version dated 11.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c minimum Pomeron-x for low-mass diffraction
C     AMO = 1.5D0
      AMO = 2.0D0
c maximum Pomeron-x for low-mass diffraction
c (adjusted to get a smooth transition between HM and LM component)
      R   = DT_RNDM(AMO)
      SAM = 1.0D0
      IF (ECM.LE.300.0D0) SAM = 1.0D0-EXP(-((ECM/200.0D0)**4))
      R   = DT_RNDM(AMO)*SAM
      AMAX= (1.0D0-SAM)*SQRT(0.1D0*ECM**2)+SAM*SQRT(400.0D0)
      AMU = R*SQRT(100.0D0)+(1.0D0-R)*AMAX

c selection of diffractive mass
c (adjusted to get a smooth transition between HM and LM component)
      R   = DT_RNDM(AMU)
      IF (ECM.LE.50.0D0) THEN
         DT_XMLMD = AMO*(AMU/AMO)**R
      ELSE
         A = 0.7D0
         IF (ECM.LE.300.0D0) A = 0.7D0*(1.0D0-EXP(-((ECM/100.0D0)**2)))
         DT_XMLMD = 1.0D0/((R/(AMU**A)+(1.0D0-R)/(AMO**A))**(1.0D0/A))
      ENDIF

      RETURN
      END
c
c===tdiff==============================================================*
c
CDECK  ID>, DT_TDIFF
      DOUBLE PRECISION FUNCTION DT_TDIFF(ECM,TMIN,XM1I,K1,XM2I,K2,IREJ)

c***********************************************************************
c t-selection for single/double diffractive interactions.              *
c          ECM      cm. energy                                         *
c          TMIN     minimum momentum transfer to produce diff. masses  *
c          XM1/XM2  diffractively produced masses                      *
c                   (for single diffraction XM2 is obsolete)           *
c          K1/K2= 0 not excited                                        *
c               = 1 low-mass excitation                                *
c               = 2 high-mass excitation                               *
c This version dated 11.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0)

      PARAMETER ( BTP0   = 3.7D0,
     &            ALPHAP = 0.24D0 )

      IREJ   = 0
      NCLOOP = 0
      DT_TDIFF  = ZERO

      IF (K1.GT.0) THEN
         XM1 = XM1I
         XM2 = XM2I
      ELSE
         XM1 = XM2I
      ENDIF
      XDI = (XM1/ECM)**2
      IF ((K1.EQ.0).OR.(K2.EQ.0)) THEN
c slope for single diffraction
         SLOPE = BTP0-2.0D0*ALPHAP*LOG(XDI)
      ELSE
c slope for double diffraction
         SLOPE = -2.0D0*ALPHAP*LOG(XDI*XM2**2)
      ENDIF

    1 CONTINUE
      NCLOOP = NCLOOP+1
      IF (MOD(NCLOOP,1000).EQ.0) GOTO 9999
      Y = DT_RNDM(XDI)
      T = -LOG(1.0D0-Y)/SLOPE
      IF (ABS(T).LE.ABS(TMIN)) GOTO 1
      DT_TDIFF = -ABS(T)

      RETURN

 9999 CONTINUE
      WRITE(ErrorOut,1000) ECM,TMIN,XM1I,XM2I,K1,K2
 1000 FORMAT(1X,'DT_TDIFF:   T-SELECTION REJECTED!',/,
     &       1X,'ECM  = ',E12.3,' TMIN = ',E12.2,/,1X,'XM1I = ',
     &       E12.3,' XM2I = ',E12.3,' K1 = ',I2,' K2 = ',I2)
      IREJ = 1
      RETURN
      END
c
c===xvalhm=============================================================*
c
CDECK  ID>, DT_XVALHM
      SUBROUTINE DT_XVALHM(KP,KT)

c***********************************************************************
c Sampling of parton x-values in high-mass diffractive interactions.   *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0,TINY2=1.0D-2)

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)

c various options for treatment of partons (DTUNUC 1.x)
c (chain recombination, Cronin,..)
      LOGICAL LCO2CR,LINTPT
      COMMON /DTCHAI/ SEASQ,CRONCO,CUTOF,MKCRON,ISICHA,IRECOM,
     &                LCO2CR,LINTPT


      DATA UNON,XVQTHR /2.0D0,0.8D0/

      IF (KP.EQ.2) THEN
c x-fractions of projectile valence partons
    1    CONTINUE
         XPH(1) = DT_DBETAR(OHALF,UNON)
         IF (XPH(1).GE.XVQTHR) GOTO 1
         XPH(2) = ONE-XPH(1)
c x-fractions of Pomeron q-aq-pair
         XPOLO = TINY2
         XPOHI = ONE-TINY2
         XPPO(1) = DT_SAMPEX(XPOLO,XPOHI)
         XPPO(2) = ONE-XPPO(1)
c flavors of Pomeron q-aq-pair
         IFLAV    = INT(ONE+DT_RNDM(UNON)*(2.0D0+SEASQ))
         IFPPO(1) = IFLAV
         IFPPO(2) = -IFLAV
         IF (DT_RNDM(UNON).GT.OHALF) THEN
            IFPPO(1) = -IFLAV
            IFPPO(2) = IFLAV
         ENDIF
      ENDIF

      IF (KT.EQ.2) THEN
c x-fractions of projectile target partons
    2    CONTINUE
         XTH(1) = DT_DBETAR(OHALF,UNON)
         IF (XTH(1).GE.XVQTHR) GOTO 2
         XTH(2) = ONE-XTH(1)
c x-fractions of Pomeron q-aq-pair
         XPOLO = TINY2
         XPOHI = ONE-TINY2
         XTPO(1) = DT_SAMPEX(XPOLO,XPOHI)
         XTPO(2) = ONE-XTPO(1)
c flavors of Pomeron q-aq-pair
         IFLAV    = INT(ONE+DT_RNDM(XPOLO)*(2.0D0+SEASQ))
         IFTPO(1) = IFLAV
         IFTPO(2) = -IFLAV
         IF (DT_RNDM(XPOLO).GT.OHALF) THEN
            IFTPO(1) = -IFLAV
            IFTPO(2) = IFLAV
         ENDIF
      ENDIF

      RETURN
      END
c
c===lm2res=============================================================*
c
CDECK  ID>, DT_LM2RES
      SUBROUTINE DT_LM2RES(IF1,IF2,XM,IDR,IDXR,IREJ)

c***********************************************************************
c Check low-mass diffractive excitation for resonance mass.            *
c   (input)   IF1/2    PDG-indizes of valence partons                  *
c   (in/out)  XM       diffractive mass requested/corrected            *
c   (output)  IDR/IDXR id./BAMJET-index of resonance                   *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


      IREJ = 0
      IF1B = 0
      IF2B = 0
      XMI  = XM

c BAMJET indices of partons
      IF1A = IDT_IPDG2B(IF1,1,2)
      IF (ABS(IF1).GE.1000) IF1B = IDT_IPDG2B(IF1,2,2)
      IF2A = IDT_IPDG2B(IF2,1,2)
      IF (ABS(IF2).GE.1000) IF2B = IDT_IPDG2B(IF2,2,2)

c get kind of chains (1 - q-aq, 2 - q-qq/aq-aqaq)
      IDCH = 2
      IF ((IF1B.EQ.0).AND.(IF2B.EQ.0)) IDCH = 1

c check for resonance mass
      CALL DT_CH2RES(IF1A,IF1B,IF2A,IF2B,IDR,IDXR,XMI,XMN,IDCH,IREJ1)
      IF (IREJ1.NE.0) GOTO 9999

      XM = XMN
      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===lmkine=============================================================*
c
CDECK  ID>, DT_LMKINE
      SUBROUTINE DT_LMKINE(IFP1,IFP2,KP,IFT1,IFT2,KT,IREJ)

c***********************************************************************
c Kinematical treatment of low-mass excitations.                       *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)



c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


      DIMENSION P1(4),P2(4)

      IREJ = 0

      IF (KP.EQ.1) THEN
         PABS = SQRT(PPF(1)**2+PPF(2)**2+PPF(3)**2)
         POE  = PPF(4)/PABS
         FAC1 = OHALF*(POE+ONE)
         FAC2 = -OHALF*(POE-ONE)
         DO 1 K=1,3
            PPLM1(K) = FAC1*PPF(K)
            PPLM2(K) = FAC2*PPF(K)
    1    CONTINUE
         PPLM1(4) = FAC1*PABS
         PPLM2(4) = -FAC2*PABS
         IF (IMSHL.EQ.1) THEN

            XM1 = PYMASS(IFP1)
            XM2 = PYMASS(IFP2)

            CALL DT_MASHEL(PPLM1,PPLM2,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 2 K=1,4
               PPLM1(K) = P1(K)
               PPLM2(K) = P2(K)
    2       CONTINUE
         ENDIF
      ENDIF

      IF (KT.EQ.1) THEN
         PABS = SQRT(PTF(1)**2+PTF(2)**2+PTF(3)**2)
         POE  = PTF(4)/PABS
         FAC1 = OHALF*(POE+ONE)
         FAC2 = -OHALF*(POE-ONE)
         DO 3 K=1,3
            PTLM2(K) = FAC1*PTF(K)
            PTLM1(K) = FAC2*PTF(K)
    3    CONTINUE
         PTLM2(4) = FAC1*PABS
         PTLM1(4) = -FAC2*PABS
         IF (IMSHL.EQ.1) THEN

            XM1 = PYMASS(IFT1)
            XM2 = PYMASS(IFT2)

            CALL DT_MASHEL(PTLM1,PTLM2,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 4 K=1,4
               PTLM1(K) = P1(K)
               PTLM2(K) = P2(K)
    4       CONTINUE
         ENDIF
      ENDIF

      RETURN

 9999 CONTINUE
      WRITE(ErrorOut,
     * '(A)') 'LMKINE:   kinematical treatment rejected'
      IREJ = 1
      RETURN
      END
c
c===difini=============================================================*
c
CDECK  ID>, DT_DIFINI
      SUBROUTINE DT_DIFINI

c***********************************************************************
c Initialization of common /DTDIKI/                                    *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)


      DO 1 K=1,4
         PPOM(K)  = ZERO
         PSC(K)   = ZERO
         PPF(K)   = ZERO
         PTF(K)   = ZERO
         PPLM1(K) = ZERO
         PPLM2(K) = ZERO
         PTLM1(K) = ZERO
         PTLM2(K) = ZERO
    1 CONTINUE
      DO 2 K=1,2
         XPH(K)   = ZERO
         XPPO(K)  = ZERO
         XTH(K)   = ZERO
         XTPO(K)  = ZERO
         IFPPO(K) = 0
         IFTPO(K) = 0
    2 CONTINUE
      IDPR  = 0
      IDXPR = 0
      IDTR  = 0
      IDXTR = 0

      RETURN
      END
c
c===difput=============================================================*
c
CDECK  ID>, DT_DIFPUT
      SUBROUTINE DT_DIFPUT(IFP1,IFP2,PP,MOP,KP,IFT1,IFT2,PT,MOT,KT,NCSY,
     &                                                          IREJ)

c***********************************************************************
c Dump diffractive chains into DTEVT1                                  *
c This version dated 12.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (ZERO=0.0D0,OHALF=0.5D0,ONE=1.0D0)

      LOGICAL LCHK

c kinematics of diffractive interactions (DTUNUC 1.x)
      COMMON /DTDIKI/ XPH(2),XPPO(2),XTH(2),XTPO(2),PPOM(4),PSC(4),
     &                PPF(4),PTF(4),
     &                PPLM1(4),PPLM2(4),PTLM1(4),PTLM2(4),
     &                IDPR,IDXPR,IDTR,IDXTR,IFPPO(2),IFTPO(2)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC


      DIMENSION PP1(4),PP2(4),PT1(4),PT2(4),PCH(4),PP(4),PT(4),
     &          P1(4),P2(4),P3(4),P4(4)

      IREJ = 0

      IF (KP.EQ.1) THEN
         DO 1 K=1,4
            PCH(K) = PPLM1(K)+PPLM2(K)
    1    CONTINUE
         ID1 = IFP1
         ID2 = IFP2
         IF (DT_RNDM(PT).GT.OHALF) THEN
            ID1 = IFP2
            ID2 = IFP1
         ENDIF
         CALL DT_EVTPUT(21,ID1,MOP,0,PPLM1(1),PPLM1(2),PPLM1(3),
     &                                        PPLM1(4),0,0,0)
         CALL DT_EVTPUT(21,ID2,MOP,0,PPLM2(1),PPLM2(2),PPLM2(3),
     &                                        PPLM2(4),0,0,0)
         CALL DT_EVTPUT(281,88888,-2,-1,PCH(1),PCH(2),PCH(3),PCH(4),
     &                                              IDPR,IDXPR,8)
      ELSEIF (KP.EQ.2) THEN
         DO 2 K=1,4
            PP1(K) = XPH(1)*PP(K)
            PP2(K) = XPH(2)*PP(K)
            PT1(K) = -XPPO(1)*PPOM(K)
            PT2(K) = -XPPO(2)*PPOM(K)
    2    CONTINUE
         CALL  DT_CHKCSY(IFP1,IFPPO(1),LCHK)
         XM1 = ZERO
         XM2 = ZERO
         IF (LCHK) THEN
            CALL DT_MASHEL(PP1,PT1,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            CALL DT_MASHEL(PP2,PT2,XM1,XM2,P3,P4,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 3 K=1,4
               PP1(K) = P1(K)
               PT1(K) = P2(K)
               PP2(K) = P3(K)
               PT2(K) = P4(K)
    3       CONTINUE
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFPPO(1),MOT,0,PT1(1),PT1(2),PT1(3),
     &                                             PT1(4),0,0,8)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFPPO(2),MOT,0,PT2(1),PT2(2),PT2(3),
     &                                             PT2(4),0,0,8)
         ELSE
            CALL DT_MASHEL(PP1,PT2,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            CALL DT_MASHEL(PP2,PT1,XM1,XM2,P3,P4,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 4 K=1,4
               PP1(K) = P1(K)
               PT2(K) = P2(K)
               PP2(K) = P3(K)
               PT1(K) = P4(K)
    4       CONTINUE
            CALL DT_EVTPUT(-21,IFP1,MOP,0,PP1(1),PP1(2),PP1(3),PP1(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFPPO(2),MOT,0,PT2(1),PT2(2),PT2(3),
     &                                                PT2(4),0,0,8)
            CALL DT_EVTPUT(-21,IFP2,MOP,0,PP2(1),PP2(2),PP2(3),PP2(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFPPO(1),MOT,0,PT1(1),PT1(2),PT1(3),
     &                                                PT1(4),0,0,8)
         ENDIF
         NCSY = NCSY+1
      ELSE
         CALL DT_EVTPUT(1,IDHKK(MOP),MOP,0,PSC(1),PSC(2),PSC(3),PSC(4),
     &                                                        0,0,0)
      ENDIF

      IF (KT.EQ.1) THEN
         DO 5 K=1,4
            PCH(K) = PTLM1(K)+PTLM2(K)
    5    CONTINUE
         ID1 = IFT1
         ID2 = IFT2
         IF (DT_RNDM(PT).GT.OHALF) THEN
            ID1 = IFT2
            ID2 = IFT1
         ENDIF
         CALL DT_EVTPUT(22,ID1,MOT,0,PTLM1(1),PTLM1(2),PTLM1(3),
     &                                              PTLM1(4),0,0,0)
         CALL DT_EVTPUT(22,ID2,MOT,0,PTLM2(1),PTLM2(2),PTLM2(3),
     &                                              PTLM2(4),0,0,0)
         CALL DT_EVTPUT(281,88888,-2,-1,PCH(1),PCH(2),PCH(3),PCH(4),
     &                                              IDTR,IDXTR,8)
      ELSEIF (KT.EQ.2) THEN
         DO 6 K=1,4
            PP1(K) = XTPO(1)*PPOM(K)
            PP2(K) = XTPO(2)*PPOM(K)
            PT1(K) = XTH(2)*PT(K)
            PT2(K) = XTH(1)*PT(K)
    6    CONTINUE
         CALL  DT_CHKCSY(IFTPO(1),IFT1,LCHK)
         XM1 = ZERO
         XM2 = ZERO
         IF (LCHK) THEN
            CALL DT_MASHEL(PP1,PT1,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            CALL DT_MASHEL(PP2,PT2,XM1,XM2,P3,P4,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 7 K=1,4
               PP1(K) = P1(K)
               PT1(K) = P2(K)
               PP2(K) = P3(K)
               PT2(K) = P4(K)
    7       CONTINUE
            CALL DT_EVTPUT(-41,IFTPO(1),MOP,0,PP1(1),PP1(2),PP1(3),
     &                                                PP1(4),0,0,8)
            CALL DT_EVTPUT(-21,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFTPO(2),MOP,0,PP2(1),PP2(2),PP2(3),
     &                                                PP2(4),0,0,8)
            CALL DT_EVTPUT(-21,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,8)
         ELSE
            CALL DT_MASHEL(PP1,PT2,XM1,XM2,P1,P2,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            CALL DT_MASHEL(PP2,PT1,XM1,XM2,P3,P4,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            DO 8 K=1,4
               PP1(K) = P1(K)
               PT2(K) = P2(K)
               PP2(K) = P3(K)
               PT1(K) = P4(K)
    8       CONTINUE
            CALL DT_EVTPUT(-41,IFTPO(1),MOP,0,PP1(1),PP1(2),PP1(3),
     &                                                PP1(4),0,0,8)
            CALL DT_EVTPUT(-21,IFT2,MOT,0,PT2(1),PT2(2),PT2(3),PT2(4),
     &                                                       0,0,8)
            CALL DT_EVTPUT(-41,IFTPO(2),MOP,0,PP2(1),PP2(2),PP2(3),
     &                                                PP2(4),0,0,8)
            CALL DT_EVTPUT(-21,IFT1,MOT,0,PT1(1),PT1(2),PT1(3),PT1(4),
     &                                                       0,0,8)
         ENDIF
         NCSY = NCSY+1
      ELSE
         CALL DT_EVTPUT(1,IDHKK(MOT),MOT,0,PSC(1),PSC(2),PSC(3),PSC(4),
     &                                                        0,0,0)
      ENDIF

      RETURN

 9999 CONTINUE
      IRDIFF(2) = IRDIFF(2)+1
      IREJ      = 1
      RETURN
      END
c
c===evtfrg=============================================================*
c
CDECK  ID>, DT_EVTFRG
      SUBROUTINE DT_EVTFRG(KMODE,NFRG,NPYMEM,IREJ)

c***********************************************************************
c Hadronization of chains in DTEVT1.                                   *
c                                                                      *
c Input:                                                               *
c   KMODE = 1   hadronization of PHOJET-chains (id=77xxx)              *
c         = 2   hadronization of DTUNUC-chains (id=88xxx)              *
c   NFRG  if KMODE = 1 : upper index of PHOJET-scatterings to be       *
c                        hadronized with one PYEXEC call               *
c         if KMODE = 2 : max. number of DTUNUC-chains to be hadronized *
c                        with one PYEXEC call                          *
c Output:                                                              *
c   NPYMEM      number of entries in JETSET-common after hadronization *
c   IREJ        rejection flag                                         *
c                                                                      *
c This version dated 17.09.00 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY3=1.0D-3,TINY1=1.0D-1)
      PARAMETER (ONE=1.0D0,ZERO=0.0D0)

      LOGICAL LACCEP

      PARAMETER (MXJOIN=200)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c statistics
      COMMON /DTSTA1/ ICREQU,ICSAMP,ICCPRO,ICDPR,ICDTA,
     &                ICRJSS,ICVV2S,ICCHAI(2,9),ICRES(9),ICDIFF(5),
     &                ICEVTG(8,0:30)

c flags for diffractive interactions (DTUNUC 1.x)
      COMMON /DTFLG3/ ISINGD,IDOUBD,IFLAGD,IDIFF

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c phojet
C  model switches and parameters
      CHARACTER*8 MDLNA
      INTEGER ISWMDL,IPAMDL
      DOUBLE PRECISION PARMDL
      COMMON /POMDLS/ MDLNA(50),ISWMDL(50),PARMDL(400),IPAMDL(400)

c jetset

      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      PARAMETER (MAXLND=4000)
      COMMON/PYJETS/N,NPAD,K(MAXLND,5),P(MAXLND,5),V(MAXLND,5)



      INTEGER PYK

      DIMENSION IJOIN(MXJOIN),ISJOIN(MXJOIN),IHISMO(8000),IFLG(4000)

      MODE = KMODE
      ISTSTG = 7
      IF (MODE.NE.1) ISTSTG = 8
      IREJ = 0

      IP     = 0
      ISH    = 0
      INIEMC = 1
      NEND   = NHKK
      NACCEP = 0
      IFRG   = 0
      IF (NPOINT(4).LE.NPOINT(3)) NPOINT(4) = NHKK+1
      DO 10 I=NPOINT(3),NEND
c sr 14.02.00: seems to be not necessary anymore, commented
C        LACCEP = ((NOBAM(I).EQ.0).AND.(MODE.EQ.1)).OR.
C    &            ((NOBAM(I).NE.0).AND.(MODE.EQ.2))
         LACCEP = .TRUE.
c pick up chains from dtevt1
         IDCHK = IDHKK(I)/10000
         IF ((IDCHK.EQ.ISTSTG).AND.LACCEP) THEN
            IF (IDCHK.EQ.7) THEN
               IPJE = IDHKK(I)-IDCHK*10000
               IF (IPJE.NE.IFRG) THEN
                  IFRG = IPJE
                  IF (IFRG.GT.NFRG) GOTO 16
               ENDIF
            ELSE
               IPJE = 1
               IFRG = IFRG+1
               IF (IFRG.GT.NFRG) THEN
                  NFRG = -1
                  GOTO 16
               ENDIF
            ENDIF
c   statistics counter
c           IF (IDCH(I).LE.8)
c    &         ICCHAI(2,IDCH(I)) = ICCHAI(2,IDCH(I))+1
c           IF (IDRES(I).NE.0) ICRES(IDCH(I)) = ICRES(IDCH(I))+1
c special treatment for small chains already corrected to hadrons
            IF (IDRES(I).NE.0) THEN
               IF (IDRES(I).EQ.11) THEN
                  ID = IDXRES(I)
               ELSE
                  ID = IDT_IPDGHA(IDXRES(I))
               ENDIF
               IF (LEMCCK) THEN
                  CALL DT_EVTEMC(PHKK(1,I),PHKK(2,I),PHKK(3,I),
     &                              PHKK(4,I),INIEMC,IDUM,IDUM)
                  INIEMC = 2
               ENDIF
               IP = IP+1
               IF (IP.GT.MSTU(4)) STOP ' NEWFRA 1: IP.GT.MSTU(4) !'
               P(IP,1) = PHKK(1,I)
               P(IP,2) = PHKK(2,I)
               P(IP,3) = PHKK(3,I)
               P(IP,4) = PHKK(4,I)
               P(IP,5) = PHKK(5,I)
               K(IP,1) = 1
               K(IP,2) = ID
               K(IP,3) = 0
               K(IP,4) = 0
               K(IP,5) = 0
               IHIST(2,I) = 10000*IPJE+IP
               IF (IHIST(1,I).LE.-100) THEN
                  ISH = ISH+1
                  IF (ISH.GT.MXJOIN) STOP 'ISH > MXJOIN !'
                  ISJOIN(ISH) = I
               ENDIF
               N = IP
               IHISMO(IP) = I
            ELSE
               IJ  = 0
               DO 11 KK=JMOHKK(1,I),JMOHKK(2,I)
                  IF (LEMCCK) THEN
                     CALL DT_EVTEMC(PHKK(1,KK),PHKK(2,KK),PHKK(3,KK),
     &                                   PHKK(4,KK),INIEMC,IDUM,IDUM)
                     CALL DT_EVTFLC(IDHKK(KK),1,INIEMC,IDUM,IDUM)
                     INIEMC = 2
                  ENDIF
                  ID = IDHKK(KK)
                  IF (ID.EQ.0) ID = 21
c                  PTOT = SQRT(PHKK(1,KK)**2+PHKK(2,KK)**2+PHKK(3,KK)**2)
c                  AM0  = SQRT(ABS((PHKK(4,KK)-PTOT)*(PHKK(4,KK)+PTOT)))

c                  AMRQ   = PYMASS(ID)

c                  AMDIF2 = (AM0-AMRQ)*(AM0+AMRQ)
c                  IF ((ABS(AMDIF2).GT.TINY3).AND.(PTOT.GT.ZERO).AND.
c     &                (ABS(IDIFF).EQ.0)) THEN
cC                    WRITE(LOUT,*)'here: ',NEVHKK,AM0,AMRQ
c                     DELTA      = -AMDIF2/(2.0D0*(PHKK(4,KK)+PTOT))
c                     PHKK(4,KK) = PHKK(4,KK)+DELTA
c                     PTOT1      = PTOT-DELTA
c                     PHKK(1,KK) = PHKK(1,KK)*PTOT1/PTOT
c                     PHKK(2,KK) = PHKK(2,KK)*PTOT1/PTOT
c                     PHKK(3,KK) = PHKK(3,KK)*PTOT1/PTOT
c                     PHKK(5,KK) = AMRQ
c                  ENDIF
                  IP = IP+1
                  IF (IP.GT.MSTU(4)) STOP ' NEWFRA 2: IP.GT.MSTU(4) !'
                  P(IP,1) = PHKK(1,KK)
                  P(IP,2) = PHKK(2,KK)
                  P(IP,3) = PHKK(3,KK)
                  P(IP,4) = PHKK(4,KK)
                  P(IP,5) = PHKK(5,KK)
                  K(IP,1) = 1
                  K(IP,2) = ID
                  K(IP,3) = 0
                  K(IP,4) = 0
                  K(IP,5) = 0
                  IHIST(2,KK) = 10000*IPJE+IP
                  IF (IHIST(1,KK).LE.-100) THEN
                     ISH = ISH+1
                     IF (ISH.GT.MXJOIN) STOP 'ISH > MXJOIN !'
                     ISJOIN(ISH) = KK
                  ENDIF
                  IJ = IJ+1
                  IF (IJ.GT.MXJOIN) STOP 'IJ > MXJOIN !'
                  IJOIN(IJ)  = IP
                  IHISMO(IP) = I
   11          CONTINUE
               N = IP
c join the two-parton system

               CALL PYJOIN(IJ,IJOIN)

            ENDIF
            IDHKK(I) = 99999
         ENDIF
   10 CONTINUE
   16 CONTINUE
      N = IP

      IF (IP.GT.0) THEN

c final state parton shower
         DO 136 NPJE=1,IPJE
            IF ((MCGENE.EQ.2).AND.(ISH.GE.2)) THEN
               IF ((ISWMDL(8).EQ.1).OR.(ISWMDL(8).EQ.3)) THEN
                  DO 130 K1=1,ISH
                     IF (ISJOIN(K1).EQ.0) GOTO 130
                     I = ISJOIN(K1)
                     IF ((IPAMDL(102).EQ.1).AND.(IHIST(1,I).NE.-100))
     &                                                       GOTO 130
                     IH1 = IHIST(2,I)/10000
                     IF (IH1.NE.NPJE) GOTO 130
                     IH1 = IHIST(2,I)-IH1*10000
                     DO 135 K2=K1+1,ISH
                        IF (ISJOIN(K2).EQ.0) GOTO 135
                        II = ISJOIN(K2)
                        IH2 = IHIST(2,II)/10000
                        IF (IH2.NE.NPJE) GOTO 135
                        IH2 = IHIST(2,II)-IH2*10000
                        IF (IHIST(1,I).EQ.IHIST(1,II)) THEN
                           PT1 = SQRT(PHKK(1,II)**2+PHKK(2,II)**2)
                           PT2 = SQRT(PHKK(1, I)**2+PHKK(2, I)**2)

                           RQLUN = MIN(PT1,PT2)
                           CALL PYSHOW(IH1,IH2,RQLUN)

                           ISJOIN(K1) = 0
                           ISJOIN(K2) = 0
                           GOTO 130
                        ENDIF
 135                 CONTINUE
 130              CONTINUE
               ENDIF
            ENDIF
 136     CONTINUE

         CALL DT_INITJS(MODE)
c hadronization

         CALL PYEXEC

         IF (MSTU(24).NE.0) THEN
            WRITE(ErrorOut,*) ' JETSET-reject at event',
     &                    NEVHKK,MSTU(24),KMODE
C           CALL DT_EVTOUT(4)

C           CALL PYLIST(2)

            GOTO 9999
         ENDIF

c   number of entries in LUJETS

         NLINES = PYK(0,1)

         NPYMEM = NLINES

         DO 12 I=1,NLINES
            IFLG(I) = 0
   12    CONTINUE

         DO 13 II=1,NLINES

            IF ((PYK(II,7).EQ.1).AND.(IFLG(II).NE.1)) THEN

c  pick up mother resonance if possible and put it together with
c  their decay-products into the common
               IDXMOR = K(II,3)
               IF ((IDXMOR.GE.1).AND.(IDXMOR.LE.MAXLND)) THEN
                  KFMOR = K(IDXMOR,2)
                  ISMOR = K(IDXMOR,1)
               ELSE
                  KFMOR = 91
                  ISMOR = 1
               ENDIF
               IF ((KFMOR.NE.91).AND.(KFMOR.NE.92).AND.
     &             (KFMOR.NE.94).AND.(ISMOR.EQ.11)) THEN
                  ID = K(IDXMOR,2)

                  MO = IHISMO(PYK(IDXMOR,15))
                  PX = PYP(IDXMOR,1)
                  PY = PYP(IDXMOR,2)
                  PZ = PYP(IDXMOR,3)
                  PE = PYP(IDXMOR,4)

                  CALL DT_EVTPUT(2,ID,MO,0,PX,PY,PZ,PE,0,0,0)
                  IFLG(IDXMOR) = 1
                  MO = NHKK
                  DO 15 JDAUG=K(IDXMOR,4),K(IDXMOR,5)

                     IF (PYK(JDAUG,7).EQ.1) THEN
                        ID = PYK(JDAUG,8)
                        PX = PYP(JDAUG,1)
                        PY = PYP(JDAUG,2)
                        PZ = PYP(JDAUG,3)
                        PE = PYP(JDAUG,4)

                        CALL DT_EVTPUT(1,ID,MO,0,PX,PY,PZ,PE,0,0,0)
                        IF (LEMCCK) THEN

                           PX = -PYP(JDAUG,1)
                           PY = -PYP(JDAUG,2)
                           PZ = -PYP(JDAUG,3)
                           PE = -PYP(JDAUG,4)

                           CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM,IDUM)
                        ENDIF
                        IFLG(JDAUG) = 1
                     ENDIF
   15             CONTINUE
               ELSE
c  there was no mother resonance

                  MO = IHISMO(PYK(II,15))
                  ID = PYK(II,8)
                  PX = PYP(II,1)
                  PY = PYP(II,2)
                  PZ = PYP(II,3)
                  PE = PYP(II,4)

                  CALL DT_EVTPUT(1,ID,MO,0,PX,PY,PZ,PE,0,0,0)
                  IF (LEMCCK) THEN

                     PX = -PYP(II,1)
                     PY = -PYP(II,2)
                     PZ = -PYP(II,3)
                     PE = -PYP(II,4)

                     CALL DT_EVTEMC(PX,PY,PZ,PE,2,IDUM,IDUM)
                  ENDIF
               ENDIF
            ENDIF
   13    CONTINUE
         IF (LEMCCK) THEN
            CHKLEV = TINY1
            CALL DT_EVTEMC(DUM,DUM,DUM,CHKLEV,-1,6,IREJ1)
C           IF (IREJ1.NE.0) CALL DT_EVTOUT(4)
         ENDIF

c global energy-momentum & flavor conservation check
c*sr 16.5. this check is skipped in case of phojet-treatment
         IF (MCGENE.EQ.1)
     &      CALL DT_EMC2(9,10,0,0,0,3,1,0,0,0,0,3,4,12,IREJ3)

c update statistics-counter for diffraction
c        IF (IFLAGD.NE.0) THEN
c           ICDIFF(1) = ICDIFF(1)+1
c           IF (IFLAGD.EQ. 1) ICDIFF(2) = ICDIFF(2)+1
c           IF (IFLAGD.EQ. 2) ICDIFF(3) = ICDIFF(3)+1
c           IF (IFLAGD.EQ.-1) ICDIFF(4) = ICDIFF(4)+1
c           IF (IFLAGD.EQ.-2) ICDIFF(5) = ICDIFF(5)+1
c        ENDIF

      ENDIF

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===decay==============================================================*
c
CDECK  ID>, DT_DECAYS
      SUBROUTINE DT_DECAYS(PIN,IDXIN,POUT,IDXOUT,NSEC,IREJ)

c***********************************************************************
c Resonance-decay.                                                     *
c This subroutine replaces DDECAY/DECHKK.                              *
c             PIN(4)      4-momentum of resonance          (input)     *
c             IDXIN       BAMJET-index of resonance        (input)     *
c             POUT(20,4)  4-momenta of decay-products      (output)    *
c             IDXOUT(20)  BAMJET-indices of decay-products (output)    *
c             NSEC        number of secondaries            (output)    *
c Adopted from the original version DECHKK.                            *
c This version dated 09.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY17=1.0D-17)

c HADRIN: decay channel information
      PARAMETER (IDMAX9=602)
      CHARACTER*8 ZKNAME
      COMMON /HNDECH/ ZKNAME(IDMAX9),WT(IDMAX9),NZK(IDMAX9,3)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      DIMENSION PIN(4),PI(20,4),POUT(20,4),IDXOUT(20),
     &          EF(3),PF(3),PFF(3),IDXSTK(20),IDX(3),
     &          CODF(3),COFF(3),SIFF(3),DCOS(3),DCOSF(3)

c ISTAB = 1 strong and weak decays
c       = 2 strong decays only
c       = 3 strong decays, weak decays for charmed particles and tau
c           leptons only
      DATA ISTAB /2/

      IREJ = 0
      NSEC = 0
c put initial resonance to stack
      NSTK = 1
      IDXSTK(NSTK) = IDXIN
      DO 5 I=1,4
         PI(NSTK,I) = PIN(I)
    5 CONTINUE

c store initial configuration for energy-momentum cons. check
      IF (LEMCCK) CALL DT_EVTEMC(PI(NSTK,1),PI(NSTK,2),PI(NSTK,3),
     &                                   PI(NSTK,4),1,IDUM,IDUM)

  100 CONTINUE
c get particle from stack
      IDXI = IDXSTK(NSTK)
c skip stable particles
      IF (ISTAB.EQ.1) THEN
         IF ((IDXI.EQ.135).OR. (IDXI.EQ.136)) GOTO 10
         IF ((IDXI.GE.  1).AND.(IDXI.LE.  7)) GOTO 10
      ELSEIF (ISTAB.EQ.2) THEN
         IF ((IDXI.GE.  1).AND.(IDXI.LE. 30)) GOTO 10
         IF ((IDXI.GE. 97).AND.(IDXI.LE.103)) GOTO 10
         IF ((IDXI.GE.115).AND.(IDXI.LE.122)) GOTO 10
         IF ((IDXI.GE.131).AND.(IDXI.LE.136)) GOTO 10
         IF ( IDXI.EQ.109)                    GOTO 10
         IF ((IDXI.GE.137).AND.(IDXI.LE.160)) GOTO 10
      ELSEIF (ISTAB.EQ.3) THEN
         IF ((IDXI.GE.  1).AND.(IDXI.LE. 23)) GOTO 10
         IF ((IDXI.GE. 97).AND.(IDXI.LE.103)) GOTO 10
         IF ((IDXI.GE.109).AND.(IDXI.LE.115)) GOTO 10
         IF ((IDXI.GE.133).AND.(IDXI.LE.136)) GOTO 10
      ENDIF

c calculate direction cosines and Lorentz-parameter of decaying part.
      PTOT = SQRT(PI(NSTK,1)**2+PI(NSTK,2)**2+PI(NSTK,3)**2)
      PTOT = MAX(PTOT,TINY17)
      DO 1 I=1,3
         DCOS(I) = PI(NSTK,I)/PTOT
    1 CONTINUE
      GAM  = PI(NSTK,4)/AAM(IDXI)
      BGAM = PTOT/AAM(IDXI)

c get decay-channel
      KCHAN = K1(IDXI)-1
    2 CONTINUE
      KCHAN = KCHAN+1
      IF ((DT_RNDM(GAM)-TINY17).GT.WT(KCHAN)) GOTO 2

c identities of secondaries
      IDX(1) = NZK(KCHAN,1)
      IDX(2) = NZK(KCHAN,2)
      IF (IDX(2).LT.1) GOTO 9999
      IDX(3) = NZK(KCHAN,3)

c handle decay in rest system of decaying particle
      IF (IDX(3).EQ.0) THEN
c   two-particle decay
         NDEC = 2
         CALL DT_DTWOPD(AAM(IDXI),EF(1),EF(2),PF(1),PF(2),
     &               CODF(1),COFF(1),SIFF(1),CODF(2),COFF(2),SIFF(2),
     &               AAM(IDX(1)),AAM(IDX(2)))
      ELSE
c   three-particle decay
         NDEC = 3
         CALL DT_DTHREP(AAM(IDXI),EF(1),EF(2),EF(3),PF(1),PF(2),PF(3),
     &               CODF(1),COFF(1),SIFF(1),CODF(2),COFF(2),SIFF(2),
     &               CODF(3),COFF(3),SIFF(3),
     &               AAM(IDX(1)),AAM(IDX(2)),AAM(IDX(3)))
      ENDIF
      NSTK = NSTK-1

c transform decay products back
      DO 3 I=1,NDEC
         NSTK = NSTK+1
         CALL DT_DTRAFO(GAM,BGAM,DCOS(1),DCOS(2),DCOS(3),
     &               CODF(I),COFF(I),SIFF(I),PF(I),EF(I),
     &               PFF(I),DCOSF(1),DCOSF(2),DCOSF(3),PI(NSTK,4))
c add particle to stack
         IDXSTK(NSTK) = IDX(I)
         DO 4 J=1,3
            PI(NSTK,J) = DCOSF(J)*PFF(I)
    4    CONTINUE
    3 CONTINUE
      GOTO 100

   10 CONTINUE
c stable particle, put to output-arrays
      NSEC = NSEC+1
      DO 6 I=1,4
         POUT(NSEC,I) = PI(NSTK,I)
    6 CONTINUE
      IDXOUT(NSEC) = IDXSTK(NSTK)
c store secondaries for energy-momentum conservation check
      IF (LEMCCK)
     &CALL DT_EVTEMC(-POUT(NSEC,1),-POUT(NSEC,2),-POUT(NSEC,3),
     &            -POUT(NSEC,4),2,IDUM,IDUM)
      NSTK = NSTK-1
      IF (NSTK.GT.0) GOTO 100

c check energy-momentum conservation
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,3,5,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF

      RETURN

 9999 CONTINUE
      IREJ = 1
      RETURN
      END
c
c===decay1=============================================================*
c
CDECK  ID>, DT_DECAY1
      SUBROUTINE DT_DECAY1

c***********************************************************************
c Decay of resonances stored in DTEVT1.                                *
c This version dated 20.01.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


      DIMENSION PIN(4),POUT(20,4),IDXOUT(20)

      NEND = NHKK
C     DO 1 I=NPOINT(5),NEND
      DO 1 I=NPOINT(4),NEND
         IF (ABS(ISTHKK(I)).EQ.1) THEN
            DO 2 K=1,4
               PIN(K) = PHKK(K,I)
    2       CONTINUE
            IDXIN = IDBAM(I)
            CALL DT_DECAYS(PIN,IDXIN,POUT,IDXOUT,NSEC,IREJ)
            IF (NSEC.GT.1) THEN
               DO 3 N=1,NSEC
                  IDHAD = IDT_IPDGHA(IDXOUT(N))
                  CALL DT_EVTPUT(1,IDHAD,I,0,POUT(N,1),POUT(N,2),
     &                               POUT(N,3),POUT(N,4),0,0,0)
    3          CONTINUE
            ENDIF
         ENDIF
    1 CONTINUE

      RETURN
      END
c
c===decpi0=============================================================*
c
CDECK  ID>, DT_DECPI0
      SUBROUTINE DT_DECPI0

c***********************************************************************
c Decay of pi0 handled with JETSET.                                    *
c This version dated 18.02.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY3=1.0D-3,ONE=1.0D0,ZERO=0.0D0)

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)


      COMMON/PYDAT3/MDCY(500,3),MDME(4000,2),BRAT(4000),KFDP(4000,5)



      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      PARAMETER (MAXLND=4000)
      COMMON/PYJETS/N,NPAD,K(MAXLND,5),P(MAXLND,5),V(MAXLND,5)


c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME



      INTEGER PYCOMP,PYK


      DIMENSION IHISMO(NMXHKK),P1(4)

      TWOPI = 2.0D0*ATAN2(0.0D0,-1.0D0)

      CALL DT_INITJS(2)
c allow pi0 decay

      KC = PYCOMP(111)

      MDCY(KC,1) = 1

      NN  = 0
      INI = 0
      DO 1 I=1,NHKK
         IF ((ISTHKK(I).EQ.1).AND.(IDHKK(I).EQ.111)) THEN
            IF (INI.EQ.0) THEN
               INI = 1
            ELSE
               INI = 2
            ENDIF
            IF (LEMCCK) CALL DT_EVTEMC(PHKK(1,I),PHKK(2,I),PHKK(3,I),
     &                                    PHKK(4,I),INI,IDUM,IDUM)
            PT    = SQRT(PHKK(1,I)**2+PHKK(2,I)**2)
            PTOT  = SQRT(PT**2+PHKK(3,I)**2)
            COSTH = PHKK(3,I)/(PTOT+TINY10)
            IF (COSTH.GT.ONE) THEN
               THETA = ZERO
            ELSEIF (COSTH.LT.-ONE) THEN
               THETA = TWOPI/2.0D0
            ELSE
               THETA = ACOS(COSTH)
            ENDIF
            PHI     = ASIN(PHKK(2,I)/(PT  +TINY10))
            IF (PHKK(1,I).LT.0.0D0)

     &         PHI  = SIGN(TWOPI/2.0D0-ABS(PHI),PHI)

            ENER    = PHKK(4,I)
            NN      = NN+1
            KTEMP   = MSTU(10)
            MSTU(10)= 1
            P(NN,5) = PHKK(5,I)

            CALL PY1ENT(NN,111,ENER,THETA,PHI)

            MSTU(10)  = KTEMP
            IHISMO(NN)= I
         ENDIF
    1 CONTINUE
      IF (NN.GT.0) THEN

         CALL PYEXEC


         NLINES = PYK(0,1)

         DO 2 II=1,NLINES

            IF (PYK(II,7).EQ.1) THEN

               DO 3 KK=1,4

                  P1(KK) = PYP(II,KK)

    3          CONTINUE

               ID = PYK(II,8)
               MO = IHISMO(PYK(II,15))

               CALL DT_EVTPUT(1,ID,MO,0,P1(1),P1(2),P1(3),P1(4),0,0,0)
               IF (LEMCCK)
     &            CALL DT_EVTEMC(-P1(1),-P1(2),-P1(3),-P1(4),2,
     &                                            IDUM,IDUM)
csr: flag with neg. sign (for HELIOS p/A-W jobs)
               ISTHKK(MO) = -2
            ENDIF
    2    CONTINUE
         IF (LEMCCK) CALL DT_EVTEMC(DUM,DUM,DUM,DUM,4,7000,IREJ1)
      ENDIF
      MDCY(KC,1) = 0

      RETURN
      END
c
c===dtwopd=============================================================*
c
CDECK  ID>, DT_DTWOPD
      SUBROUTINE DT_DTWOPD(UMO,ECM1,ECM2,PCM1,PCM2,COD1,COF1,SIF1,COD2,
     &                                            COF2,SIF2,AM1,AM2)

c***********************************************************************
c Two-particle decay.                                                  *
c  UMO                 cm-energy of the decaying system       (input)  *
c  AM1/AM2             masses of the decay products           (input)  *
c  ECM1,ECM2/PCM1,PCM2 cm-energies/momenta of the decay prod. (output) *
c  COD,COF,SIF         direction cosines of the decay prod.   (output) *
c Revised by S. Roesler, 20.11.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ONE=1.0D0,TWO=2.0D0,ZERO=0.0D0)

      IF (UMO.LT.(AM1+AM2)) THEN
         WRITE(ErrorOut,1000) UMO,AM1,AM2
 1000    FORMAT(1X,'DTWOPD:    INCONSISTENT KINEMATICS - UMO,AM1,AM2 ',
     &          3E12.3)
         STOP
      ENDIF

      ECM1 = ((UMO-AM2)*(UMO+AM2)+AM1*AM1)/(TWO*UMO)
      ECM2 = UMO-ECM1
      PCM1 = SQRT((ECM1-AM1)*(ECM1+AM1))
      PCM2 = PCM1
      CALL DT_DSFECF(SIF1,COF1)
      COD1 = TWO*DT_RNDM(PCM2)-ONE
      COD2 = -COD1
      COF2 = -COF1
      SIF2 = -SIF1

      RETURN
      END
c
c===dthrep=============================================================*
c
CDECK  ID>, DT_DTHREP
      SUBROUTINE DT_DTHREP(UMO,ECM1,ECM2,ECM3,PCM1,PCM2,PCM3,COD1,COF1,
     &                  SIF1,COD2,COF2,SIF2,COD3,COF3,SIF3,AM1,AM2,AM3)

c***********************************************************************
c Three-particle decay.                                                *
c  UMO                 cm-energy of the decaying system       (input)  *
c  AM1/2/3             masses of the decay products           (input)  *
c  ECM1/2/2,PCM1/2/3   cm-energies/momenta of the decay prod. (output) *
c  COD,COF,SIF         direction cosines of the decay prod.   (output) *
c                                                                      *
c Threpd89: slight revision by A. Ferrari                              *
c Last change on   11-oct-93   by    Alfredo Ferrari, INFN - Milan     *
c Revised by S. Roesler, 20.11.95                                      *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER ( ANGLSQ = 2.5D-31 )
      PARAMETER ( AZRZRZ = 1.0D-30 )
      PARAMETER ( ONEMNS = 0.999999999999999  D+00 )
      PARAMETER ( ONEPLS = 1.000000000000001  D+00 )
      PARAMETER ( ONEONE = 1.D+00 )
      PARAMETER ( TWOTWO = 2.D+00 )
      PARAMETER ( PIPIPI = 3.1415926535897932270 D+00 )

      COMMON /HNGAMR/ REDU,AMO,AMM(15)

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME


      DIMENSION F(5),XX(5)
      DATA EPS /AZRZRZ/

      UMOO=UMO+UMO
C***S1, S2, S3 ARE THE INVARIANT MASSES OF THE PARTICLES 1, 2, 3
C***J. VON NEUMANN - RANDOM - SELECTION OF S2
C***CALCULATION OF THE MAXIMUM OF THE S2 - DISTRIBUTION
      UUMO=UMO
      AAM1=AM1
      AAM2=AM2
      AAM3=AM3
      GU=(AM2+AM3)**2
      GO=(UMO-AM1)**2
c     UFAK=1.0000000000001D0
c     IF (GU.GT.GO) UFAK=0.9999999999999D0
      IF (GU.GT.GO) THEN
         UFAK=ONEMNS
      ELSE
         UFAK=ONEPLS
      END IF
      OFAK=2.D0-UFAK
      GU=GU*UFAK
      GO=GO*OFAK
      DS2=(GO-GU)/99.D0
      AM11=AM1*AM1
      AM22=AM2*AM2
      AM33=AM3*AM3
      UMO2=UMO*UMO
      RHO2=0.D0
      S22=GU
      DO 124 I=1,100
         S21=S22
         S22=GU+(I-1.D0)*DS2
         RHO1=RHO2
         RHO2=DT_YLAMB(S22,UMO2,AM11)*DT_YLAMB(S22,AM22,AM33)/
     *                                             (S22+EPS)
         IF(RHO2.LT.RHO1) GO TO 125
  124 CONTINUE
  125 S2SUP=(S22-S21)*.5D0+S21
      SUPRHO=DT_YLAMB(S2SUP,UMO2,AM11)*DT_YLAMB(S2SUP,AM22,AM33)/
     *                                           (S2SUP+EPS)
      SUPRHO=SUPRHO*1.05D0
      XO=S21-DS2
      IF (GU.LT.GO.AND.XO.LT.GU) XO=GU
      IF (GU.GT.GO.AND.XO.GT.GU) XO=GU
      XX(1)=XO
      XX(3)=S22
      X1=(XO+S22)*0.5D0
      XX(2)=X1
      F(3)=RHO2
      F(1)=DT_YLAMB(XO,UMO2,AM11)*DT_YLAMB(XO,AM22,AM33)/(XO+EPS)
      F(2)=DT_YLAMB(X1,UMO2,AM11)*DT_YLAMB(X1,AM22,AM33)/(X1+EPS)
      DO 126 I=1,16
         X4=(XX(1)+XX(2))*0.5D0
         X5=(XX(2)+XX(3))*0.5D0
         F(4)=DT_YLAMB(X4,UMO2,AM11)*DT_YLAMB(X4,AM22,AM33)/
     *                                               (X4+EPS)
         F(5)=DT_YLAMB(X5,UMO2,AM11)*DT_YLAMB(X5,AM22,AM33)/
     *                                               (X5+EPS)
         XX(4)=X4
         XX(5)=X5
         DO 128 II=1,5
            IA=II
            DO 128 III=IA,5
               IF (F (II).GE.F (III)) GO TO 128
               FH=F(II)
               F(II)=F(III)
               F(III)=FH
               FH=XX(II)
               XX(II)=XX(III)
               XX(III)=FH
128      CONTINUE
         SUPRHO=F(1)
         S2SUP=XX(1)
         DO 129 II=1,3
            IA=II
            DO 129 III=IA,3
               IF (XX(II).GE.XX(III)) GO TO 129
               FH=F(II)
               F(II)=F(III)
               F(III)=FH
               FH=XX(II)
               XX(II)=XX(III)
               XX(III)=FH
129      CONTINUE
126   CONTINUE
      AM23=(AM2+AM3)**2
      ITH=0
      REDU=2.D0
    1 CONTINUE
      ITH=ITH+1
      IF (ITH.GT.200) REDU=-9.D0
      IF (ITH.GT.200) GO TO 400
      C=DT_RNDM(REDU)
c     S2=AM23+C*((UMO-AM1)**2-AM23)
      S2=AM23+C*(UMO-AM1-AM2-AM3)*(UMO-AM1+AM2+AM3)
      Y=DT_RNDM(S2)
      Y=Y*SUPRHO
      RHO=DT_YLAMB(S2,UMO2,AM11)*DT_YLAMB(S2,AM22,AM33)/S2
      IF(Y.GT.RHO) GO TO 1
C***RANDOM SELECTION OF S3 AND CALCULATION OF S1
      S1=DT_RNDM(S2)
      S1=S1*RHO+AM11+AM22-(S2-UMO2+AM11)*(S2+AM22-AM33)/(2.D0*S2)-
     &RHO*.5D0
      S3=UMO2+AM11+AM22+AM33-S1-S2
      ECM1=(UMO2+AM11-S2)/UMOO
      ECM2=(UMO2+AM22-S3)/UMOO
      ECM3=(UMO2+AM33-S1)/UMOO
      PCM1=SQRT((ECM1+AM1)*(ECM1-AM1))
      PCM2=SQRT((ECM2+AM2)*(ECM2-AM2))
      PCM3=SQRT((ECM3+AM3)*(ECM3-AM3))
      CALL DT_DSFECF(SFE,CFE)
C***TH IS THE ANGLE BETWEEN PARTICLES 1 AND 2
C***TH1, TH2 ARE THE ANGLES BETWEEN PARTICLES 1, 2 AND THE DIRECTION OF
      PCM12 = PCM1 * PCM2
      IF ( PCM12 .LT. ANGLSQ ) GO TO 200
      COSTH=(ECM1*ECM2+0.5D+00*(AM11+AM22-S1))/PCM12
      GO TO 300
 200  CONTINUE
         UW=DT_RNDM(S1)
         COSTH=(UW-0.5D+00)*2.D+00
 300  CONTINUE
c     IF(ABS(COSTH).GT.0.9999999999999999D0)
c    &COSTH=SIGN(0.9999999999999999D0,COSTH)
      IF(ABS(COSTH).GT.ONEONE)
     &COSTH=SIGN(ONEONE,COSTH)
      IF (REDU.LT.1.D+00) RETURN
      COSTH2=(PCM3*PCM3+PCM2*PCM2-PCM1*PCM1)/(2.D+00*PCM2*PCM3)
c     IF(ABS(COSTH2).GT.0.9999999999999999D0)
c    &COSTH2=SIGN(0.9999999999999999D0,COSTH2)
      IF(ABS(COSTH2).GT.ONEONE)
     &COSTH2=SIGN(ONEONE,COSTH2)
      SINTH2=SQRT((ONEONE-COSTH2)*(ONEONE+COSTH2))
      SINTH =SQRT((ONEONE-COSTH)*(ONEONE+COSTH))
      SINTH1=COSTH2*SINTH-COSTH*SINTH2
      COSTH1=COSTH*COSTH2+SINTH2*SINTH
C***RANDOM SELECTION OF THE SPHERICAL COORDINATES OF THE DIRECTION OF PA
C***CFE, SFE ARE COS AND SIN OF THE ROTATION ANGLE OF THE SYSTEM 1, 2 AR
C***THE DIRECTION OF PARTICLE 3
C***CALCULATION OF THE SPHERICAL COORDINATES OF PARTICLES 1, 2
      CX11=-COSTH1
      CY11=SINTH1*CFE
      CZ11=SINTH1*SFE
      CX22=-COSTH2
      CY22=-SINTH2*CFE
      CZ22=-SINTH2*SFE
      CALL DT_DSFECF(SIF3,COF3)
      COD3=TWOTWO*DT_RNDM(CX11)-ONEONE
      SID3=SQRT((1.D+00-COD3)*(1.D+00+COD3))
    2 FORMAT(5F20.15)
      COD1=CX11*COD3+CZ11*SID3
      CHLP=(ONEONE-COD1)*(ONEONE+COD1)
      IF(CHLP.LT.1.D-14)WRITE(ErrorOut,2)COD1,COF3,SID3,
     &CX11,CZ11
      SID1=SQRT(CHLP)
      COF1=(CX11*SID3*COF3-CY11*SIF3-CZ11*COD3*COF3)/SID1
      SIF1=(CX11*SID3*SIF3+CY11*COF3-CZ11*COD3*SIF3)/SID1
      COD2=CX22*COD3+CZ22*SID3
      SID2=SQRT((ONEONE-COD2)*(ONEONE+COD2))
      COF2=(CX22*SID3*COF3-CY22*SIF3-CZ22*COD3*COF3)/SID2
      SIF2=(CX22*SID3*SIF3+CY22*COF3-CZ22*COD3*SIF3)/SID2
 400  CONTINUE
c === Energy conservation check: === *
      EOCHCK = UMO - ECM1 - ECM2 - ECM3
c     SID1 = SQRT ( ( ONEONE - COD1 ) * ( ONEONE + COD1 ) )
c     SID2 = SQRT ( ( ONEONE - COD2 ) * ( ONEONE + COD2 ) )
c     SID3 = SQRT ( ( ONEONE - COD3 ) * ( ONEONE + COD3 ) )
      PZCHCK = PCM1 * COD1 + PCM2 * COD2 + PCM3 * COD3
      PXCHCK = PCM1 * COF1 * SID1 + PCM2 * COF2 * SID2
     &       + PCM3 * COF3 * SID3
      PYCHCK = PCM1 * SIF1 * SID1 + PCM2 * SIF2 * SID2
     &       + PCM3 * SIF3 * SID3
      EOCMPR = 1.D-12 * UMO
      IF ( ABS (EOCHCK) + ABS (PXCHCK) + ABS (PYCHCK) + ABS (PZCHCK)
     &     .GT. EOCMPR ) THEN
c*sr 5.5.95 output-unit changed
         IF (IOULEV(1).GT.0) THEN
            WRITE(ErrorOut,*)
     &      ' *** THREPD: ENERGY/MOMENTUM CONSERVATION FAILURE! ***',
     &      EOCHCK,PXCHCK,PYCHCK,PZCHCK
            WRITE(ErrorOut,
     * *)' *** SID1,SID2,SID3',SID1,SID2,SID3
         ENDIF
c*
      END IF
      RETURN
      END
c
c===dbklas=============================================================*
c
CDECK  ID>, DT_DBKLAS
      SUBROUTINE DT_DBKLAS(I,J,K,I8,I10)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

c quark-content to particle index conversion (DTUNUC 1.x)
      COMMON /DTQ2ID/ IMPS(6,6),IMVE(6,6),IB08(6,21),IB10(6,21),
     &                IA08(6,21),IA10(6,21)


      IF (I) 20,20,10
c baryons
   10 CONTINUE
      CALL DT_INDEXD(J,K,IND)
      I8  = IB08(I,IND)
      I10 = IB10(I,IND)
      IF (I8.LE.0) I8 = I10
      RETURN
c antibaryons
   20 CONTINUE
      II = IABS(I)
      JJ = IABS(J)
      KK = IABS(K)
      CALL DT_INDEXD(JJ,KK,IND)
      I8  = IA08(II,IND)
      I10 = IA10(II,IND)
      IF (I8.LE.0) I8 = I10

      RETURN
      END
c
c===indexd=============================================================*
c
CDECK  ID>, DT_INDEXD
      SUBROUTINE DT_INDEXD(KA,KB,IND)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      KP = KA*KB
      KS = KA+KB
      IF (KP.EQ.1) IND=1
      IF (KP.EQ.2) IND=2
      IF (KP.EQ.3) IND=3
      IF ((KP.EQ.4).AND.(KS.EQ.5)) IND=4
      IF (KP.EQ.5) IND=5
      IF ((KP.EQ.6).AND.(KS.EQ.7)) IND=6
      IF ((KP.EQ.4).AND.(KS.EQ.4)) IND=7
      IF ((KP.EQ.6).AND.(KS.EQ.5)) IND=8
      IF (KP.EQ.8)  IND=9
      IF (KP.EQ.10) IND=10
      IF ((KP.EQ.12).AND.(KS.EQ.8)) IND=11
      IF (KP.EQ.9)  IND=12
      IF ((KP.EQ.12).AND.(KS.EQ.7)) IND=13
      IF (KP.EQ.15) IND=14
      IF (KP.EQ.18) IND=15
      IF (KP.EQ.16) IND=16
      IF (KP.EQ.20) IND=17
      IF (KP.EQ.24) IND=18
      IF (KP.EQ.25) IND=19
      IF (KP.EQ.30) IND=20
      IF (KP.EQ.36) IND=21

      RETURN
      END
c
c===dchant=============================================================*
c
CDECK  ID>, DT_DCHANT
      SUBROUTINE DT_DCHANT

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ONE=1.0D0,ZERO=0.0D0)

c HADRIN: decay channel information
      PARAMETER (IDMAX9=602)
      CHARACTER*8 ZKNAME
      COMMON /HNDECH/ ZKNAME(IDMAX9),WT(IDMAX9),NZK(IDMAX9,3)

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)


      DIMENSION HWT(IDMAX9)

c change of weights wt from absolut values into the sum of wt of a dec.
      DO 10 J=1,IDMAX9
         HWT(J) = ZERO
   10 CONTINUE
C     DO 999 KKK=1,210
C        WRITE(LOUT,'(A8,F5.2,2E10.3,2I4,2I10)')
C    &      ANAME(KKK),AAM(KKK),GA(KKK),TAU(KKK),IICH(KKK),IIBAR(KKK),
C    &      K1(KKK),K2(KKK)
C 999 CONTINUE
C     STOP
      DO 30 I=1,210
         IK1 = K1(I)
         IK2 = K2(I)
         HV  = ZERO
         DO 20 J=IK1,IK2
            HV     = HV+WT(J)
            HWT(J) = HV
c*sr 13.1.95
            IF (HWT(J).GT.1.0001) WRITE(ErrorOut,
     * 1000) HWT(J),J,I,IK1
 1000       FORMAT(2X,15H ERROR IN HWT =,1F10.5,8H J,I,K1=,3I5)
   20    CONTINUE
   30 CONTINUE
      DO 40 J=1,IDMAX9
         WT(J) = HWT(J)
   40 CONTINUE

      RETURN
      END
c
c===ddatar=============================================================*
c
CDECK  ID>, DT_DDATAR
      SUBROUTINE DT_DDATAR

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ONE=1.0D0,ZERO=0.0D0)

c quark-content to particle index conversion (DTUNUC 1.x)
      COMMON /DTQ2ID/ IMPS(6,6),IMVE(6,6),IB08(6,21),IB10(6,21),
     &                IA08(6,21),IA10(6,21)


      DIMENSION IV(36),IP(36),IB(126),IBB(126),IA(126),IAA(126)

      DATA IV/ 33, 34, 38,123,  0,  0, 32, 33, 39,124,
     &          0,  0, 36, 37, 96,127,  0,  0,126,125,
     &        128,129,14*0/
      DATA IP/ 23, 14, 16,116,  0,  0, 13, 23, 25,117,
     &          0,  0, 15, 24, 31,120,  0,  0,119,118,
     &        121,122,14*0/
      DATA IB/  0,  1, 21,140,  0,  0,  8, 22,137,  0,
     &          0, 97,138,  0,  0,146,  0,  0,  0,  0,
     &          0,  1,  8, 22,137,  0,  0,  0, 20,142,
     &          0,  0, 98,139,  0,  0,147,  0,  0,  0,
     &          0,  0, 21, 22, 97,138,  0,  0, 20, 98,
     &        139,  0,  0,  0,145,  0,  0,148,  0,  0,
     &          0,  0,  0,140,137,138,146,  0,  0,142,
     &        139,147,  0,  0,145,148,           50*0/
      DATA IBB/53, 54,104,161,  0,  0, 55,105,162,  0,
     &          0,107,164,  0,  0,167,  0,  0,  0,  0,
     &          0, 54, 55,105,162,  0,  0, 56,106,163,
     &          0,  0,108,165,  0,  0,168,  0,  0,  0,
     &          0,  0,104,105,107,164,  0,  0,106,108,
     &        165,  0,  0,109,166,  0,  0,169,  0,  0,
     &          0,  0,  0,161,162,164,167,  0,  0,163,
     &        165,168,  0,  0,166,169,  0,  0,170,47*0/
      DATA IA/  0,  2, 99,152,  0,  0,  9,100,149,  0,
     &          0,102,150,  0,  0,158,  0,  0,  0,  0,
     &          0,  2,  9,100,149,  0,  0,  0,101,154,
     &          0,  0,103,151,  0,  0,159,  0,  0,  0,
     &          0,  0, 99,100,102,150,  0,  0,101,103,
     &        151,  0,  0,  0,157,  0,  0,160,  0,  0,
     &          0,  0,  0,152,149,150,158,  0,  0,154,
     &        151,159,  0,  0,157,160,           50*0/
      DATA IAA/67, 68,110,171,  0,  0, 69,111,172,  0,
     &          0,113,174,  0,  0,177,  0,  0,  0,  0,
     &          0, 68, 69,111,172,  0,  0, 70,112,173,
     &          0,  0,114,175,  0,  0,178,  0,  0,  0,
     &          0,  0,110,111,113,174,  0,  0,112,114,
     &        175,  0,  0,115,176,  0,  0,179,  0,  0,
     &          0,  0,  0,171,172,174,177,  0,  0,173,
     &        175,178,  0,  0,176,179,  0,  0,180,47*0/

      L=0
      DO 2 I=1,6
         DO 1 J=1,6
            L = L+1
            IMPS(I,J) = IP(L)
            IMVE(I,J) = IV(L)
    1    CONTINUE
    2 CONTINUE
      L=0
      DO 4 I=1,6
         DO 3 J=1,21
            L = L+1
            IB08(I,J) = IB(L)
            IB10(I,J) = IBB(L)
            IA08(I,J) = IA(L)
            IA10(I,J) = IAA(L)
    3    CONTINUE
    4 CONTINUE
C     A1  = 0.88D0
C     B1  = 3.0D0
C     B2  = 3.0D0
C     B3  = 8.0D0
C     LT  = 0
C     LB  = 0
C     BET = 12.0D0
C     AS  = 0.25D0
C     B8  = 0.33D0
C     AME = 0.95D0
C     DIQ = 0.375D0
C     ISU = 4

      RETURN
      END
c
c===initjs=============================================================*
c
CDECK  ID>, DT_INITJS
      SUBROUTINE DT_INITJS(MODE)

c***********************************************************************
c Initialize JETSET paramters.                                         *
c           MODE = 0 default settings                                  *
c                = 1 PHOJET settings                                   *
c                = 2 DTUNUC settings                                   *
c This version dated 16.02.96 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,ONE=1.0D0,ZERO=0.0D0)

      LOGICAL LFIRST,LFIRDT,LFIRPH


      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      COMMON/PYDAT3/MDCY(500,3),MDME(4000,2),BRAT(4000),KFDP(4000,5)


c flags for particle decays
      COMMON /DTFRPA/ MSTUX(20),PARUX(20),MSTJX(20),PARJX(20),
     &                IMSTU(20),IPARU(20),IMSTJ(20),IPARJ(20),
     &                NMSTU,NPARU,NMSTJ,NPARJ,PDB,PDBSEA(3),ISIG0,IPI0

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME



      INTEGER PYCOMP


      DIMENSION IDXSTA(40)
      DATA IDXSTA
c          K0s   pi0  lam   alam  sig+  asig+ sig-  asig- tet0  atet0
     &  /  310,  111, 3122,-3122, 3222,-3222, 3112,-3112, 3322,-3322,
c          tet- atet-  om-  aom-   D+    D-    D0    aD0   Ds+   aDs+
     &    3312,-3312, 3334,-3334,  411, -411,  421, -421,  431, -431,
c          etac lamc+alamc+sigc++ sigc+ sigc0asigc++asigc+asigc0 Ksic+
     &     441, 4122,-4122, 4222, 4212, 4112,-4222,-4212,-4112, 4232,
c         Ksic0 aKsic+aKsic0 sig0 asig0
     &    4132,-4232,-4132, 3212,-3212, 5*0/

      DATA LFIRST,LFIRDT,LFIRPH /.TRUE.,.TRUE.,.TRUE./

      IF (LFIRST) THEN
c save default settings
         PDEF1  = PARJ(1)
         PDEF2  = PARJ(2)
         PDEF3  = PARJ(3)
         PDEF5  = PARJ(5)
         PDEF6  = PARJ(6)
         PDEF7  = PARJ(7)
         PDEF18 = PARJ(18)
         PDEF19 = PARJ(19)
         PDEF21 = PARJ(21)
         PDEF42 = PARJ(42)
         MDEF12 = MSTJ(12)
c LUJETS / PYJETS array-dimensions

         MSTU(4) = 4000

c increase maximum number of JETSET-error prints
         MSTU(22) = 50000
c prevent particles decaying
         DO 1 I=1,35
            IF (I.LT.34) THEN

               KC = PYCOMP(IDXSTA(I))

               IF (I.EQ.2) THEN
c  pi0 decay
C                 MDCY(KC,1) = 1
                  MDCY(KC,1) = 0
c*cr mode
C              ELSEIF ((I.EQ.4).OR.(I.EQ. 6).OR.
C   &                 (I.EQ.8).OR.(I.EQ.10)) THEN
C              ELSEIF (I.EQ.4) THEN
C                 MDCY(KC,1) = 1
c*
               ELSE
                  MDCY(KC,1) = 0
               ENDIF
            ELSEIF (((I.EQ.34).OR.(I.EQ.35)).AND.(ISIG0.EQ.0)) THEN

               KC = PYCOMP(IDXSTA(I))

               MDCY(KC,1) = 0
            ENDIF
    1    CONTINUE
c popcorn:
         IF (PDB.LE.ZERO) THEN
c   no popcorn-mechanism
            MSTJ(12) = 1
         ELSE
            MSTJ(12) = 3
            PARJ(5)  = PDB
         ENDIF
c set JETSET-parameter requested by input cards
         IF (NMSTU.GT.0) THEN
            DO 2 I=1,NMSTU
               MSTU(IMSTU(I)) = MSTUX(I)
    2       CONTINUE
         ENDIF
         IF (NMSTJ.GT.0) THEN
            DO 3 I=1,NMSTJ
               MSTJ(IMSTJ(I)) = MSTJX(I)
    3       CONTINUE
         ENDIF
         IF (NPARU.GT.0) THEN
            DO 4 I=1,NPARU
               PARU(IPARU(I)) = PARUX(I)
    4       CONTINUE
         ENDIF
         LFIRST = .FALSE.
      ENDIF
c
c PARJ(1)  suppression of qq-aqaq pair prod. compared to
c          q-aq pair prod.                      (default: 0.1)
c PARJ(2)  strangeness suppression               (default: 0.3)
c PARJ(3)  extra suppression of strange diquarks (default: 0.4)
c PARJ(6)  extra suppression of sas-pair shared by B and
c          aB in BMaB                           (default: 0.5)
c PARJ(7)  extra suppression of strange meson M in BMaB
c          configuration                        (default: 0.5)
c PARJ(18) spin 3/2 baryon suppression           (default: 1.0)
c PARJ(21) width sigma in Gaussian p_x, p_y transverse
c          momentum distrib. for prim. hadrons  (default: 0.35)
c PARJ(42) b-parameter for symmetric Lund-fragmentation
c          function                             (default: 0.9 GeV^-2)
c
c PHOJET settings
      IF (MODE.EQ.1) THEN
c   JETSET default
C        PARJ(1)  = PDEF1
C        PARJ(2)  = PDEF2
C        PARJ(3)  = PDEF3
C        PARJ(6)  = PDEF6
C        PARJ(7)  = PDEF7
C        PARJ(18) = PDEF18
C        PARJ(21) = PDEF21
C        PARJ(42) = PDEF42
c*sr 18.11.98 parameter tuning
C        PARJ(1)  = 0.092D0
C        PARJ(2)  = 0.25D0
C        PARJ(3)  = 0.45D0
C        PARJ(19) = 0.3D0
C        PARJ(21) = 0.45D0
C        PARJ(42) = 1.0D0
c*sr 28.04.99 parameter tuning (May 99 minor modifications)
         PARJ(1)  = 0.085D0
         PARJ(2)  = 0.26D0
         PARJ(3)  = 0.8D0
         PARJ(11) = 0.38D0
         PARJ(18) = 0.3D0
         PARJ(19) = 0.4D0
         PARJ(21) = 0.36D0
         PARJ(41) = 0.3D0
         PARJ(42) = 0.86D0
         IF (NPARJ.GT.0) THEN
            DO 10 I=1,NPARJ
               IF (IPARJ(I).GT.0) PARJ(IPARJ(I)) = PARJX(I)
   10       CONTINUE
         ENDIF
         IF (LFIRPH) THEN
            WRITE(ErrorOut,'(1X,A)')
     &         'DT_INITJS: JETSET-PARAMETER FOR PHOJET'
            CALL DT_JSPARA(0)
            LFIRPH = .FALSE.
         ENDIF
c DTUNUC settings
      ELSEIF (MODE.EQ.2) THEN
         IF (IFRAG(2).EQ.1) THEN
c*sr parameters before 9.3.96
C           PARJ(2)  = 0.27D0
C           PARJ(3)  = 0.6D0
C           PARJ(6)  = 0.75D0
C           PARJ(7)  = 0.75D0
C           PARJ(21) = 0.55D0
C           PARJ(42) = 1.3D0
c*sr 18.11.98 parameter tuning
C           PARJ(1)  = 0.05D0
C           PARJ(2)  = 0.27D0
C           PARJ(3)  = 0.4D0
C           PARJ(19) = 0.2D0
C           PARJ(21) = 0.45D0
C           PARJ(42) = 1.0D0
c*sr 28.04.99 parameter tuning
            PARJ(1)  = 0.11D0
            PARJ(2)  = 0.36D0
            PARJ(3)  = 0.8D0
            PARJ(19) = 0.2D0
            PARJ(21) = 0.3D0
            PARJ(41) = 0.3D0
            PARJ(42) = 0.58D0
            IF (NPARJ.GT.0) THEN
               DO 20 I=1,NPARJ
                  IF (IPARJ(I).LT.0) THEN
                     IDX = ABS(IPARJ(I))
                     PARJ(IDX) = PARJX(I)
                  ENDIF
   20          CONTINUE
            ENDIF
            IF (LFIRDT) THEN
               WRITE(ErrorOut,'(1X,A)')
     &           'DT_INITJS: JETSET-PARAMETER FOR DTUNUC'
               CALL DT_JSPARA(0)
               LFIRDT = .FALSE.
            ENDIF
         ELSEIF (IFRAG(2).EQ.2) THEN
            PARJ(1)  = 0.11D0
            PARJ(2)  = 0.27D0
            PARJ(3)  = 0.3D0
            PARJ(6)  = 0.35D0
            PARJ(7)  = 0.45D0
            PARJ(18) = 0.66D0
C           PARJ(21) = 0.55D0
C           PARJ(42) = 1.0D0
            PARJ(21) = 0.60D0
            PARJ(42) = 1.3D0
         ELSE
            PARJ(1)  = PDEF1
            PARJ(2)  = PDEF2
            PARJ(3)  = PDEF3
            PARJ(6)  = PDEF6
            PARJ(7)  = PDEF7
            PARJ(18) = PDEF18
            PARJ(21) = PDEF21
            PARJ(42) = PDEF42
         ENDIF
      ELSE
         PARJ(1)  = PDEF1
         PARJ(2)  = PDEF2
         PARJ(3)  = PDEF3
         PARJ(5)  = PDEF5
         PARJ(6)  = PDEF6
         PARJ(7)  = PDEF7
         PARJ(18) = PDEF18
         PARJ(19) = PDEF19
         PARJ(21) = PDEF21
         PARJ(42) = PDEF42
         MSTJ(12) = MDEF12
      ENDIF

      RETURN
      END
c
c===jspara=============================================================*
c
CDECK  ID>, DT_JSPARA
      SUBROUTINE DT_JSPARA(MODE)

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (TINY10=1.0D-10,TINY3=1.0D-3,TINY1=1.0D-1,
     &           ONE=1.0D0,ZERO=0.0D0)

      LOGICAL LFIRST


      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)



      DIMENSION ISTU(200),QARU(200),ISTJ(200),QARJ(200)

      DATA LFIRST /.TRUE./

c save the default JETSET-parameter on the first call
      IF (LFIRST) THEN
         DO 1 I=1,200
            ISTU(I) = MSTU(I)
            QARU(I) = PARU(I)
            ISTJ(I) = MSTJ(I)
            QARJ(I) = PARJ(I)
    1    CONTINUE
         LFIRST = .FALSE.
      ENDIF

      WRITE(ErrorOut,1000)
 1000 FORMAT(1X,'DT_JSPARA: NEW VALUE (DEFAULT VALUE)')

c compare the default JETSET-parameter with the present values
      DO 2 I=1,200
         IF ((MSTU(I).NE.ISTU(I)).AND.(I.NE.31)) THEN
            WRITE(ErrorOut,1002) 'MSTU(',I,MSTU(I),ISTU(I)
C           ISTU(I) = MSTU(I)
         ENDIF
         DIFF = ABS(PARU(I)-QARU(I))
         IF ((DIFF.GE.1.0D-5).AND.(I.NE.21)) THEN
            WRITE(ErrorOut,1001) 'PARU(',I,PARU(I),QARU(I)
C           QARU(I) = PARU(I)
         ENDIF
         IF (MSTJ(I).NE.ISTJ(I)) THEN
            WRITE(ErrorOut,1002) 'MSTJ(',I,MSTJ(I),ISTJ(I)
C           ISTJ(I) = MSTJ(I)
         ENDIF
         DIFF = ABS(PARJ(I)-QARJ(I))
         IF (DIFF.GE.1.0D-5) THEN
            WRITE(ErrorOut,1001) 'PARJ(',I,PARJ(I),QARJ(I)
C           QARJ(I) = PARJ(I)
         ENDIF
    2 CONTINUE
 1001 FORMAT(12X,A5,I3,'): ',F6.3,' (',F6.3,')')
 1002 FORMAT(12X,A5,I3,'): ',I6,' (',I6,')')

      RETURN
      END
c
c===fozoca=============================================================*
c
CDECK  ID>, DT_FOZOCA
      SUBROUTINE DT_FOZOCA(LFZC,IREJ)

c***********************************************************************
c This subroutine treats the complete FOrmation ZOne supressed intra-  *
c nuclear CAscade.                                                     *
c               LFZC = .true.  cascade has been treated                *
c                    = .false. cascade skipped                         *
c This is a completely revised version of the original FOZOKL.         *
c This version dated 18.11.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)
      PARAMETER (DLARGE=1.0D10,OHALF=0.5D0,ZERO=0.0D0)
      PARAMETER (FM2MM=1.0D-12,RNUCLE = 1.12D0)

      LOGICAL LSTART,LCAS,LFZC

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c rejection counter
      COMMON /DTREJC/ IRPT,IRHHA,IRRES(2),LOMRES,LOBRES,
     &                IRCHKI(2),IRFRAG,IRCRON(3),IREVT,
     &                IREXCI(3),IRDIFF(2),IRINC

c properties of interacting particles
      COMMON /DTPRTA/ IT,ITZ,IP,IPZ,IJPROJ,IBPROJ,IJTARG,IBTARG

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c final state after intranuclear cascade step
      COMMON /DTPAUL/ EWOUND(2,300),NWOUND(2),IDXINC(2000),NOINC

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI


      DIMENSION NCWOUN(2)

      DATA LSTART /.TRUE./

      LFZC = .TRUE.
      IREJ = 0

c skip cascade if hadron-hadron interaction or if supressed by user
      IF (((IP.EQ.1).AND.(IT.EQ.1)).OR.(KTAUGE.LT.1)) GOTO 9999
c skip cascade if not all possible chains systems are hadronized
      DO 1 I=1,8
         IF (.NOT.LHADRO(I)) GOTO 9999
    1 CONTINUE

      IF (LSTART) THEN
         WRITE(ErrorOut,1000) KTAUGE,TAUFOR,INCMOD
 1000    FORMAT(/,1X,'FOZOCA:  INTRANUCLEAR CASCADE TREATED FOR A ',
     &          'MAXIMUM OF',I4,' GENERATIONS',/,10X,'FORMATION TIME ',
     &          'PARAMETER:',F5.1,'  FM/C',9X,'MODUS:',I2)
         IF (ITAUVE.EQ.1) WRITE(ErrorOut,1001)
         IF (ITAUVE.EQ.2) WRITE(ErrorOut,1002)
 1001    FORMAT(10X,'P_T DEPENDENT FORMATION ZONE',/)
 1002    FORMAT(10X,'CONSTANT FORMATION ZONE',/)
         LSTART = .FALSE.
      ENDIF

c in order to avoid wasting of cpu-time the DTEVT1-indices of nucleons
c which may interact with final state particles are stored in a seperate
c array - here all proj./target nucleon-indices (just for simplicity)
      NOINC = 0
      DO 9 I=1,NPOINT(1)-1
         NOINC = NOINC+1
         IDXINC(NOINC) = I
    9 CONTINUE

c initialize Pauli-principle treatment (find wounded nucleons)
      NWOUND(1) = 0
      NWOUND(2) = 0
      NCWOUN(1) = 0
      NCWOUN(2) = 0
      DO 2 J=1,NPOINT(1)
         DO 3 I=1,2
            IF (ISTHKK(J).EQ.10+I) THEN
               NWOUND(I) = NWOUND(I)+1
               EWOUND(I,NWOUND(I)) = PHKK(4,J)
               IF (IDHKK(J).EQ.2212) NCWOUN(I) = NCWOUN(I)+1
            ENDIF
    3    CONTINUE
    2 CONTINUE

c modify nuclear potential for wounded nucleons
      IPRCL  = IP -NWOUND(1)
      IPZRCL = IPZ-NCWOUN(1)
      ITRCL  = IT -NWOUND(2)
      ITZRCL = ITZ-NCWOUN(2)
      CALL DT_NCLPOT(IPZRCL,IPRCL,ITZRCL,ITRCL,ZERO,ZERO,1)

      NSTART = NPOINT(4)
      NEND   = NHKK

    7 CONTINUE
      DO 8 I=NSTART,NEND

         IF ((ABS(ISTHKK(I)).EQ.1).AND.(IDCH(I).LT.KTAUGE)) THEN
c select nucleus the cascade starts first (proj. - 1, target - -1)
            NCAS   = 1
c   projectile/target with probab. 1/2
            IF ((INCMOD.EQ.1).OR.(IDCH(I).GT.0)) THEN
               IF (DT_RNDM(TAUFOR).GT.OHALF) NCAS = -NCAS
c   in the nucleus with highest mass
            ELSEIF (INCMOD.EQ.2) THEN
               IF (IP.GT.IT) THEN
                  NCAS = -NCAS
               ELSEIF (IP.EQ.IT) THEN
                  IF (DT_RNDM(TAUFOR).GT.OHALF) NCAS = -NCAS
               ENDIF
c the nucleus the cascade starts first is requested to be the one
c moving in the direction of the secondary
            ELSEIF (INCMOD.EQ.3) THEN
               NCAS = INT(SIGN(1.0D0,PHKK(3,I)))
            ENDIF
c check that the selected "nucleus" is not a hadron
            IF (((NCAS.EQ. 1).AND.(IP.LE.1)).OR.
     &          ((NCAS.EQ.-1).AND.(IT.LE.1)))    NCAS = -NCAS

c treat intranuclear cascade in the nucleus selected first
            LCAS = .FALSE.
            CALL DT_INUCAS(IT,IP,I,LCAS,NCAS,IREJ1)
            IF (IREJ1.NE.0) GOTO 9998
c treat intranuclear cascade in the other nucleus if this isn't a had.
            NCAS = -NCAS
            IF (((NCAS.EQ. 1).AND.(IP.GT.1)).OR.
     &          ((NCAS.EQ.-1).AND.(IT.GT.1)))    THEN
               IF (LCAS) CALL DT_INUCAS(IT,IP,I,LCAS,NCAS,IREJ1)
               IF (IREJ1.NE.0) GOTO 9998
            ENDIF

         ENDIF

    8 CONTINUE
      NSTART = NEND+1
      NEND   = NHKK
      IF (NSTART.LE.NEND) GOTO 7

      RETURN

 9998 CONTINUE
c reject this event
      IRINC = IRINC+1
      IREJ = 1

 9999 CONTINUE
c intranucl. cascade not treated because of interaction properties or
c it is supressed by user or it was rejected or...
      LFZC = .FALSE.
c reset flag characterizing direction of motion in n-n-cms
c*sr14-11-95
C     DO 9990 I=NPOINT(5),NHKK
C        IF (ISTHKK(I).EQ.-1) ISTHKK(I)=1
C9990 CONTINUE

      RETURN
      END
c
c===inucas=============================================================*
c
CDECK  ID>, DT_INUCAS
      SUBROUTINE DT_INUCAS(IT,IP,IDXCAS,LCAS,NCAS,IREJ)

c***********************************************************************
c Formation zone supressed IntraNUclear CAScade for one final state    *
c particle.                                                            *
c           IT, IP    mass numbers of target, projectile nuclei        *
c           IDXCAS    index of final state particle in DTEVT1          *
c           NCAS =  1 intranuclear cascade in projectile               *
c                = -1 intranuclear cascade in target                   *
c This version dated 18.11.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                                   !    the host name where  the job runs.)

        character*32 SharpEnv      !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/#/ in \verb/#_/ or \verb/#./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/#/ is replaced by
                                   !    the process number of the run).

        character*32 PercentEnv    !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/%/ in \verb/%_/ or \verb/%./ 
                                   !   expressing a  part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/%/ is replaced by
                                   !    the USER name).


c	<-)	-------------------------------------
	common /Zmanagerpc/
     *  BaseTime,  BaseErg, BasePower, Within, UserHookr(10),
     *  ErrorOut, Cont, InitRN(2), UserHooki(10),
     *  EventsInTheRun, DestEventNo(2), Hidden, TempDev, 
     *  PrevEventNo, SeedFileDev, EventNo


       common /Zmanagerpc2/
     * UserHookc(5), PrimaryFile,
     * CutOffFile,  Job, ContFile, AtmosFile, GeomagFile,
     * SkeletonFile, SeedFile, DpmFile, DeadLine, SharpEnv,
     * PercentEnv, AtEnv
 
      SAVE
      PARAMETER (LOUT=6,LLOOK=9)

      PARAMETER (TINY10=1.0D-10,TINY2=1.0D-2,ZERO=0.0D0,DLARGE=1.0D10,
     &           OHALF=0.5D0,ONE=1.0D0)
      PARAMETER (FM2MM=1.0D-12,RNUCLE = 1.12D0)
      PARAMETER (TWOPI=6.283185307179586454D+00)
      PARAMETER (PLOWH=0.01D0,PHIH=9.0D0)

      LOGICAL LABSOR,LCAS

c event history

      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

c extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

c final state after inc step
      PARAMETER (MAXFSP=10)
      COMMON /DTCAPA/ PFSP(5,MAXFSP),IDFSP(MAXFSP),NFSP

c flags for input different options
      LOGICAL LEMCCK,LHADRO,LSEADI,LEVAPO
      COMMON /DTFLG1/ IFRAG(2),IRESCO,IMSHL,IRESRJ,IOULEV(6),
     &                LEMCCK,LHADRO(0:9),LSEADI,LEVAPO,IFRAME

c particle properties (BAMJET index convention)
      CHARACTER*8  ANAME
      COMMON /DTPART/ ANAME(210),AAM(210),GA(210),TAU(210),
     &                IICH(210),IIBAR(210),K1(210),K2(210)

c Glauber formalism: collision properties
      COMMON /DTGLCP/ RPROJ,RTARG,BIMPAC,
     &                NWTSAM,NWASAM,NWBSAM,NWTACC,NWAACC,NWBACC

c nuclear potential
      LOGICAL LFERMI
      COMMON /DTNPOT/ PFERMP(2),PFERMN(2),FERMOD,
     &                EBINDP(2),EBINDN(2),EPOT(2,210),
     &                ETACOU(2),ICOUL,LFERMI

c parameter for intranuclear cascade
      LOGICAL LPAULI
      COMMON /DTFOTI/ TAUFOR,KTAUGE,ITAUVE,INCMOD,LPAULI

c final state after intranuclear cascade step
      COMMON /DTPAUL/ EWOUND(2,300),NWOUND(2),IDXINC(2000),NOINC

c nucleon-nucleon event-generator
      CHARACTER*8 CMODEL
      LOGICAL LPHOIN
      COMMON /DTMODL/ CMODEL(4),ELOJET,MCGENE,LPHOIN

c statistics: residual nuclei
      COMMON /DTSTA2/ EXCDPM(4),EXCEVA(2),
     &                NINCGE,NINCCO(2,3),NINCHR(2,2),NINCWO(2),
     &                NINCST(2,4),NINCEV(2),
     &                NRESTO(2),NRESPR(2),NRESNU(2),NRESBA(2),
     &                NRESPB(2),NRESCH(2),NRESEV(4),
     &                NEVA(2,6),NEVAGA(2),NEVAHT(2),NEVAHY(2,2,240),
     &                NEVAFI(2,2)


      DIMENSION PCAS(2,5),PTOCAS(2),COSCAS(2,3),VTXCAS(2,4),VTXCA1(2,4),
     &          PCAS1(5),PNUC(5),BGTA(4),
     &          BGCAS(2),GACAS(2),BECAS(2),
     &          RNUC(2),BIMPC(2),VTXDST(3),IDXSPE(2),IDSPE(2),NWTMP(2)

      DATA PDIF /0.545D0/

      IREJ = 0

c update counter
      IF (NINCEV(1).NE.NEVHKK) THEN
         NINCEV(1) = NEVHKK
         NINCEV(2) = NINCEV(2)+1
      ENDIF

c "BAMJET-index" of this hadron
      IDCAS = IDBAM(IDXCAS)
c////////////KK   NOte if next call is activated, Epics will have
c                 unresolved external reference. 
c      if(IDCAS .le. 0) then
c         call checkstat("inucas1")
c         goto 9999
c      endif
c/////////////
      IF (IDT_MCHAD(IDCAS).EQ.-1) RETURN

c skip gammas, electrons, etc..
      IF (AAM(IDCAS).LT.TINY2) RETURN

c Lorentz-trsf. into projectile rest system
      IF (IP.GT.1) THEN
         CALL DT_LTRANS(PHKK(1,IDXCAS),PHKK(2,IDXCAS),PHKK(3,IDXCAS),
     &               PHKK(4,IDXCAS),PCAS(1,1),PCAS(1,2),PCAS(1,3),
     &               PCAS(1,4),IDCAS,-2)
         PTOCAS(1) = SQRT(PCAS(1,1)**2+PCAS(1,2)**2+PCAS(1,3)**2)
         PCAS(1,5) = (PCAS(1,4)-PTOCAS(1))*(PCAS(1,4)+PTOCAS(1))
         IF (PCAS(1,5).GT.ZERO) THEN
            PCAS(1,5) = SQRT(PCAS(1,5))
         ELSE
            PCAS(1,5) = AAM(IDCAS)
         ENDIF
         DO 20 K=1,3
            COSCAS(1,K) = PCAS(1,K)/MAX(PTOCAS(1),TINY10)
   20    CONTINUE
c Lorentz-parameters
c   particle rest system --> projectile rest system
         BGCAS(1) = PTOCAS(1)/MAX(PCAS(1,5),TINY10)
         GACAS(1) = PCAS(1,4)/MAX(PCAS(1,5),TINY10)
         BECAS(1) = BGCAS(1)/GACAS(1)
      ELSE
         DO 21 K=1,5
            PCAS(1,K) = ZERO
            IF (K.LE.3) COSCAS(1,K) = ZERO
   21    CONTINUE
         PTOCAS(1) = ZERO
         BGCAS(1)  = ZERO
         GACAS(1)  = ZERO
         BECAS(1)  = ZERO
      ENDIF
c Lorentz-trsf. into target rest system
      IF (IT.GT.1) THEN
c LEPTO: final state particles are already in target rest frame
C        IF (MCGENE.EQ.3) THEN
C           PCAS(2,1) = PHKK(1,IDXCAS)
C           PCAS(2,2) = PHKK(2,IDXCAS)
C           PCAS(2,3) = PHKK(3,IDXCAS)
C           PCAS(2,4) = PHKK(4,IDXCAS)
C        ELSE
            CALL DT_LTRANS(PHKK(1,IDXCAS),PHKK(2,IDXCAS),PHKK(3,IDXCAS),
     &                  PHKK(4,IDXCAS),PCAS(2,1),PCAS(2,2),PCAS(2,3),
     &                  PCAS(2,4),IDCAS,-3)
C        ENDIF
         PTOCAS(2) = SQRT(PCAS(2,1)**2+PCAS(2,2)**2+PCAS(2,3)**2)
         PCAS(2,5) = (PCAS(2,4)-PTOCAS(2))*(PCAS(2,4)+PTOCAS(2))
         IF (PCAS(2,5).GT.ZERO) THEN
            PCAS(2,5) = SQRT(PCAS(2,5))
         ELSE
            PCAS(2,5) = AAM(IDCAS)
         ENDIF
         DO 22 K=1,3
            COSCAS(2,K) = PCAS(2,K)/MAX(PTOCAS(2),TINY10)
   22    CONTINUE
c Lorentz-parameters
c   particle rest system --> target rest system
         BGCAS(2) = PTOCAS(2)/MAX(PCAS(2,5),TINY10)
         GACAS(2) = PCAS(2,4)/MAX(PCAS(2,5),TINY10)
         BECAS(2) = BGCAS(2)/GACAS(2)
      ELSE
         DO 23 K=1,5
            PCAS(2,K) = ZERO
            IF (K.LE.3) COSCAS(2,K) = ZERO
   23    CONTINUE
         PTOCAS(2) = ZERO
         BGCAS(2)  = ZERO
         GACAS(2)  = ZERO
         BECAS(2)  = ZERO
      ENDIF

c radii of nuclei (mm) modified by the wall-depth of the Woods-Saxon-
c potential (see CONUCL)
      RNUC(1)  = (RPROJ+4.605D0*PDIF)*FM2MM
      RNUC(2)  = (RTARG+4.605D0*PDIF)*FM2MM
c impact parameter (the projectile moving along z)
      BIMPC(1) = ZERO
      BIMPC(2) = BIMPAC*FM2MM

c get position of initial hadron in projectile/target rest-syst.
      DO 3 K=1,4
         VTXCAS(1,K) = WHKK(K,IDXCAS)
         VTXCAS(2,K) = VHKK(K,IDXCAS)
    3 CONTINUE

      ICAS = 1
      I2   = 2
      IF (NCAS.EQ.-1) THEN
         ICAS = 2
         I2   = 1
      ENDIF

      IF (PTOCAS(ICAS).LT.TINY10) THEN
         WRITE(ErrorOut,1000) PTOCAS
 1000    FORMAT(1X,'INUCAS:   WARNING! ZERO MOMENTUM OF INITIAL',
     &          '  HADRON ',/,20X,2E12.4)
         GOTO 9999
      ENDIF

c reset spectator flags
      NSPE = 0
      IDXSPE(1) = 0
      IDXSPE(2) = 0
      IDSPE(1)  = 0
      IDSPE(2)  = 0

c formation length (in fm)
C     IF (LCAS) THEN
C        DEL0 = ZERO
C     ELSE
         DEL0 = TAUFOR*BGCAS(ICAS)
         IF (ITAUVE.EQ.1) THEN
            AMT  = PCAS(ICAS,1)**2+PCAS(ICAS,2)**2+PCAS(ICAS,5)**2
            DEL0 = DEL0*PCAS(ICAS,5)**2/AMT
         ENDIF
C     ENDIF
c   sample from exp(-del/del0)
      DEL1   = -DEL0*LOG(MAX(DT_RNDM(DEL0),TINY10))
c save formation time
      TAUSA1 = DEL1/BGCAS(ICAS)
      REL1   = TAUSA1*BGCAS(I2)

      DEL    = DEL1
      TAUSAM = DEL/BGCAS(ICAS)
      REL    = TAUSAM*BGCAS(I2)

c special treatment for negative particles unable to escape
c nuclear potential (implemented for ap, pi-, K- only)
      LABSOR = .FALSE.
      IF ((IICH(IDCAS).EQ.-1).AND.(IDCAS.LT.20)) THEN
c   threshold energy = nuclear potential + Coulomb potential
c   (nuclear potential for hadron-nucleus interactions only)
         ETHR = AAM(IDCAS)+EPOT(ICAS,IDCAS)+ETACOU(ICAS)
         IF (PCAS(ICAS,4).LT.ETHR) THEN
            DO 4 K=1,5
               PCAS1(K) = PCAS(ICAS,K)
    4       CONTINUE
c   "absorb" negative particle in nucleus
            CALL DT_ABSORP(IDCAS,PCAS1,NCAS,NSPE,IDSPE,IDXSPE,0,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            IF (NSPE.GE.1) LABSOR = .TRUE.
         ENDIF
      ENDIF

c if the initial particle has not been absorbed proceed with
c "normal" cascade
      IF (.NOT.LABSOR) THEN

c   calculate coordinates of hadron at the end of the formation zone
c   transport-time and -step in the rest system where this step is
c   treated
         DSTEP  = DEL*FM2MM
         DTIME  = DSTEP/BECAS(ICAS)
         RSTEP  = REL*FM2MM
         IF ((IP.GT.1).AND.(IT.GT.1)) THEN
            RTIME = RSTEP/BECAS(I2)
         ELSE
            RTIME = ZERO
         ENDIF
c   save step whithout considering the overlapping region
         DSTEP1 = DEL1*FM2MM
         DTIME1 = DSTEP1/BECAS(ICAS)
         RSTEP1 = REL1*FM2MM
         IF ((IP.GT.1).AND.(IT.GT.1)) THEN
            RTIME1 = RSTEP1/BECAS(I2)
         ELSE
            RTIME1 = ZERO
         ENDIF
c   transport to the end of the formation zone in this system
         DO 5 K=1,3
            VTXCA1(ICAS,K) = VTXCAS(ICAS,K)+DSTEP1*COSCAS(ICAS,K)
            VTXCA1(I2,K)   = VTXCAS(I2,K)  +RSTEP1*COSCAS(I2,K)
            VTXCAS(ICAS,K) = VTXCAS(ICAS,K)+DSTEP*COSCAS(ICAS,K)
            VTXCAS(I2,K)   = VTXCAS(I2,K)  +RSTEP*COSCAS(I2,K)
    5    CONTINUE
         VTXCA1(ICAS,4) = VTXCAS(ICAS,4)+DTIME1
         VTXCA1(I2,4)   = VTXCAS(I2,4)  +RTIME1
         VTXCAS(ICAS,4) = VTXCAS(ICAS,4)+DTIME
         VTXCAS(I2,4)   = VTXCAS(I2,4)  +RTIME

         IF ((IP.GT.1).AND.(IT.GT.1)) THEN
            XCAS   = VTXCAS(ICAS,1)
            YCAS   = VTXCAS(ICAS,2)
            XNCLTA = BIMPAC*FM2MM
            RNCLPR = (RPROJ+RNUCLE)*FM2MM
            RNCLTA = (RTARG+RNUCLE)*FM2MM
C           RNCLPR = (RPROJ+1.605D0*PDIF)*FM2MM
C           RNCLTA = (RTARG+1.605D0*PDIF)*FM2MM
C           RNCLPR = (RPROJ)*FM2MM
C           RNCLTA = (RTARG)*FM2MM
            RCASPR = SQRT( XCAS**2        +YCAS**2)
            RCASTA = SQRT((XCAS-XNCLTA)**2+YCAS**2)
            IF ((RCASPR.LT.RNCLPR).AND.(RCASTA.LT.RNCLTA)) THEN
               IF (IDCH(IDXCAS).EQ.0) NOBAM(IDXCAS) = 3
            ENDIF
         ENDIF

c   check if particle is already outside of the corresp. nucleus
         RDIST = SQRT((VTXCAS(ICAS,1)-BIMPC(ICAS))**2+
     &                VTXCAS(ICAS,2)**2+VTXCAS(ICAS,3)**2)
         IF (RDIST.GE.RNUC(ICAS)) THEN
c   here: IDCH is the generation of the final state part. starting
c   with zero for hadronization products
c   flag particles of generation 0 being outside the nuclei after
c   formation time (to be used for excitation energy calculation)
            IF ((IDCH(IDXCAS).EQ.0).AND.(NOBAM(IDXCAS).LT.3))
     &         NOBAM(IDXCAS) = NOBAM(IDXCAS)+ICAS
            GOTO 9997
         ENDIF
         DIST   = DLARGE
         DISTP  = DLARGE
         DISTN  = DLARGE
         IDXP   = 0
         IDXN   = 0

c   already here: skip particles being outside HADRIN "energy-window"
c   to avoid wasting of time
         NINCHR(ICAS,1) = NINCHR(ICAS,1)+1
         IF ((PTOCAS(ICAS).LE.PLOWH).OR.(PTOCAS(ICAS).GE.PHIH)) THEN
            NINCHR(ICAS,2) = NINCHR(ICAS,2)+1
C           WRITE(LOUT,1002) IDXCAS,IDCAS,ICAS,PTOCAS(ICAS),NEVHKK
C1002       FORMAT(1X,'INUCAS:   warning! momentum of particle with ',
C    &             'index ',I5,' (id: ',I3,') ',I3,/,11X,'p_tot = ',
C    &             E12.4,', above or below HADRIN-thresholds',I6)
            NSPE = 0
            GOTO 9997
         ENDIF

         DO 7 IDXHKK=1,NOINC
            I = IDXINC(IDXHKK)
c   scan DTEVT1 for unwounded or excited nucleons
            IF ((ISTHKK(I).EQ.12+ICAS).OR.(ISTHKK(I).EQ.14+ICAS)) THEN
               DO 8 K=1,3
                  IF (ICAS.EQ.1) THEN
                     VTXDST(K) = WHKK(K,I)-VTXCAS(1,K)
                  ELSEIF (ICAS.EQ.2) THEN
                     VTXDST(K) = VHKK(K,I)-VTXCAS(2,K)
                  ENDIF
    8          CONTINUE
               POSNUC = VTXDST(1)*COSCAS(ICAS,1)+
     &                  VTXDST(2)*COSCAS(ICAS,2)+
     &                  VTXDST(3)*COSCAS(ICAS,3)
c   check if nucleon is situated in forward direction
               IF (POSNUC.GT.ZERO) THEN
c   distance between hadron and this nucleon
                  DISTNU = SQRT(VTXDST(1)**2+VTXDST(2)**2+
     &                          VTXDST(3)**2)
c   impact parameter
                  BIMNU2 = DISTNU**2-POSNUC**2
                  IF (BIMNU2.LT.ZERO) THEN
                     WRITE(ErrorOut,1001) DISTNU,POSNUC,BIMNU2
 1001                FORMAT(1X,'INUCAS:   WARNING! INCONSISTENT IMPACT',
     &                      '  PARAMETER ',/,20X,3E12.4)
                     GOTO 7
                  ENDIF
                  BIMNU  = SQRT(BIMNU2)
c   maximum impact parameter to have interaction
                  IDNUC  = IDT_ICIHAD(IDHKK(I))
c////////////KK
c      if(IDNUC .le. 0) then
c         call checkstat("inucas2")
c         goto 9999
c      endif
c      if(IDCAS .le. 0) then
c         call checkstat("inucas3")
c         goto 9999
c      endif
c/////////////

                  IDNUC1 = IDT_MCHAD(IDNUC)
                  IDCAS1 = IDT_MCHAD(IDCAS)
                  DO 19 K=1,5
                     PCAS1(K) = PCAS(ICAS,K)
                     PNUC(K)  = PHKK(K,I)
   19             CONTINUE
c Lorentz-parameter for trafo into rest-system of target
                  DO 18 K=1,4
                     BGTA(K) = PNUC(K)/MAX(PNUC(5),TINY10)
   18             CONTINUE
c transformation of projectile into rest-system of target
                  CALL DT_DALTRA(BGTA(4),-BGTA(1),-BGTA(2),-BGTA(3),
     &                        PCAS1(1),PCAS1(2),PCAS1(3),PCAS1(4),
     &                        PPTOT,PX,PY,PZ,PE)
c*
C                 CALL DT_SIHNIN(IDCAS1,IDNUC1,PPTOT,SIGIN)
C                 CALL DT_SIHNEL(IDCAS1,IDNUC1,PPTOT,SIGEL)
                  DUMZER = ZERO
                  CALL DT_XSHN(IDCAS1,IDNUC1,PPTOT,DUMZER,SIGTOT,SIGEL)
                  CALL DT_SIHNAB(IDCAS1,IDNUC1,PPTOT,SIGAB)
                  IF (((IDCAS1.EQ.13).OR.(IDCAS1.EQ.14)).AND.
     &                (PPTOT.LT.0.15D0)) SIGEL = SIGEL/2.0D0
                  SIGIN = SIGTOT-SIGEL-SIGAB
C                 SIGTOT = SIGIN+SIGEL+SIGAB
c*
                  BIMMAX = SQRT(SIGTOT/(5.0D0*TWOPI))*FM2MM
c   check if interaction is possible
                  IF (BIMNU.LE.BIMMAX) THEN
c   get nucleon with smallest distance and kind of interaction
c   (elastic/inelastic)
                     IF (DISTNU.LT.DIST) THEN
                        DIST      = DISTNU
                        BINT      = BIMNU
                        IF (IDNUC.NE.IDSPE(1)) THEN
                           IDSPE(2)  = IDSPE(1)
                           IDXSPE(2) = IDXSPE(1)
                           IDSPE(1)  = IDNUC
                        ENDIF
                        IDXSPE(1) = I
                        NSPE      = 1
c*sr
                        SELA = SIGEL
                        SABS = SIGAB
                        STOT = SIGTOT
C                       IF ((IDCAS.EQ.2).OR.(IDCAS.EQ.9)) THEN
C                          SELA = SIGEL
C                          STOT = SIGIN+SIGEL
C                       ELSE
C                          SELA = SIGEL+0.75D0*SIGIN
C                          STOT = 0.25D0*SIGIN+SELA
C                       ENDIF
c*
                     ENDIF
                  ENDIF
               ENDIF
               DISTNU = SQRT(VTXDST(1)**2+VTXDST(2)**2+
     &                       VTXDST(3)**2)
               IDNUC  = IDT_ICIHAD(IDHKK(I))
               IF (IDNUC.EQ.1) THEN
                  IF (DISTNU.LT.DISTP) THEN
                     DISTP = DISTNU
                     IDXP  = I
                     POSP  = POSNUC
                  ENDIF
               ELSEIF (IDNUC.EQ.8) THEN
                  IF (DISTNU.LT.DISTN) THEN
                     DISTN = DISTNU
                     IDXN  = I
                     POSN  = POSNUC
                  ENDIF
               ENDIF
            ENDIF
    7    CONTINUE

c there is no nucleon for a secondary interaction
         IF (NSPE.EQ.0) GOTO 9997

C        IF ((IDCAS.EQ.13).AND.((PCAS(ICAS,4)-PCAS(ICAS,5)).LT.0.1D0))
C    &      WRITE(LOUT,*) STOT,SELA,SABS,IDXSPE
         IF (IDXSPE(2).EQ.0) THEN
            IF ((IDSPE(1).EQ.1).AND.(IDXN.GT.0)) THEN
C              DO 80 K=1,3
C                 IF (ICAS.EQ.1) THEN
C                    VTXDST(K) = WHKK(K,IDXN)-WHKK(K,IDXSPE(1))
C                 ELSEIF (ICAS.EQ.2) THEN
C                    VTXDST(K) = VHKK(K,IDXN)-VHKK(K,IDXSPE(1))
C                 ENDIF
C  80          CONTINUE
C              DISTNU = SQRT(VTXDST(1)**2+VTXDST(2)**2+
C    &                       VTXDST(3)**2)
C              IF ((DISTNU.LT.15.0D0*FM2MM).OR.(POSN.GT.ZERO)) THEN
                  IDXSPE(2) = IDXN
                  IDSPE(2)  = 8
C              ELSE
C                 STOT = STOT-SABS
C                 SABS = ZERO
C              ENDIF
            ELSEIF ((IDSPE(1).EQ.8).AND.(IDXP.GT.0)) THEN
C              DO 81 K=1,3
C                 IF (ICAS.EQ.1) THEN
C                    VTXDST(K) = WHKK(K,IDXP)-WHKK(K,IDXSPE(1))
C                 ELSEIF (ICAS.EQ.2) THEN
C                    VTXDST(K) = VHKK(K,IDXP)-VHKK(K,IDXSPE(1))
C                 ENDIF
C  81          CONTINUE
C              DISTNU = SQRT(VTXDST(1)**2+VTXDST(2)**2+
C    &                       VTXDST(3)**2)
C              IF ((DISTNU.LT.15.0D0*FM2MM).OR.(POSP.GT.ZERO)) THEN
                  IDXSPE(2) = IDXP
                  IDSPE(2)  = 1
C              ELSE
C                 STOT = STOT-SABS
C                 SABS = ZERO
C              ENDIF
            ELSE
               STOT = STOT-SABS
               SABS = ZERO
            ENDIF
         ENDIF
         RR = DT_RNDM(DIST)
         IF (RR.LT.SELA/STOT) THEN
            IPROC = 2
         ELSEIF ((RR.GE.SELA/STOT).AND.(RR.LT.(SELA+SABS)/STOT)) THEN
            IPROC = 3
         ELSE
            IPROC = 1
         ENDIF

         DO 9 K=1,5
            PCAS1(K) = PCAS(ICAS,K)
            PNUC(K)  = PHKK(K,IDXSPE(1))
    9    CONTINUE
         IF (IPROC.EQ.3) THEN
c 2-nucleon absorption of pion
            NSPE = 2
            CALL DT_ABSORP(IDCAS,PCAS1,NCAS,NSPE,IDSPE,IDXSPE,1,IREJ1)
            IF (IREJ1.NE.0) GOTO 9999
            IF (NSPE.GE.1) LABSOR = .TRUE.
         ELSE
c sample secondary interaction
            IDNUC = IDBAM(IDXSPE(1))
            CALL DT_HADRIN(IDCAS,PCAS1,IDNUC,PNUC,IPROC,IREJ1)
            IF (IREJ1.EQ.1) GOTO 9999
            IF (IREJ1.GT.1) GOTO 9998
         ENDIF
      ENDIF

c update arrays to include Pauli-principle
      DO 10 I=1,NSPE
         IF (NWOUND(ICAS).LE.299) THEN
            NWOUND(ICAS) = NWOUND(ICAS)+1
            EWOUND(ICAS,NWOUND(ICAS)) = PHKK(4,IDXSPE(I))
         ENDIF
   10 CONTINUE

c dump initial hadron for energy-momentum conservation check
      IF (LEMCCK)
     &   CALL DT_EVTEMC(PCAS(ICAS,1),PCAS(ICAS,2),PCAS(ICAS,3),
     &               PCAS(ICAS,4),1,IDUM,IDUM)

c dump final state particles into DTEVT1

c   check if Pauli-principle is fulfilled
      NPAULI = 0
      NWTMP(1) = NWOUND(1)
      NWTMP(2) = NWOUND(2)
      DO 111 I=1,NFSP
         NPAULI = 0
         J1 = 2
         IF (((NCAS.EQ. 1).AND.(IT.LE.1)).OR.
     &       ((NCAS.EQ.-1).AND.(IP.LE.1)))    J1 = 1
         DO 117 J=1,J1
            IF ((NPAULI.NE.0).AND.(J.EQ.2)) GOTO 117
            IF (J.EQ.1) THEN
               IDX = ICAS
               PE  = PFSP(4,I)
            ELSE
               IDX  = I2
               MODE = 1
               IF (IDX.EQ.1) MODE = -1
               CALL DT_LTNUC(PFSP(3,I),PFSP(4,I),PZ,PE,MODE)
            ENDIF
c first check if cascade step is forbidden due to Pauli-principle
c (in case of absorpion this step is forced)
            IF ((.NOT.LABSOR).AND.LPAULI.AND.((IDFSP(I).EQ.1).OR.
     &          (IDFSP(I).EQ.8))) THEN
c   get nuclear potential barrier
               POT = EPOT(IDX,IDFSP(I))+AAM(IDFSP(I))
               IF (IDFSP(I).EQ.1) THEN
                  POTLOW = POT-EBINDP(IDX)
               ELSE
                  POTLOW = POT-EBINDN(IDX)
               ENDIF
c   final state particle not able to escape nucleus
               IF (PE.LE.POTLOW) THEN
c     check if there are wounded nucleons
                  IF ((NWOUND(IDX).GE.1).AND.(PE.GE.
     &                 EWOUND(IDX,NWOUND(IDX)))) THEN
                     NPAULI      = NPAULI+1
                     NWOUND(IDX) = NWOUND(IDX)-1
                  ELSE
c     interaction prohibited by Pauli-principle
                     NWOUND(1) = NWTMP(1)
                     NWOUND(2) = NWTMP(2)
                     GOTO 9997
                  ENDIF
               ENDIF
            ENDIF
  117    CONTINUE
  111 CONTINUE

      NPAULI = 0
      NWOUND(1) = NWTMP(1)
      NWOUND(2) = NWTMP(2)

      DO 11 I=1,NFSP

         IST = ISTHKK(IDXCAS)

         NPAULI = 0
         J1 = 2
         IF (((NCAS.EQ. 1).AND.(IT.LE.1)).OR.
     &       ((NCAS.EQ.-1).AND.(IP.LE.1)))    J1 = 1
         DO 17 J=1,J1
            IF ((NPAULI.NE.0).AND.(J.EQ.2)) GOTO 17
            IDX = ICAS
            PE  = PFSP(4,I)
            IF (J.EQ.2) THEN
               IDX = I2
               CALL DT_LTNUC(PFSP(3,I),PFSP(4,I),PZ,PE,NCAS)
            ENDIF
c first check if cascade step is forbidden due to Pauli-principle
c (in case of absorpion this step is forced)
            IF ((.NOT.LABSOR).AND.LPAULI.AND.((IDFSP(I).EQ.1).OR.
     &          (IDFSP(I).EQ.8))) THEN
c   get nuclear potential barrier
               POT = EPOT(IDX,IDFSP(I))+AAM(IDFSP(I))
               IF (IDFSP(I).EQ.1) THEN
                  POTLOW = POT-EBINDP(IDX)
               ELSE
                  POTLOW = POT-EBINDN(IDX)
               ENDIF
c   final state particle not able to escape nucleus
               IF (PE.LE.POTLOW) THEN
c     check if there are wounded nucleons
                  IF ((NWOUND(IDX).GE.1).AND.(PE.GE.
     &                 EWOUND(IDX,NWOUND(IDX)))) THEN
                     NWOUND(IDX) = NWOUND(IDX)-1
                     NPAULI = NPAULI+1
                     IST    = 14+IDX
                  ELSE
c     interaction prohibited by Pauli-principle
                     NWOUND(1) = NWTMP(1)
                     NWOUND(2) = NWTMP(2)
                     GOTO 9997
                  ENDIF
c*sr
c               ELSEIF (PE.LE.POT) THEN
cC              ELSEIF ((PE.LE.POT).AND.(NWOUND(IDX).GE.1)) THEN
cC                 NWOUND(IDX) = NWOUND(IDX)-1
c**
c                  NPAULI = NPAULI+1
c                  IST    = 14+IDX
               ENDIF
            ENDIF
   17    CONTINUE

c dump final state particles for energy-momentum conservation check
         IF (LEMCCK) CALL DT_EVTEMC(-PFSP(1,I),-PFSP(2,I),-PFSP(3,I),
     &                           -PFSP(4,I),2,IDUM,IDUM)

         PX = PFSP(1,I)
         PY = PFSP(2,I)
         PZ = PFSP(3,I)
         PE = PFSP(4,I)
         IF (ABS(IST).EQ.1) THEN
c transform particles back into n-n cms
c LEPTO: leave final state particles in target rest frame
C           IF (MCGENE.EQ.3) THEN
C              PFSP(1,I) = PX
C              PFSP(2,I) = PY
C              PFSP(3,I) = PZ
C              PFSP(4,I) = PE
C           ELSE
               IMODE = ICAS+1
               CALL DT_LTRANS(PX,PY,PZ,PE,PFSP(1,I),PFSP(2,I),PFSP(3,I),
     &                     PFSP(4,I),IDFSP(I),IMODE)
C           ENDIF
         ELSEIF ((ICAS.EQ.2).AND.(IST.EQ.15)) THEN
c target cascade but fsp got stuck in proj. --> transform it into
c proj. rest system
            CALL DT_LTRANS(PX,PY,PZ,PE,PFSP(1,I),PFSP(2,I),PFSP(3,I),
     &                  PFSP(4,I),IDFSP(I),-1)
         ELSEIF ((ICAS.EQ.1).AND.(IST.EQ.16)) THEN
c proj. cascade but fsp got stuck in target --> transform it into
c target rest system
            CALL DT_LTRANS(PX,PY,PZ,PE,PFSP(1,I),PFSP(2,I),PFSP(3,I),
     &                  PFSP(4,I),IDFSP(I),1)
         ENDIF

c dump final state particles into DTEVT1
         IGEN = IDCH(IDXCAS)+1
         ID   = IDT_IPDGHA(IDFSP(I))
         IXR  = 0
         IF (LABSOR) IXR = 99
         CALL DT_EVTPUT(IST,ID,IDXCAS,IDXSPE(1),PFSP(1,I),
     &               PFSP(2,I),PFSP(3,I),PFSP(4,I),0,IXR,IGEN)

c update the counter for particles which got stuck inside the nucleus
         IF ((IST.EQ.15).OR.(IST.EQ.16)) THEN
            NOINC = NOINC+1
            IDXINC(NOINC) = NHKK
         ENDIF
         IF (LABSOR) THEN
c   in case of absorption the spatial treatment is an approximate
c   solution anyway (the positions of the nucleons which "absorb" the
c   cascade particle are not taken into consideration) therefore the
c   particles are produced at the position of the cascade particle
            DO 12 K=1,4
               WHKK(K,NHKK) = WHKK(K,IDXCAS)
               VHKK(K,NHKK) = VHKK(K,IDXCAS)
   12       CONTINUE
         ELSE
c   DDISTL - distance the cascade particle moves to the intera. point
c   (the position where impact-parameter = distance to the interacting
c   nucleon), DIST - distance to the interacting nucleon at the time of
c   formation of the cascade particle, BINT - impact-parameter of this
c   cascade-interaction
            DDISTL = SQRT(DIST**2-BINT**2)
            DTIME  = DDISTL/BECAS(ICAS)
            DTIMEL = DDISTL/BGCAS(ICAS)
            RDISTL = DTIMEL*BGCAS(I2)
            IF ((IP.GT.1).AND.(IT.GT.1)) THEN
               RTIME = RDISTL/BECAS(I2)
            ELSE
               RTIME = ZERO
            ENDIF
c   RDISTL, RTIME are this step and time in the rest system of the other
c   nucleus
            DO 13 K=1,3
               VTXCA1(ICAS,K) = VTXCAS(ICAS,K)+COSCAS(ICAS,K)*DDISTL
               VTXCA1(I2,K)   = VTXCAS(I2,K)  +COSCAS(I2,K)  *RDISTL
   13       CONTINUE
            VTXCA1(ICAS,4) = VTXCAS(ICAS,4)+DTIME
            VTXCA1(I2,4)   = VTXCAS(I2,4)  +RTIME
c   position of particle production is half the impact-parameter to
c   the interacting nucleon
            DO 14 K=1,3
               WHKK(K,NHKK) = OHALF*(VTXCA1(1,K)+WHKK(K,IDXSPE(1)))
               VHKK(K,NHKK) = OHALF*(VTXCA1(2,K)+VHKK(K,IDXSPE(1)))
   14       CONTINUE
c   time of production of secondary = time of interaction
            WHKK(4,NHKK) = VTXCA1(1,4)
            VHKK(4,NHKK) = VTXCA1(2,4)
         ENDIF

   11 CONTINUE

c modify status and position of cascade particle (the latter for
c statistics reasons only)
      ISTHKK(IDXCAS) = 2
      IF (LABSOR) ISTHKK(IDXCAS) = 19
      IF (.NOT.LABSOR) THEN
         DO 15 K=1,4
            WHKK(K,IDXCAS) = VTXCA1(1,K)
            VHKK(K,IDXCAS) = VTXCA1(2,K)
   15    CONTINUE
      ENDIF

      DO 16 I=1,NSPE
         IS = IDXSPE(I)
c dump interacting nucleons for energy-momentum conservation check
         IF (LEMCCK)
     &      CALL DT_EVTEMC(PHKK(1,IS),PHKK(2,IS),PHKK(3,IS),PHKK(4,IS),
     &                                                  2,IDUM,IDUM)
c modify entry for interacting nucleons
         IF (ISTHKK(IS).EQ.12+ICAS) ISTHKK(IS)=16+ICAS
         IF (ISTHKK(IS).EQ.14+ICAS) ISTHKK(IS)=2
         IF (I.GE.2) THEN
            JDAHKK(1,IS) = JDAHKK(1,IDXSPE(1))
            JDAHKK(2,IS) = JDAHKK(2,IDXSPE(1))
         ENDIF
   16 CONTINUE

c check energy-momentum conservation
      IF (LEMCCK) THEN
         CALL DT_EVTEMC(DUM,DUM,DUM,DUM,4,500,IREJ1)
         IF (IREJ1.NE.0) GOTO 9999
      ENDIF

c update counter
      IF (LABSOR) THEN
         NINCCO(ICAS,1) = NINCCO(ICAS,1)+1
      ELSE
         IF (IPROC.EQ.1) NINCCO(ICAS,2) = NINCCO(ICAS,2)+1
         IF (IPROC.EQ.2) NINCCO(ICAS,3) = NINCCO(ICAS,3)+1
      ENDIF

      RETURN

 9997 CONTINUE
 9998 CONTINUE
c transport-step but no cascade step due to configuration (i.e. there
c is no nucleon for interaction etc.)
      IF (LCAS) THEN
         DO 100 K=1,4
C           WHKK(K,IDXCAS) = VTXCAS(1,K)
C           VHKK(K,IDXCAS) = VTXCAS(2,K)
            WHKK(K,IDXCAS) = VTXCA1(1,K)
            VHKK(K,IDXCAS) = VTXCA1(2,K)
  100    CONTINUE
      ENDIF

C9998 CONTINUE
c no cascade-step because of configuration
c (i.e. hadron outside nucleus etc.)
      LCAS = .TRUE.
      RETURN

 9999 CONTINUE
c rejection
      IREJ = 1
      RETURN
      END
c
c===absorp=============================================================*
c
CDECK  ID>, DT_ABSORP
      SUBROUTINE DT_ABSORP(IDCAS,PCAS,NCAS,NSPE,IDSPE,IDXSPE,MODE,IREJ)

c***********************************************************************
c Two-nucleon absorption of antiprotons, pi-, and K-.                  *
c Antiproton absorption is handled by HADRIN.                          *
c The following channels for meson-absorption are considered:          *
c          pi- + p + p ---> n + p                                      *
c          pi- + p + n ---> n + n                                      *
c          K-  + p + p ---> sigma+ + n / Lam + p / sigma0 + p          *
c          K-  + p + n ---> sigma- + n / Lam + n / sigma0 + n          *
c          K-  + p + p ---> sigma- + n                                 *
c      IDCAS, PCAS   identity, momentum of particle to be absorbed     *
c      NCAS =  1     intranuclear cascade in projectile                *
c           = -1     intranuclear cascade in target                    *
c      NSPE          number of spectator nucleons involved             *
c      IDXSPE(2)     DTEVT1-indices of spectator nucleons involved     *
c Revised version of the original STOPIK written by HJM and J. Ranft.  *
c This version dated 24.02.95 is written by S. Roesler                 *
c***********************************************************************

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

















c   Parameters   needed  for the Launcher.
c
c	(->	------------------------------------

	integer ErrorOut    !2 Error output logical  dev number.
	character*128  PrimaryFile  !1  Primary Spectrum data file (full or relative path)
	character*128  CutOffFile   !1  Geomagnetic cut-off file
	character*128  ContFile     !1  Job continuation information file  (full or relative path).
                                   !   default is "ContInfo".  This will be created when job
                                   !   is finished normally.
	character*128  GeomagFile   !2  IGRF or WMM file path which contains geomagnetic field expansion 
                                   !   coefficients.  Their format is the same one as given in their web 
                                   !   page.  If ' ' (default), Cosmos/Data/Geomag/igrf is used.
	character*128  SkeletonFile !1   Skeleton information file (full or relative path). created if Job =
                                   !    'skeleton'. Default is 'skeletonParam'.  This is the Namelist data
                                   !     referred by Cosmos automatically  if Job='flesh' is specified. For
                                   !     Job='flesh', you have to modify some part of  this file.
        character*128  DpmFile      !2  control card to specify the dpmjet execution conditions. If ' ',
	                           !   Cosmos/Data/DPM/atmos.inp is assumed.  
	character*10  Job          !1  What kind of job you are going to do.\newline
                                   !   =' ' (default).  nothing special.\newline
                                   !   ='skeleton'.  Makes skeleton. \newline
                                   !   ='flesh'. Flesh skeleton events.  See manual.\newline
                                   !   ='newskel'   \newline
                                   !   ='newflesh'  see manual. \newline
        character*128  SeedFile     !1   File to  contain the initial random numbers for those events to 
                                   !    which you want to flesh. You can create the file by calling
                                   !     cwriteSeed in a user hook routine (say, in chookEnEvent) at 
                                   !     skeleton making time. Default is 'Seed'.  For a normal run with
                                   !      Job=' ', if SeedFile is not ' ',  two integer initial random numbers
                                   !      and the event number are  automatically output on the speicfied disk file.
        integer       SeedFileDev  !2   logical device number of SeedFile.
	logical       Cont         !1  If T, continuation from a previous job is assumed. Contfile content is used.
	integer       InitRN       !1  Initial random number seed. 2 integers. If InitRN(1) $<$ 0, file dev  \# 14
                                   !    is  assumed to have  pairs of IR in each row, and they are read to
                                   !    initialize each event.  This feature is ignored when Job = 'flesh' or 
                                   !    'newflesh'. The \# 14 file should be opened by the user routine
                                   !    (chookBgRun). This is almost debug purpose.\newline
                                   !   If InitRn(2)$<$0, timer, hostname and process number are used for the 
                                   !    initialization.
	integer       EventNo      !2  cumulative event number counter.(excluding discarded ones due to cutoff).
	integer       EventsInTheRun !2  Counter for event number in the run. Internal use.
                                     !          (excluding discarded ones due to cutoff).
	integer       DestEventNo    !1 2 integers: Final event no. to be generated and events to be generated
                                     !  in the current run.  If negative, their absolute is used and counting 
                                     !  includes discarded ones due to rigidity cutoff.
                                     !  If DestEventNo(2)=0, DestEventNo(1) is used. If it is negative, only
                                     !  DestEventNo(2) is checked to see events in the current run. For the
                                     !  flux calculation, negative ones are better.
	logical       Hidden         !1  Make T, if hidden parameters are to be written.
	integer	      TempDev	   !2  Logical Dev. number for temporary disk use.
	integer       PrevEventNo  !2  The event number already finished.  System use for Cont job.
                                   !        (excluding discarded ones due to cutoff).
	character*8   DeadLine     !1  The dead line before which the job should terminate.
                                   !   Should be given like '10.11.15' which means the nearest 10th, 11 O'clock,
                                   !   15 min.  Not used if Within has non zero value.  
        integer       Within       !1  The job should end within this minutes from now.  Default is 99999.
                                   !   If 0 is given,  DeadLine is used.
        real*8        BaseTime     !1  Rough cpu time needed for completing one event (say, for protons, or
                                   !   gamma rays) with energy BaseErg.  The cpu time estimation is based on 
                                   !   A * ( E1ry par nucleon )**BasePower / BaseErg * BaseTime, where A is mass number
                                   !  (for nucleus; otherwise 1).
        real*8        BaseErg      !2  See BaseTime.  The default is  1000 (GeV).
        real*8        BasePower    !2  See BaseTime.   Default is 1.0
        character*100 UserHookc    !2  array size is MAX\_USERHOOKC(=5). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call  cqUHookc(i, cv)' in the userHook routine, 
                                   !   where cv is a character variable to receive the data.
        real*8        UserHookr    !2  array size is MAX\_USERHOOKR(=10). Usage is left for the user. To get the i-th
                                   !   component, the use may 'call cqUHookr(i, rv)' in the userHook routine,
                                   !   where rv is a real*8 variable to receive the data.
        integer       UserHooki    !2  array size is MAX\_USERHOOKI(=10). Usage is left for the user.  To get the i-th
                                   !   component, the use may 'call ccqUHooki(i, iv)' in the userHook rouitne,
                                   !   where iv is an integer varialbe to receive the data.
        character*128 AtmosFile    !2  path to the atmospheric data as in 'Cosmos/Data/Atmos/stdatmos2.d'

        character*32  AtEnv        !2  If this is non blank, an environmental variable with that name is
                                   !   assumed to exist and Cosmos tries to get the value of that env variable.
                                   !   If the value is obtained, the \verb/@/ in \verb/@_/ or \verb/@./
                                   !   expressing a part of a file name is replaced by that value. 
                                   !   (default is blank and in that case the \verb/@/ is replaced by
                    