      subroutine chookEabsorbi
c           init for each event
      implicit none
#include "Zmaxdef.h"
#include "Zcode.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "./Zabsorb.h"
      integer i
      do i = 0, NoOfSites + 1
c            i = 0 and NoOfSite+1 will not be used now. 
         dEbydEdx(i) = 0.
         dEbyDeath(i) = 0.
         dEbyDeathNeu(i) = 0.
         dEbyDeathNut(i) = 0.
      enddo
      do i = 1, 7
         dEbyBound(i,1) = 0.
         dEbyBound(i,2) = 0.
      enddo
      end
      subroutine chookEabsorb( a, b, dE, info )
      implicit none
#include "Zmaxdef.h"
#include "Zobs.h"
#include "Ztrack.h"
#include "./Zabsorb.h"
c   This is called when Eabsorb != 0 and
c   when a charged particle runs from a 
c   to b and deposits energy dE (GeV) to the  Air.
c             
      record /track/  a  ! input. charged particle track info. at a.
      record /track/  b  ! input. charged particle track info. at b.
      real*8  dE  ! input.  energy deposit in GeV; no weight is applied yet
      integer info ! in/out. not used now

      if(a.where .ge. 1)  then
         dEbydEdx(a.where)= dEbydEdx(a.where) + dE*a.wgt
      endif
      end
      subroutine chookEabsorbD( a, dE, info )
      implicit none
#include "Zmaxdef.h"
#include "Zcode.h"
#include "Zobs.h"
#include "Ztrack.h"
#include "./Zabsorb.h"
c   This is called when Eabsorb != 0 and
c   when a  particle energy becomes < Emin.
c   Whether this is called or not depends on the   particle
c   and bit in Eabsorb.  dE is energy that can be regarded
c   as absorbed in the Air. (GeV).
c   bit 1 is the LSB of Eabsorb.
c     
c   bit   particle
c    1     photon: used to absorb shell energy at 
c          photoelectric effect. This bit is not used in the Air.  
c    2    photon.  
c    3    e+/e-
c    4    proton
c    5    neutron
c    6    anti-N
c    7    decaying prtcl 
c    8    others
c             
c***** Normally Eabsorb=6 (110 in bit pattarn) is enough.****
c
c
      record /track/  a  ! input.  a particle that is < Emin 
                          ! at birth
      real*8  dE  ! input.  energy which is supposed to  be emitted by 
                  ! the dying particle
      integer info ! in/out. not used now.
      if(a.where .ge. 1) then
         if(a.p.code .eq. kneue .or. a.p.code .eq. kneumu) then
           !  neutrino
            dEbyDeathNeu(a.where) = dEbyDeathNeu(a.where) + dE*a.wgt
         elseif(a.p.code .eq. knuc .and. a.p.charge .eq. 0 .and.
     *          a.p.subcode .eq. regptcl ) then
            !  low E neuton
            dEbyDeathNut(a.where) = dEbyDeathNut(a.where) + dE*a.wgt
         else
                  !  and can be regarded as absorbed
                  ! in the Air almost instantly.
            dEbyDeath(a.where) = dEbyDeath(a.where) + dE*a.wgt
         endif
      endif
      end

      subroutine chookEabsorbB(a,info)
      implicit none
#include "Zmaxdef.h"
#include "Zcode.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "./Zabsorb.h"
c   This is called when a particle crosses the observation level &
c   Eabosrb != 0 
c
      record /track/  a  ! input.  a particle that croses the observation level
      integer info  ! input.  0   normal level.  1 going out to the space

      integer code
      integer lv

c            If you want to  set the boundary at anther level
c            use another value instead of NoOfASSites.
      if(info .eq. 0 ) then
         lv = 1
      elseif(info .eq. 1) then
         lv = 2
      endif

      if(a.where .eq. NoOfSites .or. info .eq. 1 ) then
         code = a.p.code
c              for other ptcls than g,e,mu, pi, K, N, use 7
         if(code .gt. 7) code=7
c             at the last layer we see sum of the particle energy
      
         dEbyBound(code, lv) = dEbyBound(code,lv) + 
     *              (a.p.fm.p(4)-a.p.mass)*a.wgt
         if( a.p.subcode .eq. antip ) then
            dEbyBound(code, lv) = dEbyBound(code, lv) + 
     *            (2*a.p.mass)*a.wgt
         endif
      endif
      end
