#include "../../cmain.f"
#include "../chookHybAS.f"
#include "../../ctemplCeren.f"
#include "howmuch.f"
#include "asinfo.f"
#include "asdensity.f"
#include "crecprob.f"
c
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"
#include "../../SkelFlesh/Zprivate.h"

      real*8  temp
      character*100 msg
      integer icon
      integer i
      EventNo = 0

c            namelist output
      call cwriteParam(ErrorOut, 0)
c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
      call cprintObs(ErrorOut)

      call cqUHooki(1, Mdev)      ! get skeleton memo dev #
      call cqUHookc(1, msg)       ! get file name for sekelton data
      call cgetfname(msg, Mskel)  ! add host name etc if needed
      call copenfw2(Mdev, Mskel, 2, icon)
      if(icon .ne. 1) then
         call cerrorMsg(Mskel,1)
         call cerrorMsg(' could not be opened',0)
      endif

      call xBgRun
      call ihist                ! instanciate histogram
      end

c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none
#include "../../SkelFlesh/Zprivate.h"


      integer nomore
      call cbegin1ev( nomore )
      if( nomore .eq. 1) then
         call cerrorMsg('all events have been fleshed', 1)
         stop                   !!!!!!!!!!!!  
      endif
      call cpushInci
 
      call xBgEvent
      return
      end
      subroutine cbegin1ev(nomore)
      implicit none
#include "../../SkelFlesh/Zprivate.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Ztrackp.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "Zcode.h"
#include "Zmanager.h"
#include "Zmanagerp.h"
      
      integer nomore       !  output. 0 still there  are showers
                           !          1 no more skeleton showers to be fleshed
c          event number, primary      

      record /track/ incident, zsave
      record /coord/ angle
      
      integer i
      integer seed(2)
      integer cumnum, num, jeof, fin
      read( Mdev, end=1000, err=999 ) cumnum, num, SeedSave, Zfirst

      EventsInTheRun = EventsInTheRun + 1
      EventNo = EventNo + 1
c                 reset the seed.
      call rnd1r(SeedSave)
c         next incident; confirmed to be the same one as preserved one
      call cmkIncident(incident, fin)
      if(fin .ne. 0 ) goto 1000
      zsave = Zfirst    ! save;  this is reset in next 
      call ciniTracking( incident )   
c          set first interaction pos
      Zfirst = zsave
c      call cresetTimer(Zfirst)



c          do your own init for a one event here
c      ==========================================================


c      ==========================================================
c

      call cgetHES(Mdev)  ! get high energy ptlcs
      call cobsHES        ! imitate their observation
      nomore = 0
      return

 1000 continue
      nomore = 1
      return
 999  continue
      write(0,*) ' Mdev read err'
      stop 1111
      end

c     ************************************ hook for observation
c     *  One particel information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Zcode.h"
#include "Ztrack.h"


      integer id  ! input.  2 ==> reached at an observation level
c                           1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack
c
c
      integer n, i
      real*8 eps, u

      if(aTrack.wgt .gt. 1.) then
         n=aTrack.wgt
         eps = aTrack.wgt - n
         call rndc(u)
         if(u .lt. eps) then
            n = n + 1
         endif
      else
         n = 1
      endif
      do i = 1, n 
         call xObs(aTrack, id)
      enddo

      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"

      integer i

c       for Job ='newflesh', we must call cfinTracking ourselves.
      call cfinTracking
c           end of 1 event; if you need to do some here is
c           the place

      call xEnEvent


      end


c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun
      implicit none
      call  cprintStatus   ! if don't like,  comment out
      end
c     ********************************* hook for trace
c     *  This is called only when trace > 100
c     *  User should manage the trace information here.
c     *  If you use this, you may need some output for trace
c     *  at the beginning of 1 event generatio and at the end of  1 event
c     *  generation so that you can identfy each event.
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

       real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 100
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height

      end
c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
      implicit none
      integer never             ! input & output
      never = 1
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
      implicit none
      integer never   ! input & output
      never = 1
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
      implicit none
      integer never   ! input & output
      never = 1
      end


      subroutine cgetHES(from)
      implicit none
#include "../../SkelFlesh/Zprivate.h"
      integer from

      integer i

      read(from)  Np
      do i = 1, Np
         read(from) o(i)
      enddo
      end

      subroutine cobsHES
      implicit none
#include "../../SkelFlesh/Zprivate.h"
#include "Ztrack.h"
c
c           memorized high energy showers at the skeleton making
c     time is put into the chookObs as if they are really observed
      record /track/ aTrack

      integer i
      logical  HEobs            ! if T, currently observing 
      common /ZHEobs/ HEobs     !  particles those obsrved at skeelton making time

      HEobs = .true.
      do i = 1, Np
         aTrack.where =  o(i).where 
         aTrack.p.code =  o(i).code 
         aTrack.p.subcode = o(i).subcode 
         aTrack.p.charge = o(i).charge 
         aTrack.t = o(i).atime 
         aTrack.p.fm.p(4) = o(i).erg
         aTrack.p.mass = o(i).mass 
         aTrack.pos.xyz.r(1) = o(i).x 
         aTrack.pos.xyz.r(2) = o(i).y 
         aTrack.vec.w.r(1) = o(i).wx
         aTrack.vec.w.r(2) = o(i).wy
         aTrack.vec.w.r(3) = o(i).wz
         aTrack.vec.coszenith = o(i).zenith 
         call chookObs(aTrack, 2)
      enddo
      HEobs = .false.
      end


c        push all  low energy partilces in the skeleton in the stack

      subroutine cpushInci
      implicit none
#include "../../SkelFlesh/Zprivate.h"
#include "Ztrack.h"
#include "Ztrackv.h"
      integer i

      record /track/aTrack

      call cinitStack  ! empty the stack

      read(Mdev)  NoOfLowE
      do  i = 1, NoOfLowE
         read(Mdev) aTrack
c           aTrack is already complete track so push it directly.
         call cpush(aTrack)
      enddo
c           sort stack dscendent order
      call csortStack
      
      end
