#!/bin/bash
#  When (assemHist.sh, assemNrfai.sh) assemHyb.sh assemDat.sh are finished,
#  we get ($EXECID.hist, $EXECID.nrfai) $EXECID.hyb and $EXECID.dat
# in this directory.  These are put to the $OUTDIR of the $ORIGIN
# as corresponding files of the first  failed job.
# The rest of the failed job is moved to $OUTDIR/Failed/
#
# Directory is change to  $ORIGIN/Assemble/
# and final assembling is performed by 
# using (RassemHist.sh, RassemNrfai.sh) RassemHyb.sh, RassemDat.sh;
# In these routines # of cpu's will be regarded
# as MCPU-(# of failed jobs) + 1
#
source ../Smash/setupenv.sh $0
source ../$FLESHDIR/setupenv.sh $0
# now EXECID is available

newEXECID=$EXECID

# get  host.jobnumb of first one among failed jobs
#  set ORIGIN and ARENA
source ../setupenv.sh
if [ -f ../Smash/failedHostNum ]; then 
    hostnum=`head -n 1 ../Smash/failedHostNum`
    echo "First failed job number is " $hostnum
    echo "This will be replaced by rescued result"
else
    echo "there is no ../Smash/failedHostNum"
    exit 1
fi
#    get original OUTDIR 
source ../../$ORIGIN/$FLESHDIR/setupenv.sh $0
##//////////
echo " outdir=" $OUTDIR
###////////

if [ $FLESHDIR = "FleshHist" ] ; then
    cp $newEXECID.hist  $OUTDIR/rescued-${hostnum}.hist
fi
if [ -f  $newEXECID.nrfai ];  then
    cp $newEXECID.nrfai  $OUTDIR/rescued-${hostnum}.nrfai
fi

cp $newEXECID.hyb  $OUTDIR/rescued-${hostnum}.hyb
cp $newEXECID.dat  $OUTDIR/rescued-${hostnum}.dat

#   modify hostnum.err
echo "###end of run###" >> ../../$ORIGIN/$FLESHDIR/ErrDir/*${hostnum}.err

mkdir -p ../../$ORIGIN/$FLESHDIR/ErrDir/Failed
for f in  ../../$ORIGIN/$FLESHDIR/ErrDir/*err
do
  x=`tail -n 4  $f | grep "###end of run###"`
  if [ "x$x" = "x" ];  then
      mv $f ../../$ORIGIN/$FLESHDIR/ErrDir/Failed/
  fi
done


here=`pwd`

cd ../../$ORIGIN/Assemble
if [ $FLESHDIR = "FleshHist" ] ; then
    ./RassemHist.sh
fi
./RassemHyb.sh


if [ $FLESHDIR = "FleshHist" ] ; then
  echo "Assembled .hist and .hyb data files are put in ../../$ORIGIN/Assembled (NOT in $here)"
else
  echo "Assembled  .hyb data file is  put in ../../$ORIGIN/Assembled (NOT in $here)"
fi

yesno="n"
until [ "x$yesno" = "xy" ]
do
  echo " "
  echo "***** present directory is: " `pwd`
  echo "Enter directory where final assembled .dat file is to be put"
  read dir
  echo $dir
  echo "Enter file name of final assembled .dat file(=${EXECID}.dat)"
  read filenm
  if [ x$filenm = "x" ]; then
      filenm=$EXECID.dat
  fi
  echo "Your input is " $dir " and " $filenm
  echo "Is is OK ?.  Enter y if yes"
  read yesno
done
./RassemDat.sh  $dir $filenm


