      subroutine cminTime2WebSec(obsdetxyz, ldep,  depidx,  awebmin)
      implicit none
#include  "Zglobalc.h"
#include  "Zmaxdef.h"
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zcode.h"
#include "Zheavyp.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include  "Zstackv.h"
#include "Zprivate.h"
c   #include "Zprivate2.h"
      integer ldep ! layer number of the observation depth
      integer depidx ! layer index for web array
      record /coord /obsdetxyz  ! input. observation detector axis in E-xyz
c                        = ObsSites(loc).pos.xyz  where  loc is the
c          observation layer number. 
      
      real*8 awebmin(nrbin, nfai, MaxNoOfSites) ! output. to store min time (ns)
                                 ! for each web sector.
      real*8 r, hdr, Ra, rc
      record /track/ inci
      record /coord/ angle
      integer i, j, ii, jj
      real*8 faimin,  fai, R0, Rbot, rmu, cosz
      data faimin/-15.0d0/
      record /coord/ xyz, oxyz, effpos
      real*8  temp,  dtemp, leng
      integer it



      call cqIncident(inci, angle)  ! we may better to use the first
                     ! collision point but not so easy to get it
                     ! since this is called before collision
      
      effpos = inci.pos.xyz    ! default is 100 km

ccc      effpos.z = 20.d3  ! so we use 20km instead
c         assume  web sector is aligned so that incident direcion
c         is on fai=0 of the web sector. 
c         sinz cosf= dirx
c         sinz sinf= diry
c         cosz = dirz 
c          tanf = diry/dirx;  fai=atan2(diry,dirx)
c          L dirx =x L diry =y  L dirz = z
c          L = z/dirz =
c      cosz = inci.vec.coszenith ~ -angle.r(3)

c                 Top view
c                       / this is web sector fai=0       
c                      / 
c                     /
c                    /      so fai* = fai-fai0
c                   / should be used as azimuthal angle of
c                  /           ptcls.  Therefore  we use
c                 /  fai0      effpos  as below
c               ------------------------> mag east
c
c      L cosz = effpos.z
c      L sinz = effpos.x
c      effpos.y = 0.
c

      leng = effpos.z/-angle.r(3)
      effpos.x = sqrt(1.d0-angle.r(3)**2)*leng
      effpos.y = 0.
c          convert it to xyz system
      call cdet2xyz(obsdetxyz, effpos,  effpos)

      xyz.z = 0.
      xyz.x = 0.
      xyz.y = 0.
      call cdet2xyz(obsdetxyz, xyz, oxyz)
c/////////////
c      write(0,*)  ' layer =', ldep
c      write(0,*)  ' obsdetxyx=',obsdetxyz.x,
c     *       obsdetxyz.y,   obsdetxyz.z
c      write(0,*) ' center =', oxyz.x, oxyz.y, oxyz.z
c      write(0,*) ' effposx,y,x=',effpos.x,
c     *effpos.y, effpos.z
c//////////////

      R0 = sqrt( (oxyz.x-effpos.x)**2 +
     *           (oxyz.y-effpos.y)**2 +
     *           (oxyz.z-effpos.z)**2 )
c////////////
c      write(0,*) ' R0=', R0
c///////////

      call cgetMoliereU( ObsSites(ldep).pos.depth, cosz, rmu)
c//////////
c      write(0,*)  ' mu=', rmu
c///////////

      hdr = 10.**(bin/2.)

      do i = 1, nrbin
         rc = rbin(i) * rmu ! in m
         do j = 1, nfai
            Rbot = 10.d10
c               for all web sectors examine 4 corners
            do ii = 1, 2
c                rbin is the center of the web sector in r direction (log10 center).
              if(ii .eq.  1)  then
                 r = rc/hdr
              else
                 r = rc*hdr
              endif
              do jj = j, j+1
                 fai = faimin + (jj-1)*dfai
                 xyz.x = r*cos(fai*ToRad)
                 xyz.y = r*sin(fai*Torad)
                 call cdet2xyz(obsdetxyz, xyz, oxyz)
c                     *
c                    * ^
c                   *  ^
c                  *
c              R0 *     ^  Ra
c                *
c               *        
c              *         ^  
                 Ra = sqrt( (oxyz.x-effpos.x)**2 +
     *                 (oxyz.y-effpos.y)**2 +
     *                 (oxyz.z-effpos.z)**2 )
                  if( Ra-R0 .lt. Rbot ) Rbot = Ra-R0
               enddo
            enddo  ! for a given fai bi
c/////////////
c            if(i .gt. 20 .and. j. eq. 1) then
c               write(0,*) " ridx=",i, " Rbot=", Rbot
c            endif
c///////////
c/////////////
c            Rbot may not be real mininum if incident axis lies
c            on the sector. for safety  25 % correction.  in n sec
            dtemp =1.d9* ( Rbot - abs(Rbot)*0.25 )/c  ! ns

            awebmin(i,j,depidx) = dtemp   
         enddo
      enddo


      end
