c    suppose you have .nrfai file with invalid "rec" component while
c    "all" and "dE/dx" part are correct.
c    Also you have size reduced .dat file.
c    This program read .dat file and count data in each (r, fai) bin
c    and make correct  .nrfai data.
c   The program structure is the same as reduceSize.f but we accept
c   all particles in the .dat
c       input file: .nrfai data.  give it by environmental
c                   varialbe NRFAIFILE
c                    .dat file    main output from sim.
c                       standard input.
c       output file:  rfaifile with .nrfai-r extension.        

#include "../FleshHist/asinfo.f"
#include "../FleshHist/asdensity.f"
#include "../FleshHist/crecprob.f"
      implicit none
#include "../FleshHist/Zprivate0.h"

      integer  ldep,  code, subcode,
     *        charge, ridx, faiidx, codex
      real  rinmu, fai,  Ek, time,
     *              wx, wy, wz
      real*8 u
      integer ndepth
      real    E0
      parameter (ndepth= nsites)
      real nrfaiRec0(nrbin, nfai, 4, ndepth)
      real rnrfaiRec(nrbin, nfai, 4, ndepth)
      real pnrfaiRec(nrbin, nfai, 4, ndepth)
      real nrfaiAll0(nrbin, nfai, 4, ndepth)
      real dErfai(nrbin, nfai, ndepth)
      real recprob(nrbin, 4, ndepth)

      integer EvNo0

      real limit
      real rat, all, rec, prob
      integer klena
      real intdep(ndepth)
      integer nrbina, nfaia, ansites0
      integer leng, i, j, k, l
      integer i0, j0, k0, l0
      integer NN
      integer icon0, iconx, icont
      character*128 input0
      character*100 nrfaifile, nrfaifile2
      character*3 id
      character*5 id5

      integer fnonrfai, fnonrfai2
      real  cosz, age, sum, Nx, depth
      real nptcls(nrbin, 4,  ndepth)
      integer indivdep(ndepth),  packeddepidx(ndepth), depidx
c      real rnptcls(nrbin, 4,  ndepth)
      integer  icon, kgetenv2, nrec


      fnonrfai=11
      fnonrfai2=21
      nrfaifile=" "
      leng = kgetenv2("NRFAIFILE", nrfaifile)
      if(leng .le. 0) then
         write(0,*) "Env. NRFAIFILE not given"
         stop 11111
      endif
      call copenfw2(fnonrfai, nrfaifile, 1, icon)
      if(icon .ne. 1) then
         write(0,*) ' error cannot open', nrfaifile
         stop 0000
      endif
      nrfaifile2 =" "
      nrfaifile2 = nrfaifile(1:leng)//"-r"
      call copenfw2(fnonrfai2, nrfaifile2, 1, icon)
      if(icon .ne. 0) then
         write(0,*) ' error ', nrfaifile2, ' cannot be created'
         stop 1235
      endif

      do k = 1,  ndepth
         packeddepidx(k)=0
         do j = 1, 4
            do l = 1,nfai
               do i = 1, nrbin
                  rnrfaiRec(i, l, j, k)=0
               enddo
            enddo
         enddo
      enddo
c
      do while(.true.)
         input0 = ' '
         read(fnonrfai, '(a)',  end=1000 ) input0
         if(input0 .ne. " ") then
            read(input0(1:klena(input0)), *) 
     *           EvNo0, E0,NN, cosz, limit,  nrbina, nfaia, ansites0

            write(0,*) input0

            if(nrbina .ne. nrbin .or. nfaia .ne. nfai) then
               write(0,*)' nrbina=',nrbina, 'or  nfaia=',nfaia,
     *              ' differ from the def. in this prog'
               stop 5555
            endif
            if(ansites0 .gt. ndepth) then
               write(0,*) ' too many depths'
               stop 6666
            endif
c           ********
            do i = 1, ansites0
               do j = 1, 4
                  do k = 1, nfai
                     read(fnonrfai, '(a, f7.1,  4i4)' )
     *               id, intdep(i), l0, i0, j0, k0
                     indivdep(i)=l0
                     packeddepidx(l0)=i  !  original dep index to packed indx
                     
c
c        when the above is written
c        l = indivdep(i)
c        write(fnonrfai, '("rec",f7.1, 4i4)' )
c     *     ASDepthList(l)*0.1, l, i, j, k
                                   

                     if(i0 .ne. i .or. j .ne. j0 .or. k .ne. k0) then
                        write(0,*) ' intdep, i0,j0,k0=',
     *                      intdep(i), i0, j0, k0, ' strange'
                        stop 8888
                     endif
                     if( id .ne. "rec") then
                        write(0,*) 'id=',id, ' strange'
                        stop 5678
                     endif
c
                     read(fnonrfai, *)
     *                    ( nrfaiRec0(l,k,j,i), l=1,nrbin )
                  enddo
               enddo
            enddo
c    ************
            do i = 1, ansites0
               do j = 1, 4
                  do k = 1, nfai
                     read(fnonrfai, '(a,f7.1, 4i4)' )
     *                id,  intdep(i), l0, i0, j0, k0
                     indivdep(i)=l0
                     if(i0 .ne. i .or. j .ne. j0 .or. k .ne. k0) then
                        write(0,*) ' intdep, i0,j0,k0=',
     *                      intdep(i), i0, j0, k0, ' strange'
                        stop 9876
                     endif
                     if( id .ne. "all") then
                        write(0,*) 'id=',id,' strange'
                        stop 9999
                     endif
                     read(fnonrfai, *)
     *                    ( nrfaiAll0(l,k,j,i), l=1,nrbin )
                  enddo
               enddo
            enddo
c             dErfai
            do i = 1, ansites0
               do k = 1, nfai
                  read(fnonrfai, '(a,f7.1, 3i4)' )
     *                 id5,  intdep(i), l0, i0, k0
                  indivdep(i)=l0
                  if(i0 .ne. i .or. k .ne. k0) then
                     write(0,*) ' intdep, i0,k0=',
     *                    intdep(i), i0, k0, ' strange'
                     stop 98765
                  endif
                  if( id5 .ne. "dE/dx") then
                     write(0,*) 'id=',id5,' strange'
                     stop 9999
                  endif
                  read(fnonrfai, *)
     *                    ( dErfai(l,k,i), l=1,nrbin )
               enddo
            enddo
         else
c      
            write(0,*) ' all nrfai data has been read'
            write(0, '(i2, 1pE11.3,i3, 0pf7.1, 1pE11.3, 3i4)')
     *       EvNo0, E0,NN, cosz, limit,  nrbina, nfaia, ansites0
         endif
      enddo
 1000 continue
      input0= ' '
c************* reset limit
c      limit=min(4000.0, limit)
      write(0,*) ' limit=',limit, ' is being used'
c************ 
      do i = 1,  ansites0
         do j = 1, 4
            do k = 1,nfai
               do l = 1, nrbin
                  if(nrfaiRec0(l, k, j, i) .gt. limit) then
c                       accept with this prob.
                     pnrfaiRec(l, k, j, i)=
     *                    limit/nrfaiRec0(l, k, j, i) 
                  else
                     pnrfaiRec(l, k, j, i)=1.0
                  endif
               enddo
c///////
               write(0, '(f7.1,  4i4,a)' )
     *              intdep(i), indivdep(i), i, j, k, ' prob' 
               write(0, '(1p10E11.3)')
     *               (pnrfaiRec(l,k,j,i), l=1, nrbin)
cc/////
            enddo
         enddo
      enddo
c  -------------
c            main input data; header; obsolete
c      read(*,'(a)') input0
c      write(*,'(a)') input0(1:klena(input0))
      nrec= 0
      do while(.true.)
         read(*,'(a)', end=100, Err=500) input0
         if( index(input0(1:2), "i") .gt. 0 ) cycle
C         read(*, *, end=100, Err=500)
         read(input0,*)
     *      ldep,  code, subcode,
     *      charge, ridx, faiidx,
     *      rinmu, fai,
     *      Ek, time,
     *      wx, wy, wz
         nrec= nrec+1
         depidx = packeddepidx(ldep)

         if(depidx .le. 0) then
            write(0,*) ' should not happen. depidx=',depidx
            write(0,*) ' ldep=',ldep, ' code=',code, 'nrec=',nrec
            stop 9875
         endif
         codex=min(code, 4)
c         if(u .lt.
c     *    pnrfaiRec(ridx, faiidx, codex, depidx) )  then
          rnrfaiRec(ridx, faiidx, codex, depidx)=
     *        rnrfaiRec(ridx, faiidx, codex, depidx) + 1
      enddo
 100  continue

      write( fnonrfai2,
     *     '(i2,1pE11.3, 0p,i3, f8.4, 1pE11.3,3i4)' )
     *     EvNo0, E0, NN, cosz, limit, nrbin, nfai, ansites0

      do i = 1, ansites0
         do j = 1, 4
            do k = 1, nfai
               l = indivdep(i)
               write(fnonrfai2, '("rec",f7.1, 4i4)' )
     *          intdep(i), l, i, j, k
               write(fnonrfai2, '(1p10E11.3)')
     *             ( rnrfaiRec(l,k,j,i), l=1,nrbin )
            enddo
         enddo
      enddo
      do i = 1, ansites0
         do j = 1, 4
            do k = 1, nfai
               l = indivdep(i)
               write(fnonrfai2, '("all",f7.1, 4i4)' )
     *          intdep(i), l, i, j, k
               write(fnonrfai2, '(1p10E11.3)')
     *             ( nrfaiAll0(l,k,j,i), l=1,nrbin )
            enddo
         enddo
      enddo
c     dErfai
      do i = 1, ansites0
         do k = 1, nfai
            l = indivdep(i)
            write(fnonrfai2, '("dE/dx",f7.1, 3i4)' )
     *           intdep(i), l, i, k
            write(fnonrfai2, '(1p10E11.3)')
     *           ( dErfai(l,k,i), l=1,nrbin )
         enddo
      enddo
      
      write(0,*) 'end of run'
      write(fnonrfai2,*)
      stop
 500  continue
      write(0,*) ' input error at record =', nrec
      read(*,'(a)') input0
      write(0,*) input0
      end
