      subroutine cinteNuc
      implicit none


#include  "Ztrack.h"
#include  "Ztrackv.h"
c          cinteNuc.  Treat Nucelon interactions with air target.
      character*70 msg


      if(IntInfArray(ProcessNo).process .eq. 'coll') then
         call chAcol(MovedTrack.p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      else
         write(msg, *) ' in cinteNuc: process=',
     *                IntInfArray(ProcessNo).process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg,0)
      endif
      end
c     ********************
      subroutine cintePion
c     ********************
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
c
      character*70 msg

      if(IntInfArray(ProcessNo).process .eq. 'coll') then
         call chAcol(MovedTrack.p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)

      elseif(IntInfArray(ProcessNo).process .eq. 'decay') then
         if(MovedTrack.p.charge .eq. 0) then
            call cpi0Decay(MovedTrack.p, Pwork, Nproduced)
         else
            call cpiMuDecay(MovedTrack.p, IncMuonPolari, 
     *           Pwork, Nproduced, MuonPolarization)
         endif
      else
         write(msg, *) ' in cintePion: process=',
     *           IntInfArray(ProcessNo).process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg,0)
      endif

      end
c     ********************
      subroutine cinteKaon
c     ********************
      implicit none
      
c----      include 'Ztrack.h'
#include  "Ztrack.h"
c----      include 'Ztrackv.h'
#include  "Ztrackv.h"
c----      include 'Ztrackp.h'
#include  "Ztrackp.h"
c
      character*70 msg

      if(IntInfArray(ProcessNo).process .eq. 'coll') then
         call chAcol(MovedTrack.p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      elseif(IntInfArray(ProcessNo).process .eq. 'decay') then
         call ckaonDecay(MovedTrack.p, IncMuonPolari, 
     *           Pwork, Nproduced, MuonPolarization)
      else
         write(msg, *) ' in cinteKaon: process=',
     *           IntInfArray(ProcessNo).process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
c     ********************
      subroutine cinteDmes
c     ********************
      implicit none
      
c----      include 'Ztrack.h'
#include  "Zcode.h"
#include  "Ztrack.h"
c----      include 'Ztrackv.h'
#include  "Ztrackv.h"
c
      character*70 msg
      integer icg
      icg =  MovedTrack.p.charge
      if(IntInfArray(ProcessNo).process .eq. 'decay') then
         call cdDecay(MovedTrack.p,  Pwork, Nproduced)
      elseif(IntInfArray(ProcessNo).process .eq. 'coll') then   
c            use kaon 
         if(icg .eq. 0) then
            call cmkptc(kkaon, k0l, 0, MovedTrack.p)
         else
            call cmkptc(kkaon, 0, icg, MovedTrack.p)
         endif
         call ce2p(MovedTrack.p)
         call chAcol(MovedTrack.p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      else
         write(msg, *) ' in cinteDmeson: process=',
     *           IntInfArray(ProcessNo).process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
c     ********************
      subroutine cinteHeavy
c     ********************
      implicit none
#include  "Zcode.h"      
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zevhnp.h"
#include  "Zevhnv.h"
c
      character*70 msg

      if(IntInfArray(ProcessNo).process .eq. 'coll') then
         call cheavyInt(MovedTrack.p, TargetNucleonNo,
     *         TargetProtonNo,  Pwork, Nproduced)
      else
         write(msg, *) ' in cinteHeavy: process=',
     *           IntInfArray(ProcessNo).process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
c     ********************
      subroutine cinteMuon
c     ********************
      implicit none
      
c----      include 'Ztrack.h'
#include  "Ztrack.h"
c----      include 'Ztrackv.h'
#include  "Ztrackv.h"
c----      include 'Zlife.h'
#include  "Zlife.h"
#include  "Ztrackp.h"
      real*8  capr, t0cap, u1, u2

c
      if(IntInfArray(ProcessNo).process .eq. 'decay') then
c           see if negative muon is being captured
         if(MovedTrack.p.charge .eq. -1) then
            if(MovedTrack.p.fm.p(4) .le. MovedTrack.p.mass*1.001) then
c                   assume stopping muon
               call cmucap(TargetNucleonNo, TargetProtonNo, capr)
               t0cap = 1./capr
               call rndc(u1)
               call rndc(u2)
               if( - log(u1)*t0mu .gt. - log(u2)*t0cap) then
c                     capture
                  call ccapnu(TargetNucleonNo, TargetProtonNo,
     *               Pwork, Nproduced)
               else
c!!!              MuonPolarization = 0.   ! stopping mu has no pol.
c                                          keep the value ;it's better.
                  call cmuNeuDcy(MovedTrack.p, MuonPolarization, 
     *            Eabsorb(1),   Pwork, Nproduced)
               endif
            else
               call cmuNeuDcy(MovedTrack.p, MuonPolarization,
     *            Eabsorb(1),   Pwork, Nproduced)
            endif
         else
            call cmuNeuDcy(MovedTrack.p, MuonPolarization,
     *            Eabsorb(1),   Pwork, Nproduced)
         endif
      else
         call cmuInte
      endif
      end
      subroutine csetMuonPol(val)
c         This may be used when you set muon as a primary for which
c        polarization is not fixed.
c
      implicit none
#include  "Ztrack.h"
#include "Ztrackv.h"
      real*8 val
      MuonPolarization =min(1.d0, max(val, -1.d0 ))
      end
c     ********************
      subroutine cintennb
c     ********************may be used if 1ry is nn~
      implicit none
      
c----      include 'Ztrack.h'
#include  "Ztrack.h"
c----      include 'Ztrackv.h'
#include  "Ztrackv.h"
c
      character*70 msg

      if(IntInfArray(ProcessNo).process .eq. 'decay') then
         call cnnbdc(MovedTrack.p,  Pwork, Nproduced)
      else
         write(msg, *) ' in cintennb: process=',
     *           IntInfArray(ProcessNo).process,
     *               ' undef. ProcessNo=',ProcessNo
         call  cerrorMsg(msg, 0)
      endif
      end
c     ********************
      subroutine cinteddb
c     ********************may be used if 1ry is dd~
      implicit none
      
c----      include 'Ztrack.h'
#include  "Ztrack.h"
c----      include 'Ztrackv.h'
#include  "Ztrackv.h"
c
      character*70  msg

      if(IntInfArray(ProcessNo).process .eq. 'decay') then
         call cddbdc(MovedTrack.p,  Pwork, Nproduced)
      else
         write(msg, *) ' in cintennb: process=',
     *           IntInfArray(ProcessNo).process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
c     ********************
      subroutine cinteSigma
c     *****************
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
c

      if(IntInfArray(ProcessNo).process .eq. 'decay') then
         call csigmaDecay(MovedTrack.p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack.p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
c     ********************
      subroutine cinteLambda
c     *****************
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
c

      if(IntInfArray(ProcessNo).process .eq. 'decay') then
         call clambdaDcy(MovedTrack.p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack.p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
c     ********************
      subroutine cinteGzai
c     *****************
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
c

      if(IntInfArray(ProcessNo).process .eq. 'decay') then
         call cgzaiDecay(MovedTrack.p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack.p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
c     ********************
      subroutine cinteBomega
c     *****************
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
c

      if(IntInfArray(ProcessNo).process .eq. 'decay') then
         call cbomegaDcy(MovedTrack.p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack.p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
c     *******************
      subroutine cinteEta
c     *****************
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
c

      if(IntInfArray(ProcessNo).process .eq. 'decay') then
         call cetaDecay(MovedTrack.p,  Pwork, Nproduced)
      else
         call chAcol(MovedTrack.p, TargetNucleonNo, TargetProtonNo,
     *     Pwork, Nproduced)
      endif
      end
c     ********************
      subroutine cinteLambdac
c     ********************not used yet.
      implicit none
      
#include  "Ztrack.h"
#include  "Ztrackv.h"
c
      character*80 msg

      if(IntInfArray(ProcessNo).process .eq. 'decay') then
         call clambdacDcy(MovedTrack.p,  Pwork, Nproduced)
      elseif(IntInfArray(ProcessNo).process .eq. 'coll') then   
         Nproduced = 0     ! neglect coll.
      else
         write(msg, *) ' in cinteLambdac: process=',
     *           IntInfArray(ProcessNo).process,
     *               ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif
      end
