c
c     read binary  or ascii  time histogram file and
c     analyse it
c     usage:  make -f procTime.mk
c     ./procTimePCLinuxIFC binOrascii filename        
c
c       where binOrascii is 1 for ascii input file
c                           2 for binary //
c             filenname  is path to the  input histogram file
c                       (<256 char) 
      implicit none
      integer binorascii
      integer count, status
      character*80  buf
c          get filename from command line argument
      count = NARGS()                                      
      if(count .ne. 4) then                                
         write(0,*)
     *  " must give  bin  mode  and filename as arguments"
         write(0,*) " bin=1--> ascii file"
         write(0,*) " bin=2--> binary file"
         write(0,*) " mode=1-->output fitted result. "
         write(0,*) " mode=2-->output raw result."
         write(0,*) " mode=3-->output both results."
         write(0,*) " filename: path to the input file"
         stop                                              
      endif                                                
      call getarg(1, buf, status)
      read(buf,*) binorascii
      if(binorascii .ne. 1 .and. binorascii.ne. 2) then
         write(0,*) ' error input to binOrascii=',binorascii
         stop
      endif

      if(binorascii .eq. 1) then
c             ascii file
         call procTimeAscii
      else
c             bin file
         call procTimeBin
      endif
      end

      subroutine procTimeBin
      implicit none
#include "ZprivateSub.f"
      include "../Hist/Z90histc.h"
      include "../Hist/Z90histo.h"
      include "../Hist/Z90hist1.h"
      character*80 buf

      type(histogram1) h10 ! 1D histogram area

      character*6 histid0  ! get histogram id  here
      integer icon
      real normf
      data normf/-1.0/     ! use normalization as already done
      integer ansites
      data ansites/1/   !  number of layers where histogram was taken
      integer fnoT/31/     ! file number.
      character*256 filename

      integer ir, ifai
      integer code
      integer nbinhisto, mode, status
      integer kwhistReadAscii
      integer i
  

      call getarg(2, buf, status)
      read(buf, *) mode
      call getarg(3, filename, status)                          
c      write(0,*) status, filename

      open(fnoT, file=filename,
     *         iostat=status, access='sequential',
     *         form='unformatted', action='read')
      if(status .ne. 0 ) then
         write(0,*) ' cannot open file ='
         write(0,*) filename
         stop
      endif
      
c        skip time data for core region
      do i = 1, ansites
         do code = 1, 4
            read( fnoT, end=100 ) histid0
            if( histid0 .ne. '#hist1' ) then
               write(0,*) ' histogram is not 1D: ',histid0
               stop
            endif
            call kwhistr(h10, fnoT, icon)

            call kwhists(h10, normf)
c              deallocate
            call kwhistd( h10 )
         enddo
      enddo
c          web sector region
      do i = 1, ansites
         do code = 1, 4
            do ifai= 1, nfai
               do ir= 1, nrbin
                  read( fnoT, end=100 ) histid0
                  if( histid0 .ne. '#hist1' ) then
                     write(0,*) ' histogram is not 1-D: ',histid0
                     stop
                  endif
                  call kwhistr(h10, fnoT, icon)
c                     statistical calculation
                  call kwhists(h10, normf)
c                     time analysis
                  call procTime(h10, mode,  ir, ifai, code, i)
c                        deallocate
                  call kwhistd( h10 )
               enddo
            enddo  
         enddo   
      enddo
      close(fnoT)
      return
 100  continue
      write(0,*) ' unexpected EOF ' 
      stop 2345
c     **********************
      entry  procTimeAscii
c     **********************

      call getarg(2, buf, status)
      read(buf, *)  mode
      call getarg(3, filename, status)                          
c      write(0,*) status, filename

      open(fnoT, file=filename,
     *     iostat=status, access='sequential',
     *     form='formatted', action='read')
      if(status .ne. 0 ) then
         write(0,*) ' cannot open file ='
         write(0,*) filename
         stop
      endif

c        skip time data for core region
      do i = 1, ansites
         do code = 1, 4
            nbinhisto=kwhistReadAscii(h10, fnoT)
            if(nbinhisto .le. 0 ) then
               write(0,*) ' ascii read  failed'
               stop
            endif
            call kwhists(h10, normf)
c              deallocate
            call kwhistd( h10 )
         enddo
      enddo

c          web sector region
      do i = 1, ansites
         do code = 1, 4
            do ifai= 1, nfai
               do ir= 1, nrbin
                  nbinhisto=kwhistReadAscii(h10, fnoT)
                  if(nbinhisto .le. 0 ) then
                     write(0,*) ' ascii read  failed'
                     stop
                  endif
c                     statistical calculation
                  call kwhists(h10, normf)
c                     time analysis
                  call procTime(h10,  mode, ir, ifai, code, i)
c                        deallocate
                  call kwhistd( h10 )
               enddo
            enddo  
         enddo   
      enddo
      close(fnoT)
      end
