c
c
c     Suppose that the  normalzied integral (from left) time distribution
c     in a given web sector is like below  
c  1.0   ----------------------------------------*---- 
c                                          *
c                                      *
c  frac                         <-- *
c                                 * |
c                               *   |
c                             *     |
c                           *       |
c                         *         |
c                       *           |
c                     *             |
c                   *             
c                 *            
c                *
c              *                    tf           
c 0-------- *------------------------------------------> t
c    
c      We get set of 'tf' for given set of 'frac' which are
c      e.g, 0.05 0.1, 0.2,... 0.9, 0.95  (see fig). 
c
c      real*8 frac(nfrac)
c      real*8 frac/0.05d0, 0.1d0, 0.2d0, 0.3d0, 0.4d0, 0.5d0, 0.6d0,
c     *                  0.7d0, 0.8d0, 0.9d0, 0.95d0/ 
c      real*8 tf(nfrac)  
c      ( nfrac=11 in this case. )
c
c      We get such tf's for every web sector and store
c      in an array tfary0; 
c      For a web sector with a given ir( lateral index) value 
c      we get first nfrac tf values. Then, we get similar one
c      for netx web sector at next it.  So we get nrbin 'tf'
c      falues for each 'frac'.  These are written to the
c      stdout with a header of "fai code layer" indexex.
c      The last data is indicated by "0 0  0" header indexes.
c
c      
c      
      subroutine procTime(h, mode, idxr, idxf, code, layer)
c         This treats one 1-D histogram with web index (idxr, idxf)
c         
      implicit none
#include "ZtimeAna.f"

      include '../Hist/Z90histc.h'
      include '../Hist/Z90histo.h'
      include '../Hist/Z90hist1.h'
      
      record /histogram1/h  ! input 1 D histogram
      integer mode  ! input. 1 is fitted result. 2 for no fitting result
                    !       3 for both results      
      integer idxr  ! web r bin index (1~nrbin=42)
      integer idxf  ! web fai bin index (1~nf) 
      integer code  ! ptcl code
      integer layer ! at which layer
      integer kwhistIxy
      integer maxsize  ! max histogram size
      integer n        ! actual histogram size
      
      integer i, j
      parameter (maxsize=2000)
      real*8 x(maxsize), y(maxsize)
      real*8 cgap
      integer icon
      integer idxr1, idxr2
      save

c       get (normalized) integral dist.
      n = kwhistIxy(h, x, y, maxsize)
      if(n .gt. maxsize) then
         write(0, *) ' too large histogram size=',n
         stop 1111
      endif
      if( idxr .eq. 1 ) then
         idxr1 = 0
         idxr2 = 0
      endif
c        smoothin parameter
      cgap = 0.1/(idxr/30.)**4
c          smoothing.( at least one trial is done.)
c          at large distances (idxr>30,  10 or more
c          trials) 
      
      call ksmooth(x, 1, y, 1,  n, 0, 500, cgap, icon)

      if(icon .gt. 0 ) then
         if(idxr1 .eq. 0) idxr1=idxr
         idxr2=idxr
c            get 'tf' values corresponding to 'frac'
         call procTimeGetTf(x, y, n, frac, tf, nfrac)
         do i = 1, nfrac
            tfary0(idxr,  i) = tf(i)
         enddo
      endif
      if(idxr .eq. nrbin) then
c           all data at given fai has been obtained.
c           data is between idxr1 to idxr2 for r
c           do fitting        and save the result in tfary 

         write(*,'(3i4)')  idxf, code, layer
         if(mode .eq. 1) then
            do i = idxr1, idxr2
               write(*,'(i3,1p11E11.3)') i, (tfary(i, j), j=1, nfrac)
            enddo
            write(*,
     *       '("0 0 0 0 0 0 0 0 0 0 0 0 ")')
         elseif(mode .eq. 2) then
            do i = idxr1, idxr2
               write(*,'(i3,  1p11E11.3)')
     *            i, (tfary0(i, j), j=1, nfrac)
            enddo
            write(*,
     *       '("0 0 0 0 0 0 0 0 0 0 0 0 ")')
         elseif(mode .eq. 3) then
            do i = idxr1, idxr2
               write(*,'(i3,1p22E11.3)')
     *          i, (tfary(i, j), j=1, nfrac),
     *           (tfary0(i,j), j=1, nfrac)
            enddo
            write(*,
     *       '("0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0")')
         endif
      endif
      end

      subroutine procTimeGetTf(x, y, n, frac, tf, nfrac)
      implicit none
      integer n
      real*8 x(n)
      real*8 y(n)
      integer nfrac
      real*8 frac(nfrac)
      real*8 tf(nfrac)

      real*8 error
      integer i
      integer np
      parameter (np = 3)  ! use np points for interpolation

      do i = 1,  nfrac
         call kpolintpFE(y, 1, x, 1, n,  np,
     *      frac(i),  tf(i), error)     

      enddo
      end
