c       make   binorasc  1 for ascii output (myhist1.hist)
c                        2 for binary //
c        use   call kwhists0(0)  for integral from -inf.
c           or call kwhists0(1)  fro integral from +inf.
c
      implicit none

      include 'Z90histc.h'
      include 'Z90histo.h'      
      include 'Z90hist1.h'
      integer binorasc/1/
      integer nav, nsig, npw
      parameter (nav=2, nsig=5, npw=3 )

      type(histogram1)  h(nav, nsig)
      type(histogram1)  k(npw)
      real*8 av, sig, pw
      save h
      real*8 x
      integer i, j, m, fno
      integer nc
      character*48 dirstr
      character*38 key
      real*8 xxx(500), yyy(500)
      external kwhistIxy
      integer  nnn, kwhistIxy

      fno= 3
      if(binorasc .eq. 1) then
         open(fno, file='mytest1.hist', form='formatted')
      else
         open(fno, file='mytest1.chist',
     *       form='unformatted')
      endif

      call kwhistso(binorasc)  ! bin/asc write.  this is common to all.

c       minimum calls
      pw = 0.8
      do i = 1, npw
         pw = pw + 0.2
c              init.
         call kwhisti(k(i), 1.5, 0.1, 30, b'01111' )
c              clear
         call kwhistc(k(i))
         do j= 1, 1000000
            call rndc(x)
            x = x**(-pw)
c               take histo
            call kwhist( k(i), sngl(x), 1.0 )
         enddo
      enddo
c             make arg 0 for integral from -inf. 
c                      1 for //            +inf.
      call kwhists0(0)
c        output 
      do i =1, npw
         call kwhists(k(i), 0.)
         call kwhistp(k(i), fno )
      enddo

c ++++++++++++++++++++++++++++++
c    some standard
c
      av=0.
      do i = 1, nav
         av = av + 2. 
         sig = 0.2 
         do j = 1, nsig
            sig = sig + 0.2
c             init.
            call kwhisti(h(i, j), sngl(av-7*sig), sngl(av+7*sig),  
     *       500,  b'10000')
c             clear
            call kwhistc(h(i, j))
            do m = 1, 1000000
               call kgauss(av, sig, x)
c                 take histo
               call kwhist(h(i,j), sngl(x), 1.0 )
            enddo
c             give additional info.
            call kwhistai(h(i,j), 
     *           "Test Gaussian dist.",
     *           "gauss", "event", .false., 0., 
     *           "x", "m") 
c             make key for diff. parameers
            write(key,'(1p2E11.3)' ) av, sig
c              inform it
            call kwhistid(h(i,j), key)
c              make directory: maindir/gauss/{av1,av2}
            write(dirstr,'("av",i2,"/")')  i
c                   next two is better to shrink the string length
c                   but only 3rd line can be  ok. (white blank will 
c                   be eliminated inside).
c            call kseblk(dirstr,"|", nc)
c            call kwhistdir(h(i,j), dirstr(1:nc))
            call kwhistdir(h(i,j), dirstr)
         enddo
      enddo
c         output.
      do i = 1, nav
         do j = 1, nsig
            call kwhists(h(i,j), 0.)
            call kwhistp(h(i,j), fno)
         enddo
      enddo
c            get (x,y) of integral dist.
      nnn=kwhistIxy(h(2,2), xxx, yyy, 500)
      write(0,*) ' nnn-', nnn
      do i = 1, nnn
         write(0,*) xxx(i), yyy(i)
      enddo
      end
