c       mu---> e + neue + neumu; inclusive treatment 
c     
      subroutine cmuNeuDcy(pj, polari, a, np)
      implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
      
      integer np     ! output.  no. of produced particles
      real*8 polari  ! input.   muon polarization
      record /ptcl/pj  ! input. muon
      record /ptcl/ a(*)  ! output.  produced ptcls
c
      real*8 po, f, ecm, cosa, lam
      integer  i, charge, subcode
      logical  try

      try = .true.
c
c           make 3 ptcls; neu_e, neu_mu, e
      subcode = -pj.charge
      call cmkptc(kneue, subcode, 0, a(1))
      subcode = pj.charge
      call cmkptc(kneumu, subcode, 0, a(2))
      charge = pj.charge
      call cmkptc(kelec, 0, charge,  a(3))
      if(pj.charge .eq. 1) then
c                for mu+, polarization should be made to inverse sign
c                because e+ goes same as mu+ polarizaion while
c                neue trino opposit.
         po=-polari
      else
         po=polari
      endif
      do while ( try )
c           sample energy in f=2e*/mmu: e* is at muon rest sytem
c           of neue
         call csampNeueEMu(f)
         ecm=f*pj.mass/2
c              sample decay angle of neue at muon rest system
c            (1+Pcos)dcos
         call ksampLin(po, 1.d0, -1.d0, 1.d0, cosa)
c              set random momentum about azimuth (px,py,pz)
         call cpCos2pxyz(cosa, ecm, a(1).fm)
         a(1).fm.p(4) = ecm
c                 since inclusive, no conservation tried
c          neumu; sample energy in f=2e*/mmu: e* is at muon rest sytem
         call csNeumuEMu(f)
         ecm=f*pj.mass/2
c              sample decay angle of neumu at muon rest system
c             (1+lambda P cos) dcos with
c             lambda = (1-2f)/(3-2f)
         lam=(1.-2*f)/(3.-2*f)
         call ksampLin(lam*po, 1.d0, -1.d0, 1.d0, cosa)
c             set px,py,pz
         call cpCos2pxyz(cosa, ecm, a(2).fm)
         a(2).fm.p(4) = ecm

c               electron ; paralell to neu_mu
c         x^2(3-2x + (1-2x)Pcos) dxdcos
c            first integrate by cos and get energy distribution
c         x^2(3-2x) dx: this is the same as  neu_e energy (x=2E/Mmu)
         call csNeumuEMu(f)
c         angluar distribution is
c        ( 1 + lam* cos ) dcos type
c
         lam = (1.-2*f)/(3.-2*f) *po
         call ksampLin(lam, 1.d0, -1.d0, 1.d0, cosa)
c             set px,py,pz
         call cpCos2pxyz(cosa, ecm, a(3).fm)
         a(3).fm.p(4) = ecm

c
         np = 3
c               boost to lab.
         do i = 1, np
            call cibstPol(i, pj, a(i), a(i) )
         enddo
c         since approximation here is to assume Me=0
c         we get Ee < Me sometimes (normally 5/10^5 or less )
c         so we reject such an event
         try =  a(3).fm.p(4) .le. a(3).mass
      enddo
      end
