c  ***********************************************************
c  *     open a sequential disk file.
c  *     This is intended to open a file that exists already
c  *     for formatted mode. If it doen not
c  *     exist or cannot be opened, return cond =1 
c  ***********************************************************
         subroutine copenf(io, fnin, icon)
c           io: integer. input.  Fortran logical device number
c           fnin: character(*). input. Disk file name to be openend.
c                     All %, # and @ treated as follows:
c                  
c                     @ is replaced by the hostname if PercentEnv is ' '
c                          If hostname contianes domainname, only hostname
c                          is extracted.   
c                     # is replaced by unix process number if SharpEnv is ' '.
c                     % is replaoced  by YYMMDDHHMMSS if PercentEnv is ' '
c                  
c                     In all cases above, if the corresponding variable
c                     (AtEnv etc is non blank (say, 'XYZ'),
c                     the envrionmental variable XYZ is assumed to exist
c                     and its value is used instead of hostname etc.
c
c         icon: integer. output. 0--> ok
c                                1--> cannot be opened.
         implicit none
#include "Zreadonly.h"

         character*(*) fnin
         logical opn, ex
         integer io, ios, icon, klena, fornamelist
         character*300 msg
         character*100 fn

         fornamelist = 0
         goto 10
c        ***************
         entry  copenNLf(io, fnin, icon)
c        ***************
         fornamelist = 1
 10      continue
         call cgetfname(fnin, fn)
c                  see if already opened.
             inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
             if(opn) then
                icon = 0
             elseif(ex) then
#if defined (PCLinux) || defined (PCLinuxIFC) || defined (MACOSX) || defined (PCLinuxIFC8) || defined (PCLinuxIFC64) || defined (MacIFC)
#define SPECIAL 1
#define DELIM ,delim='apostrophe'
#else
#define SPECIAL 0
#define DELIM 
#endif

#ifdef ACTION_READ
c                     for non-writable file action ='read'
c                      is needed.
                if(fornamelist .eq. SPECIAL) then
                   open(io, file=fn(1:klena(fn)), 
     *            iostat=ios, access='sequential',
     *            form='formatted', action='read' DELIM)
                else
                   open(io, file=fn(1:klena(fn)), 
     *                  iostat=ios, access='sequential',
     *                  form='formatted', action='read')
                endif
#else
                if(fornamelist .eq. SPECIAL) then
                   open(io, file=fn(1:klena(fn)), 
     *              iostat=ios, access='sequential',
     *              form='formatted' DELIM )
                else
                   open(io, file=fn(1:klena(fn)), 
     *                  iostat=ios, access='sequential',
     *                  form='formatted')
                endif
#endif
                 if(ios .eq. 0) then
                    icon = 0
                 else
                     write(msg, *)' file=',fn(1:klena(fn)),
     *               ' exists but cannot be opened'
                     call cerrorMsg(msg, 1)
                     write(msg,*) ' see copnef.f in Manager dir'
                     call cerrorMsg(msg, 1)
                     icon =1
                 endif    
             else
                 write(msg, *) ' file=', fn(1:klena(fn)),' not exist'
                 call cerrorMsg(msg, 1)
                 icon = 1
             endif    
         end
c  ***********************************************************
c  *     open a sequential disk file.
c  *     This is intended to open a file 
c  *     for formatted i/o mode. If it
c  *     cannot be opened, return cond =1 
c  ***********************************************************
         subroutine copenfw(io, fnin, icon)
c      
c           io: integer. input.  Fortran logical device number
c           fnin: character(*). input. Disk file name to be openend.
c         icon: integer. output. 0--> ok
c                                1--> cannot be opened.
         implicit none
#include "Zreadonly.h"

         character*(*) fnin
         logical opn, ex
         integer io, ios, icon, klena, fornamelist
         character*100 msg, fn

         fornamelist = 0
         goto 10

c        *******************
         entry copenNLfw(io, fnin, icon)
c        *******************
         fornamelist = 1
 10      continue

         call cgetfname(fnin, fn)
c                  see if already opened.
             inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
             if(opn) then
                icon = 0
             elseif(ex) then
                if(fornamelist .eq. SPECIAL) then
                   open(io, file=fn(1:klena(fn)), 
     *             iostat=ios, access='sequential',
     *             form='formatted' DELIM )
                else
                   open(io, file=fn(1:klena(fn)), 
     *               iostat=ios, access='sequential',
     *               form='formatted')
                endif

                 if(ios .eq. 0) then
                    icon = 0
                 else
                     write(msg, *)' file=',fn(1:klena(fn)),
     *               ' exists but cannot be opened'
                     call cerrorMsg(msg, 1)
                     write(msg,*) ' see copnef.f in Manager dir'
                     call cerrorMsg(msg, 1)
                     icon =1
                 endif    
             else
                if(fornamelist .eq. SPECIAL) then
                   open(io, file=fn(1:klena(fn)), 
     *              iostat=ios, access='sequential',
     *              form='formatted' DELIM )
                else
                   open(io, file=fn(1:klena(fn)), 
     *               iostat=ios, access='sequential',
     *               form='formatted')
                endif
                if(ios .eq. 0) then
                   icon = 0
                else
                   icon = 3
                endif
             endif    
         end
      subroutine cskiptoEOF(iodev)
      implicit none
      integer iodev

c          skip to the end of previous write
       do while(.true.)
          read(iodev, *, end=100)
       enddo
 100   continue
       end
c  ***********************************************************
c  *     open a sequential disk file.( upgraded verson of
c  *     copenfw:
c  *     This is intended to open a file
c  *     for formatted or unformatted i/o mode.
c  ***********************************************************
         subroutine copenfw2(io, fnin,  form, icon)
         implicit none
c
         integer  io ! input.  Fortran logical device number
         character*(*)  fnin !  input. Disk file name to be openend.
         integer  form !  input. if 1--> formatted file
                       !            2--> binary file
         integer  icon !. output. 0  file is newly created and  opened
                       !          1  file exists and  opened
                       !          2  file has been already opened
                       !          3  file cannot be opened.
         logical opn, ex
         integer  ios,  klena
         character*11 format
         character*128 fn

         if(form .eq. 1) then
            format='formatted'
         elseif(form .eq. 2) then
            format='unformatted'
         else
            call cerrorMsg(
     *      'form input to chookopenfw is  invalid',0)
         endif
         call cgetfname(fnin, fn)  !  replace @ # etc to hostname etc
c                  see if already opened.
         inquire(file=fn(1:klena(fn)), opened=opn, exist=ex)
         if(opn) then
            icon = 2
         elseif(ex) then
            open(io, file=fn(1:klena(fn)),
     *           iostat=ios, access='sequential',
     *           form=format)
            if(ios .eq. 0) then
               icon = 1
            else
               call cerrorMsg(fn, 1)
               call cerrorMsg(
     *         'exists but cannot be opened', 1) 
               icon =3
            endif
         else
            open(io, file=fn(1:klena(fn)),
     *           iostat=ios, access='sequential',
     *           form=format, status='new' )
            if(ios .eq. 0) then
               icon = 0
            else
               icon = 3
            endif
         endif
         end
c           upgraded version of cskiptoEOF
      subroutine cskiptoEOF2(iodev, form)
      implicit none
      integer iodev  ! input  dev. no
      integer form   ! input  1--> ascii file
                     !        2--> binary file

c          skip to the end of previous write
       do while(.true.)
          if(form .eq. 1) then
             read(iodev, *, end=100)
          elseif(form .eq. 2) then
             read(iodev, end=100)
          endif
       enddo
 100      continue
       end

      subroutine cgetfname(fnin,  fn)
      implicit none

      character*(*) fnin  ! input. for  %,  #,  @.
                          !  see the top of file. 

      character*(*) fn    ! output. 


      integer j

      fn = ' '
      fn = fnin

      j = index (fn, '%') 
      do while ( j .gt. 0 )
         call creplst( fn, j,  '%')
         j = index (fn, '%') 
      enddo   

      j = index (fn, '#') 
      do while ( j .gt. 0 )
         call creplst( fn, j, '#')
         j = index (fn, '#') 
      enddo   

      j = index (fn, '@') 
      do while ( j .gt. 0 )
         call creplst( fn, j, '@')
         j = index (fn, '@') 
      enddo   

      end
      subroutine creplst( fn, j, ch )
      implicit none
#include  "Zmanagerp.h"

      character*(*) fn   ! input.  must be < 256
                         ! output
      integer       j    ! input.  j-th chr pos. has %, # or @ 

      character*1   ch   ! input. one of %, #, @. 

      integer  klena, leng, kgetpid, dummy, kgetenv2, kgetnow
 
      character*64 replst   ! to contain hostname, etc to replace %, # of or @


      if( ch  .eq. '@'  ) then
         if(AtEnv .ne. ' ' ) then
            leng = kgetenv2(AtEnv, replst)
            if(leng .eq. 0) then
               call cerrorMsg(
     *         'Environmental variable specified by AtEnv=', 1)
               call cerrorMsg(AtEnv, 1)
               call cerrorMsg(' Not exist ', 0)
            endif
         else   
            call cgetHost(leng, replst)
         endif
      endif
      if(  ch  .eq.  '#' )  then
         if(SharpEnv .ne. ' ' ) then
            leng = kgetenv2(SharpEnv, replst)
            if(leng .eq. 0) then 
               call cerrorMsg(
     *         'Environmental variable specified by SharpEnv=', 1)
               call cerrorMsg(SharpEnv, 1)
               call cerrorMsg(' Not exist ', 0)
            endif
         else
            replst = ' '
            write(replst, '(i10)') kgetpid(dummy)
            call kseblk(replst, '{', leng)
         endif
      endif

      if( ch  .eq. '%' ) then
         if(PercentEnv .ne. ' ' ) then
            leng = kgetenv2(PercentEnv, replst)
            if(leng .eq. 0) then 
               call cerrorMsg(
     *         'Environmental variable specified by PercentEnv=', 1)
               call cerrorMsg(PercentEnv, 1)
               call cerrorMsg(' Not exist ', 0)
            endif
         else
            replst = ' '
            leng =  kgetnow(replst)  ! get YYMMDDHHMMSS
            leng =  klena(replst)
         endif
      endif
      if( j .eq. 1 ) then
         fn = replst(1:leng)//fn(j+1:klena(fn))
      else
         fn =
     *   fn(1:j-1)//replst(1:leng)//fn(j+1:klena(fn))
      endif

      end
c      **************
      subroutine cgetHost(leng, hostn)
      integer  leng       ! output
      character*(*) hostn ! output

      character*1 NULL
      integer  kgetenv, j

      NULL = char(0)
      leng = kgetenv("HOSTNAME"//NULL, hostn)
      if(leng .eq. 0) then
         leng = kgetenv("HOST"//NULL, hostn)
         if(leng .eq. 0) then
            call
     *      cerrorMsg('Env. var. HOST or HOSTNAME not found',0)
         endif
      endif

      j =index(hostn, '.') 

      if(j .gt. 0) then
         leng = j-1
         hostn = hostn(1:leng)
      endif
      end
