c    Programs contained in this file  manage the atmosphere in 
c   the vertical direction.
c   stdatmos2.d is used to describe the atmosphere. > 11km
c    
c      cstdatmos0:  to read data for the atmospeher
c      cvh2den   :  vertical height to denstiy
c      cvh2thick :  vertical height to thickness of air
c      cvthick2h :  vertical thicknes to height.
c      cvh2denp  :  d rho/ dz
c      cvh2den2p  :  d (d rho/ dz)/dz
c

c    They follow the folloing formulas.
c
c          rho = rho0 * (1+ a(z-z0)/H(z0))**(-1-1/a)          (a != 0)
c              = rho0 * exp(- (z-z0)/H)           (a =0; hence H is const)

c
c   The gramage between  given heights, z1 and z2  is by
c
c              d = d0 *(fd(z1) - fd(z2))  where
c         
c            fd(z) = (1+ a(z-z0)/H(z0))**(-1/a)                   (a != 0)
c
c                  =  exp(-(z-z0)/H )                             (a = 0)
c
c   where  d0 = rho0*H(z0)
c
c   Other formula is used  at < 11 km. I.e.,
c
c         rho = rho00*( (ha - z)/hl )** pw
c
c
      

c    
      subroutine cstdatmos0
      implicit none
#include  "Zmanager.h"
#include  "Zearth.h"
#include  "Zstdatmos.h"

      integer icon,  ios, i
      external blkstdatmos
c----      include 'Zstdatmosf.h'     !  rho=rho(h) function
#include  "Zstdatmosf.h"

      if(first) then
         call copenf(TempDev, "stdatmos2.d", icon)
         if(icon .ne. 0) stop 9999
         call cskipComment(TempDev, icon)
         if(icon .ne. 0) stop 9999

         nodes = 0
         do while( .true. )
            read(TempDev, *, iostat=ios)
     *           znode(nodes+1), tnode(nodes+1), pnode(nodes+1), 
     *           rho(nodes+1),  alfa(nodes+1), d0(nodes+1),
     *           dsum(nodes+1),  scaleh(nodes+1)
            if(ios .ne. 0) goto 10
            if(nodes .ge. maxnodes) then
               write(*,*) 'numbr of nodes for atmosphere > ', maxnodes
               stop 9999
            endif
            nodes = nodes + 1
c           write(0,*) znode(nodes), alfa(nodes)
         enddo
 10      continue
c        write(*, *) " # of nodal points =", nodes

         do i=2, nodes
            if(alfa(i-1) .ne. 0.) then
               fd1i(i) = fd1(znode(i), alfa(i-1), znode(i-1), 
     *                   scaleh(i-1))
               rhop(i) =  rho(i-1) *(-1.d0 -1.d0/alfa(i-1)) *
     *              alfa(i-1)/scaleh(i-1) 
               pwp(i) =-2.d0-1.d0/alfa(i-1)
            else
               fd0i(i) = fd0(znode(i), znode(i-1), scaleh(i-1) )
            endif
         enddo
         fd3 = ((ha-znode(2))/hl)**(pw+1.d0)
         first = .false.
      endif
      end
c     *************************    to be updated 
      block data blkstdatmos
c     *************************
       implicit none
c----       include 'Zearth.h'
#include  "Zearth.h"
c----       include 'Zstdatmos.h'
#include  "Zstdatmos.h"
       data first/.true./
       data ha/45.3425d3/, hl/11.865d3/,
     *     pw /4.36815d0/, rho00/3.50618d-3/
      end
c     *********************************   
      real*8 function  cvh2den(z)
c     *********************************   
c         gives density of air at a given vertical height.
c      h: vertical height in m
c      function value:  density in kg/m3.
c
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"
c----      include 'Zstdatmos.h'
#include  "Zstdatmos.h"
c
      integer i

      real*8 z

      if(first) call cstdatmos0

c          check if z < 11.2km
      if(z .lt. znode(2)) then
         cvh2den = rho00 * ( (ha - z)/hl )**pw
      else
         do i = 3, nodes
            if(z .lt. znode(i) .or. i .eq. nodes ) then
               if(alfa(i-1) .ne. 0.)then
                  if(z .lt. znode(i-1) ) then
                     write(0,*) ' z=',z, ' znode =', znode(i-1)
                  endif
                  cvh2den = 
     *             rho(i-1) * 
     *             (1.d0 + alfa(i-1)* 
     *             (z-znode(i-1))/scaleh(i-1) )**(-1.0-1.d0/alfa(i-1)) 
                   goto 10
               else
                  cvh2den =
     *            rho(i-1) * exp(- (z-znode(i-1))/scaleh(i-1))         
                  goto 10
               endif
            endif
         enddo
 10      continue
      endif
      end
c     *************************
      real*8 function cvh2thick(z)
c         vertical height to thickness of air above that point.
c      z:  input. vertical height in m
c  function value. output.  thickness in kg/m2.
c
c
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"
c----      include 'Zstdatmos.h'
#include  "Zstdatmos.h"
c
      integer i

      real*8 z

c----      include 'Zstdatmosf.h'
#include  "Zstdatmosf.h"


      if(first) call cstdatmos0

c          check if z < 11.2km
      if(z .lt. znode(2)) then
           cvh2thick =hl* rho00 /(pw+1.d0)* (
     *         ( (ha-z)/hl)**(pw+1.d0) -
     *         fd3 )
     *      +  dsum(2)
c              where fd3 is
c     *           ((ha-znode(2))/hl)**(pw+1.d0) )
      else
c          The gramage between  given heights, z1 and z2  is by
c
c              d = d0 *(fd(z1) - fd(z2))  where
c         
c            fd(z) = (1+ a(z-z0)/H(z0))**(-1/a)                   (a != 0)
c
c                  =  exp(-(z-z0)/H )                             (a = 0)
         do i = 3, nodes-1
            if(z .lt. znode(i) .or. i .eq. nodes-1 ) then
               if(alfa(i-1) .ne. 0.)then
                   cvh2thick =  d0(i-1) * (
     *              fd1( z, alfa(i-1), znode(i-1), scaleh(i-1) )
     *              - fd1i(i)
     *             )   + dsum(i) 

c                      where fd1i(i) is
c     *              fd1(znode(i), alfa(i-1),
c     *              znode(i-1), scaleh(i-1) )

                   goto 10
               else
                  cvh2thick = d0(i-1) * (
     *             fd0(z, znode(i-1), scaleh(i-1) )
     *             - fd0i(i)               
     *             ) + dsum(i)
c                      where fd0i is
c     *            fd0(znode(i), znode(i-1), scaleh(i-1) )
c     *            )
                  goto 10
               endif
            endif
         enddo
 10      continue
      endif
      end
c     *************************
      real*8 function cvthick2h(t)
c         vertical thickness to vertical height conversion
c     t:  input. vertical tikness in kg/m2
c  function value. output.  height in m.
c
c
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"
c----      include 'Zstdatmos.h'
#include  "Zstdatmos.h"
c
      integer i

      real*8  t,  temp


      if(first) call cstdatmos0

c          check if z < 11.2km
      if(t .gt. dsum(2)) then
c           t =hl* rho00 /(pw+1.d0)* (
c     *         ( (ha-z)/hl)**(pw+1.d0) -
c     *           ((ha-znode(2))/hl)**(pw+1.d0) )
c     *      +  dsum(2)
c           solve above eq.
            temp =( t - dsum(2))/hl/rho00 * (pw+1.d0)
     *          +  fd3
            cvthick2h =ha -  hl* temp**(1.d0/(pw+1.d0))
      else
c          The gramage between  given heights, z1 and z2  is by
c
c              d = d0 *(fd(z1) - fd(z2))  where
c         
c            fd(z) = (1+ a(z-z0)/H(z0))**(-1/a)                   (a != 0)
c
c                  =  exp(-(z-z0)/H )                             (a = 0)
         do i = 3, nodes-1
            if(t .gt. dsum(i) .or. i .eq. nodes-1 ) then
               if(alfa(i-1) .ne. 0.)then
c                   cvh2thick =  d0(i-1) * (
c     *              fd1( z, alfa(i-1), znode(i-1), scaleh(i-1) )
c     *             -  fd1(znode(i), alfa(i-1),
c     *              znode(i-1), scaleh(i-1) )
c     *             )   + dsum(i) 
c                    solve above eq.
                   temp =( t -dsum(i))/d0(i-1)
     *              +  fd1i(i)
                   cvthick2h = (temp**(-alfa(i-1)) -1.d0)*
     *               scaleh(i-1)/alfa(i-1) + znode(i-1)
                   goto 10
               else
c                  cvh2thick = d0(i-1) * (
c     *             fd0(z, znode(i-1), scaleh(i-1) )
c     *            -fd0(znode(i), znode(i-1), scaleh(i-1) )
c     *            )  + dsum(i)
c                    solve above eq.
                   temp = (t -dsum(i)) /d0(i-1) +
     *             + fd0i(i)
c                   temp =  exp(-(z-z0)/H )    
                   cvthick2h =znode(i-1)- log(temp)*scaleh(i-1)
                  goto 10
               endif
            endif
         enddo
 10      continue
      endif
      end
c     *********************************   
      real*8 function  cvh2denp(z)
c     *********************************   
c         gives derivative of the density of
c     air at a given vertical height.
c      h: vertical height in m
c      function value: drho/dz density in kg/m4
c
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"
c----      include 'Zstdatmos.h'
#include  "Zstdatmos.h"
c
      integer i

      real*8 z

      if(first) call cstdatmos0

c          check if z < 11.2km
      if(z .lt. znode(2)) then
         cvh2denp =- rho00 * pw/hl* ( (ha - z)/hl )**(pw-1.d0)
      else
         do i = 3, nodes
            if(z .lt. znode(i) .or. i .eq. nodes ) then
               if(alfa(i-1) .ne. 0.)then
                  cvh2denp = 
c       *             rho(i-1) *(-1.d0 -1.d0/alfa(i-1)) *
c       *             alfa(i-1)/scaleh(i-1) *     = rhop(i)
     *               rhop(i) *
     *             (1.d0 + alfa(i-1)* 
c     *             (z-znode(i-1))/scaleh(i-1) )**(-2.d0-1.d0/alfa(i-1)) 
     *             (z-znode(i-1))/scaleh(i-1) )**pwp(i)
                   goto 10
               else
                  cvh2denp =
     *            -rho(i-1) * exp(- (z-znode(i-1))/scaleh(i-1))         
     *            /scaleh(i-1)
                  goto 10
               endif
            endif
         enddo
 10      continue
      endif
      end
c     *********************************   
      real*8 function  cvh2den2p(z)
c     *********************************   
c         gives double derivative of the density of
c     air at a given vertical height.
c      h: vertical height in m
c      function value: d (drho/dz)/dz density in kg/m5
c
      implicit none
c----      include 'Zearth.h'
#include  "Zearth.h"
c----      include 'Zstdatmos.h'
#include  "Zstdatmos.h"
c
      integer i

      real*8 z

      if(first) call cstdatmos0

c          check if z < 11.2km
      if(z .lt. znode(2)) then
         cvh2den2p = rho00 * pw*(pw-1.d0)/hl/hl
     *          * ( (ha - z)/hl )**(pw-2.d0)
      else
         do i = 3, nodes
            if(z .lt. znode(i) .or. i .eq. nodes ) then
               if(alfa(i-1) .ne. 0.)then
                  cvh2den2p = 
     *               rhop(i) * pwp(i) *alfa(i-1)/scaleh(i-1)*
     *             (1.d0 + alfa(i-1)* 
     *             (z-znode(i-1))/scaleh(i-1) )**(pwp(i)-1.d0)
                   goto 10
               else
                  cvh2den2p =
     *            rho(i-1) * exp(- (z-znode(i-1))/scaleh(i-1))         
     *            /scaleh(i-1)**2
                  goto 10
               endif
            endif
         enddo
 10      continue
      endif
      end

