      subroutine xBgRun
      implicit none
#include  "Zmaxdef.h"
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zcode.h"
#include "Zheavyp.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include  "Zstackv.h"
      include "Zprivate.f"
      include "Zprivate2.f"



            
      save rspec, lossrspec, arspec, respec
      save rzspec,  zfspec, rtspec1, rtspec2, retspec1, retspec2
      save rezspec,  rzfspec, rfspec, efspec, refspec

      integer id  ! input.  1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack

      record /track/ inci
      record /coord/ angle
      record /coord/ tetafai
      
      character*128 input
      character*64 dirstr
      real sr, dr, tempr
      integer i, j, k, icon
      integer ansites
      save ansites
      integer iij, code
      integer i1, i2, ic

      real*8 r, Eloss, rinmu, cosang
      real*8 dedt, rho, dist, disto
      real*8 aa
      real*8 wx, wy, wz, temp
      real   za
      real  de, Ek, f, molu
      real*8  cvh2den
      integer ldep
c     integer ndummy
      integer binw
      character*9 ptcl(3)
      data ptcl/"Photons", "Electrons","Muons"/
      character*9 ptcl2(3)
      data ptcl2/"Electrons", "Muons","All"/
      real power(3)
      integer nstr
      data power/2.,2.,1./
      real  power2(3)
      data power2/2.,1.,2./
      character*128 title
      character*96 evid(nsites)
      save evid
      real*8 cog, cog2, sumne,  obstimes, Savederg(5)
      real*8 depth, dd
      logical dosort
      character*2  kd(3)
      save obstimes,  depth

c       keep this interface so that the difference between
c       the one in ForTA/  and in FleshHist is in the next line
c      1 for ForTA and 2 for FleshHist
c     ***********************
      include "interface1.f"
c     *********************
      do i = 1, nsites
         if(histdep(i) .gt. 0)  then
            ansites = i
         endif
      enddo

      call kwhistso( binw )  ! specify binary or ascii write of histogaram
                             !  1--> ascii  2--> binary

      r=rmin
      dr = 10.**bin 
      rbin(1) = 0.
      do i = 2, nrbin
         rbin(i) = r
         r = r* dr
      enddo

      return      
c    ******************
      entry ihist
c
c

c     histogram: instanciate
c         rspec (lateral):  
      if(tklat) then
         do i = 1, ansites
            do j = 1, 3         ! g,e,mu
               call kwhisti(rspec(j, i),
     *              rmin, bin, nrbin,  b'00011' )
               call kwhistai(rspec(j,i), 
     *         "Lateral Dist. of "//ptcl(j),
     *         "lat", "ptcls", .true., power(j), "r", "m.u")
            enddo
         enddo
      endif


c        elosrspec (energy loss lateral)  10m-10km log bin 0.1. e+mu, e,mu
c          
c       
      if(tkelosslat) then
         do i = 1, ansites
            do j = 1, 3         !   e, mu, e+mu
               call kwhisti( lossrspec(j, i),
     *          rmin, bin, nrbin, b'00011')
               call kwhistai(lossrspec(j, i), 
     *         "dE/dx lateral dist. of "//ptcl2(j),
     *         "dEdxLat", "GeV/(g/cm^2)", .true., power2(j),
     *         "r", "m.u")
            enddo
         enddo   
      endif


      if(tkarspec) then
         do i = 1, ansites
            do j = 1, 3           ! g,e,mu
               call kwhisti2(arspec(j, i),
     *              0.,  45.0, 8,     b'00010',
     *              rmin, bin, nrbin,  b'00011' )
cc             call kwhiststep2(arspec(j, i), 2)
               call kwhistai2(arspec(j,i), 
     *         "Lateral Dist. of "//ptcl(j)//" at  diff. azimuth",
     *         "ar", "ptcls", .true.,  power(j), 
     *         "azimuth", "deg", "r", "m.u")
            enddo
         enddo
      endif
         

c
      if(tkrespec) then
         do i = 1, ansites
            do j= 1, 2
               call kwhisti2( respec(j, i),
     *             0.01, 0.2, 20,    b'00011', 
     *             500.e-6, 0.1,    50,    b'00001')
               call kwhiststep2(respec(j, i), 2)
               call kwhistai2( respec(j, i),
     *         "Energy Spec. of "//ptcl(j)//" at  diff. r",
     *         "re", "ptcls", .true.,  1., 
     *         "r", "m.u", "E", "GeV")
            enddo
c                 mu            
            call kwhisti2( respec(3, i),
     *            0.01, 0.2, 20       , b'00011', 
     *            0.031627,  0.1,  38, b'00011' )
            call kwhiststep2(respec(3, i), 2)
            call kwhistai2( respec(3, i),
     *      "Energy Spec. of mu at diff. r",
     *      "re", "ptcls", .true.,  0.,
     *      "r",  "m.u", "E", "GeV")
         enddo
      endif


      if(tkrzspec) then
         do i = 1, ansites
            do j= 1, 2
               call kwhisti2( rzspec(j, i),
     *           0.01,   0.2,  20,  b'00011', 
     *           0.,     1.0,     20,  b'10000')
               call kwhiststep2(rzspec(j, i), 2)
               call kwhistai2( rzspec(j, i),
     *         "Zenith angle dist. of "//ptcl(j)//" at diff. r",
     *         "rz", "ptcls", .true., 0.,
     *         "r", "m.u", "cosz", " ")
            enddo
            call kwhisti2(rzspec(3, i),
     *           0.01, 0.2, 20, b'00011', 
     *           0.,  1.0,   20, b'10000' )  
           call kwhiststep2(rzspec(3, i), 2)
            call kwhistai2( rzspec(3, i),
     *         "Zenith angle dist. of m  with diff. r",
     *         "rz", "ptcls", .true., 0.,
     *         "r", "m.u", "cosz", " ")
         enddo
      endif         


      if(tkzfspec) then
         do i = 1, ansites
            do j= 1, 3
               call kwhisti2( zfspec(j, i),
     *              0.0,  1.0, 10,  b'10000', 
     *              -1.0, 1.0, 50,  b'10000')
               call kwhiststep2(zfspec(j, i), 2)
               call kwhistai2( zfspec(j, i),
     *         "f=(wx,wy)*(x,y) spectrum of "//ptcl(j)//
     *         " with diff. cosz", 
     *         "zf", "ptcls", .true., 0.,
     *         "cosz", " ", "f", " ")
            enddo
         enddo
      endif         


      if(tkrfspec) then
         do i = 1, ansites
            do j= 1, 3
               call kwhisti2( rfspec(j, i),
     *                0.01,  0.2, 20,  b'00011', 
     *               -1.0,  1.0, 50,   b'10000')
               call kwhiststep2(rfspec(j, i), 2)
               call kwhistai2( rfspec(j, i),
     *         "f spectrum of "//ptcl(j)//" with diff. r",
     *         "rf", "ptcls", .true., 0.,
     *          "r", "m.u", "f", " ")
            enddo
         enddo
      endif         


      if(tkefspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhisti2( efspec(j, i),
     *              500.e-6,  0.2, 20,  b'00001', 
     *              -1.0,     1.0, 50,  b'10000')
               call kwhiststep2(efspec(j, i), 2)
               call kwhistai2( efspec(j, i),
     *         "f spectrum of "//ptcl(j)//" with diff. E",
     *         "ef", "ptcls",.true., 0.,
     *         "E", "GeV", "f", " ")
            enddo
         enddo
      endif         

      if(tkrtspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhisti2( rtspec1(j, i),
     *              1.0, 0.2,  10,   b'00011', 
     *              10.,  0.1, 55, b'00011'  )
               call kwhiststep2(rtspec1(j, i), 2)
               call kwhistai2( rtspec1(j, i),
     *         "Arrival time dist. of "//ptcl(j)//" at diff. r",
     *         "rt", "ptcls", .true., 0.,
     *         "r", "m.u", "time", "ns")

               call kwhisti2( rtspec2(j, i),
     *             0.,  1.0, 10,  b'10000', 
     *             0., 0.25, 300, b'00000' )
               call kwhiststep2(rtspec2(j, i), 2)
               call kwhistai2( rtspec2(j, i),
     *         "Arrival time dist. of "//ptcl(j)//" at diff. r",
     *         "rt", "ptcls", .true., 0.,
     *         "r", "m.u", "time", "ns")
            enddo
         enddo
      endif

      if(tkretspec)  then
         do i = 1, ansites
            do j = 1, 2
c                  g,e
               call kwhisti3(retspec1(j, i), 
     *          1.0,     0.2,  10,    b'00011',
     *          500.e-6, 0.25, 15,    b'01001',
     *          10.0, 0.1,  55,      b'00011' )
               call kwhiststep3(retspec1(j, i), 2, 2)
               call kwhistai3(retspec1(j, i), 
     *         "Arrival time dist. of "//ptcl(j)//" with diff. r&E",
     *         "ret", "ptcls", .true., 0.,
     *         "r", "m.u", "E", "GeV", "Time", "ns")

               call kwhisti3(retspec2(j, i), 
     *          0.0,  1.0,     10,   b'10000',
     *          500.e-6, 0.25, 12,  b'01001',
     *          0.0,  0.25,   200,  b'00000' )
               call kwhiststep3(retspec2(j, i), 2,2)
               call kwhistai3(retspec2(j, i), 
     *         "Arrival time dist. of "//ptcl(j)//" with diff. r&E",
     *         "ret2", "ptcls", .true., 0.,
     *         "r", "m.u", "E", "GeV", "Time", "ns")
            enddo
c               mu
            call kwhisti3(retspec1(3, i), 
     *           1.0,   0.2,    10,       b'00011',
     *           100.e-3, 0.25, 10,       b'01011',
     *           10.0,    0.1,  72,       b'00011' )
            call kwhiststep3(retspec1(3, i),  2, 2)
            call kwhistai3(retspec1(3, i), 
     *         "Arrival time dist. of "//ptcl(3)//" with diff. r&E",
     *         "ret", "ptcls", .true., 0.,
     *         "r", "m.u", "E", "GeV", "Time", "ns")


            call kwhisti3(retspec2(3, i), 
     *           0.0,  1.0,  10,    b'10000',
     *           100.e-3,    0.25, 10,   b'01011',
     *           0.0,  0.25,    200,     b'00000' )
            call kwhiststep3(retspec2(3, i), 2,2)
            call kwhistai3(retspec2(3, i), 
     *         "Arrival time dist. of "//ptcl(3)//" with diff. r&E",
     *         "ret2", "ptcls", .true., 0.,
     *         "r", "m.u", "E", "GeV", "Time", "ns")
         enddo
      endif


      if(tkrezspec) then
         do i = 1, ansites
            do j = 1, 2
               call kwhisti3( rezspec(j, i), 
     *         0.1,   0.2,  15,     b'00011',
     *         500.e-6, 0.25, 14,   b'01001', 
     *         0.0, 1.0,   20,    b'10000')
               call kwhiststep3(rezspec(j, i), 3,2)
               call kwhistai3(rezspec(j, i), 
     *         "cos zenith dist. of "//ptcl(j)//" with diff. r&E",
     *         "rez", "ptcls", .true., 0.,
     *         "r", "m.u", "E", "GeV", "cosz", " ") 
            enddo
            call kwhisti3(rezspec(3, i), 
     *         0.1,  0.2,   15,   b'00011',
     *         100.e-3, 0.25, 10, b'01011', 
     *         0.0, 1.0,     20,   b'10000')
            call kwhiststep3(rezspec(3, i), 3,2)
            call kwhistai3(rezspec(3, i), 
     *         "cos zenith dist. of "//ptcl(3)//" with diff. r&E",
     *         "rez", "ptcls", .true., 0.,
     *         "r", "m.u", "E", "GeV", "cosz", " ") 
         enddo
      endif



      if(tkrzfspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhisti3(rzfspec(j, i), 
     *         0.1, 0.2,        15,   b'00011',
     *         0.0, 1.0,        10,   b'10000',  
     *         -1.0, 1.0,       20,   b'10000')
               call kwhiststep3(rzfspec(j, i), 3,2)
               call kwhistai3(rzfspec(j, i), 
     *         "f spectrum of "//ptcl(j)//" with diff r&cosz",
     *         "rzf", "ptcls", .true., 0.,
     *         "r", "m.u", "cosz", " ", "f", " ")
            enddo
         enddo
      endif

      if(tkrefspec) then
         do i = 1, ansites
            do j = 1, 2
               call kwhisti3( refspec(j, i), 
     *         0.1,  0.2,      15,   b'00011',
     *         500.e-6, 0.25,  16,    b'01001',  
     *         -1.0, 1.0,     20,   b'10000')
               call kwhiststep3(refspec(j, i), 3,3)
               call kwhistai3(refspec(j, i),
     *         "f spectrum of "//ptcl(j)//" with diff. r&E",
     *         "ref", "ptcls", .true., 0.,
     *         "r", "m.u", "E", "GeV", "f", " ")
            enddo
            call kwhisti3(refspec(3, i), 
     *       0.1, 0.2,      15,    b'00011',
     *       100.e-3,  0.25, 10,    b'01001',  
     *        -1.0, 1.0,     20,   b'10000')
            call kwhiststep3(refspec(3, i), 3,2)
            call kwhistai3(refspec(3, i),
     *         "f spectrum of "//ptcl(3)//" with diff. r&E",
     *         "ref", "ptcls", .true., 0.,
     *         "r", "m.u", "E", "GeV", "f", " ")
         enddo
      endif

      return
c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      entry xBgEvent
      call cqIncident(inci, angle)

       write(*,'("i ",  i3,  i4, g13.4,3f11.7,f7.1)')
     *    EventNo, inci.p.code,
     *   inci.p.fm.e,  -angle.r(1),  -angle.r(2), -angle.r(3)



      do i = 1, NoOfASSites
         SumEloss(i) = 0.
         Ng(i) = 0.
         Ne(i) = 0.
         Nmu(i) = 0.
         Nhad(i) = 0.
      enddo

      if(tklat) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc(rspec(j,i))
            enddo
         enddo
      endif

      if(tkelosslat) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc(lossrspec(j,i))
            enddo
         enddo
      endif


      if(tkarspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(arspec(j,i))
            enddo
         enddo
      endif

      if(tkrespec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(respec(j,i))
            enddo
         enddo
      endif


      if(tkrzspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(rzspec(j,i))
            enddo
         enddo
      endif

      if(tkrfspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(rfspec(j,i))
            enddo
         enddo
      endif



      if(tkefspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(efspec(j,i))
            enddo
         enddo
      endif




      if(tkrtspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(rtspec1(j,i))
               call kwhistc2(rtspec2(j,i))
            enddo
         enddo
      endif

         
      if(tkretspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc3(retspec1(j,i))
               call kwhistc3(retspec2(j,i))
            enddo
         enddo
      endif



      if(tkrezspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc3(rezspec(j,i))
            enddo
         enddo
      endif



      if(tkrzfspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc3(rzfspec(j,i))
            enddo
         enddo
      endif


      if(tkrefspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc3(refspec(j,i))
            enddo
         enddo
      endif

      obstimes = 0.

      return
c     ***************
      entry xObs(aTrack, id)
c
c     For id =2, you need not output the z value, because it is always
c     0 (within the computational accuracy).
c
c     **************************


      obstimes = obstimes + 1.d0
      if(mod(obstimes, 100000.d0) .eq. 0. ) then 
         dosort=.false.
         do i = 1, min(4,Stack_pos)
            if(Stack(i).p.fm.p(4) .ne. Savederg(i)) then
               Savederg(i)=Stack(i).p.fm.p(4) 
               dosort=.true.
            endif
         enddo
         if(dosort) then
            call csortStack
         endif
         write(0, *) ' obstimes=', obstimes, ' ptclE=',aTrack.p.fm.p(4)
         do i = 1, min(4,Stack_pos)
            write(0,*)' stack tops=', Stack(i).p.fm.p(4)
         enddo
      endif
c     ***************
      code = aTrack.p.code

      if(id .eq. 2 .and. code .ne. 7 .and.  code .ne. 8 ) then
         wz = aTrack.vec.w.r(3)  ! downgoing < 0
         if(wz .gt. 0) return
         wz = -wz
         ldep =  aTrack.where
         r = sqrt( aTrack.pos.xyz.x**2 +
     *                 aTrack.pos.xyz.y**2 )

         Ek = aTrack.p.fm.p(4) -aTrack.p.mass

         if(code .eq. kphoton) then
            Ng(ldep) = Ng(ldep) + aTrack.wgt
         elseif(code .eq. kelec) then
            Ne(ldep) = Ne(ldep) + aTrack.wgt
         elseif(code .eq. kmuon) then
            Nmu(ldep) = Nmu(ldep) + aTrack.wgt
         elseif(code .le. 6) then
            Nhad(ldep) = Nhad(ldep) +aTrack.wgt
         endif
c/////////////////
c         if(aTrack.where .eq. 25 .and. 
c     *      aTrack.p.code .eq. 1) then
c            write(*,*) sngl(aTrack.wgt), sngl(aTrack.p.fm.p(4))
c         endif
c/////////////////
         do i = 1, ansites
            j = indivdep(i) 
            if( j .eq. ldep) then
               molu =ObsSites(j).mu
               rinmu =r/molu
               sr = rinmu

               if(  recxy ) then
                  write(*,'("p ", 4i4, 1pE11.3, 3E11.3, 0p3f10.6 )')
     *                 ldep,  code,  aTrack.p.subcode,
     *                 aTrack.p.charge, aTrack.p.fm.e, 
     *                 aTrack.pos.xyz.x/molu,
     *                 aTrack.pos.xyz.y/molu,
     *                 aTrack.t, 
     *                 -sngl(aTrack.vec.w.r(1)),
     *                 -sngl(aTrack.vec.w.r(2)), wz
               else
                  write(*,'("p ", 4i4, 1pE11.3, 2E11.3, 0pf10.6 )')
     *                 ldep,  code,  aTrack.p.subcode,
     *                 aTrack.p.charge, aTrack.p.fm.e,
     *                 sr,
     *                 aTrack.t,   wz
               endif
               goto 25          !  break loop
            endif
         enddo
 25      continue
c            ---------- compute energy loss irrespec. of histdep
         if(aTrack.p.charge .ne. 0  ) then
            rho = cvh2den(aTrack.pos.height)
c         get energy loss when aTrack goes 1 g/cm2 along the
c         primary direction. Gramage the particle can run is
c         1/cos where cos is the cos of angle relative to the
c         primary angle . 1g/cm^2 = 10-3kg/10-4 m^2 =10 kg/m^2.
c         To travel  1 g/cm^2  along shower axis, the ptcl must
c         run dist kg/m^2
            disto =10./wz   ! in kg/m2
c                 to avoid too large dist due to very small zenith
c                 we limit the dist so that scattering deflection be
c                 smaller than 1 g/cm2. 
c             Since deflection in r.l ~ (Es/E) (dist/366)**(3/2).
c             i.e,   deflection in kg/m2 ~ 366(Es/E) (dist/366)**(3/2) < 10.
c                 
cc            if( wz  .lt. 0.5) then
cc               dist = min(disto, 
cc     *         366.0d0*(10.0d0/366.0d0*Ek/21.d-3)**0.666d0 )                    
cc            else
               dist = disto
cc            endif
            call cqElossRate(dedt) !  loss rate GeV/(kg/m^2)
c                       energy loss  in dist
            Eloss = dedt*dist

c                     see if this is > K.E
            if(Eloss .gt. Ek ) then
               Eloss = Ek
               dist = Eloss/dedt
            endif
            Eloss = Eloss*aTrack.wgt       !  GeV/(g/cm2)
            SumEloss(ldep)=SumEloss(ldep) + Eloss
         endif
      endif
c            ------------------
      if(id .eq. 2 .and. code .le. 3) then
c          see if 'where' is specified for histogram
         do i = 1, ansites
            if( histdep(i) .eq. ldep )  then
               j = ldep
c                  
               molu = ObsSites(ldep).mu
               rinmu = r/molu
               sr = rinmu
               if( tklat ) then
c                    lateral
                  call kwhist(rspec(code, i), sr, 1.0 )
               endif
               if( tkelosslat 
     *           .and. aTrack.p.charge .ne. 0 ) then

cc                  dist = dist/rho !   in m
cc                  wx = aTrack.vec.w.r(1)
cc                  wy = aTrack.vec.w.r(2)
cc                  call crbinPortion(rinmu, 
cc     *                 aTrack.pos.xyz.x/molu, aTrack.pos.xyz.y/molu,
cc     *                 dist, wx, wy, wz, rbin, 
cc     *                 nrbin,  deportion, i1, i2)
c//////////////////
c                  if(i1 .ne.  i2) then
c                     write(0,*) ' r, dist, wz', r, dist, wz, i1, i2
c                     sum = 0. 
c                     do ic = i1, i2
c                        sum = sum +  deportion(ic)
c                        write(0,*) deportion(ic), sum
c                     enddo
c                  endif
c///////////////
c      real*8  r  !  input.  a value >= 0.
c      real*8  d  !  input.  length of the segment
c      real*8  wx, wy, wz  !  input.  direction cosines. wz>=0 is assumed.
c      integer n           !  input. bin size
c      real*8  rbin(n)     !  input. bin values. r(1)=0 is assumed.
c      real*8  portion(n)  !  output.
c      integer i1, i2      !  output.
c                 
cc                  do ic = i1, i2
                       de = Eloss
cc                     de = deportion(ic)*Eloss
cc                     if(ic .eq. i1) then
                         tempr = sr
cc                     elseif(ic .lt. nrbin) then
cc                        tempr =( rbin(ic) + rbin(ic+1))/2/ObsSites(j).mu
cc                     else
cc                        tempr = rbin(ic)/ObsSites(j).mu
cc                     endif
c                       by   all charged particles
                     call kwhist(lossrspec(3,i), tempr, de)

                     if( aTrack.p.code .eq.  kelec ) then
c                          by electrons
                        call kwhist(lossrspec(1,i), tempr, de)
                     else
c                          by other charged particles
                        call kwhist(lossrspec(2,i), tempr, de)
                     endif
cc                  enddo
               endif          
c                  end of eloss late

               if(tkarspec) then
c                    arspec
                  aa=atan2(aTrack.pos.xyz.y,aTrack.pos.xyz.x)*
     *             57.29577951308230 
                  aa= mod(aa + 360.d0,   360.d0)
                  if(aa .gt. 337.5d0) aa= aa-360.d0
                  call kwhist2( arspec(code, i), sngl(aa), sr, 1.0)
               endif


               if( tkrespec ) then
c                  re spectrum
                  call kwhist2( respec(code, i), sr, Ek, 1.0)
               endif


               if( tkrzspec ) then
                  call kwhist2( rzspec(code, i), sr, 
     *                 sngl(wz), 1.0 )
               endif


               if( wz .lt. 1.0d0 ) then
                  temp = 1.d0 - wz**2
                  if(temp .gt. 0.) then
                     temp = sqrt(temp)
                     f = (
     *                  aTrack.pos.xyz.x* aTrack.vec.w.r(1) +
     *                  aTrack.pos.xyz.y* aTrack.vec.w.r(2) ) /r
     *                  /temp             
                  else
                     f = 1.0
                  endif
               else
                  f = 1.0
               endif
               if( tkzfspec .and. f .lt. 1.0 ) then
                  call kwhist2( zfspec(code, i), 
     *              sngl(wz), f, 1.0 )
               endif


               if( tkefspec .and. f .lt. 1.0 ) then
                  call kwhist2( efspec(code, i), 
     *              Ek, f, 1.0 )
               endif

               if( tkrfspec .and. f .lt. 1.0 ) then
                  call kwhist2( rfspec(code, i), 
     *              sr, f, 1.0 )
               endif

               if( tkrtspec ) then
                  call kwhist2( rtspec1(code, i), sr, 
     *              sngl( aTrack.t ), 1.0)
                  call kwhist2( rtspec2(code, i), sr, 
     *              sngl( aTrack.t ), 1.0)
               endif

               if(tkretspec ) then
                  call kwhist3( retspec1(code, i), sr,  Ek, 
     *                 sngl( aTrack.t ), 1.0)
                  call kwhist3( retspec2(code, i), sr,  Ek, 
     *                 sngl( aTrack.t ), 1.0)
               endif

               if( tkrezspec ) then
                  call kwhist3( rezspec(code,i), sr, Ek, 
     *              sngl(wz),  1.0 ) 
               endif

               if( tkrzfspec ) then
                  call kwhist3( rzfspec(code, i),  sr, 
     *                 sngl(wz), f, 1.0)
               endif

               if( tkrefspec ) then
                  call kwhist3( refspec(code, i),  sr, 
     *                 Ek, f, 1.0)
               endif

               goto 100
            endif
         enddo
 100     continue
      endif
      return
c     **************
      entry xEnEvent
c     **************
      call cqFirstID(depth)
      depth = depth* 0.1     ! in g/cm2  First col depth.

      if(ObserveAS) then
         cog = 0.
         sumne = 0.

         do i = 1, NoOfASSites
            if(i .gt. 1 .and. i  .lt. NoOfASSites ) then
               dd =(ASDepthList(i+1) - ASDepthList(i-1))/2.0
            elseif(i .eq. 1) then
               dd =(ASDepthList(2) - ASDepthList(1))
            else
               dd =(ASDepthList(NoOfASSites) -
     *              ASDepthList(NoOfASSites-1))
            endif
            cog = cog + ASObsSites(i).esize*dd*ASDepthList(i)
            sumne= sumne +ASObsSites(i).esize*dd
         enddo
c          0.1 is for g/cm2
         cog = cog*0.1/sumne

         cog2 = 0.
         sumne = 0.
         do i = 1, NoOfASSites
            if( ASObsSites(i).age .gt.
     *          (2.0-ASObsSites(NoOfASSites).age))  then
               if(i .gt. 1 .and. i  .lt. NoOfASSites ) then
                  dd =( ASDepthList(i+1) - ASDepthList(i-1))/2.0
               elseif(i .eq. 1) then
                  dd =(ASDepthList(2) - ASDepthList(1))
               else
                  dd =(ASDepthList(NoOfASSites) -
     *              ASDepthList(NoOfASSites-1))
               endif
               dd = dd
               cog2 = cog2 + ASObsSites(i).esize*ASDepthList(i)*dd
               sumne= sumne +ASObsSites(i).esize*dd
            endif
         enddo
         if(sumne .gt. 0.) then
            cog2 = cog2*0.1/sumne
         else
c              too deep penetration
            cog2 = ASDepthList(NoOfASSites)*0.1
         endif


         if(fnoB .ge. 0 )  then
            write(fnoB,
     *      '("h ", i4,  3i3, 1pE11.3, 0p 3f11.7, f7.2, 2f7.0)')
     *      EventNo,  inci.p.code,
     *      inci.p.subcode, inci.p.charge,
     *      inci.p.fm.e, -angle.r(1), -angle.r(2), -angle.r(3),
     *      depth, cog, cog2
         else
            write(*,
     *      '("h ", i4,  3i3, 1pE11.3, 0p 3f11.7, f7.2, 2f7.0)')
     *      EventNo,  inci.p.code,
     *      inci.p.subcode, inci.p.charge,
     *      inci.p.fm.e, -angle.r(1), -angle.r(2), -angle.r(3),
     *      depth, cog, cog2
         endif
         do i = 1, NoOfASSites 
            if(fnoB .ge. 0) then
               write(fnoB, '("t ", i3, 2f7.1,  2f6.3,
     *         1p6E11.3)')
     *          i, 
     *          ASDepthList(i)*0.1,  ASObsSites(i).mu,
     *          ASObsSites(i).age,   ASDepthList(i)*0.1/cog2, 
     *          Ng(i), Ne(i), Nmu(i), Nhad(i),
     *          ASObsSites(i).esize, SumEloss(i)  
            else
               write(*, '("t ", i3, 2f7.1,  2f6.3,
     *         1p6E11.3)')
     *          i, 
     *          ASDepthList(i)*0.1,  ASObsSites(i).mu,
     *          ASObsSites(i).age,   ASDepthList(i)*0.1/cog2, 
     *          Ng(i), Ne(i), Nmu(i), Nhad(i),
     *          ASObsSites(i).esize, SumEloss(i)  
            endif
         enddo
      endif
      if(fnoB .ge.  0) then
         write(fnoB,*)
      else
         write(*,*)
      endif

      do i = 1, ansites
         j=histdep(i)
         write(evid(i), 
     *   '(i3, i5,  f5.2, f5.2,
     *   i5,  i4)')
     *   histdep(i), int( ASDepthList(j)*0.1 ),  
     *   ASObsSites(j).age, ASDepthList(j)*0.1/cog2,
     *   int(ASObsSites(j).mu), int(cog2)
      enddo


      if( tklat ) then
         do j = 1, 3
            do i = 1, ansites
               k = histdep(i)
               call kwhists( rspec(j,i), 0. ) ! 0. means area norm.
               call kwhistev(rspec(j,i), EventNo)
               call kwhistid(rspec(j,i), evid(i))
               call kwhistdir(rspec(j,i), ptcl(j)//"/")
               call kwhistp( rspec(j,i),  fno)
            enddo
         enddo
      endif

      if(tkelosslat) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists( lossrspec(j,i), 0. ) ! area norm
               call kwhistev(lossrspec(j,i), EventNo)
               call kwhistid( lossrspec(j, i), evid(i))
               call kwhistdir( lossrspec(j, i), ptcl2(j)//"/")
               call kwhistp( lossrspec(j, i), fno)
            enddo
         enddo

      endif
 120  continue
      
      if(tkarspec) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( arspec(j, i), 0. )
               call kwhistev2( arspec(j,i), EventNo)
               call kwhistid2( arspec(j, i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")') 
     *              ptcl(j), int( ASDepthList(k)*0.1 )  
               call kseblk(dirstr, "|", nstr)
               call kwhistdir2(arspec(j, i),  dirstr)
               call kwhistp2( arspec(j, i),  fno)
            enddo
         enddo
      endif
      
      if(tkrespec) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( respec(j, i), 0. )
               call kwhistev2( respec(j,i), EventNo)
               call kwhistid2( respec(j, i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")') 
     *              ptcl(j), int( ASDepthList(k)*0.1 )  
               call kseblk(dirstr, "|", nstr)
               call kwhistdir2(respec(j, i),  dirstr)
               call kwhistp2( respec(j, i),  fno)
            enddo
         enddo
      endif


      if( tkrzspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( rzspec(j, i), 0.)
               call kwhistid2( rzspec(j, i),  evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")') 
     *              ptcl(j), int( ASDepthList(k)*0.1 )  
               call kseblk(dirstr, "|", nstr)
               call kwhistdir2( rzspec(j, i),  dirstr)
               call kwhistp2( rzspec(j, i),  fno)
            enddo
         enddo
      endif

      
      if( tkzfspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( zfspec(j, i), 0.)
               call kwhistid2( zfspec(j, i), evid(i) )
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")') 
     *              ptcl(j), int( ASDepthList(k)*0.1 )  
               call kseblk(dirstr, "|", nstr)
               call kwhistdir2(  zfspec(j, i),  dirstr)
               call kwhistp2( zfspec(j, i),  fno)
            enddo
         enddo
      endif


      
      if( tkrfspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( rfspec(j, i), 0.)
               call kwhistid2( rfspec(j, i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")') 
     *              ptcl(j), int( ASDepthList(k)*0.1 )  
               call kseblk(dirstr, "|", nstr)
               call kwhistdir2(rfspec(j, i),  dirstr)
               call kwhistp2( rfspec(j, i),  fno)
            enddo
         enddo
      endif

      
      if( tkefspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( efspec(j, i), 0.)
               call kwhistev2(efspec(j,i), EventNo)
               call kwhistid2( efspec(j, i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")') 
     *              ptcl(j), int( ASDepthList(k)*0.1 )  
               call kseblk(dirstr, "|", nstr)
               call kwhistdir2(efspec(j, i),  dirstr)
               call kwhistp2( efspec(j, i),  fno)
            enddo
         enddo
      endif


      if( tkrtspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( rtspec1(j,i), 0.)
               call kwhistev2( rtspec1(j,i), EventNo)
               call kwhistid2( rtspec1(j,i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")') 
     *              ptcl(j), int( ASDepthList(k)*0.1 )  
               call kseblk(dirstr, "|", nstr)
               call kwhistdir2(rtspec1(j,i),  dirstr)
               call kwhistp2( rtspec1(j,i),  fno)
            enddo
         enddo
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( rtspec2(j,i), 0.)
               call kwhistev2(rtspec2(j,i), EventNo)
               call kwhistid2( rtspec2(j,i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")') 
     *              ptcl(j), int( ASDepthList(k)*0.1 )  
               call kseblk(dirstr, "|", nstr)
               call kwhistdir2(rtspec2(j,i),  dirstr)
               call kwhistp2( rtspec2(j,i),  fno)
            enddo
         enddo
      endif


      if(tkretspec ) then
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( retspec1(j, i), 0.)
               call kwhistev3(retspec1(j,i), EventNo)
               call kwhistid3( retspec1(j, i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4,"/")' ) 
     *           ptcl(j), int( ASDepthList(k)*0.1 )
               call kseblk(dirstr, "|", nstr)
               call kwhistdir3( retspec1(j, i), dirstr)
               call kwhistp3( retspec1(j, i), fno)
            enddo
         enddo
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( retspec2(j, i), 0.)
               call kwhistev3(retspec2(j,i), EventNo)
               call kwhistid3( retspec2(j, i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")' ) 
     *           ptcl(j), int( ASDepthList(k)*0.1 )
               call kseblk(dirstr, "|", nstr)
               call kwhistdir3(retspec2(j, i), dirstr)
               call kwhistp3( retspec2(j, i), fno)
            enddo
         enddo
      endif


      if( tkrezspec ) then
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( rezspec(j, i), 0.)
               call kwhistev3(rezspec(j,i), EventNo)
               call kwhistid3( rezspec(j, i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4,"/")' ) 
     *           ptcl(j), int( ASDepthList(k)*0.1 )
               call kseblk(dirstr, "|", nstr)
               call kwhistdir3(rezspec(j, i),  dirstr)
               call kwhistp3( rezspec(j, i),  fno)
            enddo
         enddo
      endif


      if( tkrzfspec ) then
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( rzfspec(j, i), 0.)
               call kwhistev3(rzfspec(j,i), EventNo)
               call kwhistid3( rzfspec(j, i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4,"/")' ) 
     *           ptcl(j), int( ASDepthList(k)*0.1 )
               call kseblk(dirstr, "|", nstr)
               call kwhistdir3(rzfspec(j, i),  dirstr)
               call kwhistp3( rzfspec(j, i),  fno)
            enddo
         enddo
      endif


      if( tkrefspec ) then
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( refspec(j, i), 0.)
               call kwhistev3(refspec(j,i), EventNo)
               call kwhistid3( refspec(j, i), evid(i))
               k=histdep(i)
               write(dirstr,'(a,"/d",i4, "/")' ) 
     *           ptcl(j), int( ASDepthList(k)*0.1 )
               call kseblk(dirstr, "|", nstr)
               call kwhistdir3( refspec(j, i),  dirstr)
               call kwhistp3( refspec(j, i),  fno)
            enddo
         enddo
      endif
      end
