#!/bin/sh -f
if [ $# -lt 3 ]; then
    echo "Usage: $0 SkelDir number1 number2 {number3...}"
    echo "SkelDir is the directory where Skeleton001 etc are stored"
    echo "numberI is  such as 1 5 10 etc indicating Skeleton001 Skeleton005 etc"
    echo "They are merged and saved as ./Skeleton"
    exit
fi
make clean; make -f mergeSkel.mk
source $COSMOSTOP/Scrpt/setarch.sh
if [ ! -f  ./mergeSkel$ARCH ]; then
    echo "binary mergeSkel$ARCH is not made"
    exit
fi
source ./setupenv.sh $0
#*************
name="Skeleton"
#*************
dir=$1
if [ ! -d $dir ]; then
    echo "$dir is non existent directory"
    exit
fi

shift
num=`echo $1 | awk '{printf("%4.4d",$1)}'`
if [ ! -f $dir/$name$num ]; then
    echo " $dir/$name$num  is non existent file"
    exit
fi
cp $dir/$name$num  ./Skeleton
echo " $dir/$name$num is copied to  ./Skeleton"
shift
until [ $# -eq 0 ]
do
    num=`echo $1 | awk '{printf("%4.4d",$1)}'`
    if [ ! -f $dir/$name$num ]; then
	echo " $dir/$name$num is non existent file"
	exit
    fi
    echo "making  tempskel from ./Skeleton +  $dir/$name$num "
    echo "Skeleton  $dir/$name$num" | ./mergeSkel$ARCH
    echo "mv tempskel to ./Skeleton"
    mv ./tempskel  ./Skeleton
    shift
done
mv ./Skeleton $SKELETON
echo "All files have been  merged  and saved as $SKELETON"
