c            get max movable lenghth of a ptcl.
      subroutine cmaxMovLen(leng, thick)
c       leng:  real*8. output.  max movable length in m.
c      thick:  real*8. output.  thickness corresponding to leng in kg/m2.
c                         however, note;
c                             AlmostVacT, if Reverse=0 and height >AlmostVacH
c                             0. if Reverse = 1.
c                             0. if Reverse = 2 and  height > AlmostVacH
c                                  
c   A)   if a charged ptcl
c    A-1) compute (radius of gyro circle)/LamorDiv
c      where LamorDiv is 10 in default. Also compute length where
c      dB < 1%. Take minimum of both. 
c    A-2)   if not Reverse mode,  compute maximum gramage where cascade
c           scatteing remains very small; For a high energy electron,
c           density change must be kept small so get minimum of 
c           of the both gramage.  Convert the gramage into length.
c           if A-1) is shorter than A-2, take A-1 length and compute
c           corresponding gramage.  If A-2 is shorter,  leng and thick
c           are already obtained.
c    A-3)   if Reverse mode =1,  take A-1) and make thick = 0
c           if Reverse mode =other, take A-1) and compute thick 
c           corresponding to A-1)
c  elsse if
c   B)   a neutral particle, 
c     B-1) assume a  large length; rmg
c          If not Revesr mode, 
c            for neutrinos use such B-1) and corresponding thickness
c            (thickness is not used at all)
c            for photons, 
c                 if E> mag pair region, get length wherer dB<1 %
c                 and take min of this and rmg. (gramage not yet computed)
c            
c                 if E > LPM region, get gramage where LPM xsection
c                     remains const
c                 else  take gramage= X0*5
c                 compute  corresponding length
c                 if its rmg< length, use rmg and compute corresponding
c                 thickness else use already computed length and thick
c         if Reverse mode = 1, use leng=rmg and thick=0
c         if Reverse mode =other, use leng =rmg and corresponding thickness
c
c
c
      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zelemagp.h"
#include  "Zstdatmos.h"

      real*8 leng, thick
c
      real*8  ztrunc, rmg, rmgmax
      real*8  clen2thick, erg
      integer jcut


      erg = TrackBefMove.p.fm.p(4)
c             fix energy dependent truncation path
      if(TrackBefMove.p.charge .ne. 0) then
c            magnetic deflection
         call cmagDefR(TrackBefMove, Mag,  rmg)  ! get radius approx.
c/////////
c         write(0,*) ' rmg', rmg, ' for E=',erg, ' /LamorDiv=',
c     *     rmg/LamorDiv
c/////////
         rmg = rmg/LamorDiv        !  this is almost streight movable
c            get max length within which B is almost const (dB< 1 %)
         call clengSmallBC(TrackBefMove, rmgmax)  
c//////////
c         write(0,*) ' dB < 1% is', rmgmax, ' rmg',rmg
c/////////////
         rmg = min(rmg, rmgmax)
c            mul. scatt and lpm
         if(Reverse .eq. 0) then
c               scattering effect; streight and scattered line must be
c               not so much different ; path < ztrunc (kg/m2)
            call cmaxCasLen(TrackBefMove, ztrunc)
c/////////
c            write(0,*)  ' ztrunc=', ztrunc
c/////////////
            if(TrackBefMove.p.code .eq. kelec .and. 
     *         TrackBefMove.p.fm.p(4) .gt. LpmBremEmin
     *         .and. LpmEffect ) then
               ztrunc =
     *         max( min(TrackBefMove.pos.depth/10., ztrunc), 
     *              30.d0 )
            endif

            call cthick2len(TrackBefMove,
     *          ztrunc, leng, thick, jcut)
c//////////////
c            write(0,*) ' thick 2 len=', ' ztrunc->leng=', leng, 
c     *     ' thick =',thick, ' jcut=', jcut, ' rmg=', rmg
c////////////
c                 thick may have been changed to shorter one.
            if(rmg .lt. leng) then

               thick = clen2thick(TrackBefMove.pos.height,
     *              TrackBefMove.vec.coszenith, rmg)
               leng = rmg
c////////////////
c               write(0,*) ' rmg < leng so thick=', thick, ' leng=',leng
c/////////////
            endif
cc            else
cc               thick = AlmostVacT
cc               leng = rmg
cc            endif
         elseif(Reverse .eq. 1) then
            leng = rmg
            thick = 0.
         else
            leng = rmg
            thick = clen2thick(TrackBefMove.pos.height,
     *         TrackBefMove.vec.coszenith, rmg)
         endif
      else
c               neutral
         rmg = 1.d5
         if(Reverse .eq. 0) then
            if(TrackBefMove.p.code .eq. kneumu .or.
     *          TrackBefMove.p.code .eq. kneue) then
               leng = rmg           ! means very large
               thick = AlmostVacT   ! not used
            else
               if(TrackBefMove.p.code .eq. kphoton) then
                  if(erg .gt. MagPairEmin .and. MagPair .ne. 0) then
                     call clengSmallBC(TrackBefMove, rmgmax)  
                     rmg = min(rmg, rmgmax)
                  endif
               endif
c                  next one cannot be compliled by ifort at
c                  opteron.  reason unknown so it is modifed.
c               if(TrackBefMove.p.code .eq. kphoton .and.
c     *              TrackBefMove.p.fm.p(4) .gt. LpmPairEmin .and. 
c     *              LpmEffect) then

               if(TrackBefMove.p.code .eq. kphoton .and. LpmEffect
     *          .and. TrackBefMove.p.fm.p(4) .gt. LpmPairEmin ) then
                  if(TrackBefMove.pos.height .lt. AlmostVacH) then
                     ztrunc = TrackBefMove.pos.depth/10.
                  else
                     ztrunc = AlmostVacT  
                  endif
               else
                  ztrunc = X0*5
               endif
               call cthick2len(TrackBefMove,
     *            ztrunc, leng, thick, jcut)
c                 thick may have been changed to shorter one.
               if(rmg .lt. leng) then
                  thick = clen2thick(TrackBefMove.pos.height,
     *            TrackBefMove.vec.coszenith, rmg)
                  leng = rmg
               else
c                 leng and thick are given
c                  thick = AlmostVacT   ! not used.
c                  leng = rmg           ! strange
               endif
            endif
         elseif(Reverse .eq. 1) then
            leng = rmg
            thick = 0.
         else
            leng = rmg
cc            if(TrackBefMove.pos.height .gt. AlmostVacH) then
cc               thick = 0.
cc            else
               thick = clen2thick(TrackBefMove.pos.height,
     *         TrackBefMove.vec.coszenith, rmg)
cc            endif
         endif
      endif
      end
c     **********************
      subroutine cmaxCasLen(aTrack, kgpm2)
      implicit none
c       get max. movable length for cascade so
c       that the scattering deflection can be
c        neglected
#include "Ztrack.h"
#include  "Ztrackp.h"
cc         #include  "Ztrackv.h"
#include  "Zelemagp.h"

      record /track/ aTrack ! input.
      real*8 kgpm2  ! output. length kg/m2

c
      real*8  ek, ttrunc


      ek = aTrack.p.fm.p(4) - aTrack.p.mass
      if(ek .gt. 1.d-3) then
         ttrunc=min( ek*5.0d0, 1.d0)
      else
         ttrunc = max(1.d-3, ek*2.d0)
      endif
      kgpm2= ttrunc*X0
      end
c    *************************************
      subroutine cmagDefR(aTrack, mag, r)
c       get magnetic deflecton radius.  This is
c       approximate one.
      implicit none

#include  "Ztrack.h"

      record /track/aTrack  ! input. charged particle
      record /magfield/ mag  ! innput. magnetic field
      real*8  r   ! output. Radius of magnetic defletion.  m

      real*8 maxb

      if(aTrack.p.charge .eq. 0) then
         r = 1.e30
      else
         maxb = max (abs(mag.x), abs(mag.y), abs(mag.z)) 
         if(maxb .ne. 0) then
c               r is smaller than true Lamor radius which
c               would be obtained with momentum
c               since K.E < P
            r = 3.3*(aTrack.p.fm.p(4)-aTrack.p.mass)/maxb/
     *       abs(aTrack.p.charge)
            r= max(r, 1.d-2)
         else
            r = 1.e30
         endif
      endif
      end
c      ***********************
      subroutine clengSmallBC(aTrack, r)
c       get length where the change of magnetic
c       field can be regarded as small < 1 %
      implicit none

#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Zearth.h"

      record /track/aTrack ! input. r is obtaiend at this ptcl is
c                         located.
      real*8  r  ! output. within this length (m), geomag can be
c                      regarged as constant.

c     at the surface of Earth, it is about 20 km = MagChgDist
c     at larger radial distance, it becomes larger
c
      r =   aTrack.pos.radiallen/Eradius * MagChgDist

      end
