c      implicit none
c      integer n,  i, j
c
c      real*8 sumx,  sum, xa(500)
c
c      read(*,*) n, sumx
c
c      do i = 1, 10000
c         call ksmpConExp(n, sumx, xa)
c         sum = 0
c         do j= 1, n
c            write(*,*) sngl(xa(j))
c            sum = sum + xa(j)
c         enddo
c         if( abs(sum-sumx) .gt. 1.d-5 )  then
c            write(0,*)  sum, sumx
c            stop
c         endif
c      enddo
c      end
       subroutine ksmpConExp(n, sumx, xa)
c
c         This samples  x of n particles so that sum of x
c         becomes sumx.  The pre-assumed one particle distribution of
c         each particle is propotional to exp(-b xi/xc) dxi
c         but there is a constraint of delta(sum(xi) - sumx).
c       sampling is can be done by using (sum-xi)^(m-2) dxi
c       for givne sum = sum(xi) (i=1, m)
c      n should be b* sumx/xc;   For xc=0.1 and b=10, n=sumx*100.
c       

      implicit none
      integer n     ! input  number of particles to be generated
      real*8 sumx   ! input  sum of x
      real*8 xa(n)  ! output.  x of n particles generated 
      
      real*8 x, u, xk
      integer j
      
      x = sumx
      do j = 1, n-1
         call rndc(u)
         xk = x*(1.0- u**(1.0/(n-j)))
         xa(j) = xk
         x = x - xk
      enddo
      xa(n) = x
      end


