c             makes a table of
c          lat, long, horizontal, vertical, def. angle
c
c          for lat = -90 to 90 step 5 deg
c          long =-180 to 180 step 10 deg.
c  the resultant data can be drawn by, say, gnuplot. 
         program drawGeomag
         implicit none

#include  "Zcoord.h"
#include  "Zmagfield.h"
         real*8 year, lat, long, h
         record /coord/ llh
         record /magfield/ b, hva
         integer icon, ilat, ilong, igrf
         character*64 file
c
         year=2000.
         h =0.
         call cerrorMsg(
     *   'Enter year of geomagnetism (=2000) and height(=0 m)', 
     *    1)
         read(*,*) year, h

         call cerrorMsg(
     *   'Enter 1, 2 or 3 for 1) igrf, 2) wmm or other data', 1)
         read(*,*) igrf

         if(igrf .eq. 1) then
            file = '../Data/Geomag/igrf'
         elseif(igrf .eq. 2) then
            file = '../Data/Geomag/wmm'
         else
            call cerrorMsg('Enter file path for geomag data',1)
            read(*,*) file
         endif

         call crdGeomag(file, year)
         write(*,'("#     lat   long   H   V (Tesla) Ang(deg) ")')
         do ilat = -90, 90,  5
            lat = ilat
            do ilong = -180, 180, 10
               long = ilong
               call csetCoord('llh', lat, long, h, llh)
               call cgeomag(year, llh, b, icon)
               call cned2hva(b, hva)
c              call ctransMagTo('xyz', llh, b, b)
c              write(*,*) ' x=',b.x, ' y=', b.y, ' z=', b.z
               write(*, *) float(ilat), float(ilong), 
#ifdef  UNIONMAP
     *         sngl(hva.h), sngl(hva.v), sngl(hva.a)
#else
     *         sngl(hva.x), sngl(hva.y), sngl(hva.z)
#endif
cc             call cprintMagF(b)
cc             call cprintMagF(hva)
            enddo
            write(*,*)
         enddo   
         end
