#include "ZsubstRec.h"
c            treat interaction of MovedTrack
c
      subroutine cinteraction
      implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"

c
c          used to judge if user hook should be called 
c          after MovedTrack interacted.
c
      integer neverNEP/0/,  neverE/0/,  neverG/0/
      save  neverNEP, neverE, neverG
      integer never
      integer stackpos
      save never

cc      record /ptcl/ fragA(maxHeavyMassN),  nonIntNucA(maxHeavyMassN)
cc      integer noOfFrag, noOfNonIntN
c
c      record /track/aTrack
c
c   **  ptcl stacking is done in each subroutine; should be changed
c           (except for hadronic interactions)

      Nproduced = 0


c
cc    assume MovedTrack is not changed in interaction routine
c     but may be added asflag by chookEing if it is elec.
c      (in the case of Job ='newskel' )
c     
c
      if(MovedTrack.p.code .eq. kelec) then
         call cinteElec
      elseif(MovedTrack.p.code .eq. kphoton) then
          call cintePhoton
      else
          call cinteNEP
          if(IntInfArray(ProcessNo).process .eq. 'coll') then
             MovedTrack.pos.colheight = MovedTrack.pos.height
          endif
      endif

      if(OneDim .eq. 0) then
c            3 dimensional
c                 stack the leading ptcl  first (to save stack area)
         call cmovePtcl3(MovedTrack, Pwork, Nproduced, Nstacked)
      else
         MovedTrack.vec = IncidentCopy.vec
         call cmovePtcl1(MovedTrack, Pwork, Nproduced, Nstacked)
      endif
      if(MovedTrack.p.code .eq. kelec) then
         if(neverE .ne. 1) then
            call chookEInt(neverE)
            never = neverE
         endif
      elseif(MovedTrack.p.code .eq. kphoton) then
          if(neverG  .ne. 1)  then
             call chookGInt(neverG)
             never = neverG
          endif
      else
         if(neverNEP .ne. 1) then
            call chookNEPInt(neverNEP)
            never = neverNEP
         endif
      endif
      if(never .eq. 0 .or. never .eq. 1 ) then
c          user may set never=3 
      elseif(never .eq. 3) then
c          don't follow this and  child; reset stackpos
         call cgetCurrentStackpos(stackpos)
         stackpos=stackpos-Nstacked
         call cresetStackpos(stackpos)
      elseif(never .eq. 4) then
c             discard this event
c             clear stack
         call cinitStack
      else
         call cerrorMsg('return value from chookE,G,NEPInt wrong', 0)
         write(0,*)  ' never=', never
      endif
      end
c          following is remnant of never=2 and ad-hoc model
c          when chookNEPInt is called before push is called.
c      elseif(never .eq. 2) then
c              save only fragments and non interacting nucleons
c         if(MovedTrack.p.code .eq. kgnuc ) then
cc               get fragment and non interacting nuc.
c            call cqHvyIntF(fragA, noOfFrag)
c            call cqHvyIntNIN(nonIntNucA, noOfNonIntN)
cc
c            if(OneDim .eq. 0) then
c                call cmovePtcl3(MovedTrack, fragA, noOfFrag)
c                call cmovePtcl3(MovedTrack, nonIntNucA, noOfNonIntN)
c             else
c                MovedTrack.vec = IncidentCopy.vec
c                call cmovePtcl1(MovedTrack, fragA, noOfFrag)
c                call cmovePtcl1(MovedTrack, nonIntNucA, noOfNonIntN)
c             endif
c          endif
c
c     ************************************
c          move partcles in a given array to stack
c          3 dimensional case.

      subroutine  cmovePtcl3(iTrack, pw, n, npush)
      implicit none
c                put n ptcls in pw into stack.
c          if ThinSampling, 
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c
      integer n
      record /track/ iTrack  ! input. incident ptcl.
      record /ptcl/ pw(n)
      integer npush   ! output. actual number of ptcls put in stack.
                   ! in case of ThinSampling, this may be <= Nproduced. 

      record /track/ aTrack  
      integer i, icon
      


      aTrack = iTrack
      npush = 0
      do i =  n, 1, -1          ! move leading ptcl first
#ifdef SUBSTREC
         aTrack.p = pw(i)
#else
         aTrack.p.fm.p = pw(i).fm.p
         aTrack.p.mass = pw(i).mass
         aTrack.p.code = pw(i).code
         aTrack.p.subcode = pw(i).subcode
         aTrack.p.charge = pw(i).charge
#endif

c               reset direction cos and related stuffs
         call cresetDirec(aTrack)
         if(ThinSampling) then
            call csetThinwgt(iTrack, aTrack,  icon)
         else
            icon = 0
         endif
         if(icon .eq.0) then
#if LABELING == 1
c
c              whennever an interaction occur,  update labelcounter
c             if info>0, clear the timer and infor counters.
c
            if(aTrack.info .gt. 0) then
ccc               aTrack.info = 0
ccc               aTrack.t = 0.
            endif
            Labelcounter = Labelcounter + 1
            aTrack.label = Labelcounter
#elif LABELING == 2
c            the above simple counter may be replaced by the
c            next sophisticated one. 
c            the same one is in the 1dim mode move routine below.
c
            call ctrickycount(iTrack, aTrack, pw, i)
c
#endif
            npush = npush + 1
            call cpush(aTrack)
         endif
      enddo 
      end
#if LABELING == 2
c       ************************************
c             This routine updates label counters.
c          but for the survival particle form brems and knock-on
c          the label counter is not updated. 
c          For those ptcl with info > 0, timer and info counters
c          are cleared. 
      subroutine ctrickycount(iTrack, aTrack, pw, i)
      implicit none
#include  "Zcode.h"
#include  "Ztrackp.h"
#include  "Ztrack.h"
#include  "Ztrackv.h"
c
      integer n
      record /track/ iTrack  ! input. incident ptcl.
      record /track/ aTrack  ! input/output. i-th  secondary track 
      record /ptcl/ pw(*)    ! input.  secondary pool
      integer i              ! input.  i-th secondary (index)

      logical reset

      reset = .true.

      if( iTrack.pos.height .gt. 40.d3 ) then
         if(IntInfArray(ProcessNo).process .eq. 'brems' ) then
c             for brem, electron has the same label as the incident
            if( aTrack.p.fm.p(4) .lt. iTrack.p.fm.p(4)*0.8) then
               aTrack.label = iTrack.label
               reset = .false.
            endif
         elseif(IntInfArray(ProcessNo).process .eq. 'knock' .or.
     *        IntInfArray(ProcessNo).process .eq. 'mscat' .or.
     *         IntInfArray(ProcessNo).process .eq. 'bscat' ) then
c                for the knock-on, survival particle has the same
c                label.
            if(iTrack.p.code .ne. kelec  .or.
     *           iTrack.p.charge .ne. -1) then
c                     knockon by p,mu,pi..e+ (not by e-)
               if(aTrack.p.code .ne. kelec) then
c                       survival one has the same label
                  aTrack.label = iTrack.label
                  reset = .false.
               endif
            else
c                  electron; make the higher one has the same label
               if(pw(1).fm.p(4) .gt. pw(2).fm.p(4)) then
                  if(i .eq. 1) then
                     aTrack.label = iTrack.label
                     reset = .false.
                  endif
               else
                  if(i .eq. 2) then
                     aTrack.label = iTrack.label
                     reset = .false.
                  endif
               endif
            endif                     
         endif
      endif
      if(reset) then
         Labelcounter = Labelcounter +1
         aTrack.label = Labelcounter
cc         aTrack.t = 0.          ! timer reset
cc         aTrack.info = 0        ! cross counter reset
      endif
      end
#endif
c     ************************************
c          move partcles in a given array to stack
c          1 dimensional case.

      subroutine  cmovePtcl1(iTrack, pw, n, npush)
      implicit none

#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"


      integer n
      record /track/ iTrack   ! input. incident track
      record /ptcl/ pw(n)
      integer  npush   !  output.  actuall number of ptcls put in stack.
      real*8 temp, p

      integer i, icon
      
      record /track/ aTrack 



      aTrack = iTrack

      do i =  n, 1, -1          ! move leading ptcl last
#ifdef SUBSTREC
         aTrack.p = pw(i)
#else
         aTrack.p.fm.p = pw(i).fm.p
         aTrack.p.mass = pw(i).mass
         aTrack.p.code = pw(i).code
         aTrack.p.subcode = pw(i).subcode
         aTrack.p.charge = pw(i).charge
#endif
c            see if angle of particle is larger than a lmit
         call cscalerProd(aTrack.p.fm.p, DcAtObsXyz, temp)
         call cpxyzp(aTrack.p.fm, p)
         if(p .gt. 0.) then
            temp = temp/p
         else
            temp = 1.
         endif
         if(temp .gt. BackAngLimit)  then
c              only take some limitted angle particles
c            call cresetMom(aTrack)  which is
            aTrack.p.fm.p(1) = p * aTrack.vec.w.r(1)
            aTrack.p.fm.p(2) = p * aTrack.vec.w.r(2)
            aTrack.p.fm.p(3) = p * aTrack.vec.w.r(3)

            call cgetZenith(aTrack, aTrack.vec.coszenith)


            if(ThinSampling) then
               call csetThinwgt(iTrack, aTrack, icon)
            else
               icon = 0
            endif
            if(icon .eq. 0) then
#if LABELING == 1
c                  whennever secondary particles are generated,
c               each of them get an updated label cocunter
c               if the particle has crossed the highest level
c               (info > 0),  timer and info counter is cleared
c
               if( aTrack.info .gt. 0) then
ccc                  aTrack.info = 0
cc                  aTrack.t = 0.
               endif
               Labelcounter = Labelcounter + 1
               aTrack.label = Labelcounter
#elif LABELING == 2
c                   this may be used if a tricky count is needed
c               in stead of above  counting
               call ctrickycount(iTrack, aTrack, pw, i)
#endif
               npush = npush + 1  
               call cpush(aTrack)
            endif
         endif
      enddo
      end

c     ****************************************************************
      subroutine cqIntePtcl(ptclA, num)
      implicit none
c          inquire the particle information that made interactions
c        to produce secondary particles.
c        If "MovedTrack" is a heavy,  ptclA will get interacting nucleons
c        otherwise, ptclA will have MovedTrack.p itself.
c
c           
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"

      record /ptcl/ ptclA(*)   ! output. interacted particles. max size
                               ! should be maxHeavyMassN (= 56 =Fe)
      integer num              ! output. number of ptcls in ptclA
c
c
cc      if(MovedTrack.p.code .ge. kdeut .and. 
cc     *    MovedTrack.p.code .le. khvymax ) then
      if( MovedTrack.p.code .eq. kgnuc ) then
         call cqHvyIntIN(ptclA, num)
      else
         num = 1
#ifdef SUBSTREC
         ptclA(1) = MovedTrack.p
#else
         ptclA(1).fm.p = MovedTrack.p.fm.p
         ptclA(1).mass = MovedTrack.p.mass
         ptclA(1).code = MovedTrack.p.code
         ptclA(1).subcode = MovedTrack.p.subcode
         ptclA(1).charge = MovedTrack.p.charge
#endif
      endif
      end
c     ***************************
      subroutine csetThinwgt(iTrack, aTrack, icon)
      implicit none
#include  "Zcode.h"
#include  "Ztrack.h"
#include  "Ztrackp.h"
#include  "Ztrackv.h"
#include  "Zincidentv.h"
#include  "Zelemagp.h"

      record /track/ iTrack   ! input  parent particle
      record /track/ aTrack  ! input   child particle
c                            ! output.    wgt
      integer icon           ! output.  0 if this is not tobe discarded
                             !          1 if this is to be discarded
      real*8 u, p 
      real*8 iergpn, aergpn
      logical dothin
      real*8 dd, rhoE
      real*8 cvh2den
      real*8 Z1, E0
      data Z1/-1./, E0/-1./
      save Z1, E0, rhoE, dd

      if(IncidentCopy.p.code .eq. kphoton  .and.
     *    PhotoProd )  then
c            photon  primary and muon is interested
c            so thinsamling must be carfull
c            we apply thinning only if current depth is
c            > 120 g/cm2 from the first col. point.
         if(Z1 .ne.  Zfirst.pos.depth  .or.
     *      E0 .ne.  IncidentCopy.p.fm.p(4) ) then
            Z1 = Zfirst.pos.depth 
            E0 = IncidentCopy.p.fm.p(4) 
            if( LpmEffect ) then
               rhoE=cvh2den( Zfirst.pos.height )* 1.e-3 * 
     *             IncidentCopy.p.fm.p(4) 
               if(rhoE .lt. 1.e6)  then
                  dd = 200.
               else
                  dd =min( 200.* sqrt(rhoE/1.e6), 1000.d0)
               endif
            else
               dd = 200.
            endif
         endif

         if(  MagBrem .eq. 2 .and.   Z1 .lt. 1.e-6 ) then
            dothin = iTrack.pos.depth/Zfirst.vec.coszenith
     *           .gt. 300.
         else
            dothin=( iTrack.pos.depth-Zfirst.pos.depth)/
     *           Zfirst.vec.coszenith .gt. (1000.+ dd)
         endif
      else
         dothin = .true.
      endif
      if(dothin) then 
         iergpn = iTrack.p.fm.p(4)
         if(iTrack.p.code .eq. kgnuc) then
            iergpn = iergpn/ iTrack.p.subcode
         endif
         aergpn = aTrack.p.fm.p(4)
         if(aTrack.p.code .eq. kgnuc) then
            aergpn = aergpn / aTrack.p.subcode
         endif
c        We apply thinning if Ethin1>  E
c        and weight is < Ethin2 
c           Weight and energy has
c           E=Ethin(1)/w ; at very low energies
c          (say < 1GeV ), E<=Ethin(1)/w begins
c           and brodens  
         if(iergpn .gt. Ethin(1) ) then
            if(aergpn .gt. Ethin(1)) then
c                    Both   Ei, Ec> Ethin1; no thinning
               icon = 0
               aTrack.wgt = iTrack.wgt
c         elseif(aergpn .gt. Ethin(2)) then 
            elseif( aTrack.wgt .lt. Ethin(2)) then
c              
               p = aergpn/Ethin(1)
               call rndc(u)
               if(u .lt. p)  then
                  icon = 0
                  aTrack.wgt = iTrack.wgt / p
               else
                  icon = 1
               endif
            else
               icon = 0
               aTrack.wgt = iTrack.wgt 
            endif
c      elseif(iergpn .gt. Ethin(2) .and.
c     *       aergpn .gt. Ethin(2) ) then
         elseif(iTrack.wgt .lt. Ethin(2) .and.
     *           aTrack.wgt .lt. Ethin(2) ) then
            p = aergpn/iergpn
            call rndc(u)
            if(u .lt. p ) then
               icon = 0
               aTrack.wgt = iTrack.wgt / p
            else
               icon = 1
            endif
         else
            icon =0
            aTrack.wgt = iTrack.wgt
         endif
      else
         icon = 0
         aTrack.wgt = iTrack.wgt
      endif
      end


