cc        test kfrge.
c      program test_kfrge
c      implicit none
c      integer l, icon
cc
c      real*8 x(6)/4., 3., -1., 9., 2., 4./
c      call kfrge(x, 1, 6, 3.d0, l, icon)
c      write(*, *) l, icon, x(l)
c      end
c     ****************************************************************
c     *                                                              *
c     *  kfrge: find real data (position) .ge. given value           *
c     *                                                              *
c     ***********************  tested 87.06.07  **********************
c
c   /usage/
c          call kfrge(x, intvx, n, c, l, icon)
c
c     x:  real*8. input.  data array
c intvx:  integer. input. interval of data in x
c     n:  integer. input. |n| is no. of data in x
c     c:  real*8. input.  given value.  x  .ge.  c is sought for.
c     l:  integer. output. position of xf in x.  xf=x(1,m)
c  icon:  0 if found else 1
c
c *** note ***
c         if n>0 search is made for from 1st, else from last
c         if icon=1 resluts, m will be n+1 or 0 dependingon n>0 or
c         n<0.
c
c
      subroutine kfrge(x, intvx, n, c, m, icon)
      implicit none
      integer intvx, n, m, icon
      real*8  x(intvx, *), c
c
      integer i
c
      if( n .gt. 0 ) then
          do i=1, n
             if(x(1,i) .ge. c) then
                 m=i
                 icon=0
                 goto 100
             endif
          enddo   
          icon=1
          m=n+1
      elseif(n .lt. 0) then
          do i=-n, 1, -1
              if(x(1,i) .ge. c) then
                  m=i
                  icon=0
                  goto 100
              endif
          enddo    
          m=0
          icon=1
      else
          icon=1
      endif
  100 continue
      end
