#undef  DUMMYDATE
#if defined NEXT486
#define DUMMYDATE
#elif defined PCLinux
#define DUMMYDATE
#elif defined CF_AlphaLinux
#define DUMMYDATE
#elif defined MACOSX
#define DUMMYDATE
#elif defined PCLinuxIFC
#define DUMMYDATE
#endif

#if defined DUMMYDATE
      subroutine IDATE()
      end
      subroutine ITIME()
      end
#endif
#undef DUMMYDATE

      subroutine cdpmjet(pj, ia, iz,  a, ntp)
      implicit none

#include "Zptcl.h"
#include "Zkfcode.h"
#include "Zmanagerp.h"
#include "Zevhnp.h"
#include "Zevhnv.h"
#include "Zcode.h"
#include "Zmass.h"
      
c    &&&&&&&&&&&&&&
c

      integer irsave(2)
c
      real*8    ELAB
      integer   IDP, NTMASS, NTCHAR, NPMASS, NPCHAR
      common /dpmjetcom/ ELAB, IDP, NTMASS, NTCHAR, NPMASS,NPCHAR
     *  ,irsave
c    &&&&&&&&&&&
c
      record /ptcl/ pj  ! input. projectile particle
      integer ia     ! input. nucleon number of the target
      integer iz     ! input. charge no. of target
      record /ptcl/ a(*)  !  output. produced ptcls.  in cms.
      integer ntp   ! number of produced ptcls
c

      integer icon,  loopc
      
      integer KKMAT
c///////////
      integer i
c/////////

      integer  NEVENT, ICASCA
      COMMON /DTEVNO/ NEVENT,ICASCA

      logical dodpm, first
      save first
      data first /.true./
c////////////
c      logical deb
c      common /cdebug/ deb
c////////////

      if(first) then
         NEVENT = 0
         first = .false.
c         ELAB = 3.0d0   
c         KKMAT = -1
c         call DT_KKINC(
c     *   1, 1, ia, iz,  1, ELAB, KKMAT, icon)
      endif

      KKMAT = -1
      NEVENT = NEVENT + 1 

      
      NTMASS = ia            
      NTCHAR = iz
      ELAB = pj.fm.p(4)
      if(pj.code .eq. kgnuc) then
         ELAB = ELAB/pj.subcode
      endif
      call ccos2dpjidp( pj, IDP, NPMASS, NPCHAR )

      dodpm = .false.
      if( IDP .eq. 0) then
c            dpm cannot treat this         
         if(pj.fm.p(4) .gt. 9.) then
            if(pj.code .eq. kkaon .and. LundPara(5) .ne. 0) then
               call chAcolAdhoc(pj, ia, iz, a, ntp)
            elseif(pj.code .eq. keta) then
               call chAcolAdhoc(pj, ia, iz, a, ntp)
            else
               call chAcolAdhoc(pj, ia, iz, a, ntp)
ccc               call chANewLund(pj, ia, iz, a, ntp)
            endif
         else
            ActiveMdl ='byenergy'
c                 use fritiof 1.6 or nucrin
            call chALund(pj, ia, iz, a, ntp)
         endif
      else

         if(pj.code .eq. knuc .and.
     *      pj.subcode .ne. antip ) then
            dodpm = pj.fm.p(4) .gt. 1.6
         elseif(pj.code .eq. knuc .and. 
     *      pj.subcode .eq. antip ) then
c               for light element, 0.97 is o.k for PB
c               safe to use a higher value.
            dodpm = pj.fm.p(4) .ge. 0.99
         else
            if(pj.code .ne. kgnuc) then
c         
               if(pj.code .ne. kkaon .or. pj.charge .ne. 0) then
                  dodpm = pj.fm.p(4)  .gt. pj.mass + 0.6
               elseif(pj.subcode .ne. antip) then
                  dodpm  = pj.fm.p(4) .gt. 1.5
               endif
            else
c                 dpmjet cannot treat heavy int. below 5 GeV
              dodpm = ELAB .gt. 5.1
           endif
         endif
c           endif here       is moved to the last
         if(dodpm) then
            icon = 1
            loopc = 0 

c                 dpm; GeV/n
            do while (icon .ne. 0)
c&&&&&
c            call rnd1s(irsave)
c &&&&&
               call DT_KKINC(
     *              NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,ELAB,KKMAT,icon)
               if(icon .ne. 0) then
c                   once the event is rejected, even if different
c                   random number cannot get rid of this loop. 
c                   so we change the energy by 1 %
                  ELAB=ELAB*1.01   
                  loopc = loopc + 1
c                  if(loopc .gt. 100) then    ! probably useless.
                  if(loopc .gt.  3) then
                     write(ErrorOut,*)
     *                    ' proj code, subcode, charge=',pj.code,
     *                    pj.subcode, pj.charge, ' E=',pj.fm.p(4),
     *                    ' Target A=', ia, ' Z=', iz
                     call cpdpmjetinp
                     call cerrorMsg(
     *              'dpmjet3 loop>3; ptcl generatation failed',0)     
                  endif
               endif
            enddo
            call csetdpmresul(pj, a, ntp)
         else
            if(pj.code .le. knuc) then
c               use fritiof 1.6 or nucrin
               ActiveMdl = 'byenergy'
               call chALund(pj, ia, iz, a, ntp)
            elseif(pj.code .eq. kgnuc) then
c  
               call cerrorMsg('Recursive call of heavy routine',0)
c                    dpmjet is bypaseed for heavy < 5GeV
c               if(ELAB .gt. 0.5) then
c                  ActiveMdl = 'byenergy'
c                  call cheavyInt(pj, ia, iz, a, ntp)
c               else
c                  a(1) = pj
c                  ntp = 1
c               endif
            endif
         endif
      endif
c/////////////////////
      do i = 1, ntp
         if(a(i).code .eq. kphoton .and.  a(i).charge .ne.  0) then
            write(0,*)
     *       'dpmerr  photon charge=' ,a(i).charge, ' subc=',
     *       a(i).subcode, ' E=',a(i).fm.p(4)
            write(0,*)
     *      'dpmerr dodpm=',dodpm,' ntp=', ntp, ' pj=', pj.code,
     *       ' pj.charge=', pj.charge, ' ia=',ia, ' iz=', iz
         endif
      enddo
c/////////////////

      end
      subroutine cpdpmjetinp
      implicit none
c            print current dpmjet input
      character*100 msg
c    &&&&&&&&&&&&&&
      integer irsave(2)

      real*8    ELAB
      integer   IDP, NTMASS, NTCHAR, NPMASS, NPCHAR
      common /dpmjetcom/ ELAB, IDP, NTMASS, NTCHAR, NPMASS,NPCHAR
     *   ,irsave
c    &&&&&&&&&&&
c
      write(msg, *) ' dpmjet input: IDP=', IDP, ' Elab=',ELAB
      call cerrorMsg(msg, 1)
      write(msg, *) ' target: A=', NTMASS, ' Z=',NTCHAR,
     *   ' NPA=',NPMASS, ' NPZ=',NPCHAR
      call cerrorMsg(msg, 1)
c
      write(msg, *) ' ir=', irsave
      call cerrorMsg(msg, 1)
      end

      subroutine csetdpmresul(pj, a, ntp)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
#include "Zcode.h"
#include "Zptcl.h"
      record /ptcl/ pj    ! input. projectile 
      record /ptcl/ a(*)  ! output.  
      integer ntp  ! ouptut. number of ptcls put in a

*
* COMMON /DTEVT1/ :
*                   NHKK         number of entries in common block
*                   NEVHKK       number of the event
*                   ISTHKK(i)    status code for entry i
*                   IDHKK(i)     identifier for the entry
*                                (for particles: identifier according
*                                 to the PDG numbering scheme)
*                   JMOHKK(1,i)  pointer to the entry of the first mother
*                                of entry i
*                   JMOHKK(2,i)  pointer to the entry of the second mother
*                                of entry i
*                   JDAHKK(1,i)  pointer to the entry of the first daughter
*                                of entry i
*                   JDAHKK(2,i)  pointer to the entry of the second daughter
*                                of entry i
*                   PHKK(1..3,i) 3-momentum
*                   PHKK(4,i)    energy
*                   PHKK(5,i)    mass
*

*  The final state particles from the actual event (number NEVHKK)
*  can be found in DTEVT1 and identified by their status:
*
*     ISTHKK(i) = 1    final state particle produced in
*                      photon-/hadron-/nucleon-nucleon collisions or
*                      in intranuclear cascade processes
*                -1    nucleons, deuterons, H-3, He-3, He-4 evaporated
*                      from excited nucleus and
*                      photons produced in nuclear deexcitation processes
*                1001  residual nucleus (ground state)
*
*  The types of these particles/nuclei are given in IDHKK as follows
*
*     all final state part. except nuclei :
*       IDHKK(i)=particle identifier according to PDG numbering scheme
*     nuclei (evaporation products, and residual nucleus) :
*       IDHKK(i)=80000, IDRES(i)=mass number, IDXRES(i)=charge number
*
*  The 4-momenta and masses can be found in PHKK (target nucleus rest frame):
*                   PHKK(1..3,i) 3-momentum (p_x,p_y,p_z)
*                   PHKK(4,i)    energy
*                   PHKK(5,i)    mass
*
*
      PARAMETER (NMXHKK=90000)

      COMMON /DTEVT1/ NHKK,NEVHKK,ISTHKK(NMXHKK),IDHKK(NMXHKK),
     &                JMOHKK(2,NMXHKK),JDAHKK(2,NMXHKK),
     &                PHKK(5,NMXHKK),VHKK(4,NMXHKK),WHKK(4,NMXHKK)

* extended event history
      COMMON /DTEVT2/ IDRES(NMXHKK),IDXRES(NMXHKK),NOBAM(NMXHKK),
     &                IDBAM(NMXHKK),IDCH(NMXHKK),NPOINT(10),
     &                IHIST(2,NMXHKK)

      integer i
      integer code, subcode, charge

      ntp =0
      do i=1, NHKK
         IF (ABS(ISTHKK(i)).EQ.1) THEN
            if(IDHKK(i) .lt. 79000.) then
               call ckf2cos(IDHKK(i), code, subcode, charge)
            else
               charge = IDXRES(i)
               code = kgnuc
               subcode = IDRES(i)
            endif
            if(code .ne. krare) then
               ntp = ntp +1
               call cmkptc(code, subcode, charge, a(ntp))
               a(ntp).fm.p(1) = PHKK(1,i)
               a(ntp).fm.p(2) = PHKK(2,i)
               a(ntp).fm.p(3) = PHKK(3,i)
               a(ntp).fm.p(4) = PHKK(4,i)
            endif
c            write(*,*)
c     *      IDHKK(i), code, subcode, charge,
c     *      sngl(PHKK(4,i)),
c     *      sngl(PHKK(1,i)),sngl(PHKK(2,i)),sngl(PHKK(3,i))
         ELSEIF (ABS(ISTHKK(i)).EQ.1001) THEN
c             residual nucleus; neglect
         ENDIF
      enddo
c     -------------- rotate
      call crot3mom(pj, a, ntp)
      end
      SUBROUTINE DT_USRHIS(MODE)
      implicit none
      integer MODE
      end


c      IDP number
c     'PROTON  ' , 'APROTON ' , 'ELECTRON' , 'POSITRON' ,
c        1            2            3             4  
c     'NEUTRIE ' , 'ANEUTRIE' , 'PHOTON  ' , 'NEUTRON ' , 'ANEUTRON' ,
c        5             6           7             8             9
c     &'MUON+   ' , 'MUON-   ' , 'KAONLONG' , 'PION+   ' , 'PION-   ' ,
c       10             11          12           13           14
c     &'KAON+   ' , 'KAON-   ' , 'LAMBDA  ' , 'ALAMBDA ' , 'KAONSHRT' ,
c       15            16           17           18           19
c     &'SIGMA-  ' , 'SIGMA+  ' , 'SIGMAZER' , 'PIZERO  ' , 'KAONZERO' ,
c       20            21           22           23           24  
c     &'AKAONZER' , 'NEUTRIM ' , 'ANEUTRIM' , 'NEUTRIT ' , 'ANEUTRIT' ,
c       25            26           27           28           29 
c     
      subroutine ccos2dpjidp(pj, idp, npmass, npchar)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
c          cosmos code to idp in dpmjet
      record /ptcl/  pj
      integer idp  ! output. dpm code. which can be a projectile
      integer npmass ! ouptut.  projectile code (mass) if pj is
                     ! used as a projectile
      integer npchar ! output. charge in the same meaning as above.

      if(pj.code .eq. kgnuc) then
         idp = 1
         npmass = pj.subcode
         npchar = pj.charge
      else
         npmass = 1
         npchar = 1
         if(pj.code .eq. knuc) then
            if(pj.charge .eq. 1) then
               idp=1
            elseif(pj.charge .eq. 0) then
               if(pj.subcode .eq. antip) then
                  idp = 9
               else
                  idp = 8
               endif
            else
               idp = 2
            endif
         elseif( pj.code .eq. kpion) then
            if(pj.charge .eq. 1) then
               idp = 13
            elseif(pj.charge .eq. -1) then
               idp = 14
            else
               idp = 23
            endif
         elseif( pj.code .eq. kkaon) then
            if(pj.charge .eq. 1) then
               idp = 15
            elseif(pj.charge .eq. -1) then
               idp = 16
            elseif(pj.subcode .lt. 0) then
c                 k0; disregard  short or long but see ptlc or anti
               idp = 24
            else
c                 k0_bar
cccc               idp = 25
               idp = 24   ! tentative setting. k0bar will die easily
            endif
         elseif(pj.code .eq. klambda) then
            if(pj.subcode .eq. antip) then
               idp = 17
            else
               idp = 18
            endif
         elseif(pj.code .eq. kphoton) then
            idp = 7
         elseif(pj.code .eq. ksigma) then
            if(pj.charge .eq. 1) then
               idp = 21
            elseif(pj.charge .eq. -1) then
               idp = 20
            else
               idp = 22
            endif
         else
c              cannot be a projectile
            idp = 0
         endif
      endif
      end
      subroutine cinidpmjet(file)
      implicit none
#include "Zmanagerp.h"

      character*(*)  file  ! input. first input file to initialize
                           ! dpmjet3. 
      
      integer icon
      integer NEVTS,NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,IEMU
      real*8  EPN

      call copenf(TempDev, file, icon)
      if(icon .ne. 0) then
         call cerrorMsg( file, 1)
         call cerrorMsg('above file cannot be opened', 0)
      endif
c          init dpm; Thru this call, input data is read via TempDev
c     Glauber initialization data location is given in that
c     data and the call to cdpmOpen is made from within dpmjet

      CALL DT_DTUINI(NEVTS,EPN,NPMASS,NPCHAR,NTMASS,NTCHAR,IDP,IEMU)

      close(TempDev)

      end
