c      program test_crs_engel
c      implicit doubleprecision(a-h,o-z)
c      character line*80
c      common /crosssection_factor/fact_cross
c      common /prod_ratio/ prodratio
c      if(iargc().lt.1) then
c         stop 'test-crs-engel kin'
c      end if
c      call getarg(1, line)
c      read(line, *) kin
c      fact_cross = 1
c      do i=1, 7*40+1
c         ek = 10.d0**(real(i-1)/40 - 1.d0)
c         crs = crossint(kin, ek)
c         write(*,'(I3,1p,3E13.5)') kin, ek, crs, prodratio
cc         write(*,*) kin, ek, crs
c      enddo
c      end
c
      function crossint(kin0, ek0)
      implicit real*8 (a-h,o-z)
      include '../include/atmnc-particle-code.inc' ! particle code
c      include '../include/int-alphafact.inc' ! crs(alpha)/crs(p)

      real*8 cpa(111),cpba(111), cpip(111),cpim(111), ckp(111),ckm(111)
      common /crosssection_factor/fact_cross
      common /prod_ratio/ prodratio

      common /he_factor/fac_alpha
c      common /lastptl/ kin_save, crs_save

      logical use_orig, first, alpha
      data first/.true./
      data use_orig/.false./
      save

      data (cpa(i),i=1,111)/
     &   0.00,   0.00,   0.00,   0.00,   0.00,   0.27,  16.92,
     &  74.76, 141.83, 199.89, 225.79, 226.03, 230.53, 238.42,
     & 242.21, 243.64, 247.04, 250.48, 252.06, 252.35, 251.93,
     & 250.92, 251.34, 253.57, 254.72, 255.32, 255.94, 255.60,
     & 255.24, 256.41, 256.61, 256.14, 257.44, 258.39, 258.68,
     & 260.14, 261.46, 262.00, 262.48, 262.21, 280.00, 282.39,
     & 284.80, 287.24, 289.69, 292.17, 294.66, 297.18, 299.72,
     & 302.28, 304.87, 307.47, 310.10, 312.75, 315.43, 318.12,
     & 320.84, 323.58, 326.35, 329.14, 331.95, 334.79, 337.65,
     & 340.53, 343.44, 346.38, 349.34, 352.33, 355.34, 358.37,
     & 361.44, 364.53, 367.64, 370.78, 373.95, 377.15, 380.37,
     & 383.62, 386.90, 390.21, 393.54, 396.91, 400.30, 403.72,
     & 407.17, 410.65, 414.16, 417.70, 421.27, 424.87, 428.50,
     & 432.16, 435.86, 439.58, 443.34, 447.13, 450.95, 454.80,
     & 458.69, 462.61, 466.57, 470.55, 474.57, 478.63, 482.72,
     & 486.85, 491.01, 495.20, 499.44, 503.71, 508.01/

      data (cpba(i),i=1,111)/
     &557.681962,532.269572,508.647078,486.721307,466.402982,447.606308,
     &430.248588,414.249893,399.532789,386.022123,373.644862,362.330012,
     &352.008584,342.613618,334.080257,326.345852,319.350094,313.035150,
     &307.345806,302.229591,297.636884,293.520984,289.838159,286.547649,
     &283.611648,280.995240,278.666320,276.595481,269.703518,268.394190,
     &267.957504,267.424865,267.111293,266.996203,267.060928,267.288669,
     &267.664401,268.174752,268.807876,269.553309,275.622107,277.977759,
     &280.353543,282.749633,285.166201,287.603423,290.061475,292.540535,
     &295.040783,297.562399,300.105567,302.670471,305.257296,307.866230,
     &310.497461,313.151181,315.827581,318.526856,321.249200,323.994812,
     &326.763889,329.556632,332.373245,335.213929,338.078893,340.968342,
     &343.882486,346.821537,349.785706,352.775210,355.790264,358.831086,
     &361.897898,364.990920,368.110377,371.256496,374.429503,377.629629,
     &380.857105,384.112166,387.395046,390.705984,394.045220,397.412995,
     &400.809553,404.235141,407.690006,411.174398,414.688570,418.232777,
     &421.807276,425.412324,429.048183,432.715117,436.413391,440.143272,
     &443.905032,447.698943,451.525278,455.384317,459.276337,463.201621,
     &467.160453,471.153119,475.179910,479.241117,483.337033,487.467956,
     &491.634184,495.836020,500.073768/

      data (cpip(i),i=1,111)/
     &  0.000167,  8.447568, 19.082244, 32.470508, 49.325334, 68.779544,
     & 82.662161, 96.857012,107.921815,133.415651,163.655540,188.879829,
     &191.056698,191.211872,191.407146,191.652856,191.961988,192.335402,
     &191.134848,189.618671,187.702248,187.443089,187.116601,186.705218,
     &186.186747,185.696300,185.696300,185.708239,187.010850,188.749643,
     &189.280014,190.230084,191.320201,192.543018,193.891770,195.360216,
     &196.942605,198.641798,201.193821,203.778630,206.396647,209.048300,
     &211.734018,214.454242,223.679018,225.893160,228.148465,230.445701,
     &232.785645,235.169091,237.596850,240.069743,242.588612,245.154309,
     &247.767707,250.429691,253.081269,254.671297,256.290885,257.940584,
     &259.620952,261.332562,263.075992,264.851835,266.660694,268.503182,
     &275.594963,277.950382,280.325933,282.721786,285.138117,287.575098,
     &290.032908,292.511724,295.011726,297.533094,300.076012,302.640663,
     &305.227233,307.835910,310.466882,313.120340,315.796477,318.495486,
     &321.217562,323.962903,326.731707,329.524176,332.340511,335.180916,
     &338.045597,340.934762,343.848619,346.787380,349.751258,352.740467,
     &355.755224,358.795747,361.862256,364.954974,368.074124,371.219933,
     &374.392627,377.592438,380.819597,384.074336,387.356894,390.667506,
     &394.006412,397.373856,400.770079/

      data (cpim(i),i=1,111)/
     &156.497255,157.058434,157.763655,158.649494,163.047285,168.888252,
     &177.379832,208.406306,239.649579,254.886351,258.696224,225.348829,
     &229.943942,238.064657,234.992889,225.388987,223.363617,213.574536,
     &209.469386,207.270729,207.270728,206.857304,206.336313,205.679594,
     &204.851511,203.806902,202.488435,200.834684,199.993818,198.932997,
     &196.802809,197.084881,197.593008,198.332889,199.309392,200.526485,
     &201.987209,203.701638,206.318666,208.969316,211.654021,214.373216,
     &223.614093,225.827028,228.081104,230.377087,232.715755,235.097903,
     &237.524337,239.995883,242.513378,245.077677,247.689650,250.350183,
     &253.034645,254.623806,256.242511,257.891310,259.570763,261.281439,
     &263.023919,264.798794,266.606667,268.448150,275.525541,277.880367,
     &280.255319,282.650570,285.066291,287.502659,289.959850,292.438041,
     &294.937413,297.458146,300.000423,302.564428,305.150347,307.758367,
     &310.388676,313.041466,315.716929,318.415258,321.136648,323.881298,
     &326.649405,329.441170,332.256795,335.096485,337.960444,340.848881,
     &343.762004,346.700025,349.663157,352.651613,355.665610,358.705367,
     &361.771104,364.863043,367.981407,371.126423,374.298319,377.497324,
     &380.723669,383.977589,387.259319,390.569098,393.907163,397.273758,
     &400.669127,404.093514,407.547168/

      data (ckp(i),i=1,111)/
     &  0.000145,  9.386154, 21.202440, 36.078263, 54.805888, 75.132969,
     & 85.090062, 96.857012,102.585136,109.601306,118.161364,122.368860,
     &127.576475,134.001720,138.013064,142.334725,145.407141,149.208396,
     &151.119579,153.510505,156.497257,157.058435,157.763656,158.649496,
     &159.272286,160.049109,161.024703,162.241871,162.979845,163.906799,
     &167.886357,169.893552,171.962212,174.091977,176.282295,178.532490,
     &180.841804,183.208839,185.562589,187.946578,190.361195,192.806834,
     &195.283893,197.792776,200.333891,202.907652,205.514480,208.154798,
     &210.829038,213.537635,216.281030,225.145684,227.387093,229.670173,
     &231.995699,234.364460,236.777259,239.234915,241.738263,244.288151,
     &246.885446,249.531027,252.225794,254.134517,255.744125,257.383659,
     &259.053674,260.754737,262.487424,264.252325,266.050038,267.881173,
     &269.746351,277.157818,279.526595,281.915617,284.325057,286.755090,
     &289.205891,291.677639,294.170512,296.684691,299.220357,301.777695,
     &304.356890,306.958128,309.581599,312.227491,314.895997,317.587309,
     &320.301624,323.039136,325.800046,328.584551,331.392856,334.225161,
     &337.081674,339.962600,342.868149,345.798530,348.753957,351.734642,
     &354.740803,357.772656,360.830421,363.914320,367.024576,370.161414,
     &373.325062,376.515749,379.733705/

      data (ckm(i),i=1,111)/
     &289.629599,286.988484,261.195955,208.026231,174.222890,179.786746,
     &190.773950,207.535943,237.040018,236.382833,234.016555,231.037587,
     &227.784016,225.463811,215.771276,211.087194,205.123906,197.578381,
     &195.882736,193.738750,191.024587,189.307333,187.135571,184.385496,
     &183.779590,183.049061,182.127537,180.969829,180.089108,178.977624,
     &176.960027,177.421740,178.150853,179.145918,180.404982,181.925616,
     &183.704950,185.741875,188.128168,190.545118,192.993120,195.472572,
     &197.983878,200.527449,203.103697,205.713043,208.355913,211.032736,
     &213.743950,216.489996,225.313806,227.558341,229.844605,232.173374,
     &234.545438,236.961602,239.422685,241.929524,244.482968,247.083884,
     &249.733155,252.431680,254.255249,255.867103,257.508923,259.181266,
     &260.884701,262.619805,264.387167,266.187387,268.021075,269.888855,
     &277.336312,279.706614,282.097175,284.508167,286.939764,289.392144,
     &291.865484,294.359962,296.875760,299.413060,301.972045,304.552900,
     &307.155814,309.780974,312.428570,315.098794,317.791840,320.507902,
     &323.247178,326.009866,328.796165,331.606277,334.440407,337.298760,
     &340.181541,343.088961,346.021230,348.978559,351.961164,354.969261,
     &358.003066,361.062801,364.148686,367.260945,370.399804,373.565489,
     &376.758231,379.978259,383.225809/

      prodratio = 1.d0

c      write(*,*) 'crossint', kin, ek

      alpha = .false.
      kin = kin0
      ek = ek0
      if(kin0.eq.kalpha) then   ! calculate from proton crosssection
         alpha = .true.
         kin = kpro
         ek = ek/4
      else if(kin.lt.4.or.kin.gt.14) then
         crossint = 1.d-4
         return
      end if

      if(ek.lt.0.1d0) then
         crossint = 1.d-4
         return
      end if

c      write(*,*) 'use_orig=',use_orig
c      use_orig = .true.
      if(use_orig) then
         elk = (log10(ek) + 1.d0)*10.d0
         ie1 = int(elk)

         dle = elk - real(ie1)
         if(ie1.lt.0) then
            ie1=0
            dle=0.
         else if(ie1.gt.109) then
            ie1 = 109
         end if
         ie1 = ie1 + 1
         
         if(kin.eq.4) then
            crossint = ckp(ie1)*(1.d0 - dle) + ckp(ie1+1)*dle
         else if(kin.eq.5) then
            crossint = ckm(ie1)*(1.d0 - dle) + ckm(ie1+1)*dle
         else if(kin.eq.6 .or. kin.eq.7) then
            cr1 = ckp(ie1)*(1.d0 - dle) + ckp(ie1+1)*dle
            cr2 = ckm(ie1)*(1.d0 - dle) + ckm(ie1+1)*dle
            crossint = (cr1+ cr2)/2
         else if(kin.eq.8 .or. kin.eq.10) then
            crossint = cpa(ie1)*(1.d0 - dle) + cpa(ie1+1)*dle
         else if(kin.eq.9 .or. kin.eq.11) then
            crossint = cpba(ie1)*(1.d0 - dle) + cpba(ie1+1)*dle
         else if(kin.eq.12) then
            crossint = cpip(ie1)*(1.d0 - dle) + cpip(ie1+1)*dle
         else if(kin.eq.13) then
            crossint = cpim(ie1)*(1.d0 - dle) + cpim(ie1+1)*dle
         else if(kin.eq.14) then
            cr1 = cpip(ie1)*(1.d0 - dle) + cpip(ie1+1)*dle
            cr2 = cpim(ie1)*(1.d0 - dle) + cpim(ie1+1)*dle
            crossint = (cr1+ cr2)/2
         end if

         crossint=max(crossint, 1.d-4)
         crossint = fact_cross*crossint

         if(alpha) then  !  factor to he inelastic crs
            crossint = fac_alpha*crossint
         end if
         return
      end if

      if (Ek.gt.1.d6 .or. kin.eq.9 .or. kin.eq.11) then
c           out of engel's crosssection range
         elk = (log10(ek) + 1.d0)*10.d0
         ie1 = int(elk)

         dle = elk - real(ie1)
         if(ie1.lt.0) then
            ie1=0
            dle=0.
         else if(ie1.gt.109) then
            ie1 = 109
         end if
         ie1 = ie1 + 1
         
         if(kin.ge.4 .and. kin.le.7) then
            cr1 = ckp(ie1)*(1.d0 - dle) + ckp(ie1+1)*dle
            cr2 = ckm(ie1)*(1.d0 - dle) + ckm(ie1+1)*dle
            crossint = (cr1+ cr2)/2
         else if(kin.eq.8 .or. kin.eq.10) then
            crossint = cpa(ie1)*(1.d0 - dle) + cpa(ie1+1)*dle
         else if(kin.eq.9 .or. kin.eq.11) then
            crossint = cpba(ie1)*(1.d0 - dle) + cpba(ie1+1)*dle
         else if(kin.ge.12) then
            cr1 = cpip(ie1)*(1.d0 - dle) + cpip(ie1+1)*dle
            cr2 = cpim(ie1)*(1.d0 - dle) + cpim(ie1+1)*dle
            crossint = (cr1+ cr2)/2
         end if

         crossint=max(crossint, 1.d-4)
      else
          if(first) then
            write(0,*) 'use engel crs'
            first=.false.
         end if
         crossint=max(crs_engel(kin, ek, alpha), 1.d-4)
      end if

      crossint = fact_cross*crossint

         if(alpha) then  !  factor to he inelastic crs
c            elk = elk/10
c            fac_alpha = 1.7664633427E+00
c     &        +7.2983641735E-03*ekl - 4.8581785270E-03*ekl**2
            crossint = fac_alpha * crossint
         end if
      end

      function crs_engel(kin, ek, alpha)
      implicit doubleprecision(a-h,o-z)
      dimension ekl_crs(140, 3), val_crs(140, 3), ratio_crs(140, 3)
      common /prod_ratio/ prodratio
      logical alpha
      save

c  cross section E_kinetic, p,n + air
      Data (Ekl_crs(K, 1),K=1,140)/
     &-.100001E+01,-.948917E+00,-.898518E+00,-.848290E+00,-.797051E+00,
     &-.746597E+00,-.697061E+00,-.646266E+00,-.595835E+00,-.545039E+00,
     &-.494297E+00,-.443952E+00,-.393514E+00,-.342678E+00,-.292586E+00,
     &-.242280E+00,-.191690E+00,-.140831E+00,-.906836E-01,-.403034E-01,
     &0.105162E-01,0.608262E-01,0.111474E+00,0.161850E+00,0.212252E+00,
     &0.262805E+00,0.313329E+00,0.363826E+00,0.414231E+00,0.464741E+00,
     &0.515280E+00,0.565737E+00,0.616295E+00,0.666814E+00,0.717228E+00,
     &0.767735E+00,0.818259E+00,0.868747E+00,0.919260E+00,0.969774E+00,
     &0.102025E+01,0.107075E+01,0.112126E+01,0.117174E+01,0.122227E+01,
     &0.127275E+01,0.132327E+01,0.137375E+01,0.142426E+01,0.147477E+01,
     &0.152527E+01,0.157577E+01,0.162628E+01,0.167678E+01,0.172728E+01,
     &0.177779E+01,0.182829E+01,0.187879E+01,0.192930E+01,0.197980E+01,
     &0.203031E+01,0.208081E+01,0.213132E+01,0.218182E+01,0.223233E+01,
     &0.228283E+01,0.233334E+01,0.238384E+01,0.243435E+01,0.248485E+01,
     &0.253535E+01,0.258586E+01,0.263637E+01,0.268687E+01,0.273737E+01,
     &0.278788E+01,0.283838E+01,0.288889E+01,0.293939E+01,0.298990E+01,
     &0.304040E+01,0.309091E+01,0.314142E+01,0.319192E+01,0.324242E+01,
     &0.329293E+01,0.334343E+01,0.339394E+01,0.344444E+01,0.349495E+01,
     &0.354545E+01,0.359596E+01,0.364646E+01,0.369697E+01,0.374747E+01,
     &0.379798E+01,0.384848E+01,0.389899E+01,0.394949E+01,0.400000E+01,
     &0.404996E+01,0.409996E+01,0.414996E+01,0.419998E+01,0.424998E+01,
     &0.429999E+01,0.434998E+01,0.439999E+01,0.444999E+01,0.449999E+01,
     &0.454998E+01,0.459999E+01,0.464999E+01,0.469999E+01,0.474999E+01,
     &0.480000E+01,0.485000E+01,0.490000E+01,0.495000E+01,0.500001E+01,
     &0.504999E+01,0.509999E+01,0.514999E+01,0.520000E+01,0.525000E+01,
     &0.530001E+01,0.534999E+01,0.540000E+01,0.545000E+01,0.550000E+01,
     &0.554999E+01,0.560000E+01,0.565000E+01,0.570000E+01,0.575000E+01,
     &0.580000E+01,0.585000E+01,0.590000E+01,0.595000E+01,0.600000E+01/

c  totoal inelastic cross section value for p,n + air
      Data (val_crs(K, 1),K=1,140)/
     &0.335810E+03,0.311180E+03,0.292980E+03,0.281550E+03,0.273590E+03,
     &0.265760E+03,0.257940E+03,0.250700E+03,0.244970E+03,0.241720E+03,
     &0.240610E+03,0.240980E+03,0.243700E+03,0.249070E+03,0.257460E+03,
     &0.268730E+03,0.281720E+03,0.293820E+03,0.302080E+03,0.306390E+03,
     &0.308140E+03,0.309160E+03,0.310020E+03,0.310630E+03,0.310880E+03,
     &0.310330E+03,0.309360E+03,0.308160E+03,0.306790E+03,0.305320E+03,
     &0.303810E+03,0.302380E+03,0.301140E+03,0.300120E+03,0.299270E+03,
     &0.298530E+03,0.297830E+03,0.297070E+03,0.296190E+03,0.295230E+03,
     &0.294220E+03,0.293200E+03,0.292240E+03,0.291380E+03,0.290640E+03,
     &0.290040E+03,0.289570E+03,0.289230E+03,0.289000E+03,0.288880E+03,
     &0.288850E+03,0.288900E+03,0.289000E+03,0.289140E+03,0.289020E+03,
     &0.288740E+03,0.288520E+03,0.288380E+03,0.288310E+03,0.288310E+03,
     &0.288390E+03,0.288540E+03,0.288760E+03,0.289060E+03,0.289430E+03,
     &0.289870E+03,0.290370E+03,0.290940E+03,0.291570E+03,0.292260E+03,
     &0.293010E+03,0.293820E+03,0.294670E+03,0.295570E+03,0.296520E+03,
     &0.297510E+03,0.298540E+03,0.299600E+03,0.300690E+03,0.301810E+03,
     &0.302960E+03,0.304120E+03,0.305300E+03,0.306500E+03,0.307700E+03,
     &0.308910E+03,0.310150E+03,0.311450E+03,0.312770E+03,0.314120E+03,
     &0.315480E+03,0.316870E+03,0.318270E+03,0.319690E+03,0.321130E+03,
     &0.322580E+03,0.324050E+03,0.325530E+03,0.327030E+03,0.328540E+03,
     &0.330061E+03,0.331596E+03,0.333148E+03,0.334718E+03,0.336304E+03,
     &0.337908E+03,0.339529E+03,0.341168E+03,0.342825E+03,0.344501E+03,
     &0.346194E+03,0.347906E+03,0.349637E+03,0.351387E+03,0.353155E+03,
     &0.354944E+03,0.356751E+03,0.358579E+03,0.360426E+03,0.362294E+03,
     &0.364181E+03,0.366089E+03,0.368018E+03,0.369969E+03,0.371940E+03,
     &0.373933E+03,0.375948E+03,0.377984E+03,0.380043E+03,0.382124E+03,
     &0.384228E+03,0.386355E+03,0.388504E+03,0.390678E+03,0.392874E+03,
     &0.395095E+03,0.397341E+03,0.399610E+03,0.401904E+03,0.404224E+03/

c  production cross section value p,n + air
      Data (ratio_crs(K, 1),K=1,140)/
     &0.385933E-01,0.122437E-01,0.201379E-02,-.106553E-02,-.694470E-03,
     &-.451535E-03,-.310150E-03,-.199442E-03,-.122464E-03,-.827404E-04,
     &-.831221E-04,0.585111E-02,0.409520E-01,0.111455E+00,0.214829E+00,
     &0.335690E+00,0.453003E+00,0.545810E+00,0.604939E+00,0.640458E+00,
     &0.664276E+00,0.685923E+00,0.707116E+00,0.726942E+00,0.744339E+00,
     &0.758966E+00,0.771496E+00,0.782451E+00,0.792171E+00,0.800897E+00,
     &0.809058E+00,0.816886E+00,0.824533E+00,0.832034E+00,0.839242E+00,
     &0.845945E+00,0.851996E+00,0.857340E+00,0.861879E+00,0.865766E+00,
     &0.869112E+00,0.872067E+00,0.874726E+00,0.877274E+00,0.879783E+00,
     &0.882292E+00,0.884829E+00,0.887391E+00,0.889931E+00,0.892412E+00,
     &0.894824E+00,0.897127E+00,0.899239E+00,0.901155E+00,0.898069E+00,
     &0.899252E+00,0.900458E+00,0.901554E+00,0.902605E+00,0.903645E+00,
     &0.904574E+00,0.905524E+00,0.906393E+00,0.907182E+00,0.907957E+00,
     &0.908683E+00,0.909357E+00,0.909981E+00,0.910588E+00,0.911141E+00,
     &0.911641E+00,0.912089E+00,0.912512E+00,0.912948E+00,0.913294E+00,
     &0.913616E+00,0.913881E+00,0.914186E+00,0.914430E+00,0.914648E+00,
     &0.914807E+00,0.915001E+00,0.915133E+00,0.915237E+00,0.915372E+00,
     &0.915445E+00,0.915557E+00,0.915620E+00,0.915689E+00,0.915733E+00,
     &0.915811E+00,0.915865E+00,0.915920E+00,0.915950E+00,0.916015E+00,
     &0.916052E+00,0.916093E+00,0.916137E+00,0.916185E+00,0.916235E+00,
     &0.916264E+00,0.916302E+00,0.916334E+00,0.916365E+00,0.916400E+00,
     &0.916427E+00,0.916455E+00,0.916481E+00,0.916506E+00,0.916529E+00,
     &0.916550E+00,0.916569E+00,0.916585E+00,0.916599E+00,0.916615E+00,
     &0.916626E+00,0.916639E+00,0.916646E+00,0.916651E+00,0.916659E+00,
     &0.916662E+00,0.916665E+00,0.916664E+00,0.916661E+00,0.916659E+00,
     &0.916654E+00,0.916645E+00,0.916639E+00,0.916628E+00,0.916616E+00,
     &0.916602E+00,0.916584E+00,0.916570E+00,0.916550E+00,0.916530E+00,
     &0.916509E+00,0.916482E+00,0.916459E+00,0.916430E+00,0.916400E+00/

c cross section e_kinetic pi + air
      Data (Ekl_crs(K, 2),K=1,140)/
     &-.100001E+01,-.948539E+00,-.899447E+00,-.849161E+00,-.798458E+00,
     &-.747951E+00,-.696130E+00,-.645674E+00,-.596754E+00,-.545117E+00,
     &-.494674E+00,-.444482E+00,-.393978E+00,-.343808E+00,-.292761E+00,
     &-.242416E+00,-.191805E+00,-.141575E+00,-.911211E-01,-.406032E-01,
     &0.102279E-01,0.607016E-01,0.111010E+00,0.161539E+00,0.212172E+00,
     &0.262541E+00,0.313207E+00,0.363689E+00,0.414136E+00,0.464582E+00,
     &0.515116E+00,0.565609E+00,0.616130E+00,0.666656E+00,0.717192E+00,
     &0.767679E+00,0.818152E+00,0.868687E+00,0.919213E+00,0.969717E+00,
     &0.102021E+01,0.107071E+01,0.112121E+01,0.117173E+01,0.122222E+01,
     &0.127272E+01,0.132323E+01,0.137374E+01,0.142424E+01,0.147475E+01,
     &0.152525E+01,0.157576E+01,0.162627E+01,0.167676E+01,0.172727E+01,
     &0.177778E+01,0.182828E+01,0.187879E+01,0.192929E+01,0.197980E+01,
     &0.203030E+01,0.208081E+01,0.213131E+01,0.218182E+01,0.223232E+01,
     &0.228283E+01,0.233333E+01,0.238384E+01,0.243434E+01,0.248485E+01,
     &0.253535E+01,0.258586E+01,0.263636E+01,0.268687E+01,0.273737E+01,
     &0.278788E+01,0.283838E+01,0.288889E+01,0.293939E+01,0.298990E+01,
     &0.304040E+01,0.309091E+01,0.314142E+01,0.319192E+01,0.324242E+01,
     &0.329293E+01,0.334343E+01,0.339394E+01,0.344444E+01,0.349495E+01,
     &0.354545E+01,0.359596E+01,0.364646E+01,0.369697E+01,0.374747E+01,
     &0.379798E+01,0.384848E+01,0.389899E+01,0.394949E+01,0.400000E+01,
     &0.404999E+01,0.409999E+01,0.414999E+01,0.420000E+01,0.425000E+01,
     &0.430001E+01,0.434999E+01,0.440000E+01,0.445000E+01,0.450000E+01,
     &0.454999E+01,0.460000E+01,0.465000E+01,0.470000E+01,0.475000E+01,
     &0.480000E+01,0.485000E+01,0.490000E+01,0.495000E+01,0.500002E+01,
     &0.504999E+01,0.509999E+01,0.514999E+01,0.520000E+01,0.525001E+01,
     &0.530001E+01,0.535000E+01,0.540000E+01,0.545000E+01,0.550000E+01,
     &0.555000E+01,0.560000E+01,0.565000E+01,0.570000E+01,0.575000E+01,
     &0.580000E+01,0.585000E+01,0.590000E+01,0.595000E+01,0.600000E+01/

c cross section value pi + air
      Data (val_crs(K, 2),K=1,140)/
     &0.109610E+03,0.151740E+03,0.212910E+03,0.252620E+03,0.269950E+03,
     &0.263300E+03,0.221240E+03,0.161210E+03,0.143630E+03,0.500370E+03,
     &0.118430E+03,0.105890E+03,0.106750E+03,0.111570E+03,0.115240E+03,
     &0.161080E+03,0.163210E+03,0.165010E+03,0.202020E+03,0.201460E+03,
     &0.179150E+03,0.200680E+03,0.226700E+03,0.216500E+03,0.212160E+03,
     &0.216150E+03,0.223040E+03,0.228660E+03,0.229300E+03,0.226210E+03,
     &0.224250E+03,0.222980E+03,0.220820E+03,0.217550E+03,0.214230E+03,
     &0.211600E+03,0.209900E+03,0.208720E+03,0.207630E+03,0.206300E+03,
     &0.204690E+03,0.202890E+03,0.201170E+03,0.199970E+03,0.199590E+03,
     &0.199790E+03,0.200220E+03,0.200510E+03,0.200570E+03,0.200450E+03,
     &0.200240E+03,0.200020E+03,0.199790E+03,0.199520E+03,0.199540E+03,
     &0.199590E+03,0.199700E+03,0.199860E+03,0.200080E+03,0.200350E+03,
     &0.200670E+03,0.201050E+03,0.201480E+03,0.201960E+03,0.202480E+03,
     &0.203060E+03,0.203680E+03,0.204340E+03,0.205050E+03,0.205790E+03,
     &0.206560E+03,0.207210E+03,0.207860E+03,0.208540E+03,0.209250E+03,
     &0.209990E+03,0.210760E+03,0.211560E+03,0.212380E+03,0.213230E+03,
     &0.214110E+03,0.215010E+03,0.215940E+03,0.216880E+03,0.217850E+03,
     &0.218830E+03,0.219840E+03,0.220860E+03,0.221900E+03,0.222950E+03,
     &0.224020E+03,0.225110E+03,0.226210E+03,0.227330E+03,0.228460E+03,
     &0.229600E+03,0.230750E+03,0.231910E+03,0.233090E+03,0.234280E+03,
     &0.235520E+03,0.236740E+03,0.237980E+03,0.239240E+03,0.240510E+03,
     &0.241790E+03,0.243090E+03,0.244410E+03,0.245740E+03,0.247090E+03,
     &0.248450E+03,0.249830E+03,0.251220E+03,0.252630E+03,0.254060E+03,
     &0.255500E+03,0.256950E+03,0.258420E+03,0.259910E+03,0.261410E+03,
     &0.262920E+03,0.264450E+03,0.266000E+03,0.267560E+03,0.269140E+03,
     &0.270730E+03,0.272340E+03,0.273960E+03,0.275600E+03,0.277260E+03,
     &0.278930E+03,0.280610E+03,0.282310E+03,0.284030E+03,0.285760E+03,
     &0.287500E+03,0.289270E+03,0.291040E+03,0.292830E+03,0.294640E+03/

      Data (ratio_crs(K, 2),K=1,140)/140*1.d0/

c    cross section ek k + air
      Data (Ekl_crs(K, 3),K=1,140)/
     &-.100001E+01,-.950546E+00,-.898679E+00,-.848600E+00,-.798480E+00,
     &-.747018E+00,-.696398E+00,-.646813E+00,-.595834E+00,-.545367E+00,
     &-.494637E+00,-.444144E+00,-.394281E+00,-.343707E+00,-.293076E+00,
     &-.242221E+00,-.191712E+00,-.141421E+00,-.908153E-01,-.405112E-01,
     &0.102448E-01,0.607734E-01,0.111236E+00,0.161676E+00,0.212057E+00,
     &0.262537E+00,0.313141E+00,0.363636E+00,0.414142E+00,0.464677E+00,
     &0.515185E+00,0.565686E+00,0.616133E+00,0.666622E+00,0.717147E+00,
     &0.767641E+00,0.818198E+00,0.868691E+00,0.919193E+00,0.969683E+00,
     &0.102021E+01,0.107071E+01,0.112121E+01,0.117171E+01,0.122223E+01,
     &0.127274E+01,0.132323E+01,0.137375E+01,0.142424E+01,0.147474E+01,
     &0.152525E+01,0.157576E+01,0.162626E+01,0.167677E+01,0.172727E+01,
     &0.177778E+01,0.182828E+01,0.187879E+01,0.192929E+01,0.197980E+01,
     &0.203030E+01,0.208081E+01,0.213131E+01,0.218182E+01,0.223232E+01,
     &0.228283E+01,0.233333E+01,0.238384E+01,0.243434E+01,0.248485E+01,
     &0.253535E+01,0.258586E+01,0.263636E+01,0.268687E+01,0.273737E+01,
     &0.278788E+01,0.283838E+01,0.288889E+01,0.293939E+01,0.298990E+01,
     &0.304040E+01,0.309091E+01,0.314142E+01,0.319192E+01,0.324242E+01,
     &0.329293E+01,0.334343E+01,0.339394E+01,0.344444E+01,0.349495E+01,
     &0.354545E+01,0.359596E+01,0.364646E+01,0.369697E+01,0.374747E+01,
     &0.379798E+01,0.384848E+01,0.389899E+01,0.394949E+01,0.400000E+01,
     &0.404997E+01,0.409997E+01,0.414997E+01,0.419999E+01,0.424999E+01,
     &0.430000E+01,0.434999E+01,0.439999E+01,0.444999E+01,0.450000E+01,
     &0.454999E+01,0.460000E+01,0.464999E+01,0.470000E+01,0.475000E+01,
     &0.480000E+01,0.485000E+01,0.490000E+01,0.495000E+01,0.500001E+01,
     &0.504999E+01,0.509999E+01,0.514999E+01,0.520000E+01,0.525001E+01,
     &0.530001E+01,0.535000E+01,0.540000E+01,0.545000E+01,0.550000E+01,
     &0.555000E+01,0.560000E+01,0.565000E+01,0.570000E+01,0.575000E+01,
     &0.580000E+01,0.585000E+01,0.590000E+01,0.595000E+01,0.600000E+01/

c    crosssection value kc + air
      Data (val_crs(K, 3),K=1,140)/
     &0.185690E+03,0.228950E+03,0.220100E+03,0.205770E+03,0.152500E+03,
     &0.159770E+03,0.132680E+03,0.125170E+03,0.123780E+03,0.118260E+03,
     &0.114110E+03,0.115160E+03,0.124380E+03,0.125740E+03,0.131700E+03,
     &0.145630E+03,0.171000E+03,0.180330E+03,0.157470E+03,0.155290E+03,
     &0.168620E+03,0.179570E+03,0.180100E+03,0.176710E+03,0.173800E+03,
     &0.182500E+03,0.181850E+03,0.179460E+03,0.181230E+03,0.184610E+03,
     &0.185630E+03,0.182040E+03,0.180240E+03,0.179770E+03,0.179060E+03,
     &0.178820E+03,0.179100E+03,0.178860E+03,0.177930E+03,0.176630E+03,
     &0.175350E+03,0.174380E+03,0.173860E+03,0.173690E+03,0.173730E+03,
     &0.173820E+03,0.173830E+03,0.173730E+03,0.173600E+03,0.173560E+03,
     &0.173700E+03,0.174100E+03,0.174650E+03,0.175250E+03,0.175880E+03,
     &0.176340E+03,0.176850E+03,0.177400E+03,0.177990E+03,0.178630E+03,
     &0.179310E+03,0.180040E+03,0.180790E+03,0.181590E+03,0.182420E+03,
     &0.183280E+03,0.184170E+03,0.185090E+03,0.186040E+03,0.187010E+03,
     &0.187880E+03,0.188750E+03,0.189640E+03,0.190550E+03,0.191490E+03,
     &0.192440E+03,0.193410E+03,0.194400E+03,0.195400E+03,0.196420E+03,
     &0.197450E+03,0.198500E+03,0.199560E+03,0.200640E+03,0.201730E+03,
     &0.202820E+03,0.203940E+03,0.205060E+03,0.206190E+03,0.207330E+03,
     &0.208490E+03,0.209650E+03,0.210820E+03,0.212000E+03,0.213190E+03,
     &0.214390E+03,0.215590E+03,0.216800E+03,0.218020E+03,0.219250E+03,
     &0.220500E+03,0.221740E+03,0.222990E+03,0.224260E+03,0.225530E+03,
     &0.226810E+03,0.228100E+03,0.229400E+03,0.230710E+03,0.232030E+03,
     &0.233360E+03,0.234700E+03,0.236050E+03,0.237410E+03,0.238770E+03,
     &0.240150E+03,0.241540E+03,0.242930E+03,0.244340E+03,0.245750E+03,
     &0.247180E+03,0.248610E+03,0.250050E+03,0.251510E+03,0.252970E+03,
     &0.254440E+03,0.255920E+03,0.257410E+03,0.258910E+03,0.260420E+03,
     &0.261940E+03,0.263470E+03,0.265010E+03,0.266560E+03,0.268120E+03,
     &0.269690E+03,0.271260E+03,0.272850E+03,0.274440E+03,0.276050E+03/

      Data (ratio_crs(K, 3),K=1,140)/140*1.d0/

      if(kin.eq.8 .or. kin.eq.10) then
         kk = 1
      else if(kin.ge.12 .and. kin.le.14) then
         kk = 2
      else if(kin.ge.4 .and. kin.le.7) then
         kk = 3
      else
         crs_engel = 1.d-4
         return
      end if

      ekl = log10(ek)

      ie1 = 1
      ie2 = 140
      do while (ie2.gt.ie1+1)
         ie3 = (ie1 + ie2)/2

         if(ekl_crs(ie3, kk).gt.ekl) then
            ie2 = ie3
         else
            ie1 = ie3
         end if
      enddo

      crs_e = ( val_crs(ie1,kk)*(ekl_crs(ie2,kk)-ekl) 
     &     + val_crs(ie2,kk)*(ekl-ekl_crs(ie1,kk)) )
     &     / (ekl_crs(ie2,kk)-ekl_crs(ie1,kk))

      prodr = ( ratio_crs(ie1,kk)*(ekl_crs(ie2,kk)-ekl) 
     &     + ratio_crs(ie2,kk)*(ekl-ekl_crs(ie1,kk)) )
     &     / (ekl_crs(ie2,kk)-ekl_crs(ie1,kk))

      if(kk.eq.1) then
c model03
c         crs_prd = crs_e*prodr
c         prodratio=0.9d0
c         crs_engel = crs_prd
c model02
         crs_prd = crs_e*prodr
         crs_tmp = crs_e * 0.8
         crs_engel = max(crs_prd, crs_tmp)
         if(crs_engel.lt.1e-6) then
            prodratio = 1.d0
         else
            prodratio = crs_prd/crs_engel
         end if
      else
         crs_engel = crs_e
         prodratio = prodr
      end if

cc model01
c      if(kk.eq.1) then
c         crs_engel = 0.9164d0*crs_e
c         prodratio = crs_e*prodr/crs_engel
c      else
c         crs_engel = crs_e
c         prodratio = prodr
c      end if
cc model00
c      crs_engel = crs_engel*prodratio
c      prodratio = 1.d0
      end
