c        test  cnkg and cmnkg
c
c      real*8 cnkg, s, r 
c      s = 0.4
c      do while (s .lt. 1.8)
c         r = 0.01
c         do while (r .lt. 50.)
c            write(*, *) sngl(r), sngl(cnkg(s, r))
c            r = r * 10.**0.1
c         enddo
c         write(*, *)
c         s = s + 0.2
c      enddo
c      end
c      
c      *****************************************************************
c      *                                                               *
c      * cnkg: lateral distribution of electrons by Greisen's formula  *
c      *                                                               *
c      *****************************************************************
c
c  It is not recomended to use cnkg as it is, because it give too wide
c  lateral distribution. You must use about 1/2 Moliere Unit to get
c  rather good distribution.  
c         

c
c    (time: if don't use polynomial approximation, it will be 1.9 times)
c
       real*8 function cnkg(s, r)
       implicit none
       real*8 s ! input.  age of shower (one dimensional age)
       real*8 r ! input.  distance from the center of shower. in moliere unit
c      function value.  normalized number of electrons /(m.u)**2
                  !  (integral (nkg)*2pir*dr from 0 to infinity = 1 )
c                     if s <=0 or  s > 2.25, rho=0 is put

c
       real*8 cnkgcs
c
       if(s .gt. 0.  .and. s .lt. 2.25) then
           cnkg = r**(s-2.) * (1.+r)**(s-4.5) * cnkgcs(s)
       else
           cnkg = 0.
       endif
       end
       real*8 function cnkgcs(s)
       implicit none
c      parameter (pi=3.1415, tpii=1./pi/2.)
c          csnkg=gma(4.5 - s)
c    *     /gma(s)/gma(4.5-s*2)  * tpii
c          polynom approx.
c             better than .05 % except s<.15 or s>2.0
       real*8 s
       real*8 temp
           temp = (((((((-.4315466e-01*s+0.2827905 )*s-.5464292 )*s+
     *     .1768150 )*s+0.1253462 )*s+0.1909647 )*s+0.2234282 )*s-
     *     .1260477e-01)*s+0.7873029e-03
           cnkgcs = temp/s
       end
c      *****************************************************************
c      *                                                               *
c      * cmnkg: lateral distribution of electrons by pair electrons    *
c      *       created by m.c                                          *
c      *                                                               *
c      *****************************************************************
c
c

c
c -- output --
c
c  *** note ***
c   if s < 0.6 or  s > 2, nkg is used.
c   for 10000 call's in the mnkg region, 181 msec is needed on m380.
c   if polynomial approx for r0,rx,cs are not used, it becomes 400
c   msec.
c
      real*8 function cmnkg(s, r)
      implicit none
      real*8 s  ! input. 1 dim age.
      real*8 r  ! input.  distance from the center of shower. in moliere unit
c
c     function value:  normalized number of electrons /(m.u)**2
c           (integral (rho)*2pir*dr from 0 to infinity = 1 )
      
       real*8 a, b, r0, cs
c
       call cmnkgcs(s, a, b, r0, cs)
       cmnkg = (r/r0)**(s-a) * (1.+r/r0)**(s-b) *cs
       end
c      ************************
       subroutine cmnkgcs(s, a, b, r0, cs)
       implicit none
       real*8 s, a, b, r0, cs
c
       real*8 cnkgcs, rx

       if(s .lt. .6  .or. s .gt. 2.) then
c            use nkg
           cs = cnkgcs(s)
           a = 2.
           b = 4.5
           r0 = 1.
       else
c          tmp=(-3.309*log10(s) - .285)*log10(s) - .249
c          r0=10.**tmp
c             .1 %  approx of r0 at s=(.4-2.0).
           r0=(((((((0.2272372 *s-2.547489 )*s+ 12.33055 )*s-
     *       33.50755)*s+ 55.33528  )*s-55.46729  )*s+ 30.93687 )*s-
     *       7.405076  )*s+0.6610533
c              this give too large lateral for small s
c          rx=.29* s**1.415/r0
c          rx for m.c lateral (s=.4 to 2.) good within .2 %)
c         rx=((((((-.3179712    *s+ 2.959941    )*s-11.47338    )*s+
c    *    24.40712)*s-30.39885    )*s+ 22.81418    )*s-9.357027    )*s+
c    *    1.880529
c
c             corrected one. rx=.29*s**(1.40+.1/s**4)/r0 (s=.5 to 2.)
           rx=(((((-.3310270 *s+ 2.953910)*s-10.35767)*s+
     *     19.40102 )*s-19.71657 )*s+ 10.79047 )*s-2.225853
           a=-.21*s + 2.146
           b= (2*s+2.-a) + (s+2.-a)/rx
c
c          cs=gma(b-s)/gma(s+2.-a)/gma(a+b-2.-s*2)*tpii / r0**2
c           cs*s for m.c lateral (good at s=.4 to 2 within .3 %)
          cs=((((((-.9450091    *s+ 8.993343    )*s-35.02486    )*s+
     *    71.67270)*s-82.55823    )*s+ 56.46587    )*s-21.05954    )*s
     *    + 3.595105
          cs = cs/s
       endif
       end
