      subroutine cmuInte
      implicit none
#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zcode.h"
      
      real*8 Et
      character*80 msg

      if( IntInfArray(ProcessNo).process .eq. 'mupair' ) then
         call cmuPrsmpE(MovedTrack.p.fm.p(4),  Et)
         MovedTrack.p.fm.p(4) = MovedTrack.p.fm.p(4) - Et  ! muon
         call ce2p(MovedTrack)         ! adjust momentum
         call cpush(MovedTrack)        ! push
         if(MuPr .eq. 3) then
c              generate pair electrons; employ eppair
c              to do so, make MovedTrack a gamma of energy Et
            MovedTrack.p.fm.p(4) = Et
            MovedTrack.p.code = kphoton  ! this and next
            call ce2p(MovedTrack)       ! are not needed ; for safety
            call cpair
         endif
      elseif(IntInfArray(ProcessNo).process .eq.'mubrem' ) then   
         call cmuBrsmpE(MovedTrack.p.fm.p(4),  Et)
         MovedTrack.p.fm.p(4) = MovedTrack.p.fm.p(4) - Et  ! muon
         call ce2p(MovedTrack)         ! adjust momentum
         call cpush(MovedTrack)        ! push
         if(MuBr .eq. 3) then
c             generate brems gamma; no deflection
            MovedTrack.p.fm.p(4) = Et
            MovedTrack.p.code = kphoton
            call ce2p(MovedTrack)  ! adjust momentum
            call cpush(MovedTrack) ! push
         endif
      elseif(IntInfArray(ProcessNo).process .eq.'munuci' ) then 
         call cmuNsmpE(MovedTrack.p.fm.p(4),  Et)
         MovedTrack.p.fm.p(4) = MovedTrack.p.fm.p(4) - Et  ! muon
         call ce2p(MovedTrack)         ! adjust momentum
         call cpush(MovedTrack)        ! push
         if(MuNI .eq. 3 .and. Et .gt. 150.d-3) then
c             generate gamma-N interaction; employ gamma interaction
c             routine 
            MovedTrack.p.fm.p(4) = Et
            MovedTrack.p.code = kphoton
            call ce2p(MovedTrack)  ! adjust momentum
            call cphotop 
         endif
      else
         write(msg, *) ' in cinteMuon: process=',
     *        IntInfArray(ProcessNo).process,
     *        ' undef. ProcessNo=',ProcessNo
         call cerrorMsg(msg, 0)
      endif   
      end
