c      real*8 xai,  x, ans
c      read(*,*) xai
c      x = 0.001d0
c      do while  (x .lt. 1.d0)
cc             devide by xai: xsection is to be divided by Eg/m
cc          but if B is const, xai ~ Eg/m so, to see the
cc        cross-section within a moderate range, we use xai division
cc         
c         ans = cmPairSpec(xai, x)/xai
c         write(*, *) sngl(x), sngl(ans)
c         x = x + 0.001d0
c      enddo
c      end
      real*8 function cmPairSpec(xai, x)
      implicit none
c         This computes electron energy distribution function
c      The value dose not contain the coefficient which is
c      SyncCoef/(3Piroot(3))/Eg -->unit is  /m
      real*8 xai  ! input. Earger's (1966) xai = Eg/m * B/Bc/2
      real*8 x    ! input. Fractional electron energy. Ee/Eg
c
      real*8 y, v, ck23

      if(x .eq. 1. .or. x .eq. 0.) then
         cmPairSpec = 0.
      else
         v = 1. - 2*x
         y = 4./(3.*xai) /(1.-v**2)
         cmPairSpec = (9.- v*v)/(1.-v*v) * ck23(y)
      endif
      end

