      subroutine catmosCnst1

c   catmosCnst1:  compute some basic constants
c      a,  b,  d0, cum, H
c where
c     a, b; const shown below
c       d0: see the formula below.
c     cumd: amount of atmospher above the node.
c        H: scale height at the node
c     all in mks unit.
c
c     The scale height is approximated by a
c   number of stright lines as a function of height. The data in
c   stdatmos1.d gives height, temperatur, etc at  each nodal point.
c
c         The scale height, H, is expressed by H = H0 + a(z-z0)
c                                                = kT/mg      
c   in each region.
c   We neglect height dependence of gravitational accelleration g,
c   and the average mass of  air molecules, m.   
c   Since the data table gives T(z)= T0 + b(z-z0) at the nodal points, 
c   we can first get b,
c   and then a by a = dH/dz = k/mg * b.  H at a nodal point, z,  
c   is obtained as H(z) =kT(z)/mg.
c
c   The density off a nodal point is given by
c
c              rho = rho0 * (1+ a(z-z0)/H(z0))**(-1-1/a)      (a != 0)
c                  = rho0 * exp(- (z-z0)/H)            (a =0; hence H is const)
c
c   (We employ H(z0) as the scale height in the segment)
c   The amount of air between  given heights, z1 and z2  is by
c
c              d = d0 *(fd(z1) - fd(z2))  where
c         
c            fd(z) = (1+ a(z-z0)/H(z0))**(-1/a)                   (a != 0)
c
c                  =  exp(-(z-z0)/H )                             (a = 0)
c
c   where  d0 = rho0*H(z0)
c
c   If z1=z0,  d becomes
c
c              d= d0 ( 1 - fd(z2))
c
c

c
c    
      implicit none

#include  "Zglobalc.h"
#include  "Zatmos.h"

      integer i

      

      real*8 m, g, k, nuc, c2, kbymg, dtdz
c      m: avrage molecule mass number of air
c      g: gravitational acceleration.
c      k: Boltzman's const.
c     c2: c**2
      parameter( m=14.5d0 *2, nuc =938.3d6, g=9.80665d0, c2=c*c,
     *          k= 8.617d-5, kbymg = k*c2/(m*nuc*g))

      integer nodes

#include  "Zstdatmosf.h"

      nodes = atmos.nodes
      do i = 1, nodes-1
         dtdz = (atmos.T(i+1) - atmos.T(i))/ (atmos.z(i+1) - atmos.z(i))
         atmos.H(i) = kbymg * atmos.T(i)                 ! at atmos.z(i)
         atmos.b(i) = dtdz
         atmos.a(i) = kbymg * atmos.b(i)
         atmos.d0(i) = atmos.rho(i) * atmos.H(i)
c///////////
c        write(0, *)
c     * atmos.z(i), atmos.d0(i), atmos.a(i), atmos.b(i), atmos.H(i)
c////////
      enddo

      atmos.cumd(nodes) =  atmos.rho(nodes) * Hinf   ! put  very small amout

      do i = nodes-1, 1, -1
         if(atmos.a(i) .eq. 0.) then
c              exponential atmosphere
            atmos.cumd(i) = atmos.cumd(i+1) +
     *       atmos.d0(i)*
c     *       (1.0- exp(-(atmos.z(i+1) - atmos.z(i))/atmos.H(i)))
     *       (1.0- fd0(atmos.z(i+1), atmos.z(i), atmos.H(i)))
         else
            atmos.cumd(i) = atmos.cumd(i+1) +
     *        atmos.d0(i)*
     *        (1.0 -
     *          fd1(atmos.z(i+1), atmos.a(i),atmos.z(i), atmos.H(i) ) )

c     *        (1.0+atmos.a(i)*(atmos.z(i+1) -atmos.z(i))/atmos.H(i))
c     *        **(-1./atmos.a(i))
c     *         )
         endif
      enddo
      do i = 1, nodes
c         atmos.logP(i) = log(atmos.P(i))
         atmos.logrho(i) = log(atmos.rho(i))
         atmos.logcumd(i) = log(atmos.cumd(i))
         atmos.logcumdi(atmos.nodes-i+1) = atmos.logcumd(i)
         atmos.logrhoi(atmos.nodes-i+1) = atmos.logrho(i)
         atmos.zi(atmos.nodes-i+1) = atmos.z(i)
      enddo
      end

      subroutine catmosCnst2
c         compute c-spline coef. for later use
      implicit none
#include "Zatmos.h"

      integer  nodes
      
      nodes = atmos.nodes
c                           height--> rho
      call kcsplCoef(atmos.z, atmos.logrho, nodes, atmos.coefh2r,
     *      maxnodes)
c                           height--> log(depth)
      call kcsplCoef(atmos.z, atmos.logcumd, nodes, atmos.coefh2d,
     *      maxnodes)
c                           h--> log(P)
c      call kcsplCoef(atmos.z, atmos.logP, nodes, atmos.coefh2P,
c     *      maxnodes)
c                           h--> scale H
      call kcsplCoef(atmos.z, atmos.H, nodes-1, atmos.coefh2H,
     *      maxnodes)
c                           h--> T
      call kcsplCoef(atmos.z, atmos.T, nodes, atmos.coefh2T,
     *      maxnodes)
c                           log(rho)--> h
c      call kcsplCoef(atmos.logrho, atmos.z, nodes, atmos.coefr2h,
c     *      maxnodes)
c                           log(depth)--> h
      call kcsplCoef(atmos.logcumdi, atmos.zi, nodes, atmos.coefd2h,
     *      maxnodes)

c               log(detph) --> log(rho)
      call  kcsplCoef(atmos.logcumdi, atmos.logrhoi, nodes,
     *      atmos.coefd2r, maxnodes)
c                           log(P) --> h 
c      call kcsplCoef(atmos.logP, atmos.z, nodes, atmos.coefP2h,
c     *      maxnodes)

      end
