#   standard atmosphere by cstdatmos0.f which uses the same coefficients 
#   as the main frame one.  d rho/dz is discontinous at z = 11 km.
#   Otheres are continous.   Thickness at z = 20 km  is little bit low
#   as compared to the multi-segmented one.   Density at > 100 km is
#   far less than the multi-segmented one, but no effect for our purpose.
#
#  height m   density(kg/m3)  thickness (kg/m2)
#---------------------------------------------
   -500.000    1.30021    11002.9
   -450.000    1.29396    10938.1
   -400.000    1.28774    10873.5
   -350.000    1.28154    10809.3
   -300.000    1.27536    10745.4
   -250.000    1.26921    10681.8
   -200.000    1.26308    10618.4
   -150.000    1.25697    10555.4
  -100.0000    1.25089   10492.75
   -50.0000    1.24483   10430.35
     0.        1.23879   10368.26
    50.0000    1.23277   10306.47
   100.0000    1.22678   10244.99
    150.000    1.22080   10183.80
    200.000    1.21486   10122.91
    250.000    1.20893   10062.31
    300.000    1.20303   10002.01
    350.000    1.19714    9942.01
    400.000    1.19128    9882.30
    450.000    1.18545    9822.88
    500.000    1.17963    9763.75
    550.000    1.17384    9704.92
    600.000    1.16807    9646.37
    650.000    1.16232    9588.11
    700.000    1.15659    9530.14
    750.000    1.15088    9472.45
    800.000    1.14520    9415.05
    850.000    1.13954    9357.93
    900.000    1.13390    9301.09
    950.000    1.12828    9244.54
   1000.000    1.12268    9188.26
    1050.00    1.11711    9132.27
    1100.00    1.11155    9076.55
    1150.00    1.10602    9021.11
    1200.00    1.10051    8965.95
    1250.00    1.09502    8911.06
    1300.00    1.08955    8856.45
    1350.00    1.08410    8802.11
    1400.00    1.07867    8748.04
    1450.00    1.07327    8694.24
    1500.00    1.06788    8640.71
    1550.00    1.06252    8587.45
    1600.00    1.05717    8534.46
    1650.00    1.05185    8481.73
    1700.00    1.04655    8429.27
    1750.00    1.04127    8377.08
    1800.00    1.03601    8325.15
    1850.00    1.03077    8273.48
    1900.00    1.02555    8222.07
    1950.00    1.02035    8170.92
    2000.00    1.01517    8120.04
    2050.00    1.01001    8069.41
    2100.00    1.00487    8019.03
    2150.00   0.999752    7968.92
    2200.00   0.994654    7919.06
    2250.00   0.989576    7869.45
    2300.00   0.984519    7820.10
    2350.00   0.979481    7771.00
    2400.00   0.974463    7722.15
    2450.00   0.969465    7673.55
    2500.00   0.964487    7625.21
    2550.00   0.959528    7577.11
    2600.00   0.954590    7529.25
    2650.00   0.949671    7481.65
    2700.00   0.944771    7434.29
    2750.00   0.939891    7387.17
    2800.00   0.935031    7340.30
    2850.00   0.930190    7293.67
    2900.00   0.925368    7247.28
    2950.00   0.920566    7201.13
    3000.00   0.915783    7155.22
    3050.00   0.911019    7109.55
    3100.00   0.906274    7064.12
    3150.00   0.901549    7018.92
    3200.00   0.896842    6973.96
    3250.00   0.892155    6929.24
    3300.00   0.887486    6884.75
    3350.00   0.882837    6840.49
    3400.00   0.878206    6796.46
    3450.00   0.873594    6752.67
    3500.00   0.869000    6709.10
    3550.00   0.864426    6665.77
    3600.00   0.859870    6622.66
    3650.00   0.855332    6579.78
    3700.00   0.850813    6537.13
    3750.00   0.846313    6494.70
    3800.00   0.841831    6452.49
    3850.00   0.837367    6410.51
    3900.00   0.832922    6368.76
    3950.00   0.828494    6327.22
    4000.00   0.824085    6285.91
    4050.00   0.819695    6244.81
    4100.00   0.815322    6203.94
    4150.00   0.810967    6163.28
    4200.00   0.806630    6122.84
    4250.00   0.802312    6082.62
    4300.00   0.798011    6042.61
    4350.00   0.793728    6002.82
    4400.00   0.789462    5963.24
    4450.00   0.785215    5923.87
    4500.00   0.780985    5884.71
    4550.00   0.776772    5845.77
    4600.00   0.772578    5807.04
    4650.00   0.768400    5768.51
    4700.00   0.764241    5730.20
    4750.00   0.760098    5692.09
    4800.00   0.755973    5654.19
    4850.00   0.751866    5616.49
    4900.00   0.747775    5579.00
    4950.00   0.743702    5541.71
    5000.00   0.739646    5504.63
    5050.00   0.735607    5467.75
    5100.00   0.731585    5431.07
    5150.00   0.727580    5394.59
    5200.00   0.723592    5358.31
    5250.00   0.719621    5322.23
    5300.00   0.715667    5286.35
    5350.00   0.711730    5250.66
    5400.00   0.707809    5215.17
    5450.00   0.703905    5179.88
    5500.00   0.700018    5144.78
    5550.00   0.696147    5109.88
    5600.00   0.692293    5075.17
    5650.00   0.688455    5040.65
    5700.00   0.684634    5006.32
    5750.00   0.680829    4972.19
    5800.00   0.677041    4938.24
    5850.00   0.673269    4904.48
    5900.00   0.669513    4870.91
    5950.00   0.665773    4837.53
    6000.00   0.662050    4804.33
    6050.00   0.658342    4771.33
    6100.00   0.654651    4738.50
    6150.00   0.650975    4705.86
    6200.00   0.647316    4673.40
    6250.00   0.643673    4641.13
    6300.00   0.640045    4609.04
    6350.00   0.636433    4577.12
    6400.00   0.632837    4545.39
    6450.00   0.629257    4513.84
    6500.00   0.625692    4482.47
    6550.00   0.622143    4451.27
    6600.00   0.618609    4420.25
    6650.00   0.615091    4389.41
    6700.00   0.611589    4358.74
    6750.00   0.608102    4328.25
    6800.00   0.604630    4297.93
    6850.00   0.601173    4267.79
    6900.00   0.597732    4237.81
    6950.00   0.594306    4208.01
    7000.00   0.590896    4178.38
    7050.00   0.587500    4148.92
    7100.00   0.584120    4119.63
    7150.00   0.580754    4090.51
    7200.00   0.577404    4061.56
    7250.00   0.574068    4032.77
    7300.00   0.570748    4004.15
    7350.00   0.567442    3975.70
    7400.00   0.564151    3947.41
    7450.00   0.560875    3919.28
    7500.00   0.557613    3891.32
    7550.00   0.554366    3863.52
    7600.00   0.551134    3835.88
    7650.00   0.547917    3808.40
    7700.00   0.544713    3781.09
    7750.00   0.541525    3753.93
    7800.00   0.538351    3726.94
    7850.00   0.535191    3700.10
    7900.00   0.532045    3673.42
    7950.00   0.528914    3646.89
    8000.00   0.525797    3620.53
    8050.00   0.522695    3594.31
    8100.00   0.519606    3568.26
    8150.00   0.516532    3542.35
    8200.00   0.513471    3516.60
    8250.00   0.510425    3491.00
    8300.00   0.507393    3465.56
    8350.00   0.504374    3440.27
    8400.00   0.501370    3415.12
    8450.00   0.498379    3390.13
    8500.00   0.495402    3365.28
    8550.00   0.492439    3340.59
    8600.00   0.489489    3316.04
    8650.00   0.486554    3291.64
    8700.00   0.483631    3267.38
    8750.00   0.480723    3243.28
    8800.00   0.477828    3219.31
    8850.00   0.474946    3195.49
    8900.00   0.472078    3171.82
    8950.00   0.469223    3148.28
    9000.00   0.466382    3124.89
    9050.00   0.463554    3101.65
    9100.00   0.460739    3078.54
    9150.00   0.457937    3055.57
    9200.00   0.455149    3032.74
    9250.00   0.452373    3010.06
    9300.00   0.449611    2987.51
    9350.00   0.446862    2965.10
    9400.00   0.444126    2942.82
    9450.00   0.441403    2920.68
    9500.00   0.438692    2898.68
    9550.00   0.435995    2876.81
    9600.00   0.433310    2855.08
    9650.00   0.430638    2833.48
    9700.00   0.427979    2812.02
    9750.00   0.425333    2790.68
    9800.00   0.422699    2769.48
    9850.00   0.420078    2748.41
    9900.00   0.417470    2727.47
    9950.00   0.414873    2706.67
   10000.00   0.412290    2685.99
   10050.00   0.409719    2665.44
   10100.00   0.407160    2645.02
   10150.00   0.404614    2624.72
   10200.00   0.402080    2604.55
   10250.00   0.399558    2584.51
   10300.00   0.397048    2564.60
   10350.00   0.394551    2544.81
   10400.00   0.392066    2525.14
   10450.00   0.389593    2505.60
   10500.00   0.387132    2486.18
   10550.00   0.384683    2466.89
    10600.0   0.382246    2447.71
    10650.0   0.379821    2428.66
    10700.0   0.377408    2409.73
    10750.0   0.375006    2390.92
    10800.0   0.372617    2372.23
    10850.0   0.370239    2353.66
    10900.0   0.367873    2335.21
    10950.0   0.365519    2316.87
    11000.0   0.363137    2298.66
    11050.0   0.360280    2280.57
    11100.0   0.357445    2262.63
    11150.0   0.354633    2244.82
    11200.0   0.351843    2227.16
    11250.0   0.349074    2209.64
    11300.0   0.346328    2192.26
    11350.0   0.343603    2175.01
    11400.0   0.340900    2157.89
    11450.0   0.338218    2140.92
    11500.0   0.335557    2124.07
    11550.0   0.332916    2107.36
    11600.0   0.330297    2090.78
    11650.0   0.327698    2074.33
    11700.0   0.325120    2058.01
    11750.0   0.322562    2041.82
    11800.0   0.320024    2025.75
    11850.0   0.317506    2009.82
    11900.0   0.315008    1994.00
    11950.0   0.312530    1978.31
    12000.0   0.310071    1962.75
    12050.0   0.307631    1947.31
    12100.0   0.305211    1931.99
    12150.0   0.302810    1916.79
    12200.0   0.300427    1901.70
    12250.0   0.298064    1886.74
    12300.0   0.295719    1871.90
    12350.0   0.293392    1857.17
    12400.0   0.291084    1842.56
    12450.0   0.288793    1828.06
    12500.0   0.286521    1813.68
    12550.0   0.284267    1799.41
    12600.0   0.282030    1785.25
    12650.0   0.279811    1771.21
    12700.0   0.277610    1757.27
    12750.0   0.275426    1743.44
    12800.0   0.273259    1729.73
    12850.0   0.271109    1716.12
    12900.0   0.268976    1702.62
    12950.0   0.266860    1689.22
    13000.0   0.264760    1675.93
    13050.0   0.262677    1662.74
    13100.0   0.260610    1649.66
    13150.0   0.258560    1636.68
    13200.0   0.256525    1623.81
    13250.0   0.254507    1611.03
    13300.0   0.252505    1598.36
    13350.0   0.250518    1585.78
    13400.0   0.248547    1573.30
    13450.0   0.246592    1560.92
    13500.0   0.244651    1548.64
    13550.0   0.242727    1536.46
    13600.0   0.240817    1524.37
    13650.0   0.238922    1512.38
    13700.0   0.237042    1500.48
    13750.0   0.235177    1488.67
    13800.0   0.233327    1476.96
    13850.0   0.231491    1465.34
    13900.0   0.229670    1453.81
    13950.0   0.227863    1442.37
    14000.0   0.226070    1431.02
    14050.0   0.224292    1419.77
    14100.0   0.222527    1408.60
    14150.0   0.220776    1397.51
    14200.0   0.219039    1386.52
    14250.0   0.217316    1375.61
    14300.0   0.215606    1364.79
    14350.0   0.213910    1354.05
    14400.0   0.212227    1343.39
    14450.0   0.210557    1332.82
    14500.0   0.208900    1322.34
    14550.0   0.207257    1311.93
    14600.0   0.205626    1301.61
    14650.0   0.204008    1291.37
    14700.0   0.202403    1281.21
    14750.0   0.200811    1271.13
    14800.0   0.199231    1261.13
    14850.0   0.197663    1251.21
    14900.0   0.196108    1241.36
    14950.0   0.194565    1231.60
    15000.0   0.193034    1221.91
    15050.0   0.191516    1212.29
    15100.0   0.190009    1202.76
    15150.0   0.188514    1193.29
    15200.0   0.187031    1183.90
    15250.0   0.185559    1174.59
    15300.0   0.184099    1165.35
    15350.0   0.182651    1156.18
    15400.0   0.181214    1147.08
    15450.0   0.179788    1138.06
    15500.0   0.178373    1129.10
    15550.0   0.176970    1120.22
    15600.0   0.175578    1111.41
    15650.0   0.174196    1102.66
    15700.0   0.172826    1093.99
    15750.0   0.171466    1085.38
    15800.0   0.170117    1076.84
    15850.0   0.168778    1068.37
    15900.0   0.167450    1059.96
    15950.0   0.166133    1051.62
    16000.0   0.164826    1043.35
    16050.0   0.163529    1035.14
    16100.0   0.162242    1026.99
    16150.0   0.160966    1018.91
    16200.0   0.159700    1010.90
    16250.0   0.158443   1002.945
    16300.0   0.157196    995.054
    16350.0   0.155960    987.225
    16400.0   0.154733    979.458
    16450.0   0.153515    971.751
    16500.0   0.152307    964.106
    16550.0   0.151109    956.521
    16600.0   0.149920    948.995
    16650.0   0.148741    941.528
    16700.0   0.147570    934.121
    16750.0   0.146409    926.771
    16800.0   0.145257    919.480
    16850.0   0.144115    912.245
    16900.0   0.142981    905.068
    16950.0   0.141856    897.947
    17000.0   0.140740    890.882
    17050.0   0.139632    883.873
    17100.0   0.138534    876.919
    17150.0   0.137444    870.019
    17200.0   0.136362    863.174
    17250.0   0.135290    856.383
    17300.0   0.134225    849.645
    17350.0   0.133169    842.960
    17400.0   0.132121    836.328
    17450.0   0.131082    829.748
    17500.0   0.130051    823.220
    17550.0   0.129027    816.743
    17600.0   0.128012    810.317
    17650.0   0.127005    803.942
    17700.0   0.126006    797.616
    17750.0   0.125014    791.341
    17800.0   0.124031    785.115
    17850.0   0.123055    778.938
    17900.0   0.122087    772.809
    17950.0   0.121126    766.729
    18000.0   0.120173    760.696
    18050.0   0.119228    754.711
    18100.0   0.118290    748.773
    18150.0   0.117359    742.882
    18200.0   0.116436    737.037
    18250.0   0.115520    731.239
    18300.0   0.114611    725.485
    18350.0   0.113709    719.777
    18400.0   0.112814    714.114
    18450.0   0.111927    708.496
    18500.0   0.111046    702.922
    18550.0   0.110172    697.391
    18600.0   0.109306    691.904
    18650.0   0.108446    686.461
    18700.0   0.107592    681.060
    18750.0   0.106746    675.701
    18800.0   0.105906    670.385
    18850.0   0.105073    665.110
    18900.0    1.04246E-01    659.878
    18950.0    1.03426E-01    654.686
    19000.0    1.02612E-01    649.535
    19050.0    1.01805E-01    644.424
    19100.0    1.01004E-01    639.354
    19150.0    1.00209E-01    634.324
    19200.0    9.94207E-02    629.333
    19250.0    9.86385E-02    624.382
    19300.0    9.78624E-02    619.469
    19350.0    9.70925E-02    614.595
    19400.0    9.63286E-02    609.760
    19450.0    9.55707E-02    604.962
    19500.0    9.48188E-02    600.203
    19550.0    9.40727E-02    595.480
    19600.0    9.33326E-02    590.795
    19650.0    9.25983E-02    586.147
    19700.0    9.18697E-02    581.535
    19750.0    9.11469E-02    576.960
    19800.0    9.04298E-02    572.421
    19850.0    8.97183E-02    567.917
    19900.0    8.90124E-02    563.449
    19950.0    8.83121E-02    559.016
    20000.0    8.76173E-02    554.617
    20050.0    8.69279E-02    550.254
    20100.0    8.62440E-02    545.925
    20150.0    8.55655E-02    541.629
    20200.0    8.48923E-02    537.368
    20250.0    8.42243E-02    533.140
    20300.0    8.35617E-02    528.945
    20350.0    8.29042E-02    524.784
    20400.0    8.22520E-02    520.655
    20450.0    8.16048E-02    516.558
    20500.0    8.09628E-02    512.494
    20550.0    8.03258E-02    508.462
    20600.0    7.96938E-02    504.462
    20650.0    7.90668E-02    500.493
    20700.0    7.84447E-02    496.555
    20750.0    7.78275E-02    492.648
    20800.0    7.72152E-02    488.772
    20850.0    7.66077E-02    484.927
    20900.0    7.60049E-02    481.111
    20950.0    7.54069E-02    477.326
    21000.0    7.48137E-02    473.570
    21050.0    7.42250E-02    469.845
    21100.0    7.36411E-02    466.148
    21150.0    7.30617E-02    462.480
    21200.0    7.24868E-02    458.842
    21250.0    7.19165E-02    455.232
    21300.0    7.13507E-02    451.650
    21350.0    7.07893E-02    448.096
    21400.0    7.02324E-02    444.571
    21450.0    6.96798E-02    441.073
    21500.0    6.91316E-02    437.603
    21550.0    6.85877E-02    434.160
    21600.0    6.80480E-02    430.744
    21650.0    6.75126E-02    427.355
    21700.0    6.69815E-02    423.993
    21750.0    6.64545E-02    420.657
    21800.0    6.59316E-02    417.347
    21850.0    6.54129E-02    414.064
    21900.0    6.48982E-02    410.806
    21950.0    6.43876E-02    407.574
    22000.0    6.38810E-02    404.367
    22050.0    6.33784E-02    401.186
    22100.0    6.28798E-02    398.029
    22150.0    6.23851E-02    394.897
    22200.0    6.18942E-02    391.790
    22250.0    6.14073E-02    388.708
    22300.0    6.09241E-02    385.650
    22350.0    6.04448E-02    382.616
    22400.0    5.99692E-02    379.605
    22450.0    5.94974E-02    376.618
    22500.0    5.90293E-02    373.655
    22550.0    5.85649E-02    370.716
    22600.0    5.81041E-02    367.799
    22650.0    5.76469E-02    364.905
    22700.0    5.71934E-02    362.034
    22750.0    5.67434E-02    359.186
    22800.0    5.62969E-02    356.360
    22850.0    5.58540E-02    353.556
    22900.0    5.54146E-02    350.774
    22950.0    5.49786E-02    348.014
    23000.0    5.45460E-02    345.276
    23050.0    5.41169E-02    342.560
    23100.0    5.36911E-02    339.865
    23150.0    5.32687E-02    337.191
    23200.0    5.28495E-02    334.538
    23250.0    5.24337E-02    331.906
    23300.0    5.20212E-02    329.294
    23350.0    5.16119E-02    326.703
    23400.0    5.12058E-02    324.133
    23450.0    5.08030E-02    321.583
    23500.0    5.04033E-02    319.053
    23550.0    5.00067E-02    316.542
    23600.0    4.96133E-02    314.052
    23650.0    4.92229E-02    311.581
    23700.0    4.88356E-02    309.130
    23750.0    4.84514E-02    306.697
    23800.0    4.80702E-02    304.284
    23850.0    4.76920E-02    301.890
    23900.0    4.73168E-02    299.515
    23950.0    4.69445E-02    297.159
    24000.0    4.65751E-02    294.821
    24050.0    4.62087E-02    292.501
    24100.0    4.58451E-02    290.200
    24150.0    4.54844E-02    287.916
    24200.0    4.51266E-02    285.651
    24250.0    4.47715E-02    283.404
    24300.0    4.44193E-02    281.174
    24350.0    4.40698E-02    278.962
    24400.0    4.37231E-02    276.767
    24450.0    4.33791E-02    274.589
    24500.0    4.30378E-02    272.429
    24550.0    4.26991E-02    270.286
    24600.0    4.23632E-02    268.159
    24650.0    4.20299E-02    266.049
    24700.0    4.16992E-02    263.956
    24750.0    4.13711E-02    261.879
    24800.0    4.10456E-02    259.819
    24850.0    4.07227E-02    257.775
    24900.0    4.04023E-02    255.747
    24950.0    4.00844E-02    253.734
    25000.0    3.97690E-02    251.738
    25050.0    3.94562E-02    249.757
    25100.0    3.91457E-02    247.792
    25150.0    3.88377E-02    245.843
    25200.0    3.85322E-02    243.909
    25250.0    3.82290E-02    241.990
    25300.0    3.79282E-02    240.086
    25350.0    3.76298E-02    238.197
    25400.0    3.73338E-02    236.323
    25450.0    3.70400E-02    234.463
    25500.0    3.67486E-02    232.619
    25550.0    3.64595E-02    230.788
    25600.0    3.61726E-02    228.973
    25650.0    3.58880E-02    227.171
    25700.0    3.56057E-02    225.384
    25750.0    3.53255E-02    223.611
    25800.0    3.50476E-02    221.851
    25850.0    3.47718E-02    220.106
    25900.0    3.44983E-02    218.374
    25950.0    3.42268E-02    216.656
    26000.0    3.39575E-02    214.951
    26050.0    3.36904E-02    213.260
    26100.0    3.34253E-02    211.582
    26150.0    3.31623E-02    209.917
    26200.0    3.29014E-02    208.266
    26250.0    3.26425E-02    206.627
    26300.0    3.23857E-02    205.002
    26350.0    3.21309E-02    203.389
    26400.0    3.18781E-02    201.788
    26450.0    3.16273E-02    200.201
    26500.0    3.13785E-02    198.626
    26550.0    3.11316E-02    197.063
    26600.0    3.08867E-02    195.513
    26650.0    3.06436E-02    193.974
    26700.0    3.04026E-02    192.448
    26750.0    3.01634E-02    190.934
    26800.0    2.99260E-02    189.432
    26850.0    2.96906E-02    187.941
    26900.0    2.94570E-02    186.463
    26950.0    2.92252E-02    184.996
    27000.0    2.89953E-02    183.540
    27050.0    2.87672E-02    182.096
    27100.0    2.85408E-02    180.663
    27150.0    2.83163E-02    179.242
    27200.0    2.80935E-02    177.832
    27250.0    2.78724E-02    176.433
    27300.0    2.76532E-02    175.044
    27350.0    2.74356E-02    173.667
    27400.0    2.72197E-02    172.301
    27450.0    2.70056E-02    170.945
    27500.0    2.67931E-02    169.600
    27550.0    2.65823E-02    168.266
    27600.0    2.63731E-02    166.942
    27650.0    2.61657E-02    165.629
    27700.0    2.59598E-02    164.325
    27750.0    2.57555E-02    163.033
    27800.0    2.55529E-02    161.750
    27850.0    2.53519E-02    160.477
    27900.0    2.51524E-02    159.215
    27950.0    2.49545E-02    157.962
    28000.0    2.47582E-02    156.719
    28050.0    2.45634E-02    155.486
    28100.0    2.43701E-02    154.263
    28150.0    2.41784E-02    153.049
    28200.0    2.39881E-02    151.845
    28250.0    2.37994E-02    150.650
    28300.0    2.36122E-02    149.465
    28350.0    2.34264E-02    148.289
    28400.0    2.32421E-02    147.122
    28450.0    2.30592E-02    145.965
    28500.0    2.28778E-02    144.816
    28550.0    2.26978E-02    143.677
    28600.0    2.25192E-02    142.547
    28650.0    2.23420E-02    141.425
    28700.0    2.21662E-02    140.312
    28750.0    2.19918E-02    139.208
    28800.0    2.18188E-02    138.113
    28850.0    2.16472E-02    137.027
    28900.0    2.14768E-02    135.948
    28950.0    2.13079E-02    134.879
    29000.0    2.11402E-02    133.818
    29050.0    2.09739E-02    132.765
    29100.0    2.08089E-02    131.720
    29150.0    2.06452E-02    130.684
    29200.0    2.04827E-02    129.656
    29250.0    2.03216E-02    128.636
    29300.0    2.01617E-02    127.623
    29350.0    2.00031E-02    126.619
    29400.0    1.98457E-02    125.623
    29450.0    1.96895E-02    124.635
    29500.0    1.95346E-02    123.654
    29550.0    1.93809E-02    122.681
    29600.0    1.92284E-02    121.716
    29650.0    1.90772E-02    120.758
    29700.0    1.89271E-02    119.808
    29750.0    1.87782E-02    118.866
    29800.0    1.86304E-02    117.930
    29850.0    1.84838E-02    117.003
    29900.0    1.83384E-02    116.082
    29950.0    1.81941E-02    115.169
    30000.0    1.80510E-02    114.263
    30050.0    1.79090E-02    113.364
    30100.0    1.77680E-02    112.472
    30150.0    1.76283E-02    111.587
    30200.0    1.74896E-02    110.709
    30250.0    1.73520E-02    109.838
    30300.0    1.72154E-02    108.974
    30350.0    1.70800E-02    108.116
    30400.0    1.69456E-02    107.266
    30450.0    1.68123E-02    106.422
    30500.0    1.66800E-02    105.584
    30550.0    1.65488E-02   104.7537
    30600.0    1.64186E-02   103.9295
    30650.0    1.62894E-02   103.1118
    30700.0    1.61612E-02   102.3006
    30750.0    1.60341E-02   101.4957
    30800.0    1.59079E-02   100.6971
    30850.0    1.57828E-02    99.9049
    30900.0    1.56586E-02    99.1189
    30950.0    1.55354E-02    98.3390
    31000.0    1.54132E-02    97.5653
    31050.0    1.52919E-02    96.7977
    31100.0    1.51716E-02    96.0361
    31150.0    1.50522E-02    95.2805
    31200.0    1.49338E-02    94.5309
    31250.0    1.48163E-02    93.7871
    31300.0    1.46997E-02    93.0492
    31350.0    1.45841E-02    92.3171
    31400.0    1.44693E-02    91.5908
    31450.0    1.43555E-02    90.8702
    31500.0    1.42425E-02    90.1552
    31550.0    1.41305E-02    89.4459
    31600.0    1.40193E-02    88.7422
    31650.0    1.39090E-02    88.0440
    31700.0    1.37996E-02    87.3512
    31750.0    1.36910E-02    86.6640
    31800.0    1.35833E-02    85.9821
    31850.0    1.34764E-02    85.3056
    31900.0    1.33704E-02    84.6345
    31950.0    1.32652E-02    83.9686
    32000.0    1.31608E-02    83.3080
    32050.0    1.30573E-02    82.6525
    32100.0    1.29545E-02    82.0022
    32150.0    1.28526E-02    81.3570
    32200.0    1.27515E-02    80.7169
    32250.0    1.26512E-02    80.0819
    32300.0    1.25516E-02    79.4518
    32350.0    1.24529E-02    78.8267
    32400.0    1.23549E-02    78.2065
    32450.0    1.22577E-02    77.5912
    32500.0    1.21613E-02    76.9807
    32550.0    1.20656E-02    76.3751
    32600.0    1.19706E-02    75.7742
    32650.0    1.18765E-02    75.1780
    32700.0    1.17830E-02    74.5865
    32750.0    1.16903E-02    73.9997
    32800.0    1.15983E-02    73.4174
    32850.0    1.15071E-02    72.8398
    32900.0    1.14165E-02    72.2667
    32950.0    1.13267E-02    71.6982
    33000.0    1.12376E-02    71.1340
    33050.0    1.11492E-02    70.5744
    33100.0    1.10615E-02    70.0191
    33150.0    1.09744E-02    69.4682
    33200.0    1.08881E-02    68.9217
    33250.0    1.08024E-02    68.3794
    33300.0    1.07174E-02    67.8414
    33350.0    1.06331E-02    67.3076
    33400.0    1.05495E-02    66.7781
    33450.0    1.04665E-02    66.2527
    33500.0    1.03841E-02    65.7314
    33550.0    1.03024E-02    65.2143
    33600.0    1.02214E-02    64.7012
    33650.0    1.01409E-02    64.1921
    33700.0    1.00611E-02    63.6871
    33750.0    9.98199E-03    63.1860
    33800.0    9.90345E-03    62.6889
    33850.0    9.82554E-03    62.1956
    33900.0    9.74823E-03    61.7063
    33950.0    9.67153E-03    61.2208
    34000.0    9.59544E-03    60.7391
    34050.0    9.51994E-03    60.2613
    34100.0    9.44504E-03    59.7871
    34150.0    9.37073E-03    59.3167
    34200.0    9.29701E-03    58.8500
    34250.0    9.22386E-03    58.3870
    34300.0    9.15129E-03    57.9277
    34350.0    9.07929E-03    57.4719
    34400.0    9.00785E-03    57.0197
    34450.0    8.93698E-03    56.5711
    34500.0    8.86667E-03    56.1260
    34550.0    8.79691E-03    55.6844
    34600.0    8.72769E-03    55.2463
    34650.0    8.65903E-03    54.8116
    34700.0    8.59090E-03    54.3804
    34750.0    8.52331E-03    53.9525
    34800.0    8.45625E-03    53.5281
    34850.0    8.38972E-03    53.1069
    34900.0    8.32371E-03    52.6891
    34950.0    8.25822E-03    52.2745
    35000.0    8.19325E-03    51.8632
    35050.0    8.12878E-03    51.4552
    35100.0    8.06483E-03    51.0504
    35150.0    8.00138E-03    50.6487
    35200.0    7.93842E-03    50.2502
    35250.0    7.87596E-03    49.8549
    35300.0    7.81400E-03    49.4626
    35350.0    7.75252E-03    49.0734
    35400.0    7.69152E-03    48.6873
    35450.0    7.63101E-03    48.3043
    35500.0    7.57097E-03    47.9242
    35550.0    7.51140E-03    47.5472
    35600.0    7.45230E-03    47.1731
    35650.0    7.39367E-03    46.8019
    35700.0    7.33550E-03    46.4337
    35750.0    7.27779E-03    46.0684
    35800.0    7.22053E-03    45.7059
    35850.0    7.16372E-03    45.3463
    35900.0    7.10735E-03    44.9896
    35950.0    7.05143E-03    44.6356
    36000.0    6.99596E-03    44.2844
    36050.0    6.94091E-03    43.9360
    36100.0    6.88630E-03    43.5903
    36150.0    6.83212E-03    43.2473
    36200.0    6.77837E-03    42.9071
    36250.0    6.72504E-03    42.5695
    36300.0    6.67213E-03    42.2346
    36350.0    6.61963E-03    41.9023
    36400.0    6.56755E-03    41.5726
    36450.0    6.51588E-03    41.2455
    36500.0    6.46461E-03    40.9210
    36550.0    6.41375E-03    40.5990
    36600.0    6.36329E-03    40.2796
    36650.0    6.31322E-03    39.9627
    36700.0    6.26355E-03    39.6483
    36750.0    6.21427E-03    39.3363
    36800.0    6.16538E-03    39.0269
    36850.0    6.11687E-03    38.7198
    36900.0    6.06875E-03    38.4152
    36950.0    6.02100E-03    38.1129
    37000.0    5.97363E-03    37.8131
    37050.0    5.92663E-03    37.5156
    37100.0    5.88000E-03    37.2204
    37150.0    5.83374E-03    36.9276
    37200.0    5.78784E-03    36.6370
    37250.0    5.74230E-03    36.3488
    37300.0    5.69712E-03    36.0628
    37350.0    5.65230E-03    35.7790
    37400.0    5.60783E-03    35.4975
    37450.0    5.56371E-03    35.2183
    37500.0    5.51993E-03    34.9412
    37550.0    5.47650E-03    34.6663
    37600.0    5.43341E-03    34.3935
    37650.0    5.39066E-03    34.1229
    37700.0    5.34825E-03    33.8544
    37750.0    5.30617E-03    33.5881
    37800.0    5.26443E-03    33.3238
    37850.0    5.22301E-03    33.0616
    37900.0    5.18191E-03    32.8015
    37950.0    5.14114E-03    32.5434
    38000.0    5.10069E-03    32.2874
    38050.0    5.06056E-03    32.0334
    38100.0    5.02075E-03    31.7813
    38150.0    4.98124E-03    31.5313
    38200.0    4.94205E-03    31.2832
    38250.0    4.90317E-03    31.0371
    38300.0    4.86459E-03    30.7929
    38350.0    4.82632E-03    30.5506
    38400.0    4.78835E-03    30.3102
    38450.0    4.75067E-03    30.0718
    38500.0    4.71330E-03    29.8352
    38550.0    4.67621E-03    29.6004
    38600.0    4.63942E-03    29.3675
    38650.0    4.60292E-03    29.1365
    38700.0    4.56670E-03    28.9072
    38750.0    4.53078E-03    28.6798
    38800.0    4.49513E-03    28.4542
    38850.0    4.45976E-03    28.2303
    38900.0    4.42467E-03    28.0082
    38950.0    4.38986E-03    27.7878
    39000.0    4.35532E-03    27.5692
    39050.0    4.32106E-03    27.3523
    39100.0    4.28706E-03    27.1371
    39150.0    4.25333E-03    26.9236
    39200.0    4.21986E-03    26.7117
    39250.0    4.18666E-03    26.5016
    39300.0    4.15372E-03    26.2931
    39350.0    4.12104E-03    26.0862
    39400.0    4.08862E-03    25.8810
    39450.0    4.05645E-03    25.6773
    39500.0    4.02454E-03    25.4753
    39550.0    3.99287E-03    25.2749
    39600.0    3.96146E-03    25.0760
    39650.0    3.93029E-03    24.8787
    39700.0    3.89937E-03    24.6830
    39750.0    3.86869E-03    24.4888
    39800.0    3.83825E-03    24.2961
    39850.0    3.80805E-03    24.1050
    39900.0    3.77809E-03    23.9153
    39950.0    3.74836E-03    23.7271
    40000.0    3.71887E-03    23.5405
    40050.0    3.68961E-03    23.3553
    40100.0    3.66058E-03    23.1715
    40150.0    3.63178E-03    22.9892
    40200.0    3.60321E-03    22.8083
    40250.0    3.57486E-03    22.6289
    40300.0    3.54673E-03    22.4508
    40350.0    3.51883E-03    22.2742
    40400.0    3.49114E-03    22.0989
    40450.0    3.46368E-03    21.9251
    40500.0    3.43643E-03    21.7526
    40550.0    3.40939E-03    21.5814
    40600.0    3.38256E-03    21.4116
    40650.0    3.35595E-03    21.2432
    40700.0    3.32955E-03    21.0760
    40750.0    3.30335E-03    20.9102
    40800.0    3.27736E-03    20.7457
    40850.0    3.25157E-03    20.5825
    40900.0    3.22599E-03    20.4205
    40950.0    3.20061E-03    20.2599
    41000.0    3.17543E-03    20.1005
    41050.0    3.15045E-03    19.9423
    41100.0    3.12566E-03    19.7854
    41150.0    3.10107E-03    19.6298
    41200.0    3.07667E-03    19.4753
    41250.0    3.05246E-03    19.3221
    41300.0    3.02845E-03    19.1701
    41350.0    3.00462E-03    19.0192
    41400.0    2.98098E-03    18.8696
    41450.0    2.95752E-03    18.7211
    41500.0    2.93426E-03    18.5738
    41550.0    2.91117E-03    18.4277
    41600.0    2.88827E-03    18.2827
    41650.0    2.86554E-03    18.1389
    41700.0    2.84300E-03    17.9962
    41750.0    2.82063E-03    17.8546
    41800.0    2.79844E-03    17.7141
    41850.0    2.77642E-03    17.5747
    41900.0    2.75457E-03    17.4365
    41950.0    2.73290E-03    17.2993
    42000.0    2.71140E-03    17.1632
    42050.0    2.69007E-03    17.0281
    42100.0    2.66890E-03    16.8941
    42150.0    2.64790E-03    16.7612
    42200.0    2.62707E-03    16.6294
    42250.0    2.60640E-03    16.4985
    42300.0    2.58589E-03    16.3687
    42350.0    2.56555E-03    16.2399
    42400.0    2.54536E-03    16.1122
    42450.0    2.52534E-03    15.9854
    42500.0    2.50547E-03    15.8596
    42550.0    2.48576E-03    15.7348
    42600.0    2.46620E-03    15.6110
    42650.0    2.44680E-03    15.4882
    42700.0    2.42754E-03    15.3664
    42750.0    2.40845E-03    15.2455
    42800.0    2.38950E-03    15.1255
    42850.0    2.37070E-03    15.0065
    42900.0    2.35204E-03    14.8884
    42950.0    2.33354E-03    14.7713
    43000.0    2.31518E-03    14.6551
    43050.0    2.29696E-03    14.5398
    43100.0    2.27889E-03    14.4254
    43150.0    2.26096E-03    14.3119
    43200.0    2.24317E-03    14.1993
    43250.0    2.22552E-03    14.0876
    43300.0    2.20801E-03    13.9767
    43350.0    2.19064E-03    13.8668
    43400.0    2.17341E-03    13.7577
    43450.0    2.15631E-03    13.6494
    43500.0    2.13934E-03    13.5420
    43550.0    2.12251E-03    13.4355
    43600.0    2.10581E-03    13.3298
    43650.0    2.08924E-03    13.2249
    43700.0    2.07280E-03    13.1209
    43750.0    2.05650E-03    13.0176
    43800.0    2.04032E-03    12.9152
    43850.0    2.02426E-03    12.8136
    43900.0    2.00834E-03    12.7128
    43950.0    1.99254E-03    12.6128
    44000.0    1.97686E-03    12.5135
    44050.0    1.96131E-03    12.4151
    44100.0    1.94587E-03    12.3174
    44150.0    1.93056E-03    12.2205
    44200.0    1.91538E-03    12.1243
    44250.0    1.90031E-03    12.0289
    44300.0    1.88535E-03    11.9343
    44350.0    1.87052E-03    11.8404
    44400.0    1.85580E-03    11.7472
    44450.0    1.84120E-03    11.6548
    44500.0    1.82672E-03    11.5631
    44550.0    1.81234E-03    11.4721
    44600.0    1.79809E-03    11.3819
    44650.0    1.78394E-03    11.2923
    44700.0    1.76990E-03    11.2035
    44750.0    1.75598E-03    11.1153
    44800.0    1.74216E-03    11.0279
    44850.0    1.72845E-03    10.9411
    44900.0    1.71486E-03    10.8550
    44950.0    1.70136E-03    10.7696
    45000.0    1.68798E-03    10.6849
    45050.0    1.67470E-03    10.6008
    45100.0    1.66152E-03   10.51743
    45150.0    1.64845E-03   10.43468
    45200.0    1.63548E-03   10.35258
    45250.0    1.62261E-03   10.27113
    45300.0    1.60984E-03   10.19032
    45350.0    1.59718E-03   10.11014
    45400.0    1.58461E-03   10.03060
    45450.0    1.57215E-03    9.95168
    45500.0    1.55978E-03    9.87338
    45550.0    1.54750E-03    9.79570
    45600.0    1.53533E-03    9.71863
    45650.0    1.52325E-03    9.64217
    45700.0    1.51126E-03    9.56630
    45750.0    1.49937E-03    9.49104
    45800.0    1.48758E-03    9.41637
    45850.0    1.47587E-03    9.34228
    45900.0    1.46426E-03    9.26878
    45950.0    1.45274E-03    9.19585
    46000.0    1.44131E-03    9.12350
    46050.0    1.42997E-03    9.05172
    46100.0    1.41872E-03    8.98050
    46150.0    1.40756E-03    8.90985
    46200.0    1.39648E-03    8.83975
    46250.0    1.38550E-03    8.77020
    46300.0    1.37460E-03    8.70119
    46350.0    1.36378E-03    8.63274
    46400.0    1.35305E-03    8.56481
    46450.0    1.34241E-03    8.49743
    46500.0    1.33184E-03    8.43057
    46550.0    1.32137E-03    8.36424
    46600.0    1.31097E-03    8.29843
    46650.0    1.30065E-03    8.23314
    46700.0    1.29042E-03    8.16837
    46750.0    1.28027E-03    8.10410
    46800.0    1.27020E-03    8.04034
    46850.0    1.26020E-03    7.97708
    46900.0    1.25029E-03    7.91432
    46950.0    1.24045E-03    7.85205
    47000.0    1.23069E-03    7.79027
    47050.0    1.22101E-03    7.72898
    47100.0    1.21140E-03    7.66817
    47150.0    1.20187E-03    7.60784
    47200.0    1.19241E-03    7.54798
    47250.0    1.18303E-03    7.48860
    47300.0    1.17372E-03    7.42968
    47350.0    1.16449E-03    7.37122
    47400.0    1.15533E-03    7.31323
    47450.0    1.14624E-03    7.25569
    47500.0    1.13722E-03    7.19860
    47550.0    1.12827E-03    7.14196
    47600.0    1.11940E-03    7.08577
    47650.0    1.11059E-03    7.03002
    47700.0    1.10185E-03    6.97471
    47750.0    1.09318E-03    6.91984
    47800.0    1.08458E-03    6.86539
    47850.0    1.07605E-03    6.81138
    47900.0    1.06758E-03    6.75779
    47950.0    1.05918E-03    6.70462
    48000.0    1.05085E-03    6.65187
    48050.0    1.04258E-03    6.59953
    48100.0    1.03438E-03    6.54761
    48150.0    1.02624E-03    6.49609
    48200.0    1.01817E-03    6.44498
    48250.0    1.01015E-03    6.39428
    48300.0    1.00221E-03    6.34397
    48350.0    9.94322E-04    6.29406
    48400.0    9.86498E-04    6.24453
    48450.0    9.78737E-04    6.19540
    48500.0    9.71036E-04    6.14666
    48550.0    9.63397E-04    6.09830
    48600.0    9.55817E-04    6.05032
    48650.0    9.48297E-04    6.00272
    48700.0    9.40836E-04    5.95549
    48750.0    9.33433E-04    5.90863
    48800.0    9.26089E-04    5.86214
    48850.0    9.18803E-04    5.81602
    48900.0    9.11574E-04    5.77026
    48950.0    9.04402E-04    5.72486
    49000.0    8.97286E-04    5.67982
    49050.0    8.90227E-04    5.63513
    49100.0    8.83223E-04    5.59080
    49150.0    8.76274E-04    5.54681
    49200.0    8.69379E-04    5.50317
    49250.0    8.62539E-04    5.45987
    49300.0    8.55753E-04    5.41692
    49350.0    8.49020E-04    5.37430
    49400.0    8.42340E-04    5.33201
    49450.0    8.35713E-04    5.29006
    49500.0    8.29138E-04    5.24844
    49550.0    8.22614E-04    5.20715
    49600.0    8.16142E-04    5.16618
    49650.0    8.09721E-04    5.12553
    49700.0    8.03350E-04    5.08521
    49750.0    7.97029E-04    5.04520
    49800.0    7.90759E-04    5.00550
    49850.0    7.84537E-04    4.96612
    49900.0    7.78364E-04    4.92705
    49950.0    7.72241E-04    4.88828
    50000.0    7.66165E-04    4.84982
    50050.0    7.60137E-04    4.81167
    50100.0    7.54156E-04    4.77381
    50150.0    7.48223E-04    4.73625
    50200.0    7.42336E-04    4.69899
    50250.0    7.36495E-04    4.66201
    50300.0    7.30701E-04    4.62533
    50350.0    7.24952E-04    4.58894
    50400.0    7.19248E-04    4.55284
    50450.0    7.13589E-04    4.51702
    50500.0    7.07975E-04    4.48148
    50550.0    7.02404E-04    4.44622
    50600.0    6.96878E-04    4.41124
    50650.0    6.91395E-04    4.37653
    50700.0    6.85955E-04    4.34210
    50750.0    6.80558E-04    4.30794
    50800.0    6.75204E-04    4.27404
    50850.0    6.69892E-04    4.24041
    50900.0    6.64621E-04    4.20705
    50950.0    6.59392E-04    4.17395
    51000.0    6.54204E-04    4.14111
    51050.0    6.49057E-04    4.10853
    51100.0    6.43950E-04    4.07621
    51150.0    6.38884E-04    4.04413
    51200.0    6.33857E-04    4.01232
    51250.0    6.28870E-04    3.98075
    51300.0    6.23922E-04    3.94943
    51350.0    6.19013E-04    3.91835
    51400.0    6.14143E-04    3.88753
    51450.0    6.09311E-04    3.85694
    51500.0    6.04517E-04    3.82659
    51550.0    5.99761E-04    3.79649
    51600.0    5.95042E-04    3.76662
    51650.0    5.90361E-04    3.73698
    51700.0    5.85716E-04    3.70758
    51750.0    5.81108E-04    3.67841
    51800.0    5.76536E-04    3.64947
    51850.0    5.71999E-04    3.62076
    51900.0    5.67499E-04    3.59227
    51950.0    5.63034E-04    3.56401
    52000.0    5.58604E-04    3.53597
    52050.0    5.54209E-04    3.50815
    52100.0    5.49849E-04    3.48054
    52150.0    5.45523E-04    3.45316
    52200.0    5.41231E-04    3.42599
    52250.0    5.36972E-04    3.39904
    52300.0    5.32748E-04    3.37229
    52350.0    5.28556E-04    3.34576
    52400.0    5.24398E-04    3.31944
    52450.0    5.20272E-04    3.29332
    52500.0    5.16178E-04    3.26741
    52550.0    5.12117E-04    3.24170
    52600.0    5.08088E-04    3.21620
    52650.0    5.04090E-04    3.19089
    52700.0    5.00124E-04    3.16579
    52750.0    4.96190E-04    3.14088
    52800.0    4.92286E-04    3.11617
    52850.0    4.88412E-04    3.09165
    52900.0    4.84570E-04    3.06733
    52950.0    4.80757E-04    3.04319
    53000.0    4.76975E-04    3.01925
    53050.0    4.73222E-04    2.99550
    53100.0    4.69499E-04    2.97193
    53150.0    4.65805E-04    2.94854
    53200.0    4.62140E-04    2.92535
    53250.0    4.58504E-04    2.90233
    53300.0    4.54897E-04    2.87950
    53350.0    4.51318E-04    2.85684
    53400.0    4.47767E-04    2.83436
    53450.0    4.44244E-04    2.81206
    53500.0    4.40749E-04    2.78994
    53550.0    4.37281E-04    2.76799
    53600.0    4.33840E-04    2.74621
    53650.0    4.30427E-04    2.72460
    53700.0    4.27041E-04    2.70317
    53750.0    4.23681E-04    2.68190
    53800.0    4.20347E-04    2.66080
    53850.0    4.17040E-04    2.63986
    53900.0    4.13759E-04    2.61909
    53950.0    4.10504E-04    2.59849
    54000.0    4.07274E-04    2.57804
    54050.0    4.04069E-04    2.55776
    54100.0    4.00890E-04    2.53764
    54150.0    3.97736E-04    2.51767
    54200.0    3.94607E-04    2.49786
    54250.0    3.91502E-04    2.47821
    54300.0    3.88422E-04    2.45871
    54350.0    3.85366E-04    2.43937
    54400.0    3.82334E-04    2.42017
    54450.0    3.79326E-04    2.40113
    54500.0    3.76341E-04    2.38224
    54550.0    3.73380E-04    2.36350
    54600.0    3.70443E-04    2.34490
    54650.0    3.67528E-04    2.32645
    54700.0    3.64637E-04    2.30815
    54750.0    3.61768E-04    2.28999
    54800.0    3.58921E-04    2.27197
    54850.0    3.56097E-04    2.25410
    54900.0    3.53296E-04    2.23636
    54950.0    3.50516E-04    2.21877
    55000.0    3.47758E-04    2.20131
    55050.0    3.45022E-04    2.18399
    55100.0    3.42308E-04    2.16681
    55150.0    3.39614E-04    2.14976
    55200.0    3.36942E-04    2.13285
    55250.0    3.34291E-04    2.11607
    55300.0    3.31661E-04    2.09942
    55350.0    3.29052E-04    2.08290
    55400.0    3.26463E-04    2.06651
    55450.0    3.23894E-04    2.05025
    55500.0    3.21346E-04    2.03412
    55550.0    3.18818E-04    2.01812
    55600.0    3.16309E-04    2.00224
    55650.0    3.13821E-04    1.98649
    55700.0    3.11352E-04    1.97086
    55750.0    3.08902E-04    1.95535
    55800.0    3.06472E-04    1.93997
    55850.0    3.04060E-04    1.92470
    55900.0    3.01668E-04    1.90956
    55950.0    2.99295E-04    1.89454
    56000.0    2.96940E-04    1.87963
    56050.0    2.94604E-04    1.86484
    56100.0    2.92286E-04    1.85017
    56150.0    2.89986E-04    1.83561
    56200.0    2.87705E-04    1.82117
    56250.0    2.85441E-04    1.80684
    56300.0    2.83195E-04    1.79263
    56350.0    2.80967E-04    1.77852
    56400.0    2.78757E-04    1.76453
    56450.0    2.76563E-04    1.75065
    56500.0    2.74387E-04    1.73687
    56550.0    2.72229E-04    1.72321
    56600.0    2.70087E-04    1.70965
    56650.0    2.67962E-04    1.69620
    56700.0    2.65853E-04    1.68285
    56750.0    2.63762E-04    1.66961
    56800.0    2.61687E-04    1.65648
    56850.0    2.59628E-04    1.64344
    56900.0    2.57585E-04    1.63051
    56950.0    2.55558E-04    1.61768
    57000.0    2.53548E-04    1.60496
    57050.0    2.51553E-04    1.59233
    57100.0    2.49574E-04    1.57980
    57150.0    2.47610E-04    1.56737
    57200.0    2.45662E-04    1.55504
    57250.0    2.43729E-04    1.54281
    57300.0    2.41812E-04    1.53067
    57350.0    2.39909E-04    1.51862
    57400.0    2.38021E-04    1.50668
    57450.0    2.36149E-04    1.49482
    57500.0    2.34291E-04    1.48306
    57550.0    2.32447E-04    1.47139
    57600.0    2.30619E-04    1.45982
    57650.0    2.28804E-04    1.44833
    57700.0    2.27004E-04    1.43694
    57750.0    2.25218E-04    1.42563
    57800.0    2.23446E-04    1.41441
    57850.0    2.21688E-04    1.40328
    57900.0    2.19944E-04    1.39224
    57950.0    2.18213E-04    1.38129
    58000.0    2.16496E-04    1.37042
    58050.0    2.14793E-04    1.35964
    58100.0    2.13103E-04    1.34894
    58150.0    2.11426E-04    1.33833
    58200.0    2.09763E-04    1.32780
    58250.0    2.08113E-04    1.31735
    58300.0    2.06475E-04    1.30699
    58350.0    2.04851E-04    1.29671
    58400.0    2.03239E-04    1.28650
    58450.0    2.01640E-04    1.27638
    58500.0    2.00054E-04    1.26634
    58550.0    1.98480E-04    1.25638
    58600.0    1.96918E-04    1.24649
    58650.0    1.95369E-04    1.23668
    58700.0    1.93832E-04    1.22695
    58750.0    1.92307E-04    1.21730
    58800.0    1.90794E-04    1.20772
    58850.0    1.89292E-04    1.19822
    58900.0    1.87803E-04    1.18879
    58950.0    1.86325E-04    1.17944
    59000.0    1.84860E-04    1.17016
    59050.0    1.83405E-04    1.16095
    59100.0    1.81962E-04    1.15182
    59150.0    1.80530E-04    1.14276
    59200.0    1.79110E-04    1.13377
    59250.0    1.77701E-04    1.12485
    59300.0    1.76303E-04    1.11600
    59350.0    1.74916E-04    1.10722
    59400.0    1.73539E-04    1.09850
    59450.0    1.72174E-04    1.08986
    59500.0    1.70819E-04    1.08129
    59550.0    1.69475E-04    1.07278
    59600.0    1.68142E-04    1.06434
    59650.0    1.66819E-04    1.05597
    59700.0    1.65507E-04    1.04766
    59750.0    1.64205E-04    1.03941
    59800.0    1.62913E-04    1.03124
    59850.0    1.61631E-04    1.02312
    59900.0    1.60359E-04    1.01507
    59950.0    1.59098E-04    1.00709
    60000.0    1.57846E-04   0.999164
    60050.0    1.56604E-04   0.991302
    60100.0    1.55372E-04   0.983503
    60150.0    1.54149E-04   0.975765
    60200.0    1.52936E-04   0.968088
    60250.0    1.51733E-04   0.960471
    60300.0    1.50539E-04   0.952914
    60350.0    1.49355E-04   0.945417
    60400.0    1.48180E-04   0.937979
    60450.0    1.47014E-04   0.930599
    60500.0    1.45857E-04   0.923277
    60550.0    1.44710E-04   0.916013
    60600.0    1.43571E-04   0.908806
    60650.0    1.42442E-04   0.901656
    60700.0    1.41321E-04   0.894562
    60750.0    1.40209E-04   0.887524
    60800.0    1.39106E-04   0.880541
    60850.0    1.38012E-04   0.873613
    60900.0    1.36926E-04   0.866739
    60950.0    1.35848E-04   0.859920
    61000.0    1.34780E-04   0.853154
    61050.0    1.33719E-04   0.846442
    61100.0    1.32667E-04   0.839782
    61150.0    1.31623E-04   0.833175
    61200.0    1.30588E-04   0.826620
    61250.0    1.29560E-04   0.820116
    61300.0    1.28541E-04   0.813664
    61350.0    1.27530E-04   0.807262
    61400.0    1.26526E-04   0.800911
    61450.0    1.25531E-04   0.794609
    61500.0    1.24543E-04   0.788358
    61550.0    1.23563E-04   0.782155
    61600.0    1.22591E-04   0.776001
    61650.0    1.21626E-04   0.769896
    61700.0    1.20670E-04   0.763838
    61750.0    1.19720E-04   0.757829
    61800.0    1.18778E-04   0.751866
    61850.0    1.17844E-04   0.745951
    61900.0    1.16917E-04   0.740082
    61950.0    1.15997E-04   0.734259
    62000.0    1.15084E-04   0.728482
    62050.0    1.14179E-04   0.722750
    62100.0    1.13280E-04   0.717064
    62150.0    1.12389E-04   0.711422
    62200.0    1.11505E-04   0.705825
    62250.0    1.10627E-04   0.700272
    62300.0    1.09757E-04   0.694762
    62350.0    1.08893E-04   0.689296
    62400.0    1.08037E-04   0.683873
    62450.0    1.07187E-04   0.678492
    62500.0    1.06343E-04   0.673154
    62550.0    1.05507E-04   0.667858
    62600.0    1.04677E-04   0.662603
    62650.0    1.03853E-04   0.657390
    62700.0    1.03036E-04   0.652218
    62750.0    1.02225E-04   0.647086
    62800.0    1.01421E-04   0.641995
    62850.0    1.00623E-04   0.636944
    62900.0    9.98314E-05   0.631933
    62950.0    9.90459E-05   0.626961
    63000.0    9.82666E-05   0.622028
    63050.0    9.74935E-05   0.617134
    63100.0    9.67264E-05   0.612278
    63150.0    9.59654E-05   0.607461
    63200.0    9.52104E-05   0.602682
    63250.0    9.44613E-05   0.597940
    63300.0    9.37181E-05   0.593236
    63350.0    9.29807E-05   0.588568
    63400.0    9.22492E-05   0.583937
    63450.0    9.15234E-05   0.579343
    63500.0    9.08033E-05   0.574785
    63550.0    9.00889E-05   0.570263
    63600.0    8.93801E-05   0.565776
    63650.0    8.86769E-05   0.561325
    63700.0    8.79792E-05   0.556908
    63750.0    8.72870E-05   0.552527
    63800.0    8.66002E-05   0.548179
    63850.0    8.59189E-05   0.543866
    63900.0    8.52429E-05   0.539587
    63950.0    8.45722E-05   0.535342
    64000.0    8.39068E-05   0.531130
    64050.0    8.32466E-05   0.526951
    64100.0    8.25917E-05   0.522805
    64150.0    8.19419E-05   0.518692
    64200.0    8.12972E-05   0.514611
    64250.0    8.06575E-05   0.510562
    64300.0    8.00229E-05   0.506545
    64350.0    7.93933E-05   0.502560
    64400.0    7.87687E-05   0.498606
    64450.0    7.81490E-05   0.494683
    64500.0    7.75341E-05   0.490791
    64550.0    7.69241E-05   0.486929
    64600.0    7.63189E-05   0.483098
    64650.0    7.57184E-05   0.479297
    64700.0    7.51227E-05   0.475526
    64750.0    7.45316E-05   0.471785
    64800.0    7.39452E-05   0.468073
    64850.0    7.33634E-05   0.464391
    64900.0    7.27862E-05   0.460737
    64950.0    7.22136E-05   0.457112
    65000.0    7.16454E-05   0.453515
    65050.0    7.10817E-05   0.449947
    65100.0    7.05225E-05   0.446407
    65150.0    6.99676E-05   0.442895
    65200.0    6.94171E-05   0.439410
    65250.0    6.88709E-05   0.435953
    65300.0    6.83291E-05   0.432523
    65350.0    6.77915E-05   0.429120
    65400.0    6.72581E-05   0.425744
    65450.0    6.67289E-05   0.422394
    65500.0    6.62039E-05   0.419071
    65550.0    6.56831E-05   0.415774
    65600.0    6.51663E-05   0.412503
    65650.0    6.46536E-05   0.409257
    65700.0    6.41449E-05   0.406037
    65750.0    6.36402E-05   0.402843
    65800.0    6.31395E-05   0.399673
    65850.0    6.26427E-05   0.396529
    65900.0    6.21499E-05   0.393409
    65950.0    6.16609E-05   0.390313
    66000.0    6.11758E-05   0.387243
    66050.0    6.06944E-05   0.384196
    66100.0    6.02169E-05   0.381173
    66150.0    5.97431E-05   0.378174
    66200.0    5.92731E-05   0.375199
    66250.0    5.88067E-05   0.372247
    66300.0    5.83441E-05   0.369318
    66350.0    5.78850E-05   0.366412
    66400.0    5.74296E-05   0.363529
    66450.0    5.69778E-05   0.360669
    66500.0    5.65295E-05   0.357832
    66550.0    5.60847E-05   0.355016
    66600.0    5.56434E-05   0.352223
    66650.0    5.52057E-05   0.349452
    66700.0    5.47713E-05   0.346702
    66750.0    5.43404E-05   0.343975
    66800.0    5.39128E-05   0.341268
    66850.0    5.34887E-05   0.338583
    66900.0    5.30678E-05   0.335919
    66950.0    5.26503E-05   0.333276
    67000.0    5.22361E-05   0.330654
    67050.0    5.18251E-05   0.328053
    67100.0    5.14173E-05   0.325472
    67150.0    5.10128E-05   0.322911
    67200.0    5.06114E-05   0.320370
    67250.0    5.02132E-05   0.317850
    67300.0    4.98182E-05   0.315349
    67350.0    4.94262E-05   0.312868
    67400.0    4.90373E-05   0.310406
    67450.0    4.86515E-05   0.307964
    67500.0    4.82687E-05   0.305541
    67550.0    4.78890E-05   0.303137
    67600.0    4.75122E-05   0.300752
    67650.0    4.71384E-05   0.298386
    67700.0    4.67675E-05   0.296038
    67750.0    4.63995E-05   0.293709
    67800.0    4.60345E-05   0.291398
    67850.0    4.56723E-05   0.289106
    67900.0    4.53130E-05   0.286831
    67950.0    4.49564E-05   0.284574
    68000.0    4.46027E-05   0.282335
    68050.0    4.42518E-05   0.280114
    68100.0    4.39036E-05   0.277910
    68150.0    4.35582E-05   0.275724
    68200.0    4.32155E-05   0.273554
    68250.0    4.28755E-05   0.271402
    68300.0    4.25382E-05   0.269267
    68350.0    4.22035E-05   0.267148
    68400.0    4.18714E-05   0.265046
    68450.0    4.15420E-05   0.262961
    68500.0    4.12152E-05   0.260892
    68550.0    4.08909E-05   0.258839
    68600.0    4.05692E-05   0.256803
    68650.0    4.02500E-05   0.254782
    68700.0    3.99333E-05   0.252778
    68750.0    3.96191E-05   0.250789
    68800.0    3.93074E-05   0.248816
    68850.0    3.89981E-05   0.246858
    68900.0    3.86913E-05   0.244916
    68950.0    3.83869E-05   0.242989
    69000.0    3.80849E-05   0.241077
    69050.0    3.77852E-05   0.239181
    69100.0    3.74879E-05   0.237299
    69150.0    3.71930E-05   0.235432
    69200.0    3.69004E-05   0.233579
    69250.0    3.66101E-05   0.231742
    69300.0    3.63220E-05   0.229918
    69350.0    3.60362E-05   0.228109
    69400.0    3.57527E-05   0.226315
    69450.0    3.54714E-05   0.224534
    69500.0    3.51923E-05   0.222768
    69550.0    3.49155E-05   0.221015
    69600.0    3.46407E-05   0.219276
    69650.0    3.43682E-05   0.217551
    69700.0    3.40978E-05   0.215839
    69750.0    3.38295E-05   0.214141
    69800.0    3.35634E-05   0.212456
    69850.0    3.32993E-05   0.210785
    69900.0    3.30373E-05   0.209126
    69950.0    3.27774E-05   0.207481
    70000.0    3.25195E-05   0.205848
    70050.0    3.22636E-05   0.204229
    70100.0    3.20098E-05   0.202622
    70150.0    3.17579E-05   0.201028
    70200.0    3.15081E-05   0.199446
    70250.0    3.12602E-05   0.197877
    70300.0    3.10142E-05   0.196320
    70350.0    3.07702E-05   0.194775
    70400.0    3.05281E-05   0.193243
    70450.0    3.02879E-05   0.191723
    70500.0    3.00496E-05   0.190214
    70550.0    2.98132E-05   0.188718
    70600.0    2.95786E-05   0.187233
    70650.0    2.93459E-05   0.185760
    70700.0    2.91150E-05   0.184298
    70750.0    2.88860E-05   0.182848
    70800.0    2.86587E-05   0.181410
    70850.0    2.84332E-05   0.179982
    70900.0    2.82095E-05   0.178566
    70950.0    2.79876E-05   0.177161
    71000.0    2.77674E-05   0.175767
    71050.0    2.75489E-05   0.174385
    71100.0    2.73322E-05   0.173013
    71150.0    2.71171E-05   0.171651
    71200.0    2.69038E-05   0.170301
    71250.0    2.66921E-05   0.168961
    71300.0    2.64821E-05   0.167632
    71350.0    2.62737E-05   0.166313
    71400.0    2.60670E-05   0.165004
    71450.0    2.58619E-05   0.163706
    71500.0    2.56584E-05   0.162418
    71550.0    2.54566E-05   0.161140
    71600.0    2.52563E-05   0.159872
    71650.0    2.50576E-05   0.158614
    71700.0    2.48604E-05   0.157366
    71750.0    2.46648E-05   0.156128
    71800.0    2.44708E-05   0.154900
    71850.0    2.42782E-05   0.153681
    71900.0    2.40872E-05   0.152472
    71950.0    2.38977E-05   0.151273
    72000.0    2.37097E-05   0.150082
    72050.0    2.35231E-05   0.148902
    72100.0    2.33381E-05   0.147730
    72150.0    2.31545E-05   0.146568
    72200.0    2.29723E-05   0.145415
    72250.0    2.27915E-05   0.144270
    72300.0    2.26122E-05   0.143135
    72350.0    2.24343E-05   0.142009
    72400.0    2.22578E-05   0.140892
    72450.0    2.20827E-05   0.139783
    72500.0    2.19089E-05   0.138684
    72550.0    2.17366E-05   0.137592
    72600.0    2.15655E-05   0.136510
    72650.0    2.13959E-05   0.135436
    72700.0    2.12275E-05   0.134370
    72750.0    2.10605E-05   0.133313
    72800.0    2.08948E-05   0.132264
    72850.0    2.07304E-05   0.131224
    72900.0    2.05673E-05   0.130191
    72950.0    2.04055E-05   0.129167
    73000.0    2.02450E-05   0.128151
    73050.0    2.00857E-05   0.127142
    73100.0    1.99276E-05   0.126142
    73150.0    1.97709E-05   0.125150
    73200.0    1.96153E-05   0.124165
    73250.0    1.94610E-05   0.123188
    73300.0    1.93079E-05   0.122219
    73350.0    1.91560E-05   0.121257
    73400.0    1.90052E-05   0.120303
    73450.0    1.88557E-05   0.119357
    73500.0    1.87074E-05   0.118418
    73550.0    1.85602E-05   0.117486
    73600.0    1.84141E-05   0.116562
    73650.0    1.82693E-05   0.115644
    73700.0    1.81255E-05   0.114735
    73750.0    1.79829E-05   0.113832
    73800.0    1.78414E-05   0.112936
    73850.0    1.77011E-05   0.112048
    73900.0    1.75618E-05   0.111166
    73950.0    1.74236E-05   0.110292
    74000.0    1.72865E-05   0.109424
    74050.0    1.71505E-05   0.108563
    74100.0    1.70156E-05   0.107709
    74150.0    1.68817E-05   0.106861
    74200.0    1.67489E-05   0.106021
    74250.0    1.66171E-05   0.105186
    74300.0    1.64864E-05    1.04359E-01
    74350.0    1.63567E-05    1.03538E-01
    74400.0    1.62280E-05    1.02723E-01
    74450.0    1.61003E-05    1.01915E-01
    74500.0    1.59736E-05    1.01113E-01
    74550.0    1.58479E-05    1.00318E-01
    74600.0    1.57233E-05    9.95282E-02
    74650.0    1.55996E-05    9.87452E-02
    74700.0    1.54768E-05    9.79683E-02
    74750.0    1.53551E-05    9.71975E-02
    74800.0    1.52342E-05    9.64328E-02
    74850.0    1.51144E-05    9.56740E-02
    74900.0    1.49955E-05    9.49213E-02
    74950.0    1.48775E-05    9.41745E-02
    75000.0    1.47604E-05    9.34335E-02
    75050.0    1.46443E-05    9.26984E-02
    75100.0    1.45291E-05    9.19691E-02
    75150.0    1.44148E-05    9.12455E-02
    75200.0    1.43014E-05    9.05276E-02
    75250.0    1.41888E-05    8.98153E-02
    75300.0    1.40772E-05    8.91087E-02
    75350.0    1.39664E-05    8.84076E-02
    75400.0    1.38566E-05    8.77120E-02
    75450.0    1.37475E-05    8.70219E-02
    75500.0    1.36394E-05    8.63373E-02
    75550.0    1.35321E-05    8.56580E-02
    75600.0    1.34256E-05    8.49840E-02
    75650.0    1.33200E-05    8.43154E-02
    75700.0    1.32152E-05    8.36520E-02
    75750.0    1.31112E-05    8.29939E-02
    75800.0    1.30080E-05    8.23409E-02
    75850.0    1.29057E-05    8.16931E-02
    75900.0    1.28042E-05    8.10503E-02
    75950.0    1.27034E-05    8.04126E-02
    76000.0    1.26035E-05    7.97800E-02
    76050.0    1.25043E-05    7.91523E-02
    76100.0    1.24059E-05    7.85295E-02
    76150.0    1.23083E-05    7.79117E-02
    76200.0    1.22115E-05    7.72987E-02
    76250.0    1.21154E-05    7.66905E-02
    76300.0    1.20201E-05    7.60871E-02
    76350.0    1.19255E-05    7.54885E-02
    76400.0    1.18317E-05    7.48946E-02
    76450.0    1.17386E-05    7.43053E-02
    76500.0    1.16462E-05    7.37207E-02
    76550.0    1.15546E-05    7.31407E-02
    76600.0    1.14637E-05    7.25652E-02
    76650.0    1.13735E-05    7.19943E-02
    76700.0    1.12840E-05    7.14279E-02
    76750.0    1.11952E-05    7.08659E-02
    76800.0    1.11072E-05    7.03083E-02
    76850.0    1.10198E-05    6.97551E-02
    76900.0    1.09331E-05    6.92063E-02
    76950.0    1.08471E-05    6.86618E-02
    77000.0    1.07617E-05    6.81216E-02
    77050.0    1.06770E-05    6.75856E-02
    77100.0    1.05930E-05    6.70539E-02
    77150.0    1.05097E-05    6.65263E-02
    77200.0    1.04270E-05    6.60029E-02
    77250.0    1.03450E-05    6.54836E-02
    77300.0    1.02636E-05    6.49684E-02
    77350.0    1.01828E-05    6.44573E-02
    77400.0    1.01027E-05    6.39501E-02
    77450.0    1.00232E-05    6.34470E-02
    77500.0    9.94436E-06    6.29478E-02
    77550.0    9.86612E-06    6.24525E-02
    77600.0    9.78849E-06    6.19612E-02
    77650.0    9.71148E-06    6.14737E-02
    77700.0    9.63507E-06    6.09900E-02
    77750.0    9.55926E-06    6.05102E-02
    77800.0    9.48406E-06    6.00341E-02
    77850.0    9.40944E-06    5.95617E-02
    77900.0    9.33541E-06    5.90931E-02
    77950.0    9.26196E-06    5.86282E-02
    78000.0    9.18909E-06    5.81669E-02
    78050.0    9.11679E-06    5.77093E-02
    78100.0    9.04506E-06    5.72552E-02
    78150.0    8.97389E-06    5.68048E-02
    78200.0    8.90329E-06    5.63578E-02
    78250.0    8.83324E-06    5.59144E-02
    78300.0    8.76374E-06    5.54745E-02
    78350.0    8.69479E-06    5.50380E-02
    78400.0    8.62638E-06    5.46050E-02
    78450.0    8.55851E-06    5.41754E-02
    78500.0    8.49118E-06    5.37491E-02
    78550.0    8.42437E-06    5.33263E-02
    78600.0    8.35809E-06    5.29067E-02
    78650.0    8.29233E-06    5.24904E-02
    78700.0    8.22709E-06    5.20775E-02
    78750.0    8.16236E-06    5.16677E-02
    78800.0    8.09814E-06    5.12612E-02
    78850.0    8.03442E-06    5.08579E-02
    78900.0    7.97121E-06    5.04578E-02
    78950.0    7.90849E-06    5.00608E-02
    79000.0    7.84627E-06    4.96669E-02
    79050.0    7.78454E-06    4.92761E-02
    79100.0    7.72329E-06    4.88884E-02
    79150.0    7.66253E-06    4.85038E-02
    79200.0    7.60224E-06    4.81222E-02
    79250.0    7.54243E-06    4.77436E-02
    79300.0    7.48309E-06    4.73679E-02
    79350.0    7.42421E-06    4.69952E-02
    79400.0    7.36580E-06    4.66255E-02
    79450.0    7.30785E-06    4.62587E-02
    79500.0    7.25035E-06    4.58947E-02
    79550.0    7.19330E-06    4.55336E-02
    79600.0    7.13671E-06    4.51754E-02
    79650.0    7.08056E-06    4.48199E-02
    79700.0    7.02485E-06    4.44673E-02
    79750.0    6.96958E-06    4.41174E-02
    79800.0    6.91475E-06    4.37703E-02
    79850.0    6.86034E-06    4.34260E-02
    79900.0    6.80637E-06    4.30843E-02
    79950.0    6.75282E-06    4.27453E-02
    80000.0    6.69969E-06    4.24090E-02
    80050.0    6.64697E-06    4.20753E-02
    80100.0    6.59468E-06    4.17443E-02
    80150.0    6.54279E-06    4.14159E-02
    80200.0    6.49131E-06    4.10900E-02
    80250.0    6.44024E-06    4.07667E-02
    80300.0    6.38957E-06    4.04460E-02
    80350.0    6.33930E-06    4.01278E-02
    80400.0    6.28942E-06    3.98121E-02
    80450.0    6.23994E-06    3.94988E-02
    80500.0    6.19085E-06    3.91881E-02
    80550.0    6.14214E-06    3.88797E-02
    80600.0    6.09381E-06    3.85738E-02
    80650.0    6.04587E-06    3.82703E-02
    80700.0    5.99830E-06    3.79692E-02
    80750.0    5.95111E-06    3.76705E-02
    80800.0    5.90428E-06    3.73741E-02
    80850.0    5.85783E-06    3.70801E-02
    80900.0    5.81174E-06    3.67883E-02
    80950.0    5.76602E-06    3.64989E-02
    81000.0    5.72065E-06    3.62117E-02
    81050.0    5.67564E-06    3.59268E-02
    81100.0    5.63099E-06    3.56442E-02
    81150.0    5.58668E-06    3.53637E-02
    81200.0    5.54273E-06    3.50855E-02
    81250.0    5.49912E-06    3.48094E-02
    81300.0    5.45586E-06    3.45356E-02
    81350.0    5.41293E-06    3.42638E-02
    81400.0    5.37034E-06    3.39943E-02
    81450.0    5.32809E-06    3.37268E-02
    81500.0    5.28617E-06    3.34615E-02
    81550.0    5.24458E-06    3.31982E-02
    81600.0    5.20332E-06    3.29370E-02
    81650.0    5.16238E-06    3.26778E-02
    81700.0    5.12176E-06    3.24207E-02
    81750.0    5.08146E-06    3.21657E-02
    81800.0    5.04148E-06    3.19126E-02
    81850.0    5.00182E-06    3.16615E-02
    81900.0    4.96247E-06    3.14124E-02
    81950.0    4.92342E-06    3.11653E-02
    82000.0    4.88469E-06    3.09201E-02
    82050.0    4.84625E-06    3.06768E-02
    82100.0    4.80812E-06    3.04354E-02
    82150.0    4.77030E-06    3.01960E-02
    82200.0    4.73276E-06    2.99584E-02
    82250.0    4.69553E-06    2.97227E-02
    82300.0    4.65858E-06    2.94888E-02
    82350.0    4.62193E-06    2.92568E-02
    82400.0    4.58557E-06    2.90266E-02
    82450.0    4.54949E-06    2.87983E-02
    82500.0    4.51369E-06    2.85717E-02
    82550.0    4.47818E-06    2.83469E-02
    82600.0    4.44295E-06    2.81239E-02
    82650.0    4.40799E-06    2.79026E-02
    82700.0    4.37331E-06    2.76831E-02
    82750.0    4.33890E-06    2.74653E-02
    82800.0    4.30477E-06    2.72492E-02
    82850.0    4.27090E-06    2.70348E-02
    82900.0    4.23729E-06    2.68221E-02
    82950.0    4.20396E-06    2.66110E-02
    83000.0    4.17088E-06    2.64017E-02
    83050.0    4.13806E-06    2.61939E-02
    83100.0    4.10551E-06    2.59879E-02
    83150.0    4.07321E-06    2.57834E-02
    83200.0    4.04116E-06    2.55805E-02
    83250.0    4.00936E-06    2.53793E-02
    83300.0    3.97782E-06    2.51796E-02
    83350.0    3.94652E-06    2.49815E-02
    83400.0    3.91547E-06    2.47849E-02
    83450.0    3.88467E-06    2.45899E-02
    83500.0    3.85410E-06    2.43965E-02
    83550.0    3.82378E-06    2.42045E-02
    83600.0    3.79369E-06    2.40141E-02
    83650.0    3.76385E-06    2.38251E-02
    83700.0    3.73423E-06    2.36377E-02
    83750.0    3.70485E-06    2.34517E-02
    83800.0    3.67570E-06    2.32672E-02
    83850.0    3.64678E-06    2.30841E-02
    83900.0    3.61809E-06    2.29025E-02
    83950.0    3.58963E-06    2.27223E-02
    84000.0    3.56138E-06    2.25436E-02
    84050.0    3.53336E-06    2.23662E-02
    84100.0    3.50556E-06    2.21902E-02
    84150.0    3.47798E-06    2.20156E-02
    84200.0    3.45062E-06    2.18424E-02
    84250.0    3.42347E-06    2.16706E-02
    84300.0    3.39653E-06    2.15001E-02
    84350.0    3.36981E-06    2.13309E-02
    84400.0    3.34330E-06    2.11631E-02
    84450.0    3.31699E-06    2.09966E-02
    84500.0    3.29090E-06    2.08314E-02
    84550.0    3.26501E-06    2.06675E-02
    84600.0    3.23932E-06    2.05049E-02
    84650.0    3.21383E-06    2.03435E-02
    84700.0    3.18854E-06    2.01835E-02
    84750.0    3.16346E-06    2.00247E-02
    84800.0    3.13857E-06    1.98671E-02
    84850.0    3.11387E-06    1.97108E-02
    84900.0    3.08938E-06    1.95557E-02
    84950.0    3.06507E-06    1.94019E-02
    85000.0    3.04095E-06    1.92492E-02
    85050.0    3.01703E-06    1.90978E-02
    85100.0    2.99329E-06    1.89475E-02
    85150.0    2.96974E-06    1.87985E-02
    85200.0    2.94638E-06    1.86506E-02
    85250.0    2.92319E-06    1.85038E-02
    85300.0    2.90019E-06    1.83582E-02
    85350.0    2.87738E-06    1.82138E-02
    85400.0    2.85474E-06    1.80705E-02
    85450.0    2.83228E-06    1.79283E-02
    85500.0    2.80999E-06    1.77873E-02
    85550.0    2.78789E-06    1.76473E-02
    85600.0    2.76595E-06    1.75085E-02
    85650.0    2.74419E-06    1.73707E-02
    85700.0    2.72260E-06    1.72340E-02
    85750.0    2.70118E-06    1.70985E-02
    85800.0    2.67993E-06    1.69639E-02
    85850.0    2.65884E-06    1.68305E-02
    85900.0    2.63792E-06    1.66980E-02
    85950.0    2.61717E-06    1.65667E-02
    86000.0    2.59658E-06    1.64363E-02
    86050.0    2.57615E-06    1.63070E-02
    86100.0    2.55588E-06    1.61787E-02
    86150.0    2.53577E-06    1.60514E-02
    86200.0    2.51582E-06    1.59251E-02
    86250.0    2.49602E-06    1.57998E-02
    86300.0    2.47639E-06    1.56755E-02
    86350.0    2.45690E-06    1.55522E-02
    86400.0    2.43757E-06    1.54298E-02
    86450.0    2.41839E-06    1.53084E-02
    86500.0    2.39937E-06    1.51880E-02
    86550.0    2.38049E-06    1.50685E-02
    86600.0    2.36176E-06    1.49499E-02
    86650.0    2.34318E-06    1.48323E-02
    86700.0    2.32474E-06    1.47156E-02
    86750.0    2.30645E-06    1.45998E-02
    86800.0    2.28830E-06    1.44850E-02
    86850.0    2.27030E-06    1.43710E-02
    86900.0    2.25244E-06    1.42579E-02
    86950.0    2.23472E-06    1.41458E-02
    87000.0    2.21713E-06    1.40345E-02
    87050.0    2.19969E-06    1.39240E-02
    87100.0    2.18238E-06    1.38145E-02
    87150.0    2.16521E-06    1.37058E-02
    87200.0    2.14818E-06    1.35980E-02
    87250.0    2.13128E-06    1.34910E-02
    87300.0    2.11451E-06    1.33848E-02
    87350.0    2.09787E-06    1.32795E-02
    87400.0    2.08137E-06    1.31750E-02
    87450.0    2.06499E-06    1.30714E-02
    87500.0    2.04874E-06    1.29685E-02
    87550.0    2.03262E-06    1.28665E-02
    87600.0    2.01663E-06    1.27653E-02
    87650.0    2.00077E-06    1.26648E-02
    87700.0    1.98502E-06    1.25652E-02
    87750.0    1.96941E-06    1.24663E-02
    87800.0    1.95391E-06    1.23683E-02
    87850.0    1.93854E-06    1.22709E-02
    87900.0    1.92329E-06    1.21744E-02
    87950.0    1.90815E-06    1.20786E-02
    88000.0    1.89314E-06    1.19836E-02
    88050.0    1.87825E-06    1.18893E-02
    88100.0    1.86347E-06    1.17958E-02
    88150.0    1.84881E-06    1.17030E-02
    88200.0    1.83426E-06    1.16109E-02
    88250.0    1.81983E-06    1.15195E-02
    88300.0    1.80551E-06    1.14289E-02
    88350.0    1.79131E-06    1.13390E-02
    88400.0    1.77721E-06    1.12498E-02
    88450.0    1.76323E-06    1.11612E-02
    88500.0    1.74936E-06    1.10734E-02
    88550.0    1.73559E-06    1.09863E-02
    88600.0    1.72194E-06    1.08999E-02
    88650.0    1.70839E-06    1.08141E-02
    88700.0    1.69495E-06    1.07290E-02
    88750.0    1.68161E-06    1.06446E-02
    88800.0    1.66838E-06    1.05609E-02
    88850.0    1.65526E-06    1.04778E-02
    88900.0    1.64223E-06    1.03953E-02
    88950.0    1.62931E-06    1.03136E-02
    89000.0    1.61649E-06    1.02324E-02
    89050.0    1.60378E-06    1.01519E-02
    89100.0    1.59116E-06    1.00720E-02
    89150.0    1.57864E-06    9.99278E-03
    89200.0    1.56622E-06    9.91416E-03
    89250.0    1.55390E-06    9.83616E-03
    89300.0    1.54167E-06    9.75877E-03
    89350.0    1.52954E-06    9.68199E-03
    89400.0    1.51751E-06    9.60582E-03
    89450.0    1.50557E-06    9.53024E-03
    89500.0    1.49372E-06    9.45526E-03
    89550.0    1.48197E-06    9.38087E-03
    89600.0    1.47031E-06    9.30706E-03
    89650.0    1.45874E-06    9.23383E-03
    89700.0    1.44726E-06    9.16118E-03
    89750.0    1.43588E-06    9.08911E-03
    89800.0    1.42458E-06    9.01759E-03
    89850.0    1.41337E-06    8.94665E-03
    89900.0    1.40225E-06    8.87626E-03
    89950.0    1.39122E-06    8.80642E-03
    90000.0    1.38027E-06    8.73713E-03
    90050.0    1.36941E-06    8.66839E-03
    90100.0    1.35864E-06    8.60019E-03
    90150.0    1.34795E-06    8.53253E-03
    90200.0    1.33734E-06    8.46539E-03
    90250.0    1.32682E-06    8.39879E-03
    90300.0    1.31638E-06    8.33271E-03
    90350.0    1.30603E-06    8.26715E-03
    90400.0    1.29575E-06    8.20211E-03
    90450.0    1.28556E-06    8.13757E-03
    90500.0    1.27544E-06    8.07355E-03
    90550.0    1.26541E-06    8.01003E-03
    90600.0    1.25545E-06    7.94701E-03
    90650.0    1.24557E-06    7.88448E-03
    90700.0    1.23577E-06    7.82245E-03
    90750.0    1.22605E-06    7.76090E-03
    90800.0    1.21640E-06    7.69984E-03
    90850.0    1.20683E-06    7.63926E-03
    90900.0    1.19734E-06    7.57916E-03
    90950.0    1.18792E-06    7.51953E-03
    91000.0    1.17857E-06    7.46036E-03
    91050.0    1.16930E-06    7.40167E-03
    91100.0    1.16010E-06    7.34343E-03
    91150.0    1.15097E-06    7.28566E-03
    91200.0    1.14192E-06    7.22833E-03
    91250.0    1.13293E-06    7.17146E-03
    91300.0    1.12402E-06    7.11504E-03
    91350.0    1.11518E-06    7.05906E-03
    91400.0    1.10640E-06    7.00352E-03
    91450.0    1.09770E-06    6.94842E-03
    91500.0    1.08906E-06    6.89375E-03
    91550.0    1.08049E-06    6.83951E-03
    91600.0    1.07199E-06    6.78570E-03
    91650.0    1.06356E-06    6.73231E-03
    91700.0    1.05519E-06    6.67934E-03
    91750.0    1.04689E-06    6.62679E-03
    91800.0    1.03865E-06    6.57465E-03
    91850.0    1.03048E-06    6.52293E-03
    91900.0    1.02237E-06    6.47160E-03
    91950.0    1.01433E-06    6.42069E-03
    92000.0    1.00635E-06    6.37017E-03
    92050.0    9.98428E-07    6.32005E-03
    92100.0    9.90573E-07    6.27033E-03
    92150.0    9.82779E-07    6.22099E-03
    92200.0    9.75047E-07    6.17205E-03
    92250.0    9.67376E-07    6.12349E-03
    92300.0    9.59765E-07    6.07531E-03
    92350.0    9.52213E-07    6.02751E-03
    92400.0    9.44721E-07    5.98009E-03
    92450.0    9.37289E-07    5.93304E-03
    92500.0    9.29914E-07    5.88636E-03
    92550.0    9.22598E-07    5.84004E-03
    92600.0    9.15339E-07    5.79410E-03
    92650.0    9.08137E-07    5.74851E-03
    92700.0    9.00992E-07    5.70328E-03
    92750.0    8.93904E-07    5.65841E-03
    92800.0    8.86871E-07    5.61389E-03
    92850.0    8.79893E-07    5.56972E-03
    92900.0    8.72970E-07    5.52590E-03
    92950.0    8.66102E-07    5.48242E-03
    93000.0    8.59287E-07    5.43929E-03
    93050.0    8.52527E-07    5.39649E-03
    93100.0    8.45819E-07    5.35404E-03
    93150.0    8.39164E-07    5.31191E-03
    93200.0    8.32562E-07    5.27012E-03
    93250.0    8.26012E-07    5.22865E-03
    93300.0    8.19513E-07    5.18752E-03
    93350.0    8.13065E-07    5.14670E-03
    93400.0    8.06668E-07    5.10621E-03
    93450.0    8.00321E-07    5.06603E-03
    93500.0    7.94025E-07    5.02618E-03
    93550.0    7.87777E-07    4.98663E-03
    93600.0    7.81579E-07    4.94740E-03
    93650.0    7.75430E-07    4.90847E-03
    93700.0    7.69329E-07    4.86985E-03
    93750.0    7.63276E-07    4.83154E-03
    93800.0    7.57271E-07    4.79353E-03
    93850.0    7.51313E-07    4.75581E-03
    93900.0    7.45402E-07    4.71839E-03
    93950.0    7.39537E-07    4.68127E-03
    94000.0    7.33719E-07    4.64444E-03
    94050.0    7.27946E-07    4.60790E-03
    94100.0    7.22219E-07    4.57164E-03
    94150.0    7.16536E-07    4.53567E-03
    94200.0    7.10899E-07    4.49999E-03
    94250.0    7.05306E-07    4.46458E-03
    94300.0    6.99756E-07    4.42946E-03
    94350.0    6.94251E-07    4.39461E-03
    94400.0    6.88789E-07    4.36003E-03
    94450.0    6.83369E-07    4.32573E-03
    94500.0    6.77993E-07    4.29169E-03
    94550.0    6.72658E-07    4.25793E-03
    94600.0    6.67366E-07    4.22443E-03
    94650.0    6.62115E-07    4.19119E-03
    94700.0    6.56906E-07    4.15822E-03
    94750.0    6.51738E-07    4.12550E-03
    94800.0    6.46610E-07    4.09304E-03
    94850.0    6.41523E-07    4.06084E-03
    94900.0    6.36475E-07    4.02889E-03
    94950.0    6.31468E-07    3.99719E-03
    95000.0    6.26499E-07    3.96574E-03
    95050.0    6.21570E-07    3.93454E-03
    95100.0    6.16680E-07    3.90358E-03
    95150.0    6.11828E-07    3.87287E-03
    95200.0    6.07014E-07    3.84240E-03
    95250.0    6.02238E-07    3.81217E-03
    95300.0    5.97500E-07    3.78218E-03
    95350.0    5.92799E-07    3.75242E-03
    95400.0    5.88135E-07    3.72289E-03
    95450.0    5.83508E-07    3.69360E-03
    95500.0    5.78917E-07    3.66454E-03
    95550.0    5.74362E-07    3.63571E-03
    95600.0    5.69843E-07    3.60711E-03
    95650.0    5.65360E-07    3.57873E-03
    95700.0    5.60912E-07    3.55057E-03
    95750.0    5.56498E-07    3.52263E-03
    95800.0    5.52120E-07    3.49492E-03
    95850.0    5.47776E-07    3.46742E-03
    95900.0    5.43466E-07    3.44014E-03
    95950.0    5.39190E-07    3.41307E-03
    96000.0    5.34948E-07    3.38622E-03
    96050.0    5.30739E-07    3.35958E-03
    96100.0    5.26564E-07    3.33315E-03
    96150.0    5.22421E-07    3.30692E-03
    96200.0    5.18310E-07    3.28090E-03
    96250.0    5.14232E-07    3.25509E-03
    96300.0    5.10187E-07    3.22948E-03
    96350.0    5.06173E-07    3.20407E-03
    96400.0    5.02190E-07    3.17886E-03
    96450.0    4.98239E-07    3.15385E-03
    96500.0    4.94319E-07    3.12904E-03
    96550.0    4.90430E-07    3.10442E-03
    96600.0    4.86571E-07    3.08000E-03
    96650.0    4.82743E-07    3.05576E-03
    96700.0    4.78945E-07    3.03172E-03
    96750.0    4.75177E-07    3.00787E-03
    96800.0    4.71438E-07    2.98420E-03
    96850.0    4.67729E-07    2.96072E-03
    96900.0    4.64049E-07    2.93743E-03
    96950.0    4.60398E-07    2.91432E-03
    97000.0    4.56775E-07    2.89139E-03
    97050.0    4.53182E-07    2.86864E-03
    97100.0    4.49616E-07    2.84607E-03
    97150.0    4.46079E-07    2.82368E-03
    97200.0    4.42569E-07    2.80146E-03
    97250.0    4.39087E-07    2.77942E-03
    97300.0    4.35632E-07    2.75755E-03
    97350.0    4.32205E-07    2.73586E-03
    97400.0    4.28804E-07    2.71433E-03
    97450.0    4.25431E-07    2.69298E-03
    97500.0    4.22083E-07    2.67179E-03
    97550.0    4.18763E-07    2.65077E-03
    97600.0    4.15468E-07    2.62991E-03
    97650.0    4.12199E-07    2.60922E-03
    97700.0    4.08956E-07    2.58869E-03
    97750.0    4.05738E-07    2.56832E-03
    97800.0    4.02546E-07    2.54812E-03
    97850.0    3.99379E-07    2.52807E-03
    97900.0    3.96237E-07    2.50818E-03
    97950.0    3.93119E-07    2.48844E-03
    98000.0    3.90026E-07    2.46887E-03
    98050.0    3.86958E-07    2.44944E-03
    98100.0    3.83913E-07    2.43017E-03
    98150.0    3.80893E-07    2.41105E-03
    98200.0    3.77896E-07    2.39208E-03
    98250.0    3.74923E-07    2.37326E-03
    98300.0    3.71973E-07    2.35459E-03
    98350.0    3.69046E-07    2.33606E-03
    98400.0    3.66143E-07    2.31768E-03
    98450.0    3.63262E-07    2.29945E-03
    98500.0    3.60404E-07    2.28136E-03
    98550.0    3.57568E-07    2.26341E-03
    98600.0    3.54755E-07    2.24560E-03
    98650.0    3.51964E-07    2.22793E-03
    98700.0    3.49195E-07    2.21040E-03
    98750.0    3.46447E-07    2.19301E-03
    98800.0    3.43721E-07    2.17576E-03
    98850.0    3.41017E-07    2.15864E-03
    98900.0    3.38334E-07    2.14165E-03
    98950.0    3.35672E-07    2.12481E-03
    99000.0    3.33031E-07    2.10809E-03
    99050.0    3.30411E-07    2.09150E-03
    99100.0    3.27811E-07    2.07505E-03
    99150.0    3.25232E-07    2.05872E-03
    99200.0    3.22673E-07    2.04252E-03
    99250.0    3.20135E-07    2.02645E-03
    99300.0    3.17616E-07    2.01051E-03
    99350.0    3.15117E-07    1.99469E-03
    99400.0    3.12638E-07    1.97900E-03
    99450.0    3.10178E-07    1.96343E-03
    99500.0    3.07738E-07    1.94798E-03
    99550.0    3.05316E-07    1.93265E-03
    99600.0    3.02914E-07    1.91745E-03
    99650.0    3.00531E-07    1.90236E-03
    99700.0    2.98166E-07    1.88739E-03
    99750.0    2.95820E-07    1.87254E-03
    99800.0    2.93493E-07    1.85781E-03
    99850.0    2.91184E-07    1.84319E-03
    99900.0    2.88893E-07    1.82869E-03
    99950.0    2.86620E-07    1.81430E-03
   100000.0    2.84365E-07    1.80003E-03
   100050.0    2.82128E-07    1.78587E-03
   100100.0    2.79908E-07    1.77182E-03
   100150.0    2.77706E-07    1.75788E-03
   100200.0    2.75521E-07    1.74405E-03
   100250.0    2.73353E-07    1.73032E-03
   100300.0    2.71202E-07    1.71671E-03
   100350.0    2.69068E-07    1.70320E-03
   100400.0    2.66952E-07    1.68980E-03
   100450.0    2.64851E-07    1.67651E-03
   100500.0    2.62767E-07    1.66332E-03
   100550.0    2.60700E-07    1.65023E-03
   100600.0    2.58649E-07    1.63725E-03
   100650.0    2.56614E-07    1.62437E-03
   100700.0    2.54595E-07    1.61159E-03
   100750.0    2.52592E-07    1.59891E-03
   100800.0    2.50605E-07    1.58633E-03
   100850.0    2.48633E-07    1.57385E-03
   100900.0    2.46677E-07    1.56146E-03
   100950.0    2.44736E-07    1.54918E-03
   101000.0    2.42810E-07    1.53699E-03
   101050.0    2.40900E-07    1.52490E-03
   101100.0    2.39005E-07    1.51290E-03
   101150.0    2.37124E-07    1.50100E-03
   101200.0    2.35258E-07    1.48919E-03
   101250.0    2.33408E-07    1.47747E-03
   101300.0    2.31571E-07    1.46585E-03
   101350.0    2.29749E-07    1.45431E-03
   101400.0    2.27942E-07    1.44287E-03
   101450.0    2.26148E-07    1.43152E-03
   101500.0    2.24369E-07    1.42025E-03
   101550.0    2.22604E-07    1.40908E-03
   101600.0    2.20852E-07    1.39799E-03
   101650.0    2.19115E-07    1.38700E-03
   101700.0    2.17391E-07    1.37608E-03
   101750.0    2.15680E-07    1.36526E-03
   101800.0    2.13983E-07    1.35451E-03
   101850.0    2.12300E-07    1.34386E-03
   101900.0    2.10629E-07    1.33328E-03
   101950.0    2.08972E-07    1.32279E-03
   102000.0    2.07328E-07    1.31239E-03
   102050.0    2.05697E-07    1.30206E-03
   102100.0    2.04078E-07    1.29182E-03
   102150.0    2.02473E-07    1.28165E-03
   102200.0    2.00880E-07    1.27157E-03
   102250.0    1.99299E-07    1.26156E-03
   102300.0    1.97731E-07    1.25164E-03
   102350.0    1.96176E-07    1.24179E-03
   102400.0    1.94632E-07    1.23202E-03
   102450.0    1.93101E-07    1.22233E-03
   102500.0    1.91582E-07    1.21271E-03
   102550.0    1.90074E-07    1.20317E-03
   102600.0    1.88579E-07    1.19370E-03
   102650.0    1.87095E-07    1.18431E-03
   102700.0    1.85623E-07    1.17499E-03
   102750.0    1.84163E-07    1.16575E-03
   102800.0    1.82714E-07    1.15658E-03
   102850.0    1.81276E-07    1.14748E-03
   102900.0    1.79850E-07    1.13845E-03
   102950.0    1.78435E-07    1.12949E-03
   103000.0    1.77031E-07    1.12061E-03
   103050.0    1.75638E-07    1.11179E-03
   103100.0    1.74256E-07    1.10304E-03
   103150.0    1.72885E-07    1.09436E-03
   103200.0    1.71525E-07    1.08575E-03
   103250.0    1.70175E-07    1.07721E-03
   103300.0    1.68837E-07    1.06874E-03
   103350.0    1.67508E-07    1.06033E-03
   103400.0    1.66190E-07    1.05198E-03
   103450.0    1.64883E-07    1.04371E-03
   103500.0    1.63585E-07    1.03550E-03
   103550.0    1.62298E-07    1.02735E-03
   103600.0    1.61022E-07    1.01927E-03
   103650.0    1.59755E-07    1.01125E-03
   103700.0    1.58498E-07    1.00329E-03
   103750.0    1.57251E-07    9.95397E-04
   103800.0    1.56013E-07    9.87565E-04
   103850.0    1.54786E-07    9.79795E-04
   103900.0    1.53568E-07    9.72086E-04
   103950.0    1.52360E-07    9.64438E-04
   104000.0    1.51161E-07    9.56850E-04
   104050.0    1.49972E-07    9.49322E-04
   104100.0    1.48792E-07    9.41853E-04
   104150.0    1.47621E-07    9.34443E-04
   104200.0    1.46460E-07    9.27091E-04
   104250.0    1.45308E-07    9.19797E-04
   104300.0    1.44164E-07    9.12560E-04
   104350.0    1.43030E-07    9.05380E-04
   104400.0    1.41905E-07    8.98257E-04
   104450.0    1.40788E-07    8.91189E-04
   104500.0    1.39681E-07    8.84178E-04
   104550.0    1.38582E-07    8.77221E-04
   104600.0    1.37491E-07    8.70319E-04
   104650.0    1.36409E-07    8.63472E-04
   104700.0    1.35336E-07    8.56678E-04
   104750.0    1.34271E-07    8.49938E-04
   104800.0    1.33215E-07    8.43251E-04
   104850.0    1.32167E-07    8.36616E-04
   104900.0    1.31127E-07    8.30034E-04
   104950.0    1.30095E-07    8.23504E-04
   105000.0    1.29072E-07    8.17024E-04
   105050.0    1.28056E-07    8.10596E-04
   105100.0    1.27049E-07    8.04219E-04
   105150.0    1.26049E-07    7.97891E-04
   105200.0    1.25057E-07    7.91614E-04
   105250.0    1.24074E-07    7.85385E-04
   105300.0    1.23097E-07    7.79206E-04
   105350.0    1.22129E-07    7.73076E-04
   105400.0    1.21168E-07    7.66993E-04
   105450.0    1.20215E-07    7.60959E-04
   105500.0    1.19269E-07    7.54972E-04
    105550.    1.18330E-07    7.49032E-04
    105600.    1.17399E-07    7.43138E-04
    105650.    1.16476E-07    7.37292E-04
    105700.    1.15559E-07    7.31491E-04
    105750.    1.14650E-07    7.25736E-04
    105800.    1.13748E-07    7.20026E-04
    105850.    1.12853E-07    7.14361E-04
    105900.    1.11965E-07    7.08740E-04
    105950.    1.11084E-07    7.03164E-04
    106000.    1.10210E-07    6.97632E-04
    106050.    1.09343E-07    6.92143E-04
    106100.    1.08483E-07    6.86697E-04
    106150.    1.07629E-07    6.81294E-04
    106200.    1.06783E-07    6.75934E-04
    106250.    1.05942E-07    6.70616E-04
    106300.    1.05109E-07    6.65340E-04
    106350.    1.04282E-07    6.60105E-04
    106400.    1.03462E-07    6.54911E-04
    106450.    1.02648E-07    6.49759E-04
    106500.    1.01840E-07    6.44647E-04
    106550.    1.01039E-07    6.39575E-04
    106600.    1.00244E-07    6.34543E-04
    106650.    9.94550E-08    6.29550E-04
    106700.    9.86725E-08    6.24597E-04
    106750.    9.78962E-08    6.19683E-04
    106800.    9.71260E-08    6.14807E-04
    106850.    9.63618E-08    6.09970E-04
    106900.    9.56036E-08    6.05171E-04
    106950.    9.48515E-08    6.00410E-04
    107000.    9.41052E-08    5.95686E-04
    107050.    9.33648E-08    5.90999E-04
    107100.    9.26302E-08    5.86349E-04
    107150.    9.19014E-08    5.81736E-04
    107200.    9.11784E-08    5.77159E-04
    107250.    9.04610E-08    5.72618E-04
    107300.    8.97493E-08    5.68113E-04
    107350.    8.90431E-08    5.63643E-04
    107400.    8.83426E-08    5.59208E-04
    107450.    8.76475E-08    5.54809E-04
    107500.    8.69579E-08    5.50444E-04
    107550.    8.62737E-08    5.46113E-04
    107600.    8.55950E-08    5.41816E-04
    107650.    8.49215E-08    5.37553E-04
    107700.    8.42534E-08    5.33324E-04
    107750.    8.35905E-08    5.29128E-04
    107800.    8.29328E-08    5.24965E-04
    107850.    8.22803E-08    5.20834E-04
    107900.    8.16329E-08    5.16737E-04
    107950.    8.09907E-08    5.12671E-04
    108000.    8.03535E-08    5.08637E-04
    108050.    7.97213E-08    5.04636E-04
    108100.    7.90940E-08    5.00665E-04
    108150.    7.84717E-08    4.96726E-04
    108200.    7.78543E-08    4.92818E-04
    108250.    7.72418E-08    4.88941E-04
    108300.    7.66341E-08    4.85094E-04
    108350.    7.60311E-08    4.81277E-04
    108400.    7.54329E-08    4.77491E-04
    108450.    7.48394E-08    4.73734E-04
    108500.    7.42506E-08    4.70006E-04
    108550.    7.36664E-08    4.66309E-04
    108600.    7.30869E-08    4.62640E-04
    108650.    7.25118E-08    4.59000E-04
    108700.    7.19413E-08    4.55389E-04
    108750.    7.13753E-08    4.51806E-04
    108800.    7.08137E-08    4.48251E-04
    108850.    7.02566E-08    4.44724E-04
    108900.    6.97038E-08    4.41225E-04
    108950.    6.91554E-08    4.37754E-04
    109000.    6.86113E-08    4.34310E-04
    109050.    6.80715E-08    4.30893E-04
    109100.    6.75359E-08    4.27502E-04
    109150.    6.70046E-08    4.24139E-04
    109200.    6.64774E-08    4.20802E-04
    109250.    6.59544E-08    4.17491E-04
    109300.    6.54354E-08    4.14206E-04
    109350.    6.49206E-08    4.10947E-04
    109400.    6.44098E-08    4.07714E-04
    109450.    6.39031E-08    4.04506E-04
    109500.    6.34003E-08    4.01324E-04
    109550.    6.29015E-08    3.98166E-04
    109600.    6.24066E-08    3.95034E-04
    109650.    6.19156E-08    3.91926E-04
    109700.    6.14284E-08    3.88842E-04
    109750.    6.09451E-08    3.85783E-04
    109800.    6.04656E-08    3.82747E-04
    109850.    5.99899E-08    3.79736E-04
    109900.    5.95179E-08    3.76748E-04
    109950.    5.90496E-08    3.73784E-04
    110000.    5.85850E-08    3.70843E-04
    110050.    5.81241E-08    3.67926E-04
    110100.    5.76668E-08    3.65031E-04
    110150.    5.72131E-08    3.62159E-04
    110200.    5.67629E-08    3.59309E-04
    110250.    5.63164E-08    3.56483E-04
    110300.    5.58733E-08    3.53678E-04
    110350.    5.54337E-08    3.50895E-04
    110400.    5.49975E-08    3.48134E-04
    110450.    5.45648E-08    3.45395E-04
    110500.    5.41355E-08    3.42678E-04
    110550.    5.37096E-08    3.39982E-04
    110600.    5.32870E-08    3.37307E-04
    110650.    5.28678E-08    3.34653E-04
    110700.    5.24518E-08    3.32020E-04
    110750.    5.20391E-08    3.29408E-04
    110800.    5.16297E-08    3.26816E-04
    110850.    5.12235E-08    3.24245E-04
    110900.    5.08205E-08    3.21694E-04
    110950.    5.04206E-08    3.19163E-04
    111000.    5.00239E-08    3.16651E-04
    111050.    4.96304E-08    3.14160E-04
    111100.    4.92399E-08    3.11688E-04
    111150.    4.88525E-08    3.09236E-04
    111200.    4.84681E-08    3.06803E-04
    111250.    4.80868E-08    3.04389E-04
    111300.    4.77084E-08    3.01994E-04
    111350.    4.73331E-08    2.99618E-04
    111400.    4.69607E-08    2.97261E-04
    111450.    4.65912E-08    2.94922E-04
    111500.    4.62246E-08    2.92602E-04
    111550.    4.58609E-08    2.90300E-04
    111600.    4.55001E-08    2.88016E-04
    111650.    4.51421E-08    2.85750E-04
    111700.    4.47870E-08    2.83501E-04
    111750.    4.44346E-08    2.81271E-04
    111800.    4.40850E-08    2.79058E-04
    111850.    4.37381E-08    2.76862E-04
    111900.    4.33940E-08    2.74684E-04
    111950.    4.30526E-08    2.72523E-04
    112000.    4.27139E-08    2.70379E-04
    112050.    4.23778E-08    2.68252E-04
    112100.    4.20444E-08    2.66141E-04
    112150.    4.17136E-08    2.64047E-04
    112200.    4.13854E-08    2.61970E-04
    112250.    4.10598E-08    2.59908E-04
    112300.    4.07367E-08    2.57864E-04
    112350.    4.04162E-08    2.55835E-04
    112400.    4.00982E-08    2.53822E-04
    112450.    3.97828E-08    2.51825E-04
    112500.    3.94698E-08    2.49844E-04
    112550.    3.91592E-08    2.47878E-04
    112600.    3.88511E-08    2.45928E-04
    112650.    3.85454E-08    2.43993E-04
    112700.    3.82422E-08    2.42073E-04
    112750.    3.79413E-08    2.40168E-04
    112800.    3.76428E-08    2.38279E-04
    112850.    3.73466E-08    2.36404E-04
    112900.    3.70528E-08    2.34544E-04
    112950.    3.67613E-08    2.32699E-04
    113000.    3.64720E-08    2.30868E-04
    113050.    3.61851E-08    2.29052E-04
    113100.    3.59004E-08    2.27249E-04
    113150.    3.56179E-08    2.25461E-04
    113200.    3.53377E-08    2.23688E-04
    113250.    3.50597E-08    2.21928E-04
    113300.    3.47838E-08    2.20182E-04
    113350.    3.45102E-08    2.18449E-04
    113400.    3.42386E-08    2.16731E-04
    113450.    3.39693E-08    2.15025E-04
    113500.    3.37020E-08    2.13334E-04
    113550.    3.34368E-08    2.11655E-04
    113600.    3.31738E-08    2.09990E-04
    113650.    3.29128E-08    2.08338E-04
    113700.    3.26538E-08    2.06699E-04
    113750.    3.23969E-08    2.05072E-04
    113800.    3.21420E-08    2.03459E-04
    113850.    3.18891E-08    2.01858E-04
    113900.    3.16382E-08    2.00270E-04
    113950.    3.13893E-08    1.98694E-04
    114000.    3.11423E-08    1.97131E-04
    114050.    3.08973E-08    1.95580E-04
    114100.    3.06542E-08    1.94041E-04
    114150.    3.04130E-08    1.92514E-04
    114200.    3.01737E-08    1.91000E-04
    114250.    2.99363E-08    1.89497E-04
    114300.    2.97008E-08    1.88006E-04
    114350.    2.94671E-08    1.86527E-04
    114400.    2.92353E-08    1.85059E-04
    114450.    2.90053E-08    1.83603E-04
    114500.    2.87771E-08    1.82159E-04
    114550.    2.85507E-08    1.80726E-04
    114600.    2.83260E-08    1.79304E-04
    114650.    2.81032E-08    1.77893E-04
    114700.    2.78821E-08    1.76493E-04
    114750.    2.76627E-08    1.75105E-04
    114800.    2.74450E-08    1.73727E-04
    114850.    2.72291E-08    1.72360E-04
    114900.    2.70149E-08    1.71004E-04
    114950.    2.68023E-08    1.69659E-04
    115000.    2.65915E-08    1.68324E-04
    115050.    2.63822E-08    1.67000E-04
    115100.    2.61747E-08    1.65686E-04
    115150.    2.59687E-08    1.64382E-04
    115200.    2.57644E-08    1.63089E-04
    115250.    2.55617E-08    1.61806E-04
    115300.    2.53606E-08    1.60533E-04
    115350.    2.51611E-08    1.59270E-04
    115400.    2.49631E-08    1.58016E-04
    115450.    2.47667E-08    1.56773E-04
    115500.    2.45718E-08    1.55540E-04
    115550.    2.43785E-08    1.54316E-04
    115600.    2.41867E-08    1.53102E-04
    115650.    2.39964E-08    1.51897E-04
    115700.    2.38076E-08    1.50702E-04
    115750.    2.36203E-08    1.49517E-04
    115800.    2.34345E-08    1.48340E-04
    115850.    2.32501E-08    1.47173E-04
    115900.    2.30672E-08    1.46015E-04
    115950.    2.28857E-08    1.44866E-04
    116000.    2.27056E-08    1.43727E-04
    116050.    2.25270E-08    1.42596E-04
    116100.    2.23497E-08    1.41474E-04
    116150.    2.21739E-08    1.40361E-04
    116200.    2.19994E-08    1.39256E-04
    116250.    2.18263E-08    1.38161E-04
    116300.    2.16546E-08    1.37074E-04
    116350.    2.14842E-08    1.35995E-04
    116400.    2.13152E-08    1.34925E-04
    116450.    2.11475E-08    1.33864E-04
    116500.    2.09811E-08    1.32811E-04
    116550.    2.08160E-08    1.31766E-04
    116600.    2.06523E-08    1.30729E-04
    116650.    2.04898E-08    1.29700E-04
    116700.    2.03286E-08    1.28680E-04
    116750.    2.01686E-08    1.27667E-04
    116800.    2.00100E-08    1.26663E-04
    116850.    1.98525E-08    1.25666E-04
    116900.    1.96963E-08    1.24678E-04
    116950.    1.95414E-08    1.23697E-04
    117000.    1.93876E-08    1.22724E-04
    117050.    1.92351E-08    1.21758E-04
    117100.    1.90837E-08    1.20800E-04
    117150.    1.89336E-08    1.19850E-04
    117200.    1.87846E-08    1.18907E-04
    117250.    1.86368E-08    1.17971E-04
    117300.    1.84902E-08    1.17043E-04
    117350.    1.83447E-08    1.16122E-04
    117400.    1.82004E-08    1.15208E-04
    117450.    1.80572E-08    1.14302E-04
    117500.    1.79151E-08    1.13403E-04
    117550.    1.77742E-08    1.12511E-04
    117600.    1.76343E-08    1.11625E-04
    117650.    1.74956E-08    1.10747E-04
    117700.    1.73579E-08    1.09876E-04
    117750.    1.72214E-08    1.09011E-04
    117800.    1.70859E-08    1.08154E-04
    117850.    1.69514E-08    1.07303E-04
    117900.    1.68181E-08    1.06458E-04
    117950.    1.66858E-08    1.05621E-04
    118000.    1.65545E-08    1.04790E-04
    118050.    1.64242E-08    1.03965E-04
    118100.    1.62950E-08    1.03147E-04
    118150.    1.61668E-08    1.02336E-04
    118200.    1.60396E-08    1.01531E-04
    118250.    1.59134E-08    1.00732E-04
    118300.    1.57882E-08    9.99393E-05
    118350.    1.56640E-08    9.91530E-05
    118400.    1.55407E-08    9.83729E-05
    118450.    1.54185E-08    9.75989E-05
    118500.    1.52972E-08    9.68310E-05
    118550.    1.51768E-08    9.60692E-05
    118600.    1.50574E-08    9.53133E-05
    118650.    1.49389E-08    9.45634E-05
    118700.    1.48214E-08    9.38194E-05
    118750.    1.47048E-08    9.30813E-05
    118800.    1.45891E-08    9.23489E-05
    118850.    1.44743E-08    9.16224E-05
    118900.    1.43604E-08    9.09015E-05
    118950.    1.42474E-08    9.01863E-05
    119000.    1.41353E-08    8.94767E-05
    119050.    1.40241E-08    8.87728E-05
    119100.    1.39138E-08    8.80743E-05
    119150.    1.38043E-08    8.73814E-05
    119200.    1.36957E-08    8.66939E-05
    119250.    1.35880E-08    8.60118E-05
    119300.    1.34811E-08    8.53351E-05
    119350.    1.33750E-08    8.46637E-05
    119400.    1.32698E-08    8.39975E-05
    119450.    1.31654E-08    8.33367E-05
    119500.    1.30618E-08    8.26810E-05
    119550.    1.29590E-08    8.20305E-05
    119600.    1.28570E-08    8.13851E-05
    119650.    1.27559E-08    8.07448E-05
    119700.    1.26555E-08    8.01095E-05
    119750.    1.25560E-08    7.94792E-05
    119800.    1.24572E-08    7.88539E-05
    119850.    1.23592E-08    7.82335E-05
    119900.    1.22619E-08    7.76179E-05
    119950.    1.21654E-08    7.70073E-05
    120000.    1.20697E-08    7.64014E-05
    120050.    1.19748E-08    7.58003E-05
    120100.    1.18806E-08    7.52039E-05
    120150.    1.17871E-08    7.46122E-05
    120200.    1.16943E-08    7.40252E-05
    120250.    1.16023E-08    7.34428E-05
    120300.    1.15110E-08    7.28649E-05
    120350.    1.14205E-08    7.22916E-05
    120400.    1.13306E-08    7.17229E-05
    120450.    1.12415E-08    7.11586E-05
    120500.    1.11530E-08    7.05987E-05
    120550.    1.10653E-08    7.00433E-05
    120600.    1.09782E-08    6.94922E-05
    120650.    1.08919E-08    6.89454E-05
    120700.    1.08062E-08    6.84030E-05
    120750.    1.07211E-08    6.78648E-05
    120800.    1.06368E-08    6.73309E-05
    120850.    1.05531E-08    6.68011E-05
    120900.    1.04701E-08    6.62755E-05
    120950.    1.03877E-08    6.57541E-05
    121000.    1.03060E-08    6.52368E-05
    121050.    1.02249E-08    6.47235E-05
    121100.    1.01444E-08    6.42142E-05
    121150.    1.00646E-08    6.37090E-05
    121200.    9.98543E-09    6.32078E-05
    121250.    9.90687E-09    6.27105E-05
    121300.    9.82892E-09    6.22171E-05
    121350.    9.75159E-09    6.17276E-05
    121400.    9.67487E-09    6.12419E-05
    121450.    9.59875E-09    6.07601E-05
    121500.    9.52323E-09    6.02820E-05
    121550.    9.44830E-09    5.98077E-05
    121600.    9.37396E-09    5.93372E-05
    121650.    9.30021E-09    5.88703E-05
    121700.    9.22704E-09    5.84072E-05
    121750.    9.15444E-09    5.79476E-05
    121800.    9.08242E-09    5.74917E-05
    121850.    9.01096E-09    5.70394E-05
    121900.    8.94006E-09    5.65906E-05
    121950.    8.86972E-09    5.61454E-05
    122000.    8.79994E-09    5.57036E-05
    122050.    8.73070E-09    5.52654E-05
    122100.    8.66201E-09    5.48305E-05
    122150.    8.59386E-09    5.43991E-05
    122200.    8.52625E-09    5.39711E-05
    122250.    8.45916E-09    5.35465E-05
    122300.    8.39261E-09    5.31252E-05
    122350.    8.32658E-09    5.27072E-05
    122400.    8.26107E-09    5.22926E-05
    122450.    8.19607E-09    5.18811E-05
    122500.    8.13159E-09    5.14729E-05
    122550.    8.06761E-09    5.10680E-05
    122600.    8.00413E-09    5.06662E-05
    122650.    7.94116E-09    5.02675E-05
    122700.    7.87868E-09    4.98720E-05
    122750.    7.81669E-09    4.94797E-05
    122800.    7.75519E-09    4.90904E-05
    122850.    7.69418E-09    4.87041E-05
    122900.    7.63364E-09    4.83209E-05
    122950.    7.57358E-09    4.79408E-05
    123000.    7.51399E-09    4.75636E-05
    123050.    7.45487E-09    4.71894E-05
    123100.    7.39622E-09    4.68181E-05
    123150.    7.33803E-09    4.64497E-05
    123200.    7.28030E-09    4.60843E-05
    123250.    7.22302E-09    4.57217E-05
    123300.    7.16619E-09    4.53620E-05
    123350.    7.10980E-09    4.50051E-05
    123400.    7.05387E-09    4.46510E-05
    123450.    6.99837E-09    4.42997E-05
    123500.    6.94331E-09    4.39511E-05
    123550.    6.88868E-09    4.36053E-05
    123600.    6.83448E-09    4.32623E-05
    123650.    6.78071E-09    4.29219E-05
    123700.    6.72736E-09    4.25842E-05
    123750.    6.67443E-09    4.22491E-05
    123800.    6.62192E-09    4.19167E-05
    123850.    6.56982E-09    4.15869E-05
    123900.    6.51813E-09    4.12597E-05
    123950.    6.46684E-09    4.09351E-05
    124000.    6.41596E-09    4.06130E-05
    124050.    6.36548E-09    4.02935E-05
    124100.    6.31540E-09    3.99765E-05
    124150.    6.26571E-09    3.96620E-05
    124200.    6.21642E-09    3.93499E-05
    124250.    6.16751E-09    3.90403E-05
    124300.    6.11898E-09    3.87332E-05
    124350.    6.07084E-09    3.84284E-05
    124400.    6.02307E-09    3.81261E-05
    124450.    5.97569E-09    3.78261E-05
    124500.    5.92867E-09    3.75285E-05
    124550.    5.88203E-09    3.72332E-05
    124600.    5.83575E-09    3.69403E-05
    124650.    5.78983E-09    3.66496E-05
    124700.    5.74428E-09    3.63613E-05
    124750.    5.69909E-09    3.60752E-05
    124800.    5.65425E-09    3.57914E-05
    124850.    5.60976E-09    3.55098E-05
    124900.    5.56562E-09    3.52304E-05
    124950.    5.52183E-09    3.49532E-05
    125000.    5.47839E-09    3.46782E-05
    125050.    5.43529E-09    3.44054E-05
    125100.    5.39252E-09    3.41347E-05
    125150.    5.35010E-09    3.38661E-05
    125200.    5.30800E-09    3.35997E-05
    125250.    5.26624E-09    3.33353E-05
    125300.    5.22481E-09    3.30730E-05
    125350.    5.18370E-09    3.28128E-05
    125400.    5.14291E-09    3.25546E-05
    125450.    5.10245E-09    3.22985E-05
    125500.    5.06231E-09    3.20444E-05
    125550.    5.02248E-09    3.17923E-05
    125600.    4.98296E-09    3.15421E-05
    125650.    4.94376E-09    3.12940E-05
    125700.    4.90486E-09    3.10478E-05
    125750.    4.86627E-09    3.08035E-05
    125800.    4.82798E-09    3.05611E-05
    125850.    4.79000E-09    3.03207E-05
    125900.    4.75231E-09    3.00821E-05
    125950.    4.71492E-09    2.98455E-05
    126000.    4.67783E-09    2.96106E-05
    126050.    4.64102E-09    2.93777E-05
    126100.    4.60451E-09    2.91465E-05
    126150.    4.56828E-09    2.89172E-05
    126200.    4.53234E-09    2.86897E-05
    126250.    4.49668E-09    2.84640E-05
    126300.    4.46130E-09    2.82400E-05
    126350.    4.42620E-09    2.80178E-05
    126400.    4.39137E-09    2.77974E-05
    126450.    4.35682E-09    2.75787E-05
    126500.    4.32254E-09    2.73617E-05
    126550.    4.28854E-09    2.71464E-05
    126600.    4.25479E-09    2.69329E-05
    126650.    4.22132E-09    2.67210E-05
    126700.    4.18811E-09    2.65107E-05
    126750.    4.15516E-09    2.63021E-05
    126800.    4.12246E-09    2.60952E-05
    126850.    4.09003E-09    2.58899E-05
    126900.    4.05785E-09    2.56862E-05
    126950.    4.02592E-09    2.54841E-05
    127000.    3.99425E-09    2.52836E-05
    127050.    3.96282E-09    2.50847E-05
    127100.    3.93164E-09    2.48873E-05
    127150.    3.90071E-09    2.46915E-05
    127200.    3.87002E-09    2.44972E-05
    127250.    3.83957E-09    2.43045E-05
    127300.    3.80936E-09    2.41133E-05
    127350.    3.77939E-09    2.39236E-05
    127400.    3.74966E-09    2.37353E-05
    127450.    3.72016E-09    2.35486E-05
    127500.    3.69089E-09    2.33633E-05
    127550.    3.66185E-09    2.31795E-05
    127600.    3.63304E-09    2.29971E-05
    127650.    3.60445E-09    2.28162E-05
    127700.    3.57609E-09    2.26367E-05
    127750.    3.54796E-09    2.24586E-05
    127800.    3.52004E-09    2.22819E-05
    127850.    3.49235E-09    2.21066E-05
    127900.    3.46487E-09    2.19326E-05
    127950.    3.43761E-09    2.17601E-05
    128000.    3.41056E-09    2.15889E-05
    128050.    3.38373E-09    2.14190E-05
    128100.    3.35711E-09    2.12505E-05
    128150.    3.33069E-09    2.10833E-05
    128200.    3.30449E-09    2.09174E-05
    128250.    3.27849E-09    2.07528E-05
    128300.    3.25270E-09    2.05896E-05
    128350.    3.22710E-09    2.04276E-05
    128400.    3.20171E-09    2.02669E-05
    128450.    3.17652E-09    2.01074E-05
    128500.    3.15153E-09    1.99492E-05
    128550.    3.12674E-09    1.97922E-05
    128600.    3.10214E-09    1.96365E-05
    128650.    3.07773E-09    1.94820E-05
    128700.    3.05351E-09    1.93287E-05
    128750.    3.02949E-09    1.91767E-05
    128800.    3.00565E-09    1.90258E-05
    128850.    2.98201E-09    1.88761E-05
    128900.    2.95854E-09    1.87276E-05
    128950.    2.93527E-09    1.85802E-05
    129000.    2.91217E-09    1.84341E-05
    129050.    2.88926E-09    1.82890E-05
    129100.    2.86653E-09    1.81451E-05
    129150.    2.84398E-09    1.80024E-05
    129200.    2.82160E-09    1.78607E-05
    129250.    2.79940E-09    1.77202E-05
    129300.    2.77738E-09    1.75808E-05
    129350.    2.75552E-09    1.74425E-05
    129400.    2.73384E-09    1.73052E-05
    129450.    2.71233E-09    1.71691E-05
    129500.    2.69099E-09    1.70340E-05
    129550.    2.66982E-09    1.69000E-05
    129600.    2.64882E-09    1.67670E-05
    129650.    2.62798E-09    1.66351E-05
    129700.    2.60730E-09    1.65042E-05
    129750.    2.58679E-09    1.63744E-05
    129800.    2.56643E-09    1.62455E-05
    129850.    2.54624E-09    1.61177E-05
    129900.    2.52621E-09    1.59909E-05
    129950.    2.50633E-09    1.58651E-05
    130000.    2.48661E-09    1.57403E-05
    130050.    2.46705E-09    1.56164E-05
    130100.    2.44764E-09    1.54936E-05
    130150.    2.42838E-09    1.53717E-05
    130200.    2.40928E-09    1.52507E-05
    130250.    2.39032E-09    1.51307E-05
    130300.    2.37151E-09    1.50117E-05
    130350.    2.35286E-09    1.48936E-05
    130400.    2.33434E-09    1.47764E-05
    130450.    2.31598E-09    1.46601E-05
    130500.    2.29776E-09    1.45448E-05
    130550.    2.27968E-09    1.44304E-05
    130600.    2.26174E-09    1.43168E-05
    130650.    2.24395E-09    1.42042E-05
    130700.    2.22629E-09    1.40924E-05
    130750.    2.20878E-09    1.39816E-05
    130800.    2.19140E-09    1.38715E-05
    130850.    2.17416E-09    1.37624E-05
    130900.    2.15705E-09    1.36541E-05
    130950.    2.14008E-09    1.35467E-05
    131000.    2.12324E-09    1.34401E-05
    131050.    2.10654E-09    1.33344E-05
    131100.    2.08996E-09    1.32295E-05
    131150.    2.07352E-09    1.31254E-05
    131200.    2.05721E-09    1.30221E-05
    131250.    2.04102E-09    1.29197E-05
    131300.    2.02496E-09    1.28180E-05
    131350.    2.00903E-09    1.27172E-05
    131400.    1.99322E-09    1.26171E-05
    131450.    1.97754E-09    1.25178E-05
    131500.    1.96198E-09    1.24193E-05
    131550.    1.94655E-09    1.23216E-05
    131600.    1.93123E-09    1.22247E-05
    131650.    1.91604E-09    1.21285E-05
    131700.    1.90096E-09    1.20331E-05
    131750.    1.88600E-09    1.19384E-05
    131800.    1.87117E-09    1.18445E-05
    131850.    1.85644E-09    1.17513E-05
    131900.    1.84184E-09    1.16588E-05
    131950.    1.82735E-09    1.15671E-05
    132000.    1.81297E-09    1.14761E-05
    132050.    1.79871E-09    1.13858E-05
    132100.    1.78455E-09    1.12962E-05
    132150.    1.77051E-09    1.12073E-05
    132200.    1.75658E-09    1.11192E-05
    132250.    1.74276E-09    1.10317E-05
    132300.    1.72905E-09    1.09449E-05
    132350.    1.71545E-09    1.08588E-05
    132400.    1.70195E-09    1.07733E-05
    132450.    1.68856E-09    1.06886E-05
    132500.    1.67527E-09    1.06045E-05
    132550.    1.66209E-09    1.05211E-05
    132600.    1.64902E-09    1.04383E-05
    132650.    1.63604E-09    1.03562E-05
    132700.    1.62317E-09    1.02747E-05
    132750.    1.61040E-09    1.01938E-05
    132800.    1.59773E-09    1.01136E-05
    132850.    1.58516E-09    1.00341E-05
    132900.    1.57269E-09    9.95511E-06
    132950.    1.56031E-09    9.87679E-06
    133000.    1.54804E-09    9.79908E-06
    133050.    1.53586E-09    9.72198E-06
    133100.    1.52377E-09    9.64549E-06
    133150.    1.51179E-09    9.56960E-06
    133200.    1.49989E-09    9.49431E-06
    133250.    1.48809E-09    9.41961E-06
    133300.    1.47638E-09    9.34550E-06
    133350.    1.46477E-09    9.27197E-06
    133400.    1.45324E-09    9.19902E-06
    133450.    1.44181E-09    9.12665E-06
    133500.    1.43046E-09    9.05484E-06
    133550.    1.41921E-09    8.98360E-06
    133600.    1.40804E-09    8.91292E-06
    133650.    1.39697E-09    8.84279E-06
    133700.    1.38597E-09    8.77322E-06
    133750.    1.37507E-09    8.70419E-06
    133800.    1.36425E-09    8.63571E-06
    133850.    1.35352E-09    8.56777E-06
    133900.    1.34287E-09    8.50036E-06
    133950.    1.33230E-09    8.43348E-06
    134000.    1.32182E-09    8.36713E-06
    134050.    1.31142E-09    8.30130E-06
    134100.    1.30110E-09    8.23598E-06
    134150.    1.29087E-09    8.17118E-06
    134200.    1.28071E-09    8.10689E-06
    134250.    1.27063E-09    8.04311E-06
    134300.    1.26064E-09    7.97983E-06
    134350.    1.25072E-09    7.91705E-06
    134400.    1.24088E-09    7.85476E-06
    134450.    1.23111E-09    7.79296E-06
    134500.    1.22143E-09    7.73164E-06
    134550.    1.21182E-09    7.67081E-06
    134600.    1.20228E-09    7.61046E-06
    134650.    1.19283E-09    7.55058E-06
    134700.    1.18344E-09    7.49118E-06
    134750.    1.17413E-09    7.43224E-06
    134800.    1.16489E-09    7.37376E-06
    134850.    1.15573E-09    7.31575E-06
    134900.    1.14663E-09    7.25819E-06
    134950.    1.13761E-09    7.20108E-06
    135000.    1.12866E-09    7.14443E-06
    135050.    1.11978E-09    7.08822E-06
    135100.    1.11097E-09    7.03245E-06
    135150.    1.10223E-09    6.97712E-06
    135200.    1.09356E-09    6.92222E-06
    135250.    1.08495E-09    6.86776E-06
    135300.    1.07642E-09    6.81373E-06
    135350.    1.06795E-09    6.76012E-06
    135400.    1.05955E-09    6.70693E-06
    135450.    1.05121E-09    6.65416E-06
    135500.    1.04294E-09    6.60181E-06
    135550.    1.03473E-09    6.54987E-06
    135600.    1.02659E-09    6.49833E-06
    135650.    1.01852E-09    6.44721E-06
    135700.    1.01050E-09    6.39648E-06
    135750.    1.00255E-09    6.34616E-06
    135800.    9.94664E-10    6.29623E-06
    135850.    9.86838E-10    6.24669E-06
    135900.    9.79074E-10    6.19754E-06
    135950.    9.71371E-10    6.14878E-06
    136000.    9.63729E-10    6.10040E-06
    136050.    9.56146E-10    6.05241E-06
    136100.    9.48624E-10    6.00479E-06
    136150.    9.41160E-10    5.95754E-06
    136200.    9.33755E-10    5.91067E-06
    136250.    9.26409E-10    5.86417E-06
    136300.    9.19120E-10    5.81803E-06
    136350.    9.11888E-10    5.77225E-06
    136400.    9.04714E-10    5.72684E-06
    136450.    8.97596E-10    5.68178E-06
    136500.    8.90534E-10    5.63708E-06
    136550.    8.83527E-10    5.59273E-06
    136600.    8.76576E-10    5.54872E-06
    136650.    8.69679E-10    5.50507E-06
    136700.    8.62837E-10    5.46175E-06
    136750.    8.56048E-10    5.41878E-06
    136800.    8.49313E-10    5.37615E-06
    136850.    8.42631E-10    5.33385E-06
    136900.    8.36001E-10    5.29189E-06
    136950.    8.29423E-10    5.25025E-06
    137000.    8.22898E-10    5.20894E-06
    137050.    8.16423E-10    5.16796E-06
    137100.    8.10000E-10    5.12730E-06
    137150.    8.03627E-10    5.08696E-06
    137200.    7.97304E-10    5.04694E-06
    137250.    7.91031E-10    5.00723E-06
    137300.    7.84807E-10    4.96783E-06
    137350.    7.78633E-10    4.92875E-06
    137400.    7.72507E-10    4.88997E-06
    137450.    7.66429E-10    4.85149E-06
    137500.    7.60399E-10    4.81332E-06
    137550.    7.54416E-10    4.77545E-06
    137600.    7.48480E-10    4.73788E-06
    137650.    7.42592E-10    4.70060E-06
    137700.    7.36749E-10    4.66362E-06
    137750.    7.30952E-10    4.62693E-06
    137800.    7.25202E-10    4.59053E-06
    137850.    7.19496E-10    4.55441E-06
    137900.    7.13835E-10    4.51858E-06
    137950.    7.08219E-10    4.48302E-06
    138000.    7.02647E-10    4.44775E-06
    138050.    6.97118E-10    4.41276E-06
    138100.    6.91633E-10    4.37804E-06
    138150.    6.86192E-10    4.34359E-06
    138200.    6.80793E-10    4.30942E-06
    138250.    6.75437E-10    4.27551E-06
    138300.    6.70123E-10    4.24188E-06
    138350.    6.64850E-10    4.20850E-06
    138400.    6.59619E-10    4.17539E-06
    138450.    6.54430E-10    4.14254E-06
    138500.    6.49281E-10    4.10995E-06
    138550.    6.44172E-10    4.07761E-06
    138600.    6.39104E-10    4.04553E-06
    138650.    6.34076E-10    4.01370E-06
    138700.    6.29087E-10    3.98212E-06
    138750.    6.24137E-10    3.95079E-06
    138800.    6.19227E-10    3.91971E-06
    138850.    6.14355E-10    3.88887E-06
    138900.    6.09521E-10    3.85827E-06
    138950.    6.04726E-10    3.82791E-06
    139000.    5.99968E-10    3.79780E-06
    139050.    5.95247E-10    3.76792E-06
    139100.    5.90564E-10    3.73827E-06
    139150.    5.85918E-10    3.70886E-06
    139200.    5.81308E-10    3.67968E-06
    139250.    5.76734E-10    3.65073E-06
    139300.    5.72197E-10    3.62200E-06
    139350.    5.67695E-10    3.59351E-06
    139400.    5.63228E-10    3.56523E-06
    139450.    5.58797E-10    3.53718E-06
    139500.    5.54400E-10    3.50935E-06
    139550.    5.50039E-10    3.48174E-06
    139600.    5.45711E-10    3.45435E-06
    139650.    5.41417E-10    3.42717E-06
    139700.    5.37158E-10    3.40021E-06
    139750.    5.32931E-10    3.37346E-06
    139800.    5.28738E-10    3.34691E-06
    139850.    5.24578E-10    3.32058E-06
    139900.    5.20451E-10    3.29446E-06
    139950.    5.16356E-10    3.26854E-06
    140000.    5.12294E-10    3.24282E-06
    140050.    5.08263E-10    3.21731E-06
    140100.    5.04264E-10    3.19199E-06
    140150.    5.00297E-10    3.16688E-06
    140200.    4.96361E-10    3.14196E-06
    140250.    4.92455E-10    3.11724E-06
    140300.    4.88581E-10    3.09272E-06
    140350.    4.84737E-10    3.06838E-06
    140400.    4.80923E-10    3.04424E-06
    140450.    4.77139E-10    3.02029E-06
    140500.    4.73385E-10    2.99653E-06
    140550.    4.69661E-10    2.97295E-06
    140600.    4.65965E-10    2.94956E-06
    140650.    4.62299E-10    2.92635E-06
    140700.    4.58662E-10    2.90333E-06
    140750.    4.55053E-10    2.88049E-06
    140800.    4.51473E-10    2.85782E-06
    140850.    4.47921E-10    2.83534E-06
    140900.    4.44397E-10    2.81303E-06
    140950.    4.40901E-10    2.79090E-06
    141000.    4.37432E-10    2.76894E-06
    141050.    4.33990E-10    2.74716E-06
    141100.    4.30575E-10    2.72554E-06
    141150.    4.27188E-10    2.70410E-06
    141200.    4.23827E-10    2.68282E-06
    141250.    4.20492E-10    2.66172E-06
    141300.    4.17184E-10    2.64077E-06
    141350.    4.13902E-10    2.62000E-06
    141400.    4.10645E-10    2.59938E-06
    141450.    4.07414E-10    2.57893E-06
    141500.    4.04209E-10    2.55864E-06
    141550.    4.01028E-10    2.53851E-06
    141600.    3.97873E-10    2.51854E-06
    141650.    3.94743E-10    2.49872E-06
    141700.    3.91637E-10    2.47906E-06
    141750.    3.88556E-10    2.45956E-06
    141800.    3.85499E-10    2.44021E-06
    141850.    3.82466E-10    2.42101E-06
    141900.    3.79457E-10    2.40196E-06
    141950.    3.76471E-10    2.38306E-06
    142000.    3.73509E-10    2.36431E-06
    142050.    3.70570E-10    2.34571E-06
    142100.    3.67655E-10    2.32726E-06
    142150.    3.64762E-10    2.30895E-06
    142200.    3.61892E-10    2.29078E-06
    142250.    3.59045E-10    2.27276E-06
    142300.    3.56220E-10    2.25487E-06
    142350.    3.53418E-10    2.23713E-06
    142400.    3.50637E-10    2.21953E-06
    142450.    3.47878E-10    2.20207E-06
    142500.    3.45141E-10    2.18474E-06
    142550.    3.42426E-10    2.16755E-06
    142600.    3.39732E-10    2.15050E-06
    142650.    3.37059E-10    2.13358E-06
    142700.    3.34407E-10    2.11679E-06
    142750.    3.31776E-10    2.10014E-06
    142800.    3.29165E-10    2.08362E-06
    142850.    3.26576E-10    2.06722E-06
    142900.    3.24006E-10    2.05096E-06
    142950.    3.21457E-10    2.03482E-06
    143000.    3.18928E-10    2.01881E-06
    143050.    3.16418E-10    2.00293E-06
    143100.    3.13929E-10    1.98717E-06
    143150.    3.11459E-10    1.97154E-06
    143200.    3.09009E-10    1.95602E-06
    143250.    3.06577E-10    1.94063E-06
    143300.    3.04165E-10    1.92537E-06
    143350.    3.01772E-10    1.91022E-06
    143400.    2.99398E-10    1.89519E-06
    143450.    2.97042E-10    1.88028E-06
    143500.    2.94705E-10    1.86548E-06
    143550.    2.92387E-10    1.85081E-06
    143600.    2.90086E-10    1.83625E-06
    143650.    2.87804E-10    1.82180E-06
    143700.    2.85539E-10    1.80746E-06
    143750.    2.83293E-10    1.79324E-06
    143800.    2.81064E-10    1.77913E-06
    143850.    2.78853E-10    1.76514E-06
    143900.    2.76659E-10    1.75125E-06
    143950.    2.74482E-10    1.73747E-06
    144000.    2.72322E-10    1.72380E-06
    144050.    2.70180E-10    1.71024E-06
    144100.    2.68054E-10    1.69678E-06
    144150.    2.65945E-10    1.68343E-06
    144200.    2.63853E-10    1.67019E-06
    144250.    2.61777E-10    1.65705E-06
    144300.    2.59717E-10    1.64401E-06
    144350.    2.57674E-10    1.63108E-06
    144400.    2.55646E-10    1.61824E-06
    144450.    2.53635E-10    1.60551E-06
    144500.    2.51640E-10    1.59288E-06
    144550.    2.49660E-10    1.58035E-06
    144600.    2.47695E-10    1.56791E-06
    144650.    2.45747E-10    1.55558E-06
    144700.    2.43813E-10    1.54334E-06
    144750.    2.41895E-10    1.53119E-06
    144800.    2.39992E-10    1.51915E-06
    144850.    2.38104E-10    1.50720E-06
    144900.    2.36230E-10    1.49534E-06
    144950.    2.34372E-10    1.48357E-06
    145000.    2.32528E-10    1.47190E-06
    145050.    2.30698E-10    1.46032E-06
    145100.    2.28883E-10    1.44883E-06
    145150.    2.27082E-10    1.43743E-06
    145200.    2.25296E-10    1.42612E-06
    145250.    2.23523E-10    1.41490E-06
    145300.    2.21764E-10    1.40377E-06
    145350.    2.20020E-10    1.39272E-06
    145400.    2.18289E-10    1.38177E-06
    145450.    2.16571E-10    1.37089E-06
    145500.    2.14867E-10    1.36011E-06
    145550.    2.13177E-10    1.34941E-06
    145600.    2.11499E-10    1.33879E-06
    145650.    2.09835E-10    1.32826E-06
    145700.    2.08184E-10    1.31781E-06
    145750.    2.06546E-10    1.30744E-06
    145800.    2.04921E-10    1.29715E-06
    145850.    2.03309E-10    1.28695E-06
    145900.    2.01710E-10    1.27682E-06
    145950.    2.00123E-10    1.26678E-06
    146000.    1.98548E-10    1.25681E-06
    146050.    1.96986E-10    1.24692E-06
    146100.    1.95436E-10    1.23711E-06
    146150.    1.93898E-10    1.22738E-06
    146200.    1.92373E-10    1.21772E-06
    146250.    1.90859E-10    1.20814E-06
    146300.    1.89358E-10    1.19863E-06
    146350.    1.87868E-10    1.18920E-06
    146400.    1.86390E-10    1.17985E-06
    146450.    1.84923E-10    1.17056E-06
    146500.    1.83468E-10    1.16135E-06
    146550.    1.82025E-10    1.15222E-06
    146600.    1.80593E-10    1.14315E-06
    146650.    1.79172E-10    1.13416E-06
    146700.    1.77762E-10    1.12523E-06
    146750.    1.76364E-10    1.11638E-06
    146800.    1.74976E-10    1.10760E-06
    146850.    1.73599E-10    1.09888E-06
    146900.    1.72233E-10    1.09024E-06
    146950.    1.70878E-10    1.08166E-06
    147000.    1.69534E-10    1.07315E-06
    147050.    1.68200E-10    1.06471E-06
    147100.    1.66877E-10    1.05633E-06
    147150.    1.65564E-10    1.04802E-06
    147200.    1.64261E-10    1.03977E-06
    147250.    1.62969E-10    1.03159E-06
    147300.    1.61687E-10    1.02348E-06
    147350.    1.60414E-10    1.01542E-06
    147400.    1.59152E-10    1.00743E-06
    147450.    1.57900E-10    9.99508E-07
    147500.    1.56658E-10    9.91644E-07
    147550.    1.55425E-10    9.83842E-07
    147600.    1.54202E-10    9.76101E-07
    147650.    1.52989E-10    9.68422E-07
    147700.    1.51786E-10    9.60802E-07
    147750.    1.50591E-10    9.53243E-07
    147800.    1.49406E-10    9.45743E-07
    147850.    1.48231E-10    9.38302E-07
    147900.    1.47065E-10    9.30920E-07
    147950.    1.45908E-10    9.23596E-07
    148000.    1.44760E-10    9.16329E-07
    148050.    1.43621E-10    9.09119E-07
    148100.    1.42491E-10    9.01967E-07
    148150.    1.41370E-10    8.94870E-07
    148200.    1.40257E-10    8.87830E-07
    148250.    1.39154E-10    8.80844E-07
    148300.    1.38059E-10    8.73914E-07
    148350.    1.36973E-10    8.67038E-07
    148400.    1.35895E-10    8.60217E-07
    148450.    1.34826E-10    8.53449E-07
    148500.    1.33765E-10    8.46734E-07
    148550.    1.32713E-10    8.40072E-07
    148600.    1.31669E-10    8.33462E-07
    148650.    1.30633E-10    8.26905E-07
    148700.    1.29605E-10    8.20399E-07
    148750.    1.28585E-10    8.13944E-07
    148800.    1.27574E-10    8.07540E-07
    148850.    1.26570E-10    8.01187E-07
    148900.    1.25574E-10    7.94883E-07
    148950.    1.24586E-10    7.88629E-07
    149000.    1.23606E-10    7.82425E-07
    149050.    1.22633E-10    7.76269E-07
    149100.    1.21668E-10    7.70161E-07
    149150.    1.20711E-10    7.64102E-07
    149200.    1.19761E-10    7.58090E-07
    149250.    1.18819E-10    7.52125E-07
    149300.    1.17884E-10    7.46208E-07
    149350.    1.16957E-10    7.40337E-07
    149400.    1.16037E-10    7.34512E-07
    149450.    1.15124E-10    7.28733E-07
    149500.    1.14218E-10    7.23000E-07
    149550.    1.13319E-10    7.17311E-07
    149600.    1.12428E-10    7.11667E-07
    149650.    1.11543E-10    7.06068E-07
    149700.    1.10666E-10    7.00513E-07
    149750.    1.09795E-10    6.95002E-07
    149800.    1.08931E-10    6.89533E-07
    149850.    1.08074E-10    6.84108E-07
    149900.    1.07224E-10    6.78726E-07
    149950.    1.06380E-10    6.73386E-07
    150000.    1.05543E-10    6.68088E-07
    150050.    1.04713E-10    6.62831E-07
    150100.    1.03889E-10    6.57616E-07
    150150.    1.03071E-10    6.52442E-07
    150200.    1.02261E-10    6.47309E-07
    150250.    1.01456E-10    6.42216E-07
    150300.    1.00658E-10    6.37163E-07
    150350.    9.98658E-11    6.32150E-07
    150400.    9.90801E-11    6.27177E-07
    150450.    9.83005E-11    6.22242E-07
    150500.    9.75271E-11    6.17347E-07
    150550.    9.67598E-11    6.12489E-07
    150600.    9.59985E-11    6.07671E-07
    150650.    9.52432E-11    6.02890E-07
    150700.    9.44939E-11    5.98146E-07
    150750.    9.37504E-11    5.93440E-07
    150800.    9.30128E-11    5.88771E-07
    150850.    9.22810E-11    5.84139E-07
    150900.    9.15549E-11    5.79543E-07
    150950.    9.08346E-11    5.74983E-07
    151000.    9.01199E-11    5.70459E-07
    151050.    8.94109E-11    5.65971E-07
    151100.    8.87074E-11    5.61518E-07
    151150.    8.80095E-11    5.57100E-07
    151200.    8.73171E-11    5.52717E-07
    151250.    8.66301E-11    5.48368E-07
    151300.    8.59485E-11    5.44054E-07
    151350.    8.52723E-11    5.39773E-07
    151400.    8.46014E-11    5.35527E-07
    151450.    8.39357E-11    5.31313E-07
    151500.    8.32753E-11    5.27133E-07
    151550.    8.26202E-11    5.22986E-07
    151600.    8.19701E-11    5.18871E-07
    151650.    8.13252E-11    5.14788E-07
    151700.    8.06853E-11    5.10738E-07
    151750.    8.00505E-11    5.06720E-07
    151800.    7.94207E-11    5.02733E-07
    151850.    7.87958E-11    4.98778E-07
    151900.    7.81759E-11    4.94853E-07
    151950.    7.75608E-11    4.90960E-07
    152000.    7.69506E-11    4.87097E-07
    152050.    7.63452E-11    4.83265E-07
    152100.    7.57445E-11    4.79463E-07
    152150.    7.51486E-11    4.75690E-07
    152200.    7.45573E-11    4.71948E-07
    152250.    7.39707E-11    4.68235E-07
    152300.    7.33887E-11    4.64551E-07
    152350.    7.28113E-11    4.60896E-07
    152400.    7.22385E-11    4.57269E-07
    152450.    7.16701E-11    4.53672E-07
    152500.    7.11062E-11    4.50102E-07
    152550.    7.05468E-11    4.46561E-07
    152600.    6.99917E-11    4.43048E-07
    152650.    6.94410E-11    4.39562E-07
    152700.    6.88947E-11    4.36103E-07
    152750.    6.83526E-11    4.32672E-07
    152800.    6.78149E-11    4.29268E-07
    152850.    6.72813E-11    4.25891E-07
    152900.    6.67520E-11    4.22540E-07
    152950.    6.62268E-11    4.19215E-07
    153000.    6.57057E-11    4.15917E-07
    153050.    6.51887E-11    4.12645E-07
    153100.    6.46759E-11    4.09398E-07
    153150.    6.41670E-11    4.06177E-07
    153200.    6.36621E-11    4.02981E-07
    153250.    6.31613E-11    3.99811E-07
    153300.    6.26643E-11    3.96665E-07
    153350.    6.21713E-11    3.93544E-07
    153400.    6.16822E-11    3.90448E-07
    153450.    6.11968E-11    3.87376E-07
    153500.    6.07154E-11    3.84328E-07
    153550.    6.02377E-11    3.81304E-07
    153600.    5.97637E-11    3.78304E-07
    153650.    5.92935E-11    3.75328E-07
    153700.    5.88270E-11    3.72375E-07
    153750.    5.83642E-11    3.69445E-07
    153800.    5.79050E-11    3.66539E-07
    153850.    5.74494E-11    3.63655E-07
    153900.    5.69974E-11    3.60794E-07
    153950.    5.65490E-11    3.57955E-07
    154000.    5.61040E-11    3.55139E-07
    154050.    5.56626E-11    3.52344E-07
    154100.    5.52247E-11    3.49572E-07
    154150.    5.47902E-11    3.46822E-07
    154200.    5.43591E-11    3.44093E-07
    154250.    5.39314E-11    3.41386E-07
    154300.    5.35071E-11    3.38700E-07
    154350.    5.30861E-11    3.36035E-07
    154400.    5.26685E-11    3.33391E-07
    154450.    5.22541E-11    3.30768E-07
    154500.    5.18429E-11    3.28166E-07
    154550.    5.14351E-11    3.25584E-07
    154600.    5.10304E-11    3.23022E-07
    154650.    5.06289E-11    3.20481E-07
    154700.    5.02305E-11    3.17959E-07
    154750.    4.98353E-11    3.15458E-07
    154800.    4.94432E-11    3.12976E-07
    154850.    4.90542E-11    3.10513E-07
    154900.    4.86683E-11    3.08070E-07
    154950.    4.82854E-11    3.05646E-07
    155000.    4.79055E-11    3.03242E-07
    155050.    4.75286E-11    3.00856E-07
    155100.    4.71546E-11    2.98489E-07
    155150.    4.67836E-11    2.96140E-07
    155200.    4.64155E-11    2.93810E-07
    155250.    4.60504E-11    2.91499E-07
    155300.    4.56880E-11    2.89205E-07
    155350.    4.53286E-11    2.86930E-07
    155400.    4.49719E-11    2.84672E-07
    155450.    4.46181E-11    2.82433E-07
    155500.    4.42671E-11    2.80211E-07
    155550.    4.39188E-11    2.78006E-07
    155600.    4.35732E-11    2.75819E-07
    155650.    4.32304E-11    2.73649E-07
    155700.    4.28903E-11    2.71496E-07
    155750.    4.25528E-11    2.69359E-07
    155800.    4.22180E-11    2.67240E-07
    155850.    4.18859E-11    2.65138E-07
    155900.    4.15563E-11    2.63052E-07
    155950.    4.12294E-11    2.60982E-07
    156000.    4.09050E-11    2.58929E-07
    156050.    4.05832E-11    2.56891E-07
    156100.    4.02639E-11    2.54870E-07
    156150.    3.99471E-11    2.52865E-07
    156200.    3.96328E-11    2.50875E-07
    156250.    3.93210E-11    2.48902E-07
    156300.    3.90116E-11    2.46943E-07
    156350.    3.87047E-11    2.45000E-07
    156400.    3.84001E-11    2.43073E-07
    156450.    3.80980E-11    2.41160E-07
    156500.    3.77983E-11    2.39263E-07
    156550.    3.75009E-11    2.37381E-07
    156600.    3.72058E-11    2.35513E-07
    156650.    3.69131E-11    2.33660E-07
    156700.    3.66227E-11    2.31822E-07
    156750.    3.63345E-11    2.29998E-07
    156800.    3.60487E-11    2.28188E-07
    156850.    3.57650E-11    2.26393E-07
    156900.    3.54836E-11    2.24611E-07
    156950.    3.52045E-11    2.22844E-07
    157000.    3.49275E-11    2.21091E-07
    157050.    3.46527E-11    2.19352E-07
    157100.    3.43800E-11    2.17626E-07
    157150.    3.41096E-11    2.15913E-07
    157200.    3.38412E-11    2.14215E-07
    157250.    3.35749E-11    2.12529E-07
    157300.    3.33108E-11    2.10857E-07
    157350.    3.30487E-11    2.09198E-07
    157400.    3.27887E-11    2.07552E-07
    157450.    3.25307E-11    2.05919E-07
    157500.    3.22748E-11    2.04299E-07
    157550.    3.20208E-11    2.02692E-07
    157600.    3.17689E-11    2.01097E-07
    157650.    3.15189E-11    1.99515E-07
    157700.    3.12710E-11    1.97945E-07
    157750.    3.10249E-11    1.96388E-07
    157800.    3.07808E-11    1.94843E-07
    157850.    3.05386E-11    1.93310E-07
    157900.    3.02984E-11    1.91789E-07
    157950.    3.00600E-11    1.90280E-07
    158000.    2.98235E-11    1.88783E-07
    158050.    2.95888E-11    1.87297E-07
    158100.    2.93560E-11    1.85824E-07
    158150.    2.91251E-11    1.84362E-07
    158200.    2.88959E-11    1.82911E-07
    158250.    2.86686E-11    1.81472E-07
    158300.    2.84430E-11    1.80044E-07
    158350.    2.82192E-11    1.78628E-07
    158400.    2.79972E-11    1.77222E-07
    158450.    2.77769E-11    1.75828E-07
    158500.    2.75584E-11    1.74445E-07
    158550.    2.73416E-11    1.73072E-07
    158600.    2.71265E-11    1.71710E-07
    158650.    2.69130E-11    1.70359E-07
    158700.    2.67013E-11    1.69019E-07
    158750.    2.64912E-11    1.67689E-07
    158800.    2.62828E-11    1.66370E-07
    158850.    2.60760E-11    1.65061E-07
    158900.    2.58708E-11    1.63762E-07
    158950.    2.56673E-11    1.62474E-07
    159000.    2.54653E-11    1.61196E-07
    159050.    2.52650E-11    1.59927E-07
    159100.    2.50662E-11    1.58669E-07
    159150.    2.48690E-11    1.57421E-07
    159200.    2.46733E-11    1.56182E-07
    159250.    2.44792E-11    1.54953E-07
    159300.    2.42866E-11    1.53734E-07
    159350.    2.40955E-11    1.52525E-07
    159400.    2.39059E-11    1.51325E-07
    159450.    2.37179E-11    1.50134E-07
    159500.    2.35313E-11    1.48953E-07
    159550.    2.33461E-11    1.47781E-07
    159600.    2.31624E-11    1.46618E-07
    159650.    2.29802E-11    1.45465E-07
    159700.    2.27994E-11    1.44320E-07
    159750.    2.26200E-11    1.43185E-07
    159800.    2.24420E-11    1.42058E-07
    159850.    2.22655E-11    1.40940E-07
    159900.    2.20903E-11    1.39832E-07
    159950.    2.19165E-11    1.38731E-07
    160000.    2.17441E-11    1.37640E-07
    160050.    2.15730E-11    1.36557E-07
    160100.    2.14032E-11    1.35483E-07
    160150.    2.12349E-11    1.34417E-07
    160200.    2.10678E-11    1.33359E-07
    160250.    2.09020E-11    1.32310E-07
    160300.    2.07376E-11    1.31269E-07
    160350.    2.05744E-11    1.30236E-07
    160400.    2.04125E-11    1.29211E-07
    160450.    2.02519E-11    1.28195E-07
    160500.    2.00926E-11    1.27186E-07
    160550.    1.99345E-11    1.26185E-07
    160600.    1.97777E-11    1.25193E-07
    160650.    1.96221E-11    1.24208E-07
    160700.    1.94677E-11    1.23230E-07
    160750.    1.93145E-11    1.22261E-07
    160800.    1.91626E-11    1.21299E-07
    160850.    1.90118E-11    1.20345E-07
    160900.    1.88622E-11    1.19398E-07
    160950.    1.87138E-11    1.18458E-07
    161000.    1.85666E-11    1.17526E-07
    161050.    1.84205E-11    1.16602E-07
    161100.    1.82756E-11    1.15684E-07
    161150.    1.81318E-11    1.14774E-07
    161200.    1.79891E-11    1.13871E-07
    161250.    1.78476E-11    1.12975E-07
    161300.    1.77072E-11    1.12086E-07
    161350.    1.75678E-11    1.11204E-07
    161400.    1.74296E-11    1.10330E-07
    161450.    1.72925E-11    1.09461E-07
    161500.    1.71564E-11    1.08600E-07
    161550.    1.70215E-11    1.07746E-07
    161600.    1.68875E-11    1.06898E-07
    161650.    1.67547E-11    1.06057E-07
    161700.    1.66228E-11    1.05223E-07
    161750.    1.64921E-11    1.04395E-07
    161800.    1.63623E-11    1.03573E-07
    161850.    1.62336E-11    1.02759E-07
    161900.    1.61059E-11    1.01950E-07
    161950.    1.59791E-11    1.01148E-07
    162000.    1.58534E-11    1.00352E-07
    162050.    1.57287E-11    9.95626E-08
    162100.    1.56049E-11    9.87792E-08
    162150.    1.54822E-11    9.80020E-08
    162200.    1.53603E-11    9.72310E-08
    162250.    1.52395E-11    9.64660E-08
    162300.    1.51196E-11    9.57070E-08
    162350.    1.50006E-11    9.49540E-08
    162400.    1.48826E-11    9.42069E-08
    162450.    1.47655E-11    9.34657E-08
    162500.    1.46493E-11    9.27304E-08
    162550.    1.45341E-11    9.20008E-08
    162600.    1.44197E-11    9.12770E-08
    162650.    1.43063E-11    9.05588E-08
    162700.    1.41937E-11    8.98463E-08
    162750.    1.40821E-11    8.91394E-08
    162800.    1.39713E-11    8.84381E-08
    162850.    1.38613E-11    8.77423E-08
    162900.    1.37523E-11    8.70519E-08
    162950.    1.36441E-11    8.63670E-08
    163000.    1.35367E-11    8.56875E-08
    163050.    1.34302E-11    8.50133E-08
    163100.    1.33246E-11    8.43445E-08
    163150.    1.32197E-11    8.36809E-08
    163200.    1.31157E-11    8.30225E-08
    163250.    1.30125E-11    8.23693E-08
    163300.    1.29101E-11    8.17212E-08
    163350.    1.28086E-11    8.10783E-08
    163400.    1.27078E-11    8.04404E-08
    163450.    1.26078E-11    7.98075E-08
    163500.    1.25086E-11    7.91796E-08
    163550.    1.24102E-11    7.85566E-08
    163600.    1.23126E-11    7.79385E-08
    163650.    1.22157E-11    7.73253E-08
    163700.    1.21196E-11    7.67169E-08
    163750.    1.20242E-11    7.61134E-08
    163800.    1.19296E-11    7.55145E-08
    163850.    1.18358E-11    7.49204E-08
    163900.    1.17426E-11    7.43309E-08
    163950.    1.16503E-11    7.37461E-08
    164000.    1.15586E-11    7.31659E-08
    164050.    1.14677E-11    7.25902E-08
    164100.    1.13774E-11    7.20191E-08
    164150.    1.12879E-11    7.14525E-08
    164200.    1.11991E-11    7.08903E-08
    164250.    1.11110E-11    7.03326E-08
    164300.    1.10236E-11    6.97792E-08
    164350.    1.09368E-11    6.92302E-08
    164400.    1.08508E-11    6.86855E-08
    164450.    1.07654E-11    6.81451E-08
    164500.    1.06807E-11    6.76089E-08
    164550.    1.05967E-11    6.70770E-08
    164600.    1.05133E-11    6.65493E-08
    164650.    1.04306E-11    6.60257E-08
    164700.    1.03485E-11    6.55062E-08
    164750.    1.02671E-11    6.49908E-08
    164800.    1.01863E-11    6.44795E-08
    164850.    1.01062E-11    6.39722E-08
    164900.    1.00267E-11    6.34688E-08
    164950.    9.94779E-12    6.29695E-08
    165000.    9.86952E-12    6.24741E-08
    165050.    9.79187E-12    6.19825E-08
    165100.    9.71483E-12    6.14949E-08
    165150.    9.63839E-12    6.10110E-08
    165200.    9.56256E-12    6.05310E-08
    165250.    9.48732E-12    6.00548E-08
    165300.    9.41268E-12    5.95823E-08
    165350.    9.33862E-12    5.91135E-08
    165400.    9.26515E-12    5.86484E-08
    165450.    9.19225E-12    5.81870E-08
    165500.    9.11993E-12    5.77292E-08
    165550.    9.04818E-12    5.72750E-08
    165600.    8.97699E-12    5.68243E-08
    165650.    8.90636E-12    5.63773E-08
    165700.    8.83629E-12    5.59337E-08
    165750.    8.76676E-12    5.54936E-08
    165800.    8.69779E-12    5.50570E-08
    165850.    8.62936E-12    5.46238E-08
    165900.    8.56146E-12    5.41941E-08
    165950.    8.49410E-12    5.37677E-08
    166000.    8.42727E-12    5.33446E-08
    166050.    8.36097E-12    5.29249E-08
    166100.    8.29519E-12    5.25085E-08
    166150.    8.22992E-12    5.20954E-08
    166200.    8.16517E-12    5.16855E-08
    166250.    8.10093E-12    5.12789E-08
    166300.    8.03719E-12    5.08754E-08
    166350.    7.97396E-12    5.04752E-08
    166400.    7.91122E-12    5.00780E-08
    166450.    7.84898E-12    4.96840E-08
    166500.    7.78722E-12    4.92931E-08
    166550.    7.72595E-12    4.89053E-08
    166600.    7.66517E-12    4.85205E-08
    166650.    7.60486E-12    4.81388E-08
    166700.    7.54503E-12    4.77600E-08
    166750.    7.48566E-12    4.73843E-08
    166800.    7.42677E-12    4.70115E-08
    166850.    7.36834E-12    4.66416E-08
    166900.    7.31036E-12    4.62746E-08
    166950.    7.25285E-12    4.59105E-08
    167000.    7.19578E-12    4.55493E-08
    167050.    7.13917E-12    4.51909E-08
    167100.    7.08300E-12    4.48354E-08
    167150.    7.02727E-12    4.44826E-08
    167200.    6.97198E-12    4.41327E-08
    167250.    6.91713E-12    4.37854E-08
    167300.    6.86271E-12    4.34409E-08
    167350.    6.80871E-12    4.30992E-08
    167400.    6.75514E-12    4.27601E-08
    167450.    6.70200E-12    4.24236E-08
    167500.    6.64927E-12    4.20899E-08
    167550.    6.59695E-12    4.17587E-08
    167600.    6.54505E-12    4.14301E-08
    167650.    6.49355E-12    4.11042E-08
    167700.    6.44246E-12    4.07808E-08
    167750.    6.39177E-12    4.04599E-08
    167800.    6.34149E-12    4.01416E-08
    167850.    6.29159E-12    3.98258E-08
    167900.    6.24209E-12    3.95124E-08
    167950.    6.19298E-12    3.92016E-08
    168000.    6.14425E-12    3.88931E-08
    168050.    6.09591E-12    3.85871E-08
    168100.    6.04795E-12    3.82835E-08
    168150.    6.00037E-12    3.79823E-08
    168200.    5.95316E-12    3.76835E-08
    168250.    5.90632E-12    3.73870E-08
    168300.    5.85985E-12    3.70929E-08
    168350.    5.81375E-12    3.68010E-08
    168400.    5.76801E-12    3.65115E-08
    168450.    5.72262E-12    3.62242E-08
    168500.    5.67760E-12    3.59392E-08
    168550.    5.63293E-12    3.56564E-08
    168600.    5.58861E-12    3.53759E-08
    168650.    5.54464E-12    3.50976E-08
    168700.    5.50102E-12    3.48214E-08
    168750.    5.45774E-12    3.45475E-08
    168800.    5.41480E-12    3.42757E-08
    168850.    5.37219E-12    3.40060E-08
    168900.    5.32993E-12    3.37384E-08
    168950.    5.28799E-12    3.34730E-08
    169000.    5.24639E-12    3.32096E-08
    169050.    5.20511E-12    3.29483E-08
    169100.    5.16416E-12    3.26891E-08
    169150.    5.12353E-12    3.24319E-08
    169200.    5.08322E-12    3.21768E-08
    169250.    5.04322E-12    3.19236E-08
    169300.    5.00354E-12    3.16724E-08
    169350.    4.96418E-12    3.14232E-08
    169400.    4.92512E-12    3.11760E-08
    169450.    4.88637E-12    3.09307E-08
    169500.    4.84792E-12    3.06874E-08
    169550.    4.80978E-12    3.04459E-08
    169600.    4.77194E-12    3.02064E-08
    169650.    4.73440E-12    2.99687E-08
    169700.    4.69715E-12    2.97329E-08
    169750.    4.66019E-12    2.94990E-08
    169800.    4.62352E-12    2.92669E-08
    169850.    4.58715E-12    2.90366E-08
    169900.    4.55106E-12    2.88082E-08
    169950.    4.51525E-12    2.85815E-08
    170000.    4.47973E-12    2.83567E-08
    170050.    4.44448E-12    2.81336E-08
    170100.    4.40951E-12    2.79122E-08
    170150.    4.37482E-12    2.76926E-08
    170200.    4.34040E-12    2.74747E-08
    170250.    4.30625E-12    2.72586E-08
    170300.    4.27237E-12    2.70441E-08
    170350.    4.23875E-12    2.68313E-08
    170400.    4.20540E-12    2.66202E-08
    170450.    4.17232E-12    2.64108E-08
    170500.    4.13949E-12    2.62030E-08
    170550.    4.10692E-12    2.59968E-08
    170600.    4.07461E-12    2.57923E-08
    170650.    4.04255E-12    2.55894E-08
    170700.    4.01075E-12    2.53880E-08
    170750.    3.97919E-12    2.51883E-08
    170800.    3.94788E-12    2.49901E-08
    170850.    3.91682E-12    2.47935E-08
    170900.    3.88600E-12    2.45984E-08
    170950.    3.85543E-12    2.44049E-08
    171000.    3.82510E-12    2.42129E-08
    171050.    3.79500E-12    2.40224E-08
    171100.    3.76514E-12    2.38334E-08
    171150.    3.73552E-12    2.36458E-08
    171200.    3.70613E-12    2.34598E-08
    171250.    3.67697E-12    2.32752E-08
    171300.    3.64804E-12    2.30921E-08
    171350.    3.61934E-12    2.29104E-08
    171400.    3.59086E-12    2.27302E-08
    171450.    3.56261E-12    2.25513E-08
    171500.    3.53458E-12    2.23739E-08
    171550.    3.50677E-12    2.21979E-08
    171600.    3.47918E-12    2.20232E-08
    171650.    3.45181E-12    2.18499E-08
    171700.    3.42465E-12    2.16780E-08
    171750.    3.39771E-12    2.15075E-08
    171800.    3.37097E-12    2.13383E-08
    171850.    3.34445E-12    2.11704E-08
    171900.    3.31814E-12    2.10038E-08
    171950.    3.29203E-12    2.08386E-08
    172000.    3.26613E-12    2.06746E-08
    172050.    3.24043E-12    2.05119E-08
    172100.    3.21494E-12    2.03506E-08
    172150.    3.18964E-12    2.01904E-08
    172200.    3.16455E-12    2.00316E-08
    172250.    3.13965E-12    1.98740E-08
    172300.    3.11495E-12    1.97176E-08
    172350.    3.09044E-12    1.95625E-08
    172400.    3.06613E-12    1.94086E-08
    172450.    3.04200E-12    1.92559E-08
    172500.    3.01807E-12    1.91044E-08
    172550.    2.99432E-12    1.89541E-08
    172600.    2.97076E-12    1.88049E-08
    172650.    2.94739E-12    1.86570E-08
    172700.    2.92420E-12    1.85102E-08
    172750.    2.90119E-12    1.83646E-08
    172800.    2.87837E-12    1.82201E-08
    172850.    2.85572E-12    1.80767E-08
    172900.    2.83325E-12    1.79345E-08
    172950.    2.81096E-12    1.77934E-08
    173000.    2.78885E-12    1.76534E-08
    173050.    2.76690E-12    1.75145E-08
    173100.    2.74514E-12    1.73767E-08
    173150.    2.72354E-12    1.72400E-08
    173200.    2.70211E-12    1.71043E-08
    173250.    2.68085E-12    1.69698E-08
    173300.    2.65976E-12    1.68363E-08
    173350.    2.63883E-12    1.67038E-08
    173400.    2.61807E-12    1.65724E-08
    173450.    2.59747E-12    1.64420E-08
    173500.    2.57703E-12    1.63126E-08
    173550.    2.55676E-12    1.61843E-08
    173600.    2.53664E-12    1.60569E-08
    173650.    2.51668E-12    1.59306E-08
    173700.    2.49688E-12    1.58053E-08
    173750.    2.47724E-12    1.56809E-08
    173800.    2.45775E-12    1.55575E-08
    173850.    2.43841E-12    1.54351E-08
    173900.    2.41923E-12    1.53137E-08
    173950.    2.40019E-12    1.51932E-08
    174000.    2.38131E-12    1.50737E-08
    174050.    2.36257E-12    1.49551E-08
    174100.    2.34398E-12    1.48374E-08
    174150.    2.32554E-12    1.47207E-08
    174200.    2.30725E-12    1.46049E-08
    174250.    2.28909E-12    1.44900E-08
    174300.    2.27108E-12    1.43760E-08
    174350.    2.25321E-12    1.42628E-08
    174400.    2.23549E-12    1.41506E-08
    174450.    2.21790E-12    1.40393E-08
    174500.    2.20045E-12    1.39288E-08
    174550.    2.18314E-12    1.38193E-08
    174600.    2.16596E-12    1.37105E-08
    174650.    2.14892E-12    1.36027E-08
    174700.    2.13201E-12    1.34956E-08
    174750.    2.11524E-12    1.33894E-08
    174800.    2.09859E-12    1.32841E-08
    174850.    2.08208E-12    1.31796E-08
    174900.    2.06570E-12    1.30759E-08
    174950.    2.04945E-12    1.29730E-08
    175000.    2.03332E-12    1.28709E-08
    175050.    2.01733E-12    1.27697E-08
    175100.    2.00146E-12    1.26692E-08
    175150.    1.98571E-12    1.25695E-08
    175200.    1.97009E-12    1.24706E-08
    175250.    1.95458E-12    1.23725E-08
    175300.    1.93921E-12    1.22752E-08
    175350.    1.92395E-12    1.21786E-08
    175400.    1.90881E-12    1.20828E-08
    175450.    1.89379E-12    1.19877E-08
    175500.    1.87889E-12    1.18934E-08
    175550.    1.86411E-12    1.17998E-08
    175600.    1.84944E-12    1.17070E-08
    175650.    1.83489E-12    1.16149E-08
    175700.    1.82046E-12    1.15235E-08
    175750.    1.80613E-12    1.14328E-08
    175800.    1.79192E-12    1.13429E-08
    175850.    1.77783E-12    1.12536E-08
    175900.    1.76384E-12    1.11651E-08
    175950.    1.74996E-12    1.10773E-08
    176000.    1.73619E-12    1.09901E-08
    176050.    1.72253E-12    1.09036E-08
    176100.    1.70898E-12    1.08178E-08
    176150.    1.69553E-12    1.07327E-08
    176200.    1.68219E-12    1.06483E-08
    176250.    1.66896E-12    1.05645E-08
    176300.    1.65583E-12    1.04814E-08
    176350.    1.64280E-12    1.03989E-08
    176400.    1.62987E-12    1.03171E-08
    176450.    1.61705E-12    1.02359E-08
    176500.    1.60433E-12    1.01554E-08
    176550.    1.59171E-12    1.00755E-08
    176600.    1.57918E-12    9.99623E-09
    176650.    1.56676E-12    9.91758E-09
    176700.    1.55443E-12    9.83955E-09
    176750.    1.54220E-12    9.76214E-09
    176800.    1.53007E-12    9.68533E-09
    176850.    1.51803E-12    9.60913E-09
    176900.    1.50609E-12    9.53353E-09
    176950.    1.49424E-12    9.45852E-09
    177000.    1.48248E-12    9.38410E-09
    177050.    1.47082E-12    9.31027E-09
    177100.    1.45924E-12    9.23702E-09
    177150.    1.44776E-12    9.16434E-09
    177200.    1.43637E-12    9.09224E-09
    177250.    1.42507E-12    9.02070E-09
    177300.    1.41386E-12    8.94973E-09
    177350.    1.40274E-12    8.87932E-09
    177400.    1.39170E-12    8.80946E-09
    177450.    1.38075E-12    8.74014E-09
    177500.    1.36989E-12    8.67138E-09
    177550.    1.35911E-12    8.60315E-09
    177600.    1.34841E-12    8.53547E-09
    177650.    1.33781E-12    8.46831E-09
    177700.    1.32728E-12    8.40168E-09
    177750.    1.31684E-12    8.33558E-09
    177800.    1.30648E-12    8.27000E-09
    177850.    1.29620E-12    8.20493E-09
    177900.    1.28600E-12    8.14038E-09
    177950.    1.27588E-12    8.07633E-09
    178000.    1.26584E-12    8.01279E-09
    178050.    1.25588E-12    7.94975E-09
    178100.    1.24600E-12    7.88720E-09
    178150.    1.23620E-12    7.82514E-09
    178200.    1.22647E-12    7.76358E-09
    178250.    1.21682E-12    7.70250E-09
    178300.    1.20725E-12    7.64189E-09
    178350.    1.19775E-12    7.58177E-09
    178400.    1.18833E-12    7.52212E-09
    178450.    1.17898E-12    7.46294E-09
    178500.    1.16970E-12    7.40422E-09
    178550.    1.16050E-12    7.34596E-09
    178600.    1.15137E-12    7.28817E-09
    178650.    1.14231E-12    7.23083E-09
    178700.    1.13332E-12    7.17394E-09
    178750.    1.12441E-12    7.11749E-09
    178800.    1.11556E-12    7.06149E-09
    178850.    1.10678E-12    7.00594E-09
    178900.    1.09807E-12    6.95081E-09
    178950.    1.08944E-12    6.89613E-09
    179000.    1.08086E-12    6.84187E-09
    179050.    1.07236E-12    6.78804E-09
    179100.    1.06392E-12    6.73463E-09
    179150.    1.05555E-12    6.68165E-09
    179200.    1.04725E-12    6.62908E-09
    179250.    1.03901E-12    6.57692E-09
    179300.    1.03083E-12    6.52517E-09
    179350.    1.02272E-12    6.47384E-09
    179400.    1.01468E-12    6.42290E-09
    179450.    1.00669E-12    6.37237E-09
    179500.    9.98773E-13    6.32223E-09
    179550.    9.90914E-13    6.27249E-09
    179600.    9.83118E-13    6.22314E-09
    179650.    9.75383E-13    6.17418E-09
    179700.    9.67709E-13    6.12560E-09
    179750.    9.60095E-13    6.07740E-09
    179800.    9.52542E-13    6.02959E-09
    179850.    9.45047E-13    5.98215E-09
    179900.    9.37612E-13    5.93508E-09
    179950.    9.30235E-13    5.88839E-09
    180000.    9.22916E-13    5.84206E-09
    180050.    9.15655E-13    5.79609E-09
    180100.    9.08450E-13    5.75049E-09
    180150.    9.01303E-13    5.70525E-09
    180200.    8.94212E-13    5.66036E-09
    180250.    8.87176E-13    5.61583E-09
    180300.    8.80196E-13    5.57164E-09
    180350.    8.73271E-13    5.52781E-09
    180400.    8.66400E-13    5.48431E-09
    180450.    8.59584E-13    5.44116E-09
    180500.    8.52821E-13    5.39835E-09
    180550.    8.46111E-13    5.35588E-09
    180600.    8.39454E-13    5.31374E-09
    180650.    8.32849E-13    5.27194E-09
    180700.    8.26296E-13    5.23046E-09
    180750.    8.19795E-13    5.18930E-09
    180800.    8.13345E-13    5.14848E-09
    180850.    8.06946E-13    5.10797E-09
    180900.    8.00597E-13    5.06778E-09
    180950.    7.94298E-13    5.02791E-09
    181000.    7.88049E-13    4.98835E-09
    181050.    7.81849E-13    4.94910E-09
    181100.    7.75697E-13    4.91016E-09
    181150.    7.69594E-13    4.87153E-09
    181200.    7.63539E-13    4.83320E-09
    181250.    7.57532E-13    4.79518E-09
    181300.    7.51572E-13    4.75745E-09
    181350.    7.45659E-13    4.72002E-09
    181400.    7.39792E-13    4.68288E-09
    181450.    7.33972E-13    4.64604E-09
    181500.    7.28197E-13    4.60949E-09
    181550.    7.22467E-13    4.57322E-09
    181600.    7.16783E-13    4.53724E-09
    181650.    7.11144E-13    4.50154E-09
    181700.    7.05549E-13    4.46612E-09
    181750.    6.99998E-13    4.43098E-09
    181800.    6.94490E-13    4.39612E-09
    181850.    6.89026E-13    4.36154E-09
    181900.    6.83605E-13    4.32722E-09
    181950.    6.78227E-13    4.29317E-09
    182000.    6.72890E-13    4.25940E-09
    182050.    6.67596E-13    4.22588E-09
    182100.    6.62344E-13    4.19264E-09
    182150.    6.57133E-13    4.15965E-09
    182200.    6.51962E-13    4.12692E-09
    182250.    6.46833E-13    4.09445E-09
    182300.    6.41744E-13    4.06224E-09
    182350.    6.36695E-13    4.03028E-09
    182400.    6.31685E-13    3.99857E-09
    182450.    6.26715E-13    3.96711E-09
    182500.    6.21784E-13    3.93590E-09
    182550.    6.16892E-13    3.90493E-09
    182600.    6.12039E-13    3.87421E-09
    182650.    6.07223E-13    3.84372E-09
    182700.    6.02446E-13    3.81348E-09
    182750.    5.97706E-13    3.78348E-09
    182800.    5.93003E-13    3.75371E-09
    182850.    5.88338E-13    3.72418E-09
    182900.    5.83709E-13    3.69488E-09
    182950.    5.79116E-13    3.66581E-09
    183000.    5.74560E-13    3.63696E-09
    183050.    5.70039E-13    3.60835E-09
    183100.    5.65555E-13    3.57996E-09
    183150.    5.61105E-13    3.55179E-09
    183200.    5.56690E-13    3.52385E-09
    183250.    5.52310E-13    3.49612E-09
    183300.    5.47965E-13    3.46862E-09
    183350.    5.43654E-13    3.44133E-09
    183400.    5.39376E-13    3.41425E-09
    183450.    5.35133E-13    3.38739E-09
    183500.    5.30922E-13    3.36074E-09
    183550.    5.26745E-13    3.33430E-09
    183600.    5.22601E-13    3.30806E-09
    183650.    5.18489E-13    3.28204E-09
    183700.    5.14410E-13    3.25621E-09
    183750.    5.10362E-13    3.23059E-09
    183800.    5.06347E-13    3.20518E-09
    183850.    5.02363E-13    3.17996E-09
    183900.    4.98411E-13    3.15494E-09
    183950.    4.94489E-13    3.13012E-09
    184000.    4.90599E-13    3.10549E-09
    184050.    4.86739E-13    3.08106E-09
    184100.    4.82909E-13    3.05682E-09
    184150.    4.79110E-13    3.03277E-09
    184200.    4.75340E-13    3.00890E-09
    184250.    4.71600E-13    2.98523E-09
    184300.    4.67890E-13    2.96174E-09
    184350.    4.64209E-13    2.93844E-09
    184400.    4.60556E-13    2.91532E-09
    184450.    4.56933E-13    2.89239E-09
    184500.    4.53338E-13    2.86963E-09
    184550.    4.49771E-13    2.84705E-09
    184600.    4.46232E-13    2.82465E-09
    184650.    4.42722E-13    2.80243E-09
    184700.    4.39238E-13    2.78038E-09
    184750.    4.35782E-13    2.75850E-09
    184800.    4.32354E-13    2.73680E-09
    184850.    4.28952E-13    2.71527E-09
    184900.    4.25577E-13    2.69390E-09
    184950.    4.22229E-13    2.67271E-09
    185000.    4.18907E-13    2.65168E-09
    185050.    4.15611E-13    2.63082E-09
    185100.    4.12341E-13    2.61012E-09
    185150.    4.09097E-13    2.58958E-09
    185200.    4.05878E-13    2.56921E-09
    185250.    4.02685E-13    2.54900E-09
    185300.    3.99517E-13    2.52894E-09
    185350.    3.96373E-13    2.50904E-09
    185400.    3.93255E-13    2.48930E-09
    185450.    3.90161E-13    2.46972E-09
    185500.    3.87091E-13    2.45029E-09
    185550.    3.84045E-13    2.43101E-09
    185600.    3.81024E-13    2.41188E-09
    185650.    3.78026E-13    2.39290E-09
    185700.    3.75052E-13    2.37408E-09
    185750.    3.72101E-13    2.35540E-09
    185800.    3.69173E-13    2.33687E-09
    185850.    3.66269E-13    2.31848E-09
    185900.    3.63387E-13    2.30024E-09
    185950.    3.60528E-13    2.28214E-09
    186000.    3.57691E-13    2.26419E-09
    186050.    3.54877E-13    2.24637E-09
    186100.    3.52085E-13    2.22870E-09
    186150.    3.49315E-13    2.21116E-09
    186200.    3.46567E-13    2.19377E-09
    186250.    3.43840E-13    2.17651E-09
    186300.    3.41135E-13    2.15938E-09
    186350.    3.38451E-13    2.14239E-09
    186400.    3.35788E-13    2.12554E-09
    186450.    3.33146E-13    2.10881E-09
    186500.    3.30525E-13    2.09222E-09
    186550.    3.27924E-13    2.07576E-09
    186600.    3.25344E-13    2.05943E-09
    186650.    3.22785E-13    2.04323E-09
    186700.    3.20245E-13    2.02715E-09
    186750.    3.17725E-13    2.01120E-09
    186800.    3.15226E-13    1.99538E-09
    186850.    3.12745E-13    1.97968E-09
    186900.    3.10285E-13    1.96410E-09
    186950.    3.07844E-13    1.94865E-09
    187000.    3.05422E-13    1.93332E-09
    187050.    3.03019E-13    1.91811E-09
    187100.    3.00634E-13    1.90302E-09
    187150.    2.98269E-13    1.88804E-09
    187200.    2.95922E-13    1.87319E-09
    187250.    2.93594E-13    1.85845E-09
    187300.    2.91284E-13    1.84383E-09
    187350.    2.88992E-13    1.82932E-09
    187400.    2.86719E-13    1.81493E-09
    187450.    2.84463E-13    1.80065E-09
    187500.    2.82225E-13    1.78648E-09
    187550.    2.80004E-13    1.77243E-09
    187600.    2.77801E-13    1.75848E-09
    187650.    2.75616E-13    1.74465E-09
    187700.    2.73447E-13    1.73092E-09
    187750.    2.71296E-13    1.71730E-09
    187800.    2.69161E-13    1.70379E-09
    187850.    2.67044E-13    1.69039E-09
    187900.    2.64943E-13    1.67709E-09
    187950.    2.62858E-13    1.66389E-09
    188000.    2.60790E-13    1.65080E-09
    188050.    2.58738E-13    1.63781E-09
    188100.    2.56702E-13    1.62493E-09
    188150.    2.54683E-13    1.61214E-09
    188200.    2.52679E-13    1.59946E-09
    188250.    2.50691E-13    1.58687E-09
    188300.    2.48718E-13    1.57439E-09
    188350.    2.46762E-13    1.56200E-09
    188400.    2.44820E-13    1.54971E-09
    188450.    2.42894E-13    1.53752E-09
    188500.    2.40983E-13    1.52542E-09
    188550.    2.39087E-13    1.51342E-09
    188600.    2.37206E-13    1.50151E-09
    188650.    2.35340E-13    1.48970E-09
    188700.    2.33488E-13    1.47798E-09
    188750.    2.31651E-13    1.46635E-09
    188800.    2.29828E-13    1.45481E-09
    188850.    2.28020E-13    1.44337E-09
    188900.    2.26226E-13    1.43201E-09
    188950.    2.24446E-13    1.42074E-09
    189000.    2.22680E-13    1.40957E-09
    189050.    2.20928E-13    1.39848E-09
    189100.    2.19190E-13    1.38747E-09
    189150.    2.17466E-13    1.37656E-09
    189200.    2.15755E-13    1.36573E-09
    189250.    2.14057E-13    1.35498E-09
    189300.    2.12373E-13    1.34432E-09
    189350.    2.10702E-13    1.33374E-09
    189400.    2.09044E-13    1.32325E-09
    189450.    2.07400E-13    1.31284E-09
    189500.    2.05768E-13    1.30251E-09
    189550.    2.04149E-13    1.29226E-09
    189600.    2.02543E-13    1.28209E-09
    189650.    2.00949E-13    1.27201E-09
    189700.    1.99368E-13    1.26200E-09
    189750.    1.97799E-13    1.25207E-09
    189800.    1.96243E-13    1.24222E-09
    189850.    1.94699E-13    1.23245E-09
    189900.    1.93167E-13    1.22275E-09
    189950.    1.91648E-13    1.21313E-09
    190000.    1.90140E-13    1.20358E-09
    190050.    1.88644E-13    1.19412E-09
    190100.    1.87160E-13    1.18472E-09
    190150.    1.85687E-13    1.17540E-09
    190200.    1.84226E-13    1.16615E-09
    190250.    1.82777E-13    1.15698E-09
    190300.    1.81339E-13    1.14787E-09
    190350.    1.79912E-13    1.13884E-09
    190400.    1.78496E-13    1.12988E-09
    190450.    1.77092E-13    1.12099E-09
    190500.    1.75699E-13    1.11217E-09
    190550.    1.74316E-13    1.10342E-09
    190600.    1.72945E-13    1.09474E-09
    190650.    1.71584E-13    1.08613E-09
    190700.    1.70234E-13    1.07758E-09
    190750.    1.68895E-13    1.06910E-09
    190800.    1.67566E-13    1.06069E-09
    190850.    1.66248E-13    1.05235E-09
    190900.    1.64940E-13    1.04407E-09
    190950.    1.63642E-13    1.03585E-09
    191000.    1.62354E-13    1.02770E-09
    191050.    1.61077E-13    1.01962E-09
    191100.    1.59810E-13    1.01160E-09
    191150.    1.58552E-13    1.00364E-09
    191200.    1.57305E-13    9.95740E-10
    191250.    1.56067E-13    9.87906E-10
    191300.    1.54839E-13    9.80133E-10
    191350.    1.53621E-13    9.72422E-10
    191400.    1.52412E-13    9.64771E-10
    191450.    1.51213E-13    9.57180E-10
    191500.    1.50024E-13    9.49649E-10
    191550.    1.48843E-13    9.42178E-10
    191600.    1.47672E-13    9.34765E-10
    191650.    1.46510E-13    9.27410E-10
    191700.    1.45358E-13    9.20114E-10
    191750.    1.44214E-13    9.12874E-10
    191800.    1.43079E-13    9.05692E-10
    191850.    1.41954E-13    8.98566E-10
    191900.    1.40837E-13    8.91497E-10
    191950.    1.39729E-13    8.84482E-10
    192000.    1.38629E-13    8.77524E-10
    192050.    1.37539E-13    8.70619E-10
    192100.    1.36456E-13    8.63770E-10
    192150.    1.35383E-13    8.56974E-10
    192200.    1.34318E-13    8.50231E-10
    192250.    1.33261E-13    8.43542E-10
    192300.    1.32212E-13    8.36905E-10
    192350.    1.31172E-13    8.30320E-10
    192400.    1.30140E-13    8.23788E-10
    192450.    1.29116E-13    8.17306E-10
    192500.    1.28100E-13    8.10876E-10
    192550.    1.27093E-13    8.04496E-10
    192600.    1.26093E-13    7.98166E-10
    192650.    1.25101E-13    7.91887E-10
    192700.    1.24116E-13    7.85656E-10
    192750.    1.23140E-13    7.79475E-10
    192800.    1.22171E-13    7.73342E-10
    192850.    1.21210E-13    7.67258E-10
    192900.    1.20256E-13    7.61221E-10
    192950.    1.19310E-13    7.55232E-10
    193000.    1.18371E-13    7.49290E-10
    193050.    1.17440E-13    7.43395E-10
    193100.    1.16516E-13    7.37546E-10
    193150.    1.15599E-13    7.31743E-10
    193200.    1.14690E-13    7.25986E-10
    193250.    1.13787E-13    7.20274E-10
    193300.    1.12892E-13    7.14607E-10
    193350.    1.12004E-13    7.08984E-10
    193400.    1.11123E-13    7.03406E-10
    193450.    1.10248E-13    6.97872E-10
    193500.    1.09381E-13    6.92381E-10
    193550.    1.08520E-13    6.86934E-10
    193600.    1.07667E-13    6.81529E-10
    193650.    1.06819E-13    6.76167E-10
    193700.    1.05979E-13    6.70847E-10
    193750.    1.05145E-13    6.65569E-10
    193800.    1.04318E-13    6.60333E-10
    193850.    1.03497E-13    6.55137E-10
    193900.    1.02683E-13    6.49983E-10
    193950.    1.01875E-13    6.44869E-10
    194000.    1.01073E-13    6.39795E-10
    194050.    1.00278E-13    6.34761E-10
    194100.    9.94893E-14    6.29767E-10
    194150.    9.87065E-14    6.24812E-10
    194200.    9.79299E-14    6.19896E-10
    194250.    9.71594E-14    6.15019E-10
    194300.    9.63950E-14    6.10180E-10
    194350.    9.56366E-14    6.05380E-10
    194400.    9.48841E-14    6.00617E-10
    194450.    9.41376E-14    5.95891E-10
    194500.    9.33970E-14    5.91203E-10
    194550.    9.26621E-14    5.86551E-10
    194600.    9.19331E-14    5.81936E-10
    194650.    9.12098E-14    5.77358E-10
    194700.    9.04922E-14    5.72815E-10
    194750.    8.97802E-14    5.68309E-10
    194800.    8.90738E-14    5.63837E-10
    194850.    8.83730E-14    5.59401E-10
    194900.    8.76777E-14    5.55000E-10
    194950.    8.69879E-14    5.50633E-10
    195000.    8.63035E-14    5.46301E-10
    195050.    8.56245E-14    5.42003E-10
    195100.    8.49508E-14    5.37738E-10
    195150.    8.42824E-14    5.33508E-10
    195200.    8.36193E-14    5.29310E-10
    195250.    8.29614E-14    5.25146E-10
    195300.    8.23087E-14    5.21014E-10
    195350.    8.16611E-14    5.16915E-10
    195400.    8.10186E-14    5.12848E-10
    195450.    8.03812E-14    5.08813E-10
    195500.    7.97487E-14    5.04810E-10
    195550.    7.91213E-14    5.00838E-10
    195600.    7.84988E-14    4.96897E-10
    195650.    7.78812E-14    4.92988E-10
    195700.    7.72684E-14    4.89109E-10
    195750.    7.66605E-14    4.85261E-10
    195800.    7.60573E-14    4.81443E-10
    195850.    7.54589E-14    4.77655E-10
    195900.    7.48653E-14    4.73897E-10
    195950.    7.42762E-14    4.70169E-10
    196000.    7.36918E-14    4.66469E-10
    196050.    7.31120E-14    4.62799E-10
    196100.    7.25368E-14    4.59158E-10
    196150.    7.19661E-14    4.55545E-10
    196200.    7.13999E-14    4.51961E-10
    196250.    7.08381E-14    4.48405E-10
    196300.    7.02808E-14    4.44877E-10
    196350.    6.97278E-14    4.41377E-10
    196400.    6.91792E-14    4.37905E-10
    196450.    6.86350E-14    4.34459E-10
    196500.    6.80950E-14    4.31041E-10
    196550.    6.75592E-14    4.27650E-10
    196600.    6.70277E-14    4.24285E-10
    196650.    6.65003E-14    4.20947E-10
    196700.    6.59771E-14    4.17635E-10
    196750.    6.54580E-14    4.14349E-10
    196800.    6.49430E-14    4.11089E-10
    196850.    6.44320E-14    4.07855E-10
    196900.    6.39251E-14    4.04646E-10
    196950.    6.34221E-14    4.01462E-10
    197000.    6.29232E-14    3.98304E-10
    197050.    6.24281E-14    3.95170E-10
    197100.    6.19369E-14    3.92061E-10
    197150.    6.14496E-14    3.88976E-10
    197200.    6.09661E-14    3.85916E-10
    197250.    6.04865E-14    3.82879E-10
    197300.    6.00106E-14    3.79867E-10
    197350.    5.95384E-14    3.76878E-10
    197400.    5.90700E-14    3.73913E-10
    197450.    5.86052E-14    3.70971E-10
    197500.    5.81441E-14    3.68052E-10
    197550.    5.76867E-14    3.65157E-10
    197600.    5.72328E-14    3.62284E-10
    197650.    5.67825E-14    3.59433E-10
    197700.    5.63358E-14    3.56605E-10
    197750.    5.58925E-14    3.53800E-10
    197800.    5.54528E-14    3.51016E-10
    197850.    5.50165E-14    3.48254E-10
    197900.    5.45836E-14    3.45514E-10
    197950.    5.41542E-14    3.42796E-10
    198000.    5.37281E-14    3.40099E-10
    198050.    5.33054E-14    3.37423E-10
    198100.    5.28860E-14    3.34768E-10
    198150.    5.24699E-14    3.32134E-10
    198200.    5.20571E-14    3.29521E-10
    198250.    5.16475E-14    3.26929E-10
    198300.    5.12411E-14    3.24356E-10
    198350.    5.08380E-14    3.21804E-10
    198400.    5.04380E-14    3.19273E-10
    198450.    5.00412E-14    3.16761E-10
    198500.    4.96475E-14    3.14268E-10
    198550.    4.92568E-14    3.11796E-10
    198600.    4.88693E-14    3.09343E-10
    198650.    4.84848E-14    3.06909E-10
    198700.    4.81033E-14    3.04494E-10
    198750.    4.77249E-14    3.02098E-10
    198800.    4.73494E-14    2.99722E-10
    198850.    4.69769E-14    2.97363E-10
    198900.    4.66073E-14    2.95024E-10
    198950.    4.62406E-14    2.92703E-10
    199000.    4.58767E-14    2.90400E-10
    199050.    4.55158E-14    2.88115E-10
    199100.    4.51577E-14    2.85848E-10
    199150.    4.48024E-14    2.83599E-10
    199200.    4.44499E-14    2.81368E-10
    199250.    4.41002E-14    2.79154E-10
    199300.    4.37532E-14    2.76958E-10
    199350.    4.34090E-14    2.74779E-10
    199400.    4.30674E-14    2.72617E-10
    199450.    4.27286E-14    2.70472E-10
    199500.    4.23924E-14    2.68344E-10
    199550.    4.20589E-14    2.66233E-10
    199600.    4.17280E-14    2.64138E-10
    199650.    4.13997E-14    2.62060E-10
    199700.    4.10739E-14    2.59998E-10
    199750.    4.07508E-14    2.57952E-10
    199800.    4.04302E-14    2.55923E-10
    199850.    4.01121E-14    2.53909E-10
    199900.    3.97965E-14    2.51912E-10
    199950.    3.94834E-14    2.49930E-10
    200000.    3.91727E-14    2.47963E-10
    200050.    3.88645E-14    2.46012E-10
    200100.    3.85587E-14    2.44077E-10
    200150.    3.82554E-14    2.42156E-10
    200200.    3.79544E-14    2.40251E-10
    200250.    3.76558E-14    2.38361E-10
    200300.    3.73595E-14    2.36486E-10
    200350.    3.70656E-14    2.34625E-10
    200400.    3.67739E-14    2.32779E-10
    200450.    3.64846E-14    2.30948E-10
    200500.    3.61976E-14    2.29131E-10
    200550.    3.59128E-14    2.27328E-10
    200600.    3.56302E-14    2.25539E-10
    200650.    3.53499E-14    2.23765E-10
    200700.    3.50718E-14    2.22004E-10
    200750.    3.47958E-14    2.20258E-10
    200800.    3.45220E-14    2.18525E-10
    200850.    3.42504E-14    2.16805E-10
    200900.    3.39810E-14    2.15099E-10
    200950.    3.37136E-14    2.13407E-10
    201000.    3.34484E-14    2.11728E-10
    201050.    3.31852E-14    2.10062E-10
    201100.    3.29241E-14    2.08410E-10
    201150.    3.26651E-14    2.06770E-10
    201200.    3.24081E-14    2.05143E-10
    201250.    3.21531E-14    2.03529E-10
    201300.    3.19001E-14    2.01928E-10
    201350.    3.16491E-14    2.00339E-10
    201400.    3.14001E-14    1.98763E-10
    201450.    3.11531E-14    1.97199E-10
    201500.    3.09080E-14    1.95647E-10
    201550.    3.06648E-14    1.94108E-10
    201600.    3.04235E-14    1.92581E-10
    201650.    3.01842E-14    1.91066E-10
    201700.    2.99467E-14    1.89562E-10
    201750.    2.97111E-14    1.88071E-10
    201800.    2.94773E-14    1.86591E-10
    201850.    2.92454E-14    1.85123E-10
    201900.    2.90153E-14    1.83667E-10
    201950.    2.87870E-14    1.82222E-10
    202000.    2.85605E-14    1.80788E-10
    202050.    2.83358E-14    1.79366E-10
    202100.    2.81129E-14    1.77954E-10
    202150.    2.78917E-14    1.76554E-10
    202200.    2.76722E-14    1.75165E-10
    202250.    2.74545E-14    1.73787E-10
    202300.    2.72385E-14    1.72420E-10
    202350.    2.70242E-14    1.71063E-10
    202400.    2.68116E-14    1.69717E-10
    202450.    2.66006E-14    1.68382E-10
    202500.    2.63913E-14    1.67057E-10
    202550.    2.61837E-14    1.65743E-10
    202600.    2.59777E-14    1.64439E-10
    202650.    2.57733E-14    1.63145E-10
    202700.    2.55705E-14    1.61861E-10
    202750.    2.53693E-14    1.60588E-10
    202800.    2.51697E-14    1.59324E-10
    202850.    2.49717E-14    1.58071E-10
    202900.    2.47752E-14    1.56827E-10
    202950.    2.45803E-14    1.55593E-10
    203000.    2.43869E-14    1.54369E-10
    203050.    2.41950E-14    1.53155E-10
    203100.    2.40047E-14    1.51950E-10
    203150.    2.38158E-14    1.50754E-10
    203200.    2.36284E-14    1.49568E-10
    203250.    2.34425E-14    1.48391E-10
    203300.    2.32581E-14    1.47224E-10
    203350.    2.30751E-14    1.46065E-10
    203400.    2.28936E-14    1.44916E-10
    203450.    2.27134E-14    1.43776E-10
    203500.    2.25347E-14    1.42645E-10
    203550.    2.23574E-14    1.41523E-10
    203600.    2.21815E-14    1.40409E-10
    203650.    2.20070E-14    1.39304E-10
    203700.    2.18339E-14    1.38208E-10
    203750.    2.16621E-14    1.37121E-10
    203800.    2.14917E-14    1.36042E-10
    203850.    2.13226E-14    1.34972E-10
    203900.    2.11548E-14    1.33910E-10
    203950.    2.09884E-14    1.32856E-10
    204000.    2.08232E-14    1.31811E-10
    204050.    2.06594E-14    1.30774E-10
    204100.    2.04968E-14    1.29745E-10
    204150.    2.03356E-14    1.28724E-10
    204200.    2.01756E-14    1.27711E-10
    204250.    2.00169E-14    1.26707E-10
    204300.    1.98594E-14    1.25710E-10
    204350.    1.97031E-14    1.24721E-10
    204400.    1.95481E-14    1.23739E-10
    204450.    1.93943E-14    1.22766E-10
    204500.    1.92417E-14    1.21800E-10
    204550.    1.90903E-14    1.20842E-10
    204600.    1.89401E-14    1.19891E-10
    204650.    1.87911E-14    1.18948E-10
    204700.    1.86433E-14    1.18012E-10
    204750.    1.84966E-14    1.17083E-10
    204800.    1.83510E-14    1.16162E-10
    204850.    1.82067E-14    1.15248E-10
    204900.    1.80634E-14    1.14341E-10
    204950.    1.79213E-14    1.13442E-10
    205000.    1.77803E-14    1.12549E-10
    205050.    1.76404E-14    1.11664E-10
    205100.    1.75016E-14    1.10785E-10
    205150.    1.73639E-14    1.09914E-10
    205200.    1.72273E-14    1.09049E-10
    205250.    1.70918E-14    1.08191E-10
    205300.    1.69573E-14    1.07340E-10
    205350.    1.68239E-14    1.06495E-10
    205400.    1.66915E-14    1.05657E-10
    205450.    1.65602E-14    1.04826E-10
    205500.    1.64299E-14    1.04001E-10
    205550.    1.63006E-14    1.03183E-10
    205600.    1.61724E-14    1.02371E-10
    205650.    1.60451E-14    1.01566E-10
    205700.    1.59189E-14    1.00767E-10
    205750.    1.57936E-14    9.99738E-11
    205800.    1.56694E-14    9.91872E-11
    205850.    1.55461E-14    9.84068E-11
    205900.    1.54238E-14    9.76326E-11
    205950.    1.53024E-14    9.68644E-11
    206000.    1.51820E-14    9.61023E-11
    206050.    1.50626E-14    9.53462E-11
    206100.    1.49441E-14    9.45960E-11
    206150.    1.48265E-14    9.38518E-11
    206200.    1.47099E-14    9.31134E-11
    206250.    1.45941E-14    9.23808E-11
    206300.    1.44793E-14    9.16539E-11
    206350.    1.43654E-14    9.09328E-11
    206400.    1.42524E-14    9.02174E-11
    206450.    1.41402E-14    8.95076E-11
    206500.    1.40290E-14    8.88034E-11
    206550.    1.39186E-14    8.81047E-11
    206600.    1.38091E-14    8.74115E-11
    206650.    1.37004E-14    8.67238E-11
    206700.    1.35926E-14    8.60414E-11
    206750.    1.34857E-14    8.53645E-11
    206800.    1.33796E-14    8.46928E-11
    206850.    1.32743E-14    8.40265E-11
    206900.    1.31699E-14    8.33654E-11
    206950.    1.30663E-14    8.27095E-11
    207000.    1.29635E-14    8.20588E-11
    207050.    1.28615E-14    8.14131E-11
    207100.    1.27603E-14    8.07726E-11
    207150.    1.26599E-14    8.01371E-11
    207200.    1.25603E-14    7.95066E-11
    207250.    1.24615E-14    7.88811E-11
    207300.    1.23634E-14    7.82604E-11
    207350.    1.22661E-14    7.76447E-11
    207400.    1.21696E-14    7.70338E-11
    207450.    1.20739E-14    7.64277E-11
    207500.    1.19789E-14    7.58264E-11
    207550.    1.18846E-14    7.52298E-11
    207600.    1.17911E-14    7.46379E-11
    207650.    1.16984E-14    7.40507E-11
    207700.    1.16063E-14    7.34681E-11
    207750.    1.15150E-14    7.28900E-11
    207800.    1.14244E-14    7.23166E-11
    207850.    1.13345E-14    7.17476E-11
    207900.    1.12454E-14    7.11831E-11
    207950.    1.11569E-14    7.06230E-11
    208000.    1.10691E-14    7.00674E-11
    208050.    1.09820E-14    6.95161E-11
    208100.    1.08956E-14    6.89692E-11
    208150.    1.08099E-14    6.84266E-11
    208200.    1.07248E-14    6.78882E-11
    208250.    1.06405E-14    6.73541E-11
    208300.    1.05567E-14    6.68241E-11
    208350.    1.04737E-14    6.62984E-11
    208400.    1.03913E-14    6.57768E-11
    208450.    1.03095E-14    6.52592E-11
    208500.    1.02284E-14    6.47458E-11
    208550.    1.01479E-14    6.42364E-11
    208600.    1.00681E-14    6.37310E-11
    208650.    9.98887E-15    6.32296E-11
    208700.    9.91028E-15    6.27321E-11
    208750.    9.83231E-15    6.22385E-11
    208800.    9.75495E-15    6.17488E-11
    208850.    9.67820E-15    6.12630E-11
    208900.    9.60206E-15    6.07810E-11
    208950.    9.52651E-15    6.03028E-11
    209000.    9.45156E-15    5.98284E-11
    209050.    9.37720E-15    5.93576E-11
    209100.    9.30342E-15    5.88906E-11
    209150.    9.23022E-15    5.84273E-11
    209200.    9.15760E-15    5.79676E-11
    209250.    9.08555E-15    5.75115E-11
    209300.    9.01407E-15    5.70590E-11
    209350.    8.94314E-15    5.66101E-11
    209400.    8.87278E-15    5.61647E-11
    209450.    8.80297E-15    5.57228E-11
    209500.    8.73371E-15    5.52844E-11
    209550.    8.66500E-15    5.48494E-11
    209600.    8.59682E-15    5.44179E-11
    209650.    8.52919E-15    5.39897E-11
    209700.    8.46208E-15    5.35650E-11
    209750.    8.39550E-15    5.31435E-11
    209800.    8.32945E-15    5.27254E-11
    209850.    8.26391E-15    5.23106E-11
    209900.    8.19890E-15    5.18990E-11
    209950.    8.13439E-15    5.14907E-11
    210000.    8.07039E-15    5.10856E-11
    210050.    8.00689E-15    5.06836E-11
    210100.    7.94390E-15    5.02849E-11
    210150.    7.88140E-15    4.98892E-11
    210200.    7.81939E-15    4.94967E-11
    210250.    7.75787E-15    4.91073E-11
    210300.    7.69683E-15    4.87209E-11
    210350.    7.63627E-15    4.83376E-11
    210400.    7.57619E-15    4.79573E-11
    210450.    7.51658E-15    4.75800E-11
    210500.    7.45744E-15    4.72056E-11
    210550.    7.39877E-15    4.68342E-11
    210600.    7.34056E-15    4.64657E-11
    210650.    7.28280E-15    4.61002E-11
    210700.    7.22551E-15    4.57374E-11
    210750.    7.16866E-15    4.53776E-11
    210800.    7.11226E-15    4.50206E-11
    210850.    7.05630E-15    4.46664E-11
    210900.    7.00078E-15    4.43149E-11
    210950.    6.94570E-15    4.39663E-11
    211000.    6.89105E-15    4.36204E-11
    211050.    6.83683E-15    4.32772E-11
    211100.    6.78304E-15    4.29367E-11
    211150.    6.72968E-15    4.25989E-11
    211200.    6.67673E-15    4.22637E-11
    211250.    6.62420E-15    4.19312E-11
    211300.    6.57208E-15    4.16013E-11
    211350.    6.52037E-15    4.12740E-11
    211400.    6.46907E-15    4.09492E-11
    211450.    6.41817E-15    4.06270E-11
    211500.    6.36768E-15    4.03074E-11
    211550.    6.31758E-15    3.99903E-11
    211600.    6.26787E-15    3.96756E-11
    211650.    6.21856E-15    3.93635E-11
    211700.    6.16963E-15    3.90538E-11
    211750.    6.12109E-15    3.87465E-11
    211800.    6.07293E-15    3.84417E-11
    211850.    6.02515E-15    3.81392E-11
    211900.    5.97775E-15    3.78391E-11
    211950.    5.93072E-15    3.75414E-11
    212000.    5.88405E-15    3.72461E-11
    212050.    5.83776E-15    3.69530E-11
    212100.    5.79183E-15    3.66623E-11
    212150.    5.74626E-15    3.63738E-11
    212200.    5.70105E-15    3.60876E-11
    212250.    5.65620E-15    3.58037E-11
    212300.    5.61169E-15    3.55220E-11
    212350.    5.56754E-15    3.52425E-11
    212400.    5.52374E-15    3.49653E-11
    212450.    5.48028E-15    3.46902E-11
    212500.    5.43716E-15    3.44172E-11
    212550.    5.39438E-15    3.41464E-11
    212600.    5.35194E-15    3.38778E-11
    212650.    5.30983E-15    3.36112E-11
    212700.    5.26806E-15    3.33468E-11
    212750.    5.22661E-15    3.30844E-11
    212800.    5.18549E-15    3.28241E-11
    212850.    5.14469E-15    3.25659E-11
    212900.    5.10421E-15    3.23097E-11
    212950.    5.06405E-15    3.20554E-11
    213000.    5.02421E-15    3.18032E-11
    213050.    4.98468E-15    3.15530E-11
    213100.    4.94546E-15    3.13048E-11
    213150.    4.90655E-15    3.10585E-11
    213200.    4.86795E-15    3.08141E-11
    213250.    4.82965E-15    3.05717E-11
    213300.    4.79165E-15    3.03311E-11
    213350.    4.75395E-15    3.00925E-11
    213400.    4.71655E-15    2.98557E-11
    213450.    4.67944E-15    2.96208E-11
    213500.    4.64262E-15    2.93878E-11
    213550.    4.60609E-15    2.91566E-11
    213600.    4.56985E-15    2.89272E-11
    213650.    4.53390E-15    2.86996E-11
    213700.    4.49823E-15    2.84738E-11
    213750.    4.46284E-15    2.82498E-11
    213800.    4.42772E-15    2.80275E-11
    213850.    4.39289E-15    2.78070E-11
    213900.    4.35833E-15    2.75882E-11
    213950.    4.32404E-15    2.73711E-11
    214000.    4.29001E-15    2.71558E-11
    214050.    4.25626E-15    2.69421E-11
    214100.    4.22277E-15    2.67302E-11
    214150.    4.18955E-15    2.65199E-11
    214200.    4.15659E-15    2.63112E-11
    214250.    4.12388E-15    2.61042E-11
    214300.    4.09144E-15    2.58988E-11
    214350.    4.05925E-15    2.56950E-11
    214400.    4.02731E-15    2.54929E-11
    214450.    3.99563E-15    2.52923E-11
    214500.    3.96419E-15    2.50933E-11
    214550.    3.93300E-15    2.48959E-11
    214600.    3.90206E-15    2.47000E-11
    214650.    3.87135E-15    2.45057E-11
    214700.    3.84090E-15    2.43129E-11
    214750.    3.81068E-15    2.41216E-11
    214800.    3.78069E-15    2.39318E-11
    214850.    3.75095E-15    2.37435E-11
    214900.    3.72144E-15    2.35567E-11
    214950.    3.69216E-15    2.33714E-11
    215000.    3.66311E-15    2.31875E-11
    215050.    3.63429E-15    2.30050E-11
    215100.    3.60569E-15    2.28240E-11
    215150.    3.57733E-15    2.26445E-11
    215200.    3.54918E-15    2.24663E-11
    215250.    3.52126E-15    2.22896E-11
    215300.    3.49355E-15    2.21142E-11
    215350.    3.46607E-15    2.19402E-11
    215400.    3.43879E-15    2.17676E-11
    215450.    3.41174E-15    2.15963E-11
    215500.    3.38490E-15    2.14264E-11
    215550.    3.35826E-15    2.12578E-11
    215600.    3.33184E-15    2.10906E-11
    215650.    3.30563E-15    2.09246E-11
    215700.    3.27962E-15    2.07600E-11
    215750.    3.25382E-15    2.05967E-11
    215800.    3.22822E-15    2.04346E-11
    215850.    3.20282E-15    2.02738E-11
    215900.    3.17762E-15    2.01143E-11
    215950.    3.15262E-15    1.99561E-11
    216000.    3.12781E-15    1.97991E-11
    216050.    3.10321E-15    1.96433E-11
    216100.    3.07879E-15    1.94887E-11
    216150.    3.05457E-15    1.93354E-11
    216200.    3.03053E-15    1.91833E-11
    216250.    3.00669E-15    1.90324E-11
    216300.    2.98303E-15    1.88826E-11
    216350.    2.95956E-15    1.87340E-11
    216400.    2.93628E-15    1.85866E-11
    216450.    2.91318E-15    1.84404E-11
    216500.    2.89026E-15    1.82953E-11
    216550.    2.86752E-15    1.81514E-11
    216600.    2.84496E-15    1.80086E-11
    216650.    2.82257E-15    1.78669E-11
    216700.    2.80037E-15    1.77263E-11
    216750.    2.77833E-15    1.75868E-11
    216800.    2.75647E-15    1.74485E-11
    216850.    2.73479E-15    1.73112E-11
    216900.    2.71327E-15    1.71750E-11
    216950.    2.69192E-15    1.70399E-11
    217000.    2.67074E-15    1.69058E-11
    217050.    2.64973E-15    1.67728E-11
    217100.    2.62888E-15    1.66408E-11
    217150.    2.60820E-15    1.65099E-11
    217200.    2.58768E-15    1.63800E-11
    217250.    2.56732E-15    1.62511E-11
    217300.    2.54712E-15    1.61233E-11
    217350.    2.52708E-15    1.59964E-11
    217400.    2.50720E-15    1.58706E-11
    217450.    2.48747E-15    1.57457E-11
    217500.    2.46790E-15    1.56218E-11
    217550.    2.44848E-15    1.54989E-11
    217600.    2.42922E-15    1.53770E-11
    217650.    2.41011E-15    1.52560E-11
    217700.    2.39114E-15    1.51359E-11
    217750.    2.37233E-15    1.50169E-11
    217800.    2.35367E-15    1.48987E-11
    217850.    2.33515E-15    1.47815E-11
    217900.    2.31678E-15    1.46652E-11
    217950.    2.29855E-15    1.45498E-11
    218000.    2.28046E-15    1.44353E-11
    218050.    2.26252E-15    1.43218E-11
    218100.    2.24472E-15    1.42091E-11
    218150.    2.22706E-15    1.40973E-11
    218200.    2.20954E-15    1.39864E-11
    218250.    2.19215E-15    1.38763E-11
    218300.    2.17491E-15    1.37672E-11
    218350.    2.15779E-15    1.36588E-11
    218400.    2.14082E-15    1.35514E-11
    218450.    2.12397E-15    1.34448E-11
    218500.    2.10726E-15    1.33390E-11
    218550.    2.09068E-15    1.32340E-11
    218600.    2.07423E-15    1.31299E-11
    218650.    2.05791E-15    1.30266E-11
    218700.    2.04172E-15    1.29241E-11
    218750.    2.02566E-15    1.28224E-11
    218800.    2.00972E-15    1.27215E-11
    218850.    1.99391E-15    1.26214E-11
    218900.    1.97822E-15    1.25221E-11
    218950.    1.96266E-15    1.24236E-11
    219000.    1.94722E-15    1.23259E-11
    219050.    1.93190E-15    1.22289E-11
    219100.    1.91670E-15    1.21327E-11
    219150.    1.90162E-15    1.20372E-11
    219200.    1.88665E-15    1.19425E-11
    219250.    1.87181E-15    1.18486E-11
    219300.    1.85708E-15    1.17553E-11
    219350.    1.84247E-15    1.16629E-11
    219400.    1.82798E-15    1.15711E-11
    219450.    1.81359E-15    1.14801E-11
    219500.    1.79933E-15    1.13897E-11
    219550.    1.78517E-15    1.13001E-11
    219600.    1.77112E-15    1.12112E-11
    219650.    1.75719E-15    1.11230E-11
    219700.    1.74336E-15    1.10355E-11
    219750.    1.72965E-15    1.09487E-11
    219800.    1.71604E-15    1.08625E-11
    219850.    1.70254E-15    1.07771E-11
    219900.    1.68914E-15    1.06923E-11
    219950.    1.67585E-15    1.06081E-11
    220000.    1.66267E-15    1.05247E-11
    220050.    1.64959E-15    1.04419E-11
    220100.    1.63661E-15    1.03597E-11
    220150.    1.62373E-15    1.02782E-11
    220200.    1.61096E-15    1.01973E-11
    220250.    1.59828E-15    1.01171E-11
    220300.    1.58571E-15    1.00375E-11
    220350.    1.57323E-15    9.95854E-12
    220400.    1.56085E-15    9.88019E-12
    220450.    1.54857E-15    9.80246E-12
    220500.    1.53639E-15    9.72533E-12
    220550.    1.52430E-15    9.64882E-12
    220600.    1.51231E-15    9.57290E-12
    220650.    1.50041E-15    9.49758E-12
    220700.    1.48860E-15    9.42286E-12
    220750.    1.47689E-15    9.34872E-12
    220800.    1.46527E-15    9.27517E-12
    220850.    1.45374E-15    9.20219E-12
    220900.    1.44231E-15    9.12979E-12
    220950.    1.43096E-15    9.05796E-12
    221000.    1.41970E-15    8.98670E-12
    221050.    1.40853E-15    8.91599E-12
    221100.    1.39745E-15    8.84584E-12
    221150.    1.38645E-15    8.77624E-12
    221200.    1.37554E-15    8.70719E-12
    221250.    1.36472E-15    8.63869E-12
    221300.    1.35398E-15    8.57072E-12
    221350.    1.34333E-15    8.50329E-12
    221400.    1.33276E-15    8.43639E-12
    221450.    1.32228E-15    8.37001E-12
    221500.    1.31187E-15    8.30416E-12
    221550.    1.30155E-15    8.23882E-12
    221600.    1.29131E-15    8.17400E-12
    221650.    1.28115E-15    8.10969E-12
    221700.    1.27107E-15    8.04588E-12
    221750.    1.26107E-15    7.98258E-12
    221800.    1.25115E-15    7.91978E-12
    221850.    1.24131E-15    7.85746E-12
    221900.    1.23154E-15    7.79564E-12
    221950.    1.22185E-15    7.73431E-12
    222000.    1.21224E-15    7.67346E-12
    222050.    1.20270E-15    7.61308E-12
    222100.    1.19324E-15    7.55319E-12
    222150.    1.18385E-15    7.49376E-12
    222200.    1.17453E-15    7.43480E-12
    222250.    1.16529E-15    7.37631E-12
    222300.    1.15612E-15    7.31827E-12
    222350.    1.14703E-15    7.26069E-12
    222400.    1.13800E-15    7.20357E-12
    222450.    1.12905E-15    7.14689E-12
    222500.    1.12017E-15    7.09066E-12
    222550.    1.11135E-15    7.03487E-12
    222600.    1.10261E-15    6.97952E-12
    222650.    1.09394E-15    6.92461E-12
    222700.    1.08533E-15    6.87013E-12
    222750.    1.07679E-15    6.81608E-12
    222800.    1.06832E-15    6.76245E-12
    222850.    1.05991E-15    6.70924E-12
    222900.    1.05157E-15    6.65646E-12
    222950.    1.04330E-15    6.60408E-12
    223000.    1.03509E-15    6.55213E-12
    223050.    1.02695E-15    6.50057E-12
    223100.    1.01887E-15    6.44943E-12
    223150.    1.01085E-15    6.39869E-12
    223200.    1.00290E-15    6.34834E-12
    223250.    9.95007E-16    6.29840E-12
    223300.    9.87179E-16    6.24884E-12
    223350.    9.79412E-16    6.19968E-12
    223400.    9.71706E-16    6.15090E-12
    223450.    9.64061E-16    6.10251E-12
    223500.    9.56476E-16    6.05449E-12
    223550.    9.48950E-16    6.00686E-12
    223600.    9.41484E-16    5.95960E-12
    223650.    9.34077E-16    5.91271E-12
    223700.    9.26728E-16    5.86619E-12
    223750.    9.19437E-16    5.82003E-12
    223800.    9.12203E-16    5.77424E-12
    223850.    9.05026E-16    5.72881E-12
    223900.    8.97905E-16    5.68374E-12
    223950.    8.90841E-16    5.63902E-12
    224000.    8.83832E-16    5.59465E-12
    224050.    8.76878E-16    5.55064E-12
    224100.    8.69979E-16    5.50697E-12
    224150.    8.63134E-16    5.46364E-12
    224200.    8.56343E-16    5.42065E-12
    224250.    8.49605E-16    5.37800E-12
    224300.    8.42921E-16    5.33569E-12
    224350.    8.36289E-16    5.29371E-12
    224400.    8.29709E-16    5.25206E-12
    224450.    8.23181E-16    5.21074E-12
    224500.    8.16705E-16    5.16974E-12
    224550.    8.10279E-16    5.12907E-12
    224600.    8.03904E-16    5.08871E-12
    224650.    7.97579E-16    5.04868E-12
    224700.    7.91304E-16    5.00895E-12
    224750.    7.85078E-16    4.96954E-12
    224800.    7.78901E-16    4.93044E-12
    224850.    7.72773E-16    4.89165E-12
    224900.    7.66693E-16    4.85317E-12
    224950.    7.60661E-16    4.81498E-12
    225000.    7.54676E-16    4.77710E-12
    225050.    7.48739E-16    4.73951E-12
    225100.    7.42848E-16    4.70223E-12
    225150.    7.37003E-16    4.66523E-12
    225200.    7.31204E-16    4.62852E-12
    225250.    7.25452E-16    4.59211E-12
    225300.    7.19744E-16    4.55598E-12
    225350.    7.14081E-16    4.52013E-12
    225400.    7.08463E-16    4.48457E-12
    225450.    7.02889E-16    4.44929E-12
    225500.    6.97359E-16    4.41428E-12
    225550.    6.91872E-16    4.37955E-12
    225600.    6.86428E-16    4.34509E-12
    225650.    6.81028E-16    4.31091E-12
    225700.    6.75670E-16    4.27699E-12
    225750.    6.70354E-16    4.24334E-12
    225800.    6.65079E-16    4.20995E-12
    225850.    6.59847E-16    4.17683E-12
    225900.    6.54655E-16    4.14397E-12
    225950.    6.49504E-16    4.11136E-12
    226000.    6.44394E-16    4.07902E-12
    226050.    6.39324E-16    4.04692E-12
    226100.    6.34294E-16    4.01508E-12
    226150.    6.29304E-16    3.98349E-12
    226200.    6.24353E-16    3.95215E-12
    226250.    6.19440E-16    3.92106E-12
    226300.    6.14567E-16    3.89021E-12
    226350.    6.09731E-16    3.85960E-12
    226400.    6.04934E-16    3.82923E-12
    226450.    6.00175E-16    3.79911E-12
    226500.    5.95453E-16    3.76922E-12
    226550.    5.90768E-16    3.73956E-12
    226600.    5.86120E-16    3.71014E-12
    226650.    5.81508E-16    3.68095E-12
    226700.    5.76933E-16    3.65199E-12
    226750.    5.72394E-16    3.62325E-12
    226800.    5.67890E-16    3.59475E-12
    226850.    5.63422E-16    3.56646E-12
    226900.    5.58990E-16    3.53840E-12
    226950.    5.54592E-16    3.51056E-12
    227000.    5.50228E-16    3.48294E-12
    227050.    5.45899E-16    3.45554E-12
    227100.    5.41604E-16    3.42835E-12
    227150.    5.37343E-16    3.40138E-12
    227200.    5.33115E-16    3.37462E-12
    227250.    5.28921E-16    3.34807E-12
    227300.    5.24759E-16    3.32173E-12
    227350.    5.20631E-16    3.29559E-12
    227400.    5.16534E-16    3.26966E-12
    227450.    5.12470E-16    3.24394E-12
    227500.    5.08438E-16    3.21841E-12
    227550.    5.04438E-16    3.19309E-12
    227600.    5.00469E-16    3.16797E-12
    227650.    4.96532E-16    3.14305E-12
    227700.    4.92625E-16    3.11832E-12
    227750.    4.88749E-16    3.09378E-12
    227800.    4.84904E-16    3.06944E-12
    227850.    4.81089E-16    3.04529E-12
    227900.    4.77304E-16    3.02133E-12
    227950.    4.73548E-16    2.99756E-12
    228000.    4.69823E-16    2.97398E-12
    228050.    4.66126E-16    2.95058E-12
    228100.    4.62459E-16    2.92736E-12
    228150.    4.58820E-16    2.90433E-12
    228200.    4.55210E-16    2.88148E-12
    228250.    4.51629E-16    2.85881E-12
    228300.    4.48075E-16    2.83632E-12
    228350.    4.44550E-16    2.81400E-12
    228400.    4.41052E-16    2.79186E-12
    228450.    4.37582E-16    2.76990E-12
    228500.    4.34140E-16    2.74810E-12
    228550.    4.30724E-16    2.72648E-12
    228600.    4.27335E-16    2.70503E-12
    228650.    4.23973E-16    2.68375E-12
    228700.    4.20637E-16    2.66263E-12
    228750.    4.17328E-16    2.64168E-12
    228800.    4.14044E-16    2.62090E-12
    228850.    4.10787E-16    2.60028E-12
    228900.    4.07555E-16    2.57982E-12
    228950.    4.04348E-16    2.55952E-12
    229000.    4.01167E-16    2.53939E-12
    229050.    3.98010E-16    2.51941E-12
    229100.    3.94879E-16    2.49958E-12
    229150.    3.91772E-16    2.47992E-12
    229200.    3.88690E-16    2.46041E-12
    229250.    3.85632E-16    2.44105E-12
    229300.    3.82598E-16    2.42184E-12
    229350.    3.79587E-16    2.40279E-12
    229400.    3.76601E-16    2.38388E-12
    229450.    3.73638E-16    2.36513E-12
    229500.    3.70698E-16    2.34652E-12
    229550.    3.67782E-16    2.32806E-12
    229600.    3.64888E-16    2.30974E-12
    229650.    3.62017E-16    2.29157E-12
    229700.    3.59169E-16    2.27354E-12
    229750.    3.56343E-16    2.25565E-12
    229800.    3.53539E-16    2.23790E-12
    229850.    3.50758E-16    2.22030E-12
    229900.    3.47998E-16    2.20283E-12
    229950.    3.45260E-16    2.18550E-12
    230000.    3.42544E-16    2.16830E-12
    230050.    3.39849E-16    2.15124E-12
    230100.    3.37175E-16    2.13432E-12
    230150.    3.34522E-16    2.11752E-12
    230200.    3.31890E-16    2.10086E-12
    230250.    3.29279E-16    2.08433E-12
    230300.    3.26688E-16    2.06794E-12
    230350.    3.24118E-16    2.05167E-12
    230400.    3.21568E-16    2.03552E-12
    230450.    3.19038E-16    2.01951E-12
    230500.    3.16528E-16    2.00362E-12
    230550.    3.14037E-16    1.98786E-12
    230600.    3.11566E-16    1.97222E-12
    230650.    3.09115E-16    1.95670E-12
    230700.    3.06683E-16    1.94130E-12
    230750.    3.04270E-16    1.92603E-12
    230800.    3.01876E-16    1.91088E-12
    230850.    2.99501E-16    1.89584E-12
    230900.    2.97145E-16    1.88093E-12
    230950.    2.94807E-16    1.86613E-12
    231000.    2.92487E-16    1.85144E-12
    231050.    2.90186E-16    1.83688E-12
    231100.    2.87903E-16    1.82243E-12
    231150.    2.85638E-16    1.80809E-12
    231200.    2.83391E-16    1.79386E-12
    231250.    2.81161E-16    1.77975E-12
    231300.    2.78949E-16    1.76575E-12
    231350.    2.76754E-16    1.75185E-12
    231400.    2.74577E-16    1.73807E-12
    231450.    2.72416E-16    1.72440E-12
    231500.    2.70273E-16    1.71083E-12
    231550.    2.68147E-16    1.69737E-12
    231600.    2.66037E-16    1.68401E-12
    231650.    2.63944E-16    1.67076E-12
    231700.    2.61867E-16    1.65762E-12
    231750.    2.59807E-16    1.64458E-12
    231800.    2.57763E-16    1.63164E-12
    231850.    2.55735E-16    1.61880E-12
    231900.    2.53723E-16    1.60606E-12
    231950.    2.51726E-16    1.59343E-12
    232000.    2.49746E-16    1.58089E-12
    232050.    2.47781E-16    1.56845E-12
    232100.    2.45831E-16    1.55611E-12
    232150.    2.43897E-16    1.54387E-12
    232200.    2.41978E-16    1.53172E-12
    232250.    2.40074E-16    1.51967E-12
    232300.    2.38186E-16    1.50771E-12
    232350.    2.36312E-16    1.49585E-12
    232400.    2.34452E-16    1.48408E-12
    232450.    2.32608E-16    1.47241E-12
    232500.    2.30778E-16    1.46082E-12
    232550.    2.28962E-16    1.44933E-12
    232600.    2.27160E-16    1.43793E-12
    232650.    2.25373E-16    1.42661E-12
    232700.    2.23600E-16    1.41539E-12
    232750.    2.21841E-16    1.40425E-12
    232800.    2.20095E-16    1.39320E-12
    232850.    2.18364E-16    1.38224E-12
    232900.    2.16646E-16    1.37137E-12
    232950.    2.14941E-16    1.36058E-12
    233000.    2.13250E-16    1.34987E-12
    233050.    2.11572E-16    1.33925E-12
    233100.    2.09908E-16    1.32872E-12
    233150.    2.08256E-16    1.31826E-12
    233200.    2.06618E-16    1.30789E-12
    233250.    2.04992E-16    1.29760E-12
    233300.    2.03379E-16    1.28739E-12
    233350.    2.01779E-16    1.27726E-12
    233400.    2.00192E-16    1.26721E-12
    233450.    1.98616E-16    1.25724E-12
    233500.    1.97054E-16    1.24735E-12
    233550.    1.95503E-16    1.23754E-12
    233600.    1.93965E-16    1.22780E-12
    233650.    1.92439E-16    1.21814E-12
    233700.    1.90925E-16    1.20856E-12
    233750.    1.89423E-16    1.19905E-12
    233800.    1.87933E-16    1.18961E-12
    233850.    1.86454E-16    1.18025E-12
    233900.    1.84987E-16    1.17097E-12
    233950.    1.83532E-16    1.16175E-12
    234000.    1.82088E-16    1.15261E-12
    234050.    1.80655E-16    1.14355E-12
    234100.    1.79234E-16    1.13455E-12
    234150.    1.77823E-16    1.12562E-12
    234200.    1.76424E-16    1.11677E-12
    234250.    1.75036E-16    1.10798E-12
    234300.    1.73659E-16    1.09926E-12
    234350.    1.72293E-16    1.09061E-12
    234400.    1.70937E-16    1.08203E-12
    234450.    1.69592E-16    1.07352E-12
    234500.    1.68258E-16    1.06507E-12
    234550.    1.66934E-16    1.05669E-12
    234600.    1.65621E-16    1.04838E-12
    234650.    1.64318E-16    1.04013E-12
    234700.    1.63025E-16    1.03195E-12
    234750.    1.61742E-16    1.02383E-12
    234800.    1.60470E-16    1.01577E-12
    234850.    1.59207E-16    1.00778E-12
    234900.    1.57955E-16    9.99853E-13
    234950.    1.56712E-16    9.91986E-13
    235000.    1.55479E-16    9.84181E-13
    235050.    1.54256E-16    9.76438E-13
    235100.    1.53042E-16    9.68756E-13
    235150.    1.51838E-16    9.61134E-13
    235200.    1.50643E-16    9.53572E-13
    235250.    1.49458E-16    9.46069E-13
    235300.    1.48282E-16    9.38626E-13
    235350.    1.47115E-16    9.31241E-13
    235400.    1.45958E-16    9.23914E-13
    235450.    1.44810E-16    9.16645E-13
    235500.    1.43670E-16    9.09433E-13
    235550.    1.42540E-16    9.02278E-13
    235600.    1.41418E-16    8.95179E-13
    235650.    1.40306E-16    8.88136E-13
    235700.    1.39202E-16    8.81148E-13
    235750.    1.38107E-16    8.74215E-13
    235800.    1.37020E-16    8.67337E-13
    235850.    1.35942E-16    8.60513E-13
    235900.    1.34872E-16    8.53743E-13
    235950.    1.33811E-16    8.47026E-13
    236000.    1.32759E-16    8.40362E-13
    236050.    1.31714E-16    8.33750E-13
    236100.    1.30678E-16    8.27190E-13
    236150.    1.29650E-16    8.20682E-13
    236200.    1.28630E-16    8.14225E-13
    236250.    1.27618E-16    8.07819E-13
    236300.    1.26613E-16    8.01463E-13
    236350.    1.25617E-16    7.95157E-13
    236400.    1.24629E-16    7.88901E-13
    236450.    1.23648E-16    7.82694E-13
    236500.    1.22676E-16    7.76536E-13
    236550.    1.21710E-16    7.70427E-13
    236600.    1.20753E-16    7.64365E-13
    236650.    1.19803E-16    7.58351E-13
    236700.    1.18860E-16    7.52385E-13
    236750.    1.17925E-16    7.46465E-13
    236800.    1.16997E-16    7.40592E-13
    236850.    1.16077E-16    7.34765E-13
    236900.    1.15163E-16    7.28984E-13
    236950.    1.14257E-16    7.23249E-13
    237000.    1.13358E-16    7.17558E-13
    237050.    1.12466E-16    7.11913E-13
    237100.    1.11582E-16    7.06312E-13
    237150.    1.10704E-16    7.00755E-13
    237200.    1.09833E-16    6.95241E-13
    237250.    1.08969E-16    6.89771E-13
    237300.    1.08111E-16    6.84344E-13
    237350.    1.07261E-16    6.78960E-13
    237400.    1.06417E-16    6.73618E-13
    237450.    1.05579E-16    6.68318E-13
    237500.    1.04749E-16    6.63060E-13
    237550.    1.03925E-16    6.57843E-13
    237600.    1.03107E-16    6.52667E-13
    237650.    1.02296E-16    6.47532E-13
    237700.    1.01491E-16    6.42438E-13
    237750.    1.00692E-16    6.37383E-13
    237800.    9.99002E-17    6.32368E-13
    237850.    9.91142E-17    6.27393E-13
    237900.    9.83344E-17    6.22457E-13
    237950.    9.75607E-17    6.17559E-13
    238000.    9.67931E-17    6.12701E-13
    238050.    9.60316E-17    6.07880E-13
    238100.    9.52760E-17    6.03097E-13
    238150.    9.45264E-17    5.98352E-13
    238200.    9.37827E-17    5.93645E-13
    238250.    9.30449E-17    5.88974E-13
    238300.    9.23128E-17    5.84340E-13
    238350.    9.15865E-17    5.79743E-13
    238400.    9.08659E-17    5.75181E-13
    238450.    9.01510E-17    5.70656E-13
    238500.    8.94417E-17    5.66166E-13
    238550.    8.87380E-17    5.61712E-13
    238600.    8.80398E-17    5.57292E-13
    238650.    8.73472E-17    5.52908E-13
    238700.    8.66599E-17    5.48557E-13
    238750.    8.59781E-17    5.44241E-13
    238800.    8.53017E-17    5.39960E-13
    238850.    8.46305E-17    5.35711E-13
    238900.    8.39647E-17    5.31496E-13
    238950.    8.33041E-17    5.27315E-13
    239000.    8.26486E-17    5.23166E-13
    239050.    8.19984E-17    5.19050E-13
    239100.    8.13532E-17    5.14966E-13
    239150.    8.07132E-17    5.10914E-13
    239200.    8.00781E-17    5.06895E-13
    239250.    7.94481E-17    5.02906E-13
    239300.    7.88230E-17    4.98950E-13
    239350.    7.82028E-17    4.95024E-13
    239400.    7.75876E-17    4.91129E-13
    239450.    7.69771E-17    4.87265E-13
    239500.    7.63715E-17    4.83431E-13
    239550.    7.57706E-17    4.79628E-13
    239600.    7.51745E-17    4.75854E-13
    239650.    7.45830E-17    4.72110E-13
    239700.    7.39962E-17    4.68396E-13
    239750.    7.34140E-17    4.64711E-13
    239800.    7.28364E-17    4.61054E-13
    239850.    7.22634E-17    4.57427E-13
    239900.    7.16948E-17    4.53828E-13
    239950.    7.11307E-17    4.50257E-13
    240000.    7.05711E-17    4.46715E-13
    240050.    7.00158E-17    4.43200E-13
    240100.    6.94650E-17    4.39713E-13
    240150.    6.89184E-17    4.36254E-13
    240200.    6.83762E-17    4.32821E-13
    240250.    6.78382E-17    4.29416E-13
    240300.    6.73045E-17    4.26037E-13
    240350.    6.67750E-17    4.22686E-13
    240400.    6.62496E-17    4.19360E-13
    240450.    6.57284E-17    4.16060E-13
    240500.    6.52112E-17    4.12787E-13
    240550.    6.46981E-17    4.09539E-13
    240600.    6.41891E-17    4.06317E-13
    240650.    6.36841E-17    4.03120E-13
    240700.    6.31830E-17    3.99949E-13
    240750.    6.26859E-17    3.96802E-13
    240800.    6.21927E-17    3.93680E-13
    240850.    6.17034E-17    3.90583E-13
    240900.    6.12179E-17    3.87510E-13
    240950.    6.07363E-17    3.84461E-13
    241000.    6.02584E-17    3.81436E-13
    241050.    5.97843E-17    3.78435E-13
    241100.    5.93140E-17    3.75457E-13
    241150.    5.88473E-17    3.72503E-13
    241200.    5.83843E-17    3.69573E-13
    241250.    5.79249E-17    3.66665E-13
    241300.    5.74692E-17    3.63780E-13
    241350.    5.70171E-17    3.60918E-13
    241400.    5.65685E-17    3.58078E-13
    241450.    5.61234E-17    3.55261E-13
    241500.    5.56818E-17    3.52466E-13
    241550.    5.52437E-17    3.49693E-13
    241600.    5.48091E-17    3.46941E-13
    241650.    5.43779E-17    3.44212E-13
    241700.    5.39500E-17    3.41504E-13
    241750.    5.35256E-17    3.38817E-13
    241800.    5.31044E-17    3.36151E-13
    241850.    5.26866E-17    3.33506E-13
    241900.    5.22721E-17    3.30882E-13
    241950.    5.18608E-17    3.28279E-13
    242000.    5.14528E-17    3.25696E-13
    242050.    5.10480E-17    3.23134E-13
    242100.    5.06463E-17    3.20591E-13
    242150.    5.02479E-17    3.18069E-13
    242200.    4.98525E-17    3.15566E-13
    242250.    4.94603E-17    3.13084E-13
    242300.    4.90712E-17    3.10620E-13
    242350.    4.86851E-17    3.08176E-13
    242400.    4.83020E-17    3.05752E-13
    242450.    4.79220E-17    3.03346E-13
    242500.    4.75450E-17    3.00960E-13
    242550.    4.71709E-17    2.98592E-13
    242600.    4.67998E-17    2.96242E-13
    242650.    4.64315E-17    2.93912E-13
    242700.    4.60662E-17    2.91599E-13
    242750.    4.57038E-17    2.89305E-13
    242800.    4.53442E-17    2.87029E-13
    242850.    4.49874E-17    2.84771E-13
    242900.    4.46335E-17    2.82530E-13
    242950.    4.42823E-17    2.80307E-13
    243000.    4.39339E-17    2.78102E-13
    243050.    4.35883E-17    2.75914E-13
    243100.    4.32453E-17    2.73743E-13
    243150.    4.29051E-17    2.71589E-13
    243200.    4.25675E-17    2.69452E-13
    243250.    4.22326E-17    2.67332E-13
    243300.    4.19003E-17    2.65229E-13
    243350.    4.15707E-17    2.63142E-13
    243400.    4.12436E-17    2.61072E-13
    243450.    4.09191E-17    2.59018E-13
    243500.    4.05972E-17    2.56980E-13
    243550.    4.02777E-17    2.54958E-13
    243600.    3.99608E-17    2.52952E-13
    243650.    3.96464E-17    2.50962E-13
    243700.    3.93345E-17    2.48987E-13
    243750.    3.90250E-17    2.47028E-13
    243800.    3.87180E-17    2.45085E-13
    243850.    3.84134E-17    2.43157E-13
    243900.    3.81111E-17    2.41244E-13
    243950.    3.78113E-17    2.39345E-13
    244000.    3.75138E-17    2.37462E-13
    244050.    3.72187E-17    2.35594E-13
    244100.    3.69258E-17    2.33740E-13
    244150.    3.66353E-17    2.31901E-13
    244200.    3.63471E-17    2.30077E-13
    244250.    3.60611E-17    2.28267E-13
    244300.    3.57774E-17    2.26471E-13
    244350.    3.54959E-17    2.24689E-13
    244400.    3.52166E-17    2.22921E-13
    244450.    3.49395E-17    2.21167E-13
    244500.    3.46646E-17    2.19427E-13
    244550.    3.43919E-17    2.17701E-13
    244600.    3.41213E-17    2.15988E-13
    244650.    3.38529E-17    2.14289E-13
    244700.    3.35865E-17    2.12603E-13
    244750.    3.33223E-17    2.10930E-13
    244800.    3.30601E-17    2.09270E-13
    244850.    3.28000E-17    2.07624E-13
    244900.    3.25419E-17    2.05990E-13
    244950.    3.22859E-17    2.04370E-13
    245000.    3.20319E-17    2.02762E-13
    245050.    3.17798E-17    2.01166E-13
    245100.    3.15298E-17    1.99584E-13
    245150.    3.12817E-17    1.98013E-13
    245200.    3.10356E-17    1.96455E-13
    245250.    3.07914E-17    1.94910E-13
    245300.    3.05492E-17    1.93376E-13
    245350.    3.03088E-17    1.91855E-13
    245400.    3.00704E-17    1.90345E-13
    245450.    2.98338E-17    1.88848E-13
    245500.    2.95990E-17    1.87362E-13
    245550.    2.93662E-17    1.85888E-13
    245600.    2.91351E-17    1.84425E-13
    245650.    2.89059E-17    1.82974E-13
    245700.    2.86785E-17    1.81535E-13
    245750.    2.84528E-17    1.80106E-13
    245800.    2.82290E-17    1.78689E-13
    245850.    2.80069E-17    1.77283E-13
    245900.    2.77865E-17    1.75889E-13
    245950.    2.75679E-17    1.74505E-13
    246000.    2.73510E-17    1.73132E-13
    246050.    2.71358E-17    1.71770E-13
    246100.    2.69223E-17    1.70418E-13
    246150.    2.67105E-17    1.69077E-13
    246200.    2.65003E-17    1.67747E-13
    246250.    2.62918E-17    1.66427E-13
    246300.    2.60850E-17    1.65118E-13
    246350.    2.58798E-17    1.63819E-13
    246400.    2.56761E-17    1.62530E-13
    246450.    2.54741E-17    1.61251E-13
    246500.    2.52737E-17    1.59983E-13
    246550.    2.50748E-17    1.58724E-13
    246600.    2.48776E-17    1.57475E-13
    246650.    2.46818E-17    1.56236E-13
    246700.    2.44876E-17    1.55007E-13
    246750.    2.42950E-17    1.53787E-13
    246800.    2.41038E-17    1.52577E-13
    246850.    2.39142E-17    1.51377E-13
    246900.    2.37260E-17    1.50186E-13
    246950.    2.35394E-17    1.49004E-13
    247000.    2.33542E-17    1.47832E-13
    247050.    2.31704E-17    1.46669E-13
    247100.    2.29881E-17    1.45515E-13
    247150.    2.28073E-17    1.44370E-13
    247200.    2.26278E-17    1.43234E-13
    247250.    2.24498E-17    1.42107E-13
    247300.    2.22731E-17    1.40989E-13
    247350.    2.20979E-17    1.39880E-13
    247400.    2.19240E-17    1.38779E-13
    247450.    2.17516E-17    1.37687E-13
    247500.    2.15804E-17    1.36604E-13
    247550.    2.14106E-17    1.35529E-13
    247600.    2.12422E-17    1.34463E-13
    247650.    2.10750E-17    1.33405E-13
    247700.    2.09092E-17    1.32355E-13
    247750.    2.07447E-17    1.31314E-13
    247800.    2.05815E-17    1.30281E-13
    247850.    2.04196E-17    1.29256E-13
    247900.    2.02589E-17    1.28239E-13
    247950.    2.00995E-17    1.27230E-13
    248000.    1.99414E-17    1.26229E-13
    248050.    1.97845E-17    1.25236E-13
    248100.    1.96288E-17    1.24251E-13
    248150.    1.94744E-17    1.23273E-13
    248200.    1.93212E-17    1.22303E-13
    248250.    1.91692E-17    1.21341E-13
    248300.    1.90183E-17    1.20386E-13
    248350.    1.88687E-17    1.19439E-13
    248400.    1.87203E-17    1.18499E-13
    248450.    1.85730E-17    1.17567E-13
    248500.    1.84268E-17    1.16642E-13
    248550.    1.82819E-17    1.15724E-13
    248600.    1.81380E-17    1.14814E-13
    248650.    1.79953E-17    1.13910E-13
    248700.    1.78537E-17    1.13014E-13
    248750.    1.77133E-17    1.12125E-13
    248800.    1.75739E-17    1.11243E-13
    248850.    1.74356E-17    1.10368E-13
    248900.    1.72985E-17    1.09499E-13
    248950.    1.71624E-17    1.08638E-13
    249000.    1.70273E-17    1.07783E-13
    249050.    1.68934E-17    1.06935E-13
    249100.    1.67604E-17    1.06094E-13
    249150.    1.66286E-17    1.05259E-13
    249200.    1.64977E-17    1.04431E-13
    249250.    1.63679E-17    1.03609E-13
    249300.    1.62392E-17    1.02794E-13
    249350.    1.61114E-17    1.01985E-13
    249400.    1.59846E-17    1.01183E-13
    249450.    1.58589E-17    1.00387E-13
    249500.    1.57341E-17    9.95969E-14
    249550.    1.56103E-17    9.88133E-14
    249600.    1.54875E-17    9.80358E-14
    249650.    1.53656E-17    9.72645E-14
    249700.    1.52447E-17    9.64993E-14
    249750.    1.51248E-17    9.57400E-14
    249800.    1.50058E-17    9.49868E-14
    249850.    1.48877E-17    9.42394E-14
    249900.    1.47706E-17    9.34980E-14
    249950.    1.46544E-17    9.27623E-14
    250000.    1.45391E-17    9.20325E-14
    250050.    1.44247E-17    9.13084E-14
    250100.    1.43112E-17    9.05900E-14
    250150.    1.41986E-17    8.98773E-14
    250200.    1.40869E-17    8.91701E-14
    250250.    1.39761E-17    8.84686E-14
    250300.    1.38661E-17    8.77725E-14
    250350.    1.37570E-17    8.70819E-14
    250400.    1.36488E-17    8.63968E-14
    250450.    1.35414E-17    8.57171E-14
    250500.    1.34349E-17    8.50427E-14
    250550.    1.33292E-17    8.43736E-14
    250600.    1.32243E-17    8.37097E-14
    250650.    1.31202E-17    8.30511E-14
    250700.    1.30170E-17    8.23977E-14
    250750.    1.29146E-17    8.17494E-14
    250800.    1.28130E-17    8.11062E-14
    250850.    1.27122E-17    8.04681E-14
    250900.    1.26122E-17    7.98350E-14
    250950.    1.25129E-17    7.92069E-14
    251000.    1.24145E-17    7.85837E-14
    251050.    1.23168E-17    7.79654E-14
    251100.    1.22199E-17    7.73520E-14
    251150.    1.21238E-17    7.67434E-14
    251200.    1.20284E-17    7.61396E-14
    251250.    1.19337E-17    7.55405E-14
    251300.    1.18398E-17    7.49462E-14
    251350.    1.17467E-17    7.43566E-14
    251400.    1.16543E-17    7.37715E-14
    251450.    1.15626E-17    7.31911E-14
    251500.    1.14716E-17    7.26153E-14
    251550.    1.13813E-17    7.20439E-14
    251600.    1.12918E-17    7.14771E-14
    251650.    1.12030E-17    7.09147E-14
    251700.    1.11148E-17    7.03568E-14
    251750.    1.10274E-17    6.98032E-14
    251800.    1.09406E-17    6.92541E-14
    251850.    1.08545E-17    6.87092E-14
    251900.    1.07691E-17    6.81686E-14
    251950.    1.06844E-17    6.76323E-14
    252000.    1.06003E-17    6.71001E-14
    252050.    1.05169E-17    6.65722E-14
    252100.    1.04342E-17    6.60484E-14
    252150.    1.03521E-17    6.55288E-14
    252200.    1.02707E-17    6.50132E-14
    252250.    1.01898E-17    6.45017E-14
    252300.    1.01097E-17    6.39942E-14
    252350.    1.00301E-17    6.34907E-14
    252400.    9.95122E-18    6.29912E-14
    252450.    9.87292E-18    6.24956E-14
    252500.    9.79524E-18    6.20039E-14
    252550.    9.71818E-18    6.15161E-14
    252600.    9.64172E-18    6.10321E-14
    252650.    9.56586E-18    6.05519E-14
    252700.    9.49060E-18    6.00755E-14
    252750.    9.41593E-18    5.96028E-14
    252800.    9.34184E-18    5.91339E-14
    252850.    9.26834E-18    5.86686E-14
    252900.    9.19542E-18    5.82070E-14
    252950.    9.12307E-18    5.77491E-14
    253000.    9.05130E-18    5.72947E-14
    253050.    8.98008E-18    5.68439E-14
    253100.    8.90943E-18    5.63967E-14
    253150.    8.83933E-18    5.59530E-14
    253200.    8.76979E-18    5.55127E-14
    253250.    8.70079E-18    5.50760E-14
    253300.    8.63233E-18    5.46427E-14
    253350.    8.56441E-18    5.42127E-14
    253400.    8.49703E-18    5.37862E-14
    253450.    8.43018E-18    5.33630E-14
    253500.    8.36385E-18    5.29432E-14
    253550.    8.29805E-18    5.25266E-14
    253600.    8.23276E-18    5.21134E-14
    253650.    8.16799E-18    5.17034E-14
    253700.    8.10372E-18    5.12966E-14
    253750.    8.03996E-18    5.08930E-14
    253800.    7.97671E-18    5.04926E-14
    253850.    7.91395E-18    5.00953E-14
    253900.    7.85168E-18    4.97012E-14
    253950.    7.78991E-18    4.93101E-14
    254000.    7.72862E-18    4.89222E-14
    254050.    7.66781E-18    4.85372E-14
    254100.    7.60748E-18    4.81554E-14
    254150.    7.54763E-18    4.77765E-14
    254200.    7.48825E-18    4.74006E-14
    254250.    7.42933E-18    4.70277E-14
    254300.    7.37088E-18    4.66577E-14
    254350.    7.31288E-18    4.62906E-14
    254400.    7.25535E-18    4.59264E-14
    254450.    7.19827E-18    4.55650E-14
    254500.    7.14163E-18    4.52065E-14
    254550.    7.08544E-18    4.48508E-14
    254600.    7.02970E-18    4.44980E-14
    254650.    6.97439E-18    4.41479E-14
    254700.    6.91951E-18    4.38005E-14
    254750.    6.86507E-18    4.34559E-14
    254800.    6.81106E-18    4.31140E-14
    254850.    6.75747E-18    4.27748E-14
    254900.    6.70431E-18    4.24383E-14
    254950.    6.65156E-18    4.21044E-14
    255000.    6.59923E-18    4.17731E-14
    255050.    6.54730E-18    4.14444E-14
    255100.    6.49579E-18    4.11184E-14
    255150.    6.44468E-18    4.07948E-14
    255200.    6.39398E-18    4.04739E-14
    255250.    6.34367E-18    4.01554E-14
    255300.    6.29376E-18    3.98395E-14
    255350.    6.24424E-18    3.95261E-14
    255400.    6.19512E-18    3.92151E-14
    255450.    6.14637E-18    3.89065E-14
    255500.    6.09801E-18    3.86004E-14
    255550.    6.05004E-18    3.82967E-14
    255600.    6.00244E-18    3.79954E-14
    255650.    5.95521E-18    3.76965E-14
    255700.    5.90836E-18    3.73999E-14
    255750.    5.86187E-18    3.71056E-14
    255800.    5.81575E-18    3.68137E-14
    255850.    5.76999E-18    3.65241E-14
    255900.    5.72460E-18    3.62367E-14
    255950.    5.67956E-18    3.59516E-14
    256000.    5.63487E-18    3.56687E-14
    256050.    5.59054E-18    3.53881E-14
    256100.    5.54655E-18    3.51097E-14
    256150.    5.50291E-18    3.48334E-14
    256200.    5.45962E-18    3.45594E-14
    256250.    5.41666E-18    3.42875E-14
    256300.    5.37405E-18    3.40177E-14
    256350.    5.33176E-18    3.37501E-14
    256400.    5.28981E-18    3.34845E-14
    256450.    5.24820E-18    3.32211E-14
    256500.    5.20690E-18    3.29597E-14
    256550.    5.16594E-18    3.27004E-14
    256600.    5.12529E-18    3.24431E-14
    256650.    5.08497E-18    3.21878E-14
    256700.    5.04496E-18    3.19346E-14
    256750.    5.00527E-18    3.16833E-14
    256800.    4.96589E-18    3.14341E-14
    256850.    4.92682E-18    3.11868E-14
    256900.    4.88805E-18    3.09414E-14
    256950.    4.84960E-18    3.06979E-14
    257000.    4.81144E-18    3.04564E-14
    257050.    4.77358E-18    3.02168E-14
    257100.    4.73603E-18    2.99791E-14
    257150.    4.69877E-18    2.97432E-14
    257200.    4.66180E-18    2.95092E-14
    257250.    4.62512E-18    2.92770E-14
    257300.    4.58873E-18    2.90467E-14
    257350.    4.55263E-18    2.88181E-14
    257400.    4.51681E-18    2.85914E-14
    257450.    4.48127E-18    2.83664E-14
    257500.    4.44601E-18    2.81433E-14
    257550.    4.41103E-18    2.79218E-14
    257600.    4.37633E-18    2.77021E-14
    257650.    4.34189E-18    2.74842E-14
    257700.    4.30773E-18    2.72680E-14
    257750.    4.27384E-18    2.70534E-14
    257800.    4.24022E-18    2.68406E-14
    257850.    4.20685E-18    2.66294E-14
    257900.    4.17376E-18    2.64199E-14
    257950.    4.14092E-18    2.62120E-14
    258000.    4.10834E-18    2.60058E-14
    258050.    4.07601E-18    2.58012E-14
    258100.    4.04395E-18    2.55982E-14
    258150.    4.01213E-18    2.53968E-14
    258200.    3.98056E-18    2.51970E-14
    258250.    3.94924E-18    2.49987E-14
    258300.    3.91817E-18    2.48020E-14
    258350.    3.88734E-18    2.46069E-14
    258400.    3.85676E-18    2.44133E-14
    258450.    3.82642E-18    2.42212E-14
    258500.    3.79631E-18    2.40306E-14
    258550.    3.76644E-18    2.38416E-14
    258600.    3.73681E-18    2.36540E-14
    258650.    3.70741E-18    2.34679E-14
    258700.    3.67824E-18    2.32833E-14
    258750.    3.64930E-18    2.31001E-14
    258800.    3.62059E-18    2.29183E-14
    258850.    3.59210E-18    2.27380E-14
    258900.    3.56384E-18    2.25591E-14
    258950.    3.53580E-18    2.23816E-14
    259000.    3.50798E-18    2.22055E-14
    259050.    3.48038E-18    2.20308E-14
    259100.    3.45300E-18    2.18575E-14
    259150.    3.42583E-18    2.16855E-14
    259200.    3.39888E-18    2.15149E-14
    259250.    3.37214E-18    2.13456E-14
    259300.    3.34560E-18    2.11777E-14
    259350.    3.31928E-18    2.10111E-14
    259400.    3.29317E-18    2.08457E-14
    259450.    3.26726E-18    2.06817E-14
    259500.    3.24155E-18    2.05190E-14
    259550.    3.21605E-18    2.03576E-14
    259600.    3.19074E-18    2.01974E-14
    259650.    3.16564E-18    2.00385E-14
    259700.    3.14073E-18    1.98808E-14
    259750.    3.11602E-18    1.97244E-14
    259800.    3.09151E-18    1.95692E-14
    259850.    3.06718E-18    1.94153E-14
    259900.    3.04305E-18    1.92625E-14
    259950.    3.01911E-18    1.91110E-14
    260000.    2.99536E-18    1.89606E-14
    260050.    2.97179E-18    1.88114E-14
    260100.    2.94841E-18    1.86634E-14
    260150.    2.92521E-18    1.85166E-14
    260200.    2.90219E-18    1.83709E-14
    260250.    2.87936E-18    1.82264E-14
    260300.    2.85671E-18    1.80830E-14
    260350.    2.83423E-18    1.79407E-14
    260400.    2.81193E-18    1.77995E-14
    260450.    2.78981E-18    1.76595E-14
    260500.    2.76786E-18    1.75205E-14
    260550.    2.74608E-18    1.73827E-14
    260600.    2.72448E-18    1.72459E-14
    260650.    2.70304E-18    1.71102E-14
    260700.    2.68177E-18    1.69756E-14
    260750.    2.66067E-18    1.68421E-14
    260800.    2.63974E-18    1.67096E-14
    260850.    2.61897E-18    1.65781E-14
    260900.    2.59837E-18    1.64477E-14
    260950.    2.57792E-18    1.63182E-14
    261000.    2.55764E-18    1.61899E-14
    261050.    2.53752E-18    1.60625E-14
    261100.    2.51755E-18    1.59361E-14
    261150.    2.49774E-18    1.58107E-14
    261200.    2.47809E-18    1.56863E-14
    261250.    2.45860E-18    1.55629E-14
    261300.    2.43925E-18    1.54405E-14
    261350.    2.42006E-18    1.53190E-14
    261400.    2.40102E-18    1.51985E-14
    261450.    2.38213E-18    1.50789E-14
    261500.    2.36339E-18    1.49602E-14
    261550.    2.34479E-18    1.48425E-14
    261600.    2.32634E-18    1.47258E-14
    261650.    2.30804E-18    1.46099E-14
    261700.    2.28988E-18    1.44950E-14
    261750.    2.27187E-18    1.43809E-14
    261800.    2.25399E-18    1.42678E-14
    261850.    2.23626E-18    1.41555E-14
    261900.    2.21866E-18    1.40441E-14
    261950.    2.20121E-18    1.39336E-14
    262000.    2.18389E-18    1.38240E-14
    262050.    2.16671E-18    1.37153E-14
    262100.    2.14966E-18    1.36073E-14
    262150.    2.13275E-18    1.35003E-14
    262200.    2.11597E-18    1.33941E-14
    262250.    2.09932E-18    1.32887E-14
    262300.    2.08280E-18    1.31841E-14
    262350.    2.06641E-18    1.30804E-14
    262400.    2.05016E-18    1.29775E-14
    262450.    2.03403E-18    1.28754E-14
    262500.    2.01802E-18    1.27741E-14
    262550.    2.00215E-18    1.26736E-14
    262600.    1.98639E-18    1.25739E-14
    262650.    1.97076E-18    1.24749E-14
    262700.    1.95526E-18    1.23768E-14
    262750.    1.93988E-18    1.22794E-14
    262800.    1.92461E-18    1.21828E-14
    262850.    1.90947E-18    1.20869E-14
    262900.    1.89445E-18    1.19918E-14
    262950.    1.87954E-18    1.18975E-14
    263000.    1.86475E-18    1.18039E-14
    263050.    1.85008E-18    1.17110E-14
    263100.    1.83553E-18    1.16189E-14
    263150.    1.82109E-18    1.15275E-14
    263200.    1.80676E-18    1.14368E-14
    263250.    1.79254E-18    1.13468E-14
    263300.    1.77844E-18    1.12575E-14
    263350.    1.76445E-18    1.11689E-14
    263400.    1.75056E-18    1.10811E-14
    263450.    1.73679E-18    1.09939E-14
    263500.    1.72313E-18    1.09074E-14
    263550.    1.70957E-18    1.08216E-14
    263600.    1.69612E-18    1.07364E-14
    263650.    1.68277E-18    1.06520E-14
    263700.    1.66953E-18    1.05682E-14
    263750.    1.65640E-18    1.04850E-14
    263800.    1.64337E-18    1.04025E-14
    263850.    1.63044E-18    1.03207E-14
    263900.    1.61761E-18    1.02395E-14
    263950.    1.60488E-18    1.01589E-14
    264000.    1.59226E-18    1.00790E-14
    264050.    1.57973E-18    9.99968E-15
    264100.    1.56730E-18    9.92100E-15
    264150.    1.55497E-18    9.84294E-15
    264200.    1.54273E-18    9.76550E-15
    264250.    1.53060E-18    9.68867E-15
    264300.    1.51855E-18    9.61244E-15
    264350.    1.50661E-18    9.53681E-15
    264400.    1.49475E-18    9.46178E-15
    264450.    1.48299E-18    9.38733E-15
    264500.    1.47132E-18    9.31348E-15
    264550.    1.45975E-18    9.24020E-15
    264600.    1.44826E-18    9.16750E-15
    264650.    1.43687E-18    9.09537E-15
    264700.    1.42556E-18    9.02381E-15
    264750.    1.41435E-18    8.95282E-15
    264800.    1.40322E-18    8.88238E-15
    264850.    1.39218E-18    8.81249E-15
    264900.    1.38123E-18    8.74316E-15
    264950.    1.37036E-18    8.67437E-15
    265000.    1.35958E-18    8.60612E-15
    265050.    1.34888E-18    8.53841E-15
    265100.    1.33827E-18    8.47123E-15
    265150.    1.32774E-18    8.40458E-15
    265200.    1.31729E-18    8.33846E-15
    265250.    1.30693E-18    8.27285E-15
    265300.    1.29664E-18    8.20776E-15
    265350.    1.28644E-18    8.14319E-15
    265400.    1.27632E-18    8.07912E-15
    265450.    1.26628E-18    8.01555E-15
    265500.    1.25632E-18    7.95249E-15
    265550.    1.24643E-18    7.88992E-15
    265600.    1.23663E-18    7.82784E-15
    265650.    1.22690E-18    7.76625E-15
    265700.    1.21724E-18    7.70515E-15
    265750.    1.20767E-18    7.64453E-15
    265800.    1.19816E-18    7.58438E-15
    265850.    1.18874E-18    7.52471E-15
    265900.    1.17939E-18    7.46551E-15
    265950.    1.17011E-18    7.40677E-15
    266000.    1.16090E-18    7.34850E-15
    266050.    1.15177E-18    7.29068E-15
    266100.    1.14270E-18    7.23332E-15
    266150.    1.13371E-18    7.17641E-15
    266200.    1.12479E-18    7.11995E-15
    266250.    1.11594E-18    7.06393E-15
    266300.    1.10716E-18    7.00835E-15
    266350.    1.09845E-18    6.95321E-15
    266400.    1.08981E-18    6.89850E-15
    266450.    1.08124E-18    6.84423E-15
    266500.    1.07273E-18    6.79038E-15
    266550.    1.06429E-18    6.73695E-15
    266600.    1.05592E-18    6.68395E-15
    266650.    1.04761E-18    6.63136E-15
    266700.    1.03937E-18    6.57919E-15
    266750.    1.03119E-18    6.52742E-15
    266800.    1.02308E-18    6.47607E-15
    266850.    1.01503E-18    6.42512E-15
    266900.    1.00704E-18    6.37456E-15
    266950.    9.99117E-19    6.32441E-15
    267000.    9.91256E-19    6.27465E-15
    267050.    9.83457E-19    6.22528E-15
    267100.    9.75720E-19    6.17630E-15
    267150.    9.68043E-19    6.12771E-15
    267200.    9.60426E-19    6.07950E-15
    267250.    9.52870E-19    6.03167E-15
    267300.    9.45373E-19    5.98421E-15
    267350.    9.37935E-19    5.93713E-15
    267400.    9.30556E-19    5.89042E-15
    267450.    9.23234E-19    5.84407E-15
    267500.    9.15970E-19    5.79809E-15
    267550.    9.08764E-19    5.75247E-15
    267600.    9.01614E-19    5.70721E-15
    267650.    8.94520E-19    5.66231E-15
    267700.    8.87482E-19    5.61776E-15
    267750.    8.80500E-19    5.57356E-15
    267800.    8.73572E-19    5.52971E-15
    267850.    8.66699E-19    5.48620E-15
    267900.    8.59880E-19    5.44304E-15
    267950.    8.53115E-19    5.40022E-15
    268000.    8.46402E-19    5.35773E-15
    268050.    8.39743E-19    5.31557E-15
    268100.    8.33136E-19    5.27375E-15
    268150.    8.26581E-19    5.23226E-15
    268200.    8.20078E-19    5.19109E-15
    268250.    8.13626E-19    5.15025E-15
    268300.    8.07224E-19    5.10973E-15
    268350.    8.00873E-19    5.06953E-15
    268400.    7.94572E-19    5.02964E-15
    268450.    7.88321E-19    4.99007E-15
    268500.    7.82118E-19    4.95081E-15
    268550.    7.75965E-19    4.91186E-15
    268600.    7.69860E-19    4.87321E-15
    268650.    7.63803E-19    4.83487E-15
    268700.    7.57793E-19    4.79683E-15
    268750.    7.51831E-19    4.75909E-15
    268800.    7.45916E-19    4.72165E-15
    268850.    7.40047E-19    4.68450E-15
    268900.    7.34225E-19    4.64764E-15
    268950.    7.28448E-19    4.61107E-15
    269000.    7.22717E-19    4.57480E-15
    269050.    7.17030E-19    4.53880E-15
    269100.    7.11389E-19    4.50309E-15
    269150.    7.05792E-19    4.46766E-15
    269200.    7.00239E-19    4.43251E-15
    269250.    6.94730E-19    4.39764E-15
    269300.    6.89264E-19    4.36304E-15
    269350.    6.83841E-19    4.32871E-15
    269400.    6.78460E-19    4.29465E-15
    269450.    6.73122E-19    4.26086E-15
    269500.    6.67826E-19    4.22734E-15
    269550.    6.62572E-19    4.19408E-15
    269600.    6.57359E-19    4.16108E-15
    269650.    6.52187E-19    4.12834E-15
    269700.    6.47056E-19    4.09586E-15
    269750.    6.41965E-19    4.06364E-15
    269800.    6.36914E-19    4.03167E-15
    269850.    6.31903E-19    3.99995E-15
    269900.    6.26931E-19    3.96848E-15
    269950.    6.21999E-19    3.93725E-15
    270000.    6.17105E-19    3.90627E-15
    270050.    6.12250E-19    3.87554E-15
    270100.    6.07433E-19    3.84505E-15
    270150.    6.02654E-19    3.81480E-15
    270200.    5.97912E-19    3.78478E-15
    270250.    5.93208E-19    3.75501E-15
    270300.    5.88541E-19    3.72546E-15
    270350.    5.83910E-19    3.69615E-15
    270400.    5.79316E-19    3.66707E-15
    270450.    5.74758E-19    3.63822E-15
    270500.    5.70236E-19    3.60959E-15
    270550.    5.65750E-19    3.58119E-15
    270600.    5.61298E-19    3.55302E-15
    270650.    5.56882E-19    3.52506E-15
    270700.    5.52501E-19    3.49733E-15
    270750.    5.48154E-19    3.46981E-15
    270800.    5.43841E-19    3.44251E-15
    270850.    5.39562E-19    3.41543E-15
    270900.    5.35317E-19    3.38856E-15
    270950.    5.31105E-19    3.36190E-15
    271000.    5.26927E-19    3.33545E-15
    271050.    5.22781E-19    3.30920E-15
    271100.    5.18668E-19    3.28317E-15
    271150.    5.14587E-19    3.25734E-15
    271200.    5.10538E-19    3.23171E-15
    271250.    5.06522E-19    3.20628E-15
    271300.    5.02536E-19    3.18106E-15
    271350.    4.98582E-19    3.15603E-15
    271400.    4.94660E-19    3.13120E-15
    271450.    4.90768E-19    3.10656E-15
    271500.    4.86907E-19    3.08212E-15
    271550.    4.83076E-19    3.05787E-15
    271600.    4.79275E-19    3.03381E-15
    271650.    4.75504E-19    3.00994E-15
    271700.    4.71763E-19    2.98626E-15
    271750.    4.68051E-19    2.96276E-15
    271800.    4.64369E-19    2.93945E-15
    271850.    4.60715E-19    2.91633E-15
    271900.    4.57090E-19    2.89338E-15
    271950.    4.53494E-19    2.87062E-15
    272000.    4.49926E-19    2.84803E-15
    272050.    4.46386E-19    2.82562E-15
    272100.    4.42874E-19    2.80339E-15
    272150.    4.39390E-19    2.78134E-15
    272200.    4.35933E-19    2.75945E-15
    272250.    4.32503E-19    2.73774E-15
    272300.    4.29100E-19    2.71620E-15
    272350.    4.25724E-19    2.69483E-15
    272400.    4.22374E-19    2.67363E-15
    272450.    4.19051E-19    2.65260E-15
    272500.    4.15754E-19    2.63173E-15
    272550.    4.12483E-19    2.61102E-15
    272600.    4.09238E-19    2.59048E-15
    272650.    4.06018E-19    2.57009E-15
    272700.    4.02824E-19    2.54987E-15
    272750.    3.99654E-19    2.52981E-15
    272800.    3.96510E-19    2.50991E-15
    272850.    3.93390E-19    2.49016E-15
    272900.    3.90295E-19    2.47057E-15
    272950.    3.87224E-19    2.45113E-15
    273000.    3.84178E-19    2.43185E-15
    273050.    3.81155E-19    2.41271E-15
    273100.    3.78156E-19    2.39373E-15
    273150.    3.75181E-19    2.37490E-15
    273200.    3.72229E-19    2.35621E-15
    273250.    3.69301E-19    2.33767E-15
    273300.    3.66395E-19    2.31928E-15
    273350.    3.63512E-19    2.30103E-15
    273400.    3.60652E-19    2.28293E-15
    273450.    3.57815E-19    2.26497E-15
    273500.    3.55000E-19    2.24715E-15
    273550.    3.52207E-19    2.22947E-15
    273600.    3.49435E-19    2.21193E-15
    273650.    3.46686E-19    2.19452E-15
    273700.    3.43959E-19    2.17726E-15
    273750.    3.41252E-19    2.16013E-15
    273800.    3.38567E-19    2.14313E-15
    273850.    3.35904E-19    2.12627E-15
    273900.    3.33261E-19    2.10954E-15
    273950.    3.30639E-19    2.09294E-15
    274000.    3.28037E-19    2.07648E-15
    274050.    3.25457E-19    2.06014E-15
    274100.    3.22896E-19    2.04393E-15
    274150.    3.20355E-19    2.02785E-15
    274200.    3.17835E-19    2.01190E-15
    274250.    3.15334E-19    1.99607E-15
    274300.    3.12853E-19    1.98036E-15
    274350.    3.10392E-19    1.96478E-15
    274400.    3.07950E-19    1.94932E-15
    274450.    3.05527E-19    1.93399E-15
    274500.    3.03123E-19    1.91877E-15
    274550.    3.00738E-19    1.90367E-15
    274600.    2.98372E-19    1.88869E-15
    274650.    2.96024E-19    1.87383E-15
    274700.    2.93695E-19    1.85909E-15
    274750.    2.91385E-19    1.84447E-15
    274800.    2.89092E-19    1.82995E-15
    274850.    2.86818E-19    1.81556E-15
    274900.    2.84561E-19    1.80127E-15
    274950.    2.82322E-19    1.78710E-15
    275000.    2.80101E-19    1.77304E-15
    275050.    2.77897E-19    1.75909E-15
    275100.    2.75711E-19    1.74525E-15
    275150.    2.73541E-19    1.73152E-15
    275200.    2.71389E-19    1.71789E-15
    275250.    2.69254E-19    1.70438E-15
    275300.    2.67136E-19    1.69097E-15
    275350.    2.65034E-19    1.67766E-15
    275400.    2.62949E-19    1.66446E-15
    275450.    2.60880E-19    1.65137E-15
    275500.    2.58827E-19    1.63838E-15
    275550.    2.56791E-19    1.62549E-15
    275600.    2.54770E-19    1.61270E-15
    275650.    2.52766E-19    1.60001E-15
    275700.    2.50777E-19    1.58742E-15
    275750.    2.48804E-19    1.57493E-15
    275800.    2.46847E-19    1.56254E-15
    275850.    2.44905E-19    1.55025E-15
    275900.    2.42978E-19    1.53805E-15
    275950.    2.41066E-19    1.52595E-15
    276000.    2.39169E-19    1.51394E-15
    276050.    2.37288E-19    1.50203E-15
    276100.    2.35421E-19    1.49021E-15
    276150.    2.33568E-19    1.47849E-15
    276200.    2.31731E-19    1.46686E-15
    276250.    2.29908E-19    1.45532E-15
    276300.    2.28099E-19    1.44386E-15
    276350.    2.26304E-19    1.43250E-15
    276400.    2.24524E-19    1.42123E-15
    276450.    2.22757E-19    1.41005E-15
    276500.    2.21004E-19    1.39896E-15
    276550.    2.19266E-19    1.38795E-15
    276600.    2.17541E-19    1.37703E-15
    276650.    2.15829E-19    1.36620E-15
    276700.    2.14131E-19    1.35545E-15
    276750.    2.12446E-19    1.34478E-15
    276800.    2.10775E-19    1.33420E-15
    276850.    2.09116E-19    1.32371E-15
    276900.    2.07471E-19    1.31329E-15
    276950.    2.05839E-19    1.30296E-15
    277000.    2.04219E-19    1.29271E-15
    277050.    2.02612E-19    1.28254E-15
    277100.    2.01018E-19    1.27245E-15
    277150.    1.99437E-19    1.26243E-15
    277200.    1.97868E-19    1.25250E-15
    277250.    1.96311E-19    1.24265E-15
    277300.    1.94766E-19    1.23287E-15
    277350.    1.93234E-19    1.22317E-15
    277400.    1.91714E-19    1.21355E-15
    277450.    1.90205E-19    1.20400E-15
    277500.    1.88709E-19    1.19453E-15
    277550.    1.87224E-19    1.18513E-15
    277600.    1.85751E-19    1.17580E-15
    277650.    1.84290E-19    1.16655E-15
    277700.    1.82840E-19    1.15738E-15
    277750.    1.81401E-19    1.14827E-15
    277800.    1.79974E-19    1.13923E-15
    277850.    1.78558E-19    1.13027E-15
    277900.    1.77153E-19    1.12138E-15
    277950.    1.75759E-19    1.11256E-15
    278000.    1.74376E-19    1.10380E-15
    278050.    1.73004E-19    1.09512E-15
    278100.    1.71643E-19    1.08650E-15
    278150.    1.70293E-19    1.07795E-15
    278200.    1.68953E-19    1.06947E-15
    278250.    1.67624E-19    1.06106E-15
    278300.    1.66305E-19    1.05271E-15
    278350.    1.64996E-19    1.04443E-15
    278400.    1.63698E-19    1.03621E-15
    278450.    1.62410E-19    1.02806E-15
    278500.    1.61133E-19    1.01997E-15
    278550.    1.59865E-19    1.01194E-15
    278600.    1.58607E-19    1.00398E-15
    278650.    1.57359E-19    9.96083E-16
    278700.    1.56121E-19    9.88246E-16
    278750.    1.54893E-19    9.80471E-16
    278800.    1.53674E-19    9.72757E-16
    278850.    1.52465E-19    9.65103E-16
    278900.    1.51265E-19    9.57510E-16
    278950.    1.50075E-19    9.49977E-16
    279000.    1.48895E-19    9.42502E-16
    279050.    1.47723E-19    9.35087E-16
    279100.    1.46561E-19    9.27730E-16
    279150.    1.45408E-19    9.20431E-16
    279200.    1.44264E-19    9.13189E-16
    279250.    1.43129E-19    9.06004E-16
    279300.    1.42003E-19    8.98876E-16
    279350.    1.40885E-19    8.91804E-16
    279400.    1.39777E-19    8.84787E-16
    279450.    1.38677E-19    8.77826E-16
    279500.    1.37586E-19    8.70920E-16
    279550.    1.36504E-19    8.64067E-16
    279600.    1.35430E-19    8.57269E-16
    279650.    1.34364E-19    8.50524E-16
    279700.    1.33307E-19    8.43832E-16
    279750.    1.32258E-19    8.37193E-16
    279800.    1.31217E-19    8.30607E-16
    279850.    1.30185E-19    8.24072E-16
    279900.    1.29161E-19    8.17588E-16
    279950.    1.28145E-19    8.11155E-16
    280000.    1.27136E-19    8.04773E-16
    280050.    1.26136E-19    7.98442E-16
    280100.    1.25144E-19    7.92160E-16
    280150.    1.24159E-19    7.85927E-16
    280200.    1.23182E-19    7.79744E-16
    280250.    1.22213E-19    7.73609E-16
    280300.    1.21252E-19    7.67522E-16
    280350.    1.20298E-19    7.61483E-16
    280400.    1.19351E-19    7.55492E-16
    280450.    1.18412E-19    7.49548E-16
    280500.    1.17480E-19    7.43651E-16
    280550.    1.16556E-19    7.37800E-16
    280600.    1.15639E-19    7.31995E-16
    280650.    1.14729E-19    7.26236E-16
    280700.    1.13827E-19    7.20522E-16
    280750.    1.12931E-19    7.14853E-16
    280800.    1.12042E-19    7.09229E-16
    280850.    1.11161E-19    7.03649E-16
    280900.    1.10286E-19    6.98113E-16
    280950.    1.09419E-19    6.92620E-16
    281000.    1.08558E-19    6.87171E-16
    281050.    1.07704E-19    6.81764E-16
    281100.    1.06856E-19    6.76400E-16
    281150.    1.06016E-19    6.71078E-16
    281200.    1.05181E-19    6.65799E-16
    281250.    1.04354E-19    6.60560E-16
    281300.    1.03533E-19    6.55363E-16
    281350.    1.02718E-19    6.50207E-16
    281400.    1.01910E-19    6.45091E-16
    281450.    1.01108E-19    6.40016E-16
    281500.    1.00313E-19    6.34980E-16
    281550.    9.95236E-20    6.29984E-16
    281600.    9.87406E-20    6.25028E-16
    281650.    9.79637E-20    6.20110E-16
    281700.    9.71929E-20    6.15231E-16
    281750.    9.64282E-20    6.10391E-16
    281800.    9.56696E-20    6.05588E-16
    281850.    9.49169E-20    6.00824E-16
    281900.    9.41701E-20    5.96097E-16
    281950.    9.34292E-20    5.91407E-16
    282000.    9.26941E-20    5.86754E-16
    282050.    9.19648E-20    5.82137E-16
    282100.    9.12412E-20    5.77557E-16
    282150.    9.05234E-20    5.73013E-16
    282200.    8.98111E-20    5.68505E-16
    282250.    8.91045E-20    5.64032E-16
    282300.    8.84035E-20    5.59594E-16
    282350.    8.77079E-20    5.55191E-16
    282400.    8.70179E-20    5.50823E-16
    282450.    8.63332E-20    5.46489E-16
    282500.    8.56540E-20    5.42190E-16
    282550.    8.49801E-20    5.37924E-16
    282600.    8.43115E-20    5.33692E-16
    282650.    8.36481E-20    5.29493E-16
    282700.    8.29900E-20    5.25327E-16
    282750.    8.23371E-20    5.21194E-16
    282800.    8.16892E-20    5.17093E-16
    282850.    8.10465E-20    5.13025E-16
    282900.    8.04089E-20    5.08988E-16
    282950.    7.97762E-20    5.04984E-16
    283000.    7.91486E-20    5.01010E-16
    283050.    7.85259E-20    4.97069E-16
    283100.    7.79080E-20    4.93158E-16
    283150.    7.72951E-20    4.89278E-16
    283200.    7.66869E-20    4.85428E-16
    283250.    7.60836E-20    4.81609E-16
    283300.    7.54850E-20    4.77820E-16
    283350.    7.48911E-20    4.74060E-16
    283400.    7.43018E-20    4.70331E-16
    283450.    7.37172E-20    4.66630E-16
    283500.    7.31372E-20    4.62959E-16
    283550.    7.25618E-20    4.59316E-16
    283600.    7.19909E-20    4.55703E-16
    283650.    7.14245E-20    4.52117E-16
    283700.    7.08626E-20    4.48560E-16
    283750.    7.03050E-20    4.45031E-16
    283800.    6.97519E-20    4.41529E-16
    283850.    6.92031E-20    4.38056E-16
    283900.    6.86586E-20    4.34609E-16
    283950.    6.81184E-20    4.31190E-16
    284000.    6.75825E-20    4.27797E-16
    284050.    6.70508E-20    4.24431E-16
    284100.    6.65232E-20    4.21092E-16
    284150.    6.59998E-20    4.17779E-16
    284200.    6.54806E-20    4.14492E-16
    284250.    6.49654E-20    4.11231E-16
    284300.    6.44542E-20    4.07995E-16
    284350.    6.39471E-20    4.04785E-16
    284400.    6.34440E-20    4.01601E-16
    284450.    6.29448E-20    3.98441E-16
    284500.    6.24496E-20    3.95306E-16
    284550.    6.19583E-20    3.92196E-16
    284600.    6.14708E-20    3.89110E-16
    284650.    6.09872E-20    3.86049E-16
    284700.    6.05073E-20    3.83011E-16
    284750.    6.00313E-20    3.79998E-16
    284800.    5.95589E-20    3.77008E-16
    284850.    5.90904E-20    3.74042E-16
    284900.    5.86254E-20    3.71099E-16
    284950.    5.81642E-20    3.68179E-16
    285000.    5.77066E-20    3.65283E-16
    285050.    5.72525E-20    3.62409E-16
    285100.    5.68021E-20    3.59557E-16
    285150.    5.63552E-20    3.56728E-16
    285200.    5.59118E-20    3.53922E-16
    285250.    5.54719E-20    3.51137E-16
    285300.    5.50355E-20    3.48374E-16
    285350.    5.46025E-20    3.45634E-16
    285400.    5.41728E-20    3.42914E-16
    285450.    5.37466E-20    3.40216E-16
    285500.    5.33238E-20    3.37539E-16
    285550.    5.29042E-20    3.34884E-16
    285600.    5.24880E-20    3.32249E-16
    285650.    5.20750E-20    3.29635E-16
    285700.    5.16653E-20    3.27041E-16
    285750.    5.12588E-20    3.24468E-16
    285800.    5.08555E-20    3.21915E-16
    285850.    5.04554E-20    3.19383E-16
    285900.    5.00584E-20    3.16870E-16
    285950.    4.96646E-20    3.14377E-16
    286000.    4.92738E-20    3.11903E-16
    286050.    4.88862E-20    3.09449E-16
    286100.    4.85015E-20    3.07015E-16
    286150.    4.81199E-20    3.04599E-16
    286200.    4.77413E-20    3.02203E-16
    286250.    4.73657E-20    2.99825E-16
    286300.    4.69931E-20    2.97466E-16
    286350.    4.66233E-20    2.95126E-16
    286400.    4.62565E-20    2.92804E-16
    286450.    4.58926E-20    2.90500E-16
    286500.    4.55315E-20    2.88214E-16
    286550.    4.51733E-20    2.85947E-16
    286600.    4.48178E-20    2.83697E-16
    286650.    4.44652E-20    2.81465E-16
    286700.    4.41154E-20    2.79250E-16
    286750.    4.37683E-20    2.77053E-16
    286800.    4.34239E-20    2.74874E-16
    286850.    4.30823E-20    2.72711E-16
    286900.    4.27433E-20    2.70565E-16
    286950.    4.24070E-20    2.68436E-16
    287000.    4.20734E-20    2.66324E-16
    287050.    4.17424E-20    2.64229E-16
    287100.    4.14139E-20    2.62150E-16
    287150.    4.10881E-20    2.60088E-16
    287200.    4.07648E-20    2.58041E-16
    287250.    4.04441E-20    2.56011E-16
    287300.    4.01259E-20    2.53997E-16
    287350.    3.98102E-20    2.51999E-16
    287400.    3.94970E-20    2.50016E-16
    287450.    3.91862E-20    2.48049E-16
    287500.    3.88779E-20    2.46097E-16
    287550.    3.85720E-20    2.44161E-16
    287600.    3.82686E-20    2.42240E-16
    287650.    3.79675E-20    2.40334E-16
    287700.    3.76687E-20    2.38443E-16
    287750.    3.73724E-20    2.36567E-16
    287800.    3.70783E-20    2.34706E-16
    287850.    3.67866E-20    2.32859E-16
    287900.    3.64972E-20    2.31027E-16
    287950.    3.62100E-20    2.29209E-16
    288000.    3.59251E-20    2.27406E-16
    288050.    3.56425E-20    2.25617E-16
    288100.    3.53621E-20    2.23842E-16
    288150.    3.50838E-20    2.22081E-16
    288200.    3.48078E-20    2.20333E-16
    288250.    3.45340E-20    2.18600E-16
    288300.    3.42622E-20    2.16880E-16
    288350.    3.39927E-20    2.15174E-16
    288400.    3.37252E-20    2.13481E-16
    288450.    3.34599E-20    2.11801E-16
    288500.    3.31966E-20    2.10135E-16
    288550.    3.29354E-20    2.08481E-16
    288600.    3.26763E-20    2.06841E-16
    288650.    3.24192E-20    2.05214E-16
    288700.    3.21642E-20    2.03599E-16
    288750.    3.19111E-20    2.01997E-16
    288800.    3.16600E-20    2.00408E-16
    288850.    3.14109E-20    1.98831E-16
    288900.    3.11638E-20    1.97267E-16
    288950.    3.09186E-20    1.95715E-16
    289000.    3.06754E-20    1.94175E-16
    289050.    3.04340E-20    1.92647E-16
    289100.    3.01946E-20    1.91132E-16
    289150.    2.99570E-20    1.89628E-16
    289200.    2.97213E-20    1.88136E-16
    289250.    2.94875E-20    1.86656E-16
    289300.    2.92555E-20    1.85187E-16
    289350.    2.90253E-20    1.83730E-16
    289400.    2.87969E-20    1.82284E-16
    289450.    2.85703E-20    1.80850E-16
    289500.    2.83456E-20    1.79427E-16
    289550.    2.81225E-20    1.78016E-16
    289600.    2.79013E-20    1.76615E-16
    289650.    2.76818E-20    1.75226E-16
    289700.    2.74640E-20    1.73847E-16
    289750.    2.72479E-20    1.72479E-16
    289800.    2.70335E-20    1.71122E-16
    289850.    2.68208E-20    1.69776E-16
    289900.    2.66098E-20    1.68440E-16
    289950.    2.64004E-20    1.67115E-16
    290000.    2.61927E-20    1.65800E-16
    290050.    2.59866E-20    1.64495E-16
    290100.    2.57822E-20    1.63201E-16
    290150.    2.55793E-20    1.61917E-16
    290200.    2.53781E-20    1.60643E-16
    290250.    2.51784E-20    1.59379E-16
    290300.    2.49803E-20    1.58125E-16
    290350.    2.47838E-20    1.56881E-16
    290400.    2.45888E-20    1.55647E-16
    290450.    2.43953E-20    1.54422E-16
    290500.    2.42034E-20    1.53207E-16
    290550.    2.40130E-20    1.52002E-16
    290600.    2.38240E-20    1.50806E-16
    290650.    2.36366E-20    1.49620E-16
    290700.    2.34506E-20    1.48442E-16
    290750.    2.32661E-20    1.47275E-16
    290800.    2.30831E-20    1.46116E-16
    290850.    2.29015E-20    1.44966E-16
    290900.    2.27213E-20    1.43826E-16
    290950.    2.25425E-20    1.42694E-16
    291000.    2.23651E-20    1.41571E-16
    291050.    2.21892E-20    1.40458E-16
    291100.    2.20146E-20    1.39352E-16
    291150.    2.18414E-20    1.38256E-16
    291200.    2.16696E-20    1.37168E-16
    291250.    2.14991E-20    1.36089E-16
    291300.    2.13299E-20    1.35018E-16
    291350.    2.11621E-20    1.33956E-16
    291400.    2.09956E-20    1.32902E-16
    291450.    2.08304E-20    1.31856E-16
    291500.    2.06665E-20    1.30819E-16
    291550.    2.05039E-20    1.29790E-16
    291600.    2.03426E-20    1.28769E-16
    291650.    2.01825E-20    1.27756E-16
    291700.    2.00238E-20    1.26750E-16
    291750.    1.98662E-20    1.25753E-16
    291800.    1.97099E-20    1.24764E-16
    291850.    1.95548E-20    1.23782E-16
    291900.    1.94010E-20    1.22808E-16
    291950.    1.92483E-20    1.21842E-16
    292000.    1.90969E-20    1.20883E-16
    292050.    1.89466E-20    1.19932E-16
    292100.    1.87976E-20    1.18989E-16
    292150.    1.86497E-20    1.18052E-16
    292200.    1.85030E-20    1.17124E-16
    292250.    1.83574E-20    1.16202E-16
    292300.    1.82129E-20    1.15288E-16
    292350.    1.80696E-20    1.14381E-16
    292400.    1.79275E-20    1.13481E-16
    292450.    1.77864E-20    1.12588E-16
    292500.    1.76465E-20    1.11702E-16
    292550.    1.75077E-20    1.10823E-16
    292600.    1.73699E-20    1.09951E-16
    292650.    1.72332E-20    1.09086E-16
    292700.    1.70977E-20    1.08228E-16
    292750.    1.69631E-20    1.07377E-16
    292800.    1.68297E-20    1.06532E-16
    292850.    1.66973E-20    1.05694E-16
    292900.    1.65659E-20    1.04862E-16
    292950.    1.64356E-20    1.04037E-16
    293000.    1.63062E-20    1.03219E-16
    293050.    1.61779E-20    1.02406E-16
    293100.    1.60507E-20    1.01601E-16
    293150.    1.59244E-20    1.00801E-16
    293200.    1.57991E-20    1.00008E-16
    293250.    1.56748E-20    9.92214E-17
    293300.    1.55515E-20    9.84407E-17
    293350.    1.54291E-20    9.76662E-17
    293400.    1.53077E-20    9.68978E-17
    293450.    1.51873E-20    9.61354E-17
    293500.    1.50678E-20    9.53791E-17
    293550.    1.49492E-20    9.46287E-17
    293600.    1.48316E-20    9.38841E-17
    293650.    1.47149E-20    9.31455E-17
    293700.    1.45992E-20    9.24126E-17
    293750.    1.44843E-20    9.16855E-17
    293800.    1.43703E-20    9.09642E-17
    293850.    1.42573E-20    9.02485E-17
    293900.    1.41451E-20    8.95384E-17
    293950.    1.40338E-20    8.88340E-17
    294000.    1.39234E-20    8.81350E-17
    294050.    1.38138E-20    8.74416E-17
    294100.    1.37052E-20    8.67537E-17
    294150.    1.35973E-20    8.60711E-17
    294200.    1.34903E-20    8.53939E-17
    294250.    1.33842E-20    8.47220E-17
    294300.    1.32789E-20    8.40555E-17
    294350.    1.31744E-20    8.33941E-17
    294400.    1.30708E-20    8.27380E-17
    294450.    1.29679E-20    8.20870E-17
    294500.    1.28659E-20    8.14412E-17
    294550.    1.27647E-20    8.08004E-17
    294600.    1.26643E-20    8.01647E-17
    294650.    1.25646E-20    7.95340E-17
    294700.    1.24658E-20    7.89082E-17
    294750.    1.23677E-20    7.82874E-17
    294800.    1.22704E-20    7.76715E-17
    294850.    1.21738E-20    7.70604E-17
    294900.    1.20781E-20    7.64541E-17
    294950.    1.19830E-20    7.58525E-17
    295000.    1.18887E-20    7.52558E-17
    295050.    1.17952E-20    7.46637E-17
    295100.    1.17024E-20    7.40762E-17
    295150.    1.16103E-20    7.34934E-17
    295200.    1.15190E-20    7.29152E-17
    295250.    1.14284E-20    7.23415E-17
    295300.    1.13384E-20    7.17723E-17
    295350.    1.12492E-20    7.12076E-17
    295400.    1.11607E-20    7.06474E-17
    295450.    1.10729E-20    7.00916E-17
    295500.    1.09858E-20    6.95401E-17
    295550.    1.08994E-20    6.89930E-17
    295600.    1.08136E-20    6.84501E-17
    295650.    1.07285E-20    6.79116E-17
    295700.    1.06441E-20    6.73773E-17
    295750.    1.05604E-20    6.68472E-17
    295800.    1.04773E-20    6.63212E-17
    295850.    1.03949E-20    6.57994E-17
    295900.    1.03131E-20    6.52817E-17
    295950.    1.02319E-20    6.47681E-17
    296000.    1.01514E-20    6.42585E-17
    296050.    1.00716E-20    6.37530E-17
    296100.    9.99232E-21    6.32514E-17
    296150.    9.91370E-21    6.27537E-17
    296200.    9.83570E-21    6.22600E-17
    296250.    9.75832E-21    6.17701E-17
    296300.    9.68154E-21    6.12841E-17
    296350.    9.60537E-21    6.08020E-17
    296400.    9.52979E-21    6.03236E-17
    296450.    9.45482E-21    5.98490E-17
    296500.    9.38043E-21    5.93781E-17
    296550.    9.30662E-21    5.89109E-17
    296600.    9.23340E-21    5.84474E-17
    296650.    9.16076E-21    5.79876E-17
    296700.    9.08868E-21    5.75314E-17
    296750.    9.01717E-21    5.70787E-17
    296800.    8.94623E-21    5.66296E-17
    296850.    8.87584E-21    5.61841E-17
    296900.    8.80601E-21    5.57420E-17
    296950.    8.73672E-21    5.53035E-17
    297000.    8.66799E-21    5.48683E-17
    297050.    8.59979E-21    5.44367E-17
    297100.    8.53213E-21    5.40084E-17
    297150.    8.46500E-21    5.35834E-17
    297200.    8.39840E-21    5.31619E-17
    297250.    8.33232E-21    5.27436E-17
    297300.    8.26676E-21    5.23286E-17
    297350.    8.20172E-21    5.19169E-17
    297400.    8.13719E-21    5.15084E-17
    297450.    8.07317E-21    5.11032E-17
    297500.    8.00965E-21    5.07011E-17
    297550.    7.94664E-21    5.03022E-17
    297600.    7.88411E-21    4.99064E-17
    297650.    7.82208E-21    4.95138E-17
    297700.    7.76054E-21    4.91242E-17
    297750.    7.69948E-21    4.87377E-17
    297800.    7.63890E-21    4.83543E-17
    297850.    7.57880E-21    4.79738E-17
    297900.    7.51917E-21    4.75964E-17
    297950.    7.46001E-21    4.72219E-17
    298000.    7.40132E-21    4.68504E-17
    298050.    7.34309E-21    4.64818E-17
    298100.    7.28532E-21    4.61160E-17
    298150.    7.22800E-21    4.57532E-17
    298200.    7.17113E-21    4.53932E-17
    298250.    7.11471E-21    4.50361E-17
    298300.    7.05873E-21    4.46818E-17
    298350.    7.00319E-21    4.43302E-17
    298400.    6.94809E-21    4.39814E-17
    298450.    6.89343E-21    4.36354E-17
    298500.    6.83919E-21    4.32921E-17
    298550.    6.78538E-21    4.29515E-17
    298600.    6.73200E-21    4.26135E-17
    298650.    6.67903E-21    4.22783E-17
    298700.    6.62648E-21    4.19456E-17
    298750.    6.57435E-21    4.16156E-17
    298800.    6.52262E-21    4.12882E-17
    298850.    6.47130E-21    4.09633E-17
    298900.    6.42039E-21    4.06411E-17
    298950.    6.36987E-21    4.03213E-17
    299000.    6.31976E-21    4.00041E-17
    299050.    6.27003E-21    3.96893E-17
    299100.    6.22070E-21    3.93770E-17
    299150.    6.17176E-21    3.90672E-17
    299200.    6.12320E-21    3.87599E-17
    299250.    6.07503E-21    3.84549E-17
    299300.    6.02723E-21    3.81524E-17
    299350.    5.97981E-21    3.78522E-17
    299400.    5.93276E-21    3.75544E-17
    299450.    5.88608E-21    3.72589E-17
    299500.    5.83977E-21    3.69658E-17
    299550.    5.79383E-21    3.66749E-17
    299600.    5.74824E-21    3.63864E-17
    299650.    5.70302E-21    3.61001E-17
    299700.    5.65815E-21    3.58161E-17
    299750.    5.61363E-21    3.55343E-17
    299800.    5.56946E-21    3.52547E-17
    299850.    5.52564E-21    3.49773E-17
    299900.    5.48217E-21    3.47021E-17
    299950.    5.43903E-21    3.44291E-17
    300000.    5.39624E-21    3.41582E-17
