c    ******************************************************************
c    *                                                                *
c    *   csigmaDecay: sigma +0- and their antiptcl
c    *                                                                *
c    ******************************************************************
c
       subroutine csigmaDecay(pj,  a,  np)
       implicit none
#include  "Zptcl.h"
#include  "Zcode.h"

       integer np               !output. no. of ptcls produced
       record /ptcl/ pj         ! input. kaon
       record /ptcl/ a(*)      ! output. produced ptcls
c
c
      if(pj.charge .eq. 1) then
c           Sigma +
         call csigmaPDcy(pj, a, np)
      elseif(pj.charge .eq. 0) then
c           sigma 0
         call csigma0Dcy(pj, a, np)
      elseif(pj.charge .eq. -1) then
c           sigma -1         
         call csigmaMDcy(pj, a, np)
      endif
      end
      subroutine csigmaPDcy(pj,  a, np)
c
c         sigma+ decay
c         1) Sigma---->p pi0      (51.6%0
c         2)      ---->n pi+       48.4 
      implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
      integer np
      record /ptcl/ pj
      record /ptcl/ a(*)
      integer subcode, charge

      real*8 u
      call rndc(u)
      subcode = pj.subcode
      charge = -pj.subcode
      if(u  .lt. .516) then
c          p+pi0  or conjugae       
         call cmkptc(kpion, 0, 0, a(1))
         call cmkptc(knuc, subcode, charge, a(2))
         call c2bdcy(pj, a(1), a(2))
         np=2
      else
c          n pi+
         call cmkptc(kpion, regptcl, -charge, a(1))
         call cmkptc(knuc,  subcode,  0, a(2))
         call c2bdcy(pj, a(1), a(2))
         np=2
      endif
      end
      subroutine csigma0Dcy(pj, a, np)
c
c         sigma0 decay
c         1) Sigma---->Lamda gamma  100 %
      implicit none
#include  "Zptcl.h"
#include  "Zcode.h"
      integer np
      record /ptcl/ pj
      record /ptcl/ a(*)
      integer subcode

      subcode = pj.subcode
      call cmkptc(klambda, subcode, 0, a(1) )
      call cmkptc(kphoton, 0, 0, a(2) )
      call c2bdcy(pj, a(1), a(2))
      np=2
      end
      subroutine csigmaMDcy(pj,  a, np)
c
c         sigma- decay
c         1) Sigma---->n pi-   100 %
      implicit none
#include  "Zptcl.h"
#include  "Zcode.h"      
      integer np
      record /ptcl/ pj
      record /ptcl/ a(*)
      integer subcode, charge

      subcode = pj.subcode
      charge = pj.subcode
      
c          n+pi-
         call cmkptc(kpion, 0, charge, a(1))
         call cmkptc(knuc, subcode, 0 , a(2))
         call c2bdcy(pj, a(1), a(2))
         np=2
      end
