cc
cc      Takahashi-Mori's double exponential integration quadrature
cc
c      implicit none
c      real*8 func,  eps, ans, error, a, b, func2
c
c      integer icon
c      external func, func2
c
c      eps = 1.d-9
cc      a = -1.d0
cc      b = 1.d0
cc      call kdexpIntF(func, a, b, eps, ans, error, icon)
c      a =0.
c      b = 1.d0
c      call kdexpIntF(func2, a, b, eps, ans, error, icon)
c      write(*,*) icon, ans, error
c      end
cc     ******************
c      real*8 function func2(x)
c      implicit none
c      real*8 x(2), xx2
c      xx2= x(2)
cc         func2 = 1/x**0.75 from 0 to 1      
cc      this may seem useless, but if you use only x(1),
cc      there will be  arithmetic exception
cc
c      if(xx2 .lt. 0.) then
cc              x = 0 - x(2)  so x=-x(2) 
c         func2 = 1./(-x(2))**0.75d0
c      else
cc              x = 1-x(2);
c        func2 = 1./x(1)**0.75d0
c      endif
c      end
cc                       
cc     *******************      
c      real*8 function func(x)
c      implicit none
c      real*8  x(2), xx2
c      xx2 =  x(2)  
cc       
cc       func = 1/sqrt( (1-x)(1+x) )
cc
c      if(xx2 .lt. 0.) then
cc                x =   -1-x(2); so 1 + x = -x(2), 1-x = 2+x(2)
c         func = 1./sqrt( -(2+xx2) * xx2)
c      else
cc                x =  1-x(2); so 1+x =2-x(2); 1-x = x(2)
c         func = 1./sqrt(xx2*(2-xx2))
c      endif
c      end
c     *******************************************************
      subroutine kdexpIntF(func, a, b, eps, ans, error, icon)
c     *******************************************************
      implicit none
c
c          Numerical integration in a finite range by Takahashi-Mori's
c       double exponential integraton method.
c       The method gives accurate result even if there are singularities
c       at the integration limits. If there is a very sharp peak in the
c       midst of the integration region, the method will not give
c       a good result. 
c       
c
      real*8 func ! input. integrand function name with 1 argument
                  !          you have to declare 'external' 
                  !  Argument is real*8 xx(2).
                  !  xx(1) is x, 
                  !  Let aa=min(a, b), bb=max(a,b)
                  !  xx(2) = aa - x   if aa<= x < (aa+bb)/2
                  !        = bb - x   if bb> x >= (aa+bb)/2
                  !  So you should use xx(2) if at aa and/or bb
                  !  func is  singular; 
                  !       x(2) < 0 ==>  f(aa-x(2))
                  !       x(2) >=0 ==>  f(bb-x(2))
                   
      real*8 a   ! input. lower limit of the integration region
      real*8 b   ! input. upper //
                 !        b may be <=a.
      real*8 eps ! input. relative or absolute error of the
                 !        intetegration  you want to get.
                 !        if |ans| is > 1, used for relative error
                 !        else used for absolute error.
                 !        eps ~> 1.d-9  may be a good choice.
      real*8 ans ! output. approximate integration value.
      real*8 error ! output. estimated error (relative or absolute)
                   !         depending on |ans|.
      integer icon ! output. 0 --> ans is reliable.
                   !         1 --> ans may have a larger error than
                   !               your request.
                   !         2 --> input error so that ans is undef.
c
c
c

      integer halveNtime  ! if the integration accuracy is not enough
                          ! halve the equi-step of trapezoidal rule.
                          ! halving is tried upto halveNtime times.
      integer pointsInUnit !  see graph below
      integer blocks       ! we take 10 blocks
      integer totalpoints  ! (max number of  points)-1  where function 
                           ! is evaluated.
c      
c       integration bin; unit is
c  
c     1 2 3 ..  2**halveNtime = pointsInUnit    
c     | | | ... |
c      blocks of units are max number of points where the function is
c      evaluated.
c    
c   0 1 2 3 ..  pointsInUnit (note 0 at the top)
c   | | | | ... | | ..... | | | |    ..       | | |         | | | | ...| 
c                 1 2.... pointsInUnit   
c                                              
c
c          1           2            3                         bloks units
c
c    for the first integration use points marked O as below (bloks points)
c   O           O               O                                     O       c     
c    That is, if pointsInUnit = 32, in each block O is used
c    
c                                                                 
c 0  1 2                              16                               32
c |  | | | | | | | | | | | | |...        | | | | | | ...     | | | | | |
c O                                                                    O
c    halving this
c                                                              
c 0  1 2                              16                              32
c |  | | | | | | | | | | | | | | | | | | | ...     | | | | | | | | | | |
c O                                    x                               O
c    halving this
c
c
c 0  1 2 3 4 5 6 7 8 9 10  12 13  14  16  18  20  22  24  26  28  30  32
c |  | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | |
c O                +                   x               +               O
c    halving this
c
c 0 1 2 3 4 5 6 7 8 9 10  12  14  16  18  20  22  24  26  28  30  32
c | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | 
c O       #       +       #       x       #       +       #       O
c
c    halving this
c 0 1 2 3 4 5 6 7 8 9 10  12  14  16  18  20  22  24  26  28  30  32
c | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | 
c O   $   #   $   +   $   #   $   x   $   #   $   +   $   #   $   O
c
c    halving this is the final step
c
      parameter (halveNtime = 5, pointsInUnit = 32)
c                                  must be 2**halveNtime
      parameter ( blocks = 10, 
     *            totalpoints = blocks * pointsInUnit + 1 )
c 
c  mapping: y(0), y(1), y(32), y(33),  ... corresponds to  the
c  above  nodal points. y(0) is very close to -1 and y(totalpoints)
c  is very close to 1. (actually, they are -1, and 1 due to 
c  finite accuracy of  double precision. so 1+y and 1-y is 
c  tabulated specially.
c 

      real*8 y(0:totalpoints),  w(0:totalpoints)
      real*8 opy(0:totalpoints),omy(0:totalpoints)
      real*8 f(0:totalpoints)
      real*8 machmin, machmax  ! machine min, and max values
      real*8 halfpi
      real*8 tmax  ! max |t| where transformation 
                   ! y = tanh(pi/2 *sinh(t)) has no over/under flow.
                   !  |y| < 1
      real*8 h     ! minimum step of trapezoidal rule.
      real*8 t, c1, ans1, ans2, step,  f2, ytox, ytoxn, ytoxp
      real*8 temp, xa(2), expm, expp
      integer i, j, jstep, k

      logical first /.true./

      save first, y, w,  halfpi, tmax, h, opy, omy, temp

      ytox(k) = c1*(y(k) + 1) + a
      ytoxn(k) = -c1*opy(k)      ! -c1(1+y)
      ytoxp(k) =  c1*omy(k)      !  c1(1-y)

      if( first ) then
c              approx  machine min, max
         call kdmachmnmx(machmin, machmax)
         halfpi = asin(1.d0)  ! pi/2

c         tmax = log(log(machmax/1.d5)/halfpi )  
c            
c          The next choice is rather from trial and error
c                      log(log(1.d-75 ~ 1.d150).. ) is o.k
c         
            tmax = log(log(sqrt(machmin)/2)/(-2))

         h = 2*tmax/totalpoints   ! width of (-tmax, tmax)  is devided
                                  !  by totalpoints
c
c          compute nodal points and weight there.
c
         do  i = 0, totalpoints
            t = -tmax + i * h
            temp = halfpi * sinh(t)
            expm = exp(-temp)
            expp = exp( temp)

            y(i) = tanh( temp )

            opy(i) = 2*expp/(expp + expm) !   1+y
            omy(i) = 2*expm/(expp + expm) !   1-y
 
            w(i) = cosh(t) / cosh( halfpi*sinh(t) )**2
            
         enddo
         first = .false.
      endif

      if(a .eq. b) then
         ans = 0.d0
         icon = 0.
      else
         c1 = (b-a)/2.0d0
         ans1 = 0.

         jstep  =  pointsInUnit
         do i = 1, halveNtime
            step = jstep*h             
            ans2 = 0.
            do j = 0, totalpoints, jstep
               if( i.gt. 1 .and.
     *            mod( mod(j, pointsInUnit), jstep*2) .eq. 0) then
                  f2 = f(j)
               else
                  xa(1) = ytox(j)
                  if(y(j) .lt. 0. ) then
                     xa(2) = ytoxn(j)
                  else
                     xa(2) = ytoxp(j)
                  endif
                  f2 = func( xa ) * w(j)
                  f(j) = f2
               endif
               ans2 = ans2 + f2
            enddo
            ans2 = ans2 * step 
            if(i .gt. 1) then
               if(abs(ans2) .gt. 1.d0) then
                  error =abs( abs(ans1/ans2)-1.d0 )
                  if(error .le. eps) then
                     icon = 0 
                     goto 1000
                  endif
               else
                  error =  abs(ans2-ans1)
                  if(error .le. eps) then
                     icon = 0
                     goto 1000
                  endif
               endif
            endif
            ans1 = ans2
            jstep = jstep/2
         enddo
         icon = 1
 1000    continue
         ans = ans2 * halfpi *c1
      endif
      end
