      subroutine cGetXXsec(Ex, xcomtab, n, m, xsec, icon)
      implicit none
c        give X-ray xsection;  1) coherent scatt
c                              2) incoherent (compton) scatt.
c                              3) photo-absorption,
c                              4)  pair prod.by nucl
c                              5)  pair prod. by atomic elec.
c                              6)  attn coef. with coh.
c                              7)  attn coef. without coh.
      real*4  Ex  ! input.  X-ray energy in GeV. 1keV to 100GeV.  if < 1 keV, extrapolation
                   ! will be done
      integer   n    ! input. row size of xcomtab. the column is 8
      real*4  xcomtab(8, n)  ! input.  x-section table obtained by using 
                     ! CreateTab   and stored as bgo.xcom etc.
                     ! for Cosmos, the table may be stored as data.
                     ! values are in log. (original 0 --> -100) of the
                     ! following  values
                     ! (1,n)=E(GeV), (2,n)=coh. (3,n)=incoh. (4,n)=p.e.
                     ! (5,n)=n.pair (6,n)=e.pair, (7,n)=atten(with coh)
                     ! (8,n)=atten.(without  coh)
      integer   m    ! input. first m xsections are obtained in xsec. in
                     !        unit of 1/(g/cm^2)
      real*4   xsec(8)  ! output.  at least size m.  xsec(k)  is k-th xsection.
      integer icon   ! output.  0--> ok.  1-->Ex<1keV. extrapolation not guaranteed
                     !          2--> Ex>100 GeV.  values at 100 GeV is given
      real*4   Exl
      real*4   dx, grad
      integer i, loc

      Exl = log(Ex)
      if( Exl .lt. xcomtab(1, 1)  ) then
         do i = 1, m
            xsec(i) = xcomtab(i+1, 1)
         enddo
         loc = 1
      elseif(EXl .gt. xcomtab(1,n) ) then
         do i = 1, m
            xsec(i) = xcomtab(i+1, n)
         enddo
         loc = n
      else
c          find i(=loc) such that   Ei <= Eg < Ei+1  ( i=1, 2, ...n-1)
         call kwhereis(Exl, n, xcomtab, 8, loc)
c           if Ex=100, loc = n
         if( loc .lt. n ) then
            if( xcomtab(1, loc) .eq.  xcomtab(1, loc+1) ) then
               loc = loc + 1
            endif
         endif
      endif
      if(loc .lt. n) then
         dx = xcomtab(1, loc+1)- xcomtab(1, loc) 
         if(dx .eq. 0.) then
            do i = 1, m
               xsec(i) = xcomtab(i+1, loc)
            enddo
         else
            do i = 1, m
               grad =(xcomtab(i+1, loc+1)-xcomtab(i+1, loc))/dx 
               if(i .eq. 4 .or. i .eq. 5) then
                  if(xcomtab(i+1, loc+1) .eq. -100.) then
                     xsec(i)= -100.
                  else
                     xsec(i) = grad* (Exl- xcomtab(1, loc)) 
     *                    + xcomtab(i+1, loc)
                  endif
               else
                  xsec(i) =  grad * (Exl- xcomtab(1, loc)) 
     *                 + xcomtab(i+1, loc)
               endif
            enddo
         endif
      else
         do i = 1, m
            xsec(i) = xcomtab(i+1, n)
         enddo
      endif
      do i = 1, m
         if(xsec(i) .eq. -100) then
            xsec(i)  = 0.
         else
            xsec(i) = exp(xsec(i))
         endif
      enddo
      end
