      subroutine cxppipe( x0, y0, z0, wx, wy, wz, r1, r2, h, el, icon)
      implicit none
c       get a x-point of a line with a pipe.  The given point is assumed 
c       to be inside the pipe (including on the boundary).
c       If it is not in the pipe, icon =-1 results.
c
      real*8  x0, y0, z0  ! input. given line starts from  this point
      real*8  wx, wy, wz  ! input. line's direction cosine.
      real*8  r1, r2      ! input. inner and outer radius of the pipe.
      real*8  h           ! input. heigh of the pipe.
                          ! pipe bottom ceneter is at (0,0,0)
                          ! pipe top center is at (0,0,h)
      real*8  el          ! output. obtained x-ing point is el*(wx,wy,wz)
                          !   el>0. 
                          !  if icon = -1, undef.
      integer icon        ! output. 0 --> x-ing point is on the inner wall
                          !         1 --> //                    outer wall
                          !         2 --> //             on the bottom
                          !         3 --> //             on the top
                          !        -1 --> no x-ing point. 
                          ! If wx=wy=0 and x0,y0,z0 is on the boundary,
                          !       icon = 2 or icon = 3 will result
                          !
                          ! If wz=0  and  x0,y0,z0 is on the boundary,
                          !  icon = 0 or 1 will result
c ----------
      real*8  rs2
      integer icon1, icon2

      
      rs2 = x0**2 + y0**2 
      icon = -1
      if(rs2 .gt. r2**2)  return
      if(rs2 .lt. r1**2)  return
      if(z0 .gt. h)  return
      if(z0  .lt. 0.0) return
c
c        x-point with inner cylinder
      call kxplcy(x0, y0, z0, wx, wy, wz, r1, h, el, icon1, icon2)
c     el: x-ssing point is at (x0,y0,z0)+el*(l,m,n)  el>=0
c         only x-ssing point with el>=0 is obtained.
c         if there is two el>=0 xssing points, nearer one is
c         taken.
c   icon1 : output. 0 the point is in the cyl. el is obtained
c                  1 the point is out side of the cyl
c                    el obtained.
c                 -1 no x-ing point
c   icon2: output. 1  x-ing point is on x-y  top plane.
c                  2  //             on the side.
c                  6  //             on      bottom.
c                 -1  no x-ing point
c
      if(icon1 .eq.  1)  then
         if(icon2 .eq. 2) then 
            icon = 0
         elseif(icon2 .eq. 1) then
            icon = 3
         elseif(icon2 .eq. 6) then
            icon = 2
         endif
      else
c          x-point with outer cylinder
         call kxplcy(x0, y0, z0, wx, wy, wz, r2, h, el, icon1, icon2)
         if(icon1 .eq. 0) then
            if(icon2 .eq. 1) then
               icon = 3
            elseif(icon2 .eq. 2) then
               icon = 1
            elseif(icon2 .eq. 6) then
               icon = 2
            endif
         endif
      endif
      end
