c      implicit none
c     
c      real*8 a, xsxp, xsxa
c      integer ia, is
c
c      do  ia=4,99, 4
c         a=ia
c         do    is=1, 40
c             xsxp=1.d-1*10.**( (is-1)/10.)
c             call cxp2xAXsec(a, xsxp, xsxa)
c             write(*, *) sngl(xsxp), sngl(xsxa)
c         enddo
c         write(*,*)
c      enddo 
c      do  ia=100, 210, 10
c         a=ia
c         do    is=1, 40
c             xsxp=1.d-1*10.**( (is-1)/10.)
c             call cxp2xAXsec(a, xsxp, xsxa)
c             write(*, *) sngl(xsxp), sngl(xsxa)
c         enddo
c         write(*,*)
c      enddo 
c      end
c
c ****************************** cp_p2p_Axs  updated Feb. 3 2001
c                  (better approximation)
c          convert xp inelastic x-section into x-A inelastic xs.
        subroutine cxp2xAXsec(a, xsxp, xsxa)
c
c    a: real*8. input.  Mass # of the target
c   xsxp: real*8. input.  x-section of xp   (mb)
c   xsxa: real*8. output. x-section of xA   (mb)
c
        implicit none
        real*8  a, xsxp, xsxa
        real ca, cb, cc
        if(xsxp .lt. 15.) then
           ca = .93812*a**1.0215
           cb = .65000E-02* a**0.5 + (((-.37436E-10* a +.18937E-07)*a 
     *      -.33424E-05)* a + .21646E-03)*a -.31385E-02
           xsxa =  ca* xsxp/(1.0 + cb* xsxp)
        elseif(xsxp .lt. 35.) then
           cb = (0.17859E-05*a-.48592)*a +  .66909E-02  +
     *     0.48968 * a**0.99875       
           ca = (0.67395E-03*a +   .93859 )*a + .26890  +
     *       .34987E-01 * a**1.4525   
           cc = 0.925
           xsxa =  ca* xsxp/(1.0 + cb* xsxp**cc)
        else
           ca = 80.000 * a**0.17829  + (((-.52469E-07*a +.30395E-04)*a
     *         -.69823E-02)*a +1.0517)*a +16.427
           if(a .lt. 20.) then
              cb  = 90.029* a**(-1.0219) + (.94351E-02*a -.45131)*a+6.4772
           else
              cb = 130.79*a**(-1.0) + (-.89803E-05*a +.52418E-02)*a -1.2073
           endif
           xsxa =  ca* log(1.0 + xsxp/cb)
        endif
        xsxa = max(xsxa, xsxp) 
        end
