#include "../../cmain.f"
#include "../chookHybAS.f"
#include "../../ctemplCeren.f"
c
c  *************************************** hook for Beginning of a Run
c  * At this moment, all (system-level) initialization for this run
c  * has been ended.  After this routine is executed, the system goes into the
c  * event creation loop.
c  *
      subroutine chookBgRun
      implicit none
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "../../SkelFlesh/Zprivate.h"

      real*8  temp
      character*128 msg
      character*128 input
      character*64  execid
      character*5 numb
      integer icon
      integer i, leng, lengn, lengid
      integer klena, kgetenv2
c     ==================================================
      
      integer seed(2)
c     ==================================================

      EventNo = 0

c            namelist output
      call cwriteParam(ErrorOut, 0)
c            primary information
      call cprintPrim(ErrorOut)
c            observation level information
      call cprintObs(ErrorOut)

      call cqUHooki(1, Mdev)      ! get skeleton memo dev #
c      call cqUHooki(6, HowFlesh)  ! how to flesh. non zero-->orthodox


      call cqUHookc(1, msg)       ! get file name for sekelton data
      call cgetfname(msg, Mskel)  ! add host name etc if needed
      call copenfw2(Mdev, Mskel, 2, icon)
      if(icon .ne. 1) then
         call cerrorMsg(Mskel,1)
         call cerrorMsg(' could not be opened',0)
      endif
      if(ObserveAS) then
         input = ' '
         lengn =  kgetenv2("NUMB", numb)
         leng =  kgetenv2("OUTDIR", input)
         lengid = kgetenv2("EXECID", execid)
         msg =input(1:leng)//
     *   "/"//execid(1:lengid)//"-@."//numb(1:lengn)//".hyb"
         call copenfw2(fnoB, msg, 1, icon)
         if(icon .gt. 1) then
            write(0,*) ' icon=', icon
            call cerrorMsg(msg, 1)
            call cerrorMsg('could not be opened', 0)
         endif
      endif

      end

c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      subroutine chookBgEvent
      implicit none
#include "../../SkelFlesh/Zprivate.h"


      integer nomore
      call cbegin1ev( nomore )
      if( nomore .eq. 1) then
         call cerrorMsg('all events have been fleshed', 1)
         stop                   !!!!!!!!!!!!  
      endif
      call cpushInci


      end
      subroutine cbegin1ev(nomore)
      implicit none
#include "../../SkelFlesh/Zprivate.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Ztrackp.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "Zcode.h"
#include "Zmanager.h"
#include "Zmanagerp.h"
      
      integer nomore       !  output. 0 still there  are showers
                           !          1 no more skeleton showers to be fleshed
c          event number, primary      

      record /track/ incident, zsave
      record /coord/ angle
      
      integer i
      integer seed(2)
      integer cumnum, num, jeof, fin
      read( Mdev, end=1000 ) cumnum, num, SeedSave, Zfirst

      EventsInTheRun = EventsInTheRun + 1
      EventNo = EventNo + 1
c                 reset the seed.
      call rnd1r(SeedSave)
c         next incident; confirmed to be the same one as preserved one
      call cmkIncident(incident, fin)
      if(fin .ne. 0 ) goto 1000
      zsave = Zfirst    ! save;  this is reset in next 
      call ciniTracking( incident )   
c          set first interaction pos
      Zfirst = zsave
      call cresetTimer(Zfirst)



c          do your own init for a one event here
c      ==========================================================


c      ==========================================================
c

      call cgetHES(Mdev)  ! get high energy ptlcs
      call cobsHES        ! imitate their observation
      nomore = 0
      return

 1000 continue
      nomore = 1
      end

c     ************************************ hook for observation
c     *  One particel information is brought here by the system.
c     *  All information of the particle is in aTrack
c     *
      subroutine chookObs(aTrack, id)
c
c     Note that every real variable is in double  precision so
c     that you may output it in sigle precision to save the memory.
c     In some cases it is essential to put it in sigle (say,
c     for gnuplot).
c 
      implicit none
#include "Zcode.h"
#include "Ztrack.h"
#include "Zobs.h"
#include "../../SkelFlesh/Zprivate.h"
#include "Zprivate.h"
      integer id  ! input.  2 ==> reached at an observation level
c                           1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack
c  -------------
      real*8  r,  fai
c  -------------
      
c
c     For id =2, you need not output the z value, because it is always
c     0 (within the computational accuracy).
c
      if(id .eq. 2 .and. aTrack.p.code .ne. kneumu .and.
     *   aTrack.p.code .ne. kneue  .and. aTrack.where .eq. 6 ) then

c     ===================================================
c--------------
         fai = atan2(aTrack.pos.xyz.r(2), aTrack.pos.xyz.r(1))
     *    *  57.2957795130823208d0
c         if( abs(fai) .lt. 0.5d0 .or. 
c     *       abs(180.d0-abs(fai)) .lt. 0.5d0) then
            r = sqrt( aTrack.pos.xyz.r(1)**2 +
     *                aTrack.pos.xyz.r(2)**2)
            write(*, '( 4i3, 1pE11.3, 0p2f11.2, 3f9.4,
     *        f10.2,  f9.3, 1pE11.1)')   
c    *           aTrack.where,   
     *       aTrack.p.code,   
     *       aTrack.p.subcode, 
     *       aTrack.p.charge,  
     *       aTrack.p.fm.p(4) - aTrack.p.mass,
     *       aTrack.pos.xyz.r(1),
     *       aTrack.pos.xyz.r(2), 
     *       aTrack.vec.w.r(1),
     *       aTrack.vec.w.r(2),
     *       aTrack.vec.w.r(3), 
     *       r, fai, aTrack.t
c         endif
c     *       aTrack.vec.coszenith
c
      endif
      if(aTrack.p.code .eq. kphoton) then
         Ng(aTrack.where) =   Ng(aTrack.where) + aTrack.wgt
      elseif(aTrack.p.code .eq. kelec) then
         Ne(aTrack.where) =   Ne(aTrack.where) + aTrack.wgt
      elseif(aTrack.p.code .eq. kmuon) then
         Nmu(aTrack.where) =   Nmu(aTrack.where) + aTrack.wgt
      endif
c     ===================================================



      end

c    *********************************** hook for end of 1 event
c    * At this moment, 1 event generation has been ended.
c    *
      subroutine chookEnEvent

      implicit none

#include "../../SkelFlesh/Zprivate.h"
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
#include "Zprivate.h"

      integer i
      real*8 cog, sumne


c       for Job ='newflesh', we must call cfinTracking ourselves.
      call cfinTracking
c           end of 1 event; if you need to do some here is
c           the place
c         ========================================================

      if(ObserveAS) then
         cog = 0.
         sumne = 0.
         do i = 1, NoOfASSites
            cog = cog + ASObsSites(i).esize*ASDepthList(i)*0.1
            sumne= sumne +ASObsSites(i).esize
         enddo
         cog = cog/sumne
         
         do i = 1, NoOfASSites
            if(fnoB .ge. 0) then
               write(fnoB, '( i4, i3, i5,
     *          1pE11.3, 0pf5.2, f5.2,  f7.1, 1p3E11.3,
     *          0pf7.0)')
     *          EventNo, i,
     *          int( ASDepthList(i)*0.1 ),
     *          ASObsSites(i).esize, ASObsSites(i).age,
     *          ASDepthList(i)*0.1/cog, 
     *          sngl(ASObsSites(i).mu), Ng(i), Ne(i), Nmu(i), cog
            else
               write(*, '( i4, i3, i5,
     *          1pE11.3, 0pf5.2, f5.2,  f7.1, 1p3E11.3,
     *          0pf7.0)')
     *          EventNo, i,
     *          int( ASDepthList(i)*0.1 ),
     *          sngl(ASObsSites(i).esize), sngl(ASObsSites(i).age),
     *          ASDepthList(i)*0.1/cog, 
     *          sngl(ASObsSites(i).mu), Ng(i), Ne(i), Nmu(i), cog
            endif
         enddo
      endif
c        ========================================================
      call cerrorMsg('end of event', 1)
      end


c     ********************************* hook for end of a run
c     *  all events have been created or time lacks
c     *
      subroutine chookEnRun
      implicit none
#include "../../SkelFlesh/Zprivate.h"
c     =========================================================

c     =========================================================
      call  cprintStatus   ! if don't like,  comment out

      write(fnoB,*) " "
      close(fnoB)





      end
c     ********************************* hook for trace
c     *  This is called only when trace > 100
c     *  User should manage the trace information here.
c     *  If you use this, you may need some output for trace
c     *  at the beginning of 1 event generatio and at the end of  1 event
c     *  generation so that you can identfy each event.
c     *
c     *
      subroutine chookTrace
            implicit none

#include  "Ztrack.h"
#include  "Ztrackv.h"
#include  "Ztrackp.h"
#include  "Zobs.h"
#include  "Zobsv.h"

       real*4 h1,  h2
c
c    Every time a particle is moved in the atmosphere, this routine is called,
c    if trace > 100
c         For a one track segment,
c     TrackBefMove  has  track information at the beginning of the segment.
c     MoveTrack    has   track information at the end of the segment.
c   
c     You can know the  information a track contains in the 
c     chookObs routine. (Note however, no conversion of coordinate
c     has been done.  The values are in the Earth xyz system.)
c     Besides quantities explained there, you can use, for a  given 'track'
c
c     atrack.pos.xyz.x, atrack.pos.xyz.y, atrack.pos.xyz.z    (x,y.z)
c     atrack.pos.radiallen   (distance from the center of the earth)
c     atrack.pos.depth       (vertical depth)
c     atrack.pos.height      (vertical heigth from sea level)  
c

      h1 = TrackBefMove.pos.height- ObsSites(NoOfSites).pos.height
      h2 = MovedTrack.pos.height - ObsSites(NoOfSites).pos.height

      end
c     ********************* this is the hook called when
c       an electron made an interaction.
c
      subroutine chookEInt(never)
      implicit none
      integer never             ! input & output
      never = 1
      end

c     ********************* this is the hook called when
c       a gamma ray made an interaction.
c
      subroutine chookGInt(never)
      implicit none
      integer never   ! input & output
      never = 1
      end

c     ********************* this is the hook called when
c       non e-g particle made an interaction.
c
      subroutine chookNEPInt(never)
      implicit none
      integer never   ! input & output
      never = 1
      end


      subroutine cgetHES(from)
      implicit none
#include "../../SkelFlesh/Zprivate.h"
      integer from

      integer i

      read(from)  Np
      do i = 1, Np
         read(from) o(i)
      enddo
      end

      subroutine cobsHES
      implicit none
#include "../../SkelFlesh/Zprivate.h"
#include "Ztrack.h"
c
c           memorized high energy showers at the skeleton making
c     time is put into the chookObs as if they are really observed
      record /track/ aTrack

      integer i

      do i = 1, Np
         aTrack.where =  o(i).where 
         aTrack.p.code =  o(i).code 
         aTrack.p.subcode = o(i).subcode 
         aTrack.p.charge = o(i).charge 
         aTrack.t = o(i).atime 
         aTrack.p.fm.p(4) = o(i).erg
         aTrack.p.mass = o(i).mass 
         aTrack.pos.xyz.r(1) = o(i).x 
         aTrack.pos.xyz.r(2) = o(i).y 
         aTrack.vec.w.r(1) = o(i).wx
         aTrack.vec.w.r(2) = o(i).wy
         aTrack.vec.w.r(3) = o(i).wz
         aTrack.vec.coszenith = o(i).zenith 
         call chookObs(aTrack, 2)
      enddo
      end


c        push all  low energy partilces in the skeleton in the stack

      subroutine cpushInci
      implicit none
#include "../../SkelFlesh/Zprivate.h"
#include "Ztrack.h"
#include "Ztrackv.h"
      integer i

      record /track/aTrack

      call cinitStack  ! empty the stack

      read(Mdev)  NoOfLowE
      do  i = 1, NoOfLowE
         read(Mdev) aTrack
c           aTrack is already complete track so push it directly.
         call cpush(aTrack)
      enddo
c           sort stack dscendent order
      call csortStack
      
      end
