c      external ff
c      real*8 ff
c      real*8 x1, x2, x, eps, ans
c      integer icon
c      x1 = 0.
c      x2 = 1.8
c      x = 1.
c      eps= 1.d-11
c      call kbinChop(ff, x1, x2, x, eps, ans, icon)
c      write(*, *) icon, ans, ff(ans)
c      end
c      real*8 function ff(x)
c      real*8 x
c      ff = sin(x) - 0.5d0
c      end
c      
c      Binary Chop for getting a solution of  f(x) = 0.
c
      subroutine kbinChop(f, x1, x2, x, eps, ans, icon)
      implicit none
c
      real*8 f  ! input. function name. to be used as f(x)
                !   f(x) = 0 is solved.
      real*8 x1 ! input. lower bound of solution
      real*8 x2  ! input.  upper bound of solution
      real*8 x   ! input. initial guess of  solution.  
      real*8 eps  ! input. relative error of solution.
      real*8 ans  ! output. obtained solution
      integer  icon ! output. condition code. 0--> ok.
c               1--> unconvergence after 45 iterations
c               2--> x not in the range
      real*8 xa, xb, fa, fb, xt, ft
      integer  n
c
      if(x .lt. x1 .or. x .gt. x2) then
         icon = 2
      else
         xa = x1
         xb = x2
         fa = f(xa)
         fb = f(xb)
         icon = 1
         do n = 0, 45
            if(fa * fb .gt. 0.) then
               icon = 1
               goto 100
            else
               xt = (xa + xb)/ 2
               ft = f(xt)
               if( ft * fa .gt. 0.) then
                  xa = xt
                  fa = ft
               else
                  xb = xt
                  fb = ft
               endif
               if(abs(xt) .gt. 1.) then
                  if(abs( (xa-xb) / xt ) .lt. eps) then
                     icon = 0
                     goto 100
                  endif
               else
                  if(abs(xa-xb) .lt. eps) then
                     icon = 0
                     goto 100
                  endif
               endif
            endif
         enddo
 100     continue
         ans = xt
      endif
      end


                     
