      subroutine creadAtmosD
c
c   creadAtmosD; read atmosphere data
c   catmosConsts:  compute some basic constants
c  
c       creadAtmosD:
c  read segmented atmosphere data consisting of 
c      height temperature pressure density       

c       catmosConsts:
c      a,  b,  d0, cum, H
c where
c     a, b; const shown below
c       d0: see the formula below.
c     cumd: amount of atmospher above the node.
c        H: scale height at the node
c     all in mks unit.
c
c     The scale height is approximated by a
c   number of stright lines as a function of height. The data in
c   stdatmos1.d gives height, temperatur, etc at  each nodal point.
c
c         The scale height, H, is expressed by H = H0 + a(z-z0)
c                                                = kT/mg      
c   in each region.
c   We neglect height dependence of gravitational accelleration g,
c   and the average mass of  air molecules, m.   
c   Since the data table gives T(z)= T0 + b(z-z0) at the nodal points, 
c   we can first get b,
c   and then a by a = dH/dz = k/mg * b.  H at a nodal point, z,  
c   is obtained as H(z) =kT(z)/mg.
c
c   The density off a nodal point is given by
c
c              rho = rho0 * (1+ a(z-z0)/H(z0))**(-1-1/a)      (a != 0)
c                  = rho0 * exp(- (z-z0)/H)            (a =0; hence H is const)
c
c   (We employ H(z0) as the scale height in the segment)
c   The amount of air between  given heights, z1 and z2  is by
c
c              d = d0 *(fd(z1) - fd(z2))  where
c         
c            fd(z) = (1+ a(z-z0)/H(z0))**(-1/a)                   (a != 0)
c
c                  =  exp(-(z-z0)/H )                             (a = 0)
c
c   where  d0 = rho0*H(z0)
c
c   If z1=z0,  d becomes
c
c              d= d0 ( 1 - fd(z2))
c
c
c
c    
      implicit none

#include  "Zmanagerp.h"
#include  "Zatmos.h"

      integer  ios, nodes, icon

      character*150 msg
      character*60 adata(maxnodes)

      integer i
c          adata is the same one as
c          Data/Atmos/stdatmos0.d
c      To avoid reading it as default, it is stored here.
       data (adata(i), i = 1, 15)/
     1 '-400	290.75	1062.2	1.2790',
     2 '0	288.15	1013.25	1.2250',
     3 '3.e3	268.659	7.0121e2 9.0925e-1',
     4 '6.e3	249.187	4.7217e2 6.6011e-1',
     5 '11.1e3	216.65	223.46	0.35932',
     6 '20.0e3	216.65	55.293	8.891e-2',
     7 '32.2e3	228.756	8.6314	1.3145e-2',
     8 '47.4e3	270.65	1.1022	1.4187e-3',
     9 '51.0e3	270.65	7.0458e-1 9.0696e-4',
     a '72.0e3	214.263	3.8362e-2 6.2374e-5',
     b '86.0e3	186.87	3.7388e-3 6.958e-6',
     c '91.0e3	186.87	1.5381e-3 2.860e-6',
     d '110.0e3	240.0	7.1042e-5 9.708e-8',
     e '130.0e3	469.27	1.2505e-5 8.152e-9',
     f '160.0e3	696.29	3.0359e-6 1.233e-9'/

       data (adata(i), i=16, 24)/
     1 '250.0e3	941.33	2.4767e-7 6.073e-11',
     2 '300.0e3	976.01	8.7704e-8 1.916e-11',
     3 '400.0e3 995.83	1.4518e-8 2.803e-12',
     4 '500.0e3	999.24	3.0236e-9 5.215e-13',
     5 '600.0e3	999.85	8.2130e-10 1.137e-13',
     6 '700.0e3	999.97	3.1908e-10 3.070e-14',
     7 '800.0e3	999.99	1.7036e-10 1.136e-14',
     8 '900.0e3	1000.0	1.0873e-10 5.759e-15',
     9 '1.0e6	1000.0	7.5138e-11 3.561e-15'/
       data adata(25)/' '/

c        read basic data
      if(AtmosFile .ne. '     ') then
         call copenf(TempDev, AtmosFile, icon)
         if(icon .ne. 0) stop 9999
         call cskipComment(TempDev, icon)
         if(icon .ne. 0) stop 9999
      endif
      nodes = 0
      do while(.true.)
         if(AtmosFile .ne. '     ') then
            read(TempDev, *, end=10, iostat=ios)
     *           atmos.z(nodes+1), atmos.T(nodes+1),
     *           atmos.P(nodes+1), atmos.rho(nodes+1)
         else
            if(adata(nodes+1) .ne. ' ') then
               read(adata(nodes+1), *)
     *           atmos.z(nodes+1), atmos.T(nodes+1),
     *           atmos.P(nodes+1), atmos.rho(nodes+1)
               ios = 0
            else
               goto 10
            endif
         endif
         if(ios .ne. 0) then
            call cerrorMsg(
     *       'something wrong about atmosphere data file:',1)
            call cerrorMsg(AtmosFile, 0)
         endif
         nodes = nodes + 1
      enddo
 10   continue
      if(AtmosFile .ne. '  ') then
         close(TempDev)
         write(msg, *) 
     *   "Atmosphere data has been read: # of nodal points =",
     *    nodes
      else
         write(msg, *) 
     *   "Atmosphere data stored internally is read nodes=",
     *    nodes
      endif
      call cerrorMsg(msg, 1)
      atmos.nodes = nodes
      end



