      subroutine cBrSSampP(Ee, prob)
c          brems prob. sampling by Seltzer data.
      implicit none
#include "ZbpCnst.h"
#include "ZbpTable.h"

      real*8 Ee
      real*8 prob  ! output probability of Brems / X0

      real*8 ale


      if(Ee .le. BrEeminS) then
         prob= 1.d-40
      else
         ale=log10(Ee)
         call kintp3(BrTXS,
     *   1, BrTXTS, BrLEeminS,
     *   BrdETXS, ale, prob) 
      endif
      end
c     ************
      subroutine cBrSSampE( Ee, Eg)
c     ************
c         brems energy by Seltzer
      implicit none
#include "Zmass.h"
#include "ZbpCnst.h"
#include "ZbpTable.h"

      real*8 Ee,  Eg

      real*8 u, ale, us, ans

      call rndc(u)
      ale = log10(Ee)
      if(u .gt. BrUminSA) then
c          region A

         call k4ptdi(BrSTSA, 
     *        BrUszSA, 
     *        BrES,
     *        BrUszSA, 
     *        BrUminSA,
     *        BrLEeminS,
     *        BrdUSA,
     *        BrdES, u,  ale,  ans)  
         Eg= exp( ans*(1.-u))*BrEgminS
      else
c         region B
         us = u**0.25d0

         call k4ptdi(BrSTSB, 
     *        BrUszSB, 
     *        BrES,
     *        BrUszSB, 
     *        0.d0,
     *        BrLEeminS,
     *        BrdUSB,
     *        BrdES, us,  ale,  ans)  
         Eg = exp(-ans*u)*(Ee-masele)
c         Eg = exp(-ans*u)*Ee
      endif
      end
