c     
c            weighted histograming  fortan 90 version
c            (Not work under Absoft fortran 90) 
c      Usage:  kwhisti:   instanciate one histogram
c              kwhistc:   clear histogram area
c              kwhist:    take histogram
c              kwhists:   compute statistical result.
c                        This can be used more than once 
c                        with a differennt normalization factor
c                        for the same histogram.   
c              kwhistp:   print statistical result
c              kwhistw:  write histogram with binary format
c                        for later use.
c              kwhistr:  read histogram written by kwhistw
c              kwhista:  add two histograms with identical
c                        structure.
c
c              print format
c     #hist1  NoOfBins MinIndex MaxIndex Norm  DataSum  ID
c     BinIndex x  dn/dx/Norm  dN   Sum(>=x)  <x>InTheBin
c     BinIndex x  dn/dx/Norm  dN   Sum(>=x)  <x>InTheBin
c     ...
c     0 0 0 0 0 0
c
c      MinIndex: min. bin index where non zero data is stored
c      MaxIndex: max. bin index where non zero data is stored
c
      subroutine kwhisti(h, ixmin, ibinORxmax, inbin, itklg )
      implicit none
c         instanciate
      integer inbin  ! input. request inbin histogram area
      real ixmin     ! input. xmin. not in log even if log10(variable) is taken
                     !         see itklg 
      real ibinORxmax  ! input. bin or ixmax. depends on itklg.
                     !  If bin and log10 is taken, bin is for log10 

      integer itklg  ! input.  bit pattern. give it like b'10001'
                     !         bit 1 is LSB.
                     !         bit 1: 0--> not take log10 of variable
                     !                1--> take log10   //
                     !             2: 0--> ixmin is the min of lowest bin
                     !                    |---|---|---|....     |...|
                     !                    |                         |
                     !                    ixmin                     ixmax
                     !                1--> ixmin is the center of the lowest bin
                     !                  |--*--|-----|-----|....    |--*--|
                     !                     |                          |
                     !                     ixmin                      ixmax
                     !            max follows the same rule.
   
                     !             3: 0--> neglect underflow
                     !                1--> underflow is put in lowest bin
                     !                     mean bin value is affected by
                     !                     those with underflowed values
                     !             4: 0--> neglect overflow
                     !                1--> overflow is put in the highest bin
                     !                     mean bin value is affected by
                     !                     overflowed ones    
                     !             5: 0-->ibinORxmax  is the bin
                     !                        xmax is determined by bin,
                     !                        xmin and inbin
                     !                1-->ibinORxmax  is ixmax. 
                     !                        bin is determined by xmax xmin
                     !                        and inbin.
c     ******************
      include 'Z90histc.f'
      include "Z90hist.f"
      type(histogram1) h, h1, h2
c     ====================      
      integer fno  !  if < 0, standard output is used else fno is used for histogram output
                   !  fno must be opened by the user beforehand.
      real inorm   !  input. used in the normalization as dN/dx/inorm
                   !  if 0, area normalization is tried.
c
      real  x, w 
      real  xx
      integer nbin,  i, ndiv, dealloc
      logical  asmax
      real*8 isumw
      real dx
      integer bfnow  !  binary  write file no.
      integer bfnor  !  binary  read file no.
      integer icon   !  0; binary read was successful
                     !  1; unexpected EOF
      character *(*) id
      integer klena

      if( h%init .eq. 'initend') then
         write(0, *) ' already instanciated; xmin=',ixmin,
     *    ' binORmax=',ibinORxmax, ' inbin=', inbin, ' itklg=',itklg
      else
         h%init = 'initend'
      endif

      h%x%nhist = inbin
      allocate( h%xw(inbin) )
      allocate( h%dnw(inbin) )
      allocate( h%mean(inbin) )
      allocate( h%dndx(inbin) )
      h%x%tklg  =( itklg - (itklg/2)*2  ) .ne. 0
      h%x%cent  =( (itklg/2)*2 - (itklg/4)*4 ) /2    ! integer
      h%x%ufl  = ( (itklg/4)*4 - (itklg/8)*8 ) .ne. 0
      h%x%ofl  = ( (itklg/8)*8 - (itklg/16)*16 ) .ne. 0
      asmax = ( (itklg/16)*16 - (itklg/32)*32 ) .ne. 0
                        
      h%x%xmin = ixmin    !  not used at present
      if(asmax) then
         if(ixmin .ge. ibinORxmax ) then
            write(0,*) ' ibinORxmax is regarded as ixmax but <= ixmin'
            stop 99999
         else
            if( h%x%cent .eq. 1 ) then
               ndiv= inbin - 1
            else
               ndiv = inbin
            endif
            if(h%x%tklg) then
               h%x%bin = log10(ibinORxmax/ixmin)/ndiv
            else
               h%x%bin = (ibinORxmax - ixmin )/ndiv
            endif
         endif
      else
         h%x%bin = ibinORxmax
      endif

      if( h%x%tklg  ) then
         if( h%x%xmin <= 0.0 )  then
            write(0,
     *       '("min must be > 0 for log option")')
            stop
         endif
         h%x%xm = log10(h%x%xmin) - h%x%cent * h%x%bin/2
         h%x%inc = 10.**h%x%bin
      else 
         h%x%xm = h%x%xmin  -  h%x%cent * h%x%bin/2
         h%x%inc  = h%x%bin
      endif
      h%id = ' '

      return
c    ************************
      entry kwhistc(h)
c    ************************
      do i = 1, h%x%nhist
         h%xw(i) = 0.
         h%dnw(i) = 0.
      enddo
      return
c    *************************
      entry kwhist( h, x, w )
c    *************************
      if( h%x%tklg  .and. x .le. 0.) then
c         neglect this data
      else
         if( h%x%tklg  ) then
            xx = log10(x)
         else
            xx = x
         endif
         i = ( xx-h%x%xm ) / h%x%bin  + 1

         if(i .le. 0 .and. h%x%ufl ) then
            i = 1
         elseif(i .gt. h%x%nhist .and. h%x%ofl ) then
            i = h%x%nhist
         endif
                                                        
         if(i .ge. 1 .and.  i  .le. h%x%nhist )  then
            h%xw(i) = h%xw(i)  +  x*w
            h%dnw(i) = h%dnw(i) + w
         endif

      endif
      return

c     ***********************
      entry kwhists( h, inorm )
c     ************* take statistics
      h%norm = inorm
      h%x%imin = 1
      do while( h%x%imin .lt. h%x%nhist .and.  h%dnw(h%x%imin) .eq. 0.) 
         h%x%imin = h%x%imin + 1
      enddo

      h%x%imax = h%x%nhist
      do while (h%x%nhist .gt. 1 .and.  h%dnw(h%x%imax) .eq.  0.)  
         h%x%imax = h%x%imax -1
      enddo



      h%x%sumw = 0
      do i = h%x%imin, h%x%imax
         h%x%sumw = h%x%sumw +  h%dnw(i)
      enddo
      if(h%norm .eq. 0. .and.  h%x%sumw  .gt. 0.) then
         h%norm = h%x%sumw 
      elseif(h%norm .eq. 0.  ) then
         h%norm = 1.0
      endif

c        bin center value
      if( h%x%tklg ) then
         xx =10**(h%x%xm + h%x%bin/2.) * h%x%inc**(h%x%imin-1)
      else
         xx = h%x%xm +   h%x%bin/2 + h%x%inc*(h%x%imin-1)
      endif

      dx = h%x%bin      
      do i = h%x%imin, h%x%imax
         if( h%x%tklg ) then
            dx  = 10.0**(h%x%xm + i * h%x%bin) -
     *            10.0**(h%x%xm + (i-1)*h%x%bin)
         endif
         if(h%dnw(i) .eq. 0) then
            h%mean(i) = xx
         else
            h%mean(i) = h%xw(i)/h%dnw(i)
         endif

         h%dndx(i) = h%dnw(i)/dx/h%norm
         if( h%x%tklg ) then
            xx = xx * h%x%inc
         else
            xx = xx + h%x%inc
         endif
      enddo
      return
c     ********************
      entry kwhistid(h,  id )
c     *******************
      h%id = id
      return
c     *********************
      entry kwhistpr( h, fno )
c     ****************print  hist
      isumw = h%x%sumw


      if( h%x%tklg ) then
         xx = 10.0**(h%x%xm + h%x%bin/2.0) * h%x%inc**(h%x%imin-1)
      else
         xx = h%x%xm + h%x%bin/2. + h%x%inc*(h%x%imin-1)
      endif
c        header
      if(fno .lt. 0) then
         write(*, '(a, 3i5, 2g14.4, a)' )
     *     '#hist1 ', h%x%nhist, h%x%imin, h%x%imax, h%norm,
     *     h%x%sumw,  h%id(1:klena(h%id))
      else
         write(fno, '(a, 3i5, 2g14.4, a)' )
     *     '#hist1 ', h%x%nhist, h%x%imin, h%x%imax, h%norm,
     *     h%x%sumw, h%id(1:klena(h%id))
      endif
c
      do i = h%x%imin, h%x%imax
         if(fno .lt. 0) then
            write(*, '(i5, 5g14.4)')   i,
     *       xx,  h%dndx(i), h%dnw(i), isumw,  h%mean(i) 
         else
            write(fno, '(i5, 5g14.4)')  i,
     *       xx,  h%dndx(i), h%dnw(i),  isumw, h%mean(i) 
         endif            
         isumw = isumw -  h%dnw(i)
         if( h%x%tklg ) then
            xx =  xx * h%x%inc 
         else
            xx = xx + h%x%inc
         endif
      enddo
c       trailer
      if(fno .lt. 0) then
         write(*,'(6i3)')  0,0,0,0,0,0
      else
         write(fno,'(6i3)')  0,0,0,0,0,0
      endif
      return
c     *********************
      entry kwhistw(h, bfnow)
c     ********************      
c       binary write of h to bfnow
      write(bfnow) '#hist1'
      write(bfnow) h%x%nhist
      write(bfnow) h%x, h%norm, h%init, h%id
      write(bfnow) h%xw, h%dnw, h%mean, h%dndx
      return
c     *********************
      entry kwhistr(h, bfnor, icon)
c     ********************
c        #hist1 must be read outside
c
      read(bfnor, end =222)  nbin 
      allocate( h%xw(nbin) )
      allocate( h%dnw(nbin) )
      allocate( h%mean(nbin) )
      allocate( h%dndx(nbin) )
      read(bfnor, end=222)  h%x, h%norm, h%init, h%id
      read(bfnor, end= 222)  h%xw, h%dnw, h%mean, h%dndx
      icon = 0
      return
 222  continue
      write(0,*) ' kwhistr reached EOF unexpectedly'
      icon = 1
      return
c     ****************
      entry kwhistd(h)
c     ***************
c      deallocate histogram area
c
      h%init = ' '
      deallocate( h%xw, h%dnw,  h%mean,  h%dndx, stat=dealloc)
      if(dealloc .ne. 0) then
         write(0,*) ' dealloc failed =',dealloc
         stop 12345
      endif
      return
c     ********************
      entry kwhista(h1, h2, h)
c     ******************
c      h = h1 + h2  of bin area. For others, h1 is inherited
c      h,  h1 and h2 must be the same size  histogram  of same 
c     type.  h can be h1
c
      if( h1%x%nhist .ne. h2%x%nhist) then
         write(0, *)
     *    ' h1 and h2 diff. size histogram in kwhista'
         stop 9876
      endif
      if( h%init .ne. 'initend') then
c           not yet initialized.
         nbin = h1%x%nhist
         allocate( h%xw(nbin) )
         allocate( h%dnw(nbin) )
         allocate( h%mean(nbin) )
         allocate( h%dndx(nbin) )
         h%init = 'initend'
      endif
      h%x = h1%x
      h%norm= h1%norm
      h%id = h1%id
      do i = 1, h%x%nhist
         h%xw(i) = h1%xw(i) + h2%xw(i)
         h%dnw(i) = h1%dnw(i) + h2%dnw(i)
      enddo
                                          
      end
      subroutine kwhistso( binw )
c        specify output method
      implicit none
      include "Z90histCom.f"
      integer binw  ! input.  1--> ascii write
                    !         2--> binary write
      
      BinWrite = binw
      if(binw .ne. 1 .and. binw .ne. 2) then
         write(0,*) 'binw=',binw,' for kwhistso is invalid'
         stop
      endif
      end

      subroutine kwhistp( h, fno )
c
c         print or binary write histogram
c         kwhistso must be called to
c         fix binary write or print
c
      implicit none
      include 'Z90histc.f'
      include "Z90hist.f"
      include "Z90histCom.f"

      type(histogram1) h
      integer fno

      if( BinWrite .eq. 2 ) then
         call kwhistw(h, fno)
      elseif(BinWrite .eq. 1 ) then
         call kwhistpr(h, fno)
      endif
      end

      

