c         test kgauss  on sun fortran (new version)
c      
c       real*8 g1
c       do 100 i=1, 25000 
c          call kgauss(0.d0, 1.d0, g1)
c         write(*, *) sngl( g1 )
c  100  continue
c      end
      subroutine kgauss(m, v, g1)
c           kagauss and kgauss2:
c           Generate a Gaussian random variable with a given mean
c           and variance.
c        m:   real*8 input.   mean of the distribution.
c        v:   real*8 input.   variance of the distribution.
c       g1:   real*8 output.  a gaussian random variable.
c
c       g2:   real*8 output.  another gaussian random variable.
c             available only via kgauss2
c
c        subroutine needed:  rndc.
c
c          Since Box-Muler method with a switch to generate one
c          variable at a time efficently is not usable for
c          Cosmos which uses the skeleton-fleshing method,
c          this version generate two varibles at a time and
c          returns only one (kgauss), or two (kgauss2).
c          (This one is faster than Butcher's method).
c        100000 variable generation: by 90 MHz Pentium and Absoft Fortran.
c         kgauss needs  (1.29 sec) and 
c         kgauss2 needs (0.69 sec )
c         Butcher's method needs 1.69 sec.
c   
c          
c          To generate 25000 variables, 0.85 sec is needed on Sparc 2.
c           
        implicit none
        real*8 m, v, g1, g2
c
c        logical sw/.true./
        logical more
        real*8 u1, u2, r
        real*8  temp
c       save sw, temp
c        save u2
        logical entry2
c
        entry2 =.false.
        goto 10

c       ***************
        entry  kgauss2(m, v, g1, g2)
c       ***************
        entry2 = .true.

c       integer nt
c             -----------------
c        if(sw) then
c               counter for the loop at the test time.
c           nt=0
c               nt is distributed like
c               exp(-1.57nt) ( nt=1, 2, ...).  The average is 1.75.
 10      continue
            more=.true.
            do while (more)
c              nt=nt+1
               call rndc(u1)
               call rndc(u2)
               u1=u1*2 - 1.0d0
               u2=u2*2 - 1.0d0
               r=u1**2 + u2**2
               more= r .gt. 1.0d0
            enddo
c           write(*,*) nt
            temp=sqrt(-2*log(r)/r)
            g1=u1*temp*v + m
c           sw=.false.
            if(entry2) then
c        else    
c                g1=u2*temp*v + m
               g2 = u2*temp*v + m
            endif   
c            sw=.true.
c        endif    
      end    
