c             hadron A collision by New Lund (Fritiof v7.02)
        subroutine chANewLund(pj, ia, iz,  a, ntp)
        implicit none

#include  "Zptcl.h"
#include  "Zcode.h"
#include  "Zevhnv.h"
c
      record /ptcl/ pj   ! input  projectile ptcl
      integer ia    ! input. nucleon no. of target
      integer iz    ! input. charge no. of target
      record /ptcl/ a(*)  !  output. produced ptcls
      integer ntp   ! number of produced ptcls
c
      record /ptcl/   tgt, temp
      integer icon, kf, i, code, subcode, charge, maxi
      real*8 maxe
c      record /fmom/ gb  ! (g*beta, gc)
      character*100 msg
c////////////
c       logical deb
c       common /cccdeb/deb
c      integer seed(2)
c      debug = .false.
c////////////
c

c             make target nucleon simply to form cms
         call cmkptc(knuc, regptcl, 1,  tgt)
c              give 4 momentum
         tgt.fm.p(1) = 0.
         tgt.fm.p(2) = 0.
         tgt.fm.p(3) = 0.
         tgt.fm.p(4) = tgt.mass
c
c         make projectile so that its direction is z
c
         Pjlab.fm.p(1) = 0.
         Pjlab.fm.p(2) = 0.
         Pjlab.fm.p(3) = sqrt(pj.fm.p(4)**2-pj.mass**2)
         Pjlab.fm.p(4) = pj.fm.p(4)
         Pjlab.mass = pj.mass
c         Pjlab.code = pj.code
c         Pjlab.subcode = pj.subcode
c         Pjlab.charge = pj.charge

c          get cms equivlent mass and 4 momentum
       call cgeqm(Pjlab, tgt, Cmsp, icon)
       if(icon .ne. 0) then
          write(msg, *) 
     *    ' cms cannot be formed in chANewLund; proj and ',
     *    'target are '
          call cerrorMsg(msg, 1)
          call cprptc(Pjlab, 1)
          call cprptc(tgt, 1)
          stop 9999
       endif
c          get (g*beta, gc) of cms
c       call cgetlf(Cmsp,  gb)
c          boost pj into cms.
c       call cbst0(1, gb, Pjlab, Pjcms)
c
       code = pj.code         ! need substitution due to integer*2
       subcode = pj.subcode
       charge = pj.charge
c          convert particle code to kf code
       call ccos2kf(code, subcode, charge, kf)
c          generate ptcls in cms and set them in a
c/////////////
c        debug = pj.fm.p(4) .gt. 30.e3
c        if(debug) then
c           write(*,*) '-----',
c     *      pj.fm.p(1), pj.fm.p(2), pj.fm.p(3), pj.fm.p(4)
c           write(*,*) 'ia, iz=', ia,iz,code,subcode,charge, kf
c           call rnd1s(seed)
c           write(*,*) ' seed=', seed
c        endif
c       if( deb ) then
c          write(*,*) ' bef cfrevent '
c       endif
c///////////

       call cfrevent(kf, charge, ia, iz, Cmsp.mass, a, ntp)

c////////////////
c       if( deb ) then
c          write(*,*) ' after cfrevent '
c       endif
c////////

c          boost back to lab.
c          find max energy partcle and store it in the last
c          part. (to save stack area, later)
       maxe = -1. 
       do   i=1, ntp
          call cibst1(i, Cmsp, a(i), a(i))
          if(a(i).fm.p(4) .gt. maxe) then
             maxe = a(i).fm.p(4)
             maxi = i
          endif
c &&&&&&&&&&&&&&&&777
c          write(*,*) ' code=', a(i).code, ' sub=', a(i).subcode, 
c     *     ' chg=', a(i).charge, ' KE=', a(i).fm.p(4) - a(i).mass
c  &&&&&&&&&&&&&&&&
       enddo
       temp = a(maxi)
       a(maxi) = a(ntp)
       a(ntp) = temp
c         in  above, momentum  is measured from pj.fm so 
c         we need rotate it.
       call crot3mom(pj, a, ntp)
       end

