c     
c            weihted histograming  fortan 90 version. 3D case 
c            (Not work with Absoft) 
c
c
      subroutine kwhisti3( h,
     *      ixmin, ixbinORxmax, ixnbin, ixtklg,  
     *      iymin, iybinORymax, iynbin, iytklg,  
     *      izmin, izbinORzmax, iznbin, iztklg )

      implicit none
c         initialize 
      integer ixnbin  ! input.  request ixnbin histogram size
      real ixmin     ! input. xmin. not in log even log10
      real ixbinORxmax    ! input. bin or xmax.  see k90whist2.f
      integer ixtklg    ! input. same as k90wist or k90whist2

      integer iynbin  ! input.  request iynbin histogram size
      real iymin     ! input. xmin. not in log even log10
      real iybinORymax      ! input. bin.  If log, bin is for log10
      integer iytklg    ! input.  same as ixtklg 
                       !         
      integer iznbin  ! input.  request iznbin histogram size
      real izmin     ! input. xmin. not in log even log10
      real izbinORzmax      ! input. bin.  If log, bin is for log10
      integer iztklg    ! input.   same as ixtklg 
      integer dealloc
      real*8 sum 
      integer   xnbin, ynbin, znbin
                       !         
      character*(*)  id
      integer klena
c     ******************
      include 'Z90histc.f'
      include "Z90hist3.f"
      type(histogram3) h, h1, h2
c     ====================      
      real inorm   !  input. used in the normalization as dN/dx/inorm
                   ! if 0, area normalization is tried. Hear the area is
                   ! not whole (x,y,z) region, but along  z at given (x,y)
                   ! ((x,y) are regarded as fixed parameter.
      integer fno  !  if < 0, standard output is used else fno is used for histogram output
                   !  fno must be opened by the user beforehand.
      integer bfnow  ! input. binary  write file no.
      integer bfnor  ! input. binary  read file no.
      integer icon   ! output. 0; binary read was successful
                     !  1;unexpected EOF
                  
c
      real  x, y, z,  w 
      real  xx, yy, zz
      integer  i, j, k, ndiv
      logical asmax
      real dx,  dy, dz



      if( h%init .eq. 'initend') then
         write(0, *) ' already instanciated; xmin=',ixmin,
     *    ' binORmax=',ixbinORxmax, ' inbin=', ixnbin, ' itklg=',ixtklg
         write(0, *) '  ymin=',iymin,
     * ' binORmax=',iybinORymax, ' iynbin=', iynbin, ' itklg=',iytklg
         write(0, *) '  zmin=',izmin,
     * ' binORmax=',izbinORzmax, ' iznbin=', iznbin, ' itklg=',iztklg
      else
         h%init = 'initend'
      endif
                                                                              
      h%x%nhist = ixnbin
      h%y%nhist = iynbin
      h%z%nhist = iznbin
      allocate( h%dnw(ixnbin, iynbin, iznbin) )
      allocate( h%dndxdydz(ixnbin, iynbin, iznbin) )

      h%x%tklg  = ( ixtklg - (ixtklg/2)*2 ) .ne. 0
      h%x%cent  = ( ( ixtklg/2)*2 - (ixtklg/4)*4 )/2
      h%x%ufl  = ( (ixtklg/4 )*4 - (ixtklg/8)*8) .ne. 0
      h%x%ofl  = ( (ixtklg/8 )*8 - (ixtklg/16)*16 ) .ne. 0
                        
      h%x%xmin = ixmin

      asmax  = ( (ixtklg/16 )*16 - (ixtklg/32)*32 ) .ne. 0
      if(asmax) then
         if(ixmin .ge. ixbinORxmax) then
            write(0,*) ' ixbinORxmax is regarded as ixmax but <= ixmin'
            stop 99999
         else
            if( h%x%cent .eq. 1 ) then
               ndiv= ixnbin - 1
            else
               ndiv = ixnbin
            endif
            if(h%x%tklg) then
               h%x%bin = log10(ixbinORxmax/ixmin)/ndiv
            else
               h%x%bin = (ixbinORxmax - ixmin )/ndiv
            endif
         endif
      else
         h%x%bin = ixbinORxmax
      endif


      h%y%tklg  = (iytklg - (iytklg/2)*2) .ne. 0
      h%y%cent  = ( (iytklg/2)*2 - (iytklg/4)*4) /2
      h%y%ufl  = ( (iytklg/4)*4 - (iytklg/8)*8 ) .ne. 0
      h%y%ofl  = ( (iytklg/8)*8 - (iytklg/16)*16 ) .ne. 0

      h%y%xmin = iymin

      asmax  = ( (iytklg/16 )*16 - (iytklg/32)*32 ) .ne. 0
      if(asmax) then
         if(iymin .ge. iybinORymax) then
            write(0,*) ' iybinORymax is regarded as iymax but <= iymin'
            stop 99999
         else
            if( h%y%cent .eq. 1 ) then
               ndiv= iynbin - 1
            else
               ndiv = iynbin
            endif
            if(h%y%tklg) then
               h%y%bin = log10(iybinORymax/iymin)/ndiv
            else
               h%y%bin = (iybinORymax - iymin )/ndiv
            endif
         endif
      else
         h%y%bin = iybinORymax
      endif



      h%z%tklg  =( iztklg - (iztklg/2)*2 ) .ne. 0
      h%z%cent  =( (iztklg/2)*2 - (iztklg/4)*4 ) /2
      h%z%ufl  = ( (iztklg/4)*4 - (iztklg/8)*8 ) .ne. 0
      h%z%ofl  = ( (iztklg/8)*8 - (iztklg/16)*16 ) .ne. 0

      h%z%xmin = izmin

      asmax  = ( (iztklg/16 )*16 - (iztklg/32)*32 ) .ne. 0
      if(asmax) then
         if(izmin .ge. izbinORzmax) then
            write(0,*) ' izbinORzmax is regarded as izmax but <= izmin'
            stop 99999
         else
            if( h%z%cent .eq. 1 ) then
               ndiv= iznbin - 1
            else
               ndiv = iznbin
            endif
            if(h%z%tklg) then
               h%z%bin = log10(izbinORzmax/izmin)/ndiv
            else
               h%z%bin = (izbinORzmax - izmin )/ndiv
            endif
         endif
      else
         h%z%bin = izbinORzmax
      endif


      if( h%x%tklg  ) then
         if( h%x%xmin <= 0.0 )  then
            write(0,
     *       '("min must be > 0 for log option")')
            stop
         endif
         h%x%xm = log10(h%x%xmin)-h%x%cent * h%x%bin/2.
         h%x%inc = 10.**h%x%bin
      else
         h%x%xm = h%x%xmin - h%x%cent * h%x%bin/2.
         h%x%inc = h%x%bin
      endif

      if( h%y%tklg  ) then
         if( h%y%xmin <= 0.0 )  then
            write(0,
     *       '("min must be > 0 for log option")')
            stop
         endif
         h%y%xm = log10(h%y%xmin) - h%y%cent * h%y%bin/2.
         h%y%inc = 10.**h%y%bin
      else 
         h%y%xm = h%y%xmin - h%y%cent * h%y%bin/2.
         h%y%inc  = h%y%bin
      endif

      if( h%z%tklg ) then
         if( h%z%xmin <= 0.0 )  then
            write(0,
     *       '("min must be > 0 for log option")')
            stop
         endif
         h%z%xm = log10(h%z%xmin) - h%z%cent * h%z%bin/2.
         h%z%inc = 10.**h%z%bin
      else 
         h%z%xm = h%z%xmin - h%z%cent * h%z%bin/2.
         h%z%inc  = h%z%bin
      endif
      return

c     ***************************
      entry kwhistc3(h)
c     ***************************
      do i = 1, h%x%nhist
         do j = 1, h%y%nhist
            do k = 1, h%z%nhist
               h%dnw(i,j,k) = 0.
            enddo
         enddo
      enddo
      return

c    *************************
      entry kwhist3( h, x, y, z,  w )
c    *************************
      if( h%x%tklg  .and. x .le. 0.) then
c         neglect this data
      elseif( h%y%tklg  .and. y .le. 0.) then
c         neglect this data
      elseif( h%z%tklg  .and. z .le. 0.) then
c         neglect this data
      else
         if( h%x%tklg  ) then
            xx = log10(x)
         else
            xx = x
         endif
         if( h%y%tklg  ) then
            yy = log10(y)
         else
            yy = y
         endif
         if( h%z%tklg  ) then
            zz = log10(z)
         else
            zz = z
         endif

         i = ( xx-h%x%xm ) / h%x%bin  + 1
         if( i .le.  0 .and. h%x%ufl ) i = 1
         if( i .gt.  h%x%nhist  .and. h%x%ofl ) i = h%x%nhist

         j = ( yy-h%y%xm ) / h%y%bin  + 1
         if( j .le.  0 .and. h%y%ufl ) j = 1
         if( j .gt.  h%y%nhist  .and. h%y%ofl ) j = h%y%nhist

         k = ( zz-h%z%xm ) / h%z%bin  + 1
         if( k .le.  0 .and. h%z%ufl ) k = 1
         if( k .gt.  h%z%nhist  .and. h%z%ofl ) k = h%z%nhist

         if(  i .ge. 1 .and.  i  .le. h%x%nhist 
     *        .and.         
     *        j .ge. 1 .and.  j  .le. h%y%nhist
     *        .and.         
     *        k .ge. 1 .and.  k  .le. h%z%nhist )  then
c            h%dn(i,j, k) = h%dn(i,j, k)  + 1
            h%dnw(i,j,k) = h%dnw(i,j,k) + w
         endif
      endif
      return

c     ***********************
      entry kwhists3( h, inorm )
c     ************* take statistics
      h%norm = inorm

      h%x%imin = h%x%nhist
      h%x%imax = 1

      h%y%imin = h%y%nhist
      h%y%imax = 1

      h%z%imin = h%z%nhist
      h%z%imax = 1

      do i = 1, h%x%nhist
         do j = 1, h%y%nhist
            do k = 1, h%z%nhist
               if( h%dnw(i,j,k) .ne. 0) then
                  h%x%imin = min(h%x%imin, i)
                  h%y%imin = min(h%y%imin, j)
                  h%z%imin = min(h%z%imin, k)
                  h%x%imax = max(h%x%imax, i)
                  h%y%imax = max(h%y%imax, j)
                  h%z%imax = max(h%z%imax, k)
               endif
            enddo
         enddo
      enddo
      if( h%norm .eq. 0. .and. sum .gt. 0.) then
         h%norm = sum
      endif
      if( h%norm .eq. 0. ) then
         h%norm = 1.
      endif

      dx = h%x%bin      
      dy = h%y%bin
      dz = h%z%bin

      do i = h%x%imin, h%x%imax
         if(h%x%tklg ) then
            dx  = 10.0**(h%x%xm + i * h%x%bin) -
     *           10.0**(h%x%xm + (i-1)*h%x%bin)
         endif

         do j = h%y%imin, h%y%imax
            if(h%y%tklg ) then
               dy  = 10.0**(h%y%xm + j * h%y%bin) -
     *               10.0**(h%y%xm + (j-1)*h%y%bin)
            endif
            sum = 0.
            do k = h%z%imin, h%z%imax
               sum = sum + h%dnw(i,j,k) 
            enddo
            if(inorm .eq. 0. .and. sum .gt. 0.) then
               h%norm = sum
            elseif(inorm .eq. 0.) then
               h%norm = 1.
            endif
            do k = h%z%imin, h%z%imax
               if(h%z%tklg ) then
                  dz  = 10.0**(h%z%xm + k * h%z%bin) -
     *                  10.0**(h%z%xm + (k-1)*h%z%bin)
               endif
               h%dndxdydz(i,j,k) = h%dnw(i,j,k)/dx/dy/dz/h%norm
            enddo
         enddo
      enddo
      return
c     *********************
      entry kwhistid3( h, id)
c     ********************
      h%id = id
      return

c     *********************
      entry kwhistpr3( h, fno )
c     ****************print  hist
c
c
      if(h%x%tklg ) then
         xx = 10.0**(h%x%xm + h%x%bin/2) * h%x%inc**(h%x%imin-1)
      else
         xx = h%x%xm + h%x%bin/2  + h%x%inc*(h%x%imin-1)
      endif
c       header
      if( fno .lt. 0 ) then
         write(*, '(a, 2i4,i5, 4i4, 2i5, g14.4, a)')
     *    '#hist3 ', h%x%nhist, h%y%nhist, h%z%nhist,
     *    h%x%imin, h%x%imax, 
     *    h%y%imin, h%y%imax,
     *    h%z%imin, h%z%imax, h%norm, h%id(1:klena(h%id))
      else
         write(fno, '(a, 2i4,i5, 4i4, 2i5, g14.4, a)')
     *    '#hist3 ', h%x%nhist, h%y%nhist, h%z%nhist,
     *    h%x%imin, h%x%imax, 
     *    h%y%imin, h%y%imax,
     *    h%z%imin, h%z%imax, h%norm, h%id(1:klena(h%id))
      endif
      do i = h%x%imin, h%x%imax
         if(h%y%tklg ) then
            yy = 10.**(h%y%xm + h%y%bin/2) * h%y%inc**(h%y%imin-1)
         else
            yy = h%y%xm + h%y%bin/2 + h%y%inc*(h%y%imin-1)
         endif

         do j = h%y%imin, h%y%imax
            if(h%z%tklg ) then
               zz =10.0**( h%z%xm + h%z%bin/2) * h%z%inc**(h%z%imin-1)
            else
               zz = h%z%xmin + h%z%bin/2 + h%z%inc*(h%z%imin-1)
            endif
            do k = h%z%imin, h%z%imax
               if(fno .lt. 0 ) then
                  write(*, '(2i4,i5, 5g14.4)') i, j, k,
     *            xx, yy, zz,  h%dndxdydz(i,j,k), h%dnw(i,j,k)
               else
                  write(fno, '(2i4, i5, 5g14.4)')  i, j, k,
     *           xx, yy, zz,  h%dndxdydz(i,j,k), h%dnw(i,j,k)
               endif               
               if( h%z%tklg ) then
                  zz =  zz * h%z%inc 
               else
                  zz =  zz + h%z%inc
               endif
            enddo
            if(fno .lt. 0) then
               write(*, '(8i3)')  i, j, 0, 0, 0, 0, 0, 0 
            else
               write(fno, '(8i3)')  i, j, 0, 0, 0, 0, 0, 0 
            endif
            if( h%y%tklg ) then
               yy =  yy * h%y%inc 
            else
               yy =  yy + h%y%inc
            endif
         enddo

         if( fno .lt. 0 ) then
            write(*, '(8i3)')  i,  0, 0, 0, 0, 0, 0, 0 
         else
            write(fno,'(8i3)')  i,  0, 0, 0, 0, 0, 0, 0 
         endif

         if( h%x%tklg ) then
            xx =  xx * h%x%inc 
         else
            xx = xx + h%x%inc
         endif
      enddo
      if( fno .lt. 0 ) then
         write(*, '(8i3)') 0,  0, 0, 0, 0, 0, 0, 0 
      else
         write(fno,'(8i3)') 0,  0, 0, 0, 0, 0, 0, 0 
      endif
      return
c     *********************
      entry kwhistw3(h, bfnow)
c     *****************
c       binary write of h to bfnow
      write(bfnow) '#hist3'
      write(bfnow) h%x%nhist, h%y%nhist, h%z%nhist 
      write(bfnow) h%x, h%y, h%z, h%norm, h%init, h%id
      write(bfnow) h%dnw,  h%dndxdydz
      return

c     *********************
      entry kwhistr3(h, bfnor, icon)
c     *********************
c        #hist3 must be read outside

      read(bfnor, end =222) xnbin, ynbin, znbin
      allocate( h%dnw(xnbin, ynbin, znbin) )
      allocate( h%dndxdydz(xnbin, ynbin, znbin) )
      read(bfnor, end=222)  h%x, h%y, h%z, h%norm, h%init, h%id
      read(bfnor, end= 222) h%dnw, h%dndxdydz
      icon = 0
      return
 222  continue
      write(0,*) ' kwhistr3 reached EOF unexpectedly'
      icon = 1
      return
c     *****************
      entry kwhistd3(h)
c     ***************
c       deallocate histo area
      h%init = ' '
      deallocate(h%dnw,h%dndxdydz, stat=dealloc)
      if(dealloc .ne. 0) then
         write(0,*) ' failed to deallocated hist 3=',dealloc
         stop 3333
      endif
      return
c     ********************
      entry kwhista3(h1, h2, h)
c     ******************
c      h = h1 + h2  of bin area. For others, h1 is inherited
c      h,  h1 and h2 must have the identical structure
c      h can be h1
c
      if( h1%x%nhist .ne. h2%x%nhist .or.
     *    h1%y%nhist .ne. h2%y%nhist .or.
     *    h1%z%nhist .ne. h2%z%nhist ) then
         write(0, *)
     *    ' h1 and h2 diff. size histogram in kwhista3'
         stop 9876
      endif
      if( h%init .ne. 'initend') then
c           not yet initialized.
         xnbin = h1%x%nhist
         ynbin = h1%y%nhist
         znbin = h1%z%nhist
         allocate( h%dnw(xnbin, ynbin, znbin) )
         allocate( h%dndxdydz(xnbin, ynbin, znbin) )
         h%init = 'initend'
      endif
      h%x = h1%x
      h%y = h1%y
      h%z = h1%z
      h%norm= h1%norm

      h%id = h1%id
      do i = 1, h%x%nhist
         do j = 1, h%y%nhist
            do k = 1, h%z%nhist
               h%dnw(i,j,k) = h1%dnw(i,j,k) + h2%dnw(i,j,k)
            enddo
         enddo
      enddo

      end
      subroutine kwhistp3( h, fno )
      implicit none
      include "Z90histCom.f"
c     ******************
      include "Z90histc.f"
      include "Z90hist3.f"
      type(histogram3) h

      integer fno
      
      if( BinWrite .eq. 1) then
         call kwhistpr3( h, fno )
      else
         call kwhistw3( h, fno )
      endif
      end

