      implicit none
c   Suppose  we have n hybrid data
c     h1, h2, h3, ....hn
c   1) cp h1 h0
c   2) h0 + h2 --> h; mv  h h0
c   3) h0 + h3 --> h; mv  h h0
c   ..
c   n) h0 + hn --> h; mv  h h0
c 
c   This program add two hybrid data; h0 + hx--> h
c            environmental variable
c   file h0: HYBFILE0
c   file hx: HYBFILEX
c   file h:  HYBFILET
c

      integer ndepth
      parameter (ndepth= 30)
      real*8  ASdep(ndepth),  muunit(ndepth), sumEsize
      real*8  Esize0(ndepth),
     *     age0(ndepth),  cogdep0(ndepth),
     *     SEloss0(ndepth),
     *     Ng0(ndepth), Ne0(ndepth), Nmu0(ndepth),
     *     cog0
      real*8  Esizex(ndepth),
     *     agex(ndepth),  cogdepx(ndepth),
     *     SElossx(ndepth), 
     *     Ngx(ndepth), Nex(ndepth), Nmux(ndepth),
     *     cogx

      real*8  Esizet(ndepth),
     *     aget(ndepth),  cogdept(ndepth),
     *     SElosst(ndepth),
     *     Ngt(ndepth), Net(ndepth), Nmut(ndepth),
     *     cogt
            
      integer EvNo0, EvNox
      integer fn0, fnx, fnt
      integer kgetenv2
      integer klena

      integer leng, i, j
      integer icon0, iconx, icont
      character*120 hyb0, hybx, hybt
      character*120 input0, inputx, inputt
      fn0 = 2
      fnx = 3
      fnt = 4
      leng = kgetenv2("HYBFILE0", hyb0)
      call copenfw2(fn0, hyb0, 1, icon0)
      if(icon0 .ne. 1)  then
         write(0,*) hyb0(1:leng)
         if( icon0 .eq. 0) then
            write(0,*) 'not exists'
         else
            write(0,*) ' cannot be opened '
         endif
         write(0,*) ' icon=',icon0
         stop 9999
      else
         write(0,*)  hyb0(1:leng), ' opened'
      endif
      leng = kgetenv2("HYBFILEX", hybx)
      call copenfw2(fnx, hybx, 1, iconx)
      if(iconx .ne. 1)  then
         write(0,*) hybx(1:leng)
         if( iconx .eq. 0) then
            write(0,*) 'not exists'
         else
            write(0,*) ' cannot be opened '
         endif
         write(0,*) ' icon=',iconx
         stop 9999
      else
         write(0,*)  hybx(1:leng), ' opened'
      endif

      
      leng = kgetenv2("HYBFILET", hybt)
      call copenfw2(fnt, hybt, 1, icont)
      if(icont .ne. 0)  then
         write(0,*) hybt(1:leng)
         write(0,*) ' cannot be opened '
         write(0,*) ' icon=',icont
         stop 9999
      else
         write(0,*)  hybt(1:leng), ' opened'
      endif
      

      i =0
      do while(.true.)
         input0 = ' '
         read( fn0, '(a)',  end=1000 ) input0
         inputx = ' '
         read( fnx, '(a)'  ) inputx 
         if(input0 .ne. " ") then
            read(input0(1:klena(input0)), *) 
     *      EvNo0, i, ASDep(i), Esize0(i), age0(i),
     *      cogdep0(i), SEloss0(i),
     *      muunit(i), Ng0(i), Ne0(i), Nmu0(i), cog0

            read(inputx(1:klena(inputx)), *) 
     *      EvNox, i, ASDep(i), Esizex(i), agex(i),
     *      cogdepx(i), SElossx(i),
     *      muunit(i), Ngx(i), Nex(i), Nmux(i), cogx
         else
c            1 event read
            if(inputx .ne. " ") then
               write(0,*) ' event differ', inputx
               stop 1111
            endif
            do j = 1, i
               Esizet(j) = Esize0(j) + Esizex(j)
               if(Esizet(j)  .gt. 0.) then
                  aget(j) = ( Esize0(j)*age0(j) + Esizex(j)*agex(j))/
     *               Esizet(j) 
               else
                  aget(j)= 0.
               endif
               SElosst(j) = SEloss0(j) + SElossx(j)
               Ngt(j) = Ng0(j) + Ngx(j)
               Net(j) = Ne0(j) + Nex(j)
               Nmut(j) = Nmu0(j) + Nmux(j)
            enddo
            cogt =0.
            sumEsize = 0. 
            do j =1, i
               cogt = cogt + ASdep(j)*Esizet(j)
               sumEsize = sumEsize +  Esizet(j)
            enddo
            cogt =  cogt / sumEsize
            do j=1, i
               cogdept(j) = ASdep(j)/cogt
            enddo
            do j = 1, i
               write(fnt, '( i4, i3, i5,
     *          g12.4, f5.2, f5.2, g12.4, f7.1, 3g10.3, f7.0)')
     *          EvNo0, j, int(ASDep(j)), Esizet(j), aget(j),
     *          cogdept(j), SElosst(j),
     *          muunit(j), Ngt(j), Net(j), Nmut(j), cogt
            enddo
            write(fnt, *) 
         endif
      enddo
 1000 continue
      write(0,*) 'all events processed '
      end


            
