      subroutine ciniQGS
      implicit none
#include "Zmanagerp.h"


      integerdebug      
      common /debug/   debug
      integer moniou
      common /qgarr43/ moniou

      logical  first
      save first
      integer iseq, j
      integer iseed(103,10)
      character*120 file1, file2
      real*8 u
      data first /.true./


      if( first ) then
         moniou = ErrorOut      !set output channel (6-default)
         call cqQGSfile(file1, file2)
         iseq=1                 !set random sequence&seed
         call rndc(u)
         iseed(1,iseq)=int(u*1.e7)
         call rndc(u)
         iseed(2,iseq)=int(u*1.e7)
         iseed(3,iseq)=0
         call rmmaq( iseed(1,iseq), iseq, 's' )
         call rmmaq( iseed(1,iseq), iseq, 'r' )
         write(moniou,*) iseq,(iseed(j,iseq),j=1,3)
         call qgset             !set model parameters
         debug=0                !set debugging level (1-default) 
         call qgaini            !initialize QGSJET-II
         first = .false.
      endif
      end
c     **********************************
      subroutine cqQGSfile(file1, file2)
c        check if data files exist for QGSJetII
      implicit none
      character*120  cosmostop
      character*(*) file1, file2
      integer kgetenv2, leng
      logical yes1, yes2 

      leng = kgetenv2("COSMOSTOP", cosmostop)
      file1= cosmostop(1:leng)//"/Data/QGS/qgsdat-II-1"
      inquire(file =file1, exist=yes1) 
      if(.not. yes1) then
         call cerrorMsg(file1, 1)
         call cerrorMsg("Data for QGS shown above is missing", 1)
      endif
      file2= cosmostop(1:leng)//"/Data/QGS/sectnu-II-1"
      inquire(file =file2, exist=yes2) 
      if(.not. yes2) then
         call cerrorMsg(file2, 1)
         call cerrorMsg("Data for QGS shown above is missing", 0)
         if(.not. yes1) stop  99999
      endif
      end

      subroutine cxsecQGS( pj, iat,   xs )
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
#include "Zmass.h"

      integer iapmax, nptmax, nsp, nsf, iaf, ich
      real*8  esp 
c      real*8  ep, ebal
c    ****************** important *****
c    if you increase iapmax, changes are also needed in qgsjet and
c    207 in Epics/prog/epixsec.f 
      parameter(iapmax=209,nptmax=50000)
c      dimension ep(4),ebal(4)
      common /qgarr12/ nsp                       !number of secondaries
      common /qgarr13/ nsf,iaf(iapmax)           !number of nuclear fragments,
      common /qgarr14/ esp(4,nptmax),ich(nptmax) !4-momenta and types of second.

      integer ntp    !  produced ptcls number
      record /ptcl/ a(*)  ! produced ptlcs' a(ntp)
c ------------------------
      record /ptcl/pj  ! input .projectile

      integer ic

      integer iat  !  input target mass number
      real*8  e0n  !  output E0/N (for Nuc) or E0 (for had)
      integer icz   ! output  1ry class
      integer iap   ! output projectile mass number. (1 for had)
      integer icp   ! output projectile QGS code  (2 for heavy)


      real*8  xs    ! output  xsection in mb  

      integer iz     ! input. charge no. of target

      integer isf, i, is
      integer zfrag, mfrag
c       following are to be kept inside
      real*8  ke0n, qgsect  
      integer kicz 
      integer kiap 
      integer kicp 
      integer kiat

      save ke0n, kicz, kiap, kicp, kiat


      if( pj.code .ne. kgnuc ) then
         kiap = 1                !set proj. mass number (1-for hadron)
      else
         kiap = pj.subcode
      endif
      call ccoscode2QGS( pj, kicp )

      ke0n = pj.fm.p(4)/kiap                     !to get energy per nucleon
      kiat = iat

      kicz=iabs(kicp)/2+1 !primary particle class (1- pion, 2 - nucleon, 3 - kaon)
      xs=qgsect(ke0n,kicz,kiap,kiat) !get particle production cross section

      return
c     *********************************
      entry cqQGSint( e0n, icz, iap, icp, iat )
c     *********************************
c        inquire current interacion conditions
c  
      e0n = ke0n
      icz = kicz
      iap = kiap
      icp = kicp
      iat = kiat
      return
c     ***********************************
      entry  cQGSjet(pj, iat, iz,  a, ntp)
c     ***********************************

c      ebal(1)=e0n*iap+.939d0*iat           
c      ebal(2)=dsqrt(e0n**2-.939d0**2)*iap
c      ebal(3)=0.d0
c      ebal(4)=0.d0
c      aknn=0.d0
c      ach=0.d0
c       call rmmaq( iseed(1,iseq), iseq, 'r' )    !get random seed

       kiat = iat  ! may not be the same as iat from cxsecqgs
       if(pj.code .eq. keta) then
c           at Ultra H.E, eta may collide.
          call chAcolAdhoc(pj, iat, iz, a, ntp)
       else
          call qgini( ke0n, kicp, kiap, iat) !initialize current interaction
          call qgconf           !inelastic interaction
c           next is projectile fragments
          ntp = 0
          do isf = 1, nsf       !loop over produced fragments
             mfrag = iaf(isf)   !fragment mass number
             zfrag = pj.charge*mfrag/kiap ! fragment charge
             ntp = ntp + 1
c                set this heavy in a
             call cmkptc(kgnuc, mfrag, zfrag, a(ntp))
             a(ntp).fm.p(4) = ke0n*mfrag
          enddo
c          set fragment Pt
          call csampFragMom( a, ntp )
          do  is = 1, nsp       !loop over produced particles
             ntp = ntp + 1
             ic=ich(is)    
             call cQGScode2cos(ic, a(ntp))
             do i=1,4
                a(ntp).fm.p(5-i)=esp(i,is) !particle 4-vector
             enddo 
c///////
c          write(0,*) ' sec;',ntp, ' code=',a(ntp).code,
c     *   ' chg=', a(ntp).charge, ' E=',a(ntp).fm.p(4), 
c     *    ' pz=',a(ntp).fm.p(3)
c/////
          enddo
       endif

c     -------------- rotate so that we get the same coordinate as pj
       call crot3mom( pj, a, ntp ) 
       if( pj.code .eq. kpion .and. pj.charge .eq. 0) then
c            pi0 is projectile.  we have been using pi+/- as
c            projectile so we wil replace the leading particle by pi+/pi-
c            kicp =1 is pi+/ kicp=-1 is pi- so we regard it as charge of pi
          call cfindHighestPi( kicp, a, ntp, i )
          if(i .gt.  0) then
             call cmkptc( kpion, 0, 0, a(i) )
          endif
       endif
      end


      subroutine ccoscode2QGS(pj, icp)
#include "Zptcl.h"
#include "Zcode.h"
      record /ptcl/ pj  ! input. cosmos ptcl 
      integer icp       ! output. code for qgsjet

      real*8 u
      character*80 msg

      if(pj.code  .eq. kpion) then
         if(pj.charge .eq.  -1) then
            icp = -1
         elseif( pj.charge .eq. 1) then
            icp = 1
         else
c            pi0, first assign it to pi+ pr pi- and later replace the leading ptcl
c            by pi0
            call rndc(u) 
            if(u .lt. 0.5) then
               icp =1
            else
               icp =-1
            endif
         endif
      elseif(pj.code .eq.  knuc ) then
         if(pj.charge .eq. 1 ) then
            icp = 2
         elseif( pj.charge .eq. -1) then
            icp = -2
         else
            if(pj.subcode .eq. antip ) then
               icp = -3
            else
               icp = 3
            endif
         endif
      elseif(pj.code .eq. kkaon) then
         if(pj.charge .eq. 1) then
            icp = 4
         elseif( pj.charge .eq. -1) then
            icp = -4
         else
            if(pj.subcode .eq. antip) then
               icp = -5
            else
               icp = 5
            endif
         endif
      elseif( pj.code .eq. kgnuc ) then
         icp = 2
      else
         write(msg,
     *   '("ptcl code=",i3," charge=",i3,"not supported in QGSII")') 
     *    pj.code, pj.charge
         call cerrorMsg(msg, 0)
      endif
c        set proj. type (-1 - pi^-, 1 - pi+,
c       -2 - p~, 2 - p, -3 - n~, 3 - n, -4 - k^-, 4 - k+, -5 - k0~, 5 - k0)
      end
      subroutine cQGScode2cos(icp, pj)
      implicit none
#include "Zptcl.h"
#include "Zcode.h"
      integer icp    ! input qgs code
      record /ptcl/ pj  ! output.  cosmos ptcl to get code

      integer  code, subcode, charge 

      character*80 msg

      if(icp .eq. -1) then
         code = kpion
         charge = -1
      elseif(icp .eq. 1) then
         code = kpion
         charge = 1
      elseif(icp .eq. 0 ) then
         code = kpion
         charge = 0
      elseif(icp .eq.  2 ) then
         code = knuc
         charge = 1
      elseif(icp .eq. -2) then
         code = knuc
         charge = -1
      elseif(icp .eq. 3) then
         code = knuc
         charge = 0
         subcode = regptcl
      elseif(icp .eq. -3) then
         code = knuc
         charge = 0
         subcode = antip
      elseif( icp .eq. 4 ) then
         code = kkaon
         charge = 1
      elseif( icp .eq. -4) then
         code  = kkaon
         charge = -1
      elseif( icp .eq. 5 )  then
         code = kkaon
         charge = 0
         subcode = k0s
      elseif( icp .eq. -5) then
         code = kkaon
         charge = 0
         subcode = k0l
      elseif( abs(icp) .eq.  6) then
         code = keta
         charge = 0
      elseif( icp .eq. -10 ) then
         code = klambda
         subcode = antip
         charge = 0
      elseif( icp .eq.  10 ) then
         code = klambda
         subcode = regptcl
         charge = 0 
      else
         write(msg,
     *   '("ptcl code from QGSII =",i3," is unknown")') 
     *    icp
         call cerrorMsg(msg, 0)
      endif
c          ((0 - pi0, -1 - pi^-, 1 - pi+,-2 - p~, 2 - p, -3 - n~, 3 - n,
c         -4 - k^-, 4 - k+, -5 - k0l, 5 - k0s, 6 - eta, -10 - lambda~, 10 - lambda)
      call cmkptc(code, subcode, charge, pj)
      end

      subroutine cfindHighestPi(chg, a, ntp, n)
c           find highest enrgy Pi+ (if chg =1)  of  Pi- (if chg=-1)
c     and return its index n
      implicit none
#include "Zcode.h"
#include "Zptcl.h"
      integer chg  !  input   incident is +  / or -
      integer ntp  ! input  total number of ptcls
      record /ptcl/ a(ntp)  ! input
      integer n   ! output  n-th ptcl is highest energy if 0, no ptcl

      integer i
      real*8 erg

      n = 0
      erg = 0.
      do i = 1, ntp
         if( a(i).code .eq. kpion ) then
            if( a(i).charge .eq. chg ) then
               if( erg .lt. a(i).fm.p(4) ) then
                  erg = a(i).fm.p(4)
                  n = i
               endif
            endif
         endif
      enddo
      end

      
      
