c      gamma-p hadron production xsection.
c
c      implicit none
c      real*8 ecm, xs
c      integer i
c              test cgpxs0 and cgpxs1
c         ecm=.15
c         do i=1,  70
c           call cgpxs1(ecm, xs)
c           write(*, *) sngl(ecm), sngl(xs)
c           ecm=ecm*10.**.1
c        enddo
c        end
c        ***********************************************************
c        *
c        * cgpxs0:  gamma-proton x-section for cm energy
c        * cgpxs1:  gamma-proton x-section for lab Eg energy
c        *
c        *********************** tested 88.07.12 ***************k.k*
c /usage/  call cgpxs0(ecm, xs)
c          call cgpxs1(eg, xs)
c
c   ecm: input. real*8. g-p cm energy in GeV (ecm>1.07)
c    eg: input. real*8. g energy in GeV in lab system. (eg>0.145)
c    xs: output. real*8. crossection in milibarn
c
        subroutine cgpxs0(ecm,xs)
        implicit none
        real*8 ecm, xs, eg
c
        integer ncm, jcon, l, i
c
           parameter (ncm=24)
           real*8  xs0(ncm), ecma(ncm), ega(ncm)
c
           data ecma/1.073, 1.1, 1.15,
     *      1.2, 1.22, 1.28, 1.30, 1.32, 1.37, 1.40,
     *      1.45, 1.50, 1.55, 1.60, 1.64, 1.70, 1.75, 1.80,
     *      2.0, 2.5, 3.0, 5.0, 10., 20./
        data (ega(i),i=   1,  24)/
     1  0.145,  0.176,  0.236,  0.299,  0.324,  0.404,  0.432,  0.460,
     2  0.531,  0.576,  0.652,  0.730,  0.812,  0.896,  0.965,  1.072,
     3  1.163,  1.258,  1.663,  2.863,  4.328, 12.857, 52.836,212.751/
           data xs0/0., .12, .29,
     *     .52, .528, .50, .40, .20, .175, .18,
     *     .22, .28, .24, .21, .20, .22, .18, .14, .14, .135,
     *     .13, .115, .11, .12/
c
           if(ecm .ge. 20.) then
               xs=(1.+log(ecm/20.)*.18)*.12
           elseif(ecm .gt. 1.073) then
               call kfrge(ecma, 1, ncm, ecm, l, jcon)
               if(jcon .eq. 0) then
                   xs= (xs0(l)-xs0(l-1))/(ecma(l)-ecma(l-1)) *
     *                 (ecm - ecma(l)) + xs0(l)
               else
                  call cerrorMsg(' error in cgpxs0 ', 0)
               endif
           else
               xs=0.
           endif
           return
c     *********************
      entry cgpxs1(eg, xs)
c     *********************
           if(eg .ge. 212.)then
               xs=(1.+log(eg/212.75)*.09)*.12
           elseif(eg .gt. .145)  then
               call kfrge(ega,  1, ncm, eg,  l, jcon)
               if(jcon .eq. 0) then
                   xs= (xs0(l)-xs0(l-1))/(ega(l)-ega(l-1)) *
     *                 (eg - ega(l)) + xs0(l)
               else
                  call cerrorMsg(' error in cgpxs1',0)
               endif
           else
               xs=0.
           endif
      end
cc          These are x-sections near threshold. 
c       implicit none
c       real*8 e, eg, xs
c
cc           to test cgppi0, cgppip, cgppi2, cgppi3
c       do  e=2.2, 3.7, .02
c          eg = 10.**e/1000.
c          call cgppi0(e, xs)
c          write(*, *) eg, xs
c       enddo
c       write(*, *)
c       do e=2.2, 3.7, .02
c          eg = 10.**e/1000.
c          call cgppip(e, xs)
c          write(*, *) eg, xs
c       enddo
c       write(*, *)
c       do e=2.2, 3.7, .02
c          eg = 10.**e/1000.
c          call cgppi2(e, xs)
c          write(*, *) eg, xs
c       enddo        
c       write(*, *)
c       do  e=2.2, 3.7, .02
c          eg = 10.**e/1000.
c          call cgppi3(e,  xs)
c          write(*, *) eg, xs
c       enddo
c       end
        subroutine cgppi0(egl10, xs)
c        egl10: input. log10(Eg/MeV)
c           xs: output. xsection in micro-barn for gp-->p+pi0
        implicit none
        real*8  xs, egl10
        integer i
        real*8 xs1(107), xs2(100), xs3(109), xs4(92)
c            log10(Eg/MeV) range step 0.01
      real*8  e11/2.2328224/,   e12/3.2981243/, eps/1./
      real*8  e21/2.3053560/,  e22/3.2981243/
      real*8 e31/2.6146288/,  e32/3.7040262/
      real*8 e41/2.8246450/

c
c            gp-->ppi0
       data ( xs1(i),i=   1,  72)/
     1    0.0,    2.4,    5.8,    8.9,   11.6,   12.8,   13.6,   14.4,
     2   17.2,   20.9,   25.3,   30.3,   35.9,   42.4,   48.5,   53.4,
     3   60.9,   71.8,   85.8,  120.9,  150.4,  204.4,  224.5,  241.6,
     4  251.3,  252.4,  248.9,  233.7,  210.9,  196.1,  186.7,  170.5,
     5  155.6,  145.1,  140.3,  134.9,  124.5,  111.0,  100.6,   91.3,
     6   86.8,   77.9,   66.8,   55.4,   46.5,   41.0,   40.0,   39.5,
     7   40.0,   40.4,   40.8,   41.2,   41.6,   42.0,   42.8,   41.7,
     8   40.3,   38.8,   37.3,   35.5,   34.2,   33.5,   32.7,   32.8,
     9   32.4,   32.0,   31.6,   31.2,   30.6,   30.0,   29.7,   28.9/
       data ( xs1(i),i=  73, 107)/
     1   27.9,   26.7,   25.3,   23.4,   21.8,   20.3,   18.8,   16.8,
     2   15.4,   14.2,   13.2,   12.3,   11.9,   11.2,   10.5,    9.8,
     3    9.0,    8.0,    7.3,    6.8,    6.2,    5.7,    5.3,    4.8,
     4    4.8,    4.7,    4.7,    4.7,    4.5,    4.1,    4.0,    2.5,
     5    1.2,    0.7,    0.7/
c

c            gp-->npi+
      data ( xs2(i),i=   1,  72)/
     1    0.0,   59.9,   82.4,  105.5,  127.1,  147.2,  160.8,  166.5,
     2  175.5,  185.1,  191.6,  194.8,  197.7,  200.1,  201.8,  203.0,
     3  203.2,  203.4,  202.3,  198.6,  195.0,  193.8,  190.1,  159.7,
     4  152.0,  143.0,  130.8,  119.4,  109.8,  101.7,   92.2,   81.5,
     5   73.8,   67.7,   64.9,   61.5,   58.4,   56.5,   56.5,   59.2,
     6   62.0,   64.1,   68.6,   76.9,   84.7,   90.1,   93.4,   96.1,
     7   97.6,   98.0,   97.3,   97.0,   96.0,   94.7,   93.0,   91.0,
     8   88.8,   86.4,   83.6,   80.6,   78.0,   74.3,   69.7,   63.7,
     9   58.1,   52.8,   47.4,   43.3,   41.2,   38.2,   35.0,   31.2/
      data ( xs2(i),i=  73, 100)/
     1   28.3,   25.7,   23.6,   22.1,   20.5,   19.1,   18.5,   17.3,
     2   16.0,   14.6,   12.8,   11.6,   10.6,    9.8,    9.2,    8.7,
     3    8.7,    8.7,    8.6,    8.6,    8.2,    7.5,    6.9,    6.2,
     4    5.7,    4.6,    3.2,    1.3/
c
c          gp-->ppi+pi-
      data ( xs3(i),i=   1,  72)/
     1    0.0,    0.7,    3.0,    5.7,    8.9,   12.9,   16.6,   21.1,
     2   23.0,   30.9,   44.3,   50.9,   57.5,   63.4,   67.4,   69.9,
     3   70.7,   71.3,   72.6,   72.4,   72.4,   71.6,   70.3,   68.5,
     4   67.4,   66.4,   65.3,   64.3,   63.3,   62.3,   61.2,   60.2,
     5   59.1,   58.0,   56.9,   55.8,   54.8,   53.8,   52.9,   51.9,
     6   51.0,   50.0,   49.4,   48.4,   47.4,   46.4,   45.4,   44.3,
     7   43.2,   42.2,   40.7,   39.6,   38.5,   37.5,   36.4,   35.4,
     8   34.4,   33.4,   32.4,   31.4,   30.4,   29.4,   28.5,   27.6,
     9   26.7,   25.8,   24.9,   24.0,   22.3,   21.5,   20.7,   20.1/
      data ( xs3(i),i=  73, 109)/
     1   19.5,   19.1,   19.2,   19.3,   19.4,   19.9,   19.6,   19.7,
     2   19.8,   20.0,   19.8,   19.7,   19.1,   18.8,   18.5,   18.3,
     3   18.0,   17.8,   17.6,   17.1,   16.9,   16.8,   16.7,   16.9,
     4   17.1,   17.4,   17.8,   18.2,   18.8,   19.4,   20.4,   21.1,
     5   21.8,   22.4,   23.0,   23.5,   23.9/
c

c                          e42/3.7369471/
c          gp-->ppi+pi- x (x=pi+,pi-,,,)
      data ( xs4(i),i=   1,  72)/
     1    0.0,    2.6,    5.6,    8.7,   11.8,   14.9,   18.1,   21.2,
     2   24.4,   28.2,   31.1,   34.0,   36.7,   39.2,   41.6,   43.9,
     3   45.9,   48.0,   50.1,   52.0,   53.9,   55.6,   57.3,   58.4,
     4   60.0,   61.6,   63.2,   64.7,   66.2,   67.6,   68.8,   70.2,
     5   71.6,   73.0,   74.4,   75.8,   77.2,   77.9,   79.3,   80.7,
     6   82.3,   84.0,   85.9,   87.8,   89.9,   93.2,   95.4,   97.4,
     7   99.3,  101.2,  103.0,  104.6,  106.7,  108.0,  109.2,  109.9,
     8  110.3,  111.7,  112.0,  112.3,  111.9,  112.3,  112.3,  112.0,
     9  111.6,  110.9,  110.1,  109.2,  108.2,  107.0,  105.7,  104.0/
      data ( xs4(i),i=  73,  92)/
     1  102.5,  100.9,   99.3,   97.6,   95.7,   93.9,   92.1,   90.3,
     2   88.5,   86.1,   84.4,   82.8,   81.4,   81.1,   80.3,   79.1,
     3   77.7,   75.9,   73.9,   71.6/
c
        goto 10
c     **********************
      entry cgppip(egl10, xs)
c     **********************
        goto 20
c     **********************
      entry cgppi2(egl10, xs)
c     **********************
        goto 30
c     **********************
      entry cgppi3(egl10, xs)
c     **********************
        goto 40
c

   10 continue
        if(egl10 .lt. e11) then
           xs=0.
        elseif(egl10 .lt. e12) then
           call kintp3(xs1, 1, 107, e11, 0.01d0, egl10, xs)
        else
           xs=0.
        endif
        return
c
   20   continue
        if(egl10 .lt. e21) then
           xs=0.
        elseif(egl10 .lt. e22) then
           call kintp3(xs2, 1, 100, e21, 0.01d0, egl10, xs)
        else
           xs=0.
        endif
        return
c
   30   continue
        if(egl10 .lt. e31) then
           xs=0.
        elseif(egl10 .lt. e32) then
           call kintp3(xs3, 1, 109, e31, 0.01d0, egl10, xs)
        else
           xs=0.
        endif
        return
c
   40   continue
        if(egl10 .lt. e41) then
           xs=0.
        else
           call kintp3(xs4, 1, 92, e41, 0.01d0, egl10, xs)
        endif
       end
