c
c      call kqsort(compf, idx, n)
c
c      kqsort is a quick sort routine for any data type in a 1 dimensional
c      array.  (data type may be real, integer, character, double precision
c      real or integer, half integer)
c      It can sort the data in ascending or descending order.
c      If you follow the instructions below, you will get ascending sort.
c
c      To use kqsort, you have to supply a simple integer function for each
c      array you want to sort.  The name is arbitrary, and must be like
c      
c      integer  compf
c      external compf
c      --------------------
c      integer  n
c      parameter (n = 10000)
c      real  x(n) 
c      common /abc/ x
c      ------------------- 
c      integer idx(n)
c       
c      x(*)  is computed somewhere
c      call kqsort(compf, idx, n)
c      Then, idx gets sorted order as (in default)
c      x(idx(1)) <= x(idx(2)) <= x(idx(3)).... <= x(idx(n))
c
c    ,,,
c      integer function compf(i, j)
c      integer i, j
c      --------------------
c      integer  n
c      parameter (n = 10000)
c      real  x(n) 
c      common /abc/ x
c      ------------------- 
c       if( x(i) .lt. x(j)) then
c          compf = -1     ! put  1 if you want descending sort
c       elseif( x(i) .gt.  x(j)) then
c          compf = 1      ! put -1 if you want descending sort
c       else
c          compf = 0
c       endif
c       end
c       *******************************************
c      If you want to have descending order, you may use
c      idx(n) to idx(1). However, this may lead to some confusion,
c      so you can get  descening sort directly. There are two method:
c      
c      1) After calling kqsort in a default manner, you may call
c            call ksortinv(idx, n)
c         Then, x(idx(1)) >= x(idx(2)) ... >= x(idx(n)) 
c      2) You may construct compf integer funtcion as shown by the
c         comment in the above example (reverse the sing of the function
c         value).
c
c      You may worry about the overhead of calling ksortinv,
c      but the time for it can  be negligiblly small as compared with
c      kqsort itself.
c
c      If you sort a large array (say, size >10^6)
c      many times, it  may be  better to use
c      kqsortd, kqsortr, kqsoti, kqsorth or kqsortc depending on
c      double precision real, real, integer, half integer, character
c      data. These routines don't require additonal integer function
c      like compf. 
c           call kqsort?(x, idx, n)
c      The routies are for ascending order sort; if you
c      want descending sort, use ksortinv.  
c      ********************
c
ccc       test kqsort
c      implicit none
c      integer i, j 
c      
c      external dcompf, icompf, rcompf, ccompf
c      integer dcompf, icomf, rcompf, ccompf
c      real*8  u
c
c      integer n
c      parameter (n = 1000000)
c      real*8 a( n )
c      real   b( n ) 
c      integer c( n )
c      character*9  x( 10 )
c
c      common /zzz/ a, b, c
c      common /zzzc/ x
c
c      integer idx(n)
c
c      do i = 1, n
c         call rndc(u)
c         b(i) = u
c      enddo
c      call kqsort(rcompf, idx, n)
c      do i = 1, n/2
c         j =idx(i)
c         idx(i) = idx(n-i+1)
c         idx(n-i+1) = j
c      enddo
c                                              
c      do  i=1, 10
c         write(*,*) i, b(idx(i))
c      enddo
c      do i=n-10, n
c         write(*,*) i, b(idx(i))
c      enddo
c
c
c      end
c
c
c      integer function dcompf(i, j)
c      integer i, j
c      integer n
c      parameter (n = 1000000)
c      real*8 a( n )
c      real   b( n ) 
c      integer c( n )
c      character*9  x(  10 )
c      common /zzz/ a, b, c
c      common /zzzc/ x
c
c      
c      if(a(i) .lt. a(j)) then
c         dcompf = -1
c      elseif(a(i) .eq. a(j)) then
c         dcompf = 0
c      else
c         dcompf = 1
c      endif
c      end
c      integer function rcompf(i, j)
c      integer i, j
c      integer n
c      parameter (n = 1000000)
c      real*8 a( n )
c      real   b( n ) 
c      integer c( n )
c      character*9  x(  10 )
c      common /zzz/ a, b, c
c      common /zzzc/ x
c
c      
c      if(b(i) .lt. b(j)) then
c         rcompf = -1
c      elseif(b(i) .eq. b(j)) then
c         rcompf = 0
c      else
c         rcompf = 1
c      endif
c      end
c
c      integer function icompf(i, j)
c      integer i, j
c      integer n
c      parameter (n = 1000000)
c      real*8 a( n )
c      real   b( n ) 
c      integer c( n )
c      character*9  x(  10 )
c      common /zzz/ a, b, c
c      common /zzzc/ x
c
c      
c      if(c(i) .lt. c(j)) then
c         icompf = -1
c      elseif(c(i) .eq. c(j)) then
c         icompf = 0
c      else
c         icompf = 1
c      endif
c      end
c
c      integer function ccompf(i, j)
c      integer i, j
c      integer n
c      parameter (n = 1000000)
c      real*8 a( n )
c      real   b( n ) 
c      integer c( n )
c      character*9  x( 10 )
c      common /zzz/ a, b, c
c      common /zzzc/ x
c
c      
c      if(x(i) .lt. x(j)) then
c         ccompf = -1
c      elseif(x(i) .eq. x(j)) then
c         ccompf = 0
c      else
c         ccompf = 1
c      endif
c      end
c      
      SUBROUTINE kqsort(compf, ORD,N)
C
C==============SORTS THE ARRAY A(I),I=1,2,...,N BY PUTTING THE
C   ASCENDING ORDER VECTOR IN ORD.  THAT IS ASCENDING ORDERED A
C   IS A(ORD(I)),I=1,2,...,N; DESCENDING ORDER A IS A(ORD(N-I+1)),
C   I=1,2,...,N .  THIS SORT RUNS IN TIME PROPORTIONAL TO N LOG N .
C
C
C     ACM QUICKSORT - ALGORITHM #402 - IMPLEMENTED IN FORTRAN BY
C                                 WILLIAM H. VERITY
C                                 COMPUTATION CENTER
C                                 PENNSYLVANIA STATE UNIVERSITY
C                                 UNIVERSITY PARK, PA.  16802
C
      IMPLICIT INTEGER (A-Z)
C
      DIMENSION ORD(N),POPLST(2,20)
      external compf
cc      INTEGER X,XX,Z,ZZ,Y
cc      CHARACTER *(*) A(N)
C
      NDEEP=0
      U1=N
      L1=1
      DO 1  I=1,N
    1 ORD(I)=I
    2 IF (U1.GT.L1) GO TO 3
      RETURN
C
    3 L=L1
      U=U1
C
C PART
C
    4 P=L
      Q=U
      X=ORD(P)
      Z=ORD(Q)

c      IF (A(X).LE.A(Z)) GO TO 5
      if( compf(x, z) .le. 0 ) goto 5 
      Y=X
      X=Z
      Z=Y
      YP=ORD(P)
      ORD(P)=ORD(Q)
      ORD(Q)=YP
    5 IF (U-L.LE.1) GO TO 15
      XX=X
      IX=P
      ZZ=Z
      IZ=Q
C
C LEFT
C
    6 P=P+1
      IF (P.GE.Q) GO TO 7
      X=ORD(P)
c      IF (A(X).GE.A(XX)) GO TO 8
      if( compf(x, xx) .ge. 0) goto 8
      GO TO 6
    7 P=Q-1
      GO TO 13
C
C RIGHT
C
    8 Q=Q-1
      IF (Q.LE.P) GO TO 9
      Z=ORD(Q)
c      IF (A(Z).LE.A(ZZ)) GO TO 10
      if( compf(z, zz) .le. 0)   goto 10
      GO TO 8
    9 Q=P
      P=P-1
      Z=X
      X=ORD(P)
C
C DIST
C
c   10 IF (A(X).LE.A(Z)) GO TO 11
 10   IF ( compf(X, z) .le. 0) goto 11  
      Y=X
      X=Z
      Z=Y
      IP=ORD(P)
      ORD(P)=ORD(Q)
      ORD(Q)=IP
c   11 IF (A(X).LE.A(XX)) GO TO 12
   11 IF ( compf( x, xx) .le. 0) goto 12
      XX=X
      IX=P
c   12 IF (A(Z).GE.A(ZZ)) GO TO 6
   12 IF ( compf(z, zz) .ge. 0) goto 6
      ZZ=Z
      IZ=Q
      GO TO 6
C
C OUT
C
   13 CONTINUE
c      IF (.NOT.(P.NE.IX.AND.A(X).NE.A(XX))) GO TO 14
      IF (.NOT.(P.NE.IX.AND. compf(X, xx) .ne. 0) ) goto 14
      IP=ORD(P)
      ORD(P)=ORD(IX)
      ORD(IX)=IP
   14 CONTINUE
c      IF (.NOT.(Q.NE.IZ.AND.A(Z).NE.A(ZZ))) GO TO 15
      IF (.NOT.(Q.NE.IZ.AND. compf(z, zz) .ne. 0) ) goto 15
      IQ=ORD(Q)
      ORD(Q)=ORD(IZ)
      ORD(IZ)=IQ
   15 CONTINUE
      IF (U-Q.LE.P-L) GO TO 16
      L1=L
      U1=P-1
      L=Q+1
      GO TO 17
   16 U1=U
      L1=Q+1
      U=P-1
   17 CONTINUE
      IF (U1.LE.L1) GO TO 18
C
C START RECURSIVE CALL
C
      NDEEP=NDEEP+1
      POPLST(1,NDEEP)=U
      POPLST(2,NDEEP)=L
      GO TO 3
   18 IF (U.GT.L) GO TO 4
C
C POP BACK UP IN THE RECURSION LIST
C
      IF (NDEEP.EQ.0) GO TO 2
      U=POPLST(1,NDEEP)
      L=POPLST(2,NDEEP)
      NDEEP=NDEEP-1
      GO TO 18
C
C END SORT
C END QSORT
C
      END
