      subroutine xBgRun
      implicit none
#include "Zmanagerp.h"
#include "Ztrack.h"
#include "Ztrackv.h"
#include "Zcode.h"
#include "Zheavyp.h"
#include "Zobs.h"
#include "Zobsp.h"
#include "Zobsv.h"
      include "Zprivate.f"
      include "Zprivate2.f"

      save rspec, lossrspec, lossrspec2, respec
      save rzspec,  zfspec, rtspec1, rtspec2, ertspec1, ertspec2
      save erzspec,  rzfspec, rfspec, efspec, refspec

      integer id  ! input.  1 ==> aTrack is going out from
c                                 outer boundery.
c                           2 ==> reached at an observation level
c                           3 ==> reached at inner boundery.
      record /track/ aTrack

      record /track/ inci
      record /coord/ angle
      record /coord/ tetafai
      
      character*100 input
      real sr, dr, tempr
      integer i, j, icon
      integer ansites
      save ansites
      integer iij, code
      integer i1, i2, ic

      real*8 r, Eloss, rinmu, cosang
      real*8 dedt, rho, dist, disto
      real*8 wx, wy, wz, temp
      real   za
      real  de, Ek, f, molu
      real*8  cvh2den
      integer ldep
      integer binw
      character*20 evid(nsites)
      save evid
      real*8 cog, sumne,  obstimes
      character*2  kd(3)
      save obstimes

c       keep this interface so that the difference between
c       the one in ForTA/ is in the next line
c     ***********************
      include "interface2.f"
c     *********************
      do i = 1, nsites
         if(histdep(i) .gt. 0)  then
            ansites = i
         endif
      enddo

      call kwhistso( binw )  ! specify binary or ascii write of histogaram
                             !  1--> ascii  2--> binary

      r=rmin
      dr = 10.**bin 
      rbin(1) = 0.
      do i = 2, nrbin
         rbin(i) = r
         r = r* dr
      enddo

      return      
c    ******************
      entry ihist
c
c

c     histogram: instanciate
c         rspec (lateral):  
      if(tklat) then
         do i = 1, ansites
            do j = 1, 3         ! g,e,mu
               call kwhisti(rspec(j, i),
     *              rmin, bin, nrbin,  b'00011' )
            enddo
         enddo
      endif


c        elosrspec (energy loss lateral)  10m-10km log bin 0.1. e+mu, e,mu
c          
c       
      if(tkelosslat) then
         do i = 1, ansites
            do j = 1, 3         !   e, mu, e+mu
               call kwhisti( lossrspec(j, i),
     *          rmin, bin, nrbin, b'00011')
            enddo
c                e+mu in the central region
            call kwhisti( lossrspec2(i), 0., 0.1, 1,  b'00000')
         enddo   
      endif


c
      if(tkrespec) then
         do i = 1, ansites
            do j= 1, 2
               call kwhisti2( respec(j, i),
     *             0.01, 10., 13,  b'10011', 
     *           500.e-6, 0.1,  30,  b'00001')
            enddo
            
            call kwhisti2( respec(3, i),
     *            0.05, 10.,  8, b'10001', 
     *            0.1,  0.1,   21, b'00011' )
         enddo
      endif


      if(tkrzspec) then
         do i = 1, ansites
            do j= 1, 2
               call kwhisti2( rzspec(j, i),
     *           0.01,   10., 11,  b'10011', 
     *           0., 1.0, 20,  b'10000')
            enddo
            call kwhisti2(rzspec(3, i),
     *           0.1, 10., 9, b'10011', 
     *           0.,  1.0,   20,  b'10000' )  
         enddo
      endif         


      if(tkzfspec) then
         do i = 1, ansites
            do j= 1, 3
               call kwhisti2( zfspec(j, i),
     *              0.0,   1.0, 5,  b'10000', 
     *              -1.0, 1.0, 50,  b'10000')
            enddo
         enddo
      endif         


      if(tkrfspec) then
         do i = 1, ansites
            do j= 1, 3
               call kwhisti2( rfspec(j, i),
     *              1.0,  0.25, 12,  b'00011', 
     *              -1.0, 1.0, 50,    b'10000')
            enddo
         enddo
      endif         


      if(tkefspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhisti2( efspec(j, i),
     *              500.e-6,  0.2, 20,  b'00001', 
     *              -1.0,     1.0, 50,  b'10000')
            enddo
         enddo
      endif         

      if(tkrtspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhisti2( rtspec1(j, i),
     *              1.0, 10., 9, b'10011', 
     *              10.0,  0.1,  72, b'00011'  )
               call kwhisti2( rtspec2(j, i),
     *             0., 1.0, 5, b'10000', 
     *             0., 1.0, 200, b'00000' )
            enddo
         enddo
      endif


      
      if(tkertspec)  then
         do i = 1, ansites
            do j = 1, 2
c                  g,e
               call kwhisti3(ertspec1(j, i), 
     *          500.e-6, 0.3333333, 13, b'00001',
     *          1.0,  0.3333333,  8,  b'00011',
     *          10.0, 0.1,  72,    b'00011' )

               call kwhisti3(ertspec2(j, i), 
     *          500.e-6, 0.3333333, 13,  b'0001',
     *          0.0,  1.0,   5,  b'10000',
     *          0.0,  2.0,    50,  b'00000' )
            enddo
c               mu
            call kwhisti3(ertspec1(3, i), 
     *           100.e-3, 0.3333333, 7, b'00011',
     *           1.0,  0.3333333,   8, b'00011',
     *           10.0, 0.1,  72,        b'00011' )
            call kwhisti3(ertspec2(3, i), 
     *           100.e-3, 0.3333333, 7, b'00011',
     *           0.0,  1.0,     5,    b'10000',
     *           0.0,  2.0,     50,     b'00000' )
         enddo
      endif



      if(tkerzspec) then
         do i = 1, ansites
            do j = 1, 2
               call kwhisti3(erzspec(j, i), 
     *         500.e-6, 0.3333333, 7, b'00001',
     *         0.1, 0.3333333,  10,   b'00011',
     *         0.0, 1.0,       20,    b'10000')
            enddo
            call kwhisti3(erzspec(3, i), 
     *         100.e-3, 0.3333333, 7, b'00011',
     *         0.1, 0.3333333,  10,   b'00011',
     *         0.0, 1.0,        20,   b'10000')
         enddo
      endif



      if(tkrzfspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhisti3(rzfspec(j, i), 
     *         0.1, 0.3333333,  10,   b'00011',
     *         0.0, 1.0,         5,   b'10000',  
     *         -1.0, 1.0,       20,   b'10000')
            enddo
         enddo
      endif

      if(tkrefspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhisti3(refspec(j, i), 
     *         0.1, 10.,     10,   b'10011',
     *         500.e-6, 0.2,   20,   b'00001',  
     *         -1.0, 1.0,      20,   b'10000')
            enddo
         enddo
      endif

      return
c     *********************************** hook for Beginning of  1 event
c     *  All system-level initialization for 1 event generation has been
c     *  eneded at this moment.
c     *  After this is executed, event generation starts.
c     *
      entry xBgEvent


      call cqIncident(inci, angle)
      write(*,'("i ",  i3,  i4, g13.4,3f11.7)') EventNo, inci.p.code,
     *   inci.p.fm.e,  -angle.r(1),  -angle.r(2), -angle.r(3)      
c      
      do i = 1, NoOfASSites
         SumEloss(i) = 0.
         Ng(i) = 0.
         Ne(i) = 0.
         Nmu(i) = 0.
      enddo

      if(tklat) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc(rspec(j,i))
            enddo
         enddo
      endif

      if(tkelosslat) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc(lossrspec(j,i))
            enddo
            call kwhistc(lossrspec2(i))
         enddo
      endif


      if(tkrespec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(respec(j,i))
            enddo
         enddo
      endif


      if(tkrzspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(rzspec(j,i))
            enddo
         enddo
      endif

      if(tkrfspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(rfspec(j,i))
            enddo
         enddo
      endif



      if(tkefspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(efspec(j,i))
            enddo
         enddo
      endif




      if(tkrtspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc2(rtspec1(j,i))
               call kwhistc2(rtspec2(j,i))
            enddo
         enddo
      endif

         
      if(tkertspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc3(ertspec1(j,i))
               call kwhistc3(ertspec2(j,i))
            enddo
         enddo
      endif



      if(tkerzspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc3(erzspec(j,i))
            enddo
         enddo
      endif



      if(tkrzfspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc3(rzfspec(j,i))
            enddo
         enddo
      endif


      if(tkrefspec) then
         do i = 1, ansites
            do j = 1, 3
               call kwhistc3(refspec(j,i))
            enddo
         enddo
      endif

      obstimes = 0.

      return
c     ***************
      entry xObs(aTrack, id)
c
c     For id =2, you need not output the z value, because it is always
c     0 (within the computational accuracy).
c
c     **************************
      obstimes = obstimes + 1.d0
      if( mod(obstimes, 100000.d0) .eq. 0. ) then 
         write(0, *) ' obstime=', obstimes, ' ptclE=',aTrack.p.fm.p(4)
      endif
c     ***************
      code = aTrack.p.code

      if(id .eq. 2 .and. code .ne. 7 .and.  code .ne. 8 ) then
         wz = aTrack.vec.w.r(3)  ! downgoing < 0
         if(wz .gt. 0) return
         wz = -wz
         ldep =  aTrack.where
         r = sqrt( aTrack.pos.xyz.x**2 +
     *                 aTrack.pos.xyz.y**2 )

         Ek = aTrack.p.fm.p(4) -aTrack.p.mass

         if(code .eq. kphoton) then
            Ng(ldep) = Ng(ldep) + aTrack.wgt
         elseif(code .eq. kelec) then
            Ne(ldep) = Ne(ldep) + aTrack.wgt
         elseif(code .eq. kmuon) then
            Nmu(ldep) = Nmu(ldep) + aTrack.wgt
         endif

         do i = 1, ansites
            j = indivdep(i) 
            if( j .eq. ldep) then
               molu =ObsSites(j).mu
               rinmu =r/molu
               sr = rinmu

               if(  recxy ) then
                  write(*,'("p ", 4i4, g12.3, 3g12.3,  3f10.6 )')
     *                 ldep,  code,  aTrack.p.subcode,
     *                 aTrack.p.charge, aTrack.p.fm.e, 
     *                 aTrack.pos.xyz.x/molu,
     *                 aTrack.pos.xyz.y/molu,
     *                 aTrack.t, 
     *                 -sngl(aTrack.vec.w.r(1)),
     *                 -sngl(aTrack.vec.w.r(2)), wz
               else
                  write(*,'("p ", 4i4, g12.3, 2g12.3, f10.6 )')
     *                 ldep,  code,  aTrack.p.subcode,
     *                 aTrack.p.charge, aTrack.p.fm.e,
     *                 sr,
     *                 aTrack.t,   wz
               endif
               goto 25          !  break loop
            endif
         enddo
 25      continue
c            ---------- compute energy loss irrespec. of histdep
         if(aTrack.p.charge .ne. 0  ) then
            rho = cvh2den(aTrack.pos.height)
c         get energy loss when aTrack goes 1 g/cm2 along the
c         primary direction. Gramage the particle can run is
c         1/cos where cos is the cos of angle relative to the
c         primary angle . 1g/cm^2 = 10-3kg/10-4 m^2 =10 kg/m^2.
c         To travel  1 g/cm^2  along shower axis, the ptcl must
c         run dist kg/m^2
            disto =10./wz   ! in kg/m2
c                 to avoid too large dist due to very small zenith
c                 we limit the dist so that scattering deflection be
c                 smaller than 1 g/cm2. 
c             Since deflection in r.l ~ (Es/E) (dist/366)**(3/2).
c             i.e,   deflection in kg/m2 ~ 366(Es/E) (dist/366)**(3/2) < 10.
c                 
cc            if( wz  .lt. 0.5) then
cc               dist = min(disto, 
cc     *         366.0d0*(10.0d0/366.0d0*Ek/21.d-3)**0.666d0 )                    
cc            else
               dist = disto
cc            endif
            call cqElossRate(dedt) !  loss rate GeV/(kg/m^2)
c                       energy loss  in dist
            Eloss = dedt*dist

c                     see if this is > K.E
            if(Eloss .gt. Ek ) then
               Eloss = Ek
               dist = Eloss/dedt
            endif
            SumEloss(ldep)=SumEloss(ldep) + Eloss
         endif
c            ------------------
               
c          see if 'where' is specified for histogram
         do i = 1, ansites
            if( histdep(i) .eq. ldep )  then
               j = ldep
c                  
               molu = ObsSites(ldep).mu
               rinmu = r/molu
               sr = rinmu
               if( tklat .and. code .le. 3) then
c                    lateral
                  call kwhist(rspec(code, i), sr, 1.0 )
               endif
               if( tkelosslat 
     *           .and. aTrack.p.charge .ne. 0 ) then

cc                  dist = dist/rho !   in m
cc                  wx = aTrack.vec.w.r(1)
cc                  wy = aTrack.vec.w.r(2)
cc                  call crbinPortion(rinmu, 
cc     *                 aTrack.pos.xyz.x/molu, aTrack.pos.xyz.y/molu,
cc     *                 dist, wx, wy, wz, rbin, 
cc     *                 nrbin,  deportion, i1, i2)
c//////////////////
c                  if(i1 .ne.  i2) then
c                     write(0,*) ' r, dist, wz', r, dist, wz, i1, i2
c                     sum = 0. 
c                     do ic = i1, i2
c                        sum = sum +  deportion(ic)
c                        write(0,*) deportion(ic), sum
c                     enddo
c                  endif
c///////////////
c      real*8  r  !  input.  a value >= 0.
c      real*8  d  !  input.  length of the segment
c      real*8  wx, wy, wz  !  input.  direction cosines. wz>=0 is assumed.
c      integer n           !  input. bin size
c      real*8  rbin(n)     !  input. bin values. r(1)=0 is assumed.
c      real*8  portion(n)  !  output.
c      integer i1, i2      !  output.
c                 
cc                  do ic = i1, i2
                       de = Eloss
cc                     de = deportion(ic)*Eloss
cc                     if(ic .eq. i1) then
                         tempr = sr
cc                     elseif(ic .lt. nrbin) then
cc                        tempr =( rbin(ic) + rbin(ic+1))/2/ObsSites(j).mu
cc                     else
cc                        tempr = rbin(ic)/ObsSites(j).mu
cc                     endif
c                       by   all charged particles
                     call kwhist(lossrspec(3,i), tempr, de)
                     call kwhist(lossrspec2(i), tempr, de)
                     if( aTrack.p.code .eq.  kelec ) then
c                          by electrons
                        call kwhist(lossrspec(1,i), tempr, de)
                     else
c                          by other charged particles
                        call kwhist(lossrspec(2,i), tempr, de)
                     endif
cc                  enddo
               endif          
c                  end of eloss late


               if( tkrespec .and. code .le. 3 ) then
c                  re spectrum
                  call kwhist2( respec(code, i), sr, Ek, 1.0)
               endif


               if( tkrzspec ) then
                  call kwhist2( rzspec(code, i), sr, 
     *                 sngl(wz), 1.0 )
               endif


               if( wz .lt. 1.0d0 ) then
                  temp = 1.d0 - wz**2
                  if(temp .gt. 0.) then
                     temp = sqrt(temp)
                     f = (
     *                  aTrack.pos.xyz.x* aTrack.vec.w.r(1) +
     *                  aTrack.pos.xyz.y* aTrack.vec.w.r(2) ) /r
     *                  /temp             
                  else
                     f = 1.0
                  endif
               else
                  f = 1.0
               endif
               if( tkzfspec .and. f .lt. 1.0 ) then
                  call kwhist2( zfspec(code, i), 
     *              sngl(wz), f, 1.0 )
               endif


               if( tkefspec .and. f .lt. 1.0 ) then
                  call kwhist2( efspec(code, i), 
     *              Ek, f, 1.0 )
               endif

               if( tkrfspec .and. f .lt. 1.0 ) then
                  call kwhist2( rfspec(code, i), 
     *              sr, f, 1.0 )
               endif

               if( tkrtspec .and. code .le. 3) then
                  call kwhist2( rtspec1(code, i), sr, 
     *              sngl( aTrack.t ), 1.0)
                  call kwhist2( rtspec2(code, i), sr, 
     *              sngl( aTrack.t ), 1.0)
               endif

               if(tkertspec .and. code .le. 3) then
                  call kwhist3( ertspec1(code, i), Ek, sr,
     *                 sngl( aTrack.t ), 1.0)
                  call kwhist3( ertspec2(code, i), Ek, sr,
     *                 sngl( aTrack.t ), 1.0)
               endif

               if( tkerzspec .and. code .le. 3 ) then
                  call kwhist3( erzspec(code,i), Ek, sr,
     *              sngl(wz),  1.0 ) 
               endif

               if( tkrzfspec .and. code .le. 3) then
                  call kwhist3( rzfspec(code, i),  sr, 
     *                 sngl(wz), f, 1.0)
               endif

               if( tkrefspec .and. code .le. 3) then
                  call kwhist3( refspec(code, i),  sr, 
     *                 Ek, f, 1.0)
               endif

               goto 100
            endif
         enddo
 100     continue
      endif
      return
c     ********************
      entry xEnEvent


      if(ObserveAS) then
         cog = 0.
         sumne = 0.
         do i = 1, NoOfASSites
            cog = cog + ASObsSites(i).esize*ASDepthList(i)*0.1
            sumne= sumne +ASObsSites(i).esize
         enddo
         cog = cog/sumne

         do i = 1, NoOfASSites 
            if(fnoB .ge. 0) then
               write(fnoB, '( i4, i3, i5,
     *          g12.4, f5.2, f5.2, g12.4, f7.1, 3g10.3, f7.0)')
     *          EventNo, i,
     *          int( ASDepthList(i)*0.1 ),  
     *          sngl(ASObsSites(i).esize), sngl(ASObsSites(i).age),
     *          ASDepthList(i)*0.1/cog, SumEloss(i),  
     *          sngl(ASObsSites(i).mu), Ng(i), Ne(i), Nmu(i), cog
            else
               write(*, '( i4, i3, i5,
     *          g12.4, f5.2, f5.2, g12.4, f7.1, 3g10.3, f7.0)')
     *          EventNo, i,
     *          int( ASDepthList(i)*0.1 ),  
     *          sngl(ASObsSites(i).esize), sngl(ASObsSites(i).age),
     *          ASDepthList(i)*0.1/cog, SumEloss(i),  
     *          sngl(ASObsSites(i).mu), Ng(i), Ne(i), Nmu(i), cog
            endif
         enddo
      endif
      if(fnoB .ge.  0) then
         write(fnoB,*)
      else
         write(*,*)
      endif

      do i = 1, ansites
         write(evid(i), '(" # ",i4, i3, f5.2, f5.2)') 
     *   EventNo, histdep(i),
     *   ASObsSites(histdep(i)).age,
     *   ASDepthList(histdep(i))*0.1/cog
      enddo


      if( tklat ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists( rspec(j,i), 0. ) ! 0. means area norm.
               call kwhistid(rspec(j,i), evid(i)//kd(j)//' lat')
               call kwhistp( rspec(j,i),  fno)
            enddo
         enddo
      endif

      if(tkelosslat) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists( lossrspec(j,i), 0. ) ! area norm
            enddo
         enddo
       
         do i = 1, ansites
            call kwhistid( lossrspec(1, i), evid(i)//' e'//' dEr')
            call kwhistp( lossrspec(1, i), fno)
         enddo
         do i = 1, ansites
            call kwhistid( lossrspec(2, i), evid(i)//' m'//' dEr')
            call kwhistp( lossrspec(2, i),  fno)
         enddo
         do i = 1, ansites
            call kwhistid( lossrspec(3, i), evid(i)//' a'//' dEr')
            call kwhistp( lossrspec(3, i), fno)
         enddo
         do i = 1, ansites
            call kwhists( lossrspec2(i), 0. )
            call kwhistid( lossrspec2(i), evid(i)//' a'//' dEr2')
            call kwhistp( lossrspec2(i), fno)
         enddo
      endif
 120  continue
      
      if(tkrespec) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( respec(j, i), 0. )
               call kwhistid2( respec(j, i), evid(i)//kd(j)//' re')
               call kwhistp2( respec(j, i),  fno)
            enddo
         enddo
      endif


      if( tkrzspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( rzspec(j, i), 0.)
               call kwhistid2( rzspec(j, i),  evid(i)//kd(j)//' rz')
               call kwhistp2( rzspec(j, i),  fno)
            enddo
         enddo
      endif

      
      if( tkzfspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( zfspec(j, i), 0.)
               call kwhistid2( zfspec(j, i), evid(i)//kd(j)//' zf')
               call kwhistp2( zfspec(j, i),  fno)
            enddo
         enddo
      endif


      
      if( tkrfspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( rfspec(j, i), 0.)
               call kwhistid2( rfspec(j, i), evid(i)//kd(j)//' rf')
               call kwhistp2( rfspec(j, i),  fno)
            enddo
         enddo
      endif

      
      if( tkefspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( efspec(j, i), 0.)
               call kwhistid2( efspec(j, i), evid(i)//kd(j)//' ef')
               call kwhistp2( efspec(j, i),  fno)
            enddo
         enddo
      endif


      if( tkrtspec ) then
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( rtspec1(j,i), 0.)
               call kwhistid2( rtspec1(j,i), evid(i)//kd(j)//' rt')
               call kwhistp2( rtspec1(j,i),  fno)
            enddo
         enddo
         do j = 1, 3
            do i = 1, ansites
               call kwhists2( rtspec2(j,i), 0.)
               call kwhistid2( rtspec2(j,i), evid(i)//kd(j)//' rt2')
               call kwhistp2( rtspec2(j,i),  fno)
            enddo
         enddo
      endif


      if(tkertspec ) then
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( ertspec1(j, i), 0.)
               call kwhistid3( ertspec1(j, i), evid(i)//kd(j)//' ert')
               call kwhistp3( ertspec1(j, i), fno)
            enddo
         enddo
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( ertspec2(j, i), 0.)
               call kwhistid3( ertspec2(j, i), evid(i)//kd(j)//' ert2')
               call kwhistp3( ertspec2(j, i), fno)
            enddo
         enddo
      endif


      if( tkerzspec ) then
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( erzspec(j, i), 0.)
               call kwhistid3( erzspec(j, i), evid(i)//kd(j)//' erz')
               call kwhistp3( erzspec(j, i),  fno)
            enddo
         enddo
      endif


      if( tkrzfspec ) then
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( rzfspec(j, i), 0.)
               call kwhistid3( rzfspec(j, i), evid(i)//kd(j)//' rzf')
               call kwhistp3( rzfspec(j, i),  fno)
            enddo
         enddo
      endif


      if( tkrefspec ) then
         do j = 1, 3
            do  i = 1, ansites
               call kwhists3( refspec(j, i), 0.)
               call kwhistid3( refspec(j, i), evid(i)//kd(j)//' ref')
               call kwhistp3( refspec(j, i),  fno)
            enddo
         enddo
      endif


      end
