c       include 'rnd.f'
c--------------------------------
cc           to test sampling from the negative binomial dist.
c       implicit none
c       real*8 k, aven
c       integer  n, i
c       aven = 10.
c       k = 1.5 
c       do i=1,10000
c           call knbino(k, aven, n)
c           write(*, *) float(n), float(n)/sngl(aven)
c       enddo
c      end
       subroutine knbino(k, avn, n)
c         samples n from the negative binomial distrubtion of
c         p(n)= (n+k-1)] / n]/(k-1)] ( a/(1+a) )** n / (1+a)**k
c         where a=avn/k.   k should be real*8
c         this is for unfixed k and avn.  If either or both of them are
c         fixed, user anothr method for faster sampling.
c
       implicit none
       real*8 k, avn
       integer n
c
       real*8 a, pn, ar, u, sum
       integer  nmax
c
        a=avn/k
        pn= 1.d0/(1.d0+a)**k
        ar=a/(1.d0+a)
        call rndc(u)
        sum=pn
        nmax=avn*15.d0
        n=0
        do   while (sum .lt. u .and. n .lt. nmax)
            n=n+1
            pn= pn* (n+k-1)/n * ar
            sum=sum+pn
        enddo
       end
